#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C trie:gen-code-function-filenames
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L gen-code-function-filenames.old <(echo \
'$ test -x ../lib/test-trie
$ print() { printf '\''%s\n'\'' "$@"; }
$ set -o pipefail
$ ../lib/test-trie -G --no-expanded-path < filenames.txt
    if (prefix("c++py-tree-demo/", p)) {
        p += 16;
        switch (*p ++) {
        case '\''.'\'':
            if (prefix("src-", p)) {
                p += 4;
                switch (*p ++) {
                case '\''d'\'':
                    if (equal(p, "irs"))
                        return "c++py-tree-demo/.src-dirs";
                    return NULL;
                case '\''f'\'':
                    if (equal(p, "iles"))
                        return "c++py-tree-demo/.src-files";
                }
            }
            return NULL;
        case '\''b'\'':
            if (equal(p, "in.patch"))
                return "c++py-tree-demo/bin.patch";
            return NULL;
        case '\''c'\'':
            if (prefix("++py", p)) {
                p += 4;
                switch (*p ++) {
                case '\''-'\'':
                    if (prefix("tree", p)) {
                        p += 4;
                        switch (*p ++) {
                        case '\''-'\'':
                            switch (*p ++) {
                            case '\''a'\'':
                                if (equal(p, "uthor.txt"))
                                    return "c++py-tree-demo/c++py-tree-author.txt";
                                return NULL;
                            case '\''d'\'':
                                if (equal(p, "emo.txt"))
                                    return "c++py-tree-demo/c++py-tree-demo.txt";
                                return NULL;
                            case '\''r'\'':
                                if (prefix("eadme.", p)) {
                                    p += 6;
                                    switch (*p ++) {
                                    case '\''p'\'':
                                        if (equal(p, "df"))
                                            return "c++py-tree-demo/c++py-tree-readme.pdf";
                                        return NULL;
                                    case '\''t'\'':
                                        switch (*p ++) {
                                        case '\''e'\'':
                                            if (*p ++ == '\''x'\'' &&
                                                *p == 0)
                                                return "c++py-tree-demo/c++py-tree-readme.tex";
                                            return NULL;
                                        case '\''x'\'':
                                            if (*p ++ == '\''t'\'' &&
                                                *p == 0)
                                                return "c++py-tree-demo/c++py-tree-readme.txt";
                                        }
                                    }
                                }
                            }
                            return NULL;
                        case '\''.'\'':
                            switch (*p ++) {
                            case '\''p'\'':
                                if (equal(p, "df"))
                                    return "c++py-tree-demo/c++py-tree.pdf";
                                return NULL;
                            case '\''t'\'':
                                switch (*p ++) {
                                case '\''e'\'':
                                    if (*p ++ == '\''x'\'' &&
                                        *p == 0)
                                        return "c++py-tree-demo/c++py-tree.tex";
                                    return NULL;
                                case '\''x'\'':
                                    if (*p ++ == '\''t'\'' &&
                                        *p == 0)
                                        return "c++py-tree-demo/c++py-tree.txt";
                                }
                            }
                        }
                    }
                    return NULL;
                case '\''/'\'':
                    switch (*p ++) {
                    case '\''.'\'':
                        if (prefix("src-", p)) {
                            p += 4;
                            switch (*p ++) {
                            case '\''d'\'':
                                if (equal(p, "irs"))
                                    return "c++py-tree-demo/c++py/.src-dirs";
                                return NULL;
                            case '\''f'\'':
                                if (equal(p, "iles"))
                                    return "c++py-tree-demo/c++py/.src-files";
                            }
                        }
                        return NULL;
                    case '\''A'\'':
                        if (equal(p, "UTHOR"))
                            return "c++py-tree-demo/c++py/AUTHOR";
                        return NULL;
                    case '\''M'\'':
                        if (equal(p, "akefile"))
                            return "c++py-tree-demo/c++py/Makefile";
                        return NULL;
                    case '\''R'\'':
                        if (equal(p, "EADME"))
                            return "c++py-tree-demo/c++py/README";
                    }
                }
            }
        }
    }
    return NULL;'
) -L gen-code-function-filenames.new <(
echo '$ test -x ../lib/test-trie'
test -x ../lib/test-trie 2>&1 ||
echo 'command failed: test -x ../lib/test-trie'

echo '$ print() { printf '\''%s\n'\'' "$@"; }'
print() { printf '%s\n' "$@"; } 2>&1 ||
echo 'command failed: print() { printf '\''%s\n'\'' "$@"; }'

echo '$ set -o pipefail'
set -o pipefail 2>&1 ||
echo 'command failed: set -o pipefail'

echo '$ ../lib/test-trie -G --no-expanded-path < filenames.txt'
../lib/test-trie -G --no-expanded-path < filenames.txt 2>&1 ||
echo 'command failed: ../lib/test-trie -G --no-expanded-path < filenames.txt'
)

