#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C parser:string-utf8-2
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L string-utf8-2.old <(echo \
'$ json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }
$ json() { json0 --literal-value --no-validate-utf8 --parse "$@"; }
$ echo -e '\''"\xc0\x80"'\''|json
$ echo -e '\''"\xc0\xae"'\''|json
$ echo -e '\''"\xc1\x81"'\''|json
$ echo -e '\''"\x41\xe2\x89\xa2\xce\x91\x2e"'\''|json'
) -L string-utf8-2.new <(
echo '$ json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }'
json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; } 2>&1 ||
echo 'command failed: json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }'

echo '$ json() { json0 --literal-value --no-validate-utf8 --parse "$@"; }'
json() { json0 --literal-value --no-validate-utf8 --parse "$@"; } 2>&1 ||
echo 'command failed: json() { json0 --literal-value --no-validate-utf8 --parse "$@"; }'

echo '$ echo -e '\''"\xc0\x80"'\''|json'
echo -e '"\xc0\x80"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xc0\x80"'\''|json'

echo '$ echo -e '\''"\xc0\xae"'\''|json'
echo -e '"\xc0\xae"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xc0\xae"'\''|json'

echo '$ echo -e '\''"\xc1\x81"'\''|json'
echo -e '"\xc1\x81"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xc1\x81"'\''|json'

echo '$ echo -e '\''"\x41\xe2\x89\xa2\xce\x91\x2e"'\''|json'
echo -e '"\x41\xe2\x89\xa2\xce\x91\x2e"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\x41\xe2\x89\xa2\xce\x91\x2e"'\''|json'
)

