#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C parser:number
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L number.old <(echo \
'$ json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }
$ json() { json0 --literal-value "$@"; }
$ echo 0|json -b 1
0
$ echo 0|json -b 2
0
$ echo 0|json -b 3
0
$ echo 1|json -b 1
1
$ echo 1|json -b 2
1
$ echo 1|json -b 3
1
$ echo 2|json -b 1
2
$ echo 2|json -b 2
2
$ echo 2|json -b 3
2
$ echo 3|json -b 1
3
$ echo 3|json -b 2
3
$ echo 3|json -b 3
3
$ echo 4|json -b 1
4
$ echo 4|json -b 2
4
$ echo 4|json -b 3
4
$ echo 5|json -b 1
5
$ echo 5|json -b 2
5
$ echo 5|json -b 3
5
$ echo 6|json -b 1
6
$ echo 6|json -b 2
6
$ echo 6|json -b 3
6
$ echo 7|json -b 1
7
$ echo 7|json -b 2
7
$ echo 7|json -b 3
7
$ echo 8|json -b 1
8
$ echo 8|json -b 2
8
$ echo 8|json -b 3
8
$ echo 9|json -b 1
9
$ echo 9|json -b 2
9
$ echo 9|json -b 3
9'
) -L number.new <(
echo '$ json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }'
json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; } 2>&1 ||
echo 'command failed: json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }'

echo '$ json() { json0 --literal-value "$@"; }'
json() { json0 --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { json0 --literal-value "$@"; }'

echo '$ echo 0|json -b 1'
echo 0|json -b 1 2>&1 ||
echo 'command failed: echo 0|json -b 1'

echo '$ echo 0|json -b 2'
echo 0|json -b 2 2>&1 ||
echo 'command failed: echo 0|json -b 2'

echo '$ echo 0|json -b 3'
echo 0|json -b 3 2>&1 ||
echo 'command failed: echo 0|json -b 3'

echo '$ echo 1|json -b 1'
echo 1|json -b 1 2>&1 ||
echo 'command failed: echo 1|json -b 1'

echo '$ echo 1|json -b 2'
echo 1|json -b 2 2>&1 ||
echo 'command failed: echo 1|json -b 2'

echo '$ echo 1|json -b 3'
echo 1|json -b 3 2>&1 ||
echo 'command failed: echo 1|json -b 3'

echo '$ echo 2|json -b 1'
echo 2|json -b 1 2>&1 ||
echo 'command failed: echo 2|json -b 1'

echo '$ echo 2|json -b 2'
echo 2|json -b 2 2>&1 ||
echo 'command failed: echo 2|json -b 2'

echo '$ echo 2|json -b 3'
echo 2|json -b 3 2>&1 ||
echo 'command failed: echo 2|json -b 3'

echo '$ echo 3|json -b 1'
echo 3|json -b 1 2>&1 ||
echo 'command failed: echo 3|json -b 1'

echo '$ echo 3|json -b 2'
echo 3|json -b 2 2>&1 ||
echo 'command failed: echo 3|json -b 2'

echo '$ echo 3|json -b 3'
echo 3|json -b 3 2>&1 ||
echo 'command failed: echo 3|json -b 3'

echo '$ echo 4|json -b 1'
echo 4|json -b 1 2>&1 ||
echo 'command failed: echo 4|json -b 1'

echo '$ echo 4|json -b 2'
echo 4|json -b 2 2>&1 ||
echo 'command failed: echo 4|json -b 2'

echo '$ echo 4|json -b 3'
echo 4|json -b 3 2>&1 ||
echo 'command failed: echo 4|json -b 3'

echo '$ echo 5|json -b 1'
echo 5|json -b 1 2>&1 ||
echo 'command failed: echo 5|json -b 1'

echo '$ echo 5|json -b 2'
echo 5|json -b 2 2>&1 ||
echo 'command failed: echo 5|json -b 2'

echo '$ echo 5|json -b 3'
echo 5|json -b 3 2>&1 ||
echo 'command failed: echo 5|json -b 3'

echo '$ echo 6|json -b 1'
echo 6|json -b 1 2>&1 ||
echo 'command failed: echo 6|json -b 1'

echo '$ echo 6|json -b 2'
echo 6|json -b 2 2>&1 ||
echo 'command failed: echo 6|json -b 2'

echo '$ echo 6|json -b 3'
echo 6|json -b 3 2>&1 ||
echo 'command failed: echo 6|json -b 3'

echo '$ echo 7|json -b 1'
echo 7|json -b 1 2>&1 ||
echo 'command failed: echo 7|json -b 1'

echo '$ echo 7|json -b 2'
echo 7|json -b 2 2>&1 ||
echo 'command failed: echo 7|json -b 2'

echo '$ echo 7|json -b 3'
echo 7|json -b 3 2>&1 ||
echo 'command failed: echo 7|json -b 3'

echo '$ echo 8|json -b 1'
echo 8|json -b 1 2>&1 ||
echo 'command failed: echo 8|json -b 1'

echo '$ echo 8|json -b 2'
echo 8|json -b 2 2>&1 ||
echo 'command failed: echo 8|json -b 2'

echo '$ echo 8|json -b 3'
echo 8|json -b 3 2>&1 ||
echo 'command failed: echo 8|json -b 3'

echo '$ echo 9|json -b 1'
echo 9|json -b 1 2>&1 ||
echo 'command failed: echo 9|json -b 1'

echo '$ echo 9|json -b 2'
echo 9|json -b 2 2>&1 ||
echo 'command failed: echo 9|json -b 2'

echo '$ echo 9|json -b 3'
echo 9|json -b 3 2>&1 ||
echo 'command failed: echo 9|json -b 3'
)

