#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -p litex -C lib:empty-str
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L empty-str.old <(echo \
'$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"
$ json-litex() { set -o pipefail && LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value -VF -- ../lib/json-litex.so -A "$@"|sed -r '\''s/"size":[0-9]+,"bytes":\["[0-9a-f]+"(,"[0-9a-f]+")*\]//;s/("lookup":"0x)[0-9a-f]+(")/\1...\2/g'\''|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }
$ json-litex -d '\''""'\''
json: error: <text>:1:1: filter library: attribute error: invalid string: is empty
json: error: <text>:1:1: ""
json: error: <text>:1:1: ^
command failed: json-litex -d '\''""'\''
$ json-litex -d '\''{"foo":""}'\''
json: error: <text>:1:8: filter library: attribute error: invalid string: is empty
json: error: <text>:1:8: {"foo":""}
json: error: <text>:1:8:        ^
command failed: json-litex -d '\''{"foo":""}'\''
$ json-litex -d '\''[""]'\''
json: error: <text>:1:2: filter library: attribute error: invalid string: is empty
json: error: <text>:1:2: [""]
json: error: <text>:1:2:  ^
command failed: json-litex -d '\''[""]'\''
$ json-litex -d '\''{"bar":{"foo":""}}'\''
json: error: <text>:1:15: filter library: attribute error: invalid string: is empty
json: error: <text>:1:15: {"bar":{"foo":""}}
json: error: <text>:1:15:               ^
command failed: json-litex -d '\''{"bar":{"foo":""}}'\''
$ json-litex -d '\''{"bar":[""]}'\''
json: error: <text>:1:9: filter library: attribute error: invalid string: is empty
json: error: <text>:1:9: {"bar":[""]}
json: error: <text>:1:9:         ^
command failed: json-litex -d '\''{"bar":[""]}'\''
$ json-litex -d '\''[{"foo":""}]'\''
json: error: <text>:1:9: filter library: attribute error: invalid string: is empty
json: error: <text>:1:9: [{"foo":""}]
json: error: <text>:1:9:         ^
command failed: json-litex -d '\''[{"foo":""}]'\''
$ json-litex -d '\''{"baz":{"bar":{"foo":""}}}'\''
json: error: <text>:1:22: filter library: attribute error: invalid string: is empty
json: error: <text>:1:22: {"baz":{"bar":{"foo":""}}}
json: error: <text>:1:22:                      ^
command failed: json-litex -d '\''{"baz":{"bar":{"foo":""}}}'\''
$ json-litex -d '\''{"baz":{"bar":[""]}}'\''
json: error: <text>:1:16: filter library: attribute error: invalid string: is empty
json: error: <text>:1:16: {"baz":{"bar":[""]}}
json: error: <text>:1:16:                ^
command failed: json-litex -d '\''{"baz":{"bar":[""]}}'\''
$ json-litex -d '\''{"baz":[{"foo":""}]}'\''
json: error: <text>:1:16: filter library: attribute error: invalid string: is empty
json: error: <text>:1:16: {"baz":[{"foo":""}]}
json: error: <text>:1:16:                ^
command failed: json-litex -d '\''{"baz":[{"foo":""}]}'\''
$ json-litex -d '\''[{"bar":{"foo":""}}]'\''
json: error: <text>:1:16: filter library: attribute error: invalid string: is empty
json: error: <text>:1:16: [{"bar":{"foo":""}}]
json: error: <text>:1:16:                ^
command failed: json-litex -d '\''[{"bar":{"foo":""}}]'\''
$ json-litex -d '\''[{"bar":[""]}]'\''
json: error: <text>:1:10: filter library: attribute error: invalid string: is empty
json: error: <text>:1:10: [{"bar":[""]}]
json: error: <text>:1:10:          ^
command failed: json-litex -d '\''[{"bar":[""]}]'\'''
) -L empty-str.new <(
echo '$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'
[ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib" 2>&1 ||
echo 'command failed: [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'

echo '$ json-litex() { set -o pipefail && LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value -VF -- ../lib/json-litex.so -A "$@"|sed -r '\''s/"size":[0-9]+,"bytes":\["[0-9a-f]+"(,"[0-9a-f]+")*\]//;s/("lookup":"0x)[0-9a-f]+(")/\1...\2/g'\''|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }'
json-litex() { set -o pipefail && LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value -VF -- ../lib/json-litex.so -A "$@"|sed -r 's/"size":[0-9]+,"bytes":\["[0-9a-f]+"(,"[0-9a-f]+")*\]//;s/("lookup":"0x)[0-9a-f]+(")/\1...\2/g'|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; } 2>&1 ||
echo 'command failed: json-litex() { set -o pipefail && LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value -VF -- ../lib/json-litex.so -A "$@"|sed -r '\''s/"size":[0-9]+,"bytes":\["[0-9a-f]+"(,"[0-9a-f]+")*\]//;s/("lookup":"0x)[0-9a-f]+(")/\1...\2/g'\''|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }'

echo '$ json-litex -d '\''""'\'''
json-litex -d '""' 2>&1 ||
echo 'command failed: json-litex -d '\''""'\'''

echo '$ json-litex -d '\''{"foo":""}'\'''
json-litex -d '{"foo":""}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"foo":""}'\'''

echo '$ json-litex -d '\''[""]'\'''
json-litex -d '[""]' 2>&1 ||
echo 'command failed: json-litex -d '\''[""]'\'''

echo '$ json-litex -d '\''{"bar":{"foo":""}}'\'''
json-litex -d '{"bar":{"foo":""}}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"bar":{"foo":""}}'\'''

echo '$ json-litex -d '\''{"bar":[""]}'\'''
json-litex -d '{"bar":[""]}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"bar":[""]}'\'''

echo '$ json-litex -d '\''[{"foo":""}]'\'''
json-litex -d '[{"foo":""}]' 2>&1 ||
echo 'command failed: json-litex -d '\''[{"foo":""}]'\'''

echo '$ json-litex -d '\''{"baz":{"bar":{"foo":""}}}'\'''
json-litex -d '{"baz":{"bar":{"foo":""}}}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"baz":{"bar":{"foo":""}}}'\'''

echo '$ json-litex -d '\''{"baz":{"bar":[""]}}'\'''
json-litex -d '{"baz":{"bar":[""]}}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"baz":{"bar":[""]}}'\'''

echo '$ json-litex -d '\''{"baz":[{"foo":""}]}'\'''
json-litex -d '{"baz":[{"foo":""}]}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"baz":[{"foo":""}]}'\'''

echo '$ json-litex -d '\''[{"bar":{"foo":""}}]'\'''
json-litex -d '[{"bar":{"foo":""}}]' 2>&1 ||
echo 'command failed: json-litex -d '\''[{"bar":{"foo":""}}]'\'''

echo '$ json-litex -d '\''[{"bar":[""]}]'\'''
json-litex -d '[{"bar":[""]}]' 2>&1 ||
echo 'command failed: json-litex -d '\''[{"bar":[""]}]'\'''
)

