#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -p litex -C expr:builtins2
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L builtins2.old <(echo \
'$ shopt -s expand_aliases
$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"
$ test-expr() { LD_LIBRARY_PATH="$JSON_LITEX_TEST_PCRE2_LIB" ../lib/test-expr "$@" -vb default -E; }
$ test-expr -e '\''int(8)'\'' -l -129
0
$ test-expr -e '\''int(8)'\'' -l '\''"-129"'\''
0
$ test-expr -e '\''int(16)'\'' -l -129
1
$ test-expr -e '\''int(16)'\'' -l '\''"-129"'\''
1
$ test-expr -e '\''int(32)'\'' -l -129
1
$ test-expr -e '\''int(32)'\'' -l '\''"-129"'\''
1
$ test-expr -e '\''int(64)'\'' -l -129
1
$ test-expr -e '\''int(64)'\'' -l '\''"-129"'\''
1
$ test-expr -e '\''uint(8)'\'' -l -129
0
$ test-expr -e '\''uint(8)'\'' -l '\''"-129"'\''
0
$ test-expr -e '\''uint(16)'\'' -l -129
0
$ test-expr -e '\''uint(16)'\'' -l '\''"-129"'\''
0
$ test-expr -e '\''uint(32)'\'' -l -129
0
$ test-expr -e '\''uint(32)'\'' -l '\''"-129"'\''
0
$ test-expr -e '\''uint(64)'\'' -l -129
0
$ test-expr -e '\''uint(64)'\'' -l '\''"-129"'\''
0
$ test-expr -e '\''int(8)'\'' -l -128
1
$ test-expr -e '\''int(8)'\'' -l '\''"-128"'\''
1
$ test-expr -e '\''int(16)'\'' -l -128
1
$ test-expr -e '\''int(16)'\'' -l '\''"-128"'\''
1
$ test-expr -e '\''int(32)'\'' -l -128
1
$ test-expr -e '\''int(32)'\'' -l '\''"-128"'\''
1
$ test-expr -e '\''int(64)'\'' -l -128
1
$ test-expr -e '\''int(64)'\'' -l '\''"-128"'\''
1
$ test-expr -e '\''uint(8)'\'' -l -128
0
$ test-expr -e '\''uint(8)'\'' -l '\''"-128"'\''
0
$ test-expr -e '\''uint(16)'\'' -l -128
0
$ test-expr -e '\''uint(16)'\'' -l '\''"-128"'\''
0
$ test-expr -e '\''uint(32)'\'' -l -128
0
$ test-expr -e '\''uint(32)'\'' -l '\''"-128"'\''
0
$ test-expr -e '\''uint(64)'\'' -l -128
0
$ test-expr -e '\''uint(64)'\'' -l '\''"-128"'\''
0
$ test-expr -e '\''int(8)'\'' -l -127
1
$ test-expr -e '\''int(8)'\'' -l '\''"-127"'\''
1
$ test-expr -e '\''int(16)'\'' -l -127
1
$ test-expr -e '\''int(16)'\'' -l '\''"-127"'\''
1
$ test-expr -e '\''int(32)'\'' -l -127
1
$ test-expr -e '\''int(32)'\'' -l '\''"-127"'\''
1
$ test-expr -e '\''int(64)'\'' -l -127
1
$ test-expr -e '\''int(64)'\'' -l '\''"-127"'\''
1
$ test-expr -e '\''uint(8)'\'' -l -127
0
$ test-expr -e '\''uint(8)'\'' -l '\''"-127"'\''
0
$ test-expr -e '\''uint(16)'\'' -l -127
0
$ test-expr -e '\''uint(16)'\'' -l '\''"-127"'\''
0
$ test-expr -e '\''uint(32)'\'' -l -127
0
$ test-expr -e '\''uint(32)'\'' -l '\''"-127"'\''
0
$ test-expr -e '\''uint(64)'\'' -l -127
0
$ test-expr -e '\''uint(64)'\'' -l '\''"-127"'\''
0
$ test-expr -e '\''int(8)'\'' -l 126
1
$ test-expr -e '\''int(8)'\'' -l '\''"126"'\''
1
$ test-expr -e '\''int(16)'\'' -l 126
1
$ test-expr -e '\''int(16)'\'' -l '\''"126"'\''
1
$ test-expr -e '\''int(32)'\'' -l 126
1
$ test-expr -e '\''int(32)'\'' -l '\''"126"'\''
1
$ test-expr -e '\''int(64)'\'' -l 126
1
$ test-expr -e '\''int(64)'\'' -l '\''"126"'\''
1
$ test-expr -e '\''uint(8)'\'' -l 126
1
$ test-expr -e '\''uint(8)'\'' -l '\''"126"'\''
1
$ test-expr -e '\''uint(16)'\'' -l 126
1
$ test-expr -e '\''uint(16)'\'' -l '\''"126"'\''
1
$ test-expr -e '\''uint(32)'\'' -l 126
1
$ test-expr -e '\''uint(32)'\'' -l '\''"126"'\''
1
$ test-expr -e '\''uint(64)'\'' -l 126
1
$ test-expr -e '\''uint(64)'\'' -l '\''"126"'\''
1
$ test-expr -e '\''int(8)'\'' -l 127
1
$ test-expr -e '\''int(8)'\'' -l '\''"127"'\''
1
$ test-expr -e '\''int(16)'\'' -l 127
1
$ test-expr -e '\''int(16)'\'' -l '\''"127"'\''
1
$ test-expr -e '\''int(32)'\'' -l 127
1
$ test-expr -e '\''int(32)'\'' -l '\''"127"'\''
1
$ test-expr -e '\''int(64)'\'' -l 127
1
$ test-expr -e '\''int(64)'\'' -l '\''"127"'\''
1
$ test-expr -e '\''uint(8)'\'' -l 127
1
$ test-expr -e '\''uint(8)'\'' -l '\''"127"'\''
1
$ test-expr -e '\''uint(16)'\'' -l 127
1
$ test-expr -e '\''uint(16)'\'' -l '\''"127"'\''
1
$ test-expr -e '\''uint(32)'\'' -l 127
1
$ test-expr -e '\''uint(32)'\'' -l '\''"127"'\''
1
$ test-expr -e '\''uint(64)'\'' -l 127
1
$ test-expr -e '\''uint(64)'\'' -l '\''"127"'\''
1
$ test-expr -e '\''int(8)'\'' -l 128
0
$ test-expr -e '\''int(8)'\'' -l '\''"128"'\''
0
$ test-expr -e '\''int(16)'\'' -l 128
1
$ test-expr -e '\''int(16)'\'' -l '\''"128"'\''
1
$ test-expr -e '\''int(32)'\'' -l 128
1
$ test-expr -e '\''int(32)'\'' -l '\''"128"'\''
1
$ test-expr -e '\''int(64)'\'' -l 128
1
$ test-expr -e '\''int(64)'\'' -l '\''"128"'\''
1
$ test-expr -e '\''uint(8)'\'' -l 128
1
$ test-expr -e '\''uint(8)'\'' -l '\''"128"'\''
1
$ test-expr -e '\''uint(16)'\'' -l 128
1
$ test-expr -e '\''uint(16)'\'' -l '\''"128"'\''
1
$ test-expr -e '\''uint(32)'\'' -l 128
1
$ test-expr -e '\''uint(32)'\'' -l '\''"128"'\''
1
$ test-expr -e '\''uint(64)'\'' -l 128
1
$ test-expr -e '\''uint(64)'\'' -l '\''"128"'\''
1
$ test-expr -e '\''int(8)'\'' -l -32769
0
$ test-expr -e '\''int(8)'\'' -l '\''"-32769"'\''
0
$ test-expr -e '\''int(16)'\'' -l -32769
0
$ test-expr -e '\''int(16)'\'' -l '\''"-32769"'\''
0
$ test-expr -e '\''int(32)'\'' -l -32769
1
$ test-expr -e '\''int(32)'\'' -l '\''"-32769"'\''
1
$ test-expr -e '\''int(64)'\'' -l -32769
1
$ test-expr -e '\''int(64)'\'' -l '\''"-32769"'\''
1
$ test-expr -e '\''uint(8)'\'' -l -32769
0
$ test-expr -e '\''uint(8)'\'' -l '\''"-32769"'\''
0
$ test-expr -e '\''uint(16)'\'' -l -32769
0
$ test-expr -e '\''uint(16)'\'' -l '\''"-32769"'\''
0
$ test-expr -e '\''uint(32)'\'' -l -32769
0
$ test-expr -e '\''uint(32)'\'' -l '\''"-32769"'\''
0
$ test-expr -e '\''uint(64)'\'' -l -32769
0
$ test-expr -e '\''uint(64)'\'' -l '\''"-32769"'\''
0
$ test-expr -e '\''int(8)'\'' -l -32768
0
$ test-expr -e '\''int(8)'\'' -l '\''"-32768"'\''
0
$ test-expr -e '\''int(16)'\'' -l -32768
1
$ test-expr -e '\''int(16)'\'' -l '\''"-32768"'\''
1
$ test-expr -e '\''int(32)'\'' -l -32768
1
$ test-expr -e '\''int(32)'\'' -l '\''"-32768"'\''
1
$ test-expr -e '\''int(64)'\'' -l -32768
1
$ test-expr -e '\''int(64)'\'' -l '\''"-32768"'\''
1
$ test-expr -e '\''uint(8)'\'' -l -32768
0
$ test-expr -e '\''uint(8)'\'' -l '\''"-32768"'\''
0
$ test-expr -e '\''uint(16)'\'' -l -32768
0
$ test-expr -e '\''uint(16)'\'' -l '\''"-32768"'\''
0
$ test-expr -e '\''uint(32)'\'' -l -32768
0
$ test-expr -e '\''uint(32)'\'' -l '\''"-32768"'\''
0
$ test-expr -e '\''uint(64)'\'' -l -32768
0
$ test-expr -e '\''uint(64)'\'' -l '\''"-32768"'\''
0
$ test-expr -e '\''int(8)'\'' -l -32767
0
$ test-expr -e '\''int(8)'\'' -l '\''"-32767"'\''
0
$ test-expr -e '\''int(16)'\'' -l -32767
1
$ test-expr -e '\''int(16)'\'' -l '\''"-32767"'\''
1
$ test-expr -e '\''int(32)'\'' -l -32767
1
$ test-expr -e '\''int(32)'\'' -l '\''"-32767"'\''
1
$ test-expr -e '\''int(64)'\'' -l -32767
1
$ test-expr -e '\''int(64)'\'' -l '\''"-32767"'\''
1
$ test-expr -e '\''uint(8)'\'' -l -32767
0
$ test-expr -e '\''uint(8)'\'' -l '\''"-32767"'\''
0
$ test-expr -e '\''uint(16)'\'' -l -32767
0
$ test-expr -e '\''uint(16)'\'' -l '\''"-32767"'\''
0
$ test-expr -e '\''uint(32)'\'' -l -32767
0
$ test-expr -e '\''uint(32)'\'' -l '\''"-32767"'\''
0
$ test-expr -e '\''uint(64)'\'' -l -32767
0
$ test-expr -e '\''uint(64)'\'' -l '\''"-32767"'\''
0
$ test-expr -e '\''int(8)'\'' -l 32766
0
$ test-expr -e '\''int(8)'\'' -l '\''"32766"'\''
0
$ test-expr -e '\''int(16)'\'' -l 32766
1
$ test-expr -e '\''int(16)'\'' -l '\''"32766"'\''
1
$ test-expr -e '\''int(32)'\'' -l 32766
1
$ test-expr -e '\''int(32)'\'' -l '\''"32766"'\''
1
$ test-expr -e '\''int(64)'\'' -l 32766
1
$ test-expr -e '\''int(64)'\'' -l '\''"32766"'\''
1
$ test-expr -e '\''uint(8)'\'' -l 32766
0
$ test-expr -e '\''uint(8)'\'' -l '\''"32766"'\''
0
$ test-expr -e '\''uint(16)'\'' -l 32766
1
$ test-expr -e '\''uint(16)'\'' -l '\''"32766"'\''
1
$ test-expr -e '\''uint(32)'\'' -l 32766
1
$ test-expr -e '\''uint(32)'\'' -l '\''"32766"'\''
1
$ test-expr -e '\''uint(64)'\'' -l 32766
1
$ test-expr -e '\''uint(64)'\'' -l '\''"32766"'\''
1
$ test-expr -e '\''int(8)'\'' -l 32767
0
$ test-expr -e '\''int(8)'\'' -l '\''"32767"'\''
0
$ test-expr -e '\''int(16)'\'' -l 32767
1
$ test-expr -e '\''int(16)'\'' -l '\''"32767"'\''
1
$ test-expr -e '\''int(32)'\'' -l 32767
1
$ test-expr -e '\''int(32)'\'' -l '\''"32767"'\''
1
$ test-expr -e '\''int(64)'\'' -l 32767
1
$ test-expr -e '\''int(64)'\'' -l '\''"32767"'\''
1
$ test-expr -e '\''uint(8)'\'' -l 32767
0
$ test-expr -e '\''uint(8)'\'' -l '\''"32767"'\''
0
$ test-expr -e '\''uint(16)'\'' -l 32767
1
$ test-expr -e '\''uint(16)'\'' -l '\''"32767"'\''
1
$ test-expr -e '\''uint(32)'\'' -l 32767
1
$ test-expr -e '\''uint(32)'\'' -l '\''"32767"'\''
1
$ test-expr -e '\''uint(64)'\'' -l 32767
1
$ test-expr -e '\''uint(64)'\'' -l '\''"32767"'\''
1
$ test-expr -e '\''int(8)'\'' -l 32768
0
$ test-expr -e '\''int(8)'\'' -l '\''"32768"'\''
0
$ test-expr -e '\''int(16)'\'' -l 32768
0
$ test-expr -e '\''int(16)'\'' -l '\''"32768"'\''
0
$ test-expr -e '\''int(32)'\'' -l 32768
1
$ test-expr -e '\''int(32)'\'' -l '\''"32768"'\''
1
$ test-expr -e '\''int(64)'\'' -l 32768
1
$ test-expr -e '\''int(64)'\'' -l '\''"32768"'\''
1
$ test-expr -e '\''uint(8)'\'' -l 32768
0
$ test-expr -e '\''uint(8)'\'' -l '\''"32768"'\''
0
$ test-expr -e '\''uint(16)'\'' -l 32768
1
$ test-expr -e '\''uint(16)'\'' -l '\''"32768"'\''
1
$ test-expr -e '\''uint(32)'\'' -l 32768
1
$ test-expr -e '\''uint(32)'\'' -l '\''"32768"'\''
1
$ test-expr -e '\''uint(64)'\'' -l 32768
1
$ test-expr -e '\''uint(64)'\'' -l '\''"32768"'\''
1
$ test-expr -e '\''int(8)'\'' -l -2147483649
0
$ test-expr -e '\''int(8)'\'' -l '\''"-2147483649"'\''
0
$ test-expr -e '\''int(16)'\'' -l -2147483649
0
$ test-expr -e '\''int(16)'\'' -l '\''"-2147483649"'\''
0
$ test-expr -e '\''int(32)'\'' -l -2147483649
0
$ test-expr -e '\''int(32)'\'' -l '\''"-2147483649"'\''
0
$ test-expr -e '\''int(64)'\'' -l -2147483649
1
$ test-expr -e '\''int(64)'\'' -l '\''"-2147483649"'\''
1
$ test-expr -e '\''uint(8)'\'' -l -2147483649
0
$ test-expr -e '\''uint(8)'\'' -l '\''"-2147483649"'\''
0
$ test-expr -e '\''uint(16)'\'' -l -2147483649
0
$ test-expr -e '\''uint(16)'\'' -l '\''"-2147483649"'\''
0
$ test-expr -e '\''uint(32)'\'' -l -2147483649
0
$ test-expr -e '\''uint(32)'\'' -l '\''"-2147483649"'\''
0
$ test-expr -e '\''uint(64)'\'' -l -2147483649
0
$ test-expr -e '\''uint(64)'\'' -l '\''"-2147483649"'\''
0
$ test-expr -e '\''int(8)'\'' -l -2147483648
0
$ test-expr -e '\''int(8)'\'' -l '\''"-2147483648"'\''
0
$ test-expr -e '\''int(16)'\'' -l -2147483648
0
$ test-expr -e '\''int(16)'\'' -l '\''"-2147483648"'\''
0
$ test-expr -e '\''int(32)'\'' -l -2147483648
1
$ test-expr -e '\''int(32)'\'' -l '\''"-2147483648"'\''
1
$ test-expr -e '\''int(64)'\'' -l -2147483648
1
$ test-expr -e '\''int(64)'\'' -l '\''"-2147483648"'\''
1
$ test-expr -e '\''uint(8)'\'' -l -2147483648
0
$ test-expr -e '\''uint(8)'\'' -l '\''"-2147483648"'\''
0
$ test-expr -e '\''uint(16)'\'' -l -2147483648
0
$ test-expr -e '\''uint(16)'\'' -l '\''"-2147483648"'\''
0
$ test-expr -e '\''uint(32)'\'' -l -2147483648
0
$ test-expr -e '\''uint(32)'\'' -l '\''"-2147483648"'\''
0
$ test-expr -e '\''uint(64)'\'' -l -2147483648
0
$ test-expr -e '\''uint(64)'\'' -l '\''"-2147483648"'\''
0
$ test-expr -e '\''int(8)'\'' -l -2147483647
0
$ test-expr -e '\''int(8)'\'' -l '\''"-2147483647"'\''
0
$ test-expr -e '\''int(16)'\'' -l -2147483647
0
$ test-expr -e '\''int(16)'\'' -l '\''"-2147483647"'\''
0
$ test-expr -e '\''int(32)'\'' -l -2147483647
1
$ test-expr -e '\''int(32)'\'' -l '\''"-2147483647"'\''
1
$ test-expr -e '\''int(64)'\'' -l -2147483647
1
$ test-expr -e '\''int(64)'\'' -l '\''"-2147483647"'\''
1
$ test-expr -e '\''uint(8)'\'' -l -2147483647
0
$ test-expr -e '\''uint(8)'\'' -l '\''"-2147483647"'\''
0
$ test-expr -e '\''uint(16)'\'' -l -2147483647
0
$ test-expr -e '\''uint(16)'\'' -l '\''"-2147483647"'\''
0
$ test-expr -e '\''uint(32)'\'' -l -2147483647
0
$ test-expr -e '\''uint(32)'\'' -l '\''"-2147483647"'\''
0
$ test-expr -e '\''uint(64)'\'' -l -2147483647
0
$ test-expr -e '\''uint(64)'\'' -l '\''"-2147483647"'\''
0
$ test-expr -e '\''int(8)'\'' -l 2147483646
0
$ test-expr -e '\''int(8)'\'' -l '\''"2147483646"'\''
0
$ test-expr -e '\''int(16)'\'' -l 2147483646
0
$ test-expr -e '\''int(16)'\'' -l '\''"2147483646"'\''
0
$ test-expr -e '\''int(32)'\'' -l 2147483646
1
$ test-expr -e '\''int(32)'\'' -l '\''"2147483646"'\''
1
$ test-expr -e '\''int(64)'\'' -l 2147483646
1
$ test-expr -e '\''int(64)'\'' -l '\''"2147483646"'\''
1
$ test-expr -e '\''uint(8)'\'' -l 2147483646
0
$ test-expr -e '\''uint(8)'\'' -l '\''"2147483646"'\''
0
$ test-expr -e '\''uint(16)'\'' -l 2147483646
0
$ test-expr -e '\''uint(16)'\'' -l '\''"2147483646"'\''
0
$ test-expr -e '\''uint(32)'\'' -l 2147483646
1
$ test-expr -e '\''uint(32)'\'' -l '\''"2147483646"'\''
1
$ test-expr -e '\''uint(64)'\'' -l 2147483646
1
$ test-expr -e '\''uint(64)'\'' -l '\''"2147483646"'\''
1
$ test-expr -e '\''int(8)'\'' -l 2147483647
0
$ test-expr -e '\''int(8)'\'' -l '\''"2147483647"'\''
0
$ test-expr -e '\''int(16)'\'' -l 2147483647
0
$ test-expr -e '\''int(16)'\'' -l '\''"2147483647"'\''
0
$ test-expr -e '\''int(32)'\'' -l 2147483647
1
$ test-expr -e '\''int(32)'\'' -l '\''"2147483647"'\''
1
$ test-expr -e '\''int(64)'\'' -l 2147483647
1
$ test-expr -e '\''int(64)'\'' -l '\''"2147483647"'\''
1
$ test-expr -e '\''uint(8)'\'' -l 2147483647
0
$ test-expr -e '\''uint(8)'\'' -l '\''"2147483647"'\''
0
$ test-expr -e '\''uint(16)'\'' -l 2147483647
0
$ test-expr -e '\''uint(16)'\'' -l '\''"2147483647"'\''
0
$ test-expr -e '\''uint(32)'\'' -l 2147483647
1
$ test-expr -e '\''uint(32)'\'' -l '\''"2147483647"'\''
1
$ test-expr -e '\''uint(64)'\'' -l 2147483647
1
$ test-expr -e '\''uint(64)'\'' -l '\''"2147483647"'\''
1
$ test-expr -e '\''int(8)'\'' -l 2147483648
0
$ test-expr -e '\''int(8)'\'' -l '\''"2147483648"'\''
0
$ test-expr -e '\''int(16)'\'' -l 2147483648
0
$ test-expr -e '\''int(16)'\'' -l '\''"2147483648"'\''
0
$ test-expr -e '\''int(32)'\'' -l 2147483648
0
$ test-expr -e '\''int(32)'\'' -l '\''"2147483648"'\''
0
$ test-expr -e '\''int(64)'\'' -l 2147483648
1
$ test-expr -e '\''int(64)'\'' -l '\''"2147483648"'\''
1
$ test-expr -e '\''uint(8)'\'' -l 2147483648
0
$ test-expr -e '\''uint(8)'\'' -l '\''"2147483648"'\''
0
$ test-expr -e '\''uint(16)'\'' -l 2147483648
0
$ test-expr -e '\''uint(16)'\'' -l '\''"2147483648"'\''
0
$ test-expr -e '\''uint(32)'\'' -l 2147483648
1
$ test-expr -e '\''uint(32)'\'' -l '\''"2147483648"'\''
1
$ test-expr -e '\''uint(64)'\'' -l 2147483648
1
$ test-expr -e '\''uint(64)'\'' -l '\''"2147483648"'\''
1
$ test-expr -e '\''int(8)'\'' -l -9223372036854775809
0
$ test-expr -e '\''int(8)'\'' -l '\''"-9223372036854775809"'\''
0
$ test-expr -e '\''int(16)'\'' -l -9223372036854775809
0
$ test-expr -e '\''int(16)'\'' -l '\''"-9223372036854775809"'\''
0
$ test-expr -e '\''int(32)'\'' -l -9223372036854775809
0
$ test-expr -e '\''int(32)'\'' -l '\''"-9223372036854775809"'\''
0
$ test-expr -e '\''int(64)'\'' -l -9223372036854775809
0
$ test-expr -e '\''int(64)'\'' -l '\''"-9223372036854775809"'\''
0
$ test-expr -e '\''uint(8)'\'' -l -9223372036854775809
0
$ test-expr -e '\''uint(8)'\'' -l '\''"-9223372036854775809"'\''
0
$ test-expr -e '\''uint(16)'\'' -l -9223372036854775809
0
$ test-expr -e '\''uint(16)'\'' -l '\''"-9223372036854775809"'\''
0
$ test-expr -e '\''uint(32)'\'' -l -9223372036854775809
0
$ test-expr -e '\''uint(32)'\'' -l '\''"-9223372036854775809"'\''
0
$ test-expr -e '\''uint(64)'\'' -l -9223372036854775809
0
$ test-expr -e '\''uint(64)'\'' -l '\''"-9223372036854775809"'\''
0
$ test-expr -e '\''int(8)'\'' -l -9223372036854775808
0
$ test-expr -e '\''int(8)'\'' -l '\''"-9223372036854775808"'\''
0
$ test-expr -e '\''int(16)'\'' -l -9223372036854775808
0
$ test-expr -e '\''int(16)'\'' -l '\''"-9223372036854775808"'\''
0
$ test-expr -e '\''int(32)'\'' -l -9223372036854775808
0
$ test-expr -e '\''int(32)'\'' -l '\''"-9223372036854775808"'\''
0
$ test-expr -e '\''int(64)'\'' -l -9223372036854775808
1
$ test-expr -e '\''int(64)'\'' -l '\''"-9223372036854775808"'\''
1
$ test-expr -e '\''uint(8)'\'' -l -9223372036854775808
0
$ test-expr -e '\''uint(8)'\'' -l '\''"-9223372036854775808"'\''
0
$ test-expr -e '\''uint(16)'\'' -l -9223372036854775808
0
$ test-expr -e '\''uint(16)'\'' -l '\''"-9223372036854775808"'\''
0
$ test-expr -e '\''uint(32)'\'' -l -9223372036854775808
0
$ test-expr -e '\''uint(32)'\'' -l '\''"-9223372036854775808"'\''
0
$ test-expr -e '\''uint(64)'\'' -l -9223372036854775808
0
$ test-expr -e '\''uint(64)'\'' -l '\''"-9223372036854775808"'\''
0
$ test-expr -e '\''int(8)'\'' -l -9223372036854775807
0
$ test-expr -e '\''int(8)'\'' -l '\''"-9223372036854775807"'\''
0
$ test-expr -e '\''int(16)'\'' -l -9223372036854775807
0
$ test-expr -e '\''int(16)'\'' -l '\''"-9223372036854775807"'\''
0
$ test-expr -e '\''int(32)'\'' -l -9223372036854775807
0
$ test-expr -e '\''int(32)'\'' -l '\''"-9223372036854775807"'\''
0
$ test-expr -e '\''int(64)'\'' -l -9223372036854775807
1
$ test-expr -e '\''int(64)'\'' -l '\''"-9223372036854775807"'\''
1
$ test-expr -e '\''uint(8)'\'' -l -9223372036854775807
0
$ test-expr -e '\''uint(8)'\'' -l '\''"-9223372036854775807"'\''
0
$ test-expr -e '\''uint(16)'\'' -l -9223372036854775807
0
$ test-expr -e '\''uint(16)'\'' -l '\''"-9223372036854775807"'\''
0
$ test-expr -e '\''uint(32)'\'' -l -9223372036854775807
0
$ test-expr -e '\''uint(32)'\'' -l '\''"-9223372036854775807"'\''
0
$ test-expr -e '\''uint(64)'\'' -l -9223372036854775807
0
$ test-expr -e '\''uint(64)'\'' -l '\''"-9223372036854775807"'\''
0
$ test-expr -e '\''int(8)'\'' -l 9223372036854775806
0
$ test-expr -e '\''int(8)'\'' -l '\''"9223372036854775806"'\''
0
$ test-expr -e '\''int(16)'\'' -l 9223372036854775806
0
$ test-expr -e '\''int(16)'\'' -l '\''"9223372036854775806"'\''
0
$ test-expr -e '\''int(32)'\'' -l 9223372036854775806
0
$ test-expr -e '\''int(32)'\'' -l '\''"9223372036854775806"'\''
0
$ test-expr -e '\''int(64)'\'' -l 9223372036854775806
1
$ test-expr -e '\''int(64)'\'' -l '\''"9223372036854775806"'\''
1
$ test-expr -e '\''uint(8)'\'' -l 9223372036854775806
0
$ test-expr -e '\''uint(8)'\'' -l '\''"9223372036854775806"'\''
0
$ test-expr -e '\''uint(16)'\'' -l 9223372036854775806
0
$ test-expr -e '\''uint(16)'\'' -l '\''"9223372036854775806"'\''
0
$ test-expr -e '\''uint(32)'\'' -l 9223372036854775806
0
$ test-expr -e '\''uint(32)'\'' -l '\''"9223372036854775806"'\''
0
$ test-expr -e '\''uint(64)'\'' -l 9223372036854775806
1
$ test-expr -e '\''uint(64)'\'' -l '\''"9223372036854775806"'\''
1
$ test-expr -e '\''int(8)'\'' -l 9223372036854775807
0
$ test-expr -e '\''int(8)'\'' -l '\''"9223372036854775807"'\''
0
$ test-expr -e '\''int(16)'\'' -l 9223372036854775807
0
$ test-expr -e '\''int(16)'\'' -l '\''"9223372036854775807"'\''
0
$ test-expr -e '\''int(32)'\'' -l 9223372036854775807
0
$ test-expr -e '\''int(32)'\'' -l '\''"9223372036854775807"'\''
0
$ test-expr -e '\''int(64)'\'' -l 9223372036854775807
1
$ test-expr -e '\''int(64)'\'' -l '\''"9223372036854775807"'\''
1
$ test-expr -e '\''uint(8)'\'' -l 9223372036854775807
0
$ test-expr -e '\''uint(8)'\'' -l '\''"9223372036854775807"'\''
0
$ test-expr -e '\''uint(16)'\'' -l 9223372036854775807
0
$ test-expr -e '\''uint(16)'\'' -l '\''"9223372036854775807"'\''
0
$ test-expr -e '\''uint(32)'\'' -l 9223372036854775807
0
$ test-expr -e '\''uint(32)'\'' -l '\''"9223372036854775807"'\''
0
$ test-expr -e '\''uint(64)'\'' -l 9223372036854775807
1
$ test-expr -e '\''uint(64)'\'' -l '\''"9223372036854775807"'\''
1
$ test-expr -e '\''int(8)'\'' -l 9223372036854775808
0
$ test-expr -e '\''int(8)'\'' -l '\''"9223372036854775808"'\''
0
$ test-expr -e '\''int(16)'\'' -l 9223372036854775808
0
$ test-expr -e '\''int(16)'\'' -l '\''"9223372036854775808"'\''
0
$ test-expr -e '\''int(32)'\'' -l 9223372036854775808
0
$ test-expr -e '\''int(32)'\'' -l '\''"9223372036854775808"'\''
0
$ test-expr -e '\''int(64)'\'' -l 9223372036854775808
0
$ test-expr -e '\''int(64)'\'' -l '\''"9223372036854775808"'\''
0
$ test-expr -e '\''uint(8)'\'' -l 9223372036854775808
0
$ test-expr -e '\''uint(8)'\'' -l '\''"9223372036854775808"'\''
0
$ test-expr -e '\''uint(16)'\'' -l 9223372036854775808
0
$ test-expr -e '\''uint(16)'\'' -l '\''"9223372036854775808"'\''
0
$ test-expr -e '\''uint(32)'\'' -l 9223372036854775808
0
$ test-expr -e '\''uint(32)'\'' -l '\''"9223372036854775808"'\''
0
$ test-expr -e '\''uint(64)'\'' -l 9223372036854775808
1
$ test-expr -e '\''uint(64)'\'' -l '\''"9223372036854775808"'\''
1
$ test-expr -e '\''int(8)'\'' -l -170141183460469231731687303715884105729
0
$ test-expr -e '\''int(8)'\'' -l '\''"-170141183460469231731687303715884105729"'\''
0
$ test-expr -e '\''int(16)'\'' -l -170141183460469231731687303715884105729
0
$ test-expr -e '\''int(16)'\'' -l '\''"-170141183460469231731687303715884105729"'\''
0
$ test-expr -e '\''int(32)'\'' -l -170141183460469231731687303715884105729
0
$ test-expr -e '\''int(32)'\'' -l '\''"-170141183460469231731687303715884105729"'\''
0
$ test-expr -e '\''int(64)'\'' -l -170141183460469231731687303715884105729
0
$ test-expr -e '\''int(64)'\'' -l '\''"-170141183460469231731687303715884105729"'\''
0
$ test-expr -e '\''uint(8)'\'' -l -170141183460469231731687303715884105729
0
$ test-expr -e '\''uint(8)'\'' -l '\''"-170141183460469231731687303715884105729"'\''
0
$ test-expr -e '\''uint(16)'\'' -l -170141183460469231731687303715884105729
0
$ test-expr -e '\''uint(16)'\'' -l '\''"-170141183460469231731687303715884105729"'\''
0
$ test-expr -e '\''uint(32)'\'' -l -170141183460469231731687303715884105729
0
$ test-expr -e '\''uint(32)'\'' -l '\''"-170141183460469231731687303715884105729"'\''
0
$ test-expr -e '\''uint(64)'\'' -l -170141183460469231731687303715884105729
0
$ test-expr -e '\''uint(64)'\'' -l '\''"-170141183460469231731687303715884105729"'\''
0
$ test-expr -e '\''int(8)'\'' -l -170141183460469231731687303715884105728
0
$ test-expr -e '\''int(8)'\'' -l '\''"-170141183460469231731687303715884105728"'\''
0
$ test-expr -e '\''int(16)'\'' -l -170141183460469231731687303715884105728
0
$ test-expr -e '\''int(16)'\'' -l '\''"-170141183460469231731687303715884105728"'\''
0
$ test-expr -e '\''int(32)'\'' -l -170141183460469231731687303715884105728
0
$ test-expr -e '\''int(32)'\'' -l '\''"-170141183460469231731687303715884105728"'\''
0
$ test-expr -e '\''int(64)'\'' -l -170141183460469231731687303715884105728
0
$ test-expr -e '\''int(64)'\'' -l '\''"-170141183460469231731687303715884105728"'\''
0
$ test-expr -e '\''uint(8)'\'' -l -170141183460469231731687303715884105728
0
$ test-expr -e '\''uint(8)'\'' -l '\''"-170141183460469231731687303715884105728"'\''
0
$ test-expr -e '\''uint(16)'\'' -l -170141183460469231731687303715884105728
0
$ test-expr -e '\''uint(16)'\'' -l '\''"-170141183460469231731687303715884105728"'\''
0
$ test-expr -e '\''uint(32)'\'' -l -170141183460469231731687303715884105728
0
$ test-expr -e '\''uint(32)'\'' -l '\''"-170141183460469231731687303715884105728"'\''
0
$ test-expr -e '\''uint(64)'\'' -l -170141183460469231731687303715884105728
0
$ test-expr -e '\''uint(64)'\'' -l '\''"-170141183460469231731687303715884105728"'\''
0
$ test-expr -e '\''int(8)'\'' -l -170141183460469231731687303715884105727
0
$ test-expr -e '\''int(8)'\'' -l '\''"-170141183460469231731687303715884105727"'\''
0
$ test-expr -e '\''int(16)'\'' -l -170141183460469231731687303715884105727
0
$ test-expr -e '\''int(16)'\'' -l '\''"-170141183460469231731687303715884105727"'\''
0
$ test-expr -e '\''int(32)'\'' -l -170141183460469231731687303715884105727
0
$ test-expr -e '\''int(32)'\'' -l '\''"-170141183460469231731687303715884105727"'\''
0
$ test-expr -e '\''int(64)'\'' -l -170141183460469231731687303715884105727
0
$ test-expr -e '\''int(64)'\'' -l '\''"-170141183460469231731687303715884105727"'\''
0
$ test-expr -e '\''uint(8)'\'' -l -170141183460469231731687303715884105727
0
$ test-expr -e '\''uint(8)'\'' -l '\''"-170141183460469231731687303715884105727"'\''
0
$ test-expr -e '\''uint(16)'\'' -l -170141183460469231731687303715884105727
0
$ test-expr -e '\''uint(16)'\'' -l '\''"-170141183460469231731687303715884105727"'\''
0
$ test-expr -e '\''uint(32)'\'' -l -170141183460469231731687303715884105727
0
$ test-expr -e '\''uint(32)'\'' -l '\''"-170141183460469231731687303715884105727"'\''
0
$ test-expr -e '\''uint(64)'\'' -l -170141183460469231731687303715884105727
0
$ test-expr -e '\''uint(64)'\'' -l '\''"-170141183460469231731687303715884105727"'\''
0
$ test-expr -e '\''int(8)'\'' -l 170141183460469231731687303715884105726
0
$ test-expr -e '\''int(8)'\'' -l '\''"170141183460469231731687303715884105726"'\''
0
$ test-expr -e '\''int(16)'\'' -l 170141183460469231731687303715884105726
0
$ test-expr -e '\''int(16)'\'' -l '\''"170141183460469231731687303715884105726"'\''
0
$ test-expr -e '\''int(32)'\'' -l 170141183460469231731687303715884105726
0
$ test-expr -e '\''int(32)'\'' -l '\''"170141183460469231731687303715884105726"'\''
0
$ test-expr -e '\''int(64)'\'' -l 170141183460469231731687303715884105726
0
$ test-expr -e '\''int(64)'\'' -l '\''"170141183460469231731687303715884105726"'\''
0
$ test-expr -e '\''uint(8)'\'' -l 170141183460469231731687303715884105726
0
$ test-expr -e '\''uint(8)'\'' -l '\''"170141183460469231731687303715884105726"'\''
0
$ test-expr -e '\''uint(16)'\'' -l 170141183460469231731687303715884105726
0
$ test-expr -e '\''uint(16)'\'' -l '\''"170141183460469231731687303715884105726"'\''
0
$ test-expr -e '\''uint(32)'\'' -l 170141183460469231731687303715884105726
0
$ test-expr -e '\''uint(32)'\'' -l '\''"170141183460469231731687303715884105726"'\''
0
$ test-expr -e '\''uint(64)'\'' -l 170141183460469231731687303715884105726
0
$ test-expr -e '\''uint(64)'\'' -l '\''"170141183460469231731687303715884105726"'\''
0
$ test-expr -e '\''int(8)'\'' -l 170141183460469231731687303715884105727
0
$ test-expr -e '\''int(8)'\'' -l '\''"170141183460469231731687303715884105727"'\''
0
$ test-expr -e '\''int(16)'\'' -l 170141183460469231731687303715884105727
0
$ test-expr -e '\''int(16)'\'' -l '\''"170141183460469231731687303715884105727"'\''
0
$ test-expr -e '\''int(32)'\'' -l 170141183460469231731687303715884105727
0
$ test-expr -e '\''int(32)'\'' -l '\''"170141183460469231731687303715884105727"'\''
0
$ test-expr -e '\''int(64)'\'' -l 170141183460469231731687303715884105727
0
$ test-expr -e '\''int(64)'\'' -l '\''"170141183460469231731687303715884105727"'\''
0
$ test-expr -e '\''uint(8)'\'' -l 170141183460469231731687303715884105727
0
$ test-expr -e '\''uint(8)'\'' -l '\''"170141183460469231731687303715884105727"'\''
0
$ test-expr -e '\''uint(16)'\'' -l 170141183460469231731687303715884105727
0
$ test-expr -e '\''uint(16)'\'' -l '\''"170141183460469231731687303715884105727"'\''
0
$ test-expr -e '\''uint(32)'\'' -l 170141183460469231731687303715884105727
0
$ test-expr -e '\''uint(32)'\'' -l '\''"170141183460469231731687303715884105727"'\''
0
$ test-expr -e '\''uint(64)'\'' -l 170141183460469231731687303715884105727
0
$ test-expr -e '\''uint(64)'\'' -l '\''"170141183460469231731687303715884105727"'\''
0
$ test-expr -e '\''int(8)'\'' -l 170141183460469231731687303715884105728
0
$ test-expr -e '\''int(8)'\'' -l '\''"170141183460469231731687303715884105728"'\''
0
$ test-expr -e '\''int(16)'\'' -l 170141183460469231731687303715884105728
0
$ test-expr -e '\''int(16)'\'' -l '\''"170141183460469231731687303715884105728"'\''
0
$ test-expr -e '\''int(32)'\'' -l 170141183460469231731687303715884105728
0
$ test-expr -e '\''int(32)'\'' -l '\''"170141183460469231731687303715884105728"'\''
0
$ test-expr -e '\''int(64)'\'' -l 170141183460469231731687303715884105728
0
$ test-expr -e '\''int(64)'\'' -l '\''"170141183460469231731687303715884105728"'\''
0
$ test-expr -e '\''uint(8)'\'' -l 170141183460469231731687303715884105728
0
$ test-expr -e '\''uint(8)'\'' -l '\''"170141183460469231731687303715884105728"'\''
0
$ test-expr -e '\''uint(16)'\'' -l 170141183460469231731687303715884105728
0
$ test-expr -e '\''uint(16)'\'' -l '\''"170141183460469231731687303715884105728"'\''
0
$ test-expr -e '\''uint(32)'\'' -l 170141183460469231731687303715884105728
0
$ test-expr -e '\''uint(32)'\'' -l '\''"170141183460469231731687303715884105728"'\''
0
$ test-expr -e '\''uint(64)'\'' -l 170141183460469231731687303715884105728
0
$ test-expr -e '\''uint(64)'\'' -l '\''"170141183460469231731687303715884105728"'\''
0
$ test-expr -e '\''int(8)'\'' -l -1
1
$ test-expr -e '\''int(8)'\'' -l '\''"-1"'\''
1
$ test-expr -e '\''int(16)'\'' -l -1
1
$ test-expr -e '\''int(16)'\'' -l '\''"-1"'\''
1
$ test-expr -e '\''int(32)'\'' -l -1
1
$ test-expr -e '\''int(32)'\'' -l '\''"-1"'\''
1
$ test-expr -e '\''int(64)'\'' -l -1
1
$ test-expr -e '\''int(64)'\'' -l '\''"-1"'\''
1
$ test-expr -e '\''uint(8)'\'' -l -1
0
$ test-expr -e '\''uint(8)'\'' -l '\''"-1"'\''
0
$ test-expr -e '\''uint(16)'\'' -l -1
0
$ test-expr -e '\''uint(16)'\'' -l '\''"-1"'\''
0
$ test-expr -e '\''uint(32)'\'' -l -1
0
$ test-expr -e '\''uint(32)'\'' -l '\''"-1"'\''
0
$ test-expr -e '\''uint(64)'\'' -l -1
0
$ test-expr -e '\''uint(64)'\'' -l '\''"-1"'\''
0
$ test-expr -e '\''int(8)'\'' -l 0
1
$ test-expr -e '\''int(8)'\'' -l '\''"0"'\''
1
$ test-expr -e '\''int(16)'\'' -l 0
1
$ test-expr -e '\''int(16)'\'' -l '\''"0"'\''
1
$ test-expr -e '\''int(32)'\'' -l 0
1
$ test-expr -e '\''int(32)'\'' -l '\''"0"'\''
1
$ test-expr -e '\''int(64)'\'' -l 0
1
$ test-expr -e '\''int(64)'\'' -l '\''"0"'\''
1
$ test-expr -e '\''uint(8)'\'' -l 0
1
$ test-expr -e '\''uint(8)'\'' -l '\''"0"'\''
1
$ test-expr -e '\''uint(16)'\'' -l 0
1
$ test-expr -e '\''uint(16)'\'' -l '\''"0"'\''
1
$ test-expr -e '\''uint(32)'\'' -l 0
1
$ test-expr -e '\''uint(32)'\'' -l '\''"0"'\''
1
$ test-expr -e '\''uint(64)'\'' -l 0
1
$ test-expr -e '\''uint(64)'\'' -l '\''"0"'\''
1
$ test-expr -e '\''int(8)'\'' -l 1
1
$ test-expr -e '\''int(8)'\'' -l '\''"1"'\''
1
$ test-expr -e '\''int(16)'\'' -l 1
1
$ test-expr -e '\''int(16)'\'' -l '\''"1"'\''
1
$ test-expr -e '\''int(32)'\'' -l 1
1
$ test-expr -e '\''int(32)'\'' -l '\''"1"'\''
1
$ test-expr -e '\''int(64)'\'' -l 1
1
$ test-expr -e '\''int(64)'\'' -l '\''"1"'\''
1
$ test-expr -e '\''uint(8)'\'' -l 1
1
$ test-expr -e '\''uint(8)'\'' -l '\''"1"'\''
1
$ test-expr -e '\''uint(16)'\'' -l 1
1
$ test-expr -e '\''uint(16)'\'' -l '\''"1"'\''
1
$ test-expr -e '\''uint(32)'\'' -l 1
1
$ test-expr -e '\''uint(32)'\'' -l '\''"1"'\''
1
$ test-expr -e '\''uint(64)'\'' -l 1
1
$ test-expr -e '\''uint(64)'\'' -l '\''"1"'\''
1
$ test-expr -e '\''int(8)'\'' -l 254
0
$ test-expr -e '\''int(8)'\'' -l '\''"254"'\''
0
$ test-expr -e '\''int(16)'\'' -l 254
1
$ test-expr -e '\''int(16)'\'' -l '\''"254"'\''
1
$ test-expr -e '\''int(32)'\'' -l 254
1
$ test-expr -e '\''int(32)'\'' -l '\''"254"'\''
1
$ test-expr -e '\''int(64)'\'' -l 254
1
$ test-expr -e '\''int(64)'\'' -l '\''"254"'\''
1
$ test-expr -e '\''uint(8)'\'' -l 254
1
$ test-expr -e '\''uint(8)'\'' -l '\''"254"'\''
1
$ test-expr -e '\''uint(16)'\'' -l 254
1
$ test-expr -e '\''uint(16)'\'' -l '\''"254"'\''
1
$ test-expr -e '\''uint(32)'\'' -l 254
1
$ test-expr -e '\''uint(32)'\'' -l '\''"254"'\''
1
$ test-expr -e '\''uint(64)'\'' -l 254
1
$ test-expr -e '\''uint(64)'\'' -l '\''"254"'\''
1
$ test-expr -e '\''int(8)'\'' -l 255
0
$ test-expr -e '\''int(8)'\'' -l '\''"255"'\''
0
$ test-expr -e '\''int(16)'\'' -l 255
1
$ test-expr -e '\''int(16)'\'' -l '\''"255"'\''
1
$ test-expr -e '\''int(32)'\'' -l 255
1
$ test-expr -e '\''int(32)'\'' -l '\''"255"'\''
1
$ test-expr -e '\''int(64)'\'' -l 255
1
$ test-expr -e '\''int(64)'\'' -l '\''"255"'\''
1
$ test-expr -e '\''uint(8)'\'' -l 255
1
$ test-expr -e '\''uint(8)'\'' -l '\''"255"'\''
1
$ test-expr -e '\''uint(16)'\'' -l 255
1
$ test-expr -e '\''uint(16)'\'' -l '\''"255"'\''
1
$ test-expr -e '\''uint(32)'\'' -l 255
1
$ test-expr -e '\''uint(32)'\'' -l '\''"255"'\''
1
$ test-expr -e '\''uint(64)'\'' -l 255
1
$ test-expr -e '\''uint(64)'\'' -l '\''"255"'\''
1
$ test-expr -e '\''int(8)'\'' -l 256
0
$ test-expr -e '\''int(8)'\'' -l '\''"256"'\''
0
$ test-expr -e '\''int(16)'\'' -l 256
1
$ test-expr -e '\''int(16)'\'' -l '\''"256"'\''
1
$ test-expr -e '\''int(32)'\'' -l 256
1
$ test-expr -e '\''int(32)'\'' -l '\''"256"'\''
1
$ test-expr -e '\''int(64)'\'' -l 256
1
$ test-expr -e '\''int(64)'\'' -l '\''"256"'\''
1
$ test-expr -e '\''uint(8)'\'' -l 256
0
$ test-expr -e '\''uint(8)'\'' -l '\''"256"'\''
0
$ test-expr -e '\''uint(16)'\'' -l 256
1
$ test-expr -e '\''uint(16)'\'' -l '\''"256"'\''
1
$ test-expr -e '\''uint(32)'\'' -l 256
1
$ test-expr -e '\''uint(32)'\'' -l '\''"256"'\''
1
$ test-expr -e '\''uint(64)'\'' -l 256
1
$ test-expr -e '\''uint(64)'\'' -l '\''"256"'\''
1
$ test-expr -e '\''int(8)'\'' -l 65534
0
$ test-expr -e '\''int(8)'\'' -l '\''"65534"'\''
0
$ test-expr -e '\''int(16)'\'' -l 65534
0
$ test-expr -e '\''int(16)'\'' -l '\''"65534"'\''
0
$ test-expr -e '\''int(32)'\'' -l 65534
1
$ test-expr -e '\''int(32)'\'' -l '\''"65534"'\''
1
$ test-expr -e '\''int(64)'\'' -l 65534
1
$ test-expr -e '\''int(64)'\'' -l '\''"65534"'\''
1
$ test-expr -e '\''uint(8)'\'' -l 65534
0
$ test-expr -e '\''uint(8)'\'' -l '\''"65534"'\''
0
$ test-expr -e '\''uint(16)'\'' -l 65534
1
$ test-expr -e '\''uint(16)'\'' -l '\''"65534"'\''
1
$ test-expr -e '\''uint(32)'\'' -l 65534
1
$ test-expr -e '\''uint(32)'\'' -l '\''"65534"'\''
1
$ test-expr -e '\''uint(64)'\'' -l 65534
1
$ test-expr -e '\''uint(64)'\'' -l '\''"65534"'\''
1
$ test-expr -e '\''int(8)'\'' -l 65535
0
$ test-expr -e '\''int(8)'\'' -l '\''"65535"'\''
0
$ test-expr -e '\''int(16)'\'' -l 65535
0
$ test-expr -e '\''int(16)'\'' -l '\''"65535"'\''
0
$ test-expr -e '\''int(32)'\'' -l 65535
1
$ test-expr -e '\''int(32)'\'' -l '\''"65535"'\''
1
$ test-expr -e '\''int(64)'\'' -l 65535
1
$ test-expr -e '\''int(64)'\'' -l '\''"65535"'\''
1
$ test-expr -e '\''uint(8)'\'' -l 65535
0
$ test-expr -e '\''uint(8)'\'' -l '\''"65535"'\''
0
$ test-expr -e '\''uint(16)'\'' -l 65535
1
$ test-expr -e '\''uint(16)'\'' -l '\''"65535"'\''
1
$ test-expr -e '\''uint(32)'\'' -l 65535
1
$ test-expr -e '\''uint(32)'\'' -l '\''"65535"'\''
1
$ test-expr -e '\''uint(64)'\'' -l 65535
1
$ test-expr -e '\''uint(64)'\'' -l '\''"65535"'\''
1
$ test-expr -e '\''int(8)'\'' -l 65536
0
$ test-expr -e '\''int(8)'\'' -l '\''"65536"'\''
0
$ test-expr -e '\''int(16)'\'' -l 65536
0
$ test-expr -e '\''int(16)'\'' -l '\''"65536"'\''
0
$ test-expr -e '\''int(32)'\'' -l 65536
1
$ test-expr -e '\''int(32)'\'' -l '\''"65536"'\''
1
$ test-expr -e '\''int(64)'\'' -l 65536
1
$ test-expr -e '\''int(64)'\'' -l '\''"65536"'\''
1
$ test-expr -e '\''uint(8)'\'' -l 65536
0
$ test-expr -e '\''uint(8)'\'' -l '\''"65536"'\''
0
$ test-expr -e '\''uint(16)'\'' -l 65536
0
$ test-expr -e '\''uint(16)'\'' -l '\''"65536"'\''
0
$ test-expr -e '\''uint(32)'\'' -l 65536
1
$ test-expr -e '\''uint(32)'\'' -l '\''"65536"'\''
1
$ test-expr -e '\''uint(64)'\'' -l 65536
1
$ test-expr -e '\''uint(64)'\'' -l '\''"65536"'\''
1
$ test-expr -e '\''int(8)'\'' -l 4294967294
0
$ test-expr -e '\''int(8)'\'' -l '\''"4294967294"'\''
0
$ test-expr -e '\''int(16)'\'' -l 4294967294
0
$ test-expr -e '\''int(16)'\'' -l '\''"4294967294"'\''
0
$ test-expr -e '\''int(32)'\'' -l 4294967294
0
$ test-expr -e '\''int(32)'\'' -l '\''"4294967294"'\''
0
$ test-expr -e '\''int(64)'\'' -l 4294967294
1
$ test-expr -e '\''int(64)'\'' -l '\''"4294967294"'\''
1
$ test-expr -e '\''uint(8)'\'' -l 4294967294
0
$ test-expr -e '\''uint(8)'\'' -l '\''"4294967294"'\''
0
$ test-expr -e '\''uint(16)'\'' -l 4294967294
0
$ test-expr -e '\''uint(16)'\'' -l '\''"4294967294"'\''
0
$ test-expr -e '\''uint(32)'\'' -l 4294967294
1
$ test-expr -e '\''uint(32)'\'' -l '\''"4294967294"'\''
1
$ test-expr -e '\''uint(64)'\'' -l 4294967294
1
$ test-expr -e '\''uint(64)'\'' -l '\''"4294967294"'\''
1
$ test-expr -e '\''int(8)'\'' -l 4294967295
0
$ test-expr -e '\''int(8)'\'' -l '\''"4294967295"'\''
0
$ test-expr -e '\''int(16)'\'' -l 4294967295
0
$ test-expr -e '\''int(16)'\'' -l '\''"4294967295"'\''
0
$ test-expr -e '\''int(32)'\'' -l 4294967295
0
$ test-expr -e '\''int(32)'\'' -l '\''"4294967295"'\''
0
$ test-expr -e '\''int(64)'\'' -l 4294967295
1
$ test-expr -e '\''int(64)'\'' -l '\''"4294967295"'\''
1
$ test-expr -e '\''uint(8)'\'' -l 4294967295
0
$ test-expr -e '\''uint(8)'\'' -l '\''"4294967295"'\''
0
$ test-expr -e '\''uint(16)'\'' -l 4294967295
0
$ test-expr -e '\''uint(16)'\'' -l '\''"4294967295"'\''
0
$ test-expr -e '\''uint(32)'\'' -l 4294967295
1
$ test-expr -e '\''uint(32)'\'' -l '\''"4294967295"'\''
1
$ test-expr -e '\''uint(64)'\'' -l 4294967295
1
$ test-expr -e '\''uint(64)'\'' -l '\''"4294967295"'\''
1
$ test-expr -e '\''int(8)'\'' -l 4294967296
0
$ test-expr -e '\''int(8)'\'' -l '\''"4294967296"'\''
0
$ test-expr -e '\''int(16)'\'' -l 4294967296
0
$ test-expr -e '\''int(16)'\'' -l '\''"4294967296"'\''
0
$ test-expr -e '\''int(32)'\'' -l 4294967296
0
$ test-expr -e '\''int(32)'\'' -l '\''"4294967296"'\''
0
$ test-expr -e '\''int(64)'\'' -l 4294967296
1
$ test-expr -e '\''int(64)'\'' -l '\''"4294967296"'\''
1
$ test-expr -e '\''uint(8)'\'' -l 4294967296
0
$ test-expr -e '\''uint(8)'\'' -l '\''"4294967296"'\''
0
$ test-expr -e '\''uint(16)'\'' -l 4294967296
0
$ test-expr -e '\''uint(16)'\'' -l '\''"4294967296"'\''
0
$ test-expr -e '\''uint(32)'\'' -l 4294967296
0
$ test-expr -e '\''uint(32)'\'' -l '\''"4294967296"'\''
0
$ test-expr -e '\''uint(64)'\'' -l 4294967296
1
$ test-expr -e '\''uint(64)'\'' -l '\''"4294967296"'\''
1
$ test-expr -e '\''int(8)'\'' -l 18446744073709551614
0
$ test-expr -e '\''int(8)'\'' -l '\''"18446744073709551614"'\''
0
$ test-expr -e '\''int(16)'\'' -l 18446744073709551614
0
$ test-expr -e '\''int(16)'\'' -l '\''"18446744073709551614"'\''
0
$ test-expr -e '\''int(32)'\'' -l 18446744073709551614
0
$ test-expr -e '\''int(32)'\'' -l '\''"18446744073709551614"'\''
0
$ test-expr -e '\''int(64)'\'' -l 18446744073709551614
0
$ test-expr -e '\''int(64)'\'' -l '\''"18446744073709551614"'\''
0
$ test-expr -e '\''uint(8)'\'' -l 18446744073709551614
0
$ test-expr -e '\''uint(8)'\'' -l '\''"18446744073709551614"'\''
0
$ test-expr -e '\''uint(16)'\'' -l 18446744073709551614
0
$ test-expr -e '\''uint(16)'\'' -l '\''"18446744073709551614"'\''
0
$ test-expr -e '\''uint(32)'\'' -l 18446744073709551614
0
$ test-expr -e '\''uint(32)'\'' -l '\''"18446744073709551614"'\''
0
$ test-expr -e '\''uint(64)'\'' -l 18446744073709551614
1
$ test-expr -e '\''uint(64)'\'' -l '\''"18446744073709551614"'\''
1
$ test-expr -e '\''int(8)'\'' -l 18446744073709551615
0
$ test-expr -e '\''int(8)'\'' -l '\''"18446744073709551615"'\''
0
$ test-expr -e '\''int(16)'\'' -l 18446744073709551615
0
$ test-expr -e '\''int(16)'\'' -l '\''"18446744073709551615"'\''
0
$ test-expr -e '\''int(32)'\'' -l 18446744073709551615
0
$ test-expr -e '\''int(32)'\'' -l '\''"18446744073709551615"'\''
0
$ test-expr -e '\''int(64)'\'' -l 18446744073709551615
0
$ test-expr -e '\''int(64)'\'' -l '\''"18446744073709551615"'\''
0
$ test-expr -e '\''uint(8)'\'' -l 18446744073709551615
0
$ test-expr -e '\''uint(8)'\'' -l '\''"18446744073709551615"'\''
0
$ test-expr -e '\''uint(16)'\'' -l 18446744073709551615
0
$ test-expr -e '\''uint(16)'\'' -l '\''"18446744073709551615"'\''
0
$ test-expr -e '\''uint(32)'\'' -l 18446744073709551615
0
$ test-expr -e '\''uint(32)'\'' -l '\''"18446744073709551615"'\''
0
$ test-expr -e '\''uint(64)'\'' -l 18446744073709551615
1
$ test-expr -e '\''uint(64)'\'' -l '\''"18446744073709551615"'\''
1
$ test-expr -e '\''int(8)'\'' -l 18446744073709551616
0
$ test-expr -e '\''int(8)'\'' -l '\''"18446744073709551616"'\''
0
$ test-expr -e '\''int(16)'\'' -l 18446744073709551616
0
$ test-expr -e '\''int(16)'\'' -l '\''"18446744073709551616"'\''
0
$ test-expr -e '\''int(32)'\'' -l 18446744073709551616
0
$ test-expr -e '\''int(32)'\'' -l '\''"18446744073709551616"'\''
0
$ test-expr -e '\''int(64)'\'' -l 18446744073709551616
0
$ test-expr -e '\''int(64)'\'' -l '\''"18446744073709551616"'\''
0
$ test-expr -e '\''uint(8)'\'' -l 18446744073709551616
0
$ test-expr -e '\''uint(8)'\'' -l '\''"18446744073709551616"'\''
0
$ test-expr -e '\''uint(16)'\'' -l 18446744073709551616
0
$ test-expr -e '\''uint(16)'\'' -l '\''"18446744073709551616"'\''
0
$ test-expr -e '\''uint(32)'\'' -l 18446744073709551616
0
$ test-expr -e '\''uint(32)'\'' -l '\''"18446744073709551616"'\''
0
$ test-expr -e '\''uint(64)'\'' -l 18446744073709551616
0
$ test-expr -e '\''uint(64)'\'' -l '\''"18446744073709551616"'\''
0
$ test-expr -e '\''int(8)'\'' -l 340282366920938463463374607431768211454
0
$ test-expr -e '\''int(8)'\'' -l '\''"340282366920938463463374607431768211454"'\''
0
$ test-expr -e '\''int(16)'\'' -l 340282366920938463463374607431768211454
0
$ test-expr -e '\''int(16)'\'' -l '\''"340282366920938463463374607431768211454"'\''
0
$ test-expr -e '\''int(32)'\'' -l 340282366920938463463374607431768211454
0
$ test-expr -e '\''int(32)'\'' -l '\''"340282366920938463463374607431768211454"'\''
0
$ test-expr -e '\''int(64)'\'' -l 340282366920938463463374607431768211454
0
$ test-expr -e '\''int(64)'\'' -l '\''"340282366920938463463374607431768211454"'\''
0
$ test-expr -e '\''uint(8)'\'' -l 340282366920938463463374607431768211454
0
$ test-expr -e '\''uint(8)'\'' -l '\''"340282366920938463463374607431768211454"'\''
0
$ test-expr -e '\''uint(16)'\'' -l 340282366920938463463374607431768211454
0
$ test-expr -e '\''uint(16)'\'' -l '\''"340282366920938463463374607431768211454"'\''
0
$ test-expr -e '\''uint(32)'\'' -l 340282366920938463463374607431768211454
0
$ test-expr -e '\''uint(32)'\'' -l '\''"340282366920938463463374607431768211454"'\''
0
$ test-expr -e '\''uint(64)'\'' -l 340282366920938463463374607431768211454
0
$ test-expr -e '\''uint(64)'\'' -l '\''"340282366920938463463374607431768211454"'\''
0
$ test-expr -e '\''int(8)'\'' -l 340282366920938463463374607431768211455
0
$ test-expr -e '\''int(8)'\'' -l '\''"340282366920938463463374607431768211455"'\''
0
$ test-expr -e '\''int(16)'\'' -l 340282366920938463463374607431768211455
0
$ test-expr -e '\''int(16)'\'' -l '\''"340282366920938463463374607431768211455"'\''
0
$ test-expr -e '\''int(32)'\'' -l 340282366920938463463374607431768211455
0
$ test-expr -e '\''int(32)'\'' -l '\''"340282366920938463463374607431768211455"'\''
0
$ test-expr -e '\''int(64)'\'' -l 340282366920938463463374607431768211455
0
$ test-expr -e '\''int(64)'\'' -l '\''"340282366920938463463374607431768211455"'\''
0
$ test-expr -e '\''uint(8)'\'' -l 340282366920938463463374607431768211455
0
$ test-expr -e '\''uint(8)'\'' -l '\''"340282366920938463463374607431768211455"'\''
0
$ test-expr -e '\''uint(16)'\'' -l 340282366920938463463374607431768211455
0
$ test-expr -e '\''uint(16)'\'' -l '\''"340282366920938463463374607431768211455"'\''
0
$ test-expr -e '\''uint(32)'\'' -l 340282366920938463463374607431768211455
0
$ test-expr -e '\''uint(32)'\'' -l '\''"340282366920938463463374607431768211455"'\''
0
$ test-expr -e '\''uint(64)'\'' -l 340282366920938463463374607431768211455
0
$ test-expr -e '\''uint(64)'\'' -l '\''"340282366920938463463374607431768211455"'\''
0
$ test-expr -e '\''int(8)'\'' -l 340282366920938463463374607431768211456
0
$ test-expr -e '\''int(8)'\'' -l '\''"340282366920938463463374607431768211456"'\''
0
$ test-expr -e '\''int(16)'\'' -l 340282366920938463463374607431768211456
0
$ test-expr -e '\''int(16)'\'' -l '\''"340282366920938463463374607431768211456"'\''
0
$ test-expr -e '\''int(32)'\'' -l 340282366920938463463374607431768211456
0
$ test-expr -e '\''int(32)'\'' -l '\''"340282366920938463463374607431768211456"'\''
0
$ test-expr -e '\''int(64)'\'' -l 340282366920938463463374607431768211456
0
$ test-expr -e '\''int(64)'\'' -l '\''"340282366920938463463374607431768211456"'\''
0
$ test-expr -e '\''uint(8)'\'' -l 340282366920938463463374607431768211456
0
$ test-expr -e '\''uint(8)'\'' -l '\''"340282366920938463463374607431768211456"'\''
0
$ test-expr -e '\''uint(16)'\'' -l 340282366920938463463374607431768211456
0
$ test-expr -e '\''uint(16)'\'' -l '\''"340282366920938463463374607431768211456"'\''
0
$ test-expr -e '\''uint(32)'\'' -l 340282366920938463463374607431768211456
0
$ test-expr -e '\''uint(32)'\'' -l '\''"340282366920938463463374607431768211456"'\''
0
$ test-expr -e '\''uint(64)'\'' -l 340282366920938463463374607431768211456
0
$ test-expr -e '\''uint(64)'\'' -l '\''"340282366920938463463374607431768211456"'\''
0'
) -L builtins2.new <(
echo '$ shopt -s expand_aliases'
shopt -s expand_aliases 2>&1 ||
echo 'command failed: shopt -s expand_aliases'

echo '$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'
[ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib" 2>&1 ||
echo 'command failed: [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'

echo '$ test-expr() { LD_LIBRARY_PATH="$JSON_LITEX_TEST_PCRE2_LIB" ../lib/test-expr "$@" -vb default -E; }'
test-expr() { LD_LIBRARY_PATH="$JSON_LITEX_TEST_PCRE2_LIB" ../lib/test-expr "$@" -vb default -E; } 2>&1 ||
echo 'command failed: test-expr() { LD_LIBRARY_PATH="$JSON_LITEX_TEST_PCRE2_LIB" ../lib/test-expr "$@" -vb default -E; }'

echo '$ test-expr -e '\''int(8)'\'' -l -129'
test-expr -e 'int(8)' -l -129 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l -129'

echo '$ test-expr -e '\''int(8)'\'' -l '\''"-129"'\'''
test-expr -e 'int(8)' -l '"-129"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l '\''"-129"'\'''

echo '$ test-expr -e '\''int(16)'\'' -l -129'
test-expr -e 'int(16)' -l -129 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l -129'

echo '$ test-expr -e '\''int(16)'\'' -l '\''"-129"'\'''
test-expr -e 'int(16)' -l '"-129"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l '\''"-129"'\'''

echo '$ test-expr -e '\''int(32)'\'' -l -129'
test-expr -e 'int(32)' -l -129 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l -129'

echo '$ test-expr -e '\''int(32)'\'' -l '\''"-129"'\'''
test-expr -e 'int(32)' -l '"-129"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l '\''"-129"'\'''

echo '$ test-expr -e '\''int(64)'\'' -l -129'
test-expr -e 'int(64)' -l -129 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l -129'

echo '$ test-expr -e '\''int(64)'\'' -l '\''"-129"'\'''
test-expr -e 'int(64)' -l '"-129"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l '\''"-129"'\'''

echo '$ test-expr -e '\''uint(8)'\'' -l -129'
test-expr -e 'uint(8)' -l -129 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l -129'

echo '$ test-expr -e '\''uint(8)'\'' -l '\''"-129"'\'''
test-expr -e 'uint(8)' -l '"-129"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l '\''"-129"'\'''

echo '$ test-expr -e '\''uint(16)'\'' -l -129'
test-expr -e 'uint(16)' -l -129 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l -129'

echo '$ test-expr -e '\''uint(16)'\'' -l '\''"-129"'\'''
test-expr -e 'uint(16)' -l '"-129"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l '\''"-129"'\'''

echo '$ test-expr -e '\''uint(32)'\'' -l -129'
test-expr -e 'uint(32)' -l -129 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l -129'

echo '$ test-expr -e '\''uint(32)'\'' -l '\''"-129"'\'''
test-expr -e 'uint(32)' -l '"-129"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l '\''"-129"'\'''

echo '$ test-expr -e '\''uint(64)'\'' -l -129'
test-expr -e 'uint(64)' -l -129 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l -129'

echo '$ test-expr -e '\''uint(64)'\'' -l '\''"-129"'\'''
test-expr -e 'uint(64)' -l '"-129"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l '\''"-129"'\'''

echo '$ test-expr -e '\''int(8)'\'' -l -128'
test-expr -e 'int(8)' -l -128 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l -128'

echo '$ test-expr -e '\''int(8)'\'' -l '\''"-128"'\'''
test-expr -e 'int(8)' -l '"-128"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l '\''"-128"'\'''

echo '$ test-expr -e '\''int(16)'\'' -l -128'
test-expr -e 'int(16)' -l -128 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l -128'

echo '$ test-expr -e '\''int(16)'\'' -l '\''"-128"'\'''
test-expr -e 'int(16)' -l '"-128"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l '\''"-128"'\'''

echo '$ test-expr -e '\''int(32)'\'' -l -128'
test-expr -e 'int(32)' -l -128 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l -128'

echo '$ test-expr -e '\''int(32)'\'' -l '\''"-128"'\'''
test-expr -e 'int(32)' -l '"-128"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l '\''"-128"'\'''

echo '$ test-expr -e '\''int(64)'\'' -l -128'
test-expr -e 'int(64)' -l -128 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l -128'

echo '$ test-expr -e '\''int(64)'\'' -l '\''"-128"'\'''
test-expr -e 'int(64)' -l '"-128"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l '\''"-128"'\'''

echo '$ test-expr -e '\''uint(8)'\'' -l -128'
test-expr -e 'uint(8)' -l -128 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l -128'

echo '$ test-expr -e '\''uint(8)'\'' -l '\''"-128"'\'''
test-expr -e 'uint(8)' -l '"-128"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l '\''"-128"'\'''

echo '$ test-expr -e '\''uint(16)'\'' -l -128'
test-expr -e 'uint(16)' -l -128 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l -128'

echo '$ test-expr -e '\''uint(16)'\'' -l '\''"-128"'\'''
test-expr -e 'uint(16)' -l '"-128"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l '\''"-128"'\'''

echo '$ test-expr -e '\''uint(32)'\'' -l -128'
test-expr -e 'uint(32)' -l -128 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l -128'

echo '$ test-expr -e '\''uint(32)'\'' -l '\''"-128"'\'''
test-expr -e 'uint(32)' -l '"-128"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l '\''"-128"'\'''

echo '$ test-expr -e '\''uint(64)'\'' -l -128'
test-expr -e 'uint(64)' -l -128 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l -128'

echo '$ test-expr -e '\''uint(64)'\'' -l '\''"-128"'\'''
test-expr -e 'uint(64)' -l '"-128"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l '\''"-128"'\'''

echo '$ test-expr -e '\''int(8)'\'' -l -127'
test-expr -e 'int(8)' -l -127 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l -127'

echo '$ test-expr -e '\''int(8)'\'' -l '\''"-127"'\'''
test-expr -e 'int(8)' -l '"-127"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l '\''"-127"'\'''

echo '$ test-expr -e '\''int(16)'\'' -l -127'
test-expr -e 'int(16)' -l -127 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l -127'

echo '$ test-expr -e '\''int(16)'\'' -l '\''"-127"'\'''
test-expr -e 'int(16)' -l '"-127"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l '\''"-127"'\'''

echo '$ test-expr -e '\''int(32)'\'' -l -127'
test-expr -e 'int(32)' -l -127 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l -127'

echo '$ test-expr -e '\''int(32)'\'' -l '\''"-127"'\'''
test-expr -e 'int(32)' -l '"-127"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l '\''"-127"'\'''

echo '$ test-expr -e '\''int(64)'\'' -l -127'
test-expr -e 'int(64)' -l -127 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l -127'

echo '$ test-expr -e '\''int(64)'\'' -l '\''"-127"'\'''
test-expr -e 'int(64)' -l '"-127"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l '\''"-127"'\'''

echo '$ test-expr -e '\''uint(8)'\'' -l -127'
test-expr -e 'uint(8)' -l -127 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l -127'

echo '$ test-expr -e '\''uint(8)'\'' -l '\''"-127"'\'''
test-expr -e 'uint(8)' -l '"-127"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l '\''"-127"'\'''

echo '$ test-expr -e '\''uint(16)'\'' -l -127'
test-expr -e 'uint(16)' -l -127 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l -127'

echo '$ test-expr -e '\''uint(16)'\'' -l '\''"-127"'\'''
test-expr -e 'uint(16)' -l '"-127"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l '\''"-127"'\'''

echo '$ test-expr -e '\''uint(32)'\'' -l -127'
test-expr -e 'uint(32)' -l -127 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l -127'

echo '$ test-expr -e '\''uint(32)'\'' -l '\''"-127"'\'''
test-expr -e 'uint(32)' -l '"-127"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l '\''"-127"'\'''

echo '$ test-expr -e '\''uint(64)'\'' -l -127'
test-expr -e 'uint(64)' -l -127 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l -127'

echo '$ test-expr -e '\''uint(64)'\'' -l '\''"-127"'\'''
test-expr -e 'uint(64)' -l '"-127"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l '\''"-127"'\'''

echo '$ test-expr -e '\''int(8)'\'' -l 126'
test-expr -e 'int(8)' -l 126 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l 126'

echo '$ test-expr -e '\''int(8)'\'' -l '\''"126"'\'''
test-expr -e 'int(8)' -l '"126"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l '\''"126"'\'''

echo '$ test-expr -e '\''int(16)'\'' -l 126'
test-expr -e 'int(16)' -l 126 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l 126'

echo '$ test-expr -e '\''int(16)'\'' -l '\''"126"'\'''
test-expr -e 'int(16)' -l '"126"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l '\''"126"'\'''

echo '$ test-expr -e '\''int(32)'\'' -l 126'
test-expr -e 'int(32)' -l 126 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l 126'

echo '$ test-expr -e '\''int(32)'\'' -l '\''"126"'\'''
test-expr -e 'int(32)' -l '"126"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l '\''"126"'\'''

echo '$ test-expr -e '\''int(64)'\'' -l 126'
test-expr -e 'int(64)' -l 126 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l 126'

echo '$ test-expr -e '\''int(64)'\'' -l '\''"126"'\'''
test-expr -e 'int(64)' -l '"126"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l '\''"126"'\'''

echo '$ test-expr -e '\''uint(8)'\'' -l 126'
test-expr -e 'uint(8)' -l 126 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l 126'

echo '$ test-expr -e '\''uint(8)'\'' -l '\''"126"'\'''
test-expr -e 'uint(8)' -l '"126"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l '\''"126"'\'''

echo '$ test-expr -e '\''uint(16)'\'' -l 126'
test-expr -e 'uint(16)' -l 126 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l 126'

echo '$ test-expr -e '\''uint(16)'\'' -l '\''"126"'\'''
test-expr -e 'uint(16)' -l '"126"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l '\''"126"'\'''

echo '$ test-expr -e '\''uint(32)'\'' -l 126'
test-expr -e 'uint(32)' -l 126 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l 126'

echo '$ test-expr -e '\''uint(32)'\'' -l '\''"126"'\'''
test-expr -e 'uint(32)' -l '"126"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l '\''"126"'\'''

echo '$ test-expr -e '\''uint(64)'\'' -l 126'
test-expr -e 'uint(64)' -l 126 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l 126'

echo '$ test-expr -e '\''uint(64)'\'' -l '\''"126"'\'''
test-expr -e 'uint(64)' -l '"126"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l '\''"126"'\'''

echo '$ test-expr -e '\''int(8)'\'' -l 127'
test-expr -e 'int(8)' -l 127 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l 127'

echo '$ test-expr -e '\''int(8)'\'' -l '\''"127"'\'''
test-expr -e 'int(8)' -l '"127"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l '\''"127"'\'''

echo '$ test-expr -e '\''int(16)'\'' -l 127'
test-expr -e 'int(16)' -l 127 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l 127'

echo '$ test-expr -e '\''int(16)'\'' -l '\''"127"'\'''
test-expr -e 'int(16)' -l '"127"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l '\''"127"'\'''

echo '$ test-expr -e '\''int(32)'\'' -l 127'
test-expr -e 'int(32)' -l 127 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l 127'

echo '$ test-expr -e '\''int(32)'\'' -l '\''"127"'\'''
test-expr -e 'int(32)' -l '"127"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l '\''"127"'\'''

echo '$ test-expr -e '\''int(64)'\'' -l 127'
test-expr -e 'int(64)' -l 127 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l 127'

echo '$ test-expr -e '\''int(64)'\'' -l '\''"127"'\'''
test-expr -e 'int(64)' -l '"127"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l '\''"127"'\'''

echo '$ test-expr -e '\''uint(8)'\'' -l 127'
test-expr -e 'uint(8)' -l 127 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l 127'

echo '$ test-expr -e '\''uint(8)'\'' -l '\''"127"'\'''
test-expr -e 'uint(8)' -l '"127"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l '\''"127"'\'''

echo '$ test-expr -e '\''uint(16)'\'' -l 127'
test-expr -e 'uint(16)' -l 127 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l 127'

echo '$ test-expr -e '\''uint(16)'\'' -l '\''"127"'\'''
test-expr -e 'uint(16)' -l '"127"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l '\''"127"'\'''

echo '$ test-expr -e '\''uint(32)'\'' -l 127'
test-expr -e 'uint(32)' -l 127 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l 127'

echo '$ test-expr -e '\''uint(32)'\'' -l '\''"127"'\'''
test-expr -e 'uint(32)' -l '"127"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l '\''"127"'\'''

echo '$ test-expr -e '\''uint(64)'\'' -l 127'
test-expr -e 'uint(64)' -l 127 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l 127'

echo '$ test-expr -e '\''uint(64)'\'' -l '\''"127"'\'''
test-expr -e 'uint(64)' -l '"127"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l '\''"127"'\'''

echo '$ test-expr -e '\''int(8)'\'' -l 128'
test-expr -e 'int(8)' -l 128 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l 128'

echo '$ test-expr -e '\''int(8)'\'' -l '\''"128"'\'''
test-expr -e 'int(8)' -l '"128"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l '\''"128"'\'''

echo '$ test-expr -e '\''int(16)'\'' -l 128'
test-expr -e 'int(16)' -l 128 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l 128'

echo '$ test-expr -e '\''int(16)'\'' -l '\''"128"'\'''
test-expr -e 'int(16)' -l '"128"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l '\''"128"'\'''

echo '$ test-expr -e '\''int(32)'\'' -l 128'
test-expr -e 'int(32)' -l 128 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l 128'

echo '$ test-expr -e '\''int(32)'\'' -l '\''"128"'\'''
test-expr -e 'int(32)' -l '"128"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l '\''"128"'\'''

echo '$ test-expr -e '\''int(64)'\'' -l 128'
test-expr -e 'int(64)' -l 128 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l 128'

echo '$ test-expr -e '\''int(64)'\'' -l '\''"128"'\'''
test-expr -e 'int(64)' -l '"128"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l '\''"128"'\'''

echo '$ test-expr -e '\''uint(8)'\'' -l 128'
test-expr -e 'uint(8)' -l 128 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l 128'

echo '$ test-expr -e '\''uint(8)'\'' -l '\''"128"'\'''
test-expr -e 'uint(8)' -l '"128"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l '\''"128"'\'''

echo '$ test-expr -e '\''uint(16)'\'' -l 128'
test-expr -e 'uint(16)' -l 128 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l 128'

echo '$ test-expr -e '\''uint(16)'\'' -l '\''"128"'\'''
test-expr -e 'uint(16)' -l '"128"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l '\''"128"'\'''

echo '$ test-expr -e '\''uint(32)'\'' -l 128'
test-expr -e 'uint(32)' -l 128 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l 128'

echo '$ test-expr -e '\''uint(32)'\'' -l '\''"128"'\'''
test-expr -e 'uint(32)' -l '"128"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l '\''"128"'\'''

echo '$ test-expr -e '\''uint(64)'\'' -l 128'
test-expr -e 'uint(64)' -l 128 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l 128'

echo '$ test-expr -e '\''uint(64)'\'' -l '\''"128"'\'''
test-expr -e 'uint(64)' -l '"128"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l '\''"128"'\'''

echo '$ test-expr -e '\''int(8)'\'' -l -32769'
test-expr -e 'int(8)' -l -32769 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l -32769'

echo '$ test-expr -e '\''int(8)'\'' -l '\''"-32769"'\'''
test-expr -e 'int(8)' -l '"-32769"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l '\''"-32769"'\'''

echo '$ test-expr -e '\''int(16)'\'' -l -32769'
test-expr -e 'int(16)' -l -32769 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l -32769'

echo '$ test-expr -e '\''int(16)'\'' -l '\''"-32769"'\'''
test-expr -e 'int(16)' -l '"-32769"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l '\''"-32769"'\'''

echo '$ test-expr -e '\''int(32)'\'' -l -32769'
test-expr -e 'int(32)' -l -32769 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l -32769'

echo '$ test-expr -e '\''int(32)'\'' -l '\''"-32769"'\'''
test-expr -e 'int(32)' -l '"-32769"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l '\''"-32769"'\'''

echo '$ test-expr -e '\''int(64)'\'' -l -32769'
test-expr -e 'int(64)' -l -32769 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l -32769'

echo '$ test-expr -e '\''int(64)'\'' -l '\''"-32769"'\'''
test-expr -e 'int(64)' -l '"-32769"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l '\''"-32769"'\'''

echo '$ test-expr -e '\''uint(8)'\'' -l -32769'
test-expr -e 'uint(8)' -l -32769 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l -32769'

echo '$ test-expr -e '\''uint(8)'\'' -l '\''"-32769"'\'''
test-expr -e 'uint(8)' -l '"-32769"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l '\''"-32769"'\'''

echo '$ test-expr -e '\''uint(16)'\'' -l -32769'
test-expr -e 'uint(16)' -l -32769 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l -32769'

echo '$ test-expr -e '\''uint(16)'\'' -l '\''"-32769"'\'''
test-expr -e 'uint(16)' -l '"-32769"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l '\''"-32769"'\'''

echo '$ test-expr -e '\''uint(32)'\'' -l -32769'
test-expr -e 'uint(32)' -l -32769 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l -32769'

echo '$ test-expr -e '\''uint(32)'\'' -l '\''"-32769"'\'''
test-expr -e 'uint(32)' -l '"-32769"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l '\''"-32769"'\'''

echo '$ test-expr -e '\''uint(64)'\'' -l -32769'
test-expr -e 'uint(64)' -l -32769 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l -32769'

echo '$ test-expr -e '\''uint(64)'\'' -l '\''"-32769"'\'''
test-expr -e 'uint(64)' -l '"-32769"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l '\''"-32769"'\'''

echo '$ test-expr -e '\''int(8)'\'' -l -32768'
test-expr -e 'int(8)' -l -32768 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l -32768'

echo '$ test-expr -e '\''int(8)'\'' -l '\''"-32768"'\'''
test-expr -e 'int(8)' -l '"-32768"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l '\''"-32768"'\'''

echo '$ test-expr -e '\''int(16)'\'' -l -32768'
test-expr -e 'int(16)' -l -32768 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l -32768'

echo '$ test-expr -e '\''int(16)'\'' -l '\''"-32768"'\'''
test-expr -e 'int(16)' -l '"-32768"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l '\''"-32768"'\'''

echo '$ test-expr -e '\''int(32)'\'' -l -32768'
test-expr -e 'int(32)' -l -32768 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l -32768'

echo '$ test-expr -e '\''int(32)'\'' -l '\''"-32768"'\'''
test-expr -e 'int(32)' -l '"-32768"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l '\''"-32768"'\'''

echo '$ test-expr -e '\''int(64)'\'' -l -32768'
test-expr -e 'int(64)' -l -32768 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l -32768'

echo '$ test-expr -e '\''int(64)'\'' -l '\''"-32768"'\'''
test-expr -e 'int(64)' -l '"-32768"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l '\''"-32768"'\'''

echo '$ test-expr -e '\''uint(8)'\'' -l -32768'
test-expr -e 'uint(8)' -l -32768 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l -32768'

echo '$ test-expr -e '\''uint(8)'\'' -l '\''"-32768"'\'''
test-expr -e 'uint(8)' -l '"-32768"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l '\''"-32768"'\'''

echo '$ test-expr -e '\''uint(16)'\'' -l -32768'
test-expr -e 'uint(16)' -l -32768 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l -32768'

echo '$ test-expr -e '\''uint(16)'\'' -l '\''"-32768"'\'''
test-expr -e 'uint(16)' -l '"-32768"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l '\''"-32768"'\'''

echo '$ test-expr -e '\''uint(32)'\'' -l -32768'
test-expr -e 'uint(32)' -l -32768 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l -32768'

echo '$ test-expr -e '\''uint(32)'\'' -l '\''"-32768"'\'''
test-expr -e 'uint(32)' -l '"-32768"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l '\''"-32768"'\'''

echo '$ test-expr -e '\''uint(64)'\'' -l -32768'
test-expr -e 'uint(64)' -l -32768 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l -32768'

echo '$ test-expr -e '\''uint(64)'\'' -l '\''"-32768"'\'''
test-expr -e 'uint(64)' -l '"-32768"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l '\''"-32768"'\'''

echo '$ test-expr -e '\''int(8)'\'' -l -32767'
test-expr -e 'int(8)' -l -32767 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l -32767'

echo '$ test-expr -e '\''int(8)'\'' -l '\''"-32767"'\'''
test-expr -e 'int(8)' -l '"-32767"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l '\''"-32767"'\'''

echo '$ test-expr -e '\''int(16)'\'' -l -32767'
test-expr -e 'int(16)' -l -32767 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l -32767'

echo '$ test-expr -e '\''int(16)'\'' -l '\''"-32767"'\'''
test-expr -e 'int(16)' -l '"-32767"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l '\''"-32767"'\'''

echo '$ test-expr -e '\''int(32)'\'' -l -32767'
test-expr -e 'int(32)' -l -32767 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l -32767'

echo '$ test-expr -e '\''int(32)'\'' -l '\''"-32767"'\'''
test-expr -e 'int(32)' -l '"-32767"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l '\''"-32767"'\'''

echo '$ test-expr -e '\''int(64)'\'' -l -32767'
test-expr -e 'int(64)' -l -32767 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l -32767'

echo '$ test-expr -e '\''int(64)'\'' -l '\''"-32767"'\'''
test-expr -e 'int(64)' -l '"-32767"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l '\''"-32767"'\'''

echo '$ test-expr -e '\''uint(8)'\'' -l -32767'
test-expr -e 'uint(8)' -l -32767 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l -32767'

echo '$ test-expr -e '\''uint(8)'\'' -l '\''"-32767"'\'''
test-expr -e 'uint(8)' -l '"-32767"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l '\''"-32767"'\'''

echo '$ test-expr -e '\''uint(16)'\'' -l -32767'
test-expr -e 'uint(16)' -l -32767 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l -32767'

echo '$ test-expr -e '\''uint(16)'\'' -l '\''"-32767"'\'''
test-expr -e 'uint(16)' -l '"-32767"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l '\''"-32767"'\'''

echo '$ test-expr -e '\''uint(32)'\'' -l -32767'
test-expr -e 'uint(32)' -l -32767 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l -32767'

echo '$ test-expr -e '\''uint(32)'\'' -l '\''"-32767"'\'''
test-expr -e 'uint(32)' -l '"-32767"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l '\''"-32767"'\'''

echo '$ test-expr -e '\''uint(64)'\'' -l -32767'
test-expr -e 'uint(64)' -l -32767 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l -32767'

echo '$ test-expr -e '\''uint(64)'\'' -l '\''"-32767"'\'''
test-expr -e 'uint(64)' -l '"-32767"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l '\''"-32767"'\'''

echo '$ test-expr -e '\''int(8)'\'' -l 32766'
test-expr -e 'int(8)' -l 32766 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l 32766'

echo '$ test-expr -e '\''int(8)'\'' -l '\''"32766"'\'''
test-expr -e 'int(8)' -l '"32766"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l '\''"32766"'\'''

echo '$ test-expr -e '\''int(16)'\'' -l 32766'
test-expr -e 'int(16)' -l 32766 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l 32766'

echo '$ test-expr -e '\''int(16)'\'' -l '\''"32766"'\'''
test-expr -e 'int(16)' -l '"32766"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l '\''"32766"'\'''

echo '$ test-expr -e '\''int(32)'\'' -l 32766'
test-expr -e 'int(32)' -l 32766 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l 32766'

echo '$ test-expr -e '\''int(32)'\'' -l '\''"32766"'\'''
test-expr -e 'int(32)' -l '"32766"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l '\''"32766"'\'''

echo '$ test-expr -e '\''int(64)'\'' -l 32766'
test-expr -e 'int(64)' -l 32766 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l 32766'

echo '$ test-expr -e '\''int(64)'\'' -l '\''"32766"'\'''
test-expr -e 'int(64)' -l '"32766"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l '\''"32766"'\'''

echo '$ test-expr -e '\''uint(8)'\'' -l 32766'
test-expr -e 'uint(8)' -l 32766 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l 32766'

echo '$ test-expr -e '\''uint(8)'\'' -l '\''"32766"'\'''
test-expr -e 'uint(8)' -l '"32766"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l '\''"32766"'\'''

echo '$ test-expr -e '\''uint(16)'\'' -l 32766'
test-expr -e 'uint(16)' -l 32766 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l 32766'

echo '$ test-expr -e '\''uint(16)'\'' -l '\''"32766"'\'''
test-expr -e 'uint(16)' -l '"32766"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l '\''"32766"'\'''

echo '$ test-expr -e '\''uint(32)'\'' -l 32766'
test-expr -e 'uint(32)' -l 32766 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l 32766'

echo '$ test-expr -e '\''uint(32)'\'' -l '\''"32766"'\'''
test-expr -e 'uint(32)' -l '"32766"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l '\''"32766"'\'''

echo '$ test-expr -e '\''uint(64)'\'' -l 32766'
test-expr -e 'uint(64)' -l 32766 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l 32766'

echo '$ test-expr -e '\''uint(64)'\'' -l '\''"32766"'\'''
test-expr -e 'uint(64)' -l '"32766"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l '\''"32766"'\'''

echo '$ test-expr -e '\''int(8)'\'' -l 32767'
test-expr -e 'int(8)' -l 32767 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l 32767'

echo '$ test-expr -e '\''int(8)'\'' -l '\''"32767"'\'''
test-expr -e 'int(8)' -l '"32767"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l '\''"32767"'\'''

echo '$ test-expr -e '\''int(16)'\'' -l 32767'
test-expr -e 'int(16)' -l 32767 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l 32767'

echo '$ test-expr -e '\''int(16)'\'' -l '\''"32767"'\'''
test-expr -e 'int(16)' -l '"32767"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l '\''"32767"'\'''

echo '$ test-expr -e '\''int(32)'\'' -l 32767'
test-expr -e 'int(32)' -l 32767 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l 32767'

echo '$ test-expr -e '\''int(32)'\'' -l '\''"32767"'\'''
test-expr -e 'int(32)' -l '"32767"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l '\''"32767"'\'''

echo '$ test-expr -e '\''int(64)'\'' -l 32767'
test-expr -e 'int(64)' -l 32767 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l 32767'

echo '$ test-expr -e '\''int(64)'\'' -l '\''"32767"'\'''
test-expr -e 'int(64)' -l '"32767"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l '\''"32767"'\'''

echo '$ test-expr -e '\''uint(8)'\'' -l 32767'
test-expr -e 'uint(8)' -l 32767 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l 32767'

echo '$ test-expr -e '\''uint(8)'\'' -l '\''"32767"'\'''
test-expr -e 'uint(8)' -l '"32767"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l '\''"32767"'\'''

echo '$ test-expr -e '\''uint(16)'\'' -l 32767'
test-expr -e 'uint(16)' -l 32767 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l 32767'

echo '$ test-expr -e '\''uint(16)'\'' -l '\''"32767"'\'''
test-expr -e 'uint(16)' -l '"32767"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l '\''"32767"'\'''

echo '$ test-expr -e '\''uint(32)'\'' -l 32767'
test-expr -e 'uint(32)' -l 32767 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l 32767'

echo '$ test-expr -e '\''uint(32)'\'' -l '\''"32767"'\'''
test-expr -e 'uint(32)' -l '"32767"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l '\''"32767"'\'''

echo '$ test-expr -e '\''uint(64)'\'' -l 32767'
test-expr -e 'uint(64)' -l 32767 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l 32767'

echo '$ test-expr -e '\''uint(64)'\'' -l '\''"32767"'\'''
test-expr -e 'uint(64)' -l '"32767"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l '\''"32767"'\'''

echo '$ test-expr -e '\''int(8)'\'' -l 32768'
test-expr -e 'int(8)' -l 32768 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l 32768'

echo '$ test-expr -e '\''int(8)'\'' -l '\''"32768"'\'''
test-expr -e 'int(8)' -l '"32768"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l '\''"32768"'\'''

echo '$ test-expr -e '\''int(16)'\'' -l 32768'
test-expr -e 'int(16)' -l 32768 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l 32768'

echo '$ test-expr -e '\''int(16)'\'' -l '\''"32768"'\'''
test-expr -e 'int(16)' -l '"32768"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l '\''"32768"'\'''

echo '$ test-expr -e '\''int(32)'\'' -l 32768'
test-expr -e 'int(32)' -l 32768 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l 32768'

echo '$ test-expr -e '\''int(32)'\'' -l '\''"32768"'\'''
test-expr -e 'int(32)' -l '"32768"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l '\''"32768"'\'''

echo '$ test-expr -e '\''int(64)'\'' -l 32768'
test-expr -e 'int(64)' -l 32768 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l 32768'

echo '$ test-expr -e '\''int(64)'\'' -l '\''"32768"'\'''
test-expr -e 'int(64)' -l '"32768"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l '\''"32768"'\'''

echo '$ test-expr -e '\''uint(8)'\'' -l 32768'
test-expr -e 'uint(8)' -l 32768 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l 32768'

echo '$ test-expr -e '\''uint(8)'\'' -l '\''"32768"'\'''
test-expr -e 'uint(8)' -l '"32768"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l '\''"32768"'\'''

echo '$ test-expr -e '\''uint(16)'\'' -l 32768'
test-expr -e 'uint(16)' -l 32768 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l 32768'

echo '$ test-expr -e '\''uint(16)'\'' -l '\''"32768"'\'''
test-expr -e 'uint(16)' -l '"32768"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l '\''"32768"'\'''

echo '$ test-expr -e '\''uint(32)'\'' -l 32768'
test-expr -e 'uint(32)' -l 32768 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l 32768'

echo '$ test-expr -e '\''uint(32)'\'' -l '\''"32768"'\'''
test-expr -e 'uint(32)' -l '"32768"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l '\''"32768"'\'''

echo '$ test-expr -e '\''uint(64)'\'' -l 32768'
test-expr -e 'uint(64)' -l 32768 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l 32768'

echo '$ test-expr -e '\''uint(64)'\'' -l '\''"32768"'\'''
test-expr -e 'uint(64)' -l '"32768"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l '\''"32768"'\'''

echo '$ test-expr -e '\''int(8)'\'' -l -2147483649'
test-expr -e 'int(8)' -l -2147483649 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l -2147483649'

echo '$ test-expr -e '\''int(8)'\'' -l '\''"-2147483649"'\'''
test-expr -e 'int(8)' -l '"-2147483649"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l '\''"-2147483649"'\'''

echo '$ test-expr -e '\''int(16)'\'' -l -2147483649'
test-expr -e 'int(16)' -l -2147483649 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l -2147483649'

echo '$ test-expr -e '\''int(16)'\'' -l '\''"-2147483649"'\'''
test-expr -e 'int(16)' -l '"-2147483649"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l '\''"-2147483649"'\'''

echo '$ test-expr -e '\''int(32)'\'' -l -2147483649'
test-expr -e 'int(32)' -l -2147483649 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l -2147483649'

echo '$ test-expr -e '\''int(32)'\'' -l '\''"-2147483649"'\'''
test-expr -e 'int(32)' -l '"-2147483649"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l '\''"-2147483649"'\'''

echo '$ test-expr -e '\''int(64)'\'' -l -2147483649'
test-expr -e 'int(64)' -l -2147483649 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l -2147483649'

echo '$ test-expr -e '\''int(64)'\'' -l '\''"-2147483649"'\'''
test-expr -e 'int(64)' -l '"-2147483649"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l '\''"-2147483649"'\'''

echo '$ test-expr -e '\''uint(8)'\'' -l -2147483649'
test-expr -e 'uint(8)' -l -2147483649 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l -2147483649'

echo '$ test-expr -e '\''uint(8)'\'' -l '\''"-2147483649"'\'''
test-expr -e 'uint(8)' -l '"-2147483649"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l '\''"-2147483649"'\'''

echo '$ test-expr -e '\''uint(16)'\'' -l -2147483649'
test-expr -e 'uint(16)' -l -2147483649 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l -2147483649'

echo '$ test-expr -e '\''uint(16)'\'' -l '\''"-2147483649"'\'''
test-expr -e 'uint(16)' -l '"-2147483649"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l '\''"-2147483649"'\'''

echo '$ test-expr -e '\''uint(32)'\'' -l -2147483649'
test-expr -e 'uint(32)' -l -2147483649 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l -2147483649'

echo '$ test-expr -e '\''uint(32)'\'' -l '\''"-2147483649"'\'''
test-expr -e 'uint(32)' -l '"-2147483649"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l '\''"-2147483649"'\'''

echo '$ test-expr -e '\''uint(64)'\'' -l -2147483649'
test-expr -e 'uint(64)' -l -2147483649 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l -2147483649'

echo '$ test-expr -e '\''uint(64)'\'' -l '\''"-2147483649"'\'''
test-expr -e 'uint(64)' -l '"-2147483649"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l '\''"-2147483649"'\'''

echo '$ test-expr -e '\''int(8)'\'' -l -2147483648'
test-expr -e 'int(8)' -l -2147483648 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l -2147483648'

echo '$ test-expr -e '\''int(8)'\'' -l '\''"-2147483648"'\'''
test-expr -e 'int(8)' -l '"-2147483648"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l '\''"-2147483648"'\'''

echo '$ test-expr -e '\''int(16)'\'' -l -2147483648'
test-expr -e 'int(16)' -l -2147483648 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l -2147483648'

echo '$ test-expr -e '\''int(16)'\'' -l '\''"-2147483648"'\'''
test-expr -e 'int(16)' -l '"-2147483648"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l '\''"-2147483648"'\'''

echo '$ test-expr -e '\''int(32)'\'' -l -2147483648'
test-expr -e 'int(32)' -l -2147483648 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l -2147483648'

echo '$ test-expr -e '\''int(32)'\'' -l '\''"-2147483648"'\'''
test-expr -e 'int(32)' -l '"-2147483648"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l '\''"-2147483648"'\'''

echo '$ test-expr -e '\''int(64)'\'' -l -2147483648'
test-expr -e 'int(64)' -l -2147483648 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l -2147483648'

echo '$ test-expr -e '\''int(64)'\'' -l '\''"-2147483648"'\'''
test-expr -e 'int(64)' -l '"-2147483648"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l '\''"-2147483648"'\'''

echo '$ test-expr -e '\''uint(8)'\'' -l -2147483648'
test-expr -e 'uint(8)' -l -2147483648 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l -2147483648'

echo '$ test-expr -e '\''uint(8)'\'' -l '\''"-2147483648"'\'''
test-expr -e 'uint(8)' -l '"-2147483648"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l '\''"-2147483648"'\'''

echo '$ test-expr -e '\''uint(16)'\'' -l -2147483648'
test-expr -e 'uint(16)' -l -2147483648 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l -2147483648'

echo '$ test-expr -e '\''uint(16)'\'' -l '\''"-2147483648"'\'''
test-expr -e 'uint(16)' -l '"-2147483648"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l '\''"-2147483648"'\'''

echo '$ test-expr -e '\''uint(32)'\'' -l -2147483648'
test-expr -e 'uint(32)' -l -2147483648 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l -2147483648'

echo '$ test-expr -e '\''uint(32)'\'' -l '\''"-2147483648"'\'''
test-expr -e 'uint(32)' -l '"-2147483648"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l '\''"-2147483648"'\'''

echo '$ test-expr -e '\''uint(64)'\'' -l -2147483648'
test-expr -e 'uint(64)' -l -2147483648 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l -2147483648'

echo '$ test-expr -e '\''uint(64)'\'' -l '\''"-2147483648"'\'''
test-expr -e 'uint(64)' -l '"-2147483648"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l '\''"-2147483648"'\'''

echo '$ test-expr -e '\''int(8)'\'' -l -2147483647'
test-expr -e 'int(8)' -l -2147483647 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l -2147483647'

echo '$ test-expr -e '\''int(8)'\'' -l '\''"-2147483647"'\'''
test-expr -e 'int(8)' -l '"-2147483647"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l '\''"-2147483647"'\'''

echo '$ test-expr -e '\''int(16)'\'' -l -2147483647'
test-expr -e 'int(16)' -l -2147483647 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l -2147483647'

echo '$ test-expr -e '\''int(16)'\'' -l '\''"-2147483647"'\'''
test-expr -e 'int(16)' -l '"-2147483647"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l '\''"-2147483647"'\'''

echo '$ test-expr -e '\''int(32)'\'' -l -2147483647'
test-expr -e 'int(32)' -l -2147483647 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l -2147483647'

echo '$ test-expr -e '\''int(32)'\'' -l '\''"-2147483647"'\'''
test-expr -e 'int(32)' -l '"-2147483647"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l '\''"-2147483647"'\'''

echo '$ test-expr -e '\''int(64)'\'' -l -2147483647'
test-expr -e 'int(64)' -l -2147483647 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l -2147483647'

echo '$ test-expr -e '\''int(64)'\'' -l '\''"-2147483647"'\'''
test-expr -e 'int(64)' -l '"-2147483647"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l '\''"-2147483647"'\'''

echo '$ test-expr -e '\''uint(8)'\'' -l -2147483647'
test-expr -e 'uint(8)' -l -2147483647 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l -2147483647'

echo '$ test-expr -e '\''uint(8)'\'' -l '\''"-2147483647"'\'''
test-expr -e 'uint(8)' -l '"-2147483647"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l '\''"-2147483647"'\'''

echo '$ test-expr -e '\''uint(16)'\'' -l -2147483647'
test-expr -e 'uint(16)' -l -2147483647 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l -2147483647'

echo '$ test-expr -e '\''uint(16)'\'' -l '\''"-2147483647"'\'''
test-expr -e 'uint(16)' -l '"-2147483647"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l '\''"-2147483647"'\'''

echo '$ test-expr -e '\''uint(32)'\'' -l -2147483647'
test-expr -e 'uint(32)' -l -2147483647 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l -2147483647'

echo '$ test-expr -e '\''uint(32)'\'' -l '\''"-2147483647"'\'''
test-expr -e 'uint(32)' -l '"-2147483647"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l '\''"-2147483647"'\'''

echo '$ test-expr -e '\''uint(64)'\'' -l -2147483647'
test-expr -e 'uint(64)' -l -2147483647 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l -2147483647'

echo '$ test-expr -e '\''uint(64)'\'' -l '\''"-2147483647"'\'''
test-expr -e 'uint(64)' -l '"-2147483647"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l '\''"-2147483647"'\'''

echo '$ test-expr -e '\''int(8)'\'' -l 2147483646'
test-expr -e 'int(8)' -l 2147483646 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l 2147483646'

echo '$ test-expr -e '\''int(8)'\'' -l '\''"2147483646"'\'''
test-expr -e 'int(8)' -l '"2147483646"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l '\''"2147483646"'\'''

echo '$ test-expr -e '\''int(16)'\'' -l 2147483646'
test-expr -e 'int(16)' -l 2147483646 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l 2147483646'

echo '$ test-expr -e '\''int(16)'\'' -l '\''"2147483646"'\'''
test-expr -e 'int(16)' -l '"2147483646"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l '\''"2147483646"'\'''

echo '$ test-expr -e '\''int(32)'\'' -l 2147483646'
test-expr -e 'int(32)' -l 2147483646 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l 2147483646'

echo '$ test-expr -e '\''int(32)'\'' -l '\''"2147483646"'\'''
test-expr -e 'int(32)' -l '"2147483646"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l '\''"2147483646"'\'''

echo '$ test-expr -e '\''int(64)'\'' -l 2147483646'
test-expr -e 'int(64)' -l 2147483646 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l 2147483646'

echo '$ test-expr -e '\''int(64)'\'' -l '\''"2147483646"'\'''
test-expr -e 'int(64)' -l '"2147483646"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l '\''"2147483646"'\'''

echo '$ test-expr -e '\''uint(8)'\'' -l 2147483646'
test-expr -e 'uint(8)' -l 2147483646 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l 2147483646'

echo '$ test-expr -e '\''uint(8)'\'' -l '\''"2147483646"'\'''
test-expr -e 'uint(8)' -l '"2147483646"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l '\''"2147483646"'\'''

echo '$ test-expr -e '\''uint(16)'\'' -l 2147483646'
test-expr -e 'uint(16)' -l 2147483646 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l 2147483646'

echo '$ test-expr -e '\''uint(16)'\'' -l '\''"2147483646"'\'''
test-expr -e 'uint(16)' -l '"2147483646"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l '\''"2147483646"'\'''

echo '$ test-expr -e '\''uint(32)'\'' -l 2147483646'
test-expr -e 'uint(32)' -l 2147483646 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l 2147483646'

echo '$ test-expr -e '\''uint(32)'\'' -l '\''"2147483646"'\'''
test-expr -e 'uint(32)' -l '"2147483646"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l '\''"2147483646"'\'''

echo '$ test-expr -e '\''uint(64)'\'' -l 2147483646'
test-expr -e 'uint(64)' -l 2147483646 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l 2147483646'

echo '$ test-expr -e '\''uint(64)'\'' -l '\''"2147483646"'\'''
test-expr -e 'uint(64)' -l '"2147483646"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l '\''"2147483646"'\'''

echo '$ test-expr -e '\''int(8)'\'' -l 2147483647'
test-expr -e 'int(8)' -l 2147483647 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l 2147483647'

echo '$ test-expr -e '\''int(8)'\'' -l '\''"2147483647"'\'''
test-expr -e 'int(8)' -l '"2147483647"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l '\''"2147483647"'\'''

echo '$ test-expr -e '\''int(16)'\'' -l 2147483647'
test-expr -e 'int(16)' -l 2147483647 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l 2147483647'

echo '$ test-expr -e '\''int(16)'\'' -l '\''"2147483647"'\'''
test-expr -e 'int(16)' -l '"2147483647"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l '\''"2147483647"'\'''

echo '$ test-expr -e '\''int(32)'\'' -l 2147483647'
test-expr -e 'int(32)' -l 2147483647 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l 2147483647'

echo '$ test-expr -e '\''int(32)'\'' -l '\''"2147483647"'\'''
test-expr -e 'int(32)' -l '"2147483647"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l '\''"2147483647"'\'''

echo '$ test-expr -e '\''int(64)'\'' -l 2147483647'
test-expr -e 'int(64)' -l 2147483647 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l 2147483647'

echo '$ test-expr -e '\''int(64)'\'' -l '\''"2147483647"'\'''
test-expr -e 'int(64)' -l '"2147483647"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l '\''"2147483647"'\'''

echo '$ test-expr -e '\''uint(8)'\'' -l 2147483647'
test-expr -e 'uint(8)' -l 2147483647 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l 2147483647'

echo '$ test-expr -e '\''uint(8)'\'' -l '\''"2147483647"'\'''
test-expr -e 'uint(8)' -l '"2147483647"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l '\''"2147483647"'\'''

echo '$ test-expr -e '\''uint(16)'\'' -l 2147483647'
test-expr -e 'uint(16)' -l 2147483647 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l 2147483647'

echo '$ test-expr -e '\''uint(16)'\'' -l '\''"2147483647"'\'''
test-expr -e 'uint(16)' -l '"2147483647"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l '\''"2147483647"'\'''

echo '$ test-expr -e '\''uint(32)'\'' -l 2147483647'
test-expr -e 'uint(32)' -l 2147483647 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l 2147483647'

echo '$ test-expr -e '\''uint(32)'\'' -l '\''"2147483647"'\'''
test-expr -e 'uint(32)' -l '"2147483647"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l '\''"2147483647"'\'''

echo '$ test-expr -e '\''uint(64)'\'' -l 2147483647'
test-expr -e 'uint(64)' -l 2147483647 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l 2147483647'

echo '$ test-expr -e '\''uint(64)'\'' -l '\''"2147483647"'\'''
test-expr -e 'uint(64)' -l '"2147483647"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l '\''"2147483647"'\'''

echo '$ test-expr -e '\''int(8)'\'' -l 2147483648'
test-expr -e 'int(8)' -l 2147483648 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l 2147483648'

echo '$ test-expr -e '\''int(8)'\'' -l '\''"2147483648"'\'''
test-expr -e 'int(8)' -l '"2147483648"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l '\''"2147483648"'\'''

echo '$ test-expr -e '\''int(16)'\'' -l 2147483648'
test-expr -e 'int(16)' -l 2147483648 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l 2147483648'

echo '$ test-expr -e '\''int(16)'\'' -l '\''"2147483648"'\'''
test-expr -e 'int(16)' -l '"2147483648"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l '\''"2147483648"'\'''

echo '$ test-expr -e '\''int(32)'\'' -l 2147483648'
test-expr -e 'int(32)' -l 2147483648 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l 2147483648'

echo '$ test-expr -e '\''int(32)'\'' -l '\''"2147483648"'\'''
test-expr -e 'int(32)' -l '"2147483648"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l '\''"2147483648"'\'''

echo '$ test-expr -e '\''int(64)'\'' -l 2147483648'
test-expr -e 'int(64)' -l 2147483648 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l 2147483648'

echo '$ test-expr -e '\''int(64)'\'' -l '\''"2147483648"'\'''
test-expr -e 'int(64)' -l '"2147483648"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l '\''"2147483648"'\'''

echo '$ test-expr -e '\''uint(8)'\'' -l 2147483648'
test-expr -e 'uint(8)' -l 2147483648 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l 2147483648'

echo '$ test-expr -e '\''uint(8)'\'' -l '\''"2147483648"'\'''
test-expr -e 'uint(8)' -l '"2147483648"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l '\''"2147483648"'\'''

echo '$ test-expr -e '\''uint(16)'\'' -l 2147483648'
test-expr -e 'uint(16)' -l 2147483648 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l 2147483648'

echo '$ test-expr -e '\''uint(16)'\'' -l '\''"2147483648"'\'''
test-expr -e 'uint(16)' -l '"2147483648"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l '\''"2147483648"'\'''

echo '$ test-expr -e '\''uint(32)'\'' -l 2147483648'
test-expr -e 'uint(32)' -l 2147483648 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l 2147483648'

echo '$ test-expr -e '\''uint(32)'\'' -l '\''"2147483648"'\'''
test-expr -e 'uint(32)' -l '"2147483648"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l '\''"2147483648"'\'''

echo '$ test-expr -e '\''uint(64)'\'' -l 2147483648'
test-expr -e 'uint(64)' -l 2147483648 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l 2147483648'

echo '$ test-expr -e '\''uint(64)'\'' -l '\''"2147483648"'\'''
test-expr -e 'uint(64)' -l '"2147483648"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l '\''"2147483648"'\'''

echo '$ test-expr -e '\''int(8)'\'' -l -9223372036854775809'
test-expr -e 'int(8)' -l -9223372036854775809 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l -9223372036854775809'

echo '$ test-expr -e '\''int(8)'\'' -l '\''"-9223372036854775809"'\'''
test-expr -e 'int(8)' -l '"-9223372036854775809"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l '\''"-9223372036854775809"'\'''

echo '$ test-expr -e '\''int(16)'\'' -l -9223372036854775809'
test-expr -e 'int(16)' -l -9223372036854775809 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l -9223372036854775809'

echo '$ test-expr -e '\''int(16)'\'' -l '\''"-9223372036854775809"'\'''
test-expr -e 'int(16)' -l '"-9223372036854775809"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l '\''"-9223372036854775809"'\'''

echo '$ test-expr -e '\''int(32)'\'' -l -9223372036854775809'
test-expr -e 'int(32)' -l -9223372036854775809 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l -9223372036854775809'

echo '$ test-expr -e '\''int(32)'\'' -l '\''"-9223372036854775809"'\'''
test-expr -e 'int(32)' -l '"-9223372036854775809"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l '\''"-9223372036854775809"'\'''

echo '$ test-expr -e '\''int(64)'\'' -l -9223372036854775809'
test-expr -e 'int(64)' -l -9223372036854775809 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l -9223372036854775809'

echo '$ test-expr -e '\''int(64)'\'' -l '\''"-9223372036854775809"'\'''
test-expr -e 'int(64)' -l '"-9223372036854775809"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l '\''"-9223372036854775809"'\'''

echo '$ test-expr -e '\''uint(8)'\'' -l -9223372036854775809'
test-expr -e 'uint(8)' -l -9223372036854775809 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l -9223372036854775809'

echo '$ test-expr -e '\''uint(8)'\'' -l '\''"-9223372036854775809"'\'''
test-expr -e 'uint(8)' -l '"-9223372036854775809"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l '\''"-9223372036854775809"'\'''

echo '$ test-expr -e '\''uint(16)'\'' -l -9223372036854775809'
test-expr -e 'uint(16)' -l -9223372036854775809 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l -9223372036854775809'

echo '$ test-expr -e '\''uint(16)'\'' -l '\''"-9223372036854775809"'\'''
test-expr -e 'uint(16)' -l '"-9223372036854775809"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l '\''"-9223372036854775809"'\'''

echo '$ test-expr -e '\''uint(32)'\'' -l -9223372036854775809'
test-expr -e 'uint(32)' -l -9223372036854775809 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l -9223372036854775809'

echo '$ test-expr -e '\''uint(32)'\'' -l '\''"-9223372036854775809"'\'''
test-expr -e 'uint(32)' -l '"-9223372036854775809"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l '\''"-9223372036854775809"'\'''

echo '$ test-expr -e '\''uint(64)'\'' -l -9223372036854775809'
test-expr -e 'uint(64)' -l -9223372036854775809 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l -9223372036854775809'

echo '$ test-expr -e '\''uint(64)'\'' -l '\''"-9223372036854775809"'\'''
test-expr -e 'uint(64)' -l '"-9223372036854775809"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l '\''"-9223372036854775809"'\'''

echo '$ test-expr -e '\''int(8)'\'' -l -9223372036854775808'
test-expr -e 'int(8)' -l -9223372036854775808 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l -9223372036854775808'

echo '$ test-expr -e '\''int(8)'\'' -l '\''"-9223372036854775808"'\'''
test-expr -e 'int(8)' -l '"-9223372036854775808"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l '\''"-9223372036854775808"'\'''

echo '$ test-expr -e '\''int(16)'\'' -l -9223372036854775808'
test-expr -e 'int(16)' -l -9223372036854775808 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l -9223372036854775808'

echo '$ test-expr -e '\''int(16)'\'' -l '\''"-9223372036854775808"'\'''
test-expr -e 'int(16)' -l '"-9223372036854775808"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l '\''"-9223372036854775808"'\'''

echo '$ test-expr -e '\''int(32)'\'' -l -9223372036854775808'
test-expr -e 'int(32)' -l -9223372036854775808 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l -9223372036854775808'

echo '$ test-expr -e '\''int(32)'\'' -l '\''"-9223372036854775808"'\'''
test-expr -e 'int(32)' -l '"-9223372036854775808"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l '\''"-9223372036854775808"'\'''

echo '$ test-expr -e '\''int(64)'\'' -l -9223372036854775808'
test-expr -e 'int(64)' -l -9223372036854775808 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l -9223372036854775808'

echo '$ test-expr -e '\''int(64)'\'' -l '\''"-9223372036854775808"'\'''
test-expr -e 'int(64)' -l '"-9223372036854775808"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l '\''"-9223372036854775808"'\'''

echo '$ test-expr -e '\''uint(8)'\'' -l -9223372036854775808'
test-expr -e 'uint(8)' -l -9223372036854775808 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l -9223372036854775808'

echo '$ test-expr -e '\''uint(8)'\'' -l '\''"-9223372036854775808"'\'''
test-expr -e 'uint(8)' -l '"-9223372036854775808"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l '\''"-9223372036854775808"'\'''

echo '$ test-expr -e '\''uint(16)'\'' -l -9223372036854775808'
test-expr -e 'uint(16)' -l -9223372036854775808 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l -9223372036854775808'

echo '$ test-expr -e '\''uint(16)'\'' -l '\''"-9223372036854775808"'\'''
test-expr -e 'uint(16)' -l '"-9223372036854775808"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l '\''"-9223372036854775808"'\'''

echo '$ test-expr -e '\''uint(32)'\'' -l -9223372036854775808'
test-expr -e 'uint(32)' -l -9223372036854775808 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l -9223372036854775808'

echo '$ test-expr -e '\''uint(32)'\'' -l '\''"-9223372036854775808"'\'''
test-expr -e 'uint(32)' -l '"-9223372036854775808"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l '\''"-9223372036854775808"'\'''

echo '$ test-expr -e '\''uint(64)'\'' -l -9223372036854775808'
test-expr -e 'uint(64)' -l -9223372036854775808 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l -9223372036854775808'

echo '$ test-expr -e '\''uint(64)'\'' -l '\''"-9223372036854775808"'\'''
test-expr -e 'uint(64)' -l '"-9223372036854775808"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l '\''"-9223372036854775808"'\'''

echo '$ test-expr -e '\''int(8)'\'' -l -9223372036854775807'
test-expr -e 'int(8)' -l -9223372036854775807 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l -9223372036854775807'

echo '$ test-expr -e '\''int(8)'\'' -l '\''"-9223372036854775807"'\'''
test-expr -e 'int(8)' -l '"-9223372036854775807"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l '\''"-9223372036854775807"'\'''

echo '$ test-expr -e '\''int(16)'\'' -l -9223372036854775807'
test-expr -e 'int(16)' -l -9223372036854775807 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l -9223372036854775807'

echo '$ test-expr -e '\''int(16)'\'' -l '\''"-9223372036854775807"'\'''
test-expr -e 'int(16)' -l '"-9223372036854775807"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l '\''"-9223372036854775807"'\'''

echo '$ test-expr -e '\''int(32)'\'' -l -9223372036854775807'
test-expr -e 'int(32)' -l -9223372036854775807 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l -9223372036854775807'

echo '$ test-expr -e '\''int(32)'\'' -l '\''"-9223372036854775807"'\'''
test-expr -e 'int(32)' -l '"-9223372036854775807"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l '\''"-9223372036854775807"'\'''

echo '$ test-expr -e '\''int(64)'\'' -l -9223372036854775807'
test-expr -e 'int(64)' -l -9223372036854775807 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l -9223372036854775807'

echo '$ test-expr -e '\''int(64)'\'' -l '\''"-9223372036854775807"'\'''
test-expr -e 'int(64)' -l '"-9223372036854775807"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l '\''"-9223372036854775807"'\'''

echo '$ test-expr -e '\''uint(8)'\'' -l -9223372036854775807'
test-expr -e 'uint(8)' -l -9223372036854775807 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l -9223372036854775807'

echo '$ test-expr -e '\''uint(8)'\'' -l '\''"-9223372036854775807"'\'''
test-expr -e 'uint(8)' -l '"-9223372036854775807"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l '\''"-9223372036854775807"'\'''

echo '$ test-expr -e '\''uint(16)'\'' -l -9223372036854775807'
test-expr -e 'uint(16)' -l -9223372036854775807 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l -9223372036854775807'

echo '$ test-expr -e '\''uint(16)'\'' -l '\''"-9223372036854775807"'\'''
test-expr -e 'uint(16)' -l '"-9223372036854775807"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l '\''"-9223372036854775807"'\'''

echo '$ test-expr -e '\''uint(32)'\'' -l -9223372036854775807'
test-expr -e 'uint(32)' -l -9223372036854775807 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l -9223372036854775807'

echo '$ test-expr -e '\''uint(32)'\'' -l '\''"-9223372036854775807"'\'''
test-expr -e 'uint(32)' -l '"-9223372036854775807"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l '\''"-9223372036854775807"'\'''

echo '$ test-expr -e '\''uint(64)'\'' -l -9223372036854775807'
test-expr -e 'uint(64)' -l -9223372036854775807 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l -9223372036854775807'

echo '$ test-expr -e '\''uint(64)'\'' -l '\''"-9223372036854775807"'\'''
test-expr -e 'uint(64)' -l '"-9223372036854775807"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l '\''"-9223372036854775807"'\'''

echo '$ test-expr -e '\''int(8)'\'' -l 9223372036854775806'
test-expr -e 'int(8)' -l 9223372036854775806 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l 9223372036854775806'

echo '$ test-expr -e '\''int(8)'\'' -l '\''"9223372036854775806"'\'''
test-expr -e 'int(8)' -l '"9223372036854775806"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l '\''"9223372036854775806"'\'''

echo '$ test-expr -e '\''int(16)'\'' -l 9223372036854775806'
test-expr -e 'int(16)' -l 9223372036854775806 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l 9223372036854775806'

echo '$ test-expr -e '\''int(16)'\'' -l '\''"9223372036854775806"'\'''
test-expr -e 'int(16)' -l '"9223372036854775806"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l '\''"9223372036854775806"'\'''

echo '$ test-expr -e '\''int(32)'\'' -l 9223372036854775806'
test-expr -e 'int(32)' -l 9223372036854775806 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l 9223372036854775806'

echo '$ test-expr -e '\''int(32)'\'' -l '\''"9223372036854775806"'\'''
test-expr -e 'int(32)' -l '"9223372036854775806"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l '\''"9223372036854775806"'\'''

echo '$ test-expr -e '\''int(64)'\'' -l 9223372036854775806'
test-expr -e 'int(64)' -l 9223372036854775806 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l 9223372036854775806'

echo '$ test-expr -e '\''int(64)'\'' -l '\''"9223372036854775806"'\'''
test-expr -e 'int(64)' -l '"9223372036854775806"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l '\''"9223372036854775806"'\'''

echo '$ test-expr -e '\''uint(8)'\'' -l 9223372036854775806'
test-expr -e 'uint(8)' -l 9223372036854775806 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l 9223372036854775806'

echo '$ test-expr -e '\''uint(8)'\'' -l '\''"9223372036854775806"'\'''
test-expr -e 'uint(8)' -l '"9223372036854775806"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l '\''"9223372036854775806"'\'''

echo '$ test-expr -e '\''uint(16)'\'' -l 9223372036854775806'
test-expr -e 'uint(16)' -l 9223372036854775806 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l 9223372036854775806'

echo '$ test-expr -e '\''uint(16)'\'' -l '\''"9223372036854775806"'\'''
test-expr -e 'uint(16)' -l '"9223372036854775806"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l '\''"9223372036854775806"'\'''

echo '$ test-expr -e '\''uint(32)'\'' -l 9223372036854775806'
test-expr -e 'uint(32)' -l 9223372036854775806 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l 9223372036854775806'

echo '$ test-expr -e '\''uint(32)'\'' -l '\''"9223372036854775806"'\'''
test-expr -e 'uint(32)' -l '"9223372036854775806"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l '\''"9223372036854775806"'\'''

echo '$ test-expr -e '\''uint(64)'\'' -l 9223372036854775806'
test-expr -e 'uint(64)' -l 9223372036854775806 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l 9223372036854775806'

echo '$ test-expr -e '\''uint(64)'\'' -l '\''"9223372036854775806"'\'''
test-expr -e 'uint(64)' -l '"9223372036854775806"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l '\''"9223372036854775806"'\'''

echo '$ test-expr -e '\''int(8)'\'' -l 9223372036854775807'
test-expr -e 'int(8)' -l 9223372036854775807 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l 9223372036854775807'

echo '$ test-expr -e '\''int(8)'\'' -l '\''"9223372036854775807"'\'''
test-expr -e 'int(8)' -l '"9223372036854775807"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l '\''"9223372036854775807"'\'''

echo '$ test-expr -e '\''int(16)'\'' -l 9223372036854775807'
test-expr -e 'int(16)' -l 9223372036854775807 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l 9223372036854775807'

echo '$ test-expr -e '\''int(16)'\'' -l '\''"9223372036854775807"'\'''
test-expr -e 'int(16)' -l '"9223372036854775807"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l '\''"9223372036854775807"'\'''

echo '$ test-expr -e '\''int(32)'\'' -l 9223372036854775807'
test-expr -e 'int(32)' -l 9223372036854775807 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l 9223372036854775807'

echo '$ test-expr -e '\''int(32)'\'' -l '\''"9223372036854775807"'\'''
test-expr -e 'int(32)' -l '"9223372036854775807"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l '\''"9223372036854775807"'\'''

echo '$ test-expr -e '\''int(64)'\'' -l 9223372036854775807'
test-expr -e 'int(64)' -l 9223372036854775807 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l 9223372036854775807'

echo '$ test-expr -e '\''int(64)'\'' -l '\''"9223372036854775807"'\'''
test-expr -e 'int(64)' -l '"9223372036854775807"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l '\''"9223372036854775807"'\'''

echo '$ test-expr -e '\''uint(8)'\'' -l 9223372036854775807'
test-expr -e 'uint(8)' -l 9223372036854775807 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l 9223372036854775807'

echo '$ test-expr -e '\''uint(8)'\'' -l '\''"9223372036854775807"'\'''
test-expr -e 'uint(8)' -l '"9223372036854775807"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l '\''"9223372036854775807"'\'''

echo '$ test-expr -e '\''uint(16)'\'' -l 9223372036854775807'
test-expr -e 'uint(16)' -l 9223372036854775807 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l 9223372036854775807'

echo '$ test-expr -e '\''uint(16)'\'' -l '\''"9223372036854775807"'\'''
test-expr -e 'uint(16)' -l '"9223372036854775807"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l '\''"9223372036854775807"'\'''

echo '$ test-expr -e '\''uint(32)'\'' -l 9223372036854775807'
test-expr -e 'uint(32)' -l 9223372036854775807 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l 9223372036854775807'

echo '$ test-expr -e '\''uint(32)'\'' -l '\''"9223372036854775807"'\'''
test-expr -e 'uint(32)' -l '"9223372036854775807"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l '\''"9223372036854775807"'\'''

echo '$ test-expr -e '\''uint(64)'\'' -l 9223372036854775807'
test-expr -e 'uint(64)' -l 9223372036854775807 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l 9223372036854775807'

echo '$ test-expr -e '\''uint(64)'\'' -l '\''"9223372036854775807"'\'''
test-expr -e 'uint(64)' -l '"9223372036854775807"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l '\''"9223372036854775807"'\'''

echo '$ test-expr -e '\''int(8)'\'' -l 9223372036854775808'
test-expr -e 'int(8)' -l 9223372036854775808 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l 9223372036854775808'

echo '$ test-expr -e '\''int(8)'\'' -l '\''"9223372036854775808"'\'''
test-expr -e 'int(8)' -l '"9223372036854775808"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l '\''"9223372036854775808"'\'''

echo '$ test-expr -e '\''int(16)'\'' -l 9223372036854775808'
test-expr -e 'int(16)' -l 9223372036854775808 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l 9223372036854775808'

echo '$ test-expr -e '\''int(16)'\'' -l '\''"9223372036854775808"'\'''
test-expr -e 'int(16)' -l '"9223372036854775808"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l '\''"9223372036854775808"'\'''

echo '$ test-expr -e '\''int(32)'\'' -l 9223372036854775808'
test-expr -e 'int(32)' -l 9223372036854775808 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l 9223372036854775808'

echo '$ test-expr -e '\''int(32)'\'' -l '\''"9223372036854775808"'\'''
test-expr -e 'int(32)' -l '"9223372036854775808"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l '\''"9223372036854775808"'\'''

echo '$ test-expr -e '\''int(64)'\'' -l 9223372036854775808'
test-expr -e 'int(64)' -l 9223372036854775808 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l 9223372036854775808'

echo '$ test-expr -e '\''int(64)'\'' -l '\''"9223372036854775808"'\'''
test-expr -e 'int(64)' -l '"9223372036854775808"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l '\''"9223372036854775808"'\'''

echo '$ test-expr -e '\''uint(8)'\'' -l 9223372036854775808'
test-expr -e 'uint(8)' -l 9223372036854775808 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l 9223372036854775808'

echo '$ test-expr -e '\''uint(8)'\'' -l '\''"9223372036854775808"'\'''
test-expr -e 'uint(8)' -l '"9223372036854775808"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l '\''"9223372036854775808"'\'''

echo '$ test-expr -e '\''uint(16)'\'' -l 9223372036854775808'
test-expr -e 'uint(16)' -l 9223372036854775808 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l 9223372036854775808'

echo '$ test-expr -e '\''uint(16)'\'' -l '\''"9223372036854775808"'\'''
test-expr -e 'uint(16)' -l '"9223372036854775808"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l '\''"9223372036854775808"'\'''

echo '$ test-expr -e '\''uint(32)'\'' -l 9223372036854775808'
test-expr -e 'uint(32)' -l 9223372036854775808 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l 9223372036854775808'

echo '$ test-expr -e '\''uint(32)'\'' -l '\''"9223372036854775808"'\'''
test-expr -e 'uint(32)' -l '"9223372036854775808"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l '\''"9223372036854775808"'\'''

echo '$ test-expr -e '\''uint(64)'\'' -l 9223372036854775808'
test-expr -e 'uint(64)' -l 9223372036854775808 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l 9223372036854775808'

echo '$ test-expr -e '\''uint(64)'\'' -l '\''"9223372036854775808"'\'''
test-expr -e 'uint(64)' -l '"9223372036854775808"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l '\''"9223372036854775808"'\'''

echo '$ test-expr -e '\''int(8)'\'' -l -170141183460469231731687303715884105729'
test-expr -e 'int(8)' -l -170141183460469231731687303715884105729 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l -170141183460469231731687303715884105729'

echo '$ test-expr -e '\''int(8)'\'' -l '\''"-170141183460469231731687303715884105729"'\'''
test-expr -e 'int(8)' -l '"-170141183460469231731687303715884105729"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l '\''"-170141183460469231731687303715884105729"'\'''

echo '$ test-expr -e '\''int(16)'\'' -l -170141183460469231731687303715884105729'
test-expr -e 'int(16)' -l -170141183460469231731687303715884105729 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l -170141183460469231731687303715884105729'

echo '$ test-expr -e '\''int(16)'\'' -l '\''"-170141183460469231731687303715884105729"'\'''
test-expr -e 'int(16)' -l '"-170141183460469231731687303715884105729"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l '\''"-170141183460469231731687303715884105729"'\'''

echo '$ test-expr -e '\''int(32)'\'' -l -170141183460469231731687303715884105729'
test-expr -e 'int(32)' -l -170141183460469231731687303715884105729 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l -170141183460469231731687303715884105729'

echo '$ test-expr -e '\''int(32)'\'' -l '\''"-170141183460469231731687303715884105729"'\'''
test-expr -e 'int(32)' -l '"-170141183460469231731687303715884105729"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l '\''"-170141183460469231731687303715884105729"'\'''

echo '$ test-expr -e '\''int(64)'\'' -l -170141183460469231731687303715884105729'
test-expr -e 'int(64)' -l -170141183460469231731687303715884105729 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l -170141183460469231731687303715884105729'

echo '$ test-expr -e '\''int(64)'\'' -l '\''"-170141183460469231731687303715884105729"'\'''
test-expr -e 'int(64)' -l '"-170141183460469231731687303715884105729"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l '\''"-170141183460469231731687303715884105729"'\'''

echo '$ test-expr -e '\''uint(8)'\'' -l -170141183460469231731687303715884105729'
test-expr -e 'uint(8)' -l -170141183460469231731687303715884105729 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l -170141183460469231731687303715884105729'

echo '$ test-expr -e '\''uint(8)'\'' -l '\''"-170141183460469231731687303715884105729"'\'''
test-expr -e 'uint(8)' -l '"-170141183460469231731687303715884105729"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l '\''"-170141183460469231731687303715884105729"'\'''

echo '$ test-expr -e '\''uint(16)'\'' -l -170141183460469231731687303715884105729'
test-expr -e 'uint(16)' -l -170141183460469231731687303715884105729 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l -170141183460469231731687303715884105729'

echo '$ test-expr -e '\''uint(16)'\'' -l '\''"-170141183460469231731687303715884105729"'\'''
test-expr -e 'uint(16)' -l '"-170141183460469231731687303715884105729"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l '\''"-170141183460469231731687303715884105729"'\'''

echo '$ test-expr -e '\''uint(32)'\'' -l -170141183460469231731687303715884105729'
test-expr -e 'uint(32)' -l -170141183460469231731687303715884105729 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l -170141183460469231731687303715884105729'

echo '$ test-expr -e '\''uint(32)'\'' -l '\''"-170141183460469231731687303715884105729"'\'''
test-expr -e 'uint(32)' -l '"-170141183460469231731687303715884105729"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l '\''"-170141183460469231731687303715884105729"'\'''

echo '$ test-expr -e '\''uint(64)'\'' -l -170141183460469231731687303715884105729'
test-expr -e 'uint(64)' -l -170141183460469231731687303715884105729 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l -170141183460469231731687303715884105729'

echo '$ test-expr -e '\''uint(64)'\'' -l '\''"-170141183460469231731687303715884105729"'\'''
test-expr -e 'uint(64)' -l '"-170141183460469231731687303715884105729"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l '\''"-170141183460469231731687303715884105729"'\'''

echo '$ test-expr -e '\''int(8)'\'' -l -170141183460469231731687303715884105728'
test-expr -e 'int(8)' -l -170141183460469231731687303715884105728 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l -170141183460469231731687303715884105728'

echo '$ test-expr -e '\''int(8)'\'' -l '\''"-170141183460469231731687303715884105728"'\'''
test-expr -e 'int(8)' -l '"-170141183460469231731687303715884105728"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l '\''"-170141183460469231731687303715884105728"'\'''

echo '$ test-expr -e '\''int(16)'\'' -l -170141183460469231731687303715884105728'
test-expr -e 'int(16)' -l -170141183460469231731687303715884105728 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l -170141183460469231731687303715884105728'

echo '$ test-expr -e '\''int(16)'\'' -l '\''"-170141183460469231731687303715884105728"'\'''
test-expr -e 'int(16)' -l '"-170141183460469231731687303715884105728"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l '\''"-170141183460469231731687303715884105728"'\'''

echo '$ test-expr -e '\''int(32)'\'' -l -170141183460469231731687303715884105728'
test-expr -e 'int(32)' -l -170141183460469231731687303715884105728 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l -170141183460469231731687303715884105728'

echo '$ test-expr -e '\''int(32)'\'' -l '\''"-170141183460469231731687303715884105728"'\'''
test-expr -e 'int(32)' -l '"-170141183460469231731687303715884105728"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l '\''"-170141183460469231731687303715884105728"'\'''

echo '$ test-expr -e '\''int(64)'\'' -l -170141183460469231731687303715884105728'
test-expr -e 'int(64)' -l -170141183460469231731687303715884105728 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l -170141183460469231731687303715884105728'

echo '$ test-expr -e '\''int(64)'\'' -l '\''"-170141183460469231731687303715884105728"'\'''
test-expr -e 'int(64)' -l '"-170141183460469231731687303715884105728"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l '\''"-170141183460469231731687303715884105728"'\'''

echo '$ test-expr -e '\''uint(8)'\'' -l -170141183460469231731687303715884105728'
test-expr -e 'uint(8)' -l -170141183460469231731687303715884105728 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l -170141183460469231731687303715884105728'

echo '$ test-expr -e '\''uint(8)'\'' -l '\''"-170141183460469231731687303715884105728"'\'''
test-expr -e 'uint(8)' -l '"-170141183460469231731687303715884105728"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l '\''"-170141183460469231731687303715884105728"'\'''

echo '$ test-expr -e '\''uint(16)'\'' -l -170141183460469231731687303715884105728'
test-expr -e 'uint(16)' -l -170141183460469231731687303715884105728 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l -170141183460469231731687303715884105728'

echo '$ test-expr -e '\''uint(16)'\'' -l '\''"-170141183460469231731687303715884105728"'\'''
test-expr -e 'uint(16)' -l '"-170141183460469231731687303715884105728"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l '\''"-170141183460469231731687303715884105728"'\'''

echo '$ test-expr -e '\''uint(32)'\'' -l -170141183460469231731687303715884105728'
test-expr -e 'uint(32)' -l -170141183460469231731687303715884105728 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l -170141183460469231731687303715884105728'

echo '$ test-expr -e '\''uint(32)'\'' -l '\''"-170141183460469231731687303715884105728"'\'''
test-expr -e 'uint(32)' -l '"-170141183460469231731687303715884105728"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l '\''"-170141183460469231731687303715884105728"'\'''

echo '$ test-expr -e '\''uint(64)'\'' -l -170141183460469231731687303715884105728'
test-expr -e 'uint(64)' -l -170141183460469231731687303715884105728 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l -170141183460469231731687303715884105728'

echo '$ test-expr -e '\''uint(64)'\'' -l '\''"-170141183460469231731687303715884105728"'\'''
test-expr -e 'uint(64)' -l '"-170141183460469231731687303715884105728"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l '\''"-170141183460469231731687303715884105728"'\'''

echo '$ test-expr -e '\''int(8)'\'' -l -170141183460469231731687303715884105727'
test-expr -e 'int(8)' -l -170141183460469231731687303715884105727 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l -170141183460469231731687303715884105727'

echo '$ test-expr -e '\''int(8)'\'' -l '\''"-170141183460469231731687303715884105727"'\'''
test-expr -e 'int(8)' -l '"-170141183460469231731687303715884105727"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l '\''"-170141183460469231731687303715884105727"'\'''

echo '$ test-expr -e '\''int(16)'\'' -l -170141183460469231731687303715884105727'
test-expr -e 'int(16)' -l -170141183460469231731687303715884105727 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l -170141183460469231731687303715884105727'

echo '$ test-expr -e '\''int(16)'\'' -l '\''"-170141183460469231731687303715884105727"'\'''
test-expr -e 'int(16)' -l '"-170141183460469231731687303715884105727"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l '\''"-170141183460469231731687303715884105727"'\'''

echo '$ test-expr -e '\''int(32)'\'' -l -170141183460469231731687303715884105727'
test-expr -e 'int(32)' -l -170141183460469231731687303715884105727 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l -170141183460469231731687303715884105727'

echo '$ test-expr -e '\''int(32)'\'' -l '\''"-170141183460469231731687303715884105727"'\'''
test-expr -e 'int(32)' -l '"-170141183460469231731687303715884105727"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l '\''"-170141183460469231731687303715884105727"'\'''

echo '$ test-expr -e '\''int(64)'\'' -l -170141183460469231731687303715884105727'
test-expr -e 'int(64)' -l -170141183460469231731687303715884105727 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l -170141183460469231731687303715884105727'

echo '$ test-expr -e '\''int(64)'\'' -l '\''"-170141183460469231731687303715884105727"'\'''
test-expr -e 'int(64)' -l '"-170141183460469231731687303715884105727"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l '\''"-170141183460469231731687303715884105727"'\'''

echo '$ test-expr -e '\''uint(8)'\'' -l -170141183460469231731687303715884105727'
test-expr -e 'uint(8)' -l -170141183460469231731687303715884105727 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l -170141183460469231731687303715884105727'

echo '$ test-expr -e '\''uint(8)'\'' -l '\''"-170141183460469231731687303715884105727"'\'''
test-expr -e 'uint(8)' -l '"-170141183460469231731687303715884105727"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l '\''"-170141183460469231731687303715884105727"'\'''

echo '$ test-expr -e '\''uint(16)'\'' -l -170141183460469231731687303715884105727'
test-expr -e 'uint(16)' -l -170141183460469231731687303715884105727 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l -170141183460469231731687303715884105727'

echo '$ test-expr -e '\''uint(16)'\'' -l '\''"-170141183460469231731687303715884105727"'\'''
test-expr -e 'uint(16)' -l '"-170141183460469231731687303715884105727"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l '\''"-170141183460469231731687303715884105727"'\'''

echo '$ test-expr -e '\''uint(32)'\'' -l -170141183460469231731687303715884105727'
test-expr -e 'uint(32)' -l -170141183460469231731687303715884105727 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l -170141183460469231731687303715884105727'

echo '$ test-expr -e '\''uint(32)'\'' -l '\''"-170141183460469231731687303715884105727"'\'''
test-expr -e 'uint(32)' -l '"-170141183460469231731687303715884105727"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l '\''"-170141183460469231731687303715884105727"'\'''

echo '$ test-expr -e '\''uint(64)'\'' -l -170141183460469231731687303715884105727'
test-expr -e 'uint(64)' -l -170141183460469231731687303715884105727 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l -170141183460469231731687303715884105727'

echo '$ test-expr -e '\''uint(64)'\'' -l '\''"-170141183460469231731687303715884105727"'\'''
test-expr -e 'uint(64)' -l '"-170141183460469231731687303715884105727"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l '\''"-170141183460469231731687303715884105727"'\'''

echo '$ test-expr -e '\''int(8)'\'' -l 170141183460469231731687303715884105726'
test-expr -e 'int(8)' -l 170141183460469231731687303715884105726 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l 170141183460469231731687303715884105726'

echo '$ test-expr -e '\''int(8)'\'' -l '\''"170141183460469231731687303715884105726"'\'''
test-expr -e 'int(8)' -l '"170141183460469231731687303715884105726"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l '\''"170141183460469231731687303715884105726"'\'''

echo '$ test-expr -e '\''int(16)'\'' -l 170141183460469231731687303715884105726'
test-expr -e 'int(16)' -l 170141183460469231731687303715884105726 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l 170141183460469231731687303715884105726'

echo '$ test-expr -e '\''int(16)'\'' -l '\''"170141183460469231731687303715884105726"'\'''
test-expr -e 'int(16)' -l '"170141183460469231731687303715884105726"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l '\''"170141183460469231731687303715884105726"'\'''

echo '$ test-expr -e '\''int(32)'\'' -l 170141183460469231731687303715884105726'
test-expr -e 'int(32)' -l 170141183460469231731687303715884105726 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l 170141183460469231731687303715884105726'

echo '$ test-expr -e '\''int(32)'\'' -l '\''"170141183460469231731687303715884105726"'\'''
test-expr -e 'int(32)' -l '"170141183460469231731687303715884105726"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l '\''"170141183460469231731687303715884105726"'\'''

echo '$ test-expr -e '\''int(64)'\'' -l 170141183460469231731687303715884105726'
test-expr -e 'int(64)' -l 170141183460469231731687303715884105726 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l 170141183460469231731687303715884105726'

echo '$ test-expr -e '\''int(64)'\'' -l '\''"170141183460469231731687303715884105726"'\'''
test-expr -e 'int(64)' -l '"170141183460469231731687303715884105726"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l '\''"170141183460469231731687303715884105726"'\'''

echo '$ test-expr -e '\''uint(8)'\'' -l 170141183460469231731687303715884105726'
test-expr -e 'uint(8)' -l 170141183460469231731687303715884105726 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l 170141183460469231731687303715884105726'

echo '$ test-expr -e '\''uint(8)'\'' -l '\''"170141183460469231731687303715884105726"'\'''
test-expr -e 'uint(8)' -l '"170141183460469231731687303715884105726"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l '\''"170141183460469231731687303715884105726"'\'''

echo '$ test-expr -e '\''uint(16)'\'' -l 170141183460469231731687303715884105726'
test-expr -e 'uint(16)' -l 170141183460469231731687303715884105726 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l 170141183460469231731687303715884105726'

echo '$ test-expr -e '\''uint(16)'\'' -l '\''"170141183460469231731687303715884105726"'\'''
test-expr -e 'uint(16)' -l '"170141183460469231731687303715884105726"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l '\''"170141183460469231731687303715884105726"'\'''

echo '$ test-expr -e '\''uint(32)'\'' -l 170141183460469231731687303715884105726'
test-expr -e 'uint(32)' -l 170141183460469231731687303715884105726 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l 170141183460469231731687303715884105726'

echo '$ test-expr -e '\''uint(32)'\'' -l '\''"170141183460469231731687303715884105726"'\'''
test-expr -e 'uint(32)' -l '"170141183460469231731687303715884105726"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l '\''"170141183460469231731687303715884105726"'\'''

echo '$ test-expr -e '\''uint(64)'\'' -l 170141183460469231731687303715884105726'
test-expr -e 'uint(64)' -l 170141183460469231731687303715884105726 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l 170141183460469231731687303715884105726'

echo '$ test-expr -e '\''uint(64)'\'' -l '\''"170141183460469231731687303715884105726"'\'''
test-expr -e 'uint(64)' -l '"170141183460469231731687303715884105726"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l '\''"170141183460469231731687303715884105726"'\'''

echo '$ test-expr -e '\''int(8)'\'' -l 170141183460469231731687303715884105727'
test-expr -e 'int(8)' -l 170141183460469231731687303715884105727 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l 170141183460469231731687303715884105727'

echo '$ test-expr -e '\''int(8)'\'' -l '\''"170141183460469231731687303715884105727"'\'''
test-expr -e 'int(8)' -l '"170141183460469231731687303715884105727"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l '\''"170141183460469231731687303715884105727"'\'''

echo '$ test-expr -e '\''int(16)'\'' -l 170141183460469231731687303715884105727'
test-expr -e 'int(16)' -l 170141183460469231731687303715884105727 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l 170141183460469231731687303715884105727'

echo '$ test-expr -e '\''int(16)'\'' -l '\''"170141183460469231731687303715884105727"'\'''
test-expr -e 'int(16)' -l '"170141183460469231731687303715884105727"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l '\''"170141183460469231731687303715884105727"'\'''

echo '$ test-expr -e '\''int(32)'\'' -l 170141183460469231731687303715884105727'
test-expr -e 'int(32)' -l 170141183460469231731687303715884105727 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l 170141183460469231731687303715884105727'

echo '$ test-expr -e '\''int(32)'\'' -l '\''"170141183460469231731687303715884105727"'\'''
test-expr -e 'int(32)' -l '"170141183460469231731687303715884105727"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l '\''"170141183460469231731687303715884105727"'\'''

echo '$ test-expr -e '\''int(64)'\'' -l 170141183460469231731687303715884105727'
test-expr -e 'int(64)' -l 170141183460469231731687303715884105727 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l 170141183460469231731687303715884105727'

echo '$ test-expr -e '\''int(64)'\'' -l '\''"170141183460469231731687303715884105727"'\'''
test-expr -e 'int(64)' -l '"170141183460469231731687303715884105727"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l '\''"170141183460469231731687303715884105727"'\'''

echo '$ test-expr -e '\''uint(8)'\'' -l 170141183460469231731687303715884105727'
test-expr -e 'uint(8)' -l 170141183460469231731687303715884105727 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l 170141183460469231731687303715884105727'

echo '$ test-expr -e '\''uint(8)'\'' -l '\''"170141183460469231731687303715884105727"'\'''
test-expr -e 'uint(8)' -l '"170141183460469231731687303715884105727"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l '\''"170141183460469231731687303715884105727"'\'''

echo '$ test-expr -e '\''uint(16)'\'' -l 170141183460469231731687303715884105727'
test-expr -e 'uint(16)' -l 170141183460469231731687303715884105727 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l 170141183460469231731687303715884105727'

echo '$ test-expr -e '\''uint(16)'\'' -l '\''"170141183460469231731687303715884105727"'\'''
test-expr -e 'uint(16)' -l '"170141183460469231731687303715884105727"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l '\''"170141183460469231731687303715884105727"'\'''

echo '$ test-expr -e '\''uint(32)'\'' -l 170141183460469231731687303715884105727'
test-expr -e 'uint(32)' -l 170141183460469231731687303715884105727 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l 170141183460469231731687303715884105727'

echo '$ test-expr -e '\''uint(32)'\'' -l '\''"170141183460469231731687303715884105727"'\'''
test-expr -e 'uint(32)' -l '"170141183460469231731687303715884105727"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l '\''"170141183460469231731687303715884105727"'\'''

echo '$ test-expr -e '\''uint(64)'\'' -l 170141183460469231731687303715884105727'
test-expr -e 'uint(64)' -l 170141183460469231731687303715884105727 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l 170141183460469231731687303715884105727'

echo '$ test-expr -e '\''uint(64)'\'' -l '\''"170141183460469231731687303715884105727"'\'''
test-expr -e 'uint(64)' -l '"170141183460469231731687303715884105727"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l '\''"170141183460469231731687303715884105727"'\'''

echo '$ test-expr -e '\''int(8)'\'' -l 170141183460469231731687303715884105728'
test-expr -e 'int(8)' -l 170141183460469231731687303715884105728 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l 170141183460469231731687303715884105728'

echo '$ test-expr -e '\''int(8)'\'' -l '\''"170141183460469231731687303715884105728"'\'''
test-expr -e 'int(8)' -l '"170141183460469231731687303715884105728"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l '\''"170141183460469231731687303715884105728"'\'''

echo '$ test-expr -e '\''int(16)'\'' -l 170141183460469231731687303715884105728'
test-expr -e 'int(16)' -l 170141183460469231731687303715884105728 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l 170141183460469231731687303715884105728'

echo '$ test-expr -e '\''int(16)'\'' -l '\''"170141183460469231731687303715884105728"'\'''
test-expr -e 'int(16)' -l '"170141183460469231731687303715884105728"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l '\''"170141183460469231731687303715884105728"'\'''

echo '$ test-expr -e '\''int(32)'\'' -l 170141183460469231731687303715884105728'
test-expr -e 'int(32)' -l 170141183460469231731687303715884105728 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l 170141183460469231731687303715884105728'

echo '$ test-expr -e '\''int(32)'\'' -l '\''"170141183460469231731687303715884105728"'\'''
test-expr -e 'int(32)' -l '"170141183460469231731687303715884105728"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l '\''"170141183460469231731687303715884105728"'\'''

echo '$ test-expr -e '\''int(64)'\'' -l 170141183460469231731687303715884105728'
test-expr -e 'int(64)' -l 170141183460469231731687303715884105728 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l 170141183460469231731687303715884105728'

echo '$ test-expr -e '\''int(64)'\'' -l '\''"170141183460469231731687303715884105728"'\'''
test-expr -e 'int(64)' -l '"170141183460469231731687303715884105728"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l '\''"170141183460469231731687303715884105728"'\'''

echo '$ test-expr -e '\''uint(8)'\'' -l 170141183460469231731687303715884105728'
test-expr -e 'uint(8)' -l 170141183460469231731687303715884105728 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l 170141183460469231731687303715884105728'

echo '$ test-expr -e '\''uint(8)'\'' -l '\''"170141183460469231731687303715884105728"'\'''
test-expr -e 'uint(8)' -l '"170141183460469231731687303715884105728"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l '\''"170141183460469231731687303715884105728"'\'''

echo '$ test-expr -e '\''uint(16)'\'' -l 170141183460469231731687303715884105728'
test-expr -e 'uint(16)' -l 170141183460469231731687303715884105728 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l 170141183460469231731687303715884105728'

echo '$ test-expr -e '\''uint(16)'\'' -l '\''"170141183460469231731687303715884105728"'\'''
test-expr -e 'uint(16)' -l '"170141183460469231731687303715884105728"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l '\''"170141183460469231731687303715884105728"'\'''

echo '$ test-expr -e '\''uint(32)'\'' -l 170141183460469231731687303715884105728'
test-expr -e 'uint(32)' -l 170141183460469231731687303715884105728 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l 170141183460469231731687303715884105728'

echo '$ test-expr -e '\''uint(32)'\'' -l '\''"170141183460469231731687303715884105728"'\'''
test-expr -e 'uint(32)' -l '"170141183460469231731687303715884105728"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l '\''"170141183460469231731687303715884105728"'\'''

echo '$ test-expr -e '\''uint(64)'\'' -l 170141183460469231731687303715884105728'
test-expr -e 'uint(64)' -l 170141183460469231731687303715884105728 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l 170141183460469231731687303715884105728'

echo '$ test-expr -e '\''uint(64)'\'' -l '\''"170141183460469231731687303715884105728"'\'''
test-expr -e 'uint(64)' -l '"170141183460469231731687303715884105728"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l '\''"170141183460469231731687303715884105728"'\'''

echo '$ test-expr -e '\''int(8)'\'' -l -1'
test-expr -e 'int(8)' -l -1 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l -1'

echo '$ test-expr -e '\''int(8)'\'' -l '\''"-1"'\'''
test-expr -e 'int(8)' -l '"-1"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l '\''"-1"'\'''

echo '$ test-expr -e '\''int(16)'\'' -l -1'
test-expr -e 'int(16)' -l -1 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l -1'

echo '$ test-expr -e '\''int(16)'\'' -l '\''"-1"'\'''
test-expr -e 'int(16)' -l '"-1"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l '\''"-1"'\'''

echo '$ test-expr -e '\''int(32)'\'' -l -1'
test-expr -e 'int(32)' -l -1 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l -1'

echo '$ test-expr -e '\''int(32)'\'' -l '\''"-1"'\'''
test-expr -e 'int(32)' -l '"-1"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l '\''"-1"'\'''

echo '$ test-expr -e '\''int(64)'\'' -l -1'
test-expr -e 'int(64)' -l -1 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l -1'

echo '$ test-expr -e '\''int(64)'\'' -l '\''"-1"'\'''
test-expr -e 'int(64)' -l '"-1"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l '\''"-1"'\'''

echo '$ test-expr -e '\''uint(8)'\'' -l -1'
test-expr -e 'uint(8)' -l -1 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l -1'

echo '$ test-expr -e '\''uint(8)'\'' -l '\''"-1"'\'''
test-expr -e 'uint(8)' -l '"-1"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l '\''"-1"'\'''

echo '$ test-expr -e '\''uint(16)'\'' -l -1'
test-expr -e 'uint(16)' -l -1 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l -1'

echo '$ test-expr -e '\''uint(16)'\'' -l '\''"-1"'\'''
test-expr -e 'uint(16)' -l '"-1"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l '\''"-1"'\'''

echo '$ test-expr -e '\''uint(32)'\'' -l -1'
test-expr -e 'uint(32)' -l -1 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l -1'

echo '$ test-expr -e '\''uint(32)'\'' -l '\''"-1"'\'''
test-expr -e 'uint(32)' -l '"-1"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l '\''"-1"'\'''

echo '$ test-expr -e '\''uint(64)'\'' -l -1'
test-expr -e 'uint(64)' -l -1 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l -1'

echo '$ test-expr -e '\''uint(64)'\'' -l '\''"-1"'\'''
test-expr -e 'uint(64)' -l '"-1"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l '\''"-1"'\'''

echo '$ test-expr -e '\''int(8)'\'' -l 0'
test-expr -e 'int(8)' -l 0 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l 0'

echo '$ test-expr -e '\''int(8)'\'' -l '\''"0"'\'''
test-expr -e 'int(8)' -l '"0"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l '\''"0"'\'''

echo '$ test-expr -e '\''int(16)'\'' -l 0'
test-expr -e 'int(16)' -l 0 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l 0'

echo '$ test-expr -e '\''int(16)'\'' -l '\''"0"'\'''
test-expr -e 'int(16)' -l '"0"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l '\''"0"'\'''

echo '$ test-expr -e '\''int(32)'\'' -l 0'
test-expr -e 'int(32)' -l 0 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l 0'

echo '$ test-expr -e '\''int(32)'\'' -l '\''"0"'\'''
test-expr -e 'int(32)' -l '"0"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l '\''"0"'\'''

echo '$ test-expr -e '\''int(64)'\'' -l 0'
test-expr -e 'int(64)' -l 0 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l 0'

echo '$ test-expr -e '\''int(64)'\'' -l '\''"0"'\'''
test-expr -e 'int(64)' -l '"0"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l '\''"0"'\'''

echo '$ test-expr -e '\''uint(8)'\'' -l 0'
test-expr -e 'uint(8)' -l 0 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l 0'

echo '$ test-expr -e '\''uint(8)'\'' -l '\''"0"'\'''
test-expr -e 'uint(8)' -l '"0"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l '\''"0"'\'''

echo '$ test-expr -e '\''uint(16)'\'' -l 0'
test-expr -e 'uint(16)' -l 0 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l 0'

echo '$ test-expr -e '\''uint(16)'\'' -l '\''"0"'\'''
test-expr -e 'uint(16)' -l '"0"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l '\''"0"'\'''

echo '$ test-expr -e '\''uint(32)'\'' -l 0'
test-expr -e 'uint(32)' -l 0 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l 0'

echo '$ test-expr -e '\''uint(32)'\'' -l '\''"0"'\'''
test-expr -e 'uint(32)' -l '"0"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l '\''"0"'\'''

echo '$ test-expr -e '\''uint(64)'\'' -l 0'
test-expr -e 'uint(64)' -l 0 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l 0'

echo '$ test-expr -e '\''uint(64)'\'' -l '\''"0"'\'''
test-expr -e 'uint(64)' -l '"0"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l '\''"0"'\'''

echo '$ test-expr -e '\''int(8)'\'' -l 1'
test-expr -e 'int(8)' -l 1 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l 1'

echo '$ test-expr -e '\''int(8)'\'' -l '\''"1"'\'''
test-expr -e 'int(8)' -l '"1"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l '\''"1"'\'''

echo '$ test-expr -e '\''int(16)'\'' -l 1'
test-expr -e 'int(16)' -l 1 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l 1'

echo '$ test-expr -e '\''int(16)'\'' -l '\''"1"'\'''
test-expr -e 'int(16)' -l '"1"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l '\''"1"'\'''

echo '$ test-expr -e '\''int(32)'\'' -l 1'
test-expr -e 'int(32)' -l 1 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l 1'

echo '$ test-expr -e '\''int(32)'\'' -l '\''"1"'\'''
test-expr -e 'int(32)' -l '"1"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l '\''"1"'\'''

echo '$ test-expr -e '\''int(64)'\'' -l 1'
test-expr -e 'int(64)' -l 1 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l 1'

echo '$ test-expr -e '\''int(64)'\'' -l '\''"1"'\'''
test-expr -e 'int(64)' -l '"1"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l '\''"1"'\'''

echo '$ test-expr -e '\''uint(8)'\'' -l 1'
test-expr -e 'uint(8)' -l 1 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l 1'

echo '$ test-expr -e '\''uint(8)'\'' -l '\''"1"'\'''
test-expr -e 'uint(8)' -l '"1"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l '\''"1"'\'''

echo '$ test-expr -e '\''uint(16)'\'' -l 1'
test-expr -e 'uint(16)' -l 1 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l 1'

echo '$ test-expr -e '\''uint(16)'\'' -l '\''"1"'\'''
test-expr -e 'uint(16)' -l '"1"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l '\''"1"'\'''

echo '$ test-expr -e '\''uint(32)'\'' -l 1'
test-expr -e 'uint(32)' -l 1 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l 1'

echo '$ test-expr -e '\''uint(32)'\'' -l '\''"1"'\'''
test-expr -e 'uint(32)' -l '"1"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l '\''"1"'\'''

echo '$ test-expr -e '\''uint(64)'\'' -l 1'
test-expr -e 'uint(64)' -l 1 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l 1'

echo '$ test-expr -e '\''uint(64)'\'' -l '\''"1"'\'''
test-expr -e 'uint(64)' -l '"1"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l '\''"1"'\'''

echo '$ test-expr -e '\''int(8)'\'' -l 254'
test-expr -e 'int(8)' -l 254 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l 254'

echo '$ test-expr -e '\''int(8)'\'' -l '\''"254"'\'''
test-expr -e 'int(8)' -l '"254"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l '\''"254"'\'''

echo '$ test-expr -e '\''int(16)'\'' -l 254'
test-expr -e 'int(16)' -l 254 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l 254'

echo '$ test-expr -e '\''int(16)'\'' -l '\''"254"'\'''
test-expr -e 'int(16)' -l '"254"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l '\''"254"'\'''

echo '$ test-expr -e '\''int(32)'\'' -l 254'
test-expr -e 'int(32)' -l 254 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l 254'

echo '$ test-expr -e '\''int(32)'\'' -l '\''"254"'\'''
test-expr -e 'int(32)' -l '"254"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l '\''"254"'\'''

echo '$ test-expr -e '\''int(64)'\'' -l 254'
test-expr -e 'int(64)' -l 254 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l 254'

echo '$ test-expr -e '\''int(64)'\'' -l '\''"254"'\'''
test-expr -e 'int(64)' -l '"254"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l '\''"254"'\'''

echo '$ test-expr -e '\''uint(8)'\'' -l 254'
test-expr -e 'uint(8)' -l 254 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l 254'

echo '$ test-expr -e '\''uint(8)'\'' -l '\''"254"'\'''
test-expr -e 'uint(8)' -l '"254"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l '\''"254"'\'''

echo '$ test-expr -e '\''uint(16)'\'' -l 254'
test-expr -e 'uint(16)' -l 254 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l 254'

echo '$ test-expr -e '\''uint(16)'\'' -l '\''"254"'\'''
test-expr -e 'uint(16)' -l '"254"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l '\''"254"'\'''

echo '$ test-expr -e '\''uint(32)'\'' -l 254'
test-expr -e 'uint(32)' -l 254 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l 254'

echo '$ test-expr -e '\''uint(32)'\'' -l '\''"254"'\'''
test-expr -e 'uint(32)' -l '"254"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l '\''"254"'\'''

echo '$ test-expr -e '\''uint(64)'\'' -l 254'
test-expr -e 'uint(64)' -l 254 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l 254'

echo '$ test-expr -e '\''uint(64)'\'' -l '\''"254"'\'''
test-expr -e 'uint(64)' -l '"254"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l '\''"254"'\'''

echo '$ test-expr -e '\''int(8)'\'' -l 255'
test-expr -e 'int(8)' -l 255 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l 255'

echo '$ test-expr -e '\''int(8)'\'' -l '\''"255"'\'''
test-expr -e 'int(8)' -l '"255"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l '\''"255"'\'''

echo '$ test-expr -e '\''int(16)'\'' -l 255'
test-expr -e 'int(16)' -l 255 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l 255'

echo '$ test-expr -e '\''int(16)'\'' -l '\''"255"'\'''
test-expr -e 'int(16)' -l '"255"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l '\''"255"'\'''

echo '$ test-expr -e '\''int(32)'\'' -l 255'
test-expr -e 'int(32)' -l 255 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l 255'

echo '$ test-expr -e '\''int(32)'\'' -l '\''"255"'\'''
test-expr -e 'int(32)' -l '"255"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l '\''"255"'\'''

echo '$ test-expr -e '\''int(64)'\'' -l 255'
test-expr -e 'int(64)' -l 255 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l 255'

echo '$ test-expr -e '\''int(64)'\'' -l '\''"255"'\'''
test-expr -e 'int(64)' -l '"255"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l '\''"255"'\'''

echo '$ test-expr -e '\''uint(8)'\'' -l 255'
test-expr -e 'uint(8)' -l 255 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l 255'

echo '$ test-expr -e '\''uint(8)'\'' -l '\''"255"'\'''
test-expr -e 'uint(8)' -l '"255"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l '\''"255"'\'''

echo '$ test-expr -e '\''uint(16)'\'' -l 255'
test-expr -e 'uint(16)' -l 255 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l 255'

echo '$ test-expr -e '\''uint(16)'\'' -l '\''"255"'\'''
test-expr -e 'uint(16)' -l '"255"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l '\''"255"'\'''

echo '$ test-expr -e '\''uint(32)'\'' -l 255'
test-expr -e 'uint(32)' -l 255 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l 255'

echo '$ test-expr -e '\''uint(32)'\'' -l '\''"255"'\'''
test-expr -e 'uint(32)' -l '"255"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l '\''"255"'\'''

echo '$ test-expr -e '\''uint(64)'\'' -l 255'
test-expr -e 'uint(64)' -l 255 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l 255'

echo '$ test-expr -e '\''uint(64)'\'' -l '\''"255"'\'''
test-expr -e 'uint(64)' -l '"255"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l '\''"255"'\'''

echo '$ test-expr -e '\''int(8)'\'' -l 256'
test-expr -e 'int(8)' -l 256 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l 256'

echo '$ test-expr -e '\''int(8)'\'' -l '\''"256"'\'''
test-expr -e 'int(8)' -l '"256"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l '\''"256"'\'''

echo '$ test-expr -e '\''int(16)'\'' -l 256'
test-expr -e 'int(16)' -l 256 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l 256'

echo '$ test-expr -e '\''int(16)'\'' -l '\''"256"'\'''
test-expr -e 'int(16)' -l '"256"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l '\''"256"'\'''

echo '$ test-expr -e '\''int(32)'\'' -l 256'
test-expr -e 'int(32)' -l 256 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l 256'

echo '$ test-expr -e '\''int(32)'\'' -l '\''"256"'\'''
test-expr -e 'int(32)' -l '"256"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l '\''"256"'\'''

echo '$ test-expr -e '\''int(64)'\'' -l 256'
test-expr -e 'int(64)' -l 256 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l 256'

echo '$ test-expr -e '\''int(64)'\'' -l '\''"256"'\'''
test-expr -e 'int(64)' -l '"256"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l '\''"256"'\'''

echo '$ test-expr -e '\''uint(8)'\'' -l 256'
test-expr -e 'uint(8)' -l 256 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l 256'

echo '$ test-expr -e '\''uint(8)'\'' -l '\''"256"'\'''
test-expr -e 'uint(8)' -l '"256"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l '\''"256"'\'''

echo '$ test-expr -e '\''uint(16)'\'' -l 256'
test-expr -e 'uint(16)' -l 256 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l 256'

echo '$ test-expr -e '\''uint(16)'\'' -l '\''"256"'\'''
test-expr -e 'uint(16)' -l '"256"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l '\''"256"'\'''

echo '$ test-expr -e '\''uint(32)'\'' -l 256'
test-expr -e 'uint(32)' -l 256 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l 256'

echo '$ test-expr -e '\''uint(32)'\'' -l '\''"256"'\'''
test-expr -e 'uint(32)' -l '"256"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l '\''"256"'\'''

echo '$ test-expr -e '\''uint(64)'\'' -l 256'
test-expr -e 'uint(64)' -l 256 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l 256'

echo '$ test-expr -e '\''uint(64)'\'' -l '\''"256"'\'''
test-expr -e 'uint(64)' -l '"256"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l '\''"256"'\'''

echo '$ test-expr -e '\''int(8)'\'' -l 65534'
test-expr -e 'int(8)' -l 65534 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l 65534'

echo '$ test-expr -e '\''int(8)'\'' -l '\''"65534"'\'''
test-expr -e 'int(8)' -l '"65534"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l '\''"65534"'\'''

echo '$ test-expr -e '\''int(16)'\'' -l 65534'
test-expr -e 'int(16)' -l 65534 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l 65534'

echo '$ test-expr -e '\''int(16)'\'' -l '\''"65534"'\'''
test-expr -e 'int(16)' -l '"65534"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l '\''"65534"'\'''

echo '$ test-expr -e '\''int(32)'\'' -l 65534'
test-expr -e 'int(32)' -l 65534 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l 65534'

echo '$ test-expr -e '\''int(32)'\'' -l '\''"65534"'\'''
test-expr -e 'int(32)' -l '"65534"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l '\''"65534"'\'''

echo '$ test-expr -e '\''int(64)'\'' -l 65534'
test-expr -e 'int(64)' -l 65534 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l 65534'

echo '$ test-expr -e '\''int(64)'\'' -l '\''"65534"'\'''
test-expr -e 'int(64)' -l '"65534"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l '\''"65534"'\'''

echo '$ test-expr -e '\''uint(8)'\'' -l 65534'
test-expr -e 'uint(8)' -l 65534 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l 65534'

echo '$ test-expr -e '\''uint(8)'\'' -l '\''"65534"'\'''
test-expr -e 'uint(8)' -l '"65534"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l '\''"65534"'\'''

echo '$ test-expr -e '\''uint(16)'\'' -l 65534'
test-expr -e 'uint(16)' -l 65534 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l 65534'

echo '$ test-expr -e '\''uint(16)'\'' -l '\''"65534"'\'''
test-expr -e 'uint(16)' -l '"65534"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l '\''"65534"'\'''

echo '$ test-expr -e '\''uint(32)'\'' -l 65534'
test-expr -e 'uint(32)' -l 65534 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l 65534'

echo '$ test-expr -e '\''uint(32)'\'' -l '\''"65534"'\'''
test-expr -e 'uint(32)' -l '"65534"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l '\''"65534"'\'''

echo '$ test-expr -e '\''uint(64)'\'' -l 65534'
test-expr -e 'uint(64)' -l 65534 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l 65534'

echo '$ test-expr -e '\''uint(64)'\'' -l '\''"65534"'\'''
test-expr -e 'uint(64)' -l '"65534"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l '\''"65534"'\'''

echo '$ test-expr -e '\''int(8)'\'' -l 65535'
test-expr -e 'int(8)' -l 65535 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l 65535'

echo '$ test-expr -e '\''int(8)'\'' -l '\''"65535"'\'''
test-expr -e 'int(8)' -l '"65535"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l '\''"65535"'\'''

echo '$ test-expr -e '\''int(16)'\'' -l 65535'
test-expr -e 'int(16)' -l 65535 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l 65535'

echo '$ test-expr -e '\''int(16)'\'' -l '\''"65535"'\'''
test-expr -e 'int(16)' -l '"65535"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l '\''"65535"'\'''

echo '$ test-expr -e '\''int(32)'\'' -l 65535'
test-expr -e 'int(32)' -l 65535 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l 65535'

echo '$ test-expr -e '\''int(32)'\'' -l '\''"65535"'\'''
test-expr -e 'int(32)' -l '"65535"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l '\''"65535"'\'''

echo '$ test-expr -e '\''int(64)'\'' -l 65535'
test-expr -e 'int(64)' -l 65535 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l 65535'

echo '$ test-expr -e '\''int(64)'\'' -l '\''"65535"'\'''
test-expr -e 'int(64)' -l '"65535"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l '\''"65535"'\'''

echo '$ test-expr -e '\''uint(8)'\'' -l 65535'
test-expr -e 'uint(8)' -l 65535 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l 65535'

echo '$ test-expr -e '\''uint(8)'\'' -l '\''"65535"'\'''
test-expr -e 'uint(8)' -l '"65535"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l '\''"65535"'\'''

echo '$ test-expr -e '\''uint(16)'\'' -l 65535'
test-expr -e 'uint(16)' -l 65535 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l 65535'

echo '$ test-expr -e '\''uint(16)'\'' -l '\''"65535"'\'''
test-expr -e 'uint(16)' -l '"65535"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l '\''"65535"'\'''

echo '$ test-expr -e '\''uint(32)'\'' -l 65535'
test-expr -e 'uint(32)' -l 65535 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l 65535'

echo '$ test-expr -e '\''uint(32)'\'' -l '\''"65535"'\'''
test-expr -e 'uint(32)' -l '"65535"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l '\''"65535"'\'''

echo '$ test-expr -e '\''uint(64)'\'' -l 65535'
test-expr -e 'uint(64)' -l 65535 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l 65535'

echo '$ test-expr -e '\''uint(64)'\'' -l '\''"65535"'\'''
test-expr -e 'uint(64)' -l '"65535"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l '\''"65535"'\'''

echo '$ test-expr -e '\''int(8)'\'' -l 65536'
test-expr -e 'int(8)' -l 65536 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l 65536'

echo '$ test-expr -e '\''int(8)'\'' -l '\''"65536"'\'''
test-expr -e 'int(8)' -l '"65536"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l '\''"65536"'\'''

echo '$ test-expr -e '\''int(16)'\'' -l 65536'
test-expr -e 'int(16)' -l 65536 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l 65536'

echo '$ test-expr -e '\''int(16)'\'' -l '\''"65536"'\'''
test-expr -e 'int(16)' -l '"65536"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l '\''"65536"'\'''

echo '$ test-expr -e '\''int(32)'\'' -l 65536'
test-expr -e 'int(32)' -l 65536 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l 65536'

echo '$ test-expr -e '\''int(32)'\'' -l '\''"65536"'\'''
test-expr -e 'int(32)' -l '"65536"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l '\''"65536"'\'''

echo '$ test-expr -e '\''int(64)'\'' -l 65536'
test-expr -e 'int(64)' -l 65536 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l 65536'

echo '$ test-expr -e '\''int(64)'\'' -l '\''"65536"'\'''
test-expr -e 'int(64)' -l '"65536"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l '\''"65536"'\'''

echo '$ test-expr -e '\''uint(8)'\'' -l 65536'
test-expr -e 'uint(8)' -l 65536 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l 65536'

echo '$ test-expr -e '\''uint(8)'\'' -l '\''"65536"'\'''
test-expr -e 'uint(8)' -l '"65536"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l '\''"65536"'\'''

echo '$ test-expr -e '\''uint(16)'\'' -l 65536'
test-expr -e 'uint(16)' -l 65536 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l 65536'

echo '$ test-expr -e '\''uint(16)'\'' -l '\''"65536"'\'''
test-expr -e 'uint(16)' -l '"65536"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l '\''"65536"'\'''

echo '$ test-expr -e '\''uint(32)'\'' -l 65536'
test-expr -e 'uint(32)' -l 65536 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l 65536'

echo '$ test-expr -e '\''uint(32)'\'' -l '\''"65536"'\'''
test-expr -e 'uint(32)' -l '"65536"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l '\''"65536"'\'''

echo '$ test-expr -e '\''uint(64)'\'' -l 65536'
test-expr -e 'uint(64)' -l 65536 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l 65536'

echo '$ test-expr -e '\''uint(64)'\'' -l '\''"65536"'\'''
test-expr -e 'uint(64)' -l '"65536"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l '\''"65536"'\'''

echo '$ test-expr -e '\''int(8)'\'' -l 4294967294'
test-expr -e 'int(8)' -l 4294967294 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l 4294967294'

echo '$ test-expr -e '\''int(8)'\'' -l '\''"4294967294"'\'''
test-expr -e 'int(8)' -l '"4294967294"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l '\''"4294967294"'\'''

echo '$ test-expr -e '\''int(16)'\'' -l 4294967294'
test-expr -e 'int(16)' -l 4294967294 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l 4294967294'

echo '$ test-expr -e '\''int(16)'\'' -l '\''"4294967294"'\'''
test-expr -e 'int(16)' -l '"4294967294"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l '\''"4294967294"'\'''

echo '$ test-expr -e '\''int(32)'\'' -l 4294967294'
test-expr -e 'int(32)' -l 4294967294 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l 4294967294'

echo '$ test-expr -e '\''int(32)'\'' -l '\''"4294967294"'\'''
test-expr -e 'int(32)' -l '"4294967294"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l '\''"4294967294"'\'''

echo '$ test-expr -e '\''int(64)'\'' -l 4294967294'
test-expr -e 'int(64)' -l 4294967294 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l 4294967294'

echo '$ test-expr -e '\''int(64)'\'' -l '\''"4294967294"'\'''
test-expr -e 'int(64)' -l '"4294967294"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l '\''"4294967294"'\'''

echo '$ test-expr -e '\''uint(8)'\'' -l 4294967294'
test-expr -e 'uint(8)' -l 4294967294 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l 4294967294'

echo '$ test-expr -e '\''uint(8)'\'' -l '\''"4294967294"'\'''
test-expr -e 'uint(8)' -l '"4294967294"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l '\''"4294967294"'\'''

echo '$ test-expr -e '\''uint(16)'\'' -l 4294967294'
test-expr -e 'uint(16)' -l 4294967294 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l 4294967294'

echo '$ test-expr -e '\''uint(16)'\'' -l '\''"4294967294"'\'''
test-expr -e 'uint(16)' -l '"4294967294"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l '\''"4294967294"'\'''

echo '$ test-expr -e '\''uint(32)'\'' -l 4294967294'
test-expr -e 'uint(32)' -l 4294967294 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l 4294967294'

echo '$ test-expr -e '\''uint(32)'\'' -l '\''"4294967294"'\'''
test-expr -e 'uint(32)' -l '"4294967294"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l '\''"4294967294"'\'''

echo '$ test-expr -e '\''uint(64)'\'' -l 4294967294'
test-expr -e 'uint(64)' -l 4294967294 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l 4294967294'

echo '$ test-expr -e '\''uint(64)'\'' -l '\''"4294967294"'\'''
test-expr -e 'uint(64)' -l '"4294967294"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l '\''"4294967294"'\'''

echo '$ test-expr -e '\''int(8)'\'' -l 4294967295'
test-expr -e 'int(8)' -l 4294967295 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l 4294967295'

echo '$ test-expr -e '\''int(8)'\'' -l '\''"4294967295"'\'''
test-expr -e 'int(8)' -l '"4294967295"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l '\''"4294967295"'\'''

echo '$ test-expr -e '\''int(16)'\'' -l 4294967295'
test-expr -e 'int(16)' -l 4294967295 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l 4294967295'

echo '$ test-expr -e '\''int(16)'\'' -l '\''"4294967295"'\'''
test-expr -e 'int(16)' -l '"4294967295"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l '\''"4294967295"'\'''

echo '$ test-expr -e '\''int(32)'\'' -l 4294967295'
test-expr -e 'int(32)' -l 4294967295 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l 4294967295'

echo '$ test-expr -e '\''int(32)'\'' -l '\''"4294967295"'\'''
test-expr -e 'int(32)' -l '"4294967295"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l '\''"4294967295"'\'''

echo '$ test-expr -e '\''int(64)'\'' -l 4294967295'
test-expr -e 'int(64)' -l 4294967295 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l 4294967295'

echo '$ test-expr -e '\''int(64)'\'' -l '\''"4294967295"'\'''
test-expr -e 'int(64)' -l '"4294967295"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l '\''"4294967295"'\'''

echo '$ test-expr -e '\''uint(8)'\'' -l 4294967295'
test-expr -e 'uint(8)' -l 4294967295 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l 4294967295'

echo '$ test-expr -e '\''uint(8)'\'' -l '\''"4294967295"'\'''
test-expr -e 'uint(8)' -l '"4294967295"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l '\''"4294967295"'\'''

echo '$ test-expr -e '\''uint(16)'\'' -l 4294967295'
test-expr -e 'uint(16)' -l 4294967295 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l 4294967295'

echo '$ test-expr -e '\''uint(16)'\'' -l '\''"4294967295"'\'''
test-expr -e 'uint(16)' -l '"4294967295"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l '\''"4294967295"'\'''

echo '$ test-expr -e '\''uint(32)'\'' -l 4294967295'
test-expr -e 'uint(32)' -l 4294967295 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l 4294967295'

echo '$ test-expr -e '\''uint(32)'\'' -l '\''"4294967295"'\'''
test-expr -e 'uint(32)' -l '"4294967295"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l '\''"4294967295"'\'''

echo '$ test-expr -e '\''uint(64)'\'' -l 4294967295'
test-expr -e 'uint(64)' -l 4294967295 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l 4294967295'

echo '$ test-expr -e '\''uint(64)'\'' -l '\''"4294967295"'\'''
test-expr -e 'uint(64)' -l '"4294967295"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l '\''"4294967295"'\'''

echo '$ test-expr -e '\''int(8)'\'' -l 4294967296'
test-expr -e 'int(8)' -l 4294967296 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l 4294967296'

echo '$ test-expr -e '\''int(8)'\'' -l '\''"4294967296"'\'''
test-expr -e 'int(8)' -l '"4294967296"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l '\''"4294967296"'\'''

echo '$ test-expr -e '\''int(16)'\'' -l 4294967296'
test-expr -e 'int(16)' -l 4294967296 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l 4294967296'

echo '$ test-expr -e '\''int(16)'\'' -l '\''"4294967296"'\'''
test-expr -e 'int(16)' -l '"4294967296"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l '\''"4294967296"'\'''

echo '$ test-expr -e '\''int(32)'\'' -l 4294967296'
test-expr -e 'int(32)' -l 4294967296 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l 4294967296'

echo '$ test-expr -e '\''int(32)'\'' -l '\''"4294967296"'\'''
test-expr -e 'int(32)' -l '"4294967296"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l '\''"4294967296"'\'''

echo '$ test-expr -e '\''int(64)'\'' -l 4294967296'
test-expr -e 'int(64)' -l 4294967296 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l 4294967296'

echo '$ test-expr -e '\''int(64)'\'' -l '\''"4294967296"'\'''
test-expr -e 'int(64)' -l '"4294967296"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l '\''"4294967296"'\'''

echo '$ test-expr -e '\''uint(8)'\'' -l 4294967296'
test-expr -e 'uint(8)' -l 4294967296 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l 4294967296'

echo '$ test-expr -e '\''uint(8)'\'' -l '\''"4294967296"'\'''
test-expr -e 'uint(8)' -l '"4294967296"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l '\''"4294967296"'\'''

echo '$ test-expr -e '\''uint(16)'\'' -l 4294967296'
test-expr -e 'uint(16)' -l 4294967296 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l 4294967296'

echo '$ test-expr -e '\''uint(16)'\'' -l '\''"4294967296"'\'''
test-expr -e 'uint(16)' -l '"4294967296"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l '\''"4294967296"'\'''

echo '$ test-expr -e '\''uint(32)'\'' -l 4294967296'
test-expr -e 'uint(32)' -l 4294967296 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l 4294967296'

echo '$ test-expr -e '\''uint(32)'\'' -l '\''"4294967296"'\'''
test-expr -e 'uint(32)' -l '"4294967296"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l '\''"4294967296"'\'''

echo '$ test-expr -e '\''uint(64)'\'' -l 4294967296'
test-expr -e 'uint(64)' -l 4294967296 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l 4294967296'

echo '$ test-expr -e '\''uint(64)'\'' -l '\''"4294967296"'\'''
test-expr -e 'uint(64)' -l '"4294967296"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l '\''"4294967296"'\'''

echo '$ test-expr -e '\''int(8)'\'' -l 18446744073709551614'
test-expr -e 'int(8)' -l 18446744073709551614 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l 18446744073709551614'

echo '$ test-expr -e '\''int(8)'\'' -l '\''"18446744073709551614"'\'''
test-expr -e 'int(8)' -l '"18446744073709551614"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l '\''"18446744073709551614"'\'''

echo '$ test-expr -e '\''int(16)'\'' -l 18446744073709551614'
test-expr -e 'int(16)' -l 18446744073709551614 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l 18446744073709551614'

echo '$ test-expr -e '\''int(16)'\'' -l '\''"18446744073709551614"'\'''
test-expr -e 'int(16)' -l '"18446744073709551614"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l '\''"18446744073709551614"'\'''

echo '$ test-expr -e '\''int(32)'\'' -l 18446744073709551614'
test-expr -e 'int(32)' -l 18446744073709551614 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l 18446744073709551614'

echo '$ test-expr -e '\''int(32)'\'' -l '\''"18446744073709551614"'\'''
test-expr -e 'int(32)' -l '"18446744073709551614"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l '\''"18446744073709551614"'\'''

echo '$ test-expr -e '\''int(64)'\'' -l 18446744073709551614'
test-expr -e 'int(64)' -l 18446744073709551614 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l 18446744073709551614'

echo '$ test-expr -e '\''int(64)'\'' -l '\''"18446744073709551614"'\'''
test-expr -e 'int(64)' -l '"18446744073709551614"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l '\''"18446744073709551614"'\'''

echo '$ test-expr -e '\''uint(8)'\'' -l 18446744073709551614'
test-expr -e 'uint(8)' -l 18446744073709551614 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l 18446744073709551614'

echo '$ test-expr -e '\''uint(8)'\'' -l '\''"18446744073709551614"'\'''
test-expr -e 'uint(8)' -l '"18446744073709551614"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l '\''"18446744073709551614"'\'''

echo '$ test-expr -e '\''uint(16)'\'' -l 18446744073709551614'
test-expr -e 'uint(16)' -l 18446744073709551614 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l 18446744073709551614'

echo '$ test-expr -e '\''uint(16)'\'' -l '\''"18446744073709551614"'\'''
test-expr -e 'uint(16)' -l '"18446744073709551614"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l '\''"18446744073709551614"'\'''

echo '$ test-expr -e '\''uint(32)'\'' -l 18446744073709551614'
test-expr -e 'uint(32)' -l 18446744073709551614 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l 18446744073709551614'

echo '$ test-expr -e '\''uint(32)'\'' -l '\''"18446744073709551614"'\'''
test-expr -e 'uint(32)' -l '"18446744073709551614"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l '\''"18446744073709551614"'\'''

echo '$ test-expr -e '\''uint(64)'\'' -l 18446744073709551614'
test-expr -e 'uint(64)' -l 18446744073709551614 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l 18446744073709551614'

echo '$ test-expr -e '\''uint(64)'\'' -l '\''"18446744073709551614"'\'''
test-expr -e 'uint(64)' -l '"18446744073709551614"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l '\''"18446744073709551614"'\'''

echo '$ test-expr -e '\''int(8)'\'' -l 18446744073709551615'
test-expr -e 'int(8)' -l 18446744073709551615 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l 18446744073709551615'

echo '$ test-expr -e '\''int(8)'\'' -l '\''"18446744073709551615"'\'''
test-expr -e 'int(8)' -l '"18446744073709551615"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l '\''"18446744073709551615"'\'''

echo '$ test-expr -e '\''int(16)'\'' -l 18446744073709551615'
test-expr -e 'int(16)' -l 18446744073709551615 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l 18446744073709551615'

echo '$ test-expr -e '\''int(16)'\'' -l '\''"18446744073709551615"'\'''
test-expr -e 'int(16)' -l '"18446744073709551615"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l '\''"18446744073709551615"'\'''

echo '$ test-expr -e '\''int(32)'\'' -l 18446744073709551615'
test-expr -e 'int(32)' -l 18446744073709551615 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l 18446744073709551615'

echo '$ test-expr -e '\''int(32)'\'' -l '\''"18446744073709551615"'\'''
test-expr -e 'int(32)' -l '"18446744073709551615"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l '\''"18446744073709551615"'\'''

echo '$ test-expr -e '\''int(64)'\'' -l 18446744073709551615'
test-expr -e 'int(64)' -l 18446744073709551615 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l 18446744073709551615'

echo '$ test-expr -e '\''int(64)'\'' -l '\''"18446744073709551615"'\'''
test-expr -e 'int(64)' -l '"18446744073709551615"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l '\''"18446744073709551615"'\'''

echo '$ test-expr -e '\''uint(8)'\'' -l 18446744073709551615'
test-expr -e 'uint(8)' -l 18446744073709551615 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l 18446744073709551615'

echo '$ test-expr -e '\''uint(8)'\'' -l '\''"18446744073709551615"'\'''
test-expr -e 'uint(8)' -l '"18446744073709551615"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l '\''"18446744073709551615"'\'''

echo '$ test-expr -e '\''uint(16)'\'' -l 18446744073709551615'
test-expr -e 'uint(16)' -l 18446744073709551615 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l 18446744073709551615'

echo '$ test-expr -e '\''uint(16)'\'' -l '\''"18446744073709551615"'\'''
test-expr -e 'uint(16)' -l '"18446744073709551615"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l '\''"18446744073709551615"'\'''

echo '$ test-expr -e '\''uint(32)'\'' -l 18446744073709551615'
test-expr -e 'uint(32)' -l 18446744073709551615 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l 18446744073709551615'

echo '$ test-expr -e '\''uint(32)'\'' -l '\''"18446744073709551615"'\'''
test-expr -e 'uint(32)' -l '"18446744073709551615"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l '\''"18446744073709551615"'\'''

echo '$ test-expr -e '\''uint(64)'\'' -l 18446744073709551615'
test-expr -e 'uint(64)' -l 18446744073709551615 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l 18446744073709551615'

echo '$ test-expr -e '\''uint(64)'\'' -l '\''"18446744073709551615"'\'''
test-expr -e 'uint(64)' -l '"18446744073709551615"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l '\''"18446744073709551615"'\'''

echo '$ test-expr -e '\''int(8)'\'' -l 18446744073709551616'
test-expr -e 'int(8)' -l 18446744073709551616 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l 18446744073709551616'

echo '$ test-expr -e '\''int(8)'\'' -l '\''"18446744073709551616"'\'''
test-expr -e 'int(8)' -l '"18446744073709551616"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l '\''"18446744073709551616"'\'''

echo '$ test-expr -e '\''int(16)'\'' -l 18446744073709551616'
test-expr -e 'int(16)' -l 18446744073709551616 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l 18446744073709551616'

echo '$ test-expr -e '\''int(16)'\'' -l '\''"18446744073709551616"'\'''
test-expr -e 'int(16)' -l '"18446744073709551616"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l '\''"18446744073709551616"'\'''

echo '$ test-expr -e '\''int(32)'\'' -l 18446744073709551616'
test-expr -e 'int(32)' -l 18446744073709551616 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l 18446744073709551616'

echo '$ test-expr -e '\''int(32)'\'' -l '\''"18446744073709551616"'\'''
test-expr -e 'int(32)' -l '"18446744073709551616"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l '\''"18446744073709551616"'\'''

echo '$ test-expr -e '\''int(64)'\'' -l 18446744073709551616'
test-expr -e 'int(64)' -l 18446744073709551616 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l 18446744073709551616'

echo '$ test-expr -e '\''int(64)'\'' -l '\''"18446744073709551616"'\'''
test-expr -e 'int(64)' -l '"18446744073709551616"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l '\''"18446744073709551616"'\'''

echo '$ test-expr -e '\''uint(8)'\'' -l 18446744073709551616'
test-expr -e 'uint(8)' -l 18446744073709551616 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l 18446744073709551616'

echo '$ test-expr -e '\''uint(8)'\'' -l '\''"18446744073709551616"'\'''
test-expr -e 'uint(8)' -l '"18446744073709551616"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l '\''"18446744073709551616"'\'''

echo '$ test-expr -e '\''uint(16)'\'' -l 18446744073709551616'
test-expr -e 'uint(16)' -l 18446744073709551616 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l 18446744073709551616'

echo '$ test-expr -e '\''uint(16)'\'' -l '\''"18446744073709551616"'\'''
test-expr -e 'uint(16)' -l '"18446744073709551616"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l '\''"18446744073709551616"'\'''

echo '$ test-expr -e '\''uint(32)'\'' -l 18446744073709551616'
test-expr -e 'uint(32)' -l 18446744073709551616 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l 18446744073709551616'

echo '$ test-expr -e '\''uint(32)'\'' -l '\''"18446744073709551616"'\'''
test-expr -e 'uint(32)' -l '"18446744073709551616"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l '\''"18446744073709551616"'\'''

echo '$ test-expr -e '\''uint(64)'\'' -l 18446744073709551616'
test-expr -e 'uint(64)' -l 18446744073709551616 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l 18446744073709551616'

echo '$ test-expr -e '\''uint(64)'\'' -l '\''"18446744073709551616"'\'''
test-expr -e 'uint(64)' -l '"18446744073709551616"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l '\''"18446744073709551616"'\'''

echo '$ test-expr -e '\''int(8)'\'' -l 340282366920938463463374607431768211454'
test-expr -e 'int(8)' -l 340282366920938463463374607431768211454 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l 340282366920938463463374607431768211454'

echo '$ test-expr -e '\''int(8)'\'' -l '\''"340282366920938463463374607431768211454"'\'''
test-expr -e 'int(8)' -l '"340282366920938463463374607431768211454"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l '\''"340282366920938463463374607431768211454"'\'''

echo '$ test-expr -e '\''int(16)'\'' -l 340282366920938463463374607431768211454'
test-expr -e 'int(16)' -l 340282366920938463463374607431768211454 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l 340282366920938463463374607431768211454'

echo '$ test-expr -e '\''int(16)'\'' -l '\''"340282366920938463463374607431768211454"'\'''
test-expr -e 'int(16)' -l '"340282366920938463463374607431768211454"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l '\''"340282366920938463463374607431768211454"'\'''

echo '$ test-expr -e '\''int(32)'\'' -l 340282366920938463463374607431768211454'
test-expr -e 'int(32)' -l 340282366920938463463374607431768211454 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l 340282366920938463463374607431768211454'

echo '$ test-expr -e '\''int(32)'\'' -l '\''"340282366920938463463374607431768211454"'\'''
test-expr -e 'int(32)' -l '"340282366920938463463374607431768211454"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l '\''"340282366920938463463374607431768211454"'\'''

echo '$ test-expr -e '\''int(64)'\'' -l 340282366920938463463374607431768211454'
test-expr -e 'int(64)' -l 340282366920938463463374607431768211454 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l 340282366920938463463374607431768211454'

echo '$ test-expr -e '\''int(64)'\'' -l '\''"340282366920938463463374607431768211454"'\'''
test-expr -e 'int(64)' -l '"340282366920938463463374607431768211454"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l '\''"340282366920938463463374607431768211454"'\'''

echo '$ test-expr -e '\''uint(8)'\'' -l 340282366920938463463374607431768211454'
test-expr -e 'uint(8)' -l 340282366920938463463374607431768211454 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l 340282366920938463463374607431768211454'

echo '$ test-expr -e '\''uint(8)'\'' -l '\''"340282366920938463463374607431768211454"'\'''
test-expr -e 'uint(8)' -l '"340282366920938463463374607431768211454"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l '\''"340282366920938463463374607431768211454"'\'''

echo '$ test-expr -e '\''uint(16)'\'' -l 340282366920938463463374607431768211454'
test-expr -e 'uint(16)' -l 340282366920938463463374607431768211454 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l 340282366920938463463374607431768211454'

echo '$ test-expr -e '\''uint(16)'\'' -l '\''"340282366920938463463374607431768211454"'\'''
test-expr -e 'uint(16)' -l '"340282366920938463463374607431768211454"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l '\''"340282366920938463463374607431768211454"'\'''

echo '$ test-expr -e '\''uint(32)'\'' -l 340282366920938463463374607431768211454'
test-expr -e 'uint(32)' -l 340282366920938463463374607431768211454 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l 340282366920938463463374607431768211454'

echo '$ test-expr -e '\''uint(32)'\'' -l '\''"340282366920938463463374607431768211454"'\'''
test-expr -e 'uint(32)' -l '"340282366920938463463374607431768211454"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l '\''"340282366920938463463374607431768211454"'\'''

echo '$ test-expr -e '\''uint(64)'\'' -l 340282366920938463463374607431768211454'
test-expr -e 'uint(64)' -l 340282366920938463463374607431768211454 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l 340282366920938463463374607431768211454'

echo '$ test-expr -e '\''uint(64)'\'' -l '\''"340282366920938463463374607431768211454"'\'''
test-expr -e 'uint(64)' -l '"340282366920938463463374607431768211454"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l '\''"340282366920938463463374607431768211454"'\'''

echo '$ test-expr -e '\''int(8)'\'' -l 340282366920938463463374607431768211455'
test-expr -e 'int(8)' -l 340282366920938463463374607431768211455 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l 340282366920938463463374607431768211455'

echo '$ test-expr -e '\''int(8)'\'' -l '\''"340282366920938463463374607431768211455"'\'''
test-expr -e 'int(8)' -l '"340282366920938463463374607431768211455"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l '\''"340282366920938463463374607431768211455"'\'''

echo '$ test-expr -e '\''int(16)'\'' -l 340282366920938463463374607431768211455'
test-expr -e 'int(16)' -l 340282366920938463463374607431768211455 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l 340282366920938463463374607431768211455'

echo '$ test-expr -e '\''int(16)'\'' -l '\''"340282366920938463463374607431768211455"'\'''
test-expr -e 'int(16)' -l '"340282366920938463463374607431768211455"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l '\''"340282366920938463463374607431768211455"'\'''

echo '$ test-expr -e '\''int(32)'\'' -l 340282366920938463463374607431768211455'
test-expr -e 'int(32)' -l 340282366920938463463374607431768211455 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l 340282366920938463463374607431768211455'

echo '$ test-expr -e '\''int(32)'\'' -l '\''"340282366920938463463374607431768211455"'\'''
test-expr -e 'int(32)' -l '"340282366920938463463374607431768211455"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l '\''"340282366920938463463374607431768211455"'\'''

echo '$ test-expr -e '\''int(64)'\'' -l 340282366920938463463374607431768211455'
test-expr -e 'int(64)' -l 340282366920938463463374607431768211455 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l 340282366920938463463374607431768211455'

echo '$ test-expr -e '\''int(64)'\'' -l '\''"340282366920938463463374607431768211455"'\'''
test-expr -e 'int(64)' -l '"340282366920938463463374607431768211455"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l '\''"340282366920938463463374607431768211455"'\'''

echo '$ test-expr -e '\''uint(8)'\'' -l 340282366920938463463374607431768211455'
test-expr -e 'uint(8)' -l 340282366920938463463374607431768211455 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l 340282366920938463463374607431768211455'

echo '$ test-expr -e '\''uint(8)'\'' -l '\''"340282366920938463463374607431768211455"'\'''
test-expr -e 'uint(8)' -l '"340282366920938463463374607431768211455"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l '\''"340282366920938463463374607431768211455"'\'''

echo '$ test-expr -e '\''uint(16)'\'' -l 340282366920938463463374607431768211455'
test-expr -e 'uint(16)' -l 340282366920938463463374607431768211455 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l 340282366920938463463374607431768211455'

echo '$ test-expr -e '\''uint(16)'\'' -l '\''"340282366920938463463374607431768211455"'\'''
test-expr -e 'uint(16)' -l '"340282366920938463463374607431768211455"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l '\''"340282366920938463463374607431768211455"'\'''

echo '$ test-expr -e '\''uint(32)'\'' -l 340282366920938463463374607431768211455'
test-expr -e 'uint(32)' -l 340282366920938463463374607431768211455 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l 340282366920938463463374607431768211455'

echo '$ test-expr -e '\''uint(32)'\'' -l '\''"340282366920938463463374607431768211455"'\'''
test-expr -e 'uint(32)' -l '"340282366920938463463374607431768211455"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l '\''"340282366920938463463374607431768211455"'\'''

echo '$ test-expr -e '\''uint(64)'\'' -l 340282366920938463463374607431768211455'
test-expr -e 'uint(64)' -l 340282366920938463463374607431768211455 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l 340282366920938463463374607431768211455'

echo '$ test-expr -e '\''uint(64)'\'' -l '\''"340282366920938463463374607431768211455"'\'''
test-expr -e 'uint(64)' -l '"340282366920938463463374607431768211455"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l '\''"340282366920938463463374607431768211455"'\'''

echo '$ test-expr -e '\''int(8)'\'' -l 340282366920938463463374607431768211456'
test-expr -e 'int(8)' -l 340282366920938463463374607431768211456 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l 340282366920938463463374607431768211456'

echo '$ test-expr -e '\''int(8)'\'' -l '\''"340282366920938463463374607431768211456"'\'''
test-expr -e 'int(8)' -l '"340282366920938463463374607431768211456"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(8)'\'' -l '\''"340282366920938463463374607431768211456"'\'''

echo '$ test-expr -e '\''int(16)'\'' -l 340282366920938463463374607431768211456'
test-expr -e 'int(16)' -l 340282366920938463463374607431768211456 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l 340282366920938463463374607431768211456'

echo '$ test-expr -e '\''int(16)'\'' -l '\''"340282366920938463463374607431768211456"'\'''
test-expr -e 'int(16)' -l '"340282366920938463463374607431768211456"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(16)'\'' -l '\''"340282366920938463463374607431768211456"'\'''

echo '$ test-expr -e '\''int(32)'\'' -l 340282366920938463463374607431768211456'
test-expr -e 'int(32)' -l 340282366920938463463374607431768211456 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l 340282366920938463463374607431768211456'

echo '$ test-expr -e '\''int(32)'\'' -l '\''"340282366920938463463374607431768211456"'\'''
test-expr -e 'int(32)' -l '"340282366920938463463374607431768211456"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(32)'\'' -l '\''"340282366920938463463374607431768211456"'\'''

echo '$ test-expr -e '\''int(64)'\'' -l 340282366920938463463374607431768211456'
test-expr -e 'int(64)' -l 340282366920938463463374607431768211456 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l 340282366920938463463374607431768211456'

echo '$ test-expr -e '\''int(64)'\'' -l '\''"340282366920938463463374607431768211456"'\'''
test-expr -e 'int(64)' -l '"340282366920938463463374607431768211456"' 2>&1 ||
echo 'command failed: test-expr -e '\''int(64)'\'' -l '\''"340282366920938463463374607431768211456"'\'''

echo '$ test-expr -e '\''uint(8)'\'' -l 340282366920938463463374607431768211456'
test-expr -e 'uint(8)' -l 340282366920938463463374607431768211456 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l 340282366920938463463374607431768211456'

echo '$ test-expr -e '\''uint(8)'\'' -l '\''"340282366920938463463374607431768211456"'\'''
test-expr -e 'uint(8)' -l '"340282366920938463463374607431768211456"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(8)'\'' -l '\''"340282366920938463463374607431768211456"'\'''

echo '$ test-expr -e '\''uint(16)'\'' -l 340282366920938463463374607431768211456'
test-expr -e 'uint(16)' -l 340282366920938463463374607431768211456 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l 340282366920938463463374607431768211456'

echo '$ test-expr -e '\''uint(16)'\'' -l '\''"340282366920938463463374607431768211456"'\'''
test-expr -e 'uint(16)' -l '"340282366920938463463374607431768211456"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(16)'\'' -l '\''"340282366920938463463374607431768211456"'\'''

echo '$ test-expr -e '\''uint(32)'\'' -l 340282366920938463463374607431768211456'
test-expr -e 'uint(32)' -l 340282366920938463463374607431768211456 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l 340282366920938463463374607431768211456'

echo '$ test-expr -e '\''uint(32)'\'' -l '\''"340282366920938463463374607431768211456"'\'''
test-expr -e 'uint(32)' -l '"340282366920938463463374607431768211456"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(32)'\'' -l '\''"340282366920938463463374607431768211456"'\'''

echo '$ test-expr -e '\''uint(64)'\'' -l 340282366920938463463374607431768211456'
test-expr -e 'uint(64)' -l 340282366920938463463374607431768211456 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l 340282366920938463463374607431768211456'

echo '$ test-expr -e '\''uint(64)'\'' -l '\''"340282366920938463463374607431768211456"'\'''
test-expr -e 'uint(64)' -l '"340282366920938463463374607431768211456"' 2>&1 ||
echo 'command failed: test-expr -e '\''uint(64)'\'' -l '\''"340282366920938463463374607431768211456"'\'''
)

