#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C bugs:44
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L 44.old <(echo \
'$ json() { local n='\'''\''; [ "$1" == '\''--null'\'' ] && { n='\'' >/dev/null'\''; shift; }; eval "set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --verbose $@$n"; }
$ echo -e '\''t\xc2\xa0'\''|json -S -uV
t\u00a0\n
$ echo -e '\''t\xc2'\''|json --null -S -uV
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: t\xc2
json: error: <stdin>:1:3:      ^
command failed: echo -e '\''t\xc2'\''|json --null -S -uV
$ echo -e '\''t\xa0'\''|json --null -S -uV
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: t\xa0
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''t\xa0'\''|json --null -S -uV
$ echo -e '\''\t\xc2\xa0'\''|json -S -uV
\t\u00a0\n
$ echo -e '\''\t\xc2'\''|json --null -S -uV
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \t\xc2
json: error: <stdin>:1:3:       ^
command failed: echo -e '\''\t\xc2'\''|json --null -S -uV
$ echo -e '\''\t\xa0'\''|json --null -S -uV
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \t\xa0
json: error: <stdin>:1:2:   ^
command failed: echo -e '\''\t\xa0'\''|json --null -S -uV
$ echo -e '\''\xe2\x80\xa0\xc3\xa0'\''|json -S -uV
\u2020\u00e0\n
$ echo -e '\''\xe2\x80\xa0\xc3'\''|json --null -S -uV
json: error: <stdin>:1:5: invalid utf-8 encoding
json: error: <stdin>:1:5: \xe2\x80\xa0\xc3
json: error: <stdin>:1:5:                 ^
command failed: echo -e '\''\xe2\x80\xa0\xc3'\''|json --null -S -uV
$ echo -e '\''\xe2\x80\xa0\xa0'\''|json --null -S -uV
json: error: <stdin>:1:4: invalid utf-8 encoding
json: error: <stdin>:1:4: \xe2\x80\xa0\xa0
json: error: <stdin>:1:4:             ^
command failed: echo -e '\''\xe2\x80\xa0\xa0'\''|json --null -S -uV
$ echo -e '\''\xf0\x90\x80\x80\xc3\xa0'\''|json -S -uV
json: error: <stdin>:1:1: non-BMP utf-8 encoding
json: error: <stdin>:1:1: \xf0\x90\x80\x80\xc3\xa0
json: error: <stdin>:1:1: ^
command failed: echo -e '\''\xf0\x90\x80\x80\xc3\xa0'\''|json -S -uV
$ echo -e '\''\xf0\x90\x80\x80\xc3\xa0'\''|json -S -uV -s
\ud800\udc00\u00e0\n
$ echo -e '\''\xf0\x90\x80\x80\xc3'\''|json --null -S -uV -s
json: error: <stdin>:1:6: invalid utf-8 encoding
json: error: <stdin>:1:6: \xf0\x90\x80\x80\xc3
json: error: <stdin>:1:6:                     ^
command failed: echo -e '\''\xf0\x90\x80\x80\xc3'\''|json --null -S -uV -s
$ echo -e '\''\xf0\x90\x80\x80\xa0'\''|json --null -S -uV -s
json: error: <stdin>:1:5: invalid utf-8 encoding
json: error: <stdin>:1:5: \xf0\x90\x80\x80\xa0
json: error: <stdin>:1:5:                 ^
command failed: echo -e '\''\xf0\x90\x80\x80\xa0'\''|json --null -S -uV -s
$ echo -e '\''"t\xc2\xa0"'\''|json -O -luV && echo OK
OK
$ echo -e '\''"t\xc2"'\''|json -O -luV
json: error: <stdin>:1:4: lex error: invalid utf-8 encoding
json: error: <stdin>:1:4: "t\xc2"
json: error: <stdin>:1:4:       ^
command failed: echo -e '\''"t\xc2"'\''|json -O -luV
$ echo -e '\''"t\xa0"'\''|json -O -luV
json: error: <stdin>:1:3: lex error: invalid utf-8 encoding
json: error: <stdin>:1:3: "t\xa0"
json: error: <stdin>:1:3:   ^
command failed: echo -e '\''"t\xa0"'\''|json -O -luV
$ echo -e '\''"\\t\xc2\xa0"'\''|json -O -luV && echo OK
OK
$ echo -e '\''"\\t\xc2"'\''|json -O -luV
json: error: <stdin>:1:5: lex error: invalid utf-8 encoding
json: error: <stdin>:1:5: "\\t\xc2"
json: error: <stdin>:1:5:         ^
command failed: echo -e '\''"\\t\xc2"'\''|json -O -luV
$ echo -e '\''"\\t\xa0"'\''|json -O -luV
json: error: <stdin>:1:4: lex error: invalid utf-8 encoding
json: error: <stdin>:1:4: "\\t\xa0"
json: error: <stdin>:1:4:     ^
command failed: echo -e '\''"\\t\xa0"'\''|json -O -luV
$ echo -e '\''"\\u2020\xc3\xa0"'\''|json -O -luV && echo OK
OK
$ echo -e '\''"\\u2020\xc3"'\''|json -O -luV
json: error: <stdin>:1:9: lex error: invalid utf-8 encoding
json: error: <stdin>:1:9: "\\u2020\xc3"
json: error: <stdin>:1:9:             ^
command failed: echo -e '\''"\\u2020\xc3"'\''|json -O -luV
$ echo -e '\''"\\u2020\xa0"'\''|json -O -luV
json: error: <stdin>:1:8: lex error: invalid utf-8 encoding
json: error: <stdin>:1:8: "\\u2020\xa0"
json: error: <stdin>:1:8:         ^
command failed: echo -e '\''"\\u2020\xa0"'\''|json -O -luV
$ echo -e '\''"\\ud800\\udc00\xc3\xa0"'\''|json -O -luV -s && echo OK
OK
$ echo -e '\''"\\ud800\\udc00\xc3"'\''|json -O -luV -s
json: error: <stdin>:1:15: lex error: invalid utf-8 encoding
json: error: <stdin>:1:15: "\\ud800\\udc00\xc3"
json: error: <stdin>:1:15:                    ^
command failed: echo -e '\''"\\ud800\\udc00\xc3"'\''|json -O -luV -s
$ echo -e '\''"\\ud800\\udc00\xa0"'\''|json -O -luV -s
json: error: <stdin>:1:14: lex error: invalid utf-8 encoding
json: error: <stdin>:1:14: "\\ud800\\udc00\xa0"
json: error: <stdin>:1:14:                ^
command failed: echo -e '\''"\\ud800\\udc00\xa0"'\''|json -O -luV -s'
) -L 44.new <(
echo '$ json() { local n='\'''\''; [ "$1" == '\''--null'\'' ] && { n='\'' >/dev/null'\''; shift; }; eval "set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --verbose $@$n"; }'
json() { local n=''; [ "$1" == '--null' ] && { n=' >/dev/null'; shift; }; eval "set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --verbose $@$n"; } 2>&1 ||
echo 'command failed: json() { local n='\'''\''; [ "$1" == '\''--null'\'' ] && { n='\'' >/dev/null'\''; shift; }; eval "set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --verbose $@$n"; }'

echo '$ echo -e '\''t\xc2\xa0'\''|json -S -uV'
echo -e 't\xc2\xa0'|json -S -uV 2>&1 ||
echo 'command failed: echo -e '\''t\xc2\xa0'\''|json -S -uV'

echo '$ echo -e '\''t\xc2'\''|json --null -S -uV'
echo -e 't\xc2'|json --null -S -uV 2>&1 ||
echo 'command failed: echo -e '\''t\xc2'\''|json --null -S -uV'

echo '$ echo -e '\''t\xa0'\''|json --null -S -uV'
echo -e 't\xa0'|json --null -S -uV 2>&1 ||
echo 'command failed: echo -e '\''t\xa0'\''|json --null -S -uV'

echo '$ echo -e '\''\t\xc2\xa0'\''|json -S -uV'
echo -e '\t\xc2\xa0'|json -S -uV 2>&1 ||
echo 'command failed: echo -e '\''\t\xc2\xa0'\''|json -S -uV'

echo '$ echo -e '\''\t\xc2'\''|json --null -S -uV'
echo -e '\t\xc2'|json --null -S -uV 2>&1 ||
echo 'command failed: echo -e '\''\t\xc2'\''|json --null -S -uV'

echo '$ echo -e '\''\t\xa0'\''|json --null -S -uV'
echo -e '\t\xa0'|json --null -S -uV 2>&1 ||
echo 'command failed: echo -e '\''\t\xa0'\''|json --null -S -uV'

echo '$ echo -e '\''\xe2\x80\xa0\xc3\xa0'\''|json -S -uV'
echo -e '\xe2\x80\xa0\xc3\xa0'|json -S -uV 2>&1 ||
echo 'command failed: echo -e '\''\xe2\x80\xa0\xc3\xa0'\''|json -S -uV'

echo '$ echo -e '\''\xe2\x80\xa0\xc3'\''|json --null -S -uV'
echo -e '\xe2\x80\xa0\xc3'|json --null -S -uV 2>&1 ||
echo 'command failed: echo -e '\''\xe2\x80\xa0\xc3'\''|json --null -S -uV'

echo '$ echo -e '\''\xe2\x80\xa0\xa0'\''|json --null -S -uV'
echo -e '\xe2\x80\xa0\xa0'|json --null -S -uV 2>&1 ||
echo 'command failed: echo -e '\''\xe2\x80\xa0\xa0'\''|json --null -S -uV'

echo '$ echo -e '\''\xf0\x90\x80\x80\xc3\xa0'\''|json -S -uV'
echo -e '\xf0\x90\x80\x80\xc3\xa0'|json -S -uV 2>&1 ||
echo 'command failed: echo -e '\''\xf0\x90\x80\x80\xc3\xa0'\''|json -S -uV'

echo '$ echo -e '\''\xf0\x90\x80\x80\xc3\xa0'\''|json -S -uV -s'
echo -e '\xf0\x90\x80\x80\xc3\xa0'|json -S -uV -s 2>&1 ||
echo 'command failed: echo -e '\''\xf0\x90\x80\x80\xc3\xa0'\''|json -S -uV -s'

echo '$ echo -e '\''\xf0\x90\x80\x80\xc3'\''|json --null -S -uV -s'
echo -e '\xf0\x90\x80\x80\xc3'|json --null -S -uV -s 2>&1 ||
echo 'command failed: echo -e '\''\xf0\x90\x80\x80\xc3'\''|json --null -S -uV -s'

echo '$ echo -e '\''\xf0\x90\x80\x80\xa0'\''|json --null -S -uV -s'
echo -e '\xf0\x90\x80\x80\xa0'|json --null -S -uV -s 2>&1 ||
echo 'command failed: echo -e '\''\xf0\x90\x80\x80\xa0'\''|json --null -S -uV -s'

echo '$ echo -e '\''"t\xc2\xa0"'\''|json -O -luV && echo OK'
echo -e '"t\xc2\xa0"'|json -O -luV && echo OK 2>&1 ||
echo 'command failed: echo -e '\''"t\xc2\xa0"'\''|json -O -luV && echo OK'

echo '$ echo -e '\''"t\xc2"'\''|json -O -luV'
echo -e '"t\xc2"'|json -O -luV 2>&1 ||
echo 'command failed: echo -e '\''"t\xc2"'\''|json -O -luV'

echo '$ echo -e '\''"t\xa0"'\''|json -O -luV'
echo -e '"t\xa0"'|json -O -luV 2>&1 ||
echo 'command failed: echo -e '\''"t\xa0"'\''|json -O -luV'

echo '$ echo -e '\''"\\t\xc2\xa0"'\''|json -O -luV && echo OK'
echo -e '"\\t\xc2\xa0"'|json -O -luV && echo OK 2>&1 ||
echo 'command failed: echo -e '\''"\\t\xc2\xa0"'\''|json -O -luV && echo OK'

echo '$ echo -e '\''"\\t\xc2"'\''|json -O -luV'
echo -e '"\\t\xc2"'|json -O -luV 2>&1 ||
echo 'command failed: echo -e '\''"\\t\xc2"'\''|json -O -luV'

echo '$ echo -e '\''"\\t\xa0"'\''|json -O -luV'
echo -e '"\\t\xa0"'|json -O -luV 2>&1 ||
echo 'command failed: echo -e '\''"\\t\xa0"'\''|json -O -luV'

echo '$ echo -e '\''"\\u2020\xc3\xa0"'\''|json -O -luV && echo OK'
echo -e '"\\u2020\xc3\xa0"'|json -O -luV && echo OK 2>&1 ||
echo 'command failed: echo -e '\''"\\u2020\xc3\xa0"'\''|json -O -luV && echo OK'

echo '$ echo -e '\''"\\u2020\xc3"'\''|json -O -luV'
echo -e '"\\u2020\xc3"'|json -O -luV 2>&1 ||
echo 'command failed: echo -e '\''"\\u2020\xc3"'\''|json -O -luV'

echo '$ echo -e '\''"\\u2020\xa0"'\''|json -O -luV'
echo -e '"\\u2020\xa0"'|json -O -luV 2>&1 ||
echo 'command failed: echo -e '\''"\\u2020\xa0"'\''|json -O -luV'

echo '$ echo -e '\''"\\ud800\\udc00\xc3\xa0"'\''|json -O -luV -s && echo OK'
echo -e '"\\ud800\\udc00\xc3\xa0"'|json -O -luV -s && echo OK 2>&1 ||
echo 'command failed: echo -e '\''"\\ud800\\udc00\xc3\xa0"'\''|json -O -luV -s && echo OK'

echo '$ echo -e '\''"\\ud800\\udc00\xc3"'\''|json -O -luV -s'
echo -e '"\\ud800\\udc00\xc3"'|json -O -luV -s 2>&1 ||
echo 'command failed: echo -e '\''"\\ud800\\udc00\xc3"'\''|json -O -luV -s'

echo '$ echo -e '\''"\\ud800\\udc00\xa0"'\''|json -O -luV -s'
echo -e '"\\ud800\\udc00\xa0"'|json -O -luV -s 2>&1 ||
echo 'command failed: echo -e '\''"\\ud800\\udc00\xa0"'\''|json -O -luV -s'
)

