#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-lib:obj-type-name
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L obj-type-name.old <(echo \
'$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }
$ json <<< '\''{"type":"a"}'\''
json: error: <stdin>:1:9: meta error: invalid "type" object: type not "object", "array", "list" or "dict"
json: error: <stdin>:1:9: {"type":"a"}
json: error: <stdin>:1:9:         ^
command failed: json <<< '\''{"type":"a"}'\''
$ json <<< '\''{"type":"a?"}'\''
json: error: <stdin>:1:9: meta error: invalid "type" object: type not "object", "array", "list" or "dict"
json: error: <stdin>:1:9: {"type":"a?"}
json: error: <stdin>:1:9:         ^
command failed: json <<< '\''{"type":"a?"}'\''
$ json <<< '\''{"type":"ar"}'\''
json: error: <stdin>:1:9: meta error: invalid "type" object: type not "object", "array", "list" or "dict"
json: error: <stdin>:1:9: {"type":"ar"}
json: error: <stdin>:1:9:         ^
command failed: json <<< '\''{"type":"ar"}'\''
$ json <<< '\''{"type":"ar?"}'\''
json: error: <stdin>:1:9: meta error: invalid "type" object: type not "object", "array", "list" or "dict"
json: error: <stdin>:1:9: {"type":"ar?"}
json: error: <stdin>:1:9:         ^
command failed: json <<< '\''{"type":"ar?"}'\''
$ json <<< '\''{"type":"arr"}'\''
json: error: <stdin>:1:9: meta error: invalid "type" object: type not "object", "array", "list" or "dict"
json: error: <stdin>:1:9: {"type":"arr"}
json: error: <stdin>:1:9:         ^
command failed: json <<< '\''{"type":"arr"}'\''
$ json <<< '\''{"type":"arr?"}'\''
json: error: <stdin>:1:9: meta error: invalid "type" object: type not "object", "array", "list" or "dict"
json: error: <stdin>:1:9: {"type":"arr?"}
json: error: <stdin>:1:9:         ^
command failed: json <<< '\''{"type":"arr?"}'\''
$ json <<< '\''{"type":"arra"}'\''
json: error: <stdin>:1:9: meta error: invalid "type" object: type not "object", "array", "list" or "dict"
json: error: <stdin>:1:9: {"type":"arra"}
json: error: <stdin>:1:9:         ^
command failed: json <<< '\''{"type":"arra"}'\''
$ json <<< '\''{"type":"arra?"}'\''
json: error: <stdin>:1:9: meta error: invalid "type" object: type not "object", "array", "list" or "dict"
json: error: <stdin>:1:9: {"type":"arra?"}
json: error: <stdin>:1:9:         ^
command failed: json <<< '\''{"type":"arra?"}'\''
$ json <<< '\''{"type":"array"}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: arguments not of size two
json: error: <stdin>:1:1: {"type":"array"}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"array"}'\''
$ json <<< '\''{"type":"array?"}'\''
json: error: <stdin>:1:9: meta error: invalid "type" object: type not "object", "array", "list" or "dict"
json: error: <stdin>:1:9: {"type":"array?"}
json: error: <stdin>:1:9:         ^
command failed: json <<< '\''{"type":"array?"}'\''
$ json <<< '\''{"type":"d"}'\''
json: error: <stdin>:1:9: meta error: invalid "type" object: type not "object", "array", "list" or "dict"
json: error: <stdin>:1:9: {"type":"d"}
json: error: <stdin>:1:9:         ^
command failed: json <<< '\''{"type":"d"}'\''
$ json <<< '\''{"type":"d?"}'\''
json: error: <stdin>:1:9: meta error: invalid "type" object: type not "object", "array", "list" or "dict"
json: error: <stdin>:1:9: {"type":"d?"}
json: error: <stdin>:1:9:         ^
command failed: json <<< '\''{"type":"d?"}'\''
$ json <<< '\''{"type":"di"}'\''
json: error: <stdin>:1:9: meta error: invalid "type" object: type not "object", "array", "list" or "dict"
json: error: <stdin>:1:9: {"type":"di"}
json: error: <stdin>:1:9:         ^
command failed: json <<< '\''{"type":"di"}'\''
$ json <<< '\''{"type":"di?"}'\''
json: error: <stdin>:1:9: meta error: invalid "type" object: type not "object", "array", "list" or "dict"
json: error: <stdin>:1:9: {"type":"di?"}
json: error: <stdin>:1:9:         ^
command failed: json <<< '\''{"type":"di?"}'\''
$ json <<< '\''{"type":"dic"}'\''
json: error: <stdin>:1:9: meta error: invalid "type" object: type not "object", "array", "list" or "dict"
json: error: <stdin>:1:9: {"type":"dic"}
json: error: <stdin>:1:9:         ^
command failed: json <<< '\''{"type":"dic"}'\''
$ json <<< '\''{"type":"dic?"}'\''
json: error: <stdin>:1:9: meta error: invalid "type" object: type not "object", "array", "list" or "dict"
json: error: <stdin>:1:9: {"type":"dic?"}
json: error: <stdin>:1:9:         ^
command failed: json <<< '\''{"type":"dic?"}'\''
$ json <<< '\''{"type":"dict"}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: arguments not of size two or three
json: error: <stdin>:1:1: {"type":"dict"}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"dict"}'\''
$ json <<< '\''{"type":"dict?"}'\''
json: error: <stdin>:1:9: meta error: invalid "type" object: type not "object", "array", "list" or "dict"
json: error: <stdin>:1:9: {"type":"dict?"}
json: error: <stdin>:1:9:         ^
command failed: json <<< '\''{"type":"dict?"}'\''
$ json <<< '\''{"type":"l"}'\''
json: error: <stdin>:1:9: meta error: invalid "type" object: type not "object", "array", "list" or "dict"
json: error: <stdin>:1:9: {"type":"l"}
json: error: <stdin>:1:9:         ^
command failed: json <<< '\''{"type":"l"}'\''
$ json <<< '\''{"type":"l?"}'\''
json: error: <stdin>:1:9: meta error: invalid "type" object: type not "object", "array", "list" or "dict"
json: error: <stdin>:1:9: {"type":"l?"}
json: error: <stdin>:1:9:         ^
command failed: json <<< '\''{"type":"l?"}'\''
$ json <<< '\''{"type":"li"}'\''
json: error: <stdin>:1:9: meta error: invalid "type" object: type not "object", "array", "list" or "dict"
json: error: <stdin>:1:9: {"type":"li"}
json: error: <stdin>:1:9:         ^
command failed: json <<< '\''{"type":"li"}'\''
$ json <<< '\''{"type":"li?"}'\''
json: error: <stdin>:1:9: meta error: invalid "type" object: type not "object", "array", "list" or "dict"
json: error: <stdin>:1:9: {"type":"li?"}
json: error: <stdin>:1:9:         ^
command failed: json <<< '\''{"type":"li?"}'\''
$ json <<< '\''{"type":"lis"}'\''
json: error: <stdin>:1:9: meta error: invalid "type" object: type not "object", "array", "list" or "dict"
json: error: <stdin>:1:9: {"type":"lis"}
json: error: <stdin>:1:9:         ^
command failed: json <<< '\''{"type":"lis"}'\''
$ json <<< '\''{"type":"lis?"}'\''
json: error: <stdin>:1:9: meta error: invalid "type" object: type not "object", "array", "list" or "dict"
json: error: <stdin>:1:9: {"type":"lis?"}
json: error: <stdin>:1:9:         ^
command failed: json <<< '\''{"type":"lis?"}'\''
$ json <<< '\''{"type":"list"}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: arguments not of size two
json: error: <stdin>:1:1: {"type":"list"}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"list"}'\''
$ json <<< '\''{"type":"list?"}'\''
json: error: <stdin>:1:9: meta error: invalid "type" object: type not "object", "array", "list" or "dict"
json: error: <stdin>:1:9: {"type":"list?"}
json: error: <stdin>:1:9:         ^
command failed: json <<< '\''{"type":"list?"}'\''
$ json <<< '\''{"type":"o"}'\''
json: error: <stdin>:1:9: meta error: invalid "type" object: type not "object", "array", "list" or "dict"
json: error: <stdin>:1:9: {"type":"o"}
json: error: <stdin>:1:9:         ^
command failed: json <<< '\''{"type":"o"}'\''
$ json <<< '\''{"type":"o?"}'\''
json: error: <stdin>:1:9: meta error: invalid "type" object: type not "object", "array", "list" or "dict"
json: error: <stdin>:1:9: {"type":"o?"}
json: error: <stdin>:1:9:         ^
command failed: json <<< '\''{"type":"o?"}'\''
$ json <<< '\''{"type":"ob"}'\''
json: error: <stdin>:1:9: meta error: invalid "type" object: type not "object", "array", "list" or "dict"
json: error: <stdin>:1:9: {"type":"ob"}
json: error: <stdin>:1:9:         ^
command failed: json <<< '\''{"type":"ob"}'\''
$ json <<< '\''{"type":"ob?"}'\''
json: error: <stdin>:1:9: meta error: invalid "type" object: type not "object", "array", "list" or "dict"
json: error: <stdin>:1:9: {"type":"ob?"}
json: error: <stdin>:1:9:         ^
command failed: json <<< '\''{"type":"ob?"}'\''
$ json <<< '\''{"type":"obj"}'\''
json: error: <stdin>:1:9: meta error: invalid "type" object: type not "object", "array", "list" or "dict"
json: error: <stdin>:1:9: {"type":"obj"}
json: error: <stdin>:1:9:         ^
command failed: json <<< '\''{"type":"obj"}'\''
$ json <<< '\''{"type":"obj?"}'\''
json: error: <stdin>:1:9: meta error: invalid "type" object: type not "object", "array", "list" or "dict"
json: error: <stdin>:1:9: {"type":"obj?"}
json: error: <stdin>:1:9:         ^
command failed: json <<< '\''{"type":"obj?"}'\''
$ json <<< '\''{"type":"obje"}'\''
json: error: <stdin>:1:9: meta error: invalid "type" object: type not "object", "array", "list" or "dict"
json: error: <stdin>:1:9: {"type":"obje"}
json: error: <stdin>:1:9:         ^
command failed: json <<< '\''{"type":"obje"}'\''
$ json <<< '\''{"type":"obje?"}'\''
json: error: <stdin>:1:9: meta error: invalid "type" object: type not "object", "array", "list" or "dict"
json: error: <stdin>:1:9: {"type":"obje?"}
json: error: <stdin>:1:9:         ^
command failed: json <<< '\''{"type":"obje?"}'\''
$ json <<< '\''{"type":"objec"}'\''
json: error: <stdin>:1:9: meta error: invalid "type" object: type not "object", "array", "list" or "dict"
json: error: <stdin>:1:9: {"type":"objec"}
json: error: <stdin>:1:9:         ^
command failed: json <<< '\''{"type":"objec"}'\''
$ json <<< '\''{"type":"objec?"}'\''
json: error: <stdin>:1:9: meta error: invalid "type" object: type not "object", "array", "list" or "dict"
json: error: <stdin>:1:9: {"type":"objec?"}
json: error: <stdin>:1:9:         ^
command failed: json <<< '\''{"type":"objec?"}'\''
$ json <<< '\''{"type":"object"}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: arguments not of size two
json: error: <stdin>:1:1: {"type":"object"}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"object"}'\''
$ json <<< '\''{"type":"object?"}'\''
json: error: <stdin>:1:9: meta error: invalid "type" object: type not "object", "array", "list" or "dict"
json: error: <stdin>:1:9: {"type":"object?"}
json: error: <stdin>:1:9:         ^
command failed: json <<< '\''{"type":"object?"}'\'''
) -L obj-type-name.new <(
echo '$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }'
json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; } 2>&1 ||
echo 'command failed: json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }'

echo '$ json <<< '\''{"type":"a"}'\'''
json <<< '{"type":"a"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"a"}'\'''

echo '$ json <<< '\''{"type":"a?"}'\'''
json <<< '{"type":"a?"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"a?"}'\'''

echo '$ json <<< '\''{"type":"ar"}'\'''
json <<< '{"type":"ar"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"ar"}'\'''

echo '$ json <<< '\''{"type":"ar?"}'\'''
json <<< '{"type":"ar?"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"ar?"}'\'''

echo '$ json <<< '\''{"type":"arr"}'\'''
json <<< '{"type":"arr"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"arr"}'\'''

echo '$ json <<< '\''{"type":"arr?"}'\'''
json <<< '{"type":"arr?"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"arr?"}'\'''

echo '$ json <<< '\''{"type":"arra"}'\'''
json <<< '{"type":"arra"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"arra"}'\'''

echo '$ json <<< '\''{"type":"arra?"}'\'''
json <<< '{"type":"arra?"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"arra?"}'\'''

echo '$ json <<< '\''{"type":"array"}'\'''
json <<< '{"type":"array"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array"}'\'''

echo '$ json <<< '\''{"type":"array?"}'\'''
json <<< '{"type":"array?"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array?"}'\'''

echo '$ json <<< '\''{"type":"d"}'\'''
json <<< '{"type":"d"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"d"}'\'''

echo '$ json <<< '\''{"type":"d?"}'\'''
json <<< '{"type":"d?"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"d?"}'\'''

echo '$ json <<< '\''{"type":"di"}'\'''
json <<< '{"type":"di"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"di"}'\'''

echo '$ json <<< '\''{"type":"di?"}'\'''
json <<< '{"type":"di?"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"di?"}'\'''

echo '$ json <<< '\''{"type":"dic"}'\'''
json <<< '{"type":"dic"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"dic"}'\'''

echo '$ json <<< '\''{"type":"dic?"}'\'''
json <<< '{"type":"dic?"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"dic?"}'\'''

echo '$ json <<< '\''{"type":"dict"}'\'''
json <<< '{"type":"dict"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"dict"}'\'''

echo '$ json <<< '\''{"type":"dict?"}'\'''
json <<< '{"type":"dict?"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"dict?"}'\'''

echo '$ json <<< '\''{"type":"l"}'\'''
json <<< '{"type":"l"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"l"}'\'''

echo '$ json <<< '\''{"type":"l?"}'\'''
json <<< '{"type":"l?"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"l?"}'\'''

echo '$ json <<< '\''{"type":"li"}'\'''
json <<< '{"type":"li"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"li"}'\'''

echo '$ json <<< '\''{"type":"li?"}'\'''
json <<< '{"type":"li?"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"li?"}'\'''

echo '$ json <<< '\''{"type":"lis"}'\'''
json <<< '{"type":"lis"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"lis"}'\'''

echo '$ json <<< '\''{"type":"lis?"}'\'''
json <<< '{"type":"lis?"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"lis?"}'\'''

echo '$ json <<< '\''{"type":"list"}'\'''
json <<< '{"type":"list"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list"}'\'''

echo '$ json <<< '\''{"type":"list?"}'\'''
json <<< '{"type":"list?"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list?"}'\'''

echo '$ json <<< '\''{"type":"o"}'\'''
json <<< '{"type":"o"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"o"}'\'''

echo '$ json <<< '\''{"type":"o?"}'\'''
json <<< '{"type":"o?"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"o?"}'\'''

echo '$ json <<< '\''{"type":"ob"}'\'''
json <<< '{"type":"ob"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"ob"}'\'''

echo '$ json <<< '\''{"type":"ob?"}'\'''
json <<< '{"type":"ob?"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"ob?"}'\'''

echo '$ json <<< '\''{"type":"obj"}'\'''
json <<< '{"type":"obj"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"obj"}'\'''

echo '$ json <<< '\''{"type":"obj?"}'\'''
json <<< '{"type":"obj?"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"obj?"}'\'''

echo '$ json <<< '\''{"type":"obje"}'\'''
json <<< '{"type":"obje"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"obje"}'\'''

echo '$ json <<< '\''{"type":"obje?"}'\'''
json <<< '{"type":"obje?"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"obje?"}'\'''

echo '$ json <<< '\''{"type":"objec"}'\'''
json <<< '{"type":"objec"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"objec"}'\'''

echo '$ json <<< '\''{"type":"objec?"}'\'''
json <<< '{"type":"objec?"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"objec?"}'\'''

echo '$ json <<< '\''{"type":"object"}'\'''
json <<< '{"type":"object"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"object"}'\'''

echo '$ json <<< '\''{"type":"object?"}'\'''
json <<< '{"type":"object?"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"object?"}'\'''
)

