#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-lib:dict-expr-ascii
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L dict-expr-ascii.old <(echo \
'$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json -V -TA <<< '\''{"type":"dict","args":[{"name":"a","type":"number"},{"name":"b","type":"number"},{"name":"c","type":"number"}],"expr":'\''$'\''\n"'\''"$1"'\''"}'\''|sed -nr '\''s/^.*"bits":"([^"]*)".*$/\1/p'\''; }
$ json $'\''\x0'\''
json: error: <stdin>:2:2: meta error: invalid dict expression: unexpected end of expression
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n""}
json: error: <stdin>:2:2:                                  ^
command failed: json $'\''\x0'\''
$ json $'\''\x2'\''
json: error: <stdin>:2:2: parse error: invalid string literal
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"\x02"}
json: error: <stdin>:2:2:                                  ^
command failed: json $'\''\x2'\''
$ json $'\''\x3'\''
json: error: <stdin>:2:2: parse error: invalid string literal
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"\x03"}
json: error: <stdin>:2:2:                                  ^
command failed: json $'\''\x3'\''
$ json $'\''\x4'\''
json: error: <stdin>:2:2: parse error: invalid string literal
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"\x04"}
json: error: <stdin>:2:2:                                  ^
command failed: json $'\''\x4'\''
$ json $'\''\x5'\''
json: error: <stdin>:2:2: parse error: invalid string literal
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"\x05"}
json: error: <stdin>:2:2:                                  ^
command failed: json $'\''\x5'\''
$ json $'\''\x6'\''
json: error: <stdin>:2:2: parse error: invalid string literal
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"\x06"}
json: error: <stdin>:2:2:                                  ^
command failed: json $'\''\x6'\''
$ json $'\''\x7'\''
json: error: <stdin>:2:2: parse error: invalid string literal
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"\a"}
json: error: <stdin>:2:2:                                  ^
command failed: json $'\''\x7'\''
$ json $'\''\x8'\''
json: error: <stdin>:2:2: parse error: invalid string literal
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"\b"}
json: error: <stdin>:2:2:                                  ^
command failed: json $'\''\x8'\''
$ json $'\''\x9'\''
json: error: <stdin>:2:2: parse error: invalid string literal
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"\t"}
json: error: <stdin>:2:2:                                  ^
command failed: json $'\''\x9'\''
$ json $'\''\xa'\''
json: error: <stdin>:2:2: parse error: invalid string literal
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"\n"}
json: error: <stdin>:2:2:                                  ^
command failed: json $'\''\xa'\''
$ json $'\''\xb'\''
json: error: <stdin>:2:2: parse error: invalid string literal
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"\v"}
json: error: <stdin>:2:2:                                  ^
command failed: json $'\''\xb'\''
$ json $'\''\xc'\''
json: error: <stdin>:2:2: parse error: invalid string literal
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"\f"}
json: error: <stdin>:2:2:                                  ^
command failed: json $'\''\xc'\''
$ json $'\''\xd'\''
json: error: <stdin>:2:2: parse error: invalid string literal
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"\r"}
json: error: <stdin>:2:2:                                  ^
command failed: json $'\''\xd'\''
$ json $'\''\xe'\''
json: error: <stdin>:2:2: parse error: invalid string literal
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"\x0e"}
json: error: <stdin>:2:2:                                  ^
command failed: json $'\''\xe'\''
$ json $'\''\xf'\''
json: error: <stdin>:2:2: parse error: invalid string literal
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"\x0f"}
json: error: <stdin>:2:2:                                  ^
command failed: json $'\''\xf'\''
$ json $'\''\x10'\''
json: error: <stdin>:2:2: parse error: invalid string literal
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"\x10"}
json: error: <stdin>:2:2:                                  ^
command failed: json $'\''\x10'\''
$ json $'\''\x11'\''
json: error: <stdin>:2:2: parse error: invalid string literal
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"\x11"}
json: error: <stdin>:2:2:                                  ^
command failed: json $'\''\x11'\''
$ json $'\''\x12'\''
json: error: <stdin>:2:2: parse error: invalid string literal
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"\x12"}
json: error: <stdin>:2:2:                                  ^
command failed: json $'\''\x12'\''
$ json $'\''\x13'\''
json: error: <stdin>:2:2: parse error: invalid string literal
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"\x13"}
json: error: <stdin>:2:2:                                  ^
command failed: json $'\''\x13'\''
$ json $'\''\x14'\''
json: error: <stdin>:2:2: parse error: invalid string literal
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"\x14"}
json: error: <stdin>:2:2:                                  ^
command failed: json $'\''\x14'\''
$ json $'\''\x15'\''
json: error: <stdin>:2:2: parse error: invalid string literal
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"\x15"}
json: error: <stdin>:2:2:                                  ^
command failed: json $'\''\x15'\''
$ json $'\''\x16'\''
json: error: <stdin>:2:2: parse error: invalid string literal
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"\x16"}
json: error: <stdin>:2:2:                                  ^
command failed: json $'\''\x16'\''
$ json $'\''\x17'\''
json: error: <stdin>:2:2: parse error: invalid string literal
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"\x17"}
json: error: <stdin>:2:2:                                  ^
command failed: json $'\''\x17'\''
$ json $'\''\x18'\''
json: error: <stdin>:2:2: parse error: invalid string literal
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"\x18"}
json: error: <stdin>:2:2:                                  ^
command failed: json $'\''\x18'\''
$ json $'\''\x19'\''
json: error: <stdin>:2:2: parse error: invalid string literal
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"\x19"}
json: error: <stdin>:2:2:                                  ^
command failed: json $'\''\x19'\''
$ json $'\''\x1a'\''
json: error: <stdin>:2:2: parse error: invalid string literal
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"\x1a"}
json: error: <stdin>:2:2:                                  ^
command failed: json $'\''\x1a'\''
$ json $'\''\x1b'\''
json: error: <stdin>:2:2: parse error: invalid string literal
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"\x1b"}
json: error: <stdin>:2:2:                                  ^
command failed: json $'\''\x1b'\''
$ json $'\''\x1c'\''
json: error: <stdin>:2:2: parse error: invalid string literal
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"\x1c"}
json: error: <stdin>:2:2:                                  ^
command failed: json $'\''\x1c'\''
$ json $'\''\x1d'\''
json: error: <stdin>:2:2: parse error: invalid string literal
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"\x1d"}
json: error: <stdin>:2:2:                                  ^
command failed: json $'\''\x1d'\''
$ json $'\''\x1e'\''
json: error: <stdin>:2:2: parse error: invalid string literal
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"\x1e"}
json: error: <stdin>:2:2:                                  ^
command failed: json $'\''\x1e'\''
$ json $'\''\x1f'\''
json: error: <stdin>:2:2: parse error: invalid string literal
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"\x1f"}
json: error: <stdin>:2:2:                                  ^
command failed: json $'\''\x1f'\''
$ json '\'' '\''
json: error: <stdin>:2:3: meta error: invalid dict expression: unexpected end of expression
json: error: <stdin>:2:3: "c","type":"number"}],"expr":\n" "}
json: error: <stdin>:2:3:                                  ^
command failed: json '\'' '\''
$ json '\''!'\''
json: error: <stdin>:2:2: meta error: invalid dict expression: unexpected char
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"!"}
json: error: <stdin>:2:2:                                  ^
command failed: json '\''!'\''
$ json '\''"'\''
json: error: <stdin>:2:5: parse error: invalid string literal
json: error: <stdin>:2:5: ","type":"number"}],"expr":\n"""}
json: error: <stdin>:2:5:                                  ^
command failed: json '\''"'\''
$ json '\''#'\''
json: error: <stdin>:2:2: meta error: invalid dict expression: unexpected char
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"#"}
json: error: <stdin>:2:2:                                  ^
command failed: json '\''#'\''
$ json '\''$'\''
json: error: <stdin>:2:2: meta error: invalid dict expression: unexpected char
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"$"}
json: error: <stdin>:2:2:                                  ^
command failed: json '\''$'\''
$ json '\''%'\''
json: error: <stdin>:2:2: meta error: invalid dict expression: unexpected char
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"%"}
json: error: <stdin>:2:2:                                  ^
command failed: json '\''%'\''
$ json '\''&'\''
json: error: <stdin>:2:2: meta error: invalid dict expression: unexpected token
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"&"}
json: error: <stdin>:2:2:                                  ^
command failed: json '\''&'\''
$ json $'\''\x27'\''
json: error: <stdin>:2:2: meta error: invalid dict expression: unexpected char
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"'\''"}
json: error: <stdin>:2:2:                                  ^
command failed: json $'\''\x27'\''
$ json '\''('\''
json: error: <stdin>:2:3: meta error: invalid dict expression: unexpected end of expression
json: error: <stdin>:2:3: "c","type":"number"}],"expr":\n"("}
json: error: <stdin>:2:3:                                  ^
command failed: json '\''('\''
$ json '\'')'\''
json: error: <stdin>:2:2: meta error: invalid dict expression: unexpected token
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n")"}
json: error: <stdin>:2:2:                                  ^
command failed: json '\'')'\''
$ json '\''*'\''
json: error: <stdin>:2:2: meta error: invalid dict expression: unexpected char
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"*"}
json: error: <stdin>:2:2:                                  ^
command failed: json '\''*'\''
$ json '\''+'\''
json: error: <stdin>:2:2: meta error: invalid dict expression: unexpected char
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"+"}
json: error: <stdin>:2:2:                                  ^
command failed: json '\''+'\''
$ json '\'','\''
json: error: <stdin>:2:2: meta error: invalid dict expression: unexpected char
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n","}
json: error: <stdin>:2:2:                                  ^
command failed: json '\'','\''
$ json '\''-'\''
json: error: <stdin>:2:2: meta error: invalid dict expression: unexpected char
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"-"}
json: error: <stdin>:2:2:                                  ^
command failed: json '\''-'\''
$ json '\''.'\''
json: error: <stdin>:2:2: meta error: invalid dict expression: unexpected char
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"."}
json: error: <stdin>:2:2:                                  ^
command failed: json '\''.'\''
$ json '\''/'\''
json: error: <stdin>:2:2: meta error: invalid dict expression: unexpected char
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"/"}
json: error: <stdin>:2:2:                                  ^
command failed: json '\''/'\''
$ json '\''0'\''
000
$ json '\''1'\''
111
$ json '\''2'\''
json: error: <stdin>:2:2: meta error: invalid dict expression: unexpected char
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"2"}
json: error: <stdin>:2:2:                                  ^
command failed: json '\''2'\''
$ json '\''3'\''
json: error: <stdin>:2:2: meta error: invalid dict expression: unexpected char
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"3"}
json: error: <stdin>:2:2:                                  ^
command failed: json '\''3'\''
$ json '\''4'\''
json: error: <stdin>:2:2: meta error: invalid dict expression: unexpected char
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"4"}
json: error: <stdin>:2:2:                                  ^
command failed: json '\''4'\''
$ json '\''5'\''
json: error: <stdin>:2:2: meta error: invalid dict expression: unexpected char
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"5"}
json: error: <stdin>:2:2:                                  ^
command failed: json '\''5'\''
$ json '\''6'\''
json: error: <stdin>:2:2: meta error: invalid dict expression: unexpected char
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"6"}
json: error: <stdin>:2:2:                                  ^
command failed: json '\''6'\''
$ json '\''7'\''
json: error: <stdin>:2:2: meta error: invalid dict expression: unexpected char
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"7"}
json: error: <stdin>:2:2:                                  ^
command failed: json '\''7'\''
$ json '\''8'\''
json: error: <stdin>:2:2: meta error: invalid dict expression: unexpected char
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"8"}
json: error: <stdin>:2:2:                                  ^
command failed: json '\''8'\''
$ json '\''9'\''
json: error: <stdin>:2:2: meta error: invalid dict expression: unexpected char
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"9"}
json: error: <stdin>:2:2:                                  ^
command failed: json '\''9'\''
$ json '\'':'\''
json: error: <stdin>:2:2: meta error: invalid dict expression: unexpected char
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n":"}
json: error: <stdin>:2:2:                                  ^
command failed: json '\'':'\''
$ json '\'';'\''
json: error: <stdin>:2:2: meta error: invalid dict expression: unexpected char
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n";"}
json: error: <stdin>:2:2:                                  ^
command failed: json '\'';'\''
$ json '\''<'\''
json: error: <stdin>:2:2: meta error: invalid dict expression: unexpected char
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"<"}
json: error: <stdin>:2:2:                                  ^
command failed: json '\''<'\''
$ json '\''='\''
json: error: <stdin>:2:2: meta error: invalid dict expression: unexpected char
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"="}
json: error: <stdin>:2:2:                                  ^
command failed: json '\''='\''
$ json '\''>'\''
json: error: <stdin>:2:2: meta error: invalid dict expression: unexpected char
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n">"}
json: error: <stdin>:2:2:                                  ^
command failed: json '\''>'\''
$ json '\''?'\''
json: error: <stdin>:2:2: meta error: invalid dict expression: unexpected char
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"?"}
json: error: <stdin>:2:2:                                  ^
command failed: json '\''?'\''
$ json '\''@'\''
json: error: <stdin>:2:2: meta error: invalid dict expression: unexpected char
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"@"}
json: error: <stdin>:2:2:                                  ^
command failed: json '\''@'\''
$ json '\''A'\''
json: error: <stdin>:2:2: attribute error: invalid "dict" type object: expression key not found ("dict" is defined at 1:1)
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"A"}
json: error: <stdin>:2:2:                                  ^
command failed: json '\''A'\''
$ json '\''B'\''
json: error: <stdin>:2:2: attribute error: invalid "dict" type object: expression key not found ("dict" is defined at 1:1)
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"B"}
json: error: <stdin>:2:2:                                  ^
command failed: json '\''B'\''
$ json '\''C'\''
json: error: <stdin>:2:2: attribute error: invalid "dict" type object: expression key not found ("dict" is defined at 1:1)
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"C"}
json: error: <stdin>:2:2:                                  ^
command failed: json '\''C'\''
$ json '\''D'\''
json: error: <stdin>:2:2: attribute error: invalid "dict" type object: expression key not found ("dict" is defined at 1:1)
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"D"}
json: error: <stdin>:2:2:                                  ^
command failed: json '\''D'\''
$ json '\''E'\''
json: error: <stdin>:2:2: attribute error: invalid "dict" type object: expression key not found ("dict" is defined at 1:1)
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"E"}
json: error: <stdin>:2:2:                                  ^
command failed: json '\''E'\''
$ json '\''F'\''
json: error: <stdin>:2:2: attribute error: invalid "dict" type object: expression key not found ("dict" is defined at 1:1)
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"F"}
json: error: <stdin>:2:2:                                  ^
command failed: json '\''F'\''
$ json '\''G'\''
json: error: <stdin>:2:2: attribute error: invalid "dict" type object: expression key not found ("dict" is defined at 1:1)
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"G"}
json: error: <stdin>:2:2:                                  ^
command failed: json '\''G'\''
$ json '\''H'\''
json: error: <stdin>:2:2: attribute error: invalid "dict" type object: expression key not found ("dict" is defined at 1:1)
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"H"}
json: error: <stdin>:2:2:                                  ^
command failed: json '\''H'\''
$ json '\''I'\''
json: error: <stdin>:2:2: attribute error: invalid "dict" type object: expression key not found ("dict" is defined at 1:1)
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"I"}
json: error: <stdin>:2:2:                                  ^
command failed: json '\''I'\''
$ json '\''J'\''
json: error: <stdin>:2:2: attribute error: invalid "dict" type object: expression key not found ("dict" is defined at 1:1)
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"J"}
json: error: <stdin>:2:2:                                  ^
command failed: json '\''J'\''
$ json '\''K'\''
json: error: <stdin>:2:2: attribute error: invalid "dict" type object: expression key not found ("dict" is defined at 1:1)
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"K"}
json: error: <stdin>:2:2:                                  ^
command failed: json '\''K'\''
$ json '\''L'\''
json: error: <stdin>:2:2: attribute error: invalid "dict" type object: expression key not found ("dict" is defined at 1:1)
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"L"}
json: error: <stdin>:2:2:                                  ^
command failed: json '\''L'\''
$ json '\''M'\''
json: error: <stdin>:2:2: attribute error: invalid "dict" type object: expression key not found ("dict" is defined at 1:1)
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"M"}
json: error: <stdin>:2:2:                                  ^
command failed: json '\''M'\''
$ json '\''N'\''
json: error: <stdin>:2:2: attribute error: invalid "dict" type object: expression key not found ("dict" is defined at 1:1)
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"N"}
json: error: <stdin>:2:2:                                  ^
command failed: json '\''N'\''
$ json '\''O'\''
json: error: <stdin>:2:2: attribute error: invalid "dict" type object: expression key not found ("dict" is defined at 1:1)
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"O"}
json: error: <stdin>:2:2:                                  ^
command failed: json '\''O'\''
$ json '\''P'\''
json: error: <stdin>:2:2: attribute error: invalid "dict" type object: expression key not found ("dict" is defined at 1:1)
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"P"}
json: error: <stdin>:2:2:                                  ^
command failed: json '\''P'\''
$ json '\''Q'\''
json: error: <stdin>:2:2: attribute error: invalid "dict" type object: expression key not found ("dict" is defined at 1:1)
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"Q"}
json: error: <stdin>:2:2:                                  ^
command failed: json '\''Q'\''
$ json '\''R'\''
json: error: <stdin>:2:2: attribute error: invalid "dict" type object: expression key not found ("dict" is defined at 1:1)
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"R"}
json: error: <stdin>:2:2:                                  ^
command failed: json '\''R'\''
$ json '\''S'\''
json: error: <stdin>:2:2: attribute error: invalid "dict" type object: expression key not found ("dict" is defined at 1:1)
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"S"}
json: error: <stdin>:2:2:                                  ^
command failed: json '\''S'\''
$ json '\''T'\''
json: error: <stdin>:2:2: attribute error: invalid "dict" type object: expression key not found ("dict" is defined at 1:1)
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"T"}
json: error: <stdin>:2:2:                                  ^
command failed: json '\''T'\''
$ json '\''U'\''
json: error: <stdin>:2:2: attribute error: invalid "dict" type object: expression key not found ("dict" is defined at 1:1)
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"U"}
json: error: <stdin>:2:2:                                  ^
command failed: json '\''U'\''
$ json '\''V'\''
json: error: <stdin>:2:2: attribute error: invalid "dict" type object: expression key not found ("dict" is defined at 1:1)
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"V"}
json: error: <stdin>:2:2:                                  ^
command failed: json '\''V'\''
$ json '\''W'\''
json: error: <stdin>:2:2: attribute error: invalid "dict" type object: expression key not found ("dict" is defined at 1:1)
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"W"}
json: error: <stdin>:2:2:                                  ^
command failed: json '\''W'\''
$ json '\''X'\''
json: error: <stdin>:2:2: attribute error: invalid "dict" type object: expression key not found ("dict" is defined at 1:1)
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"X"}
json: error: <stdin>:2:2:                                  ^
command failed: json '\''X'\''
$ json '\''Y'\''
json: error: <stdin>:2:2: attribute error: invalid "dict" type object: expression key not found ("dict" is defined at 1:1)
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"Y"}
json: error: <stdin>:2:2:                                  ^
command failed: json '\''Y'\''
$ json '\''Z'\''
json: error: <stdin>:2:2: attribute error: invalid "dict" type object: expression key not found ("dict" is defined at 1:1)
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"Z"}
json: error: <stdin>:2:2:                                  ^
command failed: json '\''Z'\''
$ json '\''['\''
json: error: <stdin>:2:2: meta error: invalid dict expression: unexpected char
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"["}
json: error: <stdin>:2:2:                                  ^
command failed: json '\''['\''
$ json '\''\'\''
json: error: <stdin>:2:5: parse error: invalid string literal
json: error: <stdin>:2:5: ","type":"number"}],"expr":\n"\\"}
json: error: <stdin>:2:5:                                   ^
command failed: json '\''\'\''
$ json '\'']'\''
json: error: <stdin>:2:2: meta error: invalid dict expression: unexpected char
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"]"}
json: error: <stdin>:2:2:                                  ^
command failed: json '\'']'\''
$ json '\''^'\''
json: error: <stdin>:2:2: meta error: invalid dict expression: unexpected char
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"^"}
json: error: <stdin>:2:2:                                  ^
command failed: json '\''^'\''
$ json '\''_'\''
json: error: <stdin>:2:2: attribute error: invalid "dict" type object: expression key not found ("dict" is defined at 1:1)
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"_"}
json: error: <stdin>:2:2:                                  ^
command failed: json '\''_'\''
$ json '\''`'\''
json: error: <stdin>:2:3: meta error: invalid dict expression: unexpected end of expression
json: error: <stdin>:2:3: "c","type":"number"}],"expr":\n"`"}
json: error: <stdin>:2:3:                                  ^
command failed: json '\''`'\''
$ json '\''a'\''
100
$ json '\''b'\''
010
$ json '\''c'\''
001
$ json '\''d'\''
json: error: <stdin>:2:2: attribute error: invalid "dict" type object: expression key not found ("dict" is defined at 1:1)
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"d"}
json: error: <stdin>:2:2:                                  ^
command failed: json '\''d'\''
$ json '\''e'\''
json: error: <stdin>:2:2: attribute error: invalid "dict" type object: expression key not found ("dict" is defined at 1:1)
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"e"}
json: error: <stdin>:2:2:                                  ^
command failed: json '\''e'\''
$ json '\''f'\''
json: error: <stdin>:2:2: attribute error: invalid "dict" type object: expression key not found ("dict" is defined at 1:1)
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"f"}
json: error: <stdin>:2:2:                                  ^
command failed: json '\''f'\''
$ json '\''g'\''
json: error: <stdin>:2:2: attribute error: invalid "dict" type object: expression key not found ("dict" is defined at 1:1)
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"g"}
json: error: <stdin>:2:2:                                  ^
command failed: json '\''g'\''
$ json '\''h'\''
json: error: <stdin>:2:2: attribute error: invalid "dict" type object: expression key not found ("dict" is defined at 1:1)
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"h"}
json: error: <stdin>:2:2:                                  ^
command failed: json '\''h'\''
$ json '\''i'\''
json: error: <stdin>:2:2: attribute error: invalid "dict" type object: expression key not found ("dict" is defined at 1:1)
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"i"}
json: error: <stdin>:2:2:                                  ^
command failed: json '\''i'\''
$ json '\''j'\''
json: error: <stdin>:2:2: attribute error: invalid "dict" type object: expression key not found ("dict" is defined at 1:1)
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"j"}
json: error: <stdin>:2:2:                                  ^
command failed: json '\''j'\''
$ json '\''k'\''
json: error: <stdin>:2:2: attribute error: invalid "dict" type object: expression key not found ("dict" is defined at 1:1)
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"k"}
json: error: <stdin>:2:2:                                  ^
command failed: json '\''k'\''
$ json '\''l'\''
json: error: <stdin>:2:2: attribute error: invalid "dict" type object: expression key not found ("dict" is defined at 1:1)
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"l"}
json: error: <stdin>:2:2:                                  ^
command failed: json '\''l'\''
$ json '\''m'\''
json: error: <stdin>:2:2: attribute error: invalid "dict" type object: expression key not found ("dict" is defined at 1:1)
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"m"}
json: error: <stdin>:2:2:                                  ^
command failed: json '\''m'\''
$ json '\''n'\''
json: error: <stdin>:2:2: attribute error: invalid "dict" type object: expression key not found ("dict" is defined at 1:1)
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"n"}
json: error: <stdin>:2:2:                                  ^
command failed: json '\''n'\''
$ json '\''o'\''
json: error: <stdin>:2:2: attribute error: invalid "dict" type object: expression key not found ("dict" is defined at 1:1)
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"o"}
json: error: <stdin>:2:2:                                  ^
command failed: json '\''o'\''
$ json '\''p'\''
json: error: <stdin>:2:2: attribute error: invalid "dict" type object: expression key not found ("dict" is defined at 1:1)
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"p"}
json: error: <stdin>:2:2:                                  ^
command failed: json '\''p'\''
$ json '\''q'\''
json: error: <stdin>:2:2: attribute error: invalid "dict" type object: expression key not found ("dict" is defined at 1:1)
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"q"}
json: error: <stdin>:2:2:                                  ^
command failed: json '\''q'\''
$ json '\''r'\''
json: error: <stdin>:2:2: attribute error: invalid "dict" type object: expression key not found ("dict" is defined at 1:1)
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"r"}
json: error: <stdin>:2:2:                                  ^
command failed: json '\''r'\''
$ json '\''s'\''
json: error: <stdin>:2:2: attribute error: invalid "dict" type object: expression key not found ("dict" is defined at 1:1)
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"s"}
json: error: <stdin>:2:2:                                  ^
command failed: json '\''s'\''
$ json '\''t'\''
json: error: <stdin>:2:2: attribute error: invalid "dict" type object: expression key not found ("dict" is defined at 1:1)
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"t"}
json: error: <stdin>:2:2:                                  ^
command failed: json '\''t'\''
$ json '\''u'\''
json: error: <stdin>:2:2: attribute error: invalid "dict" type object: expression key not found ("dict" is defined at 1:1)
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"u"}
json: error: <stdin>:2:2:                                  ^
command failed: json '\''u'\''
$ json '\''v'\''
json: error: <stdin>:2:2: attribute error: invalid "dict" type object: expression key not found ("dict" is defined at 1:1)
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"v"}
json: error: <stdin>:2:2:                                  ^
command failed: json '\''v'\''
$ json '\''w'\''
json: error: <stdin>:2:2: attribute error: invalid "dict" type object: expression key not found ("dict" is defined at 1:1)
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"w"}
json: error: <stdin>:2:2:                                  ^
command failed: json '\''w'\''
$ json '\''x'\''
json: error: <stdin>:2:2: attribute error: invalid "dict" type object: expression key not found ("dict" is defined at 1:1)
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"x"}
json: error: <stdin>:2:2:                                  ^
command failed: json '\''x'\''
$ json '\''y'\''
json: error: <stdin>:2:2: attribute error: invalid "dict" type object: expression key not found ("dict" is defined at 1:1)
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"y"}
json: error: <stdin>:2:2:                                  ^
command failed: json '\''y'\''
$ json '\''z'\''
json: error: <stdin>:2:2: attribute error: invalid "dict" type object: expression key not found ("dict" is defined at 1:1)
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"z"}
json: error: <stdin>:2:2:                                  ^
command failed: json '\''z'\''
$ json '\''{'\''
json: error: <stdin>:2:2: meta error: invalid dict expression: unexpected char
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"{"}
json: error: <stdin>:2:2:                                  ^
command failed: json '\''{'\''
$ json '\''|'\''
json: error: <stdin>:2:2: meta error: invalid dict expression: unexpected token
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"|"}
json: error: <stdin>:2:2:                                  ^
command failed: json '\''|'\''
$ json '\''}'\''
json: error: <stdin>:2:2: meta error: invalid dict expression: unexpected char
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"}"}
json: error: <stdin>:2:2:                                  ^
command failed: json '\''}'\''
$ json '\''~'\''
json: error: <stdin>:2:3: meta error: invalid dict expression: unexpected end of expression
json: error: <stdin>:2:3: "c","type":"number"}],"expr":\n"~"}
json: error: <stdin>:2:3:                                  ^
command failed: json '\''~'\'''
) -L dict-expr-ascii.new <(
echo '$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json -V -TA <<< '\''{"type":"dict","args":[{"name":"a","type":"number"},{"name":"b","type":"number"},{"name":"c","type":"number"}],"expr":'\''$'\''\n"'\''"$1"'\''"}'\''|sed -nr '\''s/^.*"bits":"([^"]*)".*$/\1/p'\''; }'
json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json -V -TA <<< '{"type":"dict","args":[{"name":"a","type":"number"},{"name":"b","type":"number"},{"name":"c","type":"number"}],"expr":'$'\n"'"$1"'"}'|sed -nr 's/^.*"bits":"([^"]*)".*$/\1/p'; } 2>&1 ||
echo 'command failed: json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json -V -TA <<< '\''{"type":"dict","args":[{"name":"a","type":"number"},{"name":"b","type":"number"},{"name":"c","type":"number"}],"expr":'\''$'\''\n"'\''"$1"'\''"}'\''|sed -nr '\''s/^.*"bits":"([^"]*)".*$/\1/p'\''; }'

echo '$ json $'\''\x0'\'''
json $'\x0' 2>&1 ||
echo 'command failed: json $'\''\x0'\'''

echo '$ json $'\''\x2'\'''
json $'\x2' 2>&1 ||
echo 'command failed: json $'\''\x2'\'''

echo '$ json $'\''\x3'\'''
json $'\x3' 2>&1 ||
echo 'command failed: json $'\''\x3'\'''

echo '$ json $'\''\x4'\'''
json $'\x4' 2>&1 ||
echo 'command failed: json $'\''\x4'\'''

echo '$ json $'\''\x5'\'''
json $'\x5' 2>&1 ||
echo 'command failed: json $'\''\x5'\'''

echo '$ json $'\''\x6'\'''
json $'\x6' 2>&1 ||
echo 'command failed: json $'\''\x6'\'''

echo '$ json $'\''\x7'\'''
json $'\x7' 2>&1 ||
echo 'command failed: json $'\''\x7'\'''

echo '$ json $'\''\x8'\'''
json $'\x8' 2>&1 ||
echo 'command failed: json $'\''\x8'\'''

echo '$ json $'\''\x9'\'''
json $'\x9' 2>&1 ||
echo 'command failed: json $'\''\x9'\'''

echo '$ json $'\''\xa'\'''
json $'\xa' 2>&1 ||
echo 'command failed: json $'\''\xa'\'''

echo '$ json $'\''\xb'\'''
json $'\xb' 2>&1 ||
echo 'command failed: json $'\''\xb'\'''

echo '$ json $'\''\xc'\'''
json $'\xc' 2>&1 ||
echo 'command failed: json $'\''\xc'\'''

echo '$ json $'\''\xd'\'''
json $'\xd' 2>&1 ||
echo 'command failed: json $'\''\xd'\'''

echo '$ json $'\''\xe'\'''
json $'\xe' 2>&1 ||
echo 'command failed: json $'\''\xe'\'''

echo '$ json $'\''\xf'\'''
json $'\xf' 2>&1 ||
echo 'command failed: json $'\''\xf'\'''

echo '$ json $'\''\x10'\'''
json $'\x10' 2>&1 ||
echo 'command failed: json $'\''\x10'\'''

echo '$ json $'\''\x11'\'''
json $'\x11' 2>&1 ||
echo 'command failed: json $'\''\x11'\'''

echo '$ json $'\''\x12'\'''
json $'\x12' 2>&1 ||
echo 'command failed: json $'\''\x12'\'''

echo '$ json $'\''\x13'\'''
json $'\x13' 2>&1 ||
echo 'command failed: json $'\''\x13'\'''

echo '$ json $'\''\x14'\'''
json $'\x14' 2>&1 ||
echo 'command failed: json $'\''\x14'\'''

echo '$ json $'\''\x15'\'''
json $'\x15' 2>&1 ||
echo 'command failed: json $'\''\x15'\'''

echo '$ json $'\''\x16'\'''
json $'\x16' 2>&1 ||
echo 'command failed: json $'\''\x16'\'''

echo '$ json $'\''\x17'\'''
json $'\x17' 2>&1 ||
echo 'command failed: json $'\''\x17'\'''

echo '$ json $'\''\x18'\'''
json $'\x18' 2>&1 ||
echo 'command failed: json $'\''\x18'\'''

echo '$ json $'\''\x19'\'''
json $'\x19' 2>&1 ||
echo 'command failed: json $'\''\x19'\'''

echo '$ json $'\''\x1a'\'''
json $'\x1a' 2>&1 ||
echo 'command failed: json $'\''\x1a'\'''

echo '$ json $'\''\x1b'\'''
json $'\x1b' 2>&1 ||
echo 'command failed: json $'\''\x1b'\'''

echo '$ json $'\''\x1c'\'''
json $'\x1c' 2>&1 ||
echo 'command failed: json $'\''\x1c'\'''

echo '$ json $'\''\x1d'\'''
json $'\x1d' 2>&1 ||
echo 'command failed: json $'\''\x1d'\'''

echo '$ json $'\''\x1e'\'''
json $'\x1e' 2>&1 ||
echo 'command failed: json $'\''\x1e'\'''

echo '$ json $'\''\x1f'\'''
json $'\x1f' 2>&1 ||
echo 'command failed: json $'\''\x1f'\'''

echo '$ json '\'' '\'''
json ' ' 2>&1 ||
echo 'command failed: json '\'' '\'''

echo '$ json '\''!'\'''
json '!' 2>&1 ||
echo 'command failed: json '\''!'\'''

echo '$ json '\''"'\'''
json '"' 2>&1 ||
echo 'command failed: json '\''"'\'''

echo '$ json '\''#'\'''
json '#' 2>&1 ||
echo 'command failed: json '\''#'\'''

echo '$ json '\''$'\'''
json '$' 2>&1 ||
echo 'command failed: json '\''$'\'''

echo '$ json '\''%'\'''
json '%' 2>&1 ||
echo 'command failed: json '\''%'\'''

echo '$ json '\''&'\'''
json '&' 2>&1 ||
echo 'command failed: json '\''&'\'''

echo '$ json $'\''\x27'\'''
json $'\x27' 2>&1 ||
echo 'command failed: json $'\''\x27'\'''

echo '$ json '\''('\'''
json '(' 2>&1 ||
echo 'command failed: json '\''('\'''

echo '$ json '\'')'\'''
json ')' 2>&1 ||
echo 'command failed: json '\'')'\'''

echo '$ json '\''*'\'''
json '*' 2>&1 ||
echo 'command failed: json '\''*'\'''

echo '$ json '\''+'\'''
json '+' 2>&1 ||
echo 'command failed: json '\''+'\'''

echo '$ json '\'','\'''
json ',' 2>&1 ||
echo 'command failed: json '\'','\'''

echo '$ json '\''-'\'''
json '-' 2>&1 ||
echo 'command failed: json '\''-'\'''

echo '$ json '\''.'\'''
json '.' 2>&1 ||
echo 'command failed: json '\''.'\'''

echo '$ json '\''/'\'''
json '/' 2>&1 ||
echo 'command failed: json '\''/'\'''

echo '$ json '\''0'\'''
json '0' 2>&1 ||
echo 'command failed: json '\''0'\'''

echo '$ json '\''1'\'''
json '1' 2>&1 ||
echo 'command failed: json '\''1'\'''

echo '$ json '\''2'\'''
json '2' 2>&1 ||
echo 'command failed: json '\''2'\'''

echo '$ json '\''3'\'''
json '3' 2>&1 ||
echo 'command failed: json '\''3'\'''

echo '$ json '\''4'\'''
json '4' 2>&1 ||
echo 'command failed: json '\''4'\'''

echo '$ json '\''5'\'''
json '5' 2>&1 ||
echo 'command failed: json '\''5'\'''

echo '$ json '\''6'\'''
json '6' 2>&1 ||
echo 'command failed: json '\''6'\'''

echo '$ json '\''7'\'''
json '7' 2>&1 ||
echo 'command failed: json '\''7'\'''

echo '$ json '\''8'\'''
json '8' 2>&1 ||
echo 'command failed: json '\''8'\'''

echo '$ json '\''9'\'''
json '9' 2>&1 ||
echo 'command failed: json '\''9'\'''

echo '$ json '\'':'\'''
json ':' 2>&1 ||
echo 'command failed: json '\'':'\'''

echo '$ json '\'';'\'''
json ';' 2>&1 ||
echo 'command failed: json '\'';'\'''

echo '$ json '\''<'\'''
json '<' 2>&1 ||
echo 'command failed: json '\''<'\'''

echo '$ json '\''='\'''
json '=' 2>&1 ||
echo 'command failed: json '\''='\'''

echo '$ json '\''>'\'''
json '>' 2>&1 ||
echo 'command failed: json '\''>'\'''

echo '$ json '\''?'\'''
json '?' 2>&1 ||
echo 'command failed: json '\''?'\'''

echo '$ json '\''@'\'''
json '@' 2>&1 ||
echo 'command failed: json '\''@'\'''

echo '$ json '\''A'\'''
json 'A' 2>&1 ||
echo 'command failed: json '\''A'\'''

echo '$ json '\''B'\'''
json 'B' 2>&1 ||
echo 'command failed: json '\''B'\'''

echo '$ json '\''C'\'''
json 'C' 2>&1 ||
echo 'command failed: json '\''C'\'''

echo '$ json '\''D'\'''
json 'D' 2>&1 ||
echo 'command failed: json '\''D'\'''

echo '$ json '\''E'\'''
json 'E' 2>&1 ||
echo 'command failed: json '\''E'\'''

echo '$ json '\''F'\'''
json 'F' 2>&1 ||
echo 'command failed: json '\''F'\'''

echo '$ json '\''G'\'''
json 'G' 2>&1 ||
echo 'command failed: json '\''G'\'''

echo '$ json '\''H'\'''
json 'H' 2>&1 ||
echo 'command failed: json '\''H'\'''

echo '$ json '\''I'\'''
json 'I' 2>&1 ||
echo 'command failed: json '\''I'\'''

echo '$ json '\''J'\'''
json 'J' 2>&1 ||
echo 'command failed: json '\''J'\'''

echo '$ json '\''K'\'''
json 'K' 2>&1 ||
echo 'command failed: json '\''K'\'''

echo '$ json '\''L'\'''
json 'L' 2>&1 ||
echo 'command failed: json '\''L'\'''

echo '$ json '\''M'\'''
json 'M' 2>&1 ||
echo 'command failed: json '\''M'\'''

echo '$ json '\''N'\'''
json 'N' 2>&1 ||
echo 'command failed: json '\''N'\'''

echo '$ json '\''O'\'''
json 'O' 2>&1 ||
echo 'command failed: json '\''O'\'''

echo '$ json '\''P'\'''
json 'P' 2>&1 ||
echo 'command failed: json '\''P'\'''

echo '$ json '\''Q'\'''
json 'Q' 2>&1 ||
echo 'command failed: json '\''Q'\'''

echo '$ json '\''R'\'''
json 'R' 2>&1 ||
echo 'command failed: json '\''R'\'''

echo '$ json '\''S'\'''
json 'S' 2>&1 ||
echo 'command failed: json '\''S'\'''

echo '$ json '\''T'\'''
json 'T' 2>&1 ||
echo 'command failed: json '\''T'\'''

echo '$ json '\''U'\'''
json 'U' 2>&1 ||
echo 'command failed: json '\''U'\'''

echo '$ json '\''V'\'''
json 'V' 2>&1 ||
echo 'command failed: json '\''V'\'''

echo '$ json '\''W'\'''
json 'W' 2>&1 ||
echo 'command failed: json '\''W'\'''

echo '$ json '\''X'\'''
json 'X' 2>&1 ||
echo 'command failed: json '\''X'\'''

echo '$ json '\''Y'\'''
json 'Y' 2>&1 ||
echo 'command failed: json '\''Y'\'''

echo '$ json '\''Z'\'''
json 'Z' 2>&1 ||
echo 'command failed: json '\''Z'\'''

echo '$ json '\''['\'''
json '[' 2>&1 ||
echo 'command failed: json '\''['\'''

echo '$ json '\''\'\'''
json '\' 2>&1 ||
echo 'command failed: json '\''\'\'''

echo '$ json '\'']'\'''
json ']' 2>&1 ||
echo 'command failed: json '\'']'\'''

echo '$ json '\''^'\'''
json '^' 2>&1 ||
echo 'command failed: json '\''^'\'''

echo '$ json '\''_'\'''
json '_' 2>&1 ||
echo 'command failed: json '\''_'\'''

echo '$ json '\''`'\'''
json '`' 2>&1 ||
echo 'command failed: json '\''`'\'''

echo '$ json '\''a'\'''
json 'a' 2>&1 ||
echo 'command failed: json '\''a'\'''

echo '$ json '\''b'\'''
json 'b' 2>&1 ||
echo 'command failed: json '\''b'\'''

echo '$ json '\''c'\'''
json 'c' 2>&1 ||
echo 'command failed: json '\''c'\'''

echo '$ json '\''d'\'''
json 'd' 2>&1 ||
echo 'command failed: json '\''d'\'''

echo '$ json '\''e'\'''
json 'e' 2>&1 ||
echo 'command failed: json '\''e'\'''

echo '$ json '\''f'\'''
json 'f' 2>&1 ||
echo 'command failed: json '\''f'\'''

echo '$ json '\''g'\'''
json 'g' 2>&1 ||
echo 'command failed: json '\''g'\'''

echo '$ json '\''h'\'''
json 'h' 2>&1 ||
echo 'command failed: json '\''h'\'''

echo '$ json '\''i'\'''
json 'i' 2>&1 ||
echo 'command failed: json '\''i'\'''

echo '$ json '\''j'\'''
json 'j' 2>&1 ||
echo 'command failed: json '\''j'\'''

echo '$ json '\''k'\'''
json 'k' 2>&1 ||
echo 'command failed: json '\''k'\'''

echo '$ json '\''l'\'''
json 'l' 2>&1 ||
echo 'command failed: json '\''l'\'''

echo '$ json '\''m'\'''
json 'm' 2>&1 ||
echo 'command failed: json '\''m'\'''

echo '$ json '\''n'\'''
json 'n' 2>&1 ||
echo 'command failed: json '\''n'\'''

echo '$ json '\''o'\'''
json 'o' 2>&1 ||
echo 'command failed: json '\''o'\'''

echo '$ json '\''p'\'''
json 'p' 2>&1 ||
echo 'command failed: json '\''p'\'''

echo '$ json '\''q'\'''
json 'q' 2>&1 ||
echo 'command failed: json '\''q'\'''

echo '$ json '\''r'\'''
json 'r' 2>&1 ||
echo 'command failed: json '\''r'\'''

echo '$ json '\''s'\'''
json 's' 2>&1 ||
echo 'command failed: json '\''s'\'''

echo '$ json '\''t'\'''
json 't' 2>&1 ||
echo 'command failed: json '\''t'\'''

echo '$ json '\''u'\'''
json 'u' 2>&1 ||
echo 'command failed: json '\''u'\'''

echo '$ json '\''v'\'''
json 'v' 2>&1 ||
echo 'command failed: json '\''v'\'''

echo '$ json '\''w'\'''
json 'w' 2>&1 ||
echo 'command failed: json '\''w'\'''

echo '$ json '\''x'\'''
json 'x' 2>&1 ||
echo 'command failed: json '\''x'\'''

echo '$ json '\''y'\'''
json 'y' 2>&1 ||
echo 'command failed: json '\''y'\'''

echo '$ json '\''z'\'''
json 'z' 2>&1 ||
echo 'command failed: json '\''z'\'''

echo '$ json '\''{'\'''
json '{' 2>&1 ||
echo 'command failed: json '\''{'\'''

echo '$ json '\''|'\'''
json '|' 2>&1 ||
echo 'command failed: json '\''|'\'''

echo '$ json '\''}'\'''
json '}' 2>&1 ||
echo 'command failed: json '\''}'\'''

echo '$ json '\''~'\'''
json '~' 2>&1 ||
echo 'command failed: json '\''~'\'''
)

