#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-lib:array-value2
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L array-value2.old <(echo \
'$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }
$ json <<< '\''["type",null]'\''
json: error: <stdin>:1:9: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:9: ["type",null]
json: error: <stdin>:1:9:         ^
command failed: json <<< '\''["type",null]'\''
$ json <<< '\''["type",false]'\''
json: error: <stdin>:1:9: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:9: ["type",false]
json: error: <stdin>:1:9:         ^
command failed: json <<< '\''["type",false]'\''
$ json <<< '\''["type",true]'\''
json: error: <stdin>:1:9: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:9: ["type",true]
json: error: <stdin>:1:9:         ^
command failed: json <<< '\''["type",true]'\''
$ json <<< '\''["type",123]'\''
json: error: <stdin>:1:9: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:9: ["type",123]
json: error: <stdin>:1:9:         ^
command failed: json <<< '\''["type",123]'\''
$ json <<< '\''["type","foo"]'\''
json: error: <stdin>:1:9: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:9: ["type","foo"]
json: error: <stdin>:1:9:         ^
command failed: json <<< '\''["type","foo"]'\''
$ json <<< '\''["type","type"]'\''
json: error: <stdin>:1:1: meta error: invalid top value: it must be a type or an array of "name" objects
json: error: <stdin>:1:1: ["type","type"]
json: error: <stdin>:1:1: ^
command failed: json <<< '\''["type","type"]'\''
$ json <<< '\''["type","null"]'\''
json: error: <stdin>:1:1: meta error: invalid top value: it must be a type or an array of "name" objects
json: error: <stdin>:1:1: ["type","null"]
json: error: <stdin>:1:1: ^
command failed: json <<< '\''["type","null"]'\''
$ json <<< '\''["type","boolean"]'\''
json: error: <stdin>:1:1: meta error: invalid top value: it must be a type or an array of "name" objects
json: error: <stdin>:1:1: ["type","boolean"]
json: error: <stdin>:1:1: ^
command failed: json <<< '\''["type","boolean"]'\''
$ json <<< '\''["type","number"]'\''
json: error: <stdin>:1:1: meta error: invalid top value: it must be a type or an array of "name" objects
json: error: <stdin>:1:1: ["type","number"]
json: error: <stdin>:1:1: ^
command failed: json <<< '\''["type","number"]'\''
$ json <<< '\''["type","string"]'\''
json: error: <stdin>:1:1: meta error: invalid top value: it must be a type or an array of "name" objects
json: error: <stdin>:1:1: ["type","string"]
json: error: <stdin>:1:1: ^
command failed: json <<< '\''["type","string"]'\''
$ json <<< '\''["type","object"]'\''
json: error: <stdin>:1:1: meta error: invalid top value: it must be a type or an array of "name" objects
json: error: <stdin>:1:1: ["type","object"]
json: error: <stdin>:1:1: ^
command failed: json <<< '\''["type","object"]'\''
$ json <<< '\''["type","array"]'\''
json: error: <stdin>:1:1: meta error: invalid top value: it must be a type or an array of "name" objects
json: error: <stdin>:1:1: ["type","array"]
json: error: <stdin>:1:1: ^
command failed: json <<< '\''["type","array"]'\''
$ json <<< '\''["type","list"]'\''
json: error: <stdin>:1:9: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:9: ["type","list"]
json: error: <stdin>:1:9:         ^
command failed: json <<< '\''["type","list"]'\''
$ json <<< '\''["type","dict"]'\''
json: error: <stdin>:1:9: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:9: ["type","dict"]
json: error: <stdin>:1:9:         ^
command failed: json <<< '\''["type","dict"]'\''
$ json <<< '\''["type",{}]'\''
json: error: <stdin>:1:9: meta error: empty objects are not allowed
json: error: <stdin>:1:9: ["type",{}]
json: error: <stdin>:1:9:         ^
command failed: json <<< '\''["type",{}]'\''
$ json <<< '\''["type",{"foo":"bar"}]'\''
json: error: <stdin>:1:10: meta error: invalid first key of object: it must be "type", "name" or "plain"
json: error: <stdin>:1:10: ["type",{"foo":"bar"}]
json: error: <stdin>:1:10:          ^
command failed: json <<< '\''["type",{"foo":"bar"}]'\''
$ json <<< '\''["type",{"name":"baz","type":"object"}]'\''
json: error: <stdin>:1:9: meta error: invalid array: its elements must all be types or all be "name" objects
json: error: <stdin>:1:9: ["type",{"name":"baz","type":"object"}]
json: error: <stdin>:1:9:         ^
command failed: json <<< '\''["type",{"name":"baz","type":"object"}]'\''
$ json <<< '\''["type",[]]'\''
json: error: <stdin>:1:9: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:9: ["type",[]]
json: error: <stdin>:1:9:         ^
command failed: json <<< '\''["type",[]]'\''
$ json <<< '\''["type",["number","string"]]'\''
json: error: <stdin>:1:9: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:9: ["type",["number","string"]]
json: error: <stdin>:1:9:         ^
command failed: json <<< '\''["type",["number","string"]]'\''
$ json <<< '\''["null",null]'\''
json: error: <stdin>:1:9: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:9: ["null",null]
json: error: <stdin>:1:9:         ^
command failed: json <<< '\''["null",null]'\''
$ json <<< '\''["null",false]'\''
json: error: <stdin>:1:9: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:9: ["null",false]
json: error: <stdin>:1:9:         ^
command failed: json <<< '\''["null",false]'\''
$ json <<< '\''["null",true]'\''
json: error: <stdin>:1:9: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:9: ["null",true]
json: error: <stdin>:1:9:         ^
command failed: json <<< '\''["null",true]'\''
$ json <<< '\''["null",123]'\''
json: error: <stdin>:1:9: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:9: ["null",123]
json: error: <stdin>:1:9:         ^
command failed: json <<< '\''["null",123]'\''
$ json <<< '\''["null","foo"]'\''
json: error: <stdin>:1:9: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:9: ["null","foo"]
json: error: <stdin>:1:9:         ^
command failed: json <<< '\''["null","foo"]'\''
$ json <<< '\''["null","type"]'\''
json: error: <stdin>:1:1: meta error: invalid top value: it must be a type or an array of "name" objects
json: error: <stdin>:1:1: ["null","type"]
json: error: <stdin>:1:1: ^
command failed: json <<< '\''["null","type"]'\''
$ json <<< '\''["null","null"]'\''
json: error: <stdin>:1:1: meta error: invalid top value: it must be a type or an array of "name" objects
json: error: <stdin>:1:1: ["null","null"]
json: error: <stdin>:1:1: ^
command failed: json <<< '\''["null","null"]'\''
$ json <<< '\''["null","boolean"]'\''
json: error: <stdin>:1:1: meta error: invalid top value: it must be a type or an array of "name" objects
json: error: <stdin>:1:1: ["null","boolean"]
json: error: <stdin>:1:1: ^
command failed: json <<< '\''["null","boolean"]'\''
$ json <<< '\''["null","number"]'\''
json: error: <stdin>:1:1: meta error: invalid top value: it must be a type or an array of "name" objects
json: error: <stdin>:1:1: ["null","number"]
json: error: <stdin>:1:1: ^
command failed: json <<< '\''["null","number"]'\''
$ json <<< '\''["null","string"]'\''
json: error: <stdin>:1:1: meta error: invalid top value: it must be a type or an array of "name" objects
json: error: <stdin>:1:1: ["null","string"]
json: error: <stdin>:1:1: ^
command failed: json <<< '\''["null","string"]'\''
$ json <<< '\''["null","object"]'\''
json: error: <stdin>:1:1: meta error: invalid top value: it must be a type or an array of "name" objects
json: error: <stdin>:1:1: ["null","object"]
json: error: <stdin>:1:1: ^
command failed: json <<< '\''["null","object"]'\''
$ json <<< '\''["null","array"]'\''
json: error: <stdin>:1:1: meta error: invalid top value: it must be a type or an array of "name" objects
json: error: <stdin>:1:1: ["null","array"]
json: error: <stdin>:1:1: ^
command failed: json <<< '\''["null","array"]'\''
$ json <<< '\''["null","list"]'\''
json: error: <stdin>:1:9: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:9: ["null","list"]
json: error: <stdin>:1:9:         ^
command failed: json <<< '\''["null","list"]'\''
$ json <<< '\''["null","dict"]'\''
json: error: <stdin>:1:9: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:9: ["null","dict"]
json: error: <stdin>:1:9:         ^
command failed: json <<< '\''["null","dict"]'\''
$ json <<< '\''["null",{}]'\''
json: error: <stdin>:1:9: meta error: empty objects are not allowed
json: error: <stdin>:1:9: ["null",{}]
json: error: <stdin>:1:9:         ^
command failed: json <<< '\''["null",{}]'\''
$ json <<< '\''["null",{"foo":"bar"}]'\''
json: error: <stdin>:1:10: meta error: invalid first key of object: it must be "type", "name" or "plain"
json: error: <stdin>:1:10: ["null",{"foo":"bar"}]
json: error: <stdin>:1:10:          ^
command failed: json <<< '\''["null",{"foo":"bar"}]'\''
$ json <<< '\''["null",{"name":"baz","type":"object"}]'\''
json: error: <stdin>:1:9: meta error: invalid array: its elements must all be types or all be "name" objects
json: error: <stdin>:1:9: ["null",{"name":"baz","type":"object"}]
json: error: <stdin>:1:9:         ^
command failed: json <<< '\''["null",{"name":"baz","type":"object"}]'\''
$ json <<< '\''["null",[]]'\''
json: error: <stdin>:1:9: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:9: ["null",[]]
json: error: <stdin>:1:9:         ^
command failed: json <<< '\''["null",[]]'\''
$ json <<< '\''["null",["number","string"]]'\''
json: error: <stdin>:1:9: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:9: ["null",["number","string"]]
json: error: <stdin>:1:9:         ^
command failed: json <<< '\''["null",["number","string"]]'\''
$ json <<< '\''["boolean",null]'\''
json: error: <stdin>:1:12: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:12: ["boolean",null]
json: error: <stdin>:1:12:            ^
command failed: json <<< '\''["boolean",null]'\''
$ json <<< '\''["boolean",false]'\''
json: error: <stdin>:1:12: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:12: ["boolean",false]
json: error: <stdin>:1:12:            ^
command failed: json <<< '\''["boolean",false]'\''
$ json <<< '\''["boolean",true]'\''
json: error: <stdin>:1:12: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:12: ["boolean",true]
json: error: <stdin>:1:12:            ^
command failed: json <<< '\''["boolean",true]'\''
$ json <<< '\''["boolean",123]'\''
json: error: <stdin>:1:12: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:12: ["boolean",123]
json: error: <stdin>:1:12:            ^
command failed: json <<< '\''["boolean",123]'\''
$ json <<< '\''["boolean","foo"]'\''
json: error: <stdin>:1:12: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:12: ["boolean","foo"]
json: error: <stdin>:1:12:            ^
command failed: json <<< '\''["boolean","foo"]'\''
$ json <<< '\''["boolean","type"]'\''
json: error: <stdin>:1:1: meta error: invalid top value: it must be a type or an array of "name" objects
json: error: <stdin>:1:1: ["boolean","type"]
json: error: <stdin>:1:1: ^
command failed: json <<< '\''["boolean","type"]'\''
$ json <<< '\''["boolean","null"]'\''
json: error: <stdin>:1:1: meta error: invalid top value: it must be a type or an array of "name" objects
json: error: <stdin>:1:1: ["boolean","null"]
json: error: <stdin>:1:1: ^
command failed: json <<< '\''["boolean","null"]'\''
$ json <<< '\''["boolean","boolean"]'\''
json: error: <stdin>:1:1: meta error: invalid top value: it must be a type or an array of "name" objects
json: error: <stdin>:1:1: ["boolean","boolean"]
json: error: <stdin>:1:1: ^
command failed: json <<< '\''["boolean","boolean"]'\''
$ json <<< '\''["boolean","number"]'\''
json: error: <stdin>:1:1: meta error: invalid top value: it must be a type or an array of "name" objects
json: error: <stdin>:1:1: ["boolean","number"]
json: error: <stdin>:1:1: ^
command failed: json <<< '\''["boolean","number"]'\''
$ json <<< '\''["boolean","string"]'\''
json: error: <stdin>:1:1: meta error: invalid top value: it must be a type or an array of "name" objects
json: error: <stdin>:1:1: ["boolean","string"]
json: error: <stdin>:1:1: ^
command failed: json <<< '\''["boolean","string"]'\''
$ json <<< '\''["boolean","object"]'\''
json: error: <stdin>:1:1: meta error: invalid top value: it must be a type or an array of "name" objects
json: error: <stdin>:1:1: ["boolean","object"]
json: error: <stdin>:1:1: ^
command failed: json <<< '\''["boolean","object"]'\''
$ json <<< '\''["boolean","array"]'\''
json: error: <stdin>:1:1: meta error: invalid top value: it must be a type or an array of "name" objects
json: error: <stdin>:1:1: ["boolean","array"]
json: error: <stdin>:1:1: ^
command failed: json <<< '\''["boolean","array"]'\''
$ json <<< '\''["boolean","list"]'\''
json: error: <stdin>:1:12: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:12: ["boolean","list"]
json: error: <stdin>:1:12:            ^
command failed: json <<< '\''["boolean","list"]'\''
$ json <<< '\''["boolean","dict"]'\''
json: error: <stdin>:1:12: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:12: ["boolean","dict"]
json: error: <stdin>:1:12:            ^
command failed: json <<< '\''["boolean","dict"]'\''
$ json <<< '\''["boolean",{}]'\''
json: error: <stdin>:1:12: meta error: empty objects are not allowed
json: error: <stdin>:1:12: ["boolean",{}]
json: error: <stdin>:1:12:            ^
command failed: json <<< '\''["boolean",{}]'\''
$ json <<< '\''["boolean",{"foo":"bar"}]'\''
json: error: <stdin>:1:13: meta error: invalid first key of object: it must be "type", "name" or "plain"
json: error: <stdin>:1:13: ["boolean",{"foo":"bar"}]
json: error: <stdin>:1:13:             ^
command failed: json <<< '\''["boolean",{"foo":"bar"}]'\''
$ json <<< '\''["boolean",{"name":"baz","type":"object"}]'\''
json: error: <stdin>:1:12: meta error: invalid array: its elements must all be types or all be "name" objects
json: error: <stdin>:1:12: ["boolean",{"name":"baz","type":"object"}]
json: error: <stdin>:1:12:            ^
command failed: json <<< '\''["boolean",{"name":"baz","type":"object"}]'\''
$ json <<< '\''["boolean",[]]'\''
json: error: <stdin>:1:12: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:12: ["boolean",[]]
json: error: <stdin>:1:12:            ^
command failed: json <<< '\''["boolean",[]]'\''
$ json <<< '\''["boolean",["number","string"]]'\''
json: error: <stdin>:1:12: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:12: ["boolean",["number","string"]]
json: error: <stdin>:1:12:            ^
command failed: json <<< '\''["boolean",["number","string"]]'\''
$ json <<< '\''["number",null]'\''
json: error: <stdin>:1:11: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:11: ["number",null]
json: error: <stdin>:1:11:           ^
command failed: json <<< '\''["number",null]'\''
$ json <<< '\''["number",false]'\''
json: error: <stdin>:1:11: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:11: ["number",false]
json: error: <stdin>:1:11:           ^
command failed: json <<< '\''["number",false]'\''
$ json <<< '\''["number",true]'\''
json: error: <stdin>:1:11: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:11: ["number",true]
json: error: <stdin>:1:11:           ^
command failed: json <<< '\''["number",true]'\''
$ json <<< '\''["number",123]'\''
json: error: <stdin>:1:11: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:11: ["number",123]
json: error: <stdin>:1:11:           ^
command failed: json <<< '\''["number",123]'\''
$ json <<< '\''["number","foo"]'\''
json: error: <stdin>:1:11: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:11: ["number","foo"]
json: error: <stdin>:1:11:           ^
command failed: json <<< '\''["number","foo"]'\''
$ json <<< '\''["number","type"]'\''
json: error: <stdin>:1:1: meta error: invalid top value: it must be a type or an array of "name" objects
json: error: <stdin>:1:1: ["number","type"]
json: error: <stdin>:1:1: ^
command failed: json <<< '\''["number","type"]'\''
$ json <<< '\''["number","null"]'\''
json: error: <stdin>:1:1: meta error: invalid top value: it must be a type or an array of "name" objects
json: error: <stdin>:1:1: ["number","null"]
json: error: <stdin>:1:1: ^
command failed: json <<< '\''["number","null"]'\''
$ json <<< '\''["number","boolean"]'\''
json: error: <stdin>:1:1: meta error: invalid top value: it must be a type or an array of "name" objects
json: error: <stdin>:1:1: ["number","boolean"]
json: error: <stdin>:1:1: ^
command failed: json <<< '\''["number","boolean"]'\''
$ json <<< '\''["number","number"]'\''
json: error: <stdin>:1:1: meta error: invalid top value: it must be a type or an array of "name" objects
json: error: <stdin>:1:1: ["number","number"]
json: error: <stdin>:1:1: ^
command failed: json <<< '\''["number","number"]'\''
$ json <<< '\''["number","string"]'\''
json: error: <stdin>:1:1: meta error: invalid top value: it must be a type or an array of "name" objects
json: error: <stdin>:1:1: ["number","string"]
json: error: <stdin>:1:1: ^
command failed: json <<< '\''["number","string"]'\''
$ json <<< '\''["number","object"]'\''
json: error: <stdin>:1:1: meta error: invalid top value: it must be a type or an array of "name" objects
json: error: <stdin>:1:1: ["number","object"]
json: error: <stdin>:1:1: ^
command failed: json <<< '\''["number","object"]'\''
$ json <<< '\''["number","array"]'\''
json: error: <stdin>:1:1: meta error: invalid top value: it must be a type or an array of "name" objects
json: error: <stdin>:1:1: ["number","array"]
json: error: <stdin>:1:1: ^
command failed: json <<< '\''["number","array"]'\''
$ json <<< '\''["number","list"]'\''
json: error: <stdin>:1:11: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:11: ["number","list"]
json: error: <stdin>:1:11:           ^
command failed: json <<< '\''["number","list"]'\''
$ json <<< '\''["number","dict"]'\''
json: error: <stdin>:1:11: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:11: ["number","dict"]
json: error: <stdin>:1:11:           ^
command failed: json <<< '\''["number","dict"]'\''
$ json <<< '\''["number",{}]'\''
json: error: <stdin>:1:11: meta error: empty objects are not allowed
json: error: <stdin>:1:11: ["number",{}]
json: error: <stdin>:1:11:           ^
command failed: json <<< '\''["number",{}]'\''
$ json <<< '\''["number",{"foo":"bar"}]'\''
json: error: <stdin>:1:12: meta error: invalid first key of object: it must be "type", "name" or "plain"
json: error: <stdin>:1:12: ["number",{"foo":"bar"}]
json: error: <stdin>:1:12:            ^
command failed: json <<< '\''["number",{"foo":"bar"}]'\''
$ json <<< '\''["number",{"name":"baz","type":"object"}]'\''
json: error: <stdin>:1:11: meta error: invalid array: its elements must all be types or all be "name" objects
json: error: <stdin>:1:11: ["number",{"name":"baz","type":"object"}]
json: error: <stdin>:1:11:           ^
command failed: json <<< '\''["number",{"name":"baz","type":"object"}]'\''
$ json <<< '\''["number",[]]'\''
json: error: <stdin>:1:11: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:11: ["number",[]]
json: error: <stdin>:1:11:           ^
command failed: json <<< '\''["number",[]]'\''
$ json <<< '\''["number",["number","string"]]'\''
json: error: <stdin>:1:11: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:11: ["number",["number","string"]]
json: error: <stdin>:1:11:           ^
command failed: json <<< '\''["number",["number","string"]]'\''
$ json <<< '\''["string",null]'\''
json: error: <stdin>:1:11: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:11: ["string",null]
json: error: <stdin>:1:11:           ^
command failed: json <<< '\''["string",null]'\''
$ json <<< '\''["string",false]'\''
json: error: <stdin>:1:11: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:11: ["string",false]
json: error: <stdin>:1:11:           ^
command failed: json <<< '\''["string",false]'\''
$ json <<< '\''["string",true]'\''
json: error: <stdin>:1:11: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:11: ["string",true]
json: error: <stdin>:1:11:           ^
command failed: json <<< '\''["string",true]'\''
$ json <<< '\''["string",123]'\''
json: error: <stdin>:1:11: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:11: ["string",123]
json: error: <stdin>:1:11:           ^
command failed: json <<< '\''["string",123]'\''
$ json <<< '\''["string","foo"]'\''
json: error: <stdin>:1:11: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:11: ["string","foo"]
json: error: <stdin>:1:11:           ^
command failed: json <<< '\''["string","foo"]'\''
$ json <<< '\''["string","type"]'\''
json: error: <stdin>:1:1: meta error: invalid top value: it must be a type or an array of "name" objects
json: error: <stdin>:1:1: ["string","type"]
json: error: <stdin>:1:1: ^
command failed: json <<< '\''["string","type"]'\''
$ json <<< '\''["string","null"]'\''
json: error: <stdin>:1:1: meta error: invalid top value: it must be a type or an array of "name" objects
json: error: <stdin>:1:1: ["string","null"]
json: error: <stdin>:1:1: ^
command failed: json <<< '\''["string","null"]'\''
$ json <<< '\''["string","boolean"]'\''
json: error: <stdin>:1:1: meta error: invalid top value: it must be a type or an array of "name" objects
json: error: <stdin>:1:1: ["string","boolean"]
json: error: <stdin>:1:1: ^
command failed: json <<< '\''["string","boolean"]'\''
$ json <<< '\''["string","number"]'\''
json: error: <stdin>:1:1: meta error: invalid top value: it must be a type or an array of "name" objects
json: error: <stdin>:1:1: ["string","number"]
json: error: <stdin>:1:1: ^
command failed: json <<< '\''["string","number"]'\''
$ json <<< '\''["string","string"]'\''
json: error: <stdin>:1:1: meta error: invalid top value: it must be a type or an array of "name" objects
json: error: <stdin>:1:1: ["string","string"]
json: error: <stdin>:1:1: ^
command failed: json <<< '\''["string","string"]'\''
$ json <<< '\''["string","object"]'\''
json: error: <stdin>:1:1: meta error: invalid top value: it must be a type or an array of "name" objects
json: error: <stdin>:1:1: ["string","object"]
json: error: <stdin>:1:1: ^
command failed: json <<< '\''["string","object"]'\''
$ json <<< '\''["string","array"]'\''
json: error: <stdin>:1:1: meta error: invalid top value: it must be a type or an array of "name" objects
json: error: <stdin>:1:1: ["string","array"]
json: error: <stdin>:1:1: ^
command failed: json <<< '\''["string","array"]'\''
$ json <<< '\''["string","list"]'\''
json: error: <stdin>:1:11: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:11: ["string","list"]
json: error: <stdin>:1:11:           ^
command failed: json <<< '\''["string","list"]'\''
$ json <<< '\''["string","dict"]'\''
json: error: <stdin>:1:11: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:11: ["string","dict"]
json: error: <stdin>:1:11:           ^
command failed: json <<< '\''["string","dict"]'\''
$ json <<< '\''["string",{}]'\''
json: error: <stdin>:1:11: meta error: empty objects are not allowed
json: error: <stdin>:1:11: ["string",{}]
json: error: <stdin>:1:11:           ^
command failed: json <<< '\''["string",{}]'\''
$ json <<< '\''["string",{"foo":"bar"}]'\''
json: error: <stdin>:1:12: meta error: invalid first key of object: it must be "type", "name" or "plain"
json: error: <stdin>:1:12: ["string",{"foo":"bar"}]
json: error: <stdin>:1:12:            ^
command failed: json <<< '\''["string",{"foo":"bar"}]'\''
$ json <<< '\''["string",{"name":"baz","type":"object"}]'\''
json: error: <stdin>:1:11: meta error: invalid array: its elements must all be types or all be "name" objects
json: error: <stdin>:1:11: ["string",{"name":"baz","type":"object"}]
json: error: <stdin>:1:11:           ^
command failed: json <<< '\''["string",{"name":"baz","type":"object"}]'\''
$ json <<< '\''["string",[]]'\''
json: error: <stdin>:1:11: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:11: ["string",[]]
json: error: <stdin>:1:11:           ^
command failed: json <<< '\''["string",[]]'\''
$ json <<< '\''["string",["number","string"]]'\''
json: error: <stdin>:1:11: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:11: ["string",["number","string"]]
json: error: <stdin>:1:11:           ^
command failed: json <<< '\''["string",["number","string"]]'\''
$ json <<< '\''["object",null]'\''
json: error: <stdin>:1:11: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:11: ["object",null]
json: error: <stdin>:1:11:           ^
command failed: json <<< '\''["object",null]'\''
$ json <<< '\''["object",false]'\''
json: error: <stdin>:1:11: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:11: ["object",false]
json: error: <stdin>:1:11:           ^
command failed: json <<< '\''["object",false]'\''
$ json <<< '\''["object",true]'\''
json: error: <stdin>:1:11: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:11: ["object",true]
json: error: <stdin>:1:11:           ^
command failed: json <<< '\''["object",true]'\''
$ json <<< '\''["object",123]'\''
json: error: <stdin>:1:11: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:11: ["object",123]
json: error: <stdin>:1:11:           ^
command failed: json <<< '\''["object",123]'\''
$ json <<< '\''["object","foo"]'\''
json: error: <stdin>:1:11: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:11: ["object","foo"]
json: error: <stdin>:1:11:           ^
command failed: json <<< '\''["object","foo"]'\''
$ json <<< '\''["object","type"]'\''
json: error: <stdin>:1:1: meta error: invalid top value: it must be a type or an array of "name" objects
json: error: <stdin>:1:1: ["object","type"]
json: error: <stdin>:1:1: ^
command failed: json <<< '\''["object","type"]'\''
$ json <<< '\''["object","null"]'\''
json: error: <stdin>:1:1: meta error: invalid top value: it must be a type or an array of "name" objects
json: error: <stdin>:1:1: ["object","null"]
json: error: <stdin>:1:1: ^
command failed: json <<< '\''["object","null"]'\''
$ json <<< '\''["object","boolean"]'\''
json: error: <stdin>:1:1: meta error: invalid top value: it must be a type or an array of "name" objects
json: error: <stdin>:1:1: ["object","boolean"]
json: error: <stdin>:1:1: ^
command failed: json <<< '\''["object","boolean"]'\''
$ json <<< '\''["object","number"]'\''
json: error: <stdin>:1:1: meta error: invalid top value: it must be a type or an array of "name" objects
json: error: <stdin>:1:1: ["object","number"]
json: error: <stdin>:1:1: ^
command failed: json <<< '\''["object","number"]'\''
$ json <<< '\''["object","string"]'\''
json: error: <stdin>:1:1: meta error: invalid top value: it must be a type or an array of "name" objects
json: error: <stdin>:1:1: ["object","string"]
json: error: <stdin>:1:1: ^
command failed: json <<< '\''["object","string"]'\''
$ json <<< '\''["object","object"]'\''
json: error: <stdin>:1:1: meta error: invalid top value: it must be a type or an array of "name" objects
json: error: <stdin>:1:1: ["object","object"]
json: error: <stdin>:1:1: ^
command failed: json <<< '\''["object","object"]'\''
$ json <<< '\''["object","array"]'\''
json: error: <stdin>:1:1: meta error: invalid top value: it must be a type or an array of "name" objects
json: error: <stdin>:1:1: ["object","array"]
json: error: <stdin>:1:1: ^
command failed: json <<< '\''["object","array"]'\''
$ json <<< '\''["object","list"]'\''
json: error: <stdin>:1:11: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:11: ["object","list"]
json: error: <stdin>:1:11:           ^
command failed: json <<< '\''["object","list"]'\''
$ json <<< '\''["object","dict"]'\''
json: error: <stdin>:1:11: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:11: ["object","dict"]
json: error: <stdin>:1:11:           ^
command failed: json <<< '\''["object","dict"]'\''
$ json <<< '\''["object",{}]'\''
json: error: <stdin>:1:11: meta error: empty objects are not allowed
json: error: <stdin>:1:11: ["object",{}]
json: error: <stdin>:1:11:           ^
command failed: json <<< '\''["object",{}]'\''
$ json <<< '\''["object",{"foo":"bar"}]'\''
json: error: <stdin>:1:12: meta error: invalid first key of object: it must be "type", "name" or "plain"
json: error: <stdin>:1:12: ["object",{"foo":"bar"}]
json: error: <stdin>:1:12:            ^
command failed: json <<< '\''["object",{"foo":"bar"}]'\''
$ json <<< '\''["object",{"name":"baz","type":"object"}]'\''
json: error: <stdin>:1:11: meta error: invalid array: its elements must all be types or all be "name" objects
json: error: <stdin>:1:11: ["object",{"name":"baz","type":"object"}]
json: error: <stdin>:1:11:           ^
command failed: json <<< '\''["object",{"name":"baz","type":"object"}]'\''
$ json <<< '\''["object",[]]'\''
json: error: <stdin>:1:11: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:11: ["object",[]]
json: error: <stdin>:1:11:           ^
command failed: json <<< '\''["object",[]]'\''
$ json <<< '\''["object",["number","string"]]'\''
json: error: <stdin>:1:11: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:11: ["object",["number","string"]]
json: error: <stdin>:1:11:           ^
command failed: json <<< '\''["object",["number","string"]]'\''
$ json <<< '\''["array",null]'\''
json: error: <stdin>:1:10: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:10: ["array",null]
json: error: <stdin>:1:10:          ^
command failed: json <<< '\''["array",null]'\''
$ json <<< '\''["array",false]'\''
json: error: <stdin>:1:10: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:10: ["array",false]
json: error: <stdin>:1:10:          ^
command failed: json <<< '\''["array",false]'\''
$ json <<< '\''["array",true]'\''
json: error: <stdin>:1:10: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:10: ["array",true]
json: error: <stdin>:1:10:          ^
command failed: json <<< '\''["array",true]'\''
$ json <<< '\''["array",123]'\''
json: error: <stdin>:1:10: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:10: ["array",123]
json: error: <stdin>:1:10:          ^
command failed: json <<< '\''["array",123]'\''
$ json <<< '\''["array","foo"]'\''
json: error: <stdin>:1:10: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:10: ["array","foo"]
json: error: <stdin>:1:10:          ^
command failed: json <<< '\''["array","foo"]'\''
$ json <<< '\''["array","type"]'\''
json: error: <stdin>:1:1: meta error: invalid top value: it must be a type or an array of "name" objects
json: error: <stdin>:1:1: ["array","type"]
json: error: <stdin>:1:1: ^
command failed: json <<< '\''["array","type"]'\''
$ json <<< '\''["array","null"]'\''
json: error: <stdin>:1:1: meta error: invalid top value: it must be a type or an array of "name" objects
json: error: <stdin>:1:1: ["array","null"]
json: error: <stdin>:1:1: ^
command failed: json <<< '\''["array","null"]'\''
$ json <<< '\''["array","boolean"]'\''
json: error: <stdin>:1:1: meta error: invalid top value: it must be a type or an array of "name" objects
json: error: <stdin>:1:1: ["array","boolean"]
json: error: <stdin>:1:1: ^
command failed: json <<< '\''["array","boolean"]'\''
$ json <<< '\''["array","number"]'\''
json: error: <stdin>:1:1: meta error: invalid top value: it must be a type or an array of "name" objects
json: error: <stdin>:1:1: ["array","number"]
json: error: <stdin>:1:1: ^
command failed: json <<< '\''["array","number"]'\''
$ json <<< '\''["array","string"]'\''
json: error: <stdin>:1:1: meta error: invalid top value: it must be a type or an array of "name" objects
json: error: <stdin>:1:1: ["array","string"]
json: error: <stdin>:1:1: ^
command failed: json <<< '\''["array","string"]'\''
$ json <<< '\''["array","object"]'\''
json: error: <stdin>:1:1: meta error: invalid top value: it must be a type or an array of "name" objects
json: error: <stdin>:1:1: ["array","object"]
json: error: <stdin>:1:1: ^
command failed: json <<< '\''["array","object"]'\''
$ json <<< '\''["array","array"]'\''
json: error: <stdin>:1:1: meta error: invalid top value: it must be a type or an array of "name" objects
json: error: <stdin>:1:1: ["array","array"]
json: error: <stdin>:1:1: ^
command failed: json <<< '\''["array","array"]'\''
$ json <<< '\''["array","list"]'\''
json: error: <stdin>:1:10: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:10: ["array","list"]
json: error: <stdin>:1:10:          ^
command failed: json <<< '\''["array","list"]'\''
$ json <<< '\''["array","dict"]'\''
json: error: <stdin>:1:10: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:10: ["array","dict"]
json: error: <stdin>:1:10:          ^
command failed: json <<< '\''["array","dict"]'\''
$ json <<< '\''["array",{}]'\''
json: error: <stdin>:1:10: meta error: empty objects are not allowed
json: error: <stdin>:1:10: ["array",{}]
json: error: <stdin>:1:10:          ^
command failed: json <<< '\''["array",{}]'\''
$ json <<< '\''["array",{"foo":"bar"}]'\''
json: error: <stdin>:1:11: meta error: invalid first key of object: it must be "type", "name" or "plain"
json: error: <stdin>:1:11: ["array",{"foo":"bar"}]
json: error: <stdin>:1:11:           ^
command failed: json <<< '\''["array",{"foo":"bar"}]'\''
$ json <<< '\''["array",{"name":"baz","type":"object"}]'\''
json: error: <stdin>:1:10: meta error: invalid array: its elements must all be types or all be "name" objects
json: error: <stdin>:1:10: ["array",{"name":"baz","type":"object"}]
json: error: <stdin>:1:10:          ^
command failed: json <<< '\''["array",{"name":"baz","type":"object"}]'\''
$ json <<< '\''["array",[]]'\''
json: error: <stdin>:1:10: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:10: ["array",[]]
json: error: <stdin>:1:10:          ^
command failed: json <<< '\''["array",[]]'\''
$ json <<< '\''["array",["number","string"]]'\''
json: error: <stdin>:1:10: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:10: ["array",["number","string"]]
json: error: <stdin>:1:10:          ^
command failed: json <<< '\''["array",["number","string"]]'\''
$ json <<< '\''[{"plain":null},null]'\''
json: error: <stdin>:1:17: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:17: [{"plain":null},null]
json: error: <stdin>:1:17:                 ^
command failed: json <<< '\''[{"plain":null},null]'\''
$ json <<< '\''[{"plain":null},false]'\''
json: error: <stdin>:1:17: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:17: [{"plain":null},false]
json: error: <stdin>:1:17:                 ^
command failed: json <<< '\''[{"plain":null},false]'\''
$ json <<< '\''[{"plain":null},true]'\''
json: error: <stdin>:1:17: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:17: [{"plain":null},true]
json: error: <stdin>:1:17:                 ^
command failed: json <<< '\''[{"plain":null},true]'\''
$ json <<< '\''[{"plain":null},123]'\''
json: error: <stdin>:1:17: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:17: [{"plain":null},123]
json: error: <stdin>:1:17:                 ^
command failed: json <<< '\''[{"plain":null},123]'\''
$ json <<< '\''[{"plain":null},"foo"]'\''
json: error: <stdin>:1:17: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:17: [{"plain":null},"foo"]
json: error: <stdin>:1:17:                 ^
command failed: json <<< '\''[{"plain":null},"foo"]'\''
$ json <<< '\''[{"plain":null},"type"]'\''
json: error: <stdin>:1:1: meta error: invalid top value: it must be a type or an array of "name" objects
json: error: <stdin>:1:1: [{"plain":null},"type"]
json: error: <stdin>:1:1: ^
command failed: json <<< '\''[{"plain":null},"type"]'\''
$ json <<< '\''[{"plain":null},"null"]'\''
json: error: <stdin>:1:1: meta error: invalid top value: it must be a type or an array of "name" objects
json: error: <stdin>:1:1: [{"plain":null},"null"]
json: error: <stdin>:1:1: ^
command failed: json <<< '\''[{"plain":null},"null"]'\''
$ json <<< '\''[{"plain":null},"boolean"]'\''
json: error: <stdin>:1:1: meta error: invalid top value: it must be a type or an array of "name" objects
json: error: <stdin>:1:1: [{"plain":null},"boolean"]
json: error: <stdin>:1:1: ^
command failed: json <<< '\''[{"plain":null},"boolean"]'\''
$ json <<< '\''[{"plain":null},"number"]'\''
json: error: <stdin>:1:1: meta error: invalid top value: it must be a type or an array of "name" objects
json: error: <stdin>:1:1: [{"plain":null},"number"]
json: error: <stdin>:1:1: ^
command failed: json <<< '\''[{"plain":null},"number"]'\''
$ json <<< '\''[{"plain":null},"string"]'\''
json: error: <stdin>:1:1: meta error: invalid top value: it must be a type or an array of "name" objects
json: error: <stdin>:1:1: [{"plain":null},"string"]
json: error: <stdin>:1:1: ^
command failed: json <<< '\''[{"plain":null},"string"]'\''
$ json <<< '\''[{"plain":null},"object"]'\''
json: error: <stdin>:1:1: meta error: invalid top value: it must be a type or an array of "name" objects
json: error: <stdin>:1:1: [{"plain":null},"object"]
json: error: <stdin>:1:1: ^
command failed: json <<< '\''[{"plain":null},"object"]'\''
$ json <<< '\''[{"plain":null},"array"]'\''
json: error: <stdin>:1:1: meta error: invalid top value: it must be a type or an array of "name" objects
json: error: <stdin>:1:1: [{"plain":null},"array"]
json: error: <stdin>:1:1: ^
command failed: json <<< '\''[{"plain":null},"array"]'\''
$ json <<< '\''[{"plain":null},"list"]'\''
json: error: <stdin>:1:17: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:17: [{"plain":null},"list"]
json: error: <stdin>:1:17:                 ^
command failed: json <<< '\''[{"plain":null},"list"]'\''
$ json <<< '\''[{"plain":null},"dict"]'\''
json: error: <stdin>:1:17: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:17: [{"plain":null},"dict"]
json: error: <stdin>:1:17:                 ^
command failed: json <<< '\''[{"plain":null},"dict"]'\''
$ json <<< '\''[{"plain":null},{}]'\''
json: error: <stdin>:1:17: meta error: empty objects are not allowed
json: error: <stdin>:1:17: [{"plain":null},{}]
json: error: <stdin>:1:17:                 ^
command failed: json <<< '\''[{"plain":null},{}]'\''
$ json <<< '\''[{"plain":null},{"foo":"bar"}]'\''
json: error: <stdin>:1:18: meta error: invalid first key of object: it must be "type", "name" or "plain"
json: error: <stdin>:1:18: [{"plain":null},{"foo":"bar"}]
json: error: <stdin>:1:18:                  ^
command failed: json <<< '\''[{"plain":null},{"foo":"bar"}]'\''
$ json <<< '\''[{"plain":null},{"name":"baz","type":"object"}]'\''
json: error: <stdin>:1:17: meta error: invalid array: its elements must all be types or all be "name" objects
json: error: <stdin>:1:17: [{"plain":null},{"name":"baz","type":"object"}]
json: error: <stdin>:1:17:                 ^
command failed: json <<< '\''[{"plain":null},{"name":"baz","type":"object"}]'\''
$ json <<< '\''[{"plain":null},[]]'\''
json: error: <stdin>:1:17: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:17: [{"plain":null},[]]
json: error: <stdin>:1:17:                 ^
command failed: json <<< '\''[{"plain":null},[]]'\''
$ json <<< '\''[{"plain":null},["number","string"]]'\''
json: error: <stdin>:1:17: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:17: [{"plain":null},["number","string"]]
json: error: <stdin>:1:17:                 ^
command failed: json <<< '\''[{"plain":null},["number","string"]]'\''
$ json <<< '\''[{"type":"array","args":"type"},null]'\''
json: error: <stdin>:1:33: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:33: [{"type":"array","args":"type"},null]
json: error: <stdin>:1:33:                                 ^
command failed: json <<< '\''[{"type":"array","args":"type"},null]'\''
$ json <<< '\''[{"type":"array","args":"type"},false]'\''
json: error: <stdin>:1:33: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:33: [{"type":"array","args":"type"},false]
json: error: <stdin>:1:33:                                 ^
command failed: json <<< '\''[{"type":"array","args":"type"},false]'\''
$ json <<< '\''[{"type":"array","args":"type"},true]'\''
json: error: <stdin>:1:33: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:33: [{"type":"array","args":"type"},true]
json: error: <stdin>:1:33:                                 ^
command failed: json <<< '\''[{"type":"array","args":"type"},true]'\''
$ json <<< '\''[{"type":"array","args":"type"},123]'\''
json: error: <stdin>:1:33: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:33: [{"type":"array","args":"type"},123]
json: error: <stdin>:1:33:                                 ^
command failed: json <<< '\''[{"type":"array","args":"type"},123]'\''
$ json <<< '\''[{"type":"array","args":"type"},"foo"]'\''
json: error: <stdin>:1:33: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:33: [{"type":"array","args":"type"},"foo"]
json: error: <stdin>:1:33:                                 ^
command failed: json <<< '\''[{"type":"array","args":"type"},"foo"]'\''
$ json <<< '\''[{"type":"array","args":"type"},"type"]'\''
json: error: <stdin>:1:1: meta error: invalid top value: it must be a type or an array of "name" objects
json: error: <stdin>:1:1: [{"type":"array","args":"type"},"
json: error: <stdin>:1:1: ^
command failed: json <<< '\''[{"type":"array","args":"type"},"type"]'\''
$ json <<< '\''[{"type":"array","args":"type"},"null"]'\''
json: error: <stdin>:1:1: meta error: invalid top value: it must be a type or an array of "name" objects
json: error: <stdin>:1:1: [{"type":"array","args":"type"},"
json: error: <stdin>:1:1: ^
command failed: json <<< '\''[{"type":"array","args":"type"},"null"]'\''
$ json <<< '\''[{"type":"array","args":"type"},"boolean"]'\''
json: error: <stdin>:1:1: meta error: invalid top value: it must be a type or an array of "name" objects
json: error: <stdin>:1:1: [{"type":"array","args":"type"},"
json: error: <stdin>:1:1: ^
command failed: json <<< '\''[{"type":"array","args":"type"},"boolean"]'\''
$ json <<< '\''[{"type":"array","args":"type"},"number"]'\''
json: error: <stdin>:1:1: meta error: invalid top value: it must be a type or an array of "name" objects
json: error: <stdin>:1:1: [{"type":"array","args":"type"},"
json: error: <stdin>:1:1: ^
command failed: json <<< '\''[{"type":"array","args":"type"},"number"]'\''
$ json <<< '\''[{"type":"array","args":"type"},"string"]'\''
json: error: <stdin>:1:1: meta error: invalid top value: it must be a type or an array of "name" objects
json: error: <stdin>:1:1: [{"type":"array","args":"type"},"
json: error: <stdin>:1:1: ^
command failed: json <<< '\''[{"type":"array","args":"type"},"string"]'\''
$ json <<< '\''[{"type":"array","args":"type"},"object"]'\''
json: error: <stdin>:1:1: meta error: invalid top value: it must be a type or an array of "name" objects
json: error: <stdin>:1:1: [{"type":"array","args":"type"},"
json: error: <stdin>:1:1: ^
command failed: json <<< '\''[{"type":"array","args":"type"},"object"]'\''
$ json <<< '\''[{"type":"array","args":"type"},"array"]'\''
json: error: <stdin>:1:1: meta error: invalid top value: it must be a type or an array of "name" objects
json: error: <stdin>:1:1: [{"type":"array","args":"type"},"
json: error: <stdin>:1:1: ^
command failed: json <<< '\''[{"type":"array","args":"type"},"array"]'\''
$ json <<< '\''[{"type":"array","args":"type"},"list"]'\''
json: error: <stdin>:1:33: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:33: [{"type":"array","args":"type"},"list"]
json: error: <stdin>:1:33:                                 ^
command failed: json <<< '\''[{"type":"array","args":"type"},"list"]'\''
$ json <<< '\''[{"type":"array","args":"type"},"dict"]'\''
json: error: <stdin>:1:33: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:33: [{"type":"array","args":"type"},"dict"]
json: error: <stdin>:1:33:                                 ^
command failed: json <<< '\''[{"type":"array","args":"type"},"dict"]'\''
$ json <<< '\''[{"type":"array","args":"type"},{}]'\''
json: error: <stdin>:1:33: meta error: empty objects are not allowed
json: error: <stdin>:1:33: [{"type":"array","args":"type"},{}]
json: error: <stdin>:1:33:                                 ^
command failed: json <<< '\''[{"type":"array","args":"type"},{}]'\''
$ json <<< '\''[{"type":"array","args":"type"},{"foo":"bar"}]'\''
json: error: <stdin>:1:34: meta error: invalid first key of object: it must be "type", "name" or "plain"
json: error: <stdin>:1:34: {"type":"array","args":"type"},{"foo":"bar"}]
json: error: <stdin>:1:34:                                 ^
command failed: json <<< '\''[{"type":"array","args":"type"},{"foo":"bar"}]'\''
$ json <<< '\''[{"type":"array","args":"type"},{"name":"baz","type":"object"}]'\''
json: error: <stdin>:1:33: meta error: invalid array: its elements must all be types or all be "name" objects
json: error: <stdin>:1:33: [{"type":"array","args":"type"},{"name":"baz","type":"object"}]
json: error: <stdin>:1:33:                                 ^
command failed: json <<< '\''[{"type":"array","args":"type"},{"name":"baz","type":"object"}]'\''
$ json <<< '\''[{"type":"array","args":"type"},[]]'\''
json: error: <stdin>:1:33: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:33: [{"type":"array","args":"type"},[]]
json: error: <stdin>:1:33:                                 ^
command failed: json <<< '\''[{"type":"array","args":"type"},[]]'\''
$ json <<< '\''[{"type":"array","args":"type"},["number","string"]]'\''
json: error: <stdin>:1:33: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:33: [{"type":"array","args":"type"},["number","string"]]
json: error: <stdin>:1:33:                                 ^
command failed: json <<< '\''[{"type":"array","args":"type"},["number","string"]]'\''
$ json <<< '\''[{"name":"baz","type":"object"},null]'\''
json: error: <stdin>:1:33: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:33: [{"name":"baz","type":"object"},null]
json: error: <stdin>:1:33:                                 ^
command failed: json <<< '\''[{"name":"baz","type":"object"},null]'\''
$ json <<< '\''[{"name":"baz","type":"object"},false]'\''
json: error: <stdin>:1:33: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:33: [{"name":"baz","type":"object"},false]
json: error: <stdin>:1:33:                                 ^
command failed: json <<< '\''[{"name":"baz","type":"object"},false]'\''
$ json <<< '\''[{"name":"baz","type":"object"},true]'\''
json: error: <stdin>:1:33: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:33: [{"name":"baz","type":"object"},true]
json: error: <stdin>:1:33:                                 ^
command failed: json <<< '\''[{"name":"baz","type":"object"},true]'\''
$ json <<< '\''[{"name":"baz","type":"object"},123]'\''
json: error: <stdin>:1:33: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:33: [{"name":"baz","type":"object"},123]
json: error: <stdin>:1:33:                                 ^
command failed: json <<< '\''[{"name":"baz","type":"object"},123]'\''
$ json <<< '\''[{"name":"baz","type":"object"},"foo"]'\''
json: error: <stdin>:1:33: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:33: [{"name":"baz","type":"object"},"foo"]
json: error: <stdin>:1:33:                                 ^
command failed: json <<< '\''[{"name":"baz","type":"object"},"foo"]'\''
$ json <<< '\''[{"name":"baz","type":"object"},"type"]'\''
json: error: <stdin>:1:33: meta error: invalid array: its elements must all be types or all be "name" objects
json: error: <stdin>:1:33: [{"name":"baz","type":"object"},"type"]
json: error: <stdin>:1:33:                                 ^
command failed: json <<< '\''[{"name":"baz","type":"object"},"type"]'\''
$ json <<< '\''[{"name":"baz","type":"object"},"null"]'\''
json: error: <stdin>:1:33: meta error: invalid array: its elements must all be types or all be "name" objects
json: error: <stdin>:1:33: [{"name":"baz","type":"object"},"null"]
json: error: <stdin>:1:33:                                 ^
command failed: json <<< '\''[{"name":"baz","type":"object"},"null"]'\''
$ json <<< '\''[{"name":"baz","type":"object"},"boolean"]'\''
json: error: <stdin>:1:33: meta error: invalid array: its elements must all be types or all be "name" objects
json: error: <stdin>:1:33: [{"name":"baz","type":"object"},"boolean"]
json: error: <stdin>:1:33:                                 ^
command failed: json <<< '\''[{"name":"baz","type":"object"},"boolean"]'\''
$ json <<< '\''[{"name":"baz","type":"object"},"number"]'\''
json: error: <stdin>:1:33: meta error: invalid array: its elements must all be types or all be "name" objects
json: error: <stdin>:1:33: [{"name":"baz","type":"object"},"number"]
json: error: <stdin>:1:33:                                 ^
command failed: json <<< '\''[{"name":"baz","type":"object"},"number"]'\''
$ json <<< '\''[{"name":"baz","type":"object"},"string"]'\''
json: error: <stdin>:1:33: meta error: invalid array: its elements must all be types or all be "name" objects
json: error: <stdin>:1:33: [{"name":"baz","type":"object"},"string"]
json: error: <stdin>:1:33:                                 ^
command failed: json <<< '\''[{"name":"baz","type":"object"},"string"]'\''
$ json <<< '\''[{"name":"baz","type":"object"},"object"]'\''
json: error: <stdin>:1:33: meta error: invalid array: its elements must all be types or all be "name" objects
json: error: <stdin>:1:33: [{"name":"baz","type":"object"},"object"]
json: error: <stdin>:1:33:                                 ^
command failed: json <<< '\''[{"name":"baz","type":"object"},"object"]'\''
$ json <<< '\''[{"name":"baz","type":"object"},"array"]'\''
json: error: <stdin>:1:33: meta error: invalid array: its elements must all be types or all be "name" objects
json: error: <stdin>:1:33: [{"name":"baz","type":"object"},"array"]
json: error: <stdin>:1:33:                                 ^
command failed: json <<< '\''[{"name":"baz","type":"object"},"array"]'\''
$ json <<< '\''[{"name":"baz","type":"object"},"list"]'\''
json: error: <stdin>:1:33: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:33: [{"name":"baz","type":"object"},"list"]
json: error: <stdin>:1:33:                                 ^
command failed: json <<< '\''[{"name":"baz","type":"object"},"list"]'\''
$ json <<< '\''[{"name":"baz","type":"object"},"dict"]'\''
json: error: <stdin>:1:33: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:33: [{"name":"baz","type":"object"},"dict"]
json: error: <stdin>:1:33:                                 ^
command failed: json <<< '\''[{"name":"baz","type":"object"},"dict"]'\''
$ json <<< '\''[{"name":"baz","type":"object"},{}]'\''
json: error: <stdin>:1:33: meta error: empty objects are not allowed
json: error: <stdin>:1:33: [{"name":"baz","type":"object"},{}]
json: error: <stdin>:1:33:                                 ^
command failed: json <<< '\''[{"name":"baz","type":"object"},{}]'\''
$ json <<< '\''[{"name":"baz","type":"object"},{"foo":"bar"}]'\''
json: error: <stdin>:1:34: meta error: invalid first key of object: it must be "type", "name" or "plain"
json: error: <stdin>:1:34: {"name":"baz","type":"object"},{"foo":"bar"}]
json: error: <stdin>:1:34:                                 ^
command failed: json <<< '\''[{"name":"baz","type":"object"},{"foo":"bar"}]'\''
$ json <<< '\''[{"name":"baz","type":"object"},{"name":"baz","type":"object"}]'\''
json: error: <stdin>:1:41: attribute error: invalid array of "name" objects: duplicated type name (previous defined at 1:10)
json: error: <stdin>:1:41: :"baz","type":"object"},{"name":"baz","type":"object"}]
json: error: <stdin>:1:41:                                 ^
[
    {
        "name": "baz",
        "type": "object"
    },
    {
        "name": "baz",
        "type": "object"
    }
]
command failed: json <<< '\''[{"name":"baz","type":"object"},{"name":"baz","type":"object"}]'\''
$ json <<< '\''[{"name":"baz","type":"object"},[]]'\''
json: error: <stdin>:1:33: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:33: [{"name":"baz","type":"object"},[]]
json: error: <stdin>:1:33:                                 ^
command failed: json <<< '\''[{"name":"baz","type":"object"},[]]'\''
$ json <<< '\''[{"name":"baz","type":"object"},["number","string"]]'\''
json: error: <stdin>:1:33: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:33: [{"name":"baz","type":"object"},["number","string"]]
json: error: <stdin>:1:33:                                 ^
command failed: json <<< '\''[{"name":"baz","type":"object"},["number","string"]]'\'''
) -L array-value2.new <(
echo '$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }'
json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; } 2>&1 ||
echo 'command failed: json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }'

echo '$ json <<< '\''["type",null]'\'''
json <<< '["type",null]' 2>&1 ||
echo 'command failed: json <<< '\''["type",null]'\'''

echo '$ json <<< '\''["type",false]'\'''
json <<< '["type",false]' 2>&1 ||
echo 'command failed: json <<< '\''["type",false]'\'''

echo '$ json <<< '\''["type",true]'\'''
json <<< '["type",true]' 2>&1 ||
echo 'command failed: json <<< '\''["type",true]'\'''

echo '$ json <<< '\''["type",123]'\'''
json <<< '["type",123]' 2>&1 ||
echo 'command failed: json <<< '\''["type",123]'\'''

echo '$ json <<< '\''["type","foo"]'\'''
json <<< '["type","foo"]' 2>&1 ||
echo 'command failed: json <<< '\''["type","foo"]'\'''

echo '$ json <<< '\''["type","type"]'\'''
json <<< '["type","type"]' 2>&1 ||
echo 'command failed: json <<< '\''["type","type"]'\'''

echo '$ json <<< '\''["type","null"]'\'''
json <<< '["type","null"]' 2>&1 ||
echo 'command failed: json <<< '\''["type","null"]'\'''

echo '$ json <<< '\''["type","boolean"]'\'''
json <<< '["type","boolean"]' 2>&1 ||
echo 'command failed: json <<< '\''["type","boolean"]'\'''

echo '$ json <<< '\''["type","number"]'\'''
json <<< '["type","number"]' 2>&1 ||
echo 'command failed: json <<< '\''["type","number"]'\'''

echo '$ json <<< '\''["type","string"]'\'''
json <<< '["type","string"]' 2>&1 ||
echo 'command failed: json <<< '\''["type","string"]'\'''

echo '$ json <<< '\''["type","object"]'\'''
json <<< '["type","object"]' 2>&1 ||
echo 'command failed: json <<< '\''["type","object"]'\'''

echo '$ json <<< '\''["type","array"]'\'''
json <<< '["type","array"]' 2>&1 ||
echo 'command failed: json <<< '\''["type","array"]'\'''

echo '$ json <<< '\''["type","list"]'\'''
json <<< '["type","list"]' 2>&1 ||
echo 'command failed: json <<< '\''["type","list"]'\'''

echo '$ json <<< '\''["type","dict"]'\'''
json <<< '["type","dict"]' 2>&1 ||
echo 'command failed: json <<< '\''["type","dict"]'\'''

echo '$ json <<< '\''["type",{}]'\'''
json <<< '["type",{}]' 2>&1 ||
echo 'command failed: json <<< '\''["type",{}]'\'''

echo '$ json <<< '\''["type",{"foo":"bar"}]'\'''
json <<< '["type",{"foo":"bar"}]' 2>&1 ||
echo 'command failed: json <<< '\''["type",{"foo":"bar"}]'\'''

echo '$ json <<< '\''["type",{"name":"baz","type":"object"}]'\'''
json <<< '["type",{"name":"baz","type":"object"}]' 2>&1 ||
echo 'command failed: json <<< '\''["type",{"name":"baz","type":"object"}]'\'''

echo '$ json <<< '\''["type",[]]'\'''
json <<< '["type",[]]' 2>&1 ||
echo 'command failed: json <<< '\''["type",[]]'\'''

echo '$ json <<< '\''["type",["number","string"]]'\'''
json <<< '["type",["number","string"]]' 2>&1 ||
echo 'command failed: json <<< '\''["type",["number","string"]]'\'''

echo '$ json <<< '\''["null",null]'\'''
json <<< '["null",null]' 2>&1 ||
echo 'command failed: json <<< '\''["null",null]'\'''

echo '$ json <<< '\''["null",false]'\'''
json <<< '["null",false]' 2>&1 ||
echo 'command failed: json <<< '\''["null",false]'\'''

echo '$ json <<< '\''["null",true]'\'''
json <<< '["null",true]' 2>&1 ||
echo 'command failed: json <<< '\''["null",true]'\'''

echo '$ json <<< '\''["null",123]'\'''
json <<< '["null",123]' 2>&1 ||
echo 'command failed: json <<< '\''["null",123]'\'''

echo '$ json <<< '\''["null","foo"]'\'''
json <<< '["null","foo"]' 2>&1 ||
echo 'command failed: json <<< '\''["null","foo"]'\'''

echo '$ json <<< '\''["null","type"]'\'''
json <<< '["null","type"]' 2>&1 ||
echo 'command failed: json <<< '\''["null","type"]'\'''

echo '$ json <<< '\''["null","null"]'\'''
json <<< '["null","null"]' 2>&1 ||
echo 'command failed: json <<< '\''["null","null"]'\'''

echo '$ json <<< '\''["null","boolean"]'\'''
json <<< '["null","boolean"]' 2>&1 ||
echo 'command failed: json <<< '\''["null","boolean"]'\'''

echo '$ json <<< '\''["null","number"]'\'''
json <<< '["null","number"]' 2>&1 ||
echo 'command failed: json <<< '\''["null","number"]'\'''

echo '$ json <<< '\''["null","string"]'\'''
json <<< '["null","string"]' 2>&1 ||
echo 'command failed: json <<< '\''["null","string"]'\'''

echo '$ json <<< '\''["null","object"]'\'''
json <<< '["null","object"]' 2>&1 ||
echo 'command failed: json <<< '\''["null","object"]'\'''

echo '$ json <<< '\''["null","array"]'\'''
json <<< '["null","array"]' 2>&1 ||
echo 'command failed: json <<< '\''["null","array"]'\'''

echo '$ json <<< '\''["null","list"]'\'''
json <<< '["null","list"]' 2>&1 ||
echo 'command failed: json <<< '\''["null","list"]'\'''

echo '$ json <<< '\''["null","dict"]'\'''
json <<< '["null","dict"]' 2>&1 ||
echo 'command failed: json <<< '\''["null","dict"]'\'''

echo '$ json <<< '\''["null",{}]'\'''
json <<< '["null",{}]' 2>&1 ||
echo 'command failed: json <<< '\''["null",{}]'\'''

echo '$ json <<< '\''["null",{"foo":"bar"}]'\'''
json <<< '["null",{"foo":"bar"}]' 2>&1 ||
echo 'command failed: json <<< '\''["null",{"foo":"bar"}]'\'''

echo '$ json <<< '\''["null",{"name":"baz","type":"object"}]'\'''
json <<< '["null",{"name":"baz","type":"object"}]' 2>&1 ||
echo 'command failed: json <<< '\''["null",{"name":"baz","type":"object"}]'\'''

echo '$ json <<< '\''["null",[]]'\'''
json <<< '["null",[]]' 2>&1 ||
echo 'command failed: json <<< '\''["null",[]]'\'''

echo '$ json <<< '\''["null",["number","string"]]'\'''
json <<< '["null",["number","string"]]' 2>&1 ||
echo 'command failed: json <<< '\''["null",["number","string"]]'\'''

echo '$ json <<< '\''["boolean",null]'\'''
json <<< '["boolean",null]' 2>&1 ||
echo 'command failed: json <<< '\''["boolean",null]'\'''

echo '$ json <<< '\''["boolean",false]'\'''
json <<< '["boolean",false]' 2>&1 ||
echo 'command failed: json <<< '\''["boolean",false]'\'''

echo '$ json <<< '\''["boolean",true]'\'''
json <<< '["boolean",true]' 2>&1 ||
echo 'command failed: json <<< '\''["boolean",true]'\'''

echo '$ json <<< '\''["boolean",123]'\'''
json <<< '["boolean",123]' 2>&1 ||
echo 'command failed: json <<< '\''["boolean",123]'\'''

echo '$ json <<< '\''["boolean","foo"]'\'''
json <<< '["boolean","foo"]' 2>&1 ||
echo 'command failed: json <<< '\''["boolean","foo"]'\'''

echo '$ json <<< '\''["boolean","type"]'\'''
json <<< '["boolean","type"]' 2>&1 ||
echo 'command failed: json <<< '\''["boolean","type"]'\'''

echo '$ json <<< '\''["boolean","null"]'\'''
json <<< '["boolean","null"]' 2>&1 ||
echo 'command failed: json <<< '\''["boolean","null"]'\'''

echo '$ json <<< '\''["boolean","boolean"]'\'''
json <<< '["boolean","boolean"]' 2>&1 ||
echo 'command failed: json <<< '\''["boolean","boolean"]'\'''

echo '$ json <<< '\''["boolean","number"]'\'''
json <<< '["boolean","number"]' 2>&1 ||
echo 'command failed: json <<< '\''["boolean","number"]'\'''

echo '$ json <<< '\''["boolean","string"]'\'''
json <<< '["boolean","string"]' 2>&1 ||
echo 'command failed: json <<< '\''["boolean","string"]'\'''

echo '$ json <<< '\''["boolean","object"]'\'''
json <<< '["boolean","object"]' 2>&1 ||
echo 'command failed: json <<< '\''["boolean","object"]'\'''

echo '$ json <<< '\''["boolean","array"]'\'''
json <<< '["boolean","array"]' 2>&1 ||
echo 'command failed: json <<< '\''["boolean","array"]'\'''

echo '$ json <<< '\''["boolean","list"]'\'''
json <<< '["boolean","list"]' 2>&1 ||
echo 'command failed: json <<< '\''["boolean","list"]'\'''

echo '$ json <<< '\''["boolean","dict"]'\'''
json <<< '["boolean","dict"]' 2>&1 ||
echo 'command failed: json <<< '\''["boolean","dict"]'\'''

echo '$ json <<< '\''["boolean",{}]'\'''
json <<< '["boolean",{}]' 2>&1 ||
echo 'command failed: json <<< '\''["boolean",{}]'\'''

echo '$ json <<< '\''["boolean",{"foo":"bar"}]'\'''
json <<< '["boolean",{"foo":"bar"}]' 2>&1 ||
echo 'command failed: json <<< '\''["boolean",{"foo":"bar"}]'\'''

echo '$ json <<< '\''["boolean",{"name":"baz","type":"object"}]'\'''
json <<< '["boolean",{"name":"baz","type":"object"}]' 2>&1 ||
echo 'command failed: json <<< '\''["boolean",{"name":"baz","type":"object"}]'\'''

echo '$ json <<< '\''["boolean",[]]'\'''
json <<< '["boolean",[]]' 2>&1 ||
echo 'command failed: json <<< '\''["boolean",[]]'\'''

echo '$ json <<< '\''["boolean",["number","string"]]'\'''
json <<< '["boolean",["number","string"]]' 2>&1 ||
echo 'command failed: json <<< '\''["boolean",["number","string"]]'\'''

echo '$ json <<< '\''["number",null]'\'''
json <<< '["number",null]' 2>&1 ||
echo 'command failed: json <<< '\''["number",null]'\'''

echo '$ json <<< '\''["number",false]'\'''
json <<< '["number",false]' 2>&1 ||
echo 'command failed: json <<< '\''["number",false]'\'''

echo '$ json <<< '\''["number",true]'\'''
json <<< '["number",true]' 2>&1 ||
echo 'command failed: json <<< '\''["number",true]'\'''

echo '$ json <<< '\''["number",123]'\'''
json <<< '["number",123]' 2>&1 ||
echo 'command failed: json <<< '\''["number",123]'\'''

echo '$ json <<< '\''["number","foo"]'\'''
json <<< '["number","foo"]' 2>&1 ||
echo 'command failed: json <<< '\''["number","foo"]'\'''

echo '$ json <<< '\''["number","type"]'\'''
json <<< '["number","type"]' 2>&1 ||
echo 'command failed: json <<< '\''["number","type"]'\'''

echo '$ json <<< '\''["number","null"]'\'''
json <<< '["number","null"]' 2>&1 ||
echo 'command failed: json <<< '\''["number","null"]'\'''

echo '$ json <<< '\''["number","boolean"]'\'''
json <<< '["number","boolean"]' 2>&1 ||
echo 'command failed: json <<< '\''["number","boolean"]'\'''

echo '$ json <<< '\''["number","number"]'\'''
json <<< '["number","number"]' 2>&1 ||
echo 'command failed: json <<< '\''["number","number"]'\'''

echo '$ json <<< '\''["number","string"]'\'''
json <<< '["number","string"]' 2>&1 ||
echo 'command failed: json <<< '\''["number","string"]'\'''

echo '$ json <<< '\''["number","object"]'\'''
json <<< '["number","object"]' 2>&1 ||
echo 'command failed: json <<< '\''["number","object"]'\'''

echo '$ json <<< '\''["number","array"]'\'''
json <<< '["number","array"]' 2>&1 ||
echo 'command failed: json <<< '\''["number","array"]'\'''

echo '$ json <<< '\''["number","list"]'\'''
json <<< '["number","list"]' 2>&1 ||
echo 'command failed: json <<< '\''["number","list"]'\'''

echo '$ json <<< '\''["number","dict"]'\'''
json <<< '["number","dict"]' 2>&1 ||
echo 'command failed: json <<< '\''["number","dict"]'\'''

echo '$ json <<< '\''["number",{}]'\'''
json <<< '["number",{}]' 2>&1 ||
echo 'command failed: json <<< '\''["number",{}]'\'''

echo '$ json <<< '\''["number",{"foo":"bar"}]'\'''
json <<< '["number",{"foo":"bar"}]' 2>&1 ||
echo 'command failed: json <<< '\''["number",{"foo":"bar"}]'\'''

echo '$ json <<< '\''["number",{"name":"baz","type":"object"}]'\'''
json <<< '["number",{"name":"baz","type":"object"}]' 2>&1 ||
echo 'command failed: json <<< '\''["number",{"name":"baz","type":"object"}]'\'''

echo '$ json <<< '\''["number",[]]'\'''
json <<< '["number",[]]' 2>&1 ||
echo 'command failed: json <<< '\''["number",[]]'\'''

echo '$ json <<< '\''["number",["number","string"]]'\'''
json <<< '["number",["number","string"]]' 2>&1 ||
echo 'command failed: json <<< '\''["number",["number","string"]]'\'''

echo '$ json <<< '\''["string",null]'\'''
json <<< '["string",null]' 2>&1 ||
echo 'command failed: json <<< '\''["string",null]'\'''

echo '$ json <<< '\''["string",false]'\'''
json <<< '["string",false]' 2>&1 ||
echo 'command failed: json <<< '\''["string",false]'\'''

echo '$ json <<< '\''["string",true]'\'''
json <<< '["string",true]' 2>&1 ||
echo 'command failed: json <<< '\''["string",true]'\'''

echo '$ json <<< '\''["string",123]'\'''
json <<< '["string",123]' 2>&1 ||
echo 'command failed: json <<< '\''["string",123]'\'''

echo '$ json <<< '\''["string","foo"]'\'''
json <<< '["string","foo"]' 2>&1 ||
echo 'command failed: json <<< '\''["string","foo"]'\'''

echo '$ json <<< '\''["string","type"]'\'''
json <<< '["string","type"]' 2>&1 ||
echo 'command failed: json <<< '\''["string","type"]'\'''

echo '$ json <<< '\''["string","null"]'\'''
json <<< '["string","null"]' 2>&1 ||
echo 'command failed: json <<< '\''["string","null"]'\'''

echo '$ json <<< '\''["string","boolean"]'\'''
json <<< '["string","boolean"]' 2>&1 ||
echo 'command failed: json <<< '\''["string","boolean"]'\'''

echo '$ json <<< '\''["string","number"]'\'''
json <<< '["string","number"]' 2>&1 ||
echo 'command failed: json <<< '\''["string","number"]'\'''

echo '$ json <<< '\''["string","string"]'\'''
json <<< '["string","string"]' 2>&1 ||
echo 'command failed: json <<< '\''["string","string"]'\'''

echo '$ json <<< '\''["string","object"]'\'''
json <<< '["string","object"]' 2>&1 ||
echo 'command failed: json <<< '\''["string","object"]'\'''

echo '$ json <<< '\''["string","array"]'\'''
json <<< '["string","array"]' 2>&1 ||
echo 'command failed: json <<< '\''["string","array"]'\'''

echo '$ json <<< '\''["string","list"]'\'''
json <<< '["string","list"]' 2>&1 ||
echo 'command failed: json <<< '\''["string","list"]'\'''

echo '$ json <<< '\''["string","dict"]'\'''
json <<< '["string","dict"]' 2>&1 ||
echo 'command failed: json <<< '\''["string","dict"]'\'''

echo '$ json <<< '\''["string",{}]'\'''
json <<< '["string",{}]' 2>&1 ||
echo 'command failed: json <<< '\''["string",{}]'\'''

echo '$ json <<< '\''["string",{"foo":"bar"}]'\'''
json <<< '["string",{"foo":"bar"}]' 2>&1 ||
echo 'command failed: json <<< '\''["string",{"foo":"bar"}]'\'''

echo '$ json <<< '\''["string",{"name":"baz","type":"object"}]'\'''
json <<< '["string",{"name":"baz","type":"object"}]' 2>&1 ||
echo 'command failed: json <<< '\''["string",{"name":"baz","type":"object"}]'\'''

echo '$ json <<< '\''["string",[]]'\'''
json <<< '["string",[]]' 2>&1 ||
echo 'command failed: json <<< '\''["string",[]]'\'''

echo '$ json <<< '\''["string",["number","string"]]'\'''
json <<< '["string",["number","string"]]' 2>&1 ||
echo 'command failed: json <<< '\''["string",["number","string"]]'\'''

echo '$ json <<< '\''["object",null]'\'''
json <<< '["object",null]' 2>&1 ||
echo 'command failed: json <<< '\''["object",null]'\'''

echo '$ json <<< '\''["object",false]'\'''
json <<< '["object",false]' 2>&1 ||
echo 'command failed: json <<< '\''["object",false]'\'''

echo '$ json <<< '\''["object",true]'\'''
json <<< '["object",true]' 2>&1 ||
echo 'command failed: json <<< '\''["object",true]'\'''

echo '$ json <<< '\''["object",123]'\'''
json <<< '["object",123]' 2>&1 ||
echo 'command failed: json <<< '\''["object",123]'\'''

echo '$ json <<< '\''["object","foo"]'\'''
json <<< '["object","foo"]' 2>&1 ||
echo 'command failed: json <<< '\''["object","foo"]'\'''

echo '$ json <<< '\''["object","type"]'\'''
json <<< '["object","type"]' 2>&1 ||
echo 'command failed: json <<< '\''["object","type"]'\'''

echo '$ json <<< '\''["object","null"]'\'''
json <<< '["object","null"]' 2>&1 ||
echo 'command failed: json <<< '\''["object","null"]'\'''

echo '$ json <<< '\''["object","boolean"]'\'''
json <<< '["object","boolean"]' 2>&1 ||
echo 'command failed: json <<< '\''["object","boolean"]'\'''

echo '$ json <<< '\''["object","number"]'\'''
json <<< '["object","number"]' 2>&1 ||
echo 'command failed: json <<< '\''["object","number"]'\'''

echo '$ json <<< '\''["object","string"]'\'''
json <<< '["object","string"]' 2>&1 ||
echo 'command failed: json <<< '\''["object","string"]'\'''

echo '$ json <<< '\''["object","object"]'\'''
json <<< '["object","object"]' 2>&1 ||
echo 'command failed: json <<< '\''["object","object"]'\'''

echo '$ json <<< '\''["object","array"]'\'''
json <<< '["object","array"]' 2>&1 ||
echo 'command failed: json <<< '\''["object","array"]'\'''

echo '$ json <<< '\''["object","list"]'\'''
json <<< '["object","list"]' 2>&1 ||
echo 'command failed: json <<< '\''["object","list"]'\'''

echo '$ json <<< '\''["object","dict"]'\'''
json <<< '["object","dict"]' 2>&1 ||
echo 'command failed: json <<< '\''["object","dict"]'\'''

echo '$ json <<< '\''["object",{}]'\'''
json <<< '["object",{}]' 2>&1 ||
echo 'command failed: json <<< '\''["object",{}]'\'''

echo '$ json <<< '\''["object",{"foo":"bar"}]'\'''
json <<< '["object",{"foo":"bar"}]' 2>&1 ||
echo 'command failed: json <<< '\''["object",{"foo":"bar"}]'\'''

echo '$ json <<< '\''["object",{"name":"baz","type":"object"}]'\'''
json <<< '["object",{"name":"baz","type":"object"}]' 2>&1 ||
echo 'command failed: json <<< '\''["object",{"name":"baz","type":"object"}]'\'''

echo '$ json <<< '\''["object",[]]'\'''
json <<< '["object",[]]' 2>&1 ||
echo 'command failed: json <<< '\''["object",[]]'\'''

echo '$ json <<< '\''["object",["number","string"]]'\'''
json <<< '["object",["number","string"]]' 2>&1 ||
echo 'command failed: json <<< '\''["object",["number","string"]]'\'''

echo '$ json <<< '\''["array",null]'\'''
json <<< '["array",null]' 2>&1 ||
echo 'command failed: json <<< '\''["array",null]'\'''

echo '$ json <<< '\''["array",false]'\'''
json <<< '["array",false]' 2>&1 ||
echo 'command failed: json <<< '\''["array",false]'\'''

echo '$ json <<< '\''["array",true]'\'''
json <<< '["array",true]' 2>&1 ||
echo 'command failed: json <<< '\''["array",true]'\'''

echo '$ json <<< '\''["array",123]'\'''
json <<< '["array",123]' 2>&1 ||
echo 'command failed: json <<< '\''["array",123]'\'''

echo '$ json <<< '\''["array","foo"]'\'''
json <<< '["array","foo"]' 2>&1 ||
echo 'command failed: json <<< '\''["array","foo"]'\'''

echo '$ json <<< '\''["array","type"]'\'''
json <<< '["array","type"]' 2>&1 ||
echo 'command failed: json <<< '\''["array","type"]'\'''

echo '$ json <<< '\''["array","null"]'\'''
json <<< '["array","null"]' 2>&1 ||
echo 'command failed: json <<< '\''["array","null"]'\'''

echo '$ json <<< '\''["array","boolean"]'\'''
json <<< '["array","boolean"]' 2>&1 ||
echo 'command failed: json <<< '\''["array","boolean"]'\'''

echo '$ json <<< '\''["array","number"]'\'''
json <<< '["array","number"]' 2>&1 ||
echo 'command failed: json <<< '\''["array","number"]'\'''

echo '$ json <<< '\''["array","string"]'\'''
json <<< '["array","string"]' 2>&1 ||
echo 'command failed: json <<< '\''["array","string"]'\'''

echo '$ json <<< '\''["array","object"]'\'''
json <<< '["array","object"]' 2>&1 ||
echo 'command failed: json <<< '\''["array","object"]'\'''

echo '$ json <<< '\''["array","array"]'\'''
json <<< '["array","array"]' 2>&1 ||
echo 'command failed: json <<< '\''["array","array"]'\'''

echo '$ json <<< '\''["array","list"]'\'''
json <<< '["array","list"]' 2>&1 ||
echo 'command failed: json <<< '\''["array","list"]'\'''

echo '$ json <<< '\''["array","dict"]'\'''
json <<< '["array","dict"]' 2>&1 ||
echo 'command failed: json <<< '\''["array","dict"]'\'''

echo '$ json <<< '\''["array",{}]'\'''
json <<< '["array",{}]' 2>&1 ||
echo 'command failed: json <<< '\''["array",{}]'\'''

echo '$ json <<< '\''["array",{"foo":"bar"}]'\'''
json <<< '["array",{"foo":"bar"}]' 2>&1 ||
echo 'command failed: json <<< '\''["array",{"foo":"bar"}]'\'''

echo '$ json <<< '\''["array",{"name":"baz","type":"object"}]'\'''
json <<< '["array",{"name":"baz","type":"object"}]' 2>&1 ||
echo 'command failed: json <<< '\''["array",{"name":"baz","type":"object"}]'\'''

echo '$ json <<< '\''["array",[]]'\'''
json <<< '["array",[]]' 2>&1 ||
echo 'command failed: json <<< '\''["array",[]]'\'''

echo '$ json <<< '\''["array",["number","string"]]'\'''
json <<< '["array",["number","string"]]' 2>&1 ||
echo 'command failed: json <<< '\''["array",["number","string"]]'\'''

echo '$ json <<< '\''[{"plain":null},null]'\'''
json <<< '[{"plain":null},null]' 2>&1 ||
echo 'command failed: json <<< '\''[{"plain":null},null]'\'''

echo '$ json <<< '\''[{"plain":null},false]'\'''
json <<< '[{"plain":null},false]' 2>&1 ||
echo 'command failed: json <<< '\''[{"plain":null},false]'\'''

echo '$ json <<< '\''[{"plain":null},true]'\'''
json <<< '[{"plain":null},true]' 2>&1 ||
echo 'command failed: json <<< '\''[{"plain":null},true]'\'''

echo '$ json <<< '\''[{"plain":null},123]'\'''
json <<< '[{"plain":null},123]' 2>&1 ||
echo 'command failed: json <<< '\''[{"plain":null},123]'\'''

echo '$ json <<< '\''[{"plain":null},"foo"]'\'''
json <<< '[{"plain":null},"foo"]' 2>&1 ||
echo 'command failed: json <<< '\''[{"plain":null},"foo"]'\'''

echo '$ json <<< '\''[{"plain":null},"type"]'\'''
json <<< '[{"plain":null},"type"]' 2>&1 ||
echo 'command failed: json <<< '\''[{"plain":null},"type"]'\'''

echo '$ json <<< '\''[{"plain":null},"null"]'\'''
json <<< '[{"plain":null},"null"]' 2>&1 ||
echo 'command failed: json <<< '\''[{"plain":null},"null"]'\'''

echo '$ json <<< '\''[{"plain":null},"boolean"]'\'''
json <<< '[{"plain":null},"boolean"]' 2>&1 ||
echo 'command failed: json <<< '\''[{"plain":null},"boolean"]'\'''

echo '$ json <<< '\''[{"plain":null},"number"]'\'''
json <<< '[{"plain":null},"number"]' 2>&1 ||
echo 'command failed: json <<< '\''[{"plain":null},"number"]'\'''

echo '$ json <<< '\''[{"plain":null},"string"]'\'''
json <<< '[{"plain":null},"string"]' 2>&1 ||
echo 'command failed: json <<< '\''[{"plain":null},"string"]'\'''

echo '$ json <<< '\''[{"plain":null},"object"]'\'''
json <<< '[{"plain":null},"object"]' 2>&1 ||
echo 'command failed: json <<< '\''[{"plain":null},"object"]'\'''

echo '$ json <<< '\''[{"plain":null},"array"]'\'''
json <<< '[{"plain":null},"array"]' 2>&1 ||
echo 'command failed: json <<< '\''[{"plain":null},"array"]'\'''

echo '$ json <<< '\''[{"plain":null},"list"]'\'''
json <<< '[{"plain":null},"list"]' 2>&1 ||
echo 'command failed: json <<< '\''[{"plain":null},"list"]'\'''

echo '$ json <<< '\''[{"plain":null},"dict"]'\'''
json <<< '[{"plain":null},"dict"]' 2>&1 ||
echo 'command failed: json <<< '\''[{"plain":null},"dict"]'\'''

echo '$ json <<< '\''[{"plain":null},{}]'\'''
json <<< '[{"plain":null},{}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"plain":null},{}]'\'''

echo '$ json <<< '\''[{"plain":null},{"foo":"bar"}]'\'''
json <<< '[{"plain":null},{"foo":"bar"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"plain":null},{"foo":"bar"}]'\'''

echo '$ json <<< '\''[{"plain":null},{"name":"baz","type":"object"}]'\'''
json <<< '[{"plain":null},{"name":"baz","type":"object"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"plain":null},{"name":"baz","type":"object"}]'\'''

echo '$ json <<< '\''[{"plain":null},[]]'\'''
json <<< '[{"plain":null},[]]' 2>&1 ||
echo 'command failed: json <<< '\''[{"plain":null},[]]'\'''

echo '$ json <<< '\''[{"plain":null},["number","string"]]'\'''
json <<< '[{"plain":null},["number","string"]]' 2>&1 ||
echo 'command failed: json <<< '\''[{"plain":null},["number","string"]]'\'''

echo '$ json <<< '\''[{"type":"array","args":"type"},null]'\'''
json <<< '[{"type":"array","args":"type"},null]' 2>&1 ||
echo 'command failed: json <<< '\''[{"type":"array","args":"type"},null]'\'''

echo '$ json <<< '\''[{"type":"array","args":"type"},false]'\'''
json <<< '[{"type":"array","args":"type"},false]' 2>&1 ||
echo 'command failed: json <<< '\''[{"type":"array","args":"type"},false]'\'''

echo '$ json <<< '\''[{"type":"array","args":"type"},true]'\'''
json <<< '[{"type":"array","args":"type"},true]' 2>&1 ||
echo 'command failed: json <<< '\''[{"type":"array","args":"type"},true]'\'''

echo '$ json <<< '\''[{"type":"array","args":"type"},123]'\'''
json <<< '[{"type":"array","args":"type"},123]' 2>&1 ||
echo 'command failed: json <<< '\''[{"type":"array","args":"type"},123]'\'''

echo '$ json <<< '\''[{"type":"array","args":"type"},"foo"]'\'''
json <<< '[{"type":"array","args":"type"},"foo"]' 2>&1 ||
echo 'command failed: json <<< '\''[{"type":"array","args":"type"},"foo"]'\'''

echo '$ json <<< '\''[{"type":"array","args":"type"},"type"]'\'''
json <<< '[{"type":"array","args":"type"},"type"]' 2>&1 ||
echo 'command failed: json <<< '\''[{"type":"array","args":"type"},"type"]'\'''

echo '$ json <<< '\''[{"type":"array","args":"type"},"null"]'\'''
json <<< '[{"type":"array","args":"type"},"null"]' 2>&1 ||
echo 'command failed: json <<< '\''[{"type":"array","args":"type"},"null"]'\'''

echo '$ json <<< '\''[{"type":"array","args":"type"},"boolean"]'\'''
json <<< '[{"type":"array","args":"type"},"boolean"]' 2>&1 ||
echo 'command failed: json <<< '\''[{"type":"array","args":"type"},"boolean"]'\'''

echo '$ json <<< '\''[{"type":"array","args":"type"},"number"]'\'''
json <<< '[{"type":"array","args":"type"},"number"]' 2>&1 ||
echo 'command failed: json <<< '\''[{"type":"array","args":"type"},"number"]'\'''

echo '$ json <<< '\''[{"type":"array","args":"type"},"string"]'\'''
json <<< '[{"type":"array","args":"type"},"string"]' 2>&1 ||
echo 'command failed: json <<< '\''[{"type":"array","args":"type"},"string"]'\'''

echo '$ json <<< '\''[{"type":"array","args":"type"},"object"]'\'''
json <<< '[{"type":"array","args":"type"},"object"]' 2>&1 ||
echo 'command failed: json <<< '\''[{"type":"array","args":"type"},"object"]'\'''

echo '$ json <<< '\''[{"type":"array","args":"type"},"array"]'\'''
json <<< '[{"type":"array","args":"type"},"array"]' 2>&1 ||
echo 'command failed: json <<< '\''[{"type":"array","args":"type"},"array"]'\'''

echo '$ json <<< '\''[{"type":"array","args":"type"},"list"]'\'''
json <<< '[{"type":"array","args":"type"},"list"]' 2>&1 ||
echo 'command failed: json <<< '\''[{"type":"array","args":"type"},"list"]'\'''

echo '$ json <<< '\''[{"type":"array","args":"type"},"dict"]'\'''
json <<< '[{"type":"array","args":"type"},"dict"]' 2>&1 ||
echo 'command failed: json <<< '\''[{"type":"array","args":"type"},"dict"]'\'''

echo '$ json <<< '\''[{"type":"array","args":"type"},{}]'\'''
json <<< '[{"type":"array","args":"type"},{}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"type":"array","args":"type"},{}]'\'''

echo '$ json <<< '\''[{"type":"array","args":"type"},{"foo":"bar"}]'\'''
json <<< '[{"type":"array","args":"type"},{"foo":"bar"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"type":"array","args":"type"},{"foo":"bar"}]'\'''

echo '$ json <<< '\''[{"type":"array","args":"type"},{"name":"baz","type":"object"}]'\'''
json <<< '[{"type":"array","args":"type"},{"name":"baz","type":"object"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"type":"array","args":"type"},{"name":"baz","type":"object"}]'\'''

echo '$ json <<< '\''[{"type":"array","args":"type"},[]]'\'''
json <<< '[{"type":"array","args":"type"},[]]' 2>&1 ||
echo 'command failed: json <<< '\''[{"type":"array","args":"type"},[]]'\'''

echo '$ json <<< '\''[{"type":"array","args":"type"},["number","string"]]'\'''
json <<< '[{"type":"array","args":"type"},["number","string"]]' 2>&1 ||
echo 'command failed: json <<< '\''[{"type":"array","args":"type"},["number","string"]]'\'''

echo '$ json <<< '\''[{"name":"baz","type":"object"},null]'\'''
json <<< '[{"name":"baz","type":"object"},null]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"baz","type":"object"},null]'\'''

echo '$ json <<< '\''[{"name":"baz","type":"object"},false]'\'''
json <<< '[{"name":"baz","type":"object"},false]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"baz","type":"object"},false]'\'''

echo '$ json <<< '\''[{"name":"baz","type":"object"},true]'\'''
json <<< '[{"name":"baz","type":"object"},true]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"baz","type":"object"},true]'\'''

echo '$ json <<< '\''[{"name":"baz","type":"object"},123]'\'''
json <<< '[{"name":"baz","type":"object"},123]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"baz","type":"object"},123]'\'''

echo '$ json <<< '\''[{"name":"baz","type":"object"},"foo"]'\'''
json <<< '[{"name":"baz","type":"object"},"foo"]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"baz","type":"object"},"foo"]'\'''

echo '$ json <<< '\''[{"name":"baz","type":"object"},"type"]'\'''
json <<< '[{"name":"baz","type":"object"},"type"]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"baz","type":"object"},"type"]'\'''

echo '$ json <<< '\''[{"name":"baz","type":"object"},"null"]'\'''
json <<< '[{"name":"baz","type":"object"},"null"]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"baz","type":"object"},"null"]'\'''

echo '$ json <<< '\''[{"name":"baz","type":"object"},"boolean"]'\'''
json <<< '[{"name":"baz","type":"object"},"boolean"]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"baz","type":"object"},"boolean"]'\'''

echo '$ json <<< '\''[{"name":"baz","type":"object"},"number"]'\'''
json <<< '[{"name":"baz","type":"object"},"number"]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"baz","type":"object"},"number"]'\'''

echo '$ json <<< '\''[{"name":"baz","type":"object"},"string"]'\'''
json <<< '[{"name":"baz","type":"object"},"string"]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"baz","type":"object"},"string"]'\'''

echo '$ json <<< '\''[{"name":"baz","type":"object"},"object"]'\'''
json <<< '[{"name":"baz","type":"object"},"object"]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"baz","type":"object"},"object"]'\'''

echo '$ json <<< '\''[{"name":"baz","type":"object"},"array"]'\'''
json <<< '[{"name":"baz","type":"object"},"array"]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"baz","type":"object"},"array"]'\'''

echo '$ json <<< '\''[{"name":"baz","type":"object"},"list"]'\'''
json <<< '[{"name":"baz","type":"object"},"list"]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"baz","type":"object"},"list"]'\'''

echo '$ json <<< '\''[{"name":"baz","type":"object"},"dict"]'\'''
json <<< '[{"name":"baz","type":"object"},"dict"]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"baz","type":"object"},"dict"]'\'''

echo '$ json <<< '\''[{"name":"baz","type":"object"},{}]'\'''
json <<< '[{"name":"baz","type":"object"},{}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"baz","type":"object"},{}]'\'''

echo '$ json <<< '\''[{"name":"baz","type":"object"},{"foo":"bar"}]'\'''
json <<< '[{"name":"baz","type":"object"},{"foo":"bar"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"baz","type":"object"},{"foo":"bar"}]'\'''

echo '$ json <<< '\''[{"name":"baz","type":"object"},{"name":"baz","type":"object"}]'\'''
json <<< '[{"name":"baz","type":"object"},{"name":"baz","type":"object"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"baz","type":"object"},{"name":"baz","type":"object"}]'\'''

echo '$ json <<< '\''[{"name":"baz","type":"object"},[]]'\'''
json <<< '[{"name":"baz","type":"object"},[]]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"baz","type":"object"},[]]'\'''

echo '$ json <<< '\''[{"name":"baz","type":"object"},["number","string"]]'\'''
json <<< '[{"name":"baz","type":"object"},["number","string"]]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"baz","type":"object"},["number","string"]]'\'''
)

