#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-checker:open-array6
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L open-array6.old <(echo \
'$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes
$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }
$ json -d '\''{"type":"array","args":"type"}'\'' <<< '\''[true,null]'\''
[true,null]
$ json -d '\''{"type":"array","args":"type"}'\'' <<< '\''[true,false]'\''
[true,false]
$ json -d '\''{"type":"array","args":"type"}'\'' <<< '\''[true,true]'\''
[true,true]
$ json -d '\''{"type":"array","args":"type"}'\'' <<< '\''[true,123]'\''
[true,123]
$ json -d '\''{"type":"array","args":"type"}'\'' <<< '\''[true,"foo"]'\''
[true,"foo"]
$ json -d '\''{"type":"array","args":"type"}'\'' <<< '\''[true,{}]'\''
[true,{}]
$ json -d '\''{"type":"array","args":"type"}'\'' <<< '\''[true,[]]'\''
[true,[]]
$ json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[true,null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:2: [true,null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[true,null]'\''
$ json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[true,false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:2: [true,false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[true,false]'\''
$ json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[true,true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:2: [true,true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[true,true]'\''
$ json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[true,123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:2: [true,123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[true,123]'\''
$ json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[true,"foo"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:2: [true,"foo"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[true,"foo"]'\''
$ json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[true,{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:2: [true,{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[true,{}]'\''
$ json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[true,[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:2: [true,[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[true,[]]'\''
$ json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[true,null]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:7: [true,null]
json: error: <stdin>:1:7:       ^
[true,
command failed: json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[true,null]'\''
$ json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[true,false]'\''
[true,false]
$ json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[true,true]'\''
[true,true]
$ json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[true,123]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:7: [true,123]
json: error: <stdin>:1:7:       ^
[true,
command failed: json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[true,123]'\''
$ json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[true,"foo"]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:7: [true,"foo"]
json: error: <stdin>:1:7:       ^
[true,
command failed: json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[true,"foo"]'\''
$ json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[true,{}]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:7: [true,{}]
json: error: <stdin>:1:7:       ^
[true,
command failed: json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[true,{}]'\''
$ json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[true,[]]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:7: [true,[]]
json: error: <stdin>:1:7:       ^
[true,
command failed: json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[true,[]]'\''
$ json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[true,null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:2: [true,null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[true,null]'\''
$ json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[true,false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:2: [true,false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[true,false]'\''
$ json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[true,true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:2: [true,true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[true,true]'\''
$ json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[true,123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:2: [true,123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[true,123]'\''
$ json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[true,"foo"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:2: [true,"foo"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[true,"foo"]'\''
$ json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[true,{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:2: [true,{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[true,{}]'\''
$ json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[true,[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:2: [true,[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[true,[]]'\''
$ json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[true,null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:2: [true,null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[true,null]'\''
$ json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[true,false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:2: [true,false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[true,false]'\''
$ json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[true,true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:2: [true,true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[true,true]'\''
$ json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[true,123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:2: [true,123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[true,123]'\''
$ json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[true,"foo"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:2: [true,"foo"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[true,"foo"]'\''
$ json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[true,{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:2: [true,{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[true,{}]'\''
$ json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[true,[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:2: [true,[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[true,[]]'\''
$ json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[true,null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:2: [true,null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[true,null]'\''
$ json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[true,false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:2: [true,false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[true,false]'\''
$ json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[true,true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:2: [true,true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[true,true]'\''
$ json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[true,123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:2: [true,123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[true,123]'\''
$ json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[true,"foo"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:2: [true,"foo"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[true,"foo"]'\''
$ json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[true,{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:2: [true,{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[true,{}]'\''
$ json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[true,[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:2: [true,[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[true,[]]'\''
$ json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[true,null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:2: [true,null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[true,null]'\''
$ json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[true,false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:2: [true,false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[true,false]'\''
$ json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[true,true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:2: [true,true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[true,true]'\''
$ json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[true,123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:2: [true,123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[true,123]'\''
$ json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[true,"foo"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:2: [true,"foo"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[true,"foo"]'\''
$ json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[true,{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:2: [true,{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[true,{}]'\''
$ json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[true,[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:2: [true,[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[true,[]]'\'''
) -L open-array6.new <(
echo '$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'
export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes 2>&1 ||
echo 'command failed: export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'

echo '$ json -d '\''{"type":"array","args":"type"}'\'' <<< '\''[true,null]'\'''
json -d '{"type":"array","args":"type"}' <<< '[true,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"type"}'\'' <<< '\''[true,null]'\'''

echo '$ json -d '\''{"type":"array","args":"type"}'\'' <<< '\''[true,false]'\'''
json -d '{"type":"array","args":"type"}' <<< '[true,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"type"}'\'' <<< '\''[true,false]'\'''

echo '$ json -d '\''{"type":"array","args":"type"}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"array","args":"type"}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"type"}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"array","args":"type"}'\'' <<< '\''[true,123]'\'''
json -d '{"type":"array","args":"type"}' <<< '[true,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"type"}'\'' <<< '\''[true,123]'\'''

echo '$ json -d '\''{"type":"array","args":"type"}'\'' <<< '\''[true,"foo"]'\'''
json -d '{"type":"array","args":"type"}' <<< '[true,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"type"}'\'' <<< '\''[true,"foo"]'\'''

echo '$ json -d '\''{"type":"array","args":"type"}'\'' <<< '\''[true,{}]'\'''
json -d '{"type":"array","args":"type"}' <<< '[true,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"type"}'\'' <<< '\''[true,{}]'\'''

echo '$ json -d '\''{"type":"array","args":"type"}'\'' <<< '\''[true,[]]'\'''
json -d '{"type":"array","args":"type"}' <<< '[true,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"type"}'\'' <<< '\''[true,[]]'\'''

echo '$ json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[true,null]'\'''
json -d '{"type":"array","args":"null"}' <<< '[true,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[true,null]'\'''

echo '$ json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[true,false]'\'''
json -d '{"type":"array","args":"null"}' <<< '[true,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[true,false]'\'''

echo '$ json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"array","args":"null"}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[true,123]'\'''
json -d '{"type":"array","args":"null"}' <<< '[true,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[true,123]'\'''

echo '$ json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[true,"foo"]'\'''
json -d '{"type":"array","args":"null"}' <<< '[true,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[true,"foo"]'\'''

echo '$ json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[true,{}]'\'''
json -d '{"type":"array","args":"null"}' <<< '[true,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[true,{}]'\'''

echo '$ json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[true,[]]'\'''
json -d '{"type":"array","args":"null"}' <<< '[true,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[true,[]]'\'''

echo '$ json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[true,null]'\'''
json -d '{"type":"array","args":"boolean"}' <<< '[true,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[true,null]'\'''

echo '$ json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[true,false]'\'''
json -d '{"type":"array","args":"boolean"}' <<< '[true,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[true,false]'\'''

echo '$ json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"array","args":"boolean"}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[true,123]'\'''
json -d '{"type":"array","args":"boolean"}' <<< '[true,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[true,123]'\'''

echo '$ json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[true,"foo"]'\'''
json -d '{"type":"array","args":"boolean"}' <<< '[true,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[true,"foo"]'\'''

echo '$ json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[true,{}]'\'''
json -d '{"type":"array","args":"boolean"}' <<< '[true,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[true,{}]'\'''

echo '$ json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[true,[]]'\'''
json -d '{"type":"array","args":"boolean"}' <<< '[true,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[true,[]]'\'''

echo '$ json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[true,null]'\'''
json -d '{"type":"array","args":"number"}' <<< '[true,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[true,null]'\'''

echo '$ json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[true,false]'\'''
json -d '{"type":"array","args":"number"}' <<< '[true,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[true,false]'\'''

echo '$ json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"array","args":"number"}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[true,123]'\'''
json -d '{"type":"array","args":"number"}' <<< '[true,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[true,123]'\'''

echo '$ json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[true,"foo"]'\'''
json -d '{"type":"array","args":"number"}' <<< '[true,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[true,"foo"]'\'''

echo '$ json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[true,{}]'\'''
json -d '{"type":"array","args":"number"}' <<< '[true,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[true,{}]'\'''

echo '$ json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[true,[]]'\'''
json -d '{"type":"array","args":"number"}' <<< '[true,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[true,[]]'\'''

echo '$ json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[true,null]'\'''
json -d '{"type":"array","args":"string"}' <<< '[true,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[true,null]'\'''

echo '$ json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[true,false]'\'''
json -d '{"type":"array","args":"string"}' <<< '[true,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[true,false]'\'''

echo '$ json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"array","args":"string"}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[true,123]'\'''
json -d '{"type":"array","args":"string"}' <<< '[true,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[true,123]'\'''

echo '$ json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[true,"foo"]'\'''
json -d '{"type":"array","args":"string"}' <<< '[true,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[true,"foo"]'\'''

echo '$ json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[true,{}]'\'''
json -d '{"type":"array","args":"string"}' <<< '[true,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[true,{}]'\'''

echo '$ json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[true,[]]'\'''
json -d '{"type":"array","args":"string"}' <<< '[true,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[true,[]]'\'''

echo '$ json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[true,null]'\'''
json -d '{"type":"array","args":"object"}' <<< '[true,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[true,null]'\'''

echo '$ json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[true,false]'\'''
json -d '{"type":"array","args":"object"}' <<< '[true,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[true,false]'\'''

echo '$ json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"array","args":"object"}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[true,123]'\'''
json -d '{"type":"array","args":"object"}' <<< '[true,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[true,123]'\'''

echo '$ json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[true,"foo"]'\'''
json -d '{"type":"array","args":"object"}' <<< '[true,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[true,"foo"]'\'''

echo '$ json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[true,{}]'\'''
json -d '{"type":"array","args":"object"}' <<< '[true,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[true,{}]'\'''

echo '$ json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[true,[]]'\'''
json -d '{"type":"array","args":"object"}' <<< '[true,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[true,[]]'\'''

echo '$ json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[true,null]'\'''
json -d '{"type":"array","args":"array"}' <<< '[true,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[true,null]'\'''

echo '$ json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[true,false]'\'''
json -d '{"type":"array","args":"array"}' <<< '[true,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[true,false]'\'''

echo '$ json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"array","args":"array"}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[true,123]'\'''
json -d '{"type":"array","args":"array"}' <<< '[true,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[true,123]'\'''

echo '$ json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[true,"foo"]'\'''
json -d '{"type":"array","args":"array"}' <<< '[true,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[true,"foo"]'\'''

echo '$ json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[true,{}]'\'''
json -d '{"type":"array","args":"array"}' <<< '[true,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[true,{}]'\'''

echo '$ json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[true,[]]'\'''
json -d '{"type":"array","args":"array"}' <<< '[true,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[true,[]]'\'''
)

