#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-checker-list:list-object-plain-basic-val-object-basic-basic
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L list-object-plain-basic-val-object-basic-basic.old <(echo \
'$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes
$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":true,"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":true,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":true,"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":true,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":true,"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":true,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":true,"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":true,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":true,"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":true,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":true,"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":true,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":true,"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":true,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":true,"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":true,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":true,"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":true,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":true,"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":true,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":true,"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":true,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":true,"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":true,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":true,"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":true,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":true,"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":true,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":true,"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":true,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":true,"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":true,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":true,"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":true,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":true,"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":true,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":true,"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":true,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":true,"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":true,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":true,"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":true,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":true,"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":true,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":true,"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":true,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":true,"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":true,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":true,"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":true,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":true,"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":true,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":true,"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":true,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":true,"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":true,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":true,"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":true,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":true,"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":true,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":true,"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":true,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":true,"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":true,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":true,"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":true,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":true,"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":true,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":true,"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":true,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":true,"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":true,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":true,"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":true,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":true,"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":true,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":true,"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":true,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":true,"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":true,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":true,"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":true,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":true,"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":true,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":true,"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":true,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":true,"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":true,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":true,"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":true,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":true,"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":true,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":true,"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":true,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":true,"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":true,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":true,"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":true,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":true,"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":true,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":true,"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":true,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":true,"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":true,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":true,"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":true,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":true,"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":true,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":true,"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":true,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":true,"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":true,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":true,"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":true,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":true,"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":true,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":true,"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":true,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":true,"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":true,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":true,"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":true,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":true,"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":true,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":true,"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":true,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":123,"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":123,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":123,"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":123,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":123,"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":123,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":123,"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":123,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":123,"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":123,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":123,"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":123,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":123,"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":123,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":123,"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":123,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":123,"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":123,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":123,"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":123,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":123,"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":123,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":123,"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":123,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":123,"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":123,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":123,"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":123,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":123,"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":123,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":123,"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":123,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":123,"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":123,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":123,"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":123,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":123,"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":123,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":123,"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":123,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":123,"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":123,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":123,"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":123,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":123,"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":123,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":123,"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":123,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":123,"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":123,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":123,"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":123,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":123,"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":123,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":123,"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":123,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":123,"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":123,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":123,"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":123,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":123,"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":123,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":123,"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":123,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":123,"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":123,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":123,"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":123,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":123,"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":123,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":123,"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":123,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":123,"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":123,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":123,"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":123,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":123,"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":123,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":123,"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":123,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":123,"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":123,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":123,"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":123,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":123,"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":123,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":123,"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":123,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":123,"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":123,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":123,"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":123,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":123,"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":123,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":123,"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":123,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":123,"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":123,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":123,"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":123,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":123,"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":123,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":123,"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":123,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":123,"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":123,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":123,"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":123,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":123,"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":123,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":123,"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":123,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":123,"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":123,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":123,"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":123,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":123,"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":123,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":123,"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":123,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":123,"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":123,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":123,"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":123,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":123,"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":123,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":"foo","baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":"foo","baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":"foo","baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":"foo","baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":"foo","baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":"foo","baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":"foo","baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":"foo","baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":"foo","baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":"foo","baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":"foo","baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":"foo","baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":"foo","baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":"foo","baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":"foo","baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":"foo","baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":"foo","baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":"foo","baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":"foo","baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":"foo","baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":"foo","baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":"foo","baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":"foo","baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":"foo","baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":"foo","baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":"foo","baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":"foo","baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":"foo","baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":"foo","baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":"foo","baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":"foo","baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":"foo","baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":"foo","baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":"foo","baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":"foo","baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":"foo","baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":"foo","baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":"foo","baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":"foo","baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":"foo","baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":"foo","baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":"foo","baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":"foo","baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":"foo","baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":"foo","baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":"foo","baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":"foo","baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":"foo","baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":"foo","baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":"foo","baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":"foo","baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":"foo","baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":"foo","baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":"foo","baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":"foo","baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":"foo","baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":"foo","baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":"foo","baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":"foo","baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":"foo","baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":"foo","baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":"foo","baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":"foo","baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":"foo","baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":"foo","baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":"foo","baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":"foo","baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":"foo","baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":"foo","baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":"foo","baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":"foo","baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":"foo","baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":"foo","baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":"foo","baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":"foo","baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":"foo","baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":"foo","baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":"foo","baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":"foo","baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":"foo","baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":"foo","baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":"foo","baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":"foo","baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":"foo","baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":"foo","baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":"foo","baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":"foo","baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":"foo","baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":"foo","baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":"foo","baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":"foo","baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":"foo","baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":"foo","baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":"foo","baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":"foo","baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":"foo","baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":"foo","baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":"foo","baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":"foo","baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":"foo","baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":"foo","baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":"foo","baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":"foo","baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":"foo","baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":"foo","baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":"foo","baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":"foo","baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":"foo","baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":"foo","baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":"foo","baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":"foo","baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":"foo","baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":"foo","baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":"foo","baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":"foo","baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":"foo","baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":"foo","baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":"foo","baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":"foo","baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":"foo","baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":"foo","baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":"foo","baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":"foo","baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":"foo","baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":"foo","baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":"foo","baa":[]}'\'''
) -L list-object-plain-basic-val-object-basic-basic.new <(
echo '$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'
export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes 2>&1 ||
echo 'command failed: export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}' <<< '{"fuu":null,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}' <<< '{"fuu":null,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}' <<< '{"fuu":null,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}' <<< '{"fuu":null,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}' <<< '{"fuu":null,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}' <<< '{"fuu":null,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}' <<< '{"fuu":null,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}' <<< '{"fuu":null,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}' <<< '{"fuu":null,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}' <<< '{"fuu":null,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}' <<< '{"fuu":null,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}' <<< '{"fuu":null,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}' <<< '{"fuu":null,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}' <<< '{"fuu":null,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}' <<< '{"fuu":null,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}' <<< '{"fuu":null,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}' <<< '{"fuu":null,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}' <<< '{"fuu":null,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}' <<< '{"fuu":null,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}' <<< '{"fuu":null,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}' <<< '{"fuu":null,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}' <<< '{"fuu":null,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}' <<< '{"fuu":null,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}' <<< '{"fuu":null,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}' <<< '{"fuu":null,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}' <<< '{"fuu":null,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}' <<< '{"fuu":null,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}' <<< '{"fuu":null,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}' <<< '{"fuu":null,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}' <<< '{"fuu":null,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}' <<< '{"fuu":null,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}' <<< '{"fuu":null,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}' <<< '{"fuu":null,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}' <<< '{"fuu":null,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}' <<< '{"fuu":null,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}' <<< '{"fuu":null,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}' <<< '{"fuu":null,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}' <<< '{"fuu":null,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}' <<< '{"fuu":null,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}' <<< '{"fuu":null,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}' <<< '{"fuu":null,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}' <<< '{"fuu":null,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}' <<< '{"fuu":null,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}' <<< '{"fuu":null,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}' <<< '{"fuu":null,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}' <<< '{"fuu":null,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}' <<< '{"fuu":null,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}' <<< '{"fuu":null,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}' <<< '{"fuu":null,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}' <<< '{"fuu":null,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}' <<< '{"fuu":null,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}' <<< '{"fuu":null,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}' <<< '{"fuu":null,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}' <<< '{"fuu":null,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}' <<< '{"fuu":null,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}' <<< '{"fuu":null,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}' <<< '{"fuu":null,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}' <<< '{"fuu":null,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}' <<< '{"fuu":null,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}' <<< '{"fuu":null,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}' <<< '{"fuu":null,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}' <<< '{"fuu":null,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}' <<< '{"fuu":null,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}' <<< '{"fuu":false,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}' <<< '{"fuu":false,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}' <<< '{"fuu":false,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}' <<< '{"fuu":false,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}' <<< '{"fuu":false,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}' <<< '{"fuu":false,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}' <<< '{"fuu":false,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}' <<< '{"fuu":false,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}' <<< '{"fuu":false,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}' <<< '{"fuu":false,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}' <<< '{"fuu":false,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}' <<< '{"fuu":false,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}' <<< '{"fuu":false,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}' <<< '{"fuu":false,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}' <<< '{"fuu":false,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}' <<< '{"fuu":false,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}' <<< '{"fuu":false,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}' <<< '{"fuu":false,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}' <<< '{"fuu":false,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}' <<< '{"fuu":false,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}' <<< '{"fuu":false,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}' <<< '{"fuu":false,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}' <<< '{"fuu":false,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}' <<< '{"fuu":false,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}' <<< '{"fuu":false,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}' <<< '{"fuu":false,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}' <<< '{"fuu":false,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}' <<< '{"fuu":false,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}' <<< '{"fuu":false,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}' <<< '{"fuu":false,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}' <<< '{"fuu":false,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}' <<< '{"fuu":false,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}' <<< '{"fuu":false,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}' <<< '{"fuu":false,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}' <<< '{"fuu":false,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}' <<< '{"fuu":false,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}' <<< '{"fuu":false,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}' <<< '{"fuu":false,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}' <<< '{"fuu":false,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}' <<< '{"fuu":false,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}' <<< '{"fuu":false,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}' <<< '{"fuu":false,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}' <<< '{"fuu":false,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}' <<< '{"fuu":false,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}' <<< '{"fuu":false,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}' <<< '{"fuu":false,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}' <<< '{"fuu":false,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}' <<< '{"fuu":false,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}' <<< '{"fuu":false,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}' <<< '{"fuu":false,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}' <<< '{"fuu":false,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}' <<< '{"fuu":false,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}' <<< '{"fuu":false,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}' <<< '{"fuu":false,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}' <<< '{"fuu":false,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}' <<< '{"fuu":false,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}' <<< '{"fuu":false,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}' <<< '{"fuu":false,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}' <<< '{"fuu":false,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}' <<< '{"fuu":false,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}' <<< '{"fuu":false,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}' <<< '{"fuu":false,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}' <<< '{"fuu":false,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":true,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}' <<< '{"fuu":true,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":true,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":true,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}' <<< '{"fuu":true,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":true,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":true,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}' <<< '{"fuu":true,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":true,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":true,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}' <<< '{"fuu":true,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":true,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":true,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}' <<< '{"fuu":true,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":true,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":true,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}' <<< '{"fuu":true,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":true,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":true,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}' <<< '{"fuu":true,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":true,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":true,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}' <<< '{"fuu":true,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":true,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":true,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}' <<< '{"fuu":true,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":true,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":true,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}' <<< '{"fuu":true,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":true,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":true,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}' <<< '{"fuu":true,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":true,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":true,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}' <<< '{"fuu":true,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":true,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":true,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}' <<< '{"fuu":true,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":true,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":true,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}' <<< '{"fuu":true,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":true,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":true,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}' <<< '{"fuu":true,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":true,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":true,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}' <<< '{"fuu":true,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":true,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":true,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}' <<< '{"fuu":true,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":true,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":true,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}' <<< '{"fuu":true,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":true,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":true,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}' <<< '{"fuu":true,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":true,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":true,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}' <<< '{"fuu":true,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":true,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":true,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}' <<< '{"fuu":true,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":true,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":true,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}' <<< '{"fuu":true,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":true,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":true,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}' <<< '{"fuu":true,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":true,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":true,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}' <<< '{"fuu":true,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":true,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":true,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}' <<< '{"fuu":true,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":true,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":true,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}' <<< '{"fuu":true,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":true,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":true,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}' <<< '{"fuu":true,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":true,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":true,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}' <<< '{"fuu":true,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":true,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":true,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}' <<< '{"fuu":true,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":true,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":true,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}' <<< '{"fuu":true,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":true,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":true,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}' <<< '{"fuu":true,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":true,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":true,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}' <<< '{"fuu":true,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":true,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":true,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}' <<< '{"fuu":true,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":true,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":true,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}' <<< '{"fuu":true,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":true,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":true,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}' <<< '{"fuu":true,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":true,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":true,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}' <<< '{"fuu":true,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":true,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":true,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}' <<< '{"fuu":true,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":true,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":true,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}' <<< '{"fuu":true,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":true,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":true,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}' <<< '{"fuu":true,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":true,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":true,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}' <<< '{"fuu":true,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":true,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":true,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}' <<< '{"fuu":true,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":true,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":true,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}' <<< '{"fuu":true,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":true,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":true,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}' <<< '{"fuu":true,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":true,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":true,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}' <<< '{"fuu":true,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":true,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":true,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}' <<< '{"fuu":true,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":true,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":true,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}' <<< '{"fuu":true,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":true,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":true,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}' <<< '{"fuu":true,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":true,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":true,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}' <<< '{"fuu":true,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":true,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":true,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}' <<< '{"fuu":true,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":true,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":true,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}' <<< '{"fuu":true,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":true,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":true,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}' <<< '{"fuu":true,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":true,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":true,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}' <<< '{"fuu":true,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":true,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":true,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}' <<< '{"fuu":true,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":true,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":true,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}' <<< '{"fuu":true,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":true,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":true,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}' <<< '{"fuu":true,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":true,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":true,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}' <<< '{"fuu":true,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":true,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":true,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}' <<< '{"fuu":true,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":true,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":true,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}' <<< '{"fuu":true,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":true,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":true,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}' <<< '{"fuu":true,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":true,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":true,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}' <<< '{"fuu":true,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":true,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":true,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}' <<< '{"fuu":true,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":true,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":true,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}' <<< '{"fuu":true,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":true,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":true,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}' <<< '{"fuu":true,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":true,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":123,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}' <<< '{"fuu":123,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":123,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":123,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}' <<< '{"fuu":123,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":123,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":123,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}' <<< '{"fuu":123,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":123,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":123,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}' <<< '{"fuu":123,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":123,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":123,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}' <<< '{"fuu":123,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":123,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":123,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}' <<< '{"fuu":123,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":123,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":123,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}' <<< '{"fuu":123,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":123,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":123,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}' <<< '{"fuu":123,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":123,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":123,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}' <<< '{"fuu":123,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":123,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":123,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}' <<< '{"fuu":123,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":123,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":123,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}' <<< '{"fuu":123,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":123,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":123,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}' <<< '{"fuu":123,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":123,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":123,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}' <<< '{"fuu":123,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":123,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":123,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}' <<< '{"fuu":123,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":123,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":123,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}' <<< '{"fuu":123,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":123,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":123,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}' <<< '{"fuu":123,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":123,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":123,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}' <<< '{"fuu":123,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":123,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":123,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}' <<< '{"fuu":123,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":123,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":123,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}' <<< '{"fuu":123,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":123,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":123,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}' <<< '{"fuu":123,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":123,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":123,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}' <<< '{"fuu":123,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":123,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":123,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}' <<< '{"fuu":123,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":123,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":123,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}' <<< '{"fuu":123,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":123,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":123,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}' <<< '{"fuu":123,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":123,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":123,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}' <<< '{"fuu":123,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":123,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":123,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}' <<< '{"fuu":123,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":123,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":123,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}' <<< '{"fuu":123,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":123,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":123,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}' <<< '{"fuu":123,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":123,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":123,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}' <<< '{"fuu":123,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":123,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":123,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}' <<< '{"fuu":123,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":123,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":123,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}' <<< '{"fuu":123,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":123,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":123,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}' <<< '{"fuu":123,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":123,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":123,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}' <<< '{"fuu":123,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":123,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":123,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}' <<< '{"fuu":123,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":123,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":123,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}' <<< '{"fuu":123,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":123,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":123,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}' <<< '{"fuu":123,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":123,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":123,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}' <<< '{"fuu":123,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":123,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":123,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}' <<< '{"fuu":123,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":123,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":123,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}' <<< '{"fuu":123,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":123,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":123,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}' <<< '{"fuu":123,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":123,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":123,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}' <<< '{"fuu":123,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":123,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":123,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}' <<< '{"fuu":123,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":123,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":123,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}' <<< '{"fuu":123,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":123,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":123,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}' <<< '{"fuu":123,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":123,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":123,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}' <<< '{"fuu":123,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":123,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":123,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}' <<< '{"fuu":123,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":123,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":123,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}' <<< '{"fuu":123,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":123,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":123,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}' <<< '{"fuu":123,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":123,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":123,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}' <<< '{"fuu":123,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":123,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":123,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}' <<< '{"fuu":123,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":123,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":123,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}' <<< '{"fuu":123,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":123,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":123,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}' <<< '{"fuu":123,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":123,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":123,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}' <<< '{"fuu":123,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":123,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":123,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}' <<< '{"fuu":123,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":123,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":123,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}' <<< '{"fuu":123,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":123,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":123,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}' <<< '{"fuu":123,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":123,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":123,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}' <<< '{"fuu":123,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":123,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":123,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}' <<< '{"fuu":123,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":123,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":123,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}' <<< '{"fuu":123,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":123,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":123,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}' <<< '{"fuu":123,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":123,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":123,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}' <<< '{"fuu":123,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":123,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":123,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}' <<< '{"fuu":123,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":123,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":123,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}' <<< '{"fuu":123,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":123,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":"foo","baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}' <<< '{"fuu":"foo","baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":"foo","baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":"foo","baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}' <<< '{"fuu":"foo","baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":"foo","baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":"foo","baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}' <<< '{"fuu":"foo","baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":"foo","baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":"foo","baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}' <<< '{"fuu":"foo","baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":"foo","baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":"foo","baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}' <<< '{"fuu":"foo","baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":"foo","baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":"foo","baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}' <<< '{"fuu":"foo","baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":"foo","baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":"foo","baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}' <<< '{"fuu":"foo","baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":"foo","baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":"foo","baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}' <<< '{"fuu":"foo","baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":"foo","baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":"foo","baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}' <<< '{"fuu":"foo","baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":"foo","baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":"foo","baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}' <<< '{"fuu":"foo","baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":"foo","baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":"foo","baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}' <<< '{"fuu":"foo","baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":"foo","baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":"foo","baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}' <<< '{"fuu":"foo","baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":"foo","baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":"foo","baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}' <<< '{"fuu":"foo","baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":"foo","baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":"foo","baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}' <<< '{"fuu":"foo","baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":"foo","baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":"foo","baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}' <<< '{"fuu":"foo","baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":"foo","baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":"foo","baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}' <<< '{"fuu":"foo","baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":"foo","baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":"foo","baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}' <<< '{"fuu":"foo","baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":"foo","baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":"foo","baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}' <<< '{"fuu":"foo","baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":"foo","baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":"foo","baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}' <<< '{"fuu":"foo","baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":"foo","baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":"foo","baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}' <<< '{"fuu":"foo","baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":"foo","baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":"foo","baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}' <<< '{"fuu":"foo","baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":"foo","baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":"foo","baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}' <<< '{"fuu":"foo","baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":"foo","baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":"foo","baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}' <<< '{"fuu":"foo","baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":"foo","baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":"foo","baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}' <<< '{"fuu":"foo","baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":"foo","baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":"foo","baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}' <<< '{"fuu":"foo","baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":"foo","baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":"foo","baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}' <<< '{"fuu":"foo","baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":"foo","baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":"foo","baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}' <<< '{"fuu":"foo","baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":"foo","baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":"foo","baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}' <<< '{"fuu":"foo","baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":"foo","baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":"foo","baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}' <<< '{"fuu":"foo","baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":"foo","baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":"foo","baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}' <<< '{"fuu":"foo","baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":"foo","baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":"foo","baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}' <<< '{"fuu":"foo","baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":"foo","baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":"foo","baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}' <<< '{"fuu":"foo","baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":"foo","baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":"foo","baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}' <<< '{"fuu":"foo","baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":"foo","baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":"foo","baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}' <<< '{"fuu":"foo","baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":"foo","baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":"foo","baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}' <<< '{"fuu":"foo","baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":"foo","baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":"foo","baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}' <<< '{"fuu":"foo","baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":"foo","baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":"foo","baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}' <<< '{"fuu":"foo","baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":"foo","baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":"foo","baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}' <<< '{"fuu":"foo","baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":"foo","baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":"foo","baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}' <<< '{"fuu":"foo","baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":"foo","baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":"foo","baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}' <<< '{"fuu":"foo","baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":"foo","baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":"foo","baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}' <<< '{"fuu":"foo","baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":"foo","baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":"foo","baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}' <<< '{"fuu":"foo","baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":"foo","baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":"foo","baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}' <<< '{"fuu":"foo","baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":"foo","baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":"foo","baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}' <<< '{"fuu":"foo","baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":"foo","baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":"foo","baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}' <<< '{"fuu":"foo","baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":"foo","baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":"foo","baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}' <<< '{"fuu":"foo","baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":"foo","baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":"foo","baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}' <<< '{"fuu":"foo","baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":"foo","baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":"foo","baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}' <<< '{"fuu":"foo","baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":"foo","baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":"foo","baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}' <<< '{"fuu":"foo","baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":"foo","baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":"foo","baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}' <<< '{"fuu":"foo","baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":"foo","baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":"foo","baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}' <<< '{"fuu":"foo","baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":"foo","baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":"foo","baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}' <<< '{"fuu":"foo","baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":"foo","baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":"foo","baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}' <<< '{"fuu":"foo","baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":"foo","baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":"foo","baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}' <<< '{"fuu":"foo","baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":"foo","baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":"foo","baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}' <<< '{"fuu":"foo","baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":"foo","baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":"foo","baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}' <<< '{"fuu":"foo","baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":"foo","baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":"foo","baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}' <<< '{"fuu":"foo","baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":"foo","baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":"foo","baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}' <<< '{"fuu":"foo","baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":"foo","baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":"foo","baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}' <<< '{"fuu":"foo","baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":"foo","baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":"foo","baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}' <<< '{"fuu":"foo","baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":"foo","baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":"foo","baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}' <<< '{"fuu":"foo","baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":"foo","baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":"foo","baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}' <<< '{"fuu":"foo","baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":"foo","baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":"foo","baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}' <<< '{"fuu":"foo","baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":"foo","baa":[]}'\'''
)

