#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-checker-list:list-object-foo-basic-object-bar-basic-val-object-bar-basic
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L list-object-foo-basic-object-bar-basic-val-object-bar-basic.old <(echo \
'$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes
$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null}'\''
{"bar":null}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"bar":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"bar":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"bar":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"bar":"baz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"bar":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"bar":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"bar":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false}'\''
{"bar":false}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":true}'\''
{"bar":true}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"bar":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"bar":"baz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"bar":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"bar":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"bar":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"bar":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"bar":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":123}'\''
{"bar":123}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"bar":"baz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"bar":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"bar":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"bar":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"bar":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"bar":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"bar":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz"}'\''
{"bar":"baz"}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"bar":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"bar":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"bar":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"bar":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"bar":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"bar":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"bar":"baz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{}}'\''
{"bar":{}}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"bar":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"bar":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"bar":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"bar":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"bar":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"bar":"baz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"bar":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[]}'\''
{"bar":[]}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":null}'\''
{"bar":null}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":false}'\''
{"bar":false}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":true}'\''
{"bar":true}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":123}'\''
{"bar":123}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":"baz"}'\''
{"bar":"baz"}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":{}}'\''
{"bar":{}}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[]}'\''
{"bar":[]}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"bar":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false}'\''
{"bar":false}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":true}'\''
{"bar":true}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"bar":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"bar":"baz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"bar":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"bar":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"bar":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"bar":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"bar":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":123}'\''
{"bar":123}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"bar":"baz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"bar":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"bar":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"bar":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"bar":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"bar":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"bar":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz"}'\''
{"bar":"baz"}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"bar":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"bar":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"bar":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"bar":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"bar":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"bar":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"bar":"baz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{}}'\''
{"bar":{}}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"bar":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"bar":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"bar":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"bar":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"bar":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"bar":"baz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"bar":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[]}'\''
{"bar":[]}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":null}'\''
{"bar":null}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":false}'\''
{"bar":false}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":true}'\''
{"bar":true}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":123}'\''
{"bar":123}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":"baz"}'\''
{"bar":"baz"}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":{}}'\''
{"bar":{}}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[]}'\''
{"bar":[]}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null}'\''
{"bar":null}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"bar":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"bar":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"bar":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"bar":"baz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"bar":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"bar":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"bar":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"bar":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"bar":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":123}'\''
{"bar":123}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"bar":"baz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"bar":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"bar":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"bar":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"bar":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"bar":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"bar":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz"}'\''
{"bar":"baz"}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"bar":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"bar":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"bar":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"bar":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"bar":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"bar":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"bar":"baz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{}}'\''
{"bar":{}}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"bar":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"bar":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"bar":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"bar":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"bar":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"bar":"baz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"bar":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[]}'\''
{"bar":[]}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":null}'\''
{"bar":null}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":false}'\''
{"bar":false}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":true}'\''
{"bar":true}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":123}'\''
{"bar":123}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":"baz"}'\''
{"bar":"baz"}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":{}}'\''
{"bar":{}}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[]}'\''
{"bar":[]}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null}'\''
{"bar":null}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"bar":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"bar":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"bar":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"bar":"baz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"bar":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"bar":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"bar":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false}'\''
{"bar":false}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":true}'\''
{"bar":true}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"bar":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"bar":"baz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"bar":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"bar":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"bar":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"bar":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"bar":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"bar":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz"}'\''
{"bar":"baz"}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"bar":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"bar":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"bar":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"bar":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"bar":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"bar":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"bar":"baz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{}}'\''
{"bar":{}}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"bar":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"bar":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"bar":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"bar":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"bar":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"bar":"baz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"bar":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[]}'\''
{"bar":[]}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":null}'\''
{"bar":null}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":false}'\''
{"bar":false}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":true}'\''
{"bar":true}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":123}'\''
{"bar":123}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":"baz"}'\''
{"bar":"baz"}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":{}}'\''
{"bar":{}}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[]}'\''
{"bar":[]}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null}'\''
{"bar":null}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"bar":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"bar":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"bar":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"bar":"baz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"bar":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"bar":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"bar":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false}'\''
{"bar":false}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":true}'\''
{"bar":true}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"bar":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"bar":"baz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"bar":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"bar":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"bar":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"bar":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"bar":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":123}'\''
{"bar":123}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"bar":"baz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"bar":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"bar":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"bar":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"bar":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"bar":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"bar":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"bar":"baz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{}}'\''
{"bar":{}}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"bar":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"bar":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"bar":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"bar":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"bar":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"bar":"baz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"bar":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[]}'\''
{"bar":[]}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":null}'\''
{"bar":null}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":false}'\''
{"bar":false}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":true}'\''
{"bar":true}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":123}'\''
{"bar":123}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":"baz"}'\''
{"bar":"baz"}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":{}}'\''
{"bar":{}}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[]}'\''
{"bar":[]}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null}'\''
{"bar":null}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"bar":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"bar":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"bar":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"bar":"baz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"bar":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"bar":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"bar":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false}'\''
{"bar":false}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":true}'\''
{"bar":true}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"bar":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"bar":"baz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"bar":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"bar":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"bar":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"bar":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"bar":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":123}'\''
{"bar":123}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"bar":"baz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"bar":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"bar":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"bar":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"bar":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"bar":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"bar":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz"}'\''
{"bar":"baz"}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"bar":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"bar":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"bar":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"bar":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"bar":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"bar":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"bar":"baz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"bar":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[]}'\''
{"bar":[]}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":null}'\''
{"bar":null}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":false}'\''
{"bar":false}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":true}'\''
{"bar":true}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":123}'\''
{"bar":123}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":"baz"}'\''
{"bar":"baz"}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":{}}'\''
{"bar":{}}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[]}'\''
{"bar":[]}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null}'\''
{"bar":null}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"bar":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"bar":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"bar":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"bar":"baz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"bar":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"bar":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"bar":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false}'\''
{"bar":false}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":true}'\''
{"bar":true}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"bar":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"bar":"baz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"bar":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"bar":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"bar":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"bar":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"bar":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":123}'\''
{"bar":123}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"bar":"baz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"bar":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"bar":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"bar":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"bar":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"bar":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"bar":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz"}'\''
{"bar":"baz"}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"bar":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"bar":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"bar":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"bar":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"bar":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"bar":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"bar":"baz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{}}'\''
{"bar":{}}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"bar":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":[]}'\'''
) -L list-object-foo-basic-object-bar-basic-val-object-bar-basic.new <(
echo '$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'
export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes 2>&1 ||
echo 'command failed: export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"bar":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"bar":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"bar":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"bar":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"bar":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"bar":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"bar":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"bar":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"bar":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"bar":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"bar":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"bar":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"bar":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"bar":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"bar":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"bar":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"bar":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"bar":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"bar":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"bar":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"bar":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"bar":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"bar":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"bar":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"bar":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"bar":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"bar":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"bar":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"bar":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"bar":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"bar":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"bar":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"bar":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"bar":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"bar":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"bar":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"bar":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"bar":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"bar":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"bar":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"bar":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"bar":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"bar":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"bar":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"bar":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"bar":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"bar":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"bar":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"bar":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"bar":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"bar":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"bar":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"bar":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"bar":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"bar":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"bar":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"bar":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"bar":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"bar":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"bar":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"bar":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"bar":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"bar":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"bar":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"bar":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"bar":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"bar":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"bar":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"bar":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"bar":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"bar":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"bar":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"bar":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"bar":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"bar":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"bar":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"bar":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"bar":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"bar":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"bar":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"bar":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"bar":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"bar":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"bar":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"bar":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"bar":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"bar":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"bar":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"bar":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"bar":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"bar":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"bar":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"bar":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"bar":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"bar":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"bar":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"bar":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"bar":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"bar":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"bar":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"bar":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"bar":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"bar":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"bar":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"bar":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"bar":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"bar":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"bar":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"bar":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"bar":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"bar":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"bar":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"bar":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"bar":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"bar":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"bar":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"bar":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"bar":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"bar":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"bar":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"bar":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"bar":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"bar":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"bar":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"bar":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"bar":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"bar":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"bar":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"bar":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"bar":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"bar":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"bar":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"bar":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"bar":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"bar":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"bar":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"bar":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"bar":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"bar":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"bar":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"bar":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"bar":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"bar":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"bar":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"bar":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"bar":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"bar":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"bar":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"bar":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"bar":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"bar":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"bar":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"bar":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"bar":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"bar":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"bar":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"bar":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"bar":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"bar":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"bar":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"bar":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"bar":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"bar":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"bar":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"bar":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"bar":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"bar":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"bar":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"bar":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"bar":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"bar":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"bar":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"bar":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"bar":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"bar":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"bar":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"bar":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"bar":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"bar":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"bar":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"bar":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"bar":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"bar":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"bar":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"bar":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"bar":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"bar":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"bar":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"bar":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"bar":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"bar":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"bar":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"bar":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"bar":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"bar":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"bar":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"bar":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"bar":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"bar":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"bar":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"bar":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"bar":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"bar":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"bar":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"bar":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"bar":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"bar":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"bar":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"bar":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"bar":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"bar":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"bar":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"bar":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"bar":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"bar":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"bar":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"bar":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"bar":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"bar":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"bar":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"bar":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"bar":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"bar":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"bar":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"bar":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"bar":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"bar":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"bar":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"bar":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"bar":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"bar":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"bar":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"bar":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"bar":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"bar":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"bar":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"bar":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"bar":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"bar":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"bar":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"bar":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"bar":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"bar":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"bar":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"bar":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"bar":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"bar":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"bar":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"bar":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"bar":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"bar":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"bar":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":[]}'\'''
)

