#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C trie:base
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L base.old <(echo \
'$ test -x ../lib/test-trie
$ print() { printf '\''%s\n'\'' "$@"; }
$ set -o pipefail
$ test-trie() { ../lib/test-trie -T; }
$ print a b|test-trie
trie={"sym":"a","lo":null,"eq":{"val":"a","lo":null,"hi":null},"hi":{"sym":"b","lo":null,"eq":{"val":"b","lo":null,"hi":null},"hi":null}}
node={"sym":"a","lo":null,"eq":{"val":"a","lo":null,"hi":null},"hi":{"sym":"b","lo":null,"eq":{"val":"b","lo":null,"hi":null},"hi":null}}
char='\''a'\''
char='\''b'\''
node={"val":"a","lo":null,"hi":null}
char='\''\0'\''
node={"val":"b","lo":null,"hi":null}
char='\''\0'\''
$ print b a|test-trie
trie={"sym":"b","lo":{"sym":"a","lo":null,"eq":{"val":"a","lo":null,"hi":null},"hi":null},"eq":{"val":"b","lo":null,"hi":null},"hi":null}
node={"sym":"b","lo":{"sym":"a","lo":null,"eq":{"val":"a","lo":null,"hi":null},"hi":null},"eq":{"val":"b","lo":null,"hi":null},"hi":null}
char='\''a'\''
char='\''b'\''
node={"val":"a","lo":null,"hi":null}
char='\''\0'\''
node={"val":"b","lo":null,"hi":null}
char='\''\0'\''
$ print a b c|test-trie
trie={"sym":"a","lo":null,"eq":{"val":"a","lo":null,"hi":null},"hi":{"sym":"b","lo":null,"eq":{"val":"b","lo":null,"hi":null},"hi":{"sym":"c","lo":null,"eq":{"val":"c","lo":null,"hi":null},"hi":null}}}
node={"sym":"a","lo":null,"eq":{"val":"a","lo":null,"hi":null},"hi":{"sym":"b","lo":null,"eq":{"val":"b","lo":null,"hi":null},"hi":{"sym":"c","lo":null,"eq":{"val":"c","lo":null,"hi":null},"hi":null}}}
char='\''a'\''
char='\''b'\''
char='\''c'\''
node={"val":"a","lo":null,"hi":null}
char='\''\0'\''
node={"val":"b","lo":null,"hi":null}
char='\''\0'\''
node={"val":"c","lo":null,"hi":null}
char='\''\0'\''
$ print b c a|test-trie
trie={"sym":"b","lo":{"sym":"a","lo":null,"eq":{"val":"a","lo":null,"hi":null},"hi":null},"eq":{"val":"b","lo":null,"hi":null},"hi":{"sym":"c","lo":null,"eq":{"val":"c","lo":null,"hi":null},"hi":null}}
node={"sym":"b","lo":{"sym":"a","lo":null,"eq":{"val":"a","lo":null,"hi":null},"hi":null},"eq":{"val":"b","lo":null,"hi":null},"hi":{"sym":"c","lo":null,"eq":{"val":"c","lo":null,"hi":null},"hi":null}}
char='\''a'\''
char='\''b'\''
char='\''c'\''
node={"val":"a","lo":null,"hi":null}
char='\''\0'\''
node={"val":"b","lo":null,"hi":null}
char='\''\0'\''
node={"val":"c","lo":null,"hi":null}
char='\''\0'\''
$ print c b a|test-trie
trie={"sym":"c","lo":{"sym":"b","lo":{"sym":"a","lo":null,"eq":{"val":"a","lo":null,"hi":null},"hi":null},"eq":{"val":"b","lo":null,"hi":null},"hi":null},"eq":{"val":"c","lo":null,"hi":null},"hi":null}
node={"sym":"c","lo":{"sym":"b","lo":{"sym":"a","lo":null,"eq":{"val":"a","lo":null,"hi":null},"hi":null},"eq":{"val":"b","lo":null,"hi":null},"hi":null},"eq":{"val":"c","lo":null,"hi":null},"hi":null}
char='\''a'\''
char='\''b'\''
char='\''c'\''
node={"val":"a","lo":null,"hi":null}
char='\''\0'\''
node={"val":"b","lo":null,"hi":null}
char='\''\0'\''
node={"val":"c","lo":null,"hi":null}
char='\''\0'\''
$ print a c b|test-trie
trie={"sym":"a","lo":null,"eq":{"val":"a","lo":null,"hi":null},"hi":{"sym":"c","lo":{"sym":"b","lo":null,"eq":{"val":"b","lo":null,"hi":null},"hi":null},"eq":{"val":"c","lo":null,"hi":null},"hi":null}}
node={"sym":"a","lo":null,"eq":{"val":"a","lo":null,"hi":null},"hi":{"sym":"c","lo":{"sym":"b","lo":null,"eq":{"val":"b","lo":null,"hi":null},"hi":null},"eq":{"val":"c","lo":null,"hi":null},"hi":null}}
char='\''a'\''
char='\''b'\''
char='\''c'\''
node={"val":"a","lo":null,"hi":null}
char='\''\0'\''
node={"val":"b","lo":null,"hi":null}
char='\''\0'\''
node={"val":"c","lo":null,"hi":null}
char='\''\0'\''
$ print b a c|test-trie
trie={"sym":"b","lo":{"sym":"a","lo":null,"eq":{"val":"a","lo":null,"hi":null},"hi":null},"eq":{"val":"b","lo":null,"hi":null},"hi":{"sym":"c","lo":null,"eq":{"val":"c","lo":null,"hi":null},"hi":null}}
node={"sym":"b","lo":{"sym":"a","lo":null,"eq":{"val":"a","lo":null,"hi":null},"hi":null},"eq":{"val":"b","lo":null,"hi":null},"hi":{"sym":"c","lo":null,"eq":{"val":"c","lo":null,"hi":null},"hi":null}}
char='\''a'\''
char='\''b'\''
char='\''c'\''
node={"val":"a","lo":null,"hi":null}
char='\''\0'\''
node={"val":"b","lo":null,"hi":null}
char='\''\0'\''
node={"val":"c","lo":null,"hi":null}
char='\''\0'\''
$ print c a b|test-trie
trie={"sym":"c","lo":{"sym":"a","lo":null,"eq":{"val":"a","lo":null,"hi":null},"hi":{"sym":"b","lo":null,"eq":{"val":"b","lo":null,"hi":null},"hi":null}},"eq":{"val":"c","lo":null,"hi":null},"hi":null}
node={"sym":"c","lo":{"sym":"a","lo":null,"eq":{"val":"a","lo":null,"hi":null},"hi":{"sym":"b","lo":null,"eq":{"val":"b","lo":null,"hi":null},"hi":null}},"eq":{"val":"c","lo":null,"hi":null},"hi":null}
char='\''a'\''
char='\''b'\''
char='\''c'\''
node={"val":"a","lo":null,"hi":null}
char='\''\0'\''
node={"val":"b","lo":null,"hi":null}
char='\''\0'\''
node={"val":"c","lo":null,"hi":null}
char='\''\0'\''
$ print ab|test-trie
trie={"sym":"a","lo":null,"eq":{"sym":"b","lo":null,"eq":{"val":"ab","lo":null,"hi":null},"hi":null},"hi":null}
node={"sym":"a","lo":null,"eq":{"sym":"b","lo":null,"eq":{"val":"ab","lo":null,"hi":null},"hi":null},"hi":null}
char='\''a'\''
node={"sym":"b","lo":null,"eq":{"val":"ab","lo":null,"hi":null},"hi":null}
char='\''b'\''
node={"val":"ab","lo":null,"hi":null}
char='\''\0'\''
$ print z ax abc abd aef aeg|test-trie
trie={"sym":"z","lo":{"sym":"a","lo":null,"eq":{"sym":"x","lo":{"sym":"b","lo":null,"eq":{"sym":"c","lo":null,"eq":{"val":"abc","lo":null,"hi":null},"hi":{"sym":"d","lo":null,"eq":{"val":"abd","lo":null,"hi":null},"hi":null}},"hi":{"sym":"e","lo":null,"eq":{"sym":"f","lo":null,"eq":{"val":"aef","lo":null,"hi":null},"hi":{"sym":"g","lo":null,"eq":{"val":"aeg","lo":null,"hi":null},"hi":null}},"hi":null}},"eq":{"val":"ax","lo":null,"hi":null},"hi":null},"hi":null},"eq":{"val":"z","lo":null,"hi":null},"hi":null}
node={"sym":"z","lo":{"sym":"a","lo":null,"eq":{"sym":"x","lo":{"sym":"b","lo":null,"eq":{"sym":"c","lo":null,"eq":{"val":"abc","lo":null,"hi":null},"hi":{"sym":"d","lo":null,"eq":{"val":"abd","lo":null,"hi":null},"hi":null}},"hi":{"sym":"e","lo":null,"eq":{"sym":"f","lo":null,"eq":{"val":"aef","lo":null,"hi":null},"hi":{"sym":"g","lo":null,"eq":{"val":"aeg","lo":null,"hi":null},"hi":null}},"hi":null}},"eq":{"val":"ax","lo":null,"hi":null},"hi":null},"hi":null},"eq":{"val":"z","lo":null,"hi":null},"hi":null}
char='\''a'\''
char='\''z'\''
node={"sym":"x","lo":{"sym":"b","lo":null,"eq":{"sym":"c","lo":null,"eq":{"val":"abc","lo":null,"hi":null},"hi":{"sym":"d","lo":null,"eq":{"val":"abd","lo":null,"hi":null},"hi":null}},"hi":{"sym":"e","lo":null,"eq":{"sym":"f","lo":null,"eq":{"val":"aef","lo":null,"hi":null},"hi":{"sym":"g","lo":null,"eq":{"val":"aeg","lo":null,"hi":null},"hi":null}},"hi":null}},"eq":{"val":"ax","lo":null,"hi":null},"hi":null}
char='\''b'\''
char='\''e'\''
char='\''x'\''
node={"val":"z","lo":null,"hi":null}
char='\''\0'\''
node={"sym":"c","lo":null,"eq":{"val":"abc","lo":null,"hi":null},"hi":{"sym":"d","lo":null,"eq":{"val":"abd","lo":null,"hi":null},"hi":null}}
char='\''c'\''
char='\''d'\''
node={"sym":"f","lo":null,"eq":{"val":"aef","lo":null,"hi":null},"hi":{"sym":"g","lo":null,"eq":{"val":"aeg","lo":null,"hi":null},"hi":null}}
char='\''f'\''
char='\''g'\''
node={"val":"ax","lo":null,"hi":null}
char='\''\0'\''
node={"val":"abc","lo":null,"hi":null}
char='\''\0'\''
node={"val":"abd","lo":null,"hi":null}
char='\''\0'\''
node={"val":"aef","lo":null,"hi":null}
char='\''\0'\''
node={"val":"aeg","lo":null,"hi":null}
char='\''\0'\''
$ print aef ae abg a abc ab abd|test-trie
trie={"sym":"a","lo":null,"eq":{"sym":"e","lo":{"sym":"b","lo":{"val":"a","lo":null,"hi":null},"eq":{"sym":"g","lo":{"sym":"c","lo":{"val":"ab","lo":null,"hi":null},"eq":{"val":"abc","lo":null,"hi":null},"hi":{"sym":"d","lo":null,"eq":{"val":"abd","lo":null,"hi":null},"hi":null}},"eq":{"val":"abg","lo":null,"hi":null},"hi":null},"hi":null},"eq":{"sym":"f","lo":{"val":"ae","lo":null,"hi":null},"eq":{"val":"aef","lo":null,"hi":null},"hi":null},"hi":null},"hi":null}
node={"sym":"a","lo":null,"eq":{"sym":"e","lo":{"sym":"b","lo":{"val":"a","lo":null,"hi":null},"eq":{"sym":"g","lo":{"sym":"c","lo":{"val":"ab","lo":null,"hi":null},"eq":{"val":"abc","lo":null,"hi":null},"hi":{"sym":"d","lo":null,"eq":{"val":"abd","lo":null,"hi":null},"hi":null}},"eq":{"val":"abg","lo":null,"hi":null},"hi":null},"hi":null},"eq":{"sym":"f","lo":{"val":"ae","lo":null,"hi":null},"eq":{"val":"aef","lo":null,"hi":null},"hi":null},"hi":null},"hi":null}
char='\''a'\''
node={"sym":"e","lo":{"sym":"b","lo":{"val":"a","lo":null,"hi":null},"eq":{"sym":"g","lo":{"sym":"c","lo":{"val":"ab","lo":null,"hi":null},"eq":{"val":"abc","lo":null,"hi":null},"hi":{"sym":"d","lo":null,"eq":{"val":"abd","lo":null,"hi":null},"hi":null}},"eq":{"val":"abg","lo":null,"hi":null},"hi":null},"hi":null},"eq":{"sym":"f","lo":{"val":"ae","lo":null,"hi":null},"eq":{"val":"aef","lo":null,"hi":null},"hi":null},"hi":null}
char='\''\0'\''
char='\''b'\''
char='\''e'\''
node={"sym":"g","lo":{"sym":"c","lo":{"val":"ab","lo":null,"hi":null},"eq":{"val":"abc","lo":null,"hi":null},"hi":{"sym":"d","lo":null,"eq":{"val":"abd","lo":null,"hi":null},"hi":null}},"eq":{"val":"abg","lo":null,"hi":null},"hi":null}
char='\''\0'\''
char='\''c'\''
char='\''d'\''
char='\''g'\''
node={"sym":"f","lo":{"val":"ae","lo":null,"hi":null},"eq":{"val":"aef","lo":null,"hi":null},"hi":null}
char='\''\0'\''
char='\''f'\''
node={"val":"abc","lo":null,"hi":null}
char='\''\0'\''
node={"val":"abd","lo":null,"hi":null}
char='\''\0'\''
node={"val":"abg","lo":null,"hi":null}
char='\''\0'\''
node={"val":"aef","lo":null,"hi":null}
char='\''\0'\'''
) -L base.new <(
echo '$ test -x ../lib/test-trie'
test -x ../lib/test-trie 2>&1 ||
echo 'command failed: test -x ../lib/test-trie'

echo '$ print() { printf '\''%s\n'\'' "$@"; }'
print() { printf '%s\n' "$@"; } 2>&1 ||
echo 'command failed: print() { printf '\''%s\n'\'' "$@"; }'

echo '$ set -o pipefail'
set -o pipefail 2>&1 ||
echo 'command failed: set -o pipefail'

echo '$ test-trie() { ../lib/test-trie -T; }'
test-trie() { ../lib/test-trie -T; } 2>&1 ||
echo 'command failed: test-trie() { ../lib/test-trie -T; }'

echo '$ print a b|test-trie'
print a b|test-trie 2>&1 ||
echo 'command failed: print a b|test-trie'

echo '$ print b a|test-trie'
print b a|test-trie 2>&1 ||
echo 'command failed: print b a|test-trie'

echo '$ print a b c|test-trie'
print a b c|test-trie 2>&1 ||
echo 'command failed: print a b c|test-trie'

echo '$ print b c a|test-trie'
print b c a|test-trie 2>&1 ||
echo 'command failed: print b c a|test-trie'

echo '$ print c b a|test-trie'
print c b a|test-trie 2>&1 ||
echo 'command failed: print c b a|test-trie'

echo '$ print a c b|test-trie'
print a c b|test-trie 2>&1 ||
echo 'command failed: print a c b|test-trie'

echo '$ print b a c|test-trie'
print b a c|test-trie 2>&1 ||
echo 'command failed: print b a c|test-trie'

echo '$ print c a b|test-trie'
print c a b|test-trie 2>&1 ||
echo 'command failed: print c a b|test-trie'

echo '$ print ab|test-trie'
print ab|test-trie 2>&1 ||
echo 'command failed: print ab|test-trie'

echo '$ print z ax abc abd aef aeg|test-trie'
print z ax abc abd aef aeg|test-trie 2>&1 ||
echo 'command failed: print z ax abc abd aef aeg|test-trie'

echo '$ print aef ae abg a abc ab abd|test-trie'
print aef ae abg a abc ab abd|test-trie 2>&1 ||
echo 'command failed: print aef ae abg a abc ab abd|test-trie'
)

