#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -p litex -w32 -R expr-flat expr-ast expr lib gen-def gen-def-gcc checker
#

test "$1" == "-q" &&
q="q" ||
q=""

p=0
f=0

for t in \
    expr-flat \
    expr-ast \
    expr \
    lib \
    gen-def \
    gen-def-gcc \
    checker
do
    r=($(./test-litex-$t.sh -w32 -c ${q:+-q}))
    (( p += ${r[0]} ))
    (( f += ${r[1]} ))
done

[ -z "$q" -o "$f" -gt 0 ] &&
echo >&2

echo "test cases passed: $p"
echo "test cases failed: $f"

exit $(( f != 0 ))

