#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C parser:string-esc4
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L string-esc4.old <(echo \
'$ json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }
$ json() { json0 --literal-value "$@"; }
$ echo '\''"\`"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\`"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\`"'\''|json -b 1
$ echo '\''"\`"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\`"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\`"'\''|json -b 2
$ echo '\''"\`"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\`"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\`"'\''|json -b 3
$ echo '\''"\`"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\`"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\`"'\''|json -b 4
$ echo '\''"\`"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\`"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\`"'\''|json -b 5
$ echo '\''"\a"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\a"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\a"'\''|json -b 1
$ echo '\''"\a"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\a"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\a"'\''|json -b 2
$ echo '\''"\a"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\a"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\a"'\''|json -b 3
$ echo '\''"\a"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\a"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\a"'\''|json -b 4
$ echo '\''"\a"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\a"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\a"'\''|json -b 5
$ echo '\''"\b"'\''|json -b 1
"\b"
$ echo '\''"\b"'\''|json -b 2
"\b"
$ echo '\''"\b"'\''|json -b 3
"\b"
$ echo '\''"\b"'\''|json -b 4
"\b"
$ echo '\''"\b"'\''|json -b 5
"\b"
$ echo '\''"\c"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\c"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\c"'\''|json -b 1
$ echo '\''"\c"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\c"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\c"'\''|json -b 2
$ echo '\''"\c"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\c"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\c"'\''|json -b 3
$ echo '\''"\c"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\c"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\c"'\''|json -b 4
$ echo '\''"\c"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\c"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\c"'\''|json -b 5
$ echo '\''"\d"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\d"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\d"'\''|json -b 1
$ echo '\''"\d"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\d"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\d"'\''|json -b 2
$ echo '\''"\d"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\d"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\d"'\''|json -b 3
$ echo '\''"\d"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\d"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\d"'\''|json -b 4
$ echo '\''"\d"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\d"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\d"'\''|json -b 5
$ echo '\''"\e"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\e"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\e"'\''|json -b 1
$ echo '\''"\e"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\e"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\e"'\''|json -b 2
$ echo '\''"\e"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\e"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\e"'\''|json -b 3
$ echo '\''"\e"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\e"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\e"'\''|json -b 4
$ echo '\''"\e"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\e"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\e"'\''|json -b 5
$ echo '\''"\f"'\''|json -b 1
"\f"
$ echo '\''"\f"'\''|json -b 2
"\f"
$ echo '\''"\f"'\''|json -b 3
"\f"
$ echo '\''"\f"'\''|json -b 4
"\f"
$ echo '\''"\f"'\''|json -b 5
"\f"
$ echo '\''"\g"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\g"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\g"'\''|json -b 1
$ echo '\''"\g"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\g"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\g"'\''|json -b 2
$ echo '\''"\g"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\g"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\g"'\''|json -b 3
$ echo '\''"\g"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\g"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\g"'\''|json -b 4
$ echo '\''"\g"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\g"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\g"'\''|json -b 5
$ echo '\''"\h"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\h"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\h"'\''|json -b 1
$ echo '\''"\h"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\h"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\h"'\''|json -b 2
$ echo '\''"\h"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\h"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\h"'\''|json -b 3
$ echo '\''"\h"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\h"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\h"'\''|json -b 4
$ echo '\''"\h"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\h"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\h"'\''|json -b 5
$ echo '\''"\i"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\i"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\i"'\''|json -b 1
$ echo '\''"\i"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\i"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\i"'\''|json -b 2
$ echo '\''"\i"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\i"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\i"'\''|json -b 3
$ echo '\''"\i"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\i"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\i"'\''|json -b 4
$ echo '\''"\i"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\i"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\i"'\''|json -b 5
$ echo '\''"\j"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\j"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\j"'\''|json -b 1
$ echo '\''"\j"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\j"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\j"'\''|json -b 2
$ echo '\''"\j"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\j"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\j"'\''|json -b 3
$ echo '\''"\j"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\j"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\j"'\''|json -b 4
$ echo '\''"\j"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\j"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\j"'\''|json -b 5
$ echo '\''"\k"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\k"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\k"'\''|json -b 1
$ echo '\''"\k"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\k"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\k"'\''|json -b 2
$ echo '\''"\k"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\k"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\k"'\''|json -b 3
$ echo '\''"\k"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\k"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\k"'\''|json -b 4
$ echo '\''"\k"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\k"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\k"'\''|json -b 5
$ echo '\''"\l"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\l"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\l"'\''|json -b 1
$ echo '\''"\l"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\l"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\l"'\''|json -b 2
$ echo '\''"\l"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\l"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\l"'\''|json -b 3
$ echo '\''"\l"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\l"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\l"'\''|json -b 4
$ echo '\''"\l"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\l"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\l"'\''|json -b 5
$ echo '\''"\m"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\m"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\m"'\''|json -b 1
$ echo '\''"\m"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\m"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\m"'\''|json -b 2
$ echo '\''"\m"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\m"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\m"'\''|json -b 3
$ echo '\''"\m"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\m"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\m"'\''|json -b 4
$ echo '\''"\m"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\m"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\m"'\''|json -b 5
$ echo '\''"\n"'\''|json -b 1
"\n"
$ echo '\''"\n"'\''|json -b 2
"\n"
$ echo '\''"\n"'\''|json -b 3
"\n"
$ echo '\''"\n"'\''|json -b 4
"\n"
$ echo '\''"\n"'\''|json -b 5
"\n"
$ echo '\''"\o"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\o"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\o"'\''|json -b 1
$ echo '\''"\o"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\o"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\o"'\''|json -b 2
$ echo '\''"\o"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\o"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\o"'\''|json -b 3
$ echo '\''"\o"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\o"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\o"'\''|json -b 4
$ echo '\''"\o"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\o"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\o"'\''|json -b 5
$ echo '\''"\p"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\p"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\p"'\''|json -b 1
$ echo '\''"\p"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\p"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\p"'\''|json -b 2
$ echo '\''"\p"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\p"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\p"'\''|json -b 3
$ echo '\''"\p"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\p"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\p"'\''|json -b 4
$ echo '\''"\p"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\p"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\p"'\''|json -b 5
$ echo '\''"\q"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\q"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\q"'\''|json -b 1
$ echo '\''"\q"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\q"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\q"'\''|json -b 2
$ echo '\''"\q"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\q"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\q"'\''|json -b 3
$ echo '\''"\q"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\q"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\q"'\''|json -b 4
$ echo '\''"\q"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\q"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\q"'\''|json -b 5
$ echo '\''"\r"'\''|json -b 1
"\r"
$ echo '\''"\r"'\''|json -b 2
"\r"
$ echo '\''"\r"'\''|json -b 3
"\r"
$ echo '\''"\r"'\''|json -b 4
"\r"
$ echo '\''"\r"'\''|json -b 5
"\r"
$ echo '\''"\s"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\s"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\s"'\''|json -b 1
$ echo '\''"\s"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\s"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\s"'\''|json -b 2
$ echo '\''"\s"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\s"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\s"'\''|json -b 3
$ echo '\''"\s"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\s"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\s"'\''|json -b 4
$ echo '\''"\s"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\s"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\s"'\''|json -b 5
$ echo '\''"\t"'\''|json -b 1
"\t"
$ echo '\''"\t"'\''|json -b 2
"\t"
$ echo '\''"\t"'\''|json -b 3
"\t"
$ echo '\''"\t"'\''|json -b 4
"\t"
$ echo '\''"\t"'\''|json -b 5
"\t"
$ echo '\''"\u"'\''|json -b 1
json: error: <stdin>:1:4: lex error: invalid string literal
json: error: <stdin>:1:4: "\\u"
json: error: <stdin>:1:4:     ^
command failed: echo '\''"\u"'\''|json -b 1
$ echo '\''"\u"'\''|json -b 2
json: error: <stdin>:1:4: lex error: invalid string literal
json: error: <stdin>:1:4: "\\u"
json: error: <stdin>:1:4:     ^
command failed: echo '\''"\u"'\''|json -b 2
$ echo '\''"\u"'\''|json -b 3
json: error: <stdin>:1:4: lex error: invalid string literal
json: error: <stdin>:1:4: "\\u"
json: error: <stdin>:1:4:     ^
command failed: echo '\''"\u"'\''|json -b 3
$ echo '\''"\u"'\''|json -b 4
json: error: <stdin>:1:4: lex error: invalid string literal
json: error: <stdin>:1:4: "\\u"
json: error: <stdin>:1:4:     ^
command failed: echo '\''"\u"'\''|json -b 4
$ echo '\''"\u"'\''|json -b 5
json: error: <stdin>:1:4: lex error: invalid string literal
json: error: <stdin>:1:4: "\\u"
json: error: <stdin>:1:4:     ^
command failed: echo '\''"\u"'\''|json -b 5
$ echo '\''"\v"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\v"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\v"'\''|json -b 1
$ echo '\''"\v"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\v"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\v"'\''|json -b 2
$ echo '\''"\v"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\v"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\v"'\''|json -b 3
$ echo '\''"\v"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\v"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\v"'\''|json -b 4
$ echo '\''"\v"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\v"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\v"'\''|json -b 5
$ echo '\''"\w"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\w"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\w"'\''|json -b 1
$ echo '\''"\w"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\w"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\w"'\''|json -b 2
$ echo '\''"\w"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\w"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\w"'\''|json -b 3
$ echo '\''"\w"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\w"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\w"'\''|json -b 4
$ echo '\''"\w"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\w"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\w"'\''|json -b 5
$ echo '\''"\x"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\x"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\x"'\''|json -b 1
$ echo '\''"\x"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\x"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\x"'\''|json -b 2
$ echo '\''"\x"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\x"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\x"'\''|json -b 3
$ echo '\''"\x"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\x"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\x"'\''|json -b 4
$ echo '\''"\x"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\x"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\x"'\''|json -b 5
$ echo '\''"\y"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\y"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\y"'\''|json -b 1
$ echo '\''"\y"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\y"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\y"'\''|json -b 2
$ echo '\''"\y"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\y"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\y"'\''|json -b 3
$ echo '\''"\y"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\y"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\y"'\''|json -b 4
$ echo '\''"\y"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\y"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\y"'\''|json -b 5
$ echo '\''"\z"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\z"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\z"'\''|json -b 1
$ echo '\''"\z"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\z"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\z"'\''|json -b 2
$ echo '\''"\z"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\z"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\z"'\''|json -b 3
$ echo '\''"\z"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\z"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\z"'\''|json -b 4
$ echo '\''"\z"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\z"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\z"'\''|json -b 5
$ echo '\''"\{"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\{"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\{"'\''|json -b 1
$ echo '\''"\{"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\{"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\{"'\''|json -b 2
$ echo '\''"\{"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\{"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\{"'\''|json -b 3
$ echo '\''"\{"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\{"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\{"'\''|json -b 4
$ echo '\''"\{"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\{"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\{"'\''|json -b 5
$ echo '\''"\|"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\|"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\|"'\''|json -b 1
$ echo '\''"\|"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\|"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\|"'\''|json -b 2
$ echo '\''"\|"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\|"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\|"'\''|json -b 3
$ echo '\''"\|"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\|"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\|"'\''|json -b 4
$ echo '\''"\|"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\|"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\|"'\''|json -b 5
$ echo '\''"\}"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\}"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\}"'\''|json -b 1
$ echo '\''"\}"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\}"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\}"'\''|json -b 2
$ echo '\''"\}"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\}"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\}"'\''|json -b 3
$ echo '\''"\}"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\}"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\}"'\''|json -b 4
$ echo '\''"\}"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\}"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\}"'\''|json -b 5
$ echo '\''"\~"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\~"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\~"'\''|json -b 1
$ echo '\''"\~"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\~"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\~"'\''|json -b 2
$ echo '\''"\~"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\~"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\~"'\''|json -b 3
$ echo '\''"\~"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\~"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\~"'\''|json -b 4
$ echo '\''"\~"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\~"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\~"'\''|json -b 5
$ echo -e '\''"\\\x7f"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x7f"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x7f"'\''|json -b 1
$ echo -e '\''"\\\x7f"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x7f"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x7f"'\''|json -b 2
$ echo -e '\''"\\\x7f"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x7f"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x7f"'\''|json -b 3
$ echo -e '\''"\\\x7f"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x7f"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x7f"'\''|json -b 4
$ echo -e '\''"\\\x7f"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x7f"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x7f"'\''|json -b 5'
) -L string-esc4.new <(
echo '$ json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }'
json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; } 2>&1 ||
echo 'command failed: json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }'

echo '$ json() { json0 --literal-value "$@"; }'
json() { json0 --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { json0 --literal-value "$@"; }'

echo '$ echo '\''"\`"'\''|json -b 1'
echo '"\`"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\`"'\''|json -b 1'

echo '$ echo '\''"\`"'\''|json -b 2'
echo '"\`"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\`"'\''|json -b 2'

echo '$ echo '\''"\`"'\''|json -b 3'
echo '"\`"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\`"'\''|json -b 3'

echo '$ echo '\''"\`"'\''|json -b 4'
echo '"\`"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\`"'\''|json -b 4'

echo '$ echo '\''"\`"'\''|json -b 5'
echo '"\`"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\`"'\''|json -b 5'

echo '$ echo '\''"\a"'\''|json -b 1'
echo '"\a"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\a"'\''|json -b 1'

echo '$ echo '\''"\a"'\''|json -b 2'
echo '"\a"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\a"'\''|json -b 2'

echo '$ echo '\''"\a"'\''|json -b 3'
echo '"\a"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\a"'\''|json -b 3'

echo '$ echo '\''"\a"'\''|json -b 4'
echo '"\a"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\a"'\''|json -b 4'

echo '$ echo '\''"\a"'\''|json -b 5'
echo '"\a"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\a"'\''|json -b 5'

echo '$ echo '\''"\b"'\''|json -b 1'
echo '"\b"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\b"'\''|json -b 1'

echo '$ echo '\''"\b"'\''|json -b 2'
echo '"\b"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\b"'\''|json -b 2'

echo '$ echo '\''"\b"'\''|json -b 3'
echo '"\b"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\b"'\''|json -b 3'

echo '$ echo '\''"\b"'\''|json -b 4'
echo '"\b"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\b"'\''|json -b 4'

echo '$ echo '\''"\b"'\''|json -b 5'
echo '"\b"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\b"'\''|json -b 5'

echo '$ echo '\''"\c"'\''|json -b 1'
echo '"\c"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\c"'\''|json -b 1'

echo '$ echo '\''"\c"'\''|json -b 2'
echo '"\c"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\c"'\''|json -b 2'

echo '$ echo '\''"\c"'\''|json -b 3'
echo '"\c"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\c"'\''|json -b 3'

echo '$ echo '\''"\c"'\''|json -b 4'
echo '"\c"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\c"'\''|json -b 4'

echo '$ echo '\''"\c"'\''|json -b 5'
echo '"\c"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\c"'\''|json -b 5'

echo '$ echo '\''"\d"'\''|json -b 1'
echo '"\d"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\d"'\''|json -b 1'

echo '$ echo '\''"\d"'\''|json -b 2'
echo '"\d"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\d"'\''|json -b 2'

echo '$ echo '\''"\d"'\''|json -b 3'
echo '"\d"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\d"'\''|json -b 3'

echo '$ echo '\''"\d"'\''|json -b 4'
echo '"\d"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\d"'\''|json -b 4'

echo '$ echo '\''"\d"'\''|json -b 5'
echo '"\d"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\d"'\''|json -b 5'

echo '$ echo '\''"\e"'\''|json -b 1'
echo '"\e"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\e"'\''|json -b 1'

echo '$ echo '\''"\e"'\''|json -b 2'
echo '"\e"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\e"'\''|json -b 2'

echo '$ echo '\''"\e"'\''|json -b 3'
echo '"\e"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\e"'\''|json -b 3'

echo '$ echo '\''"\e"'\''|json -b 4'
echo '"\e"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\e"'\''|json -b 4'

echo '$ echo '\''"\e"'\''|json -b 5'
echo '"\e"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\e"'\''|json -b 5'

echo '$ echo '\''"\f"'\''|json -b 1'
echo '"\f"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\f"'\''|json -b 1'

echo '$ echo '\''"\f"'\''|json -b 2'
echo '"\f"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\f"'\''|json -b 2'

echo '$ echo '\''"\f"'\''|json -b 3'
echo '"\f"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\f"'\''|json -b 3'

echo '$ echo '\''"\f"'\''|json -b 4'
echo '"\f"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\f"'\''|json -b 4'

echo '$ echo '\''"\f"'\''|json -b 5'
echo '"\f"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\f"'\''|json -b 5'

echo '$ echo '\''"\g"'\''|json -b 1'
echo '"\g"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\g"'\''|json -b 1'

echo '$ echo '\''"\g"'\''|json -b 2'
echo '"\g"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\g"'\''|json -b 2'

echo '$ echo '\''"\g"'\''|json -b 3'
echo '"\g"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\g"'\''|json -b 3'

echo '$ echo '\''"\g"'\''|json -b 4'
echo '"\g"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\g"'\''|json -b 4'

echo '$ echo '\''"\g"'\''|json -b 5'
echo '"\g"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\g"'\''|json -b 5'

echo '$ echo '\''"\h"'\''|json -b 1'
echo '"\h"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\h"'\''|json -b 1'

echo '$ echo '\''"\h"'\''|json -b 2'
echo '"\h"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\h"'\''|json -b 2'

echo '$ echo '\''"\h"'\''|json -b 3'
echo '"\h"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\h"'\''|json -b 3'

echo '$ echo '\''"\h"'\''|json -b 4'
echo '"\h"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\h"'\''|json -b 4'

echo '$ echo '\''"\h"'\''|json -b 5'
echo '"\h"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\h"'\''|json -b 5'

echo '$ echo '\''"\i"'\''|json -b 1'
echo '"\i"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\i"'\''|json -b 1'

echo '$ echo '\''"\i"'\''|json -b 2'
echo '"\i"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\i"'\''|json -b 2'

echo '$ echo '\''"\i"'\''|json -b 3'
echo '"\i"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\i"'\''|json -b 3'

echo '$ echo '\''"\i"'\''|json -b 4'
echo '"\i"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\i"'\''|json -b 4'

echo '$ echo '\''"\i"'\''|json -b 5'
echo '"\i"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\i"'\''|json -b 5'

echo '$ echo '\''"\j"'\''|json -b 1'
echo '"\j"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\j"'\''|json -b 1'

echo '$ echo '\''"\j"'\''|json -b 2'
echo '"\j"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\j"'\''|json -b 2'

echo '$ echo '\''"\j"'\''|json -b 3'
echo '"\j"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\j"'\''|json -b 3'

echo '$ echo '\''"\j"'\''|json -b 4'
echo '"\j"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\j"'\''|json -b 4'

echo '$ echo '\''"\j"'\''|json -b 5'
echo '"\j"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\j"'\''|json -b 5'

echo '$ echo '\''"\k"'\''|json -b 1'
echo '"\k"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\k"'\''|json -b 1'

echo '$ echo '\''"\k"'\''|json -b 2'
echo '"\k"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\k"'\''|json -b 2'

echo '$ echo '\''"\k"'\''|json -b 3'
echo '"\k"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\k"'\''|json -b 3'

echo '$ echo '\''"\k"'\''|json -b 4'
echo '"\k"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\k"'\''|json -b 4'

echo '$ echo '\''"\k"'\''|json -b 5'
echo '"\k"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\k"'\''|json -b 5'

echo '$ echo '\''"\l"'\''|json -b 1'
echo '"\l"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\l"'\''|json -b 1'

echo '$ echo '\''"\l"'\''|json -b 2'
echo '"\l"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\l"'\''|json -b 2'

echo '$ echo '\''"\l"'\''|json -b 3'
echo '"\l"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\l"'\''|json -b 3'

echo '$ echo '\''"\l"'\''|json -b 4'
echo '"\l"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\l"'\''|json -b 4'

echo '$ echo '\''"\l"'\''|json -b 5'
echo '"\l"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\l"'\''|json -b 5'

echo '$ echo '\''"\m"'\''|json -b 1'
echo '"\m"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\m"'\''|json -b 1'

echo '$ echo '\''"\m"'\''|json -b 2'
echo '"\m"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\m"'\''|json -b 2'

echo '$ echo '\''"\m"'\''|json -b 3'
echo '"\m"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\m"'\''|json -b 3'

echo '$ echo '\''"\m"'\''|json -b 4'
echo '"\m"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\m"'\''|json -b 4'

echo '$ echo '\''"\m"'\''|json -b 5'
echo '"\m"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\m"'\''|json -b 5'

echo '$ echo '\''"\n"'\''|json -b 1'
echo '"\n"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\n"'\''|json -b 1'

echo '$ echo '\''"\n"'\''|json -b 2'
echo '"\n"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\n"'\''|json -b 2'

echo '$ echo '\''"\n"'\''|json -b 3'
echo '"\n"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\n"'\''|json -b 3'

echo '$ echo '\''"\n"'\''|json -b 4'
echo '"\n"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\n"'\''|json -b 4'

echo '$ echo '\''"\n"'\''|json -b 5'
echo '"\n"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\n"'\''|json -b 5'

echo '$ echo '\''"\o"'\''|json -b 1'
echo '"\o"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\o"'\''|json -b 1'

echo '$ echo '\''"\o"'\''|json -b 2'
echo '"\o"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\o"'\''|json -b 2'

echo '$ echo '\''"\o"'\''|json -b 3'
echo '"\o"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\o"'\''|json -b 3'

echo '$ echo '\''"\o"'\''|json -b 4'
echo '"\o"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\o"'\''|json -b 4'

echo '$ echo '\''"\o"'\''|json -b 5'
echo '"\o"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\o"'\''|json -b 5'

echo '$ echo '\''"\p"'\''|json -b 1'
echo '"\p"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\p"'\''|json -b 1'

echo '$ echo '\''"\p"'\''|json -b 2'
echo '"\p"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\p"'\''|json -b 2'

echo '$ echo '\''"\p"'\''|json -b 3'
echo '"\p"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\p"'\''|json -b 3'

echo '$ echo '\''"\p"'\''|json -b 4'
echo '"\p"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\p"'\''|json -b 4'

echo '$ echo '\''"\p"'\''|json -b 5'
echo '"\p"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\p"'\''|json -b 5'

echo '$ echo '\''"\q"'\''|json -b 1'
echo '"\q"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\q"'\''|json -b 1'

echo '$ echo '\''"\q"'\''|json -b 2'
echo '"\q"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\q"'\''|json -b 2'

echo '$ echo '\''"\q"'\''|json -b 3'
echo '"\q"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\q"'\''|json -b 3'

echo '$ echo '\''"\q"'\''|json -b 4'
echo '"\q"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\q"'\''|json -b 4'

echo '$ echo '\''"\q"'\''|json -b 5'
echo '"\q"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\q"'\''|json -b 5'

echo '$ echo '\''"\r"'\''|json -b 1'
echo '"\r"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\r"'\''|json -b 1'

echo '$ echo '\''"\r"'\''|json -b 2'
echo '"\r"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\r"'\''|json -b 2'

echo '$ echo '\''"\r"'\''|json -b 3'
echo '"\r"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\r"'\''|json -b 3'

echo '$ echo '\''"\r"'\''|json -b 4'
echo '"\r"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\r"'\''|json -b 4'

echo '$ echo '\''"\r"'\''|json -b 5'
echo '"\r"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\r"'\''|json -b 5'

echo '$ echo '\''"\s"'\''|json -b 1'
echo '"\s"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\s"'\''|json -b 1'

echo '$ echo '\''"\s"'\''|json -b 2'
echo '"\s"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\s"'\''|json -b 2'

echo '$ echo '\''"\s"'\''|json -b 3'
echo '"\s"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\s"'\''|json -b 3'

echo '$ echo '\''"\s"'\''|json -b 4'
echo '"\s"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\s"'\''|json -b 4'

echo '$ echo '\''"\s"'\''|json -b 5'
echo '"\s"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\s"'\''|json -b 5'

echo '$ echo '\''"\t"'\''|json -b 1'
echo '"\t"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\t"'\''|json -b 1'

echo '$ echo '\''"\t"'\''|json -b 2'
echo '"\t"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\t"'\''|json -b 2'

echo '$ echo '\''"\t"'\''|json -b 3'
echo '"\t"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\t"'\''|json -b 3'

echo '$ echo '\''"\t"'\''|json -b 4'
echo '"\t"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\t"'\''|json -b 4'

echo '$ echo '\''"\t"'\''|json -b 5'
echo '"\t"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\t"'\''|json -b 5'

echo '$ echo '\''"\u"'\''|json -b 1'
echo '"\u"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u"'\''|json -b 1'

echo '$ echo '\''"\u"'\''|json -b 2'
echo '"\u"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u"'\''|json -b 2'

echo '$ echo '\''"\u"'\''|json -b 3'
echo '"\u"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u"'\''|json -b 3'

echo '$ echo '\''"\u"'\''|json -b 4'
echo '"\u"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u"'\''|json -b 4'

echo '$ echo '\''"\u"'\''|json -b 5'
echo '"\u"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u"'\''|json -b 5'

echo '$ echo '\''"\v"'\''|json -b 1'
echo '"\v"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\v"'\''|json -b 1'

echo '$ echo '\''"\v"'\''|json -b 2'
echo '"\v"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\v"'\''|json -b 2'

echo '$ echo '\''"\v"'\''|json -b 3'
echo '"\v"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\v"'\''|json -b 3'

echo '$ echo '\''"\v"'\''|json -b 4'
echo '"\v"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\v"'\''|json -b 4'

echo '$ echo '\''"\v"'\''|json -b 5'
echo '"\v"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\v"'\''|json -b 5'

echo '$ echo '\''"\w"'\''|json -b 1'
echo '"\w"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\w"'\''|json -b 1'

echo '$ echo '\''"\w"'\''|json -b 2'
echo '"\w"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\w"'\''|json -b 2'

echo '$ echo '\''"\w"'\''|json -b 3'
echo '"\w"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\w"'\''|json -b 3'

echo '$ echo '\''"\w"'\''|json -b 4'
echo '"\w"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\w"'\''|json -b 4'

echo '$ echo '\''"\w"'\''|json -b 5'
echo '"\w"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\w"'\''|json -b 5'

echo '$ echo '\''"\x"'\''|json -b 1'
echo '"\x"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\x"'\''|json -b 1'

echo '$ echo '\''"\x"'\''|json -b 2'
echo '"\x"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\x"'\''|json -b 2'

echo '$ echo '\''"\x"'\''|json -b 3'
echo '"\x"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\x"'\''|json -b 3'

echo '$ echo '\''"\x"'\''|json -b 4'
echo '"\x"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\x"'\''|json -b 4'

echo '$ echo '\''"\x"'\''|json -b 5'
echo '"\x"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\x"'\''|json -b 5'

echo '$ echo '\''"\y"'\''|json -b 1'
echo '"\y"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\y"'\''|json -b 1'

echo '$ echo '\''"\y"'\''|json -b 2'
echo '"\y"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\y"'\''|json -b 2'

echo '$ echo '\''"\y"'\''|json -b 3'
echo '"\y"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\y"'\''|json -b 3'

echo '$ echo '\''"\y"'\''|json -b 4'
echo '"\y"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\y"'\''|json -b 4'

echo '$ echo '\''"\y"'\''|json -b 5'
echo '"\y"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\y"'\''|json -b 5'

echo '$ echo '\''"\z"'\''|json -b 1'
echo '"\z"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\z"'\''|json -b 1'

echo '$ echo '\''"\z"'\''|json -b 2'
echo '"\z"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\z"'\''|json -b 2'

echo '$ echo '\''"\z"'\''|json -b 3'
echo '"\z"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\z"'\''|json -b 3'

echo '$ echo '\''"\z"'\''|json -b 4'
echo '"\z"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\z"'\''|json -b 4'

echo '$ echo '\''"\z"'\''|json -b 5'
echo '"\z"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\z"'\''|json -b 5'

echo '$ echo '\''"\{"'\''|json -b 1'
echo '"\{"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\{"'\''|json -b 1'

echo '$ echo '\''"\{"'\''|json -b 2'
echo '"\{"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\{"'\''|json -b 2'

echo '$ echo '\''"\{"'\''|json -b 3'
echo '"\{"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\{"'\''|json -b 3'

echo '$ echo '\''"\{"'\''|json -b 4'
echo '"\{"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\{"'\''|json -b 4'

echo '$ echo '\''"\{"'\''|json -b 5'
echo '"\{"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\{"'\''|json -b 5'

echo '$ echo '\''"\|"'\''|json -b 1'
echo '"\|"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\|"'\''|json -b 1'

echo '$ echo '\''"\|"'\''|json -b 2'
echo '"\|"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\|"'\''|json -b 2'

echo '$ echo '\''"\|"'\''|json -b 3'
echo '"\|"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\|"'\''|json -b 3'

echo '$ echo '\''"\|"'\''|json -b 4'
echo '"\|"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\|"'\''|json -b 4'

echo '$ echo '\''"\|"'\''|json -b 5'
echo '"\|"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\|"'\''|json -b 5'

echo '$ echo '\''"\}"'\''|json -b 1'
echo '"\}"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\}"'\''|json -b 1'

echo '$ echo '\''"\}"'\''|json -b 2'
echo '"\}"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\}"'\''|json -b 2'

echo '$ echo '\''"\}"'\''|json -b 3'
echo '"\}"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\}"'\''|json -b 3'

echo '$ echo '\''"\}"'\''|json -b 4'
echo '"\}"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\}"'\''|json -b 4'

echo '$ echo '\''"\}"'\''|json -b 5'
echo '"\}"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\}"'\''|json -b 5'

echo '$ echo '\''"\~"'\''|json -b 1'
echo '"\~"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\~"'\''|json -b 1'

echo '$ echo '\''"\~"'\''|json -b 2'
echo '"\~"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\~"'\''|json -b 2'

echo '$ echo '\''"\~"'\''|json -b 3'
echo '"\~"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\~"'\''|json -b 3'

echo '$ echo '\''"\~"'\''|json -b 4'
echo '"\~"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\~"'\''|json -b 4'

echo '$ echo '\''"\~"'\''|json -b 5'
echo '"\~"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\~"'\''|json -b 5'

echo '$ echo -e '\''"\\\x7f"'\''|json -b 1'
echo -e '"\\\x7f"'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''"\\\x7f"'\''|json -b 1'

echo '$ echo -e '\''"\\\x7f"'\''|json -b 2'
echo -e '"\\\x7f"'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''"\\\x7f"'\''|json -b 2'

echo '$ echo -e '\''"\\\x7f"'\''|json -b 3'
echo -e '"\\\x7f"'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''"\\\x7f"'\''|json -b 3'

echo '$ echo -e '\''"\\\x7f"'\''|json -b 4'
echo -e '"\\\x7f"'|json -b 4 2>&1 ||
echo 'command failed: echo -e '\''"\\\x7f"'\''|json -b 4'

echo '$ echo -e '\''"\\\x7f"'\''|json -b 5'
echo -e '"\\\x7f"'|json -b 5 2>&1 ||
echo 'command failed: echo -e '\''"\\\x7f"'\''|json -b 5'
)

