#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C parser:raw-string2
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L raw-string2.old <(echo \
'$ json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }
$ json() { set -o pipefail && json0 --literal-value --raw-strings --pretty --sigpipe=no-error "$@"|sed -nr '\''/\berror\b/{p;b};l1024'\''; }
$ echo -ne '\''r"foo(\0000)foo"'\''|json -b1
json: error: <stdin>:1:7: lex error: invalid raw string literal
json: error: <stdin>:1:7: r"foo(\0)foo"
json: error: <stdin>:1:7:       ^
command failed: echo -ne '\''r"foo(\0000)foo"'\''|json -b1
$ echo -ne '\''r"foo(\0000)foo"'\''|json -b2
json: error: <stdin>:1:7: lex error: invalid raw string literal
json: error: <stdin>:1:7: r"foo(\0)foo"
json: error: <stdin>:1:7:       ^
command failed: echo -ne '\''r"foo(\0000)foo"'\''|json -b2
$ echo -ne '\''r"foo(\0000)foo"'\''|json -b4
json: error: <stdin>:1:7: lex error: invalid raw string literal
json: error: <stdin>:1:7: r"foo(\0)foo"
json: error: <stdin>:1:7:       ^
command failed: echo -ne '\''r"foo(\0000)foo"'\''|json -b4
$ echo -ne '\''r"foo(\0000)foo"'\''|json -b8
json: error: <stdin>:1:7: lex error: invalid raw string literal
json: error: <stdin>:1:7: r"foo(\0)foo"
json: error: <stdin>:1:7:       ^
command failed: echo -ne '\''r"foo(\0000)foo"'\''|json -b8
$ echo -ne '\''r"foo(\0001)foo"'\''|json -b1
r"foo(\001)foo"$
$ echo -ne '\''r"foo(\0001)foo"'\''|json -b2
r"foo(\001)foo"$
$ echo -ne '\''r"foo(\0001)foo"'\''|json -b4
r"foo(\001)foo"$
$ echo -ne '\''r"foo(\0001)foo"'\''|json -b8
r"foo(\001)foo"$
$ echo -ne '\''r"foo(\0002)foo"'\''|json -b1
r"foo(\002)foo"$
$ echo -ne '\''r"foo(\0002)foo"'\''|json -b2
r"foo(\002)foo"$
$ echo -ne '\''r"foo(\0002)foo"'\''|json -b4
r"foo(\002)foo"$
$ echo -ne '\''r"foo(\0002)foo"'\''|json -b8
r"foo(\002)foo"$
$ echo -ne '\''r"foo(\0003)foo"'\''|json -b1
r"foo(\003)foo"$
$ echo -ne '\''r"foo(\0003)foo"'\''|json -b2
r"foo(\003)foo"$
$ echo -ne '\''r"foo(\0003)foo"'\''|json -b4
r"foo(\003)foo"$
$ echo -ne '\''r"foo(\0003)foo"'\''|json -b8
r"foo(\003)foo"$
$ echo -ne '\''r"foo(\0004)foo"'\''|json -b1
r"foo(\004)foo"$
$ echo -ne '\''r"foo(\0004)foo"'\''|json -b2
r"foo(\004)foo"$
$ echo -ne '\''r"foo(\0004)foo"'\''|json -b4
r"foo(\004)foo"$
$ echo -ne '\''r"foo(\0004)foo"'\''|json -b8
r"foo(\004)foo"$
$ echo -ne '\''r"foo(\0005)foo"'\''|json -b1
r"foo(\005)foo"$
$ echo -ne '\''r"foo(\0005)foo"'\''|json -b2
r"foo(\005)foo"$
$ echo -ne '\''r"foo(\0005)foo"'\''|json -b4
r"foo(\005)foo"$
$ echo -ne '\''r"foo(\0005)foo"'\''|json -b8
r"foo(\005)foo"$
$ echo -ne '\''r"foo(\0006)foo"'\''|json -b1
r"foo(\006)foo"$
$ echo -ne '\''r"foo(\0006)foo"'\''|json -b2
r"foo(\006)foo"$
$ echo -ne '\''r"foo(\0006)foo"'\''|json -b4
r"foo(\006)foo"$
$ echo -ne '\''r"foo(\0006)foo"'\''|json -b8
r"foo(\006)foo"$
$ echo -ne '\''r"foo(\0007)foo"'\''|json -b1
r"foo(\a)foo"$
$ echo -ne '\''r"foo(\0007)foo"'\''|json -b2
r"foo(\a)foo"$
$ echo -ne '\''r"foo(\0007)foo"'\''|json -b4
r"foo(\a)foo"$
$ echo -ne '\''r"foo(\0007)foo"'\''|json -b8
r"foo(\a)foo"$
$ echo -ne '\''r"foo(\0010)foo"'\''|json -b1
r"foo(\b)foo"$
$ echo -ne '\''r"foo(\0010)foo"'\''|json -b2
r"foo(\b)foo"$
$ echo -ne '\''r"foo(\0010)foo"'\''|json -b4
r"foo(\b)foo"$
$ echo -ne '\''r"foo(\0010)foo"'\''|json -b8
r"foo(\b)foo"$
$ echo -ne '\''r"foo(\0011)foo"'\''|json -b1
r"foo(\t)foo"$
$ echo -ne '\''r"foo(\0011)foo"'\''|json -b2
r"foo(\t)foo"$
$ echo -ne '\''r"foo(\0011)foo"'\''|json -b4
r"foo(\t)foo"$
$ echo -ne '\''r"foo(\0011)foo"'\''|json -b8
r"foo(\t)foo"$
$ echo -ne '\''r"foo(\0012)foo"'\''|json -b1
r"foo($
)foo"$
$ echo -ne '\''r"foo(\0012)foo"'\''|json -b2
r"foo($
)foo"$
$ echo -ne '\''r"foo(\0012)foo"'\''|json -b4
r"foo($
)foo"$
$ echo -ne '\''r"foo(\0012)foo"'\''|json -b8
r"foo($
)foo"$
$ echo -ne '\''r"foo(\0013)foo"'\''|json -b1
r"foo(\v)foo"$
$ echo -ne '\''r"foo(\0013)foo"'\''|json -b2
r"foo(\v)foo"$
$ echo -ne '\''r"foo(\0013)foo"'\''|json -b4
r"foo(\v)foo"$
$ echo -ne '\''r"foo(\0013)foo"'\''|json -b8
r"foo(\v)foo"$
$ echo -ne '\''r"foo(\0014)foo"'\''|json -b1
r"foo(\f)foo"$
$ echo -ne '\''r"foo(\0014)foo"'\''|json -b2
r"foo(\f)foo"$
$ echo -ne '\''r"foo(\0014)foo"'\''|json -b4
r"foo(\f)foo"$
$ echo -ne '\''r"foo(\0014)foo"'\''|json -b8
r"foo(\f)foo"$
$ echo -ne '\''r"foo(\0015)foo"'\''|json -b1
r"foo(\r)foo"$
$ echo -ne '\''r"foo(\0015)foo"'\''|json -b2
r"foo(\r)foo"$
$ echo -ne '\''r"foo(\0015)foo"'\''|json -b4
r"foo(\r)foo"$
$ echo -ne '\''r"foo(\0015)foo"'\''|json -b8
r"foo(\r)foo"$
$ echo -ne '\''r"foo(\0016)foo"'\''|json -b1
r"foo(\016)foo"$
$ echo -ne '\''r"foo(\0016)foo"'\''|json -b2
r"foo(\016)foo"$
$ echo -ne '\''r"foo(\0016)foo"'\''|json -b4
r"foo(\016)foo"$
$ echo -ne '\''r"foo(\0016)foo"'\''|json -b8
r"foo(\016)foo"$
$ echo -ne '\''r"foo(\0017)foo"'\''|json -b1
r"foo(\017)foo"$
$ echo -ne '\''r"foo(\0017)foo"'\''|json -b2
r"foo(\017)foo"$
$ echo -ne '\''r"foo(\0017)foo"'\''|json -b4
r"foo(\017)foo"$
$ echo -ne '\''r"foo(\0017)foo"'\''|json -b8
r"foo(\017)foo"$
$ echo -ne '\''r"foo(\0020)foo"'\''|json -b1
r"foo(\020)foo"$
$ echo -ne '\''r"foo(\0020)foo"'\''|json -b2
r"foo(\020)foo"$
$ echo -ne '\''r"foo(\0020)foo"'\''|json -b4
r"foo(\020)foo"$
$ echo -ne '\''r"foo(\0020)foo"'\''|json -b8
r"foo(\020)foo"$
$ echo -ne '\''r"foo(\0021)foo"'\''|json -b1
r"foo(\021)foo"$
$ echo -ne '\''r"foo(\0021)foo"'\''|json -b2
r"foo(\021)foo"$
$ echo -ne '\''r"foo(\0021)foo"'\''|json -b4
r"foo(\021)foo"$
$ echo -ne '\''r"foo(\0021)foo"'\''|json -b8
r"foo(\021)foo"$
$ echo -ne '\''r"foo(\0022)foo"'\''|json -b1
r"foo(\022)foo"$
$ echo -ne '\''r"foo(\0022)foo"'\''|json -b2
r"foo(\022)foo"$
$ echo -ne '\''r"foo(\0022)foo"'\''|json -b4
r"foo(\022)foo"$
$ echo -ne '\''r"foo(\0022)foo"'\''|json -b8
r"foo(\022)foo"$
$ echo -ne '\''r"foo(\0023)foo"'\''|json -b1
r"foo(\023)foo"$
$ echo -ne '\''r"foo(\0023)foo"'\''|json -b2
r"foo(\023)foo"$
$ echo -ne '\''r"foo(\0023)foo"'\''|json -b4
r"foo(\023)foo"$
$ echo -ne '\''r"foo(\0023)foo"'\''|json -b8
r"foo(\023)foo"$
$ echo -ne '\''r"foo(\0024)foo"'\''|json -b1
r"foo(\024)foo"$
$ echo -ne '\''r"foo(\0024)foo"'\''|json -b2
r"foo(\024)foo"$
$ echo -ne '\''r"foo(\0024)foo"'\''|json -b4
r"foo(\024)foo"$
$ echo -ne '\''r"foo(\0024)foo"'\''|json -b8
r"foo(\024)foo"$
$ echo -ne '\''r"foo(\0025)foo"'\''|json -b1
r"foo(\025)foo"$
$ echo -ne '\''r"foo(\0025)foo"'\''|json -b2
r"foo(\025)foo"$
$ echo -ne '\''r"foo(\0025)foo"'\''|json -b4
r"foo(\025)foo"$
$ echo -ne '\''r"foo(\0025)foo"'\''|json -b8
r"foo(\025)foo"$
$ echo -ne '\''r"foo(\0026)foo"'\''|json -b1
r"foo(\026)foo"$
$ echo -ne '\''r"foo(\0026)foo"'\''|json -b2
r"foo(\026)foo"$
$ echo -ne '\''r"foo(\0026)foo"'\''|json -b4
r"foo(\026)foo"$
$ echo -ne '\''r"foo(\0026)foo"'\''|json -b8
r"foo(\026)foo"$
$ echo -ne '\''r"foo(\0027)foo"'\''|json -b1
r"foo(\027)foo"$
$ echo -ne '\''r"foo(\0027)foo"'\''|json -b2
r"foo(\027)foo"$
$ echo -ne '\''r"foo(\0027)foo"'\''|json -b4
r"foo(\027)foo"$
$ echo -ne '\''r"foo(\0027)foo"'\''|json -b8
r"foo(\027)foo"$
$ echo -ne '\''r"foo(\0030)foo"'\''|json -b1
r"foo(\030)foo"$
$ echo -ne '\''r"foo(\0030)foo"'\''|json -b2
r"foo(\030)foo"$
$ echo -ne '\''r"foo(\0030)foo"'\''|json -b4
r"foo(\030)foo"$
$ echo -ne '\''r"foo(\0030)foo"'\''|json -b8
r"foo(\030)foo"$
$ echo -ne '\''r"foo(\0031)foo"'\''|json -b1
r"foo(\031)foo"$
$ echo -ne '\''r"foo(\0031)foo"'\''|json -b2
r"foo(\031)foo"$
$ echo -ne '\''r"foo(\0031)foo"'\''|json -b4
r"foo(\031)foo"$
$ echo -ne '\''r"foo(\0031)foo"'\''|json -b8
r"foo(\031)foo"$
$ echo -ne '\''r"foo(\0032)foo"'\''|json -b1
r"foo(\032)foo"$
$ echo -ne '\''r"foo(\0032)foo"'\''|json -b2
r"foo(\032)foo"$
$ echo -ne '\''r"foo(\0032)foo"'\''|json -b4
r"foo(\032)foo"$
$ echo -ne '\''r"foo(\0032)foo"'\''|json -b8
r"foo(\032)foo"$
$ echo -ne '\''r"foo(\0033)foo"'\''|json -b1
r"foo(\033)foo"$
$ echo -ne '\''r"foo(\0033)foo"'\''|json -b2
r"foo(\033)foo"$
$ echo -ne '\''r"foo(\0033)foo"'\''|json -b4
r"foo(\033)foo"$
$ echo -ne '\''r"foo(\0033)foo"'\''|json -b8
r"foo(\033)foo"$
$ echo -ne '\''r"foo(\0034)foo"'\''|json -b1
r"foo(\034)foo"$
$ echo -ne '\''r"foo(\0034)foo"'\''|json -b2
r"foo(\034)foo"$
$ echo -ne '\''r"foo(\0034)foo"'\''|json -b4
r"foo(\034)foo"$
$ echo -ne '\''r"foo(\0034)foo"'\''|json -b8
r"foo(\034)foo"$
$ echo -ne '\''r"foo(\0035)foo"'\''|json -b1
r"foo(\035)foo"$
$ echo -ne '\''r"foo(\0035)foo"'\''|json -b2
r"foo(\035)foo"$
$ echo -ne '\''r"foo(\0035)foo"'\''|json -b4
r"foo(\035)foo"$
$ echo -ne '\''r"foo(\0035)foo"'\''|json -b8
r"foo(\035)foo"$
$ echo -ne '\''r"foo(\0036)foo"'\''|json -b1
r"foo(\036)foo"$
$ echo -ne '\''r"foo(\0036)foo"'\''|json -b2
r"foo(\036)foo"$
$ echo -ne '\''r"foo(\0036)foo"'\''|json -b4
r"foo(\036)foo"$
$ echo -ne '\''r"foo(\0036)foo"'\''|json -b8
r"foo(\036)foo"$
$ echo -ne '\''r"foo(\0037)foo"'\''|json -b1
r"foo(\037)foo"$
$ echo -ne '\''r"foo(\0037)foo"'\''|json -b2
r"foo(\037)foo"$
$ echo -ne '\''r"foo(\0037)foo"'\''|json -b4
r"foo(\037)foo"$
$ echo -ne '\''r"foo(\0037)foo"'\''|json -b8
r"foo(\037)foo"$
$ echo -ne '\''r"foo(\0040)foo"'\''|json -b1
r"foo( )foo"$
$ echo -ne '\''r"foo(\0040)foo"'\''|json -b2
r"foo( )foo"$
$ echo -ne '\''r"foo(\0040)foo"'\''|json -b4
r"foo( )foo"$
$ echo -ne '\''r"foo(\0040)foo"'\''|json -b8
r"foo( )foo"$
$ echo -ne '\''r"foo(\0041)foo"'\''|json -b1
r"foo(!)foo"$
$ echo -ne '\''r"foo(\0041)foo"'\''|json -b2
r"foo(!)foo"$
$ echo -ne '\''r"foo(\0041)foo"'\''|json -b4
r"foo(!)foo"$
$ echo -ne '\''r"foo(\0041)foo"'\''|json -b8
r"foo(!)foo"$
$ echo -ne '\''r"foo(\0042)foo"'\''|json -b1
r"foo(")foo"$
$ echo -ne '\''r"foo(\0042)foo"'\''|json -b2
r"foo(")foo"$
$ echo -ne '\''r"foo(\0042)foo"'\''|json -b4
r"foo(")foo"$
$ echo -ne '\''r"foo(\0042)foo"'\''|json -b8
r"foo(")foo"$
$ echo -ne '\''r"foo(\0043)foo"'\''|json -b1
r"foo(#)foo"$
$ echo -ne '\''r"foo(\0043)foo"'\''|json -b2
r"foo(#)foo"$
$ echo -ne '\''r"foo(\0043)foo"'\''|json -b4
r"foo(#)foo"$
$ echo -ne '\''r"foo(\0043)foo"'\''|json -b8
r"foo(#)foo"$
$ echo -ne '\''r"foo(\0044)foo"'\''|json -b1
r"foo($)foo"$
$ echo -ne '\''r"foo(\0044)foo"'\''|json -b2
r"foo($)foo"$
$ echo -ne '\''r"foo(\0044)foo"'\''|json -b4
r"foo($)foo"$
$ echo -ne '\''r"foo(\0044)foo"'\''|json -b8
r"foo($)foo"$
$ echo -ne '\''r"foo(\0045)foo"'\''|json -b1
r"foo(%)foo"$
$ echo -ne '\''r"foo(\0045)foo"'\''|json -b2
r"foo(%)foo"$
$ echo -ne '\''r"foo(\0045)foo"'\''|json -b4
r"foo(%)foo"$
$ echo -ne '\''r"foo(\0045)foo"'\''|json -b8
r"foo(%)foo"$
$ echo -ne '\''r"foo(\0046)foo"'\''|json -b1
r"foo(&)foo"$
$ echo -ne '\''r"foo(\0046)foo"'\''|json -b2
r"foo(&)foo"$
$ echo -ne '\''r"foo(\0046)foo"'\''|json -b4
r"foo(&)foo"$
$ echo -ne '\''r"foo(\0046)foo"'\''|json -b8
r"foo(&)foo"$
$ echo -ne '\''r"foo(\0047)foo"'\''|json -b1
r"foo('\'')foo"$
$ echo -ne '\''r"foo(\0047)foo"'\''|json -b2
r"foo('\'')foo"$
$ echo -ne '\''r"foo(\0047)foo"'\''|json -b4
r"foo('\'')foo"$
$ echo -ne '\''r"foo(\0047)foo"'\''|json -b8
r"foo('\'')foo"$
$ echo -ne '\''r"foo(\0050)foo"'\''|json -b1
r"foo(()foo"$
$ echo -ne '\''r"foo(\0050)foo"'\''|json -b2
r"foo(()foo"$
$ echo -ne '\''r"foo(\0050)foo"'\''|json -b4
r"foo(()foo"$
$ echo -ne '\''r"foo(\0050)foo"'\''|json -b8
r"foo(()foo"$
$ echo -ne '\''r"foo(\0051)foo"'\''|json -b1
r"foo())foo"$
$ echo -ne '\''r"foo(\0051)foo"'\''|json -b2
r"foo())foo"$
$ echo -ne '\''r"foo(\0051)foo"'\''|json -b4
r"foo())foo"$
$ echo -ne '\''r"foo(\0051)foo"'\''|json -b8
r"foo())foo"$
$ echo -ne '\''r"foo(\0052)foo"'\''|json -b1
r"foo(*)foo"$
$ echo -ne '\''r"foo(\0052)foo"'\''|json -b2
r"foo(*)foo"$
$ echo -ne '\''r"foo(\0052)foo"'\''|json -b4
r"foo(*)foo"$
$ echo -ne '\''r"foo(\0052)foo"'\''|json -b8
r"foo(*)foo"$
$ echo -ne '\''r"foo(\0053)foo"'\''|json -b1
r"foo(+)foo"$
$ echo -ne '\''r"foo(\0053)foo"'\''|json -b2
r"foo(+)foo"$
$ echo -ne '\''r"foo(\0053)foo"'\''|json -b4
r"foo(+)foo"$
$ echo -ne '\''r"foo(\0053)foo"'\''|json -b8
r"foo(+)foo"$
$ echo -ne '\''r"foo(\0054)foo"'\''|json -b1
r"foo(,)foo"$
$ echo -ne '\''r"foo(\0054)foo"'\''|json -b2
r"foo(,)foo"$
$ echo -ne '\''r"foo(\0054)foo"'\''|json -b4
r"foo(,)foo"$
$ echo -ne '\''r"foo(\0054)foo"'\''|json -b8
r"foo(,)foo"$
$ echo -ne '\''r"foo(\0055)foo"'\''|json -b1
r"foo(-)foo"$
$ echo -ne '\''r"foo(\0055)foo"'\''|json -b2
r"foo(-)foo"$
$ echo -ne '\''r"foo(\0055)foo"'\''|json -b4
r"foo(-)foo"$
$ echo -ne '\''r"foo(\0055)foo"'\''|json -b8
r"foo(-)foo"$
$ echo -ne '\''r"foo(\0056)foo"'\''|json -b1
r"foo(.)foo"$
$ echo -ne '\''r"foo(\0056)foo"'\''|json -b2
r"foo(.)foo"$
$ echo -ne '\''r"foo(\0056)foo"'\''|json -b4
r"foo(.)foo"$
$ echo -ne '\''r"foo(\0056)foo"'\''|json -b8
r"foo(.)foo"$
$ echo -ne '\''r"foo(\0057)foo"'\''|json -b1
r"foo(/)foo"$
$ echo -ne '\''r"foo(\0057)foo"'\''|json -b2
r"foo(/)foo"$
$ echo -ne '\''r"foo(\0057)foo"'\''|json -b4
r"foo(/)foo"$
$ echo -ne '\''r"foo(\0057)foo"'\''|json -b8
r"foo(/)foo"$
$ echo -ne '\''r"foo(\0060)foo"'\''|json -b1
r"foo(0)foo"$
$ echo -ne '\''r"foo(\0060)foo"'\''|json -b2
r"foo(0)foo"$
$ echo -ne '\''r"foo(\0060)foo"'\''|json -b4
r"foo(0)foo"$
$ echo -ne '\''r"foo(\0060)foo"'\''|json -b8
r"foo(0)foo"$
$ echo -ne '\''r"foo(\0061)foo"'\''|json -b1
r"foo(1)foo"$
$ echo -ne '\''r"foo(\0061)foo"'\''|json -b2
r"foo(1)foo"$
$ echo -ne '\''r"foo(\0061)foo"'\''|json -b4
r"foo(1)foo"$
$ echo -ne '\''r"foo(\0061)foo"'\''|json -b8
r"foo(1)foo"$
$ echo -ne '\''r"foo(\0062)foo"'\''|json -b1
r"foo(2)foo"$
$ echo -ne '\''r"foo(\0062)foo"'\''|json -b2
r"foo(2)foo"$
$ echo -ne '\''r"foo(\0062)foo"'\''|json -b4
r"foo(2)foo"$
$ echo -ne '\''r"foo(\0062)foo"'\''|json -b8
r"foo(2)foo"$
$ echo -ne '\''r"foo(\0063)foo"'\''|json -b1
r"foo(3)foo"$
$ echo -ne '\''r"foo(\0063)foo"'\''|json -b2
r"foo(3)foo"$
$ echo -ne '\''r"foo(\0063)foo"'\''|json -b4
r"foo(3)foo"$
$ echo -ne '\''r"foo(\0063)foo"'\''|json -b8
r"foo(3)foo"$
$ echo -ne '\''r"foo(\0064)foo"'\''|json -b1
r"foo(4)foo"$
$ echo -ne '\''r"foo(\0064)foo"'\''|json -b2
r"foo(4)foo"$
$ echo -ne '\''r"foo(\0064)foo"'\''|json -b4
r"foo(4)foo"$
$ echo -ne '\''r"foo(\0064)foo"'\''|json -b8
r"foo(4)foo"$
$ echo -ne '\''r"foo(\0065)foo"'\''|json -b1
r"foo(5)foo"$
$ echo -ne '\''r"foo(\0065)foo"'\''|json -b2
r"foo(5)foo"$
$ echo -ne '\''r"foo(\0065)foo"'\''|json -b4
r"foo(5)foo"$
$ echo -ne '\''r"foo(\0065)foo"'\''|json -b8
r"foo(5)foo"$
$ echo -ne '\''r"foo(\0066)foo"'\''|json -b1
r"foo(6)foo"$
$ echo -ne '\''r"foo(\0066)foo"'\''|json -b2
r"foo(6)foo"$
$ echo -ne '\''r"foo(\0066)foo"'\''|json -b4
r"foo(6)foo"$
$ echo -ne '\''r"foo(\0066)foo"'\''|json -b8
r"foo(6)foo"$
$ echo -ne '\''r"foo(\0067)foo"'\''|json -b1
r"foo(7)foo"$
$ echo -ne '\''r"foo(\0067)foo"'\''|json -b2
r"foo(7)foo"$
$ echo -ne '\''r"foo(\0067)foo"'\''|json -b4
r"foo(7)foo"$
$ echo -ne '\''r"foo(\0067)foo"'\''|json -b8
r"foo(7)foo"$
$ echo -ne '\''r"foo(\0070)foo"'\''|json -b1
r"foo(8)foo"$
$ echo -ne '\''r"foo(\0070)foo"'\''|json -b2
r"foo(8)foo"$
$ echo -ne '\''r"foo(\0070)foo"'\''|json -b4
r"foo(8)foo"$
$ echo -ne '\''r"foo(\0070)foo"'\''|json -b8
r"foo(8)foo"$
$ echo -ne '\''r"foo(\0071)foo"'\''|json -b1
r"foo(9)foo"$
$ echo -ne '\''r"foo(\0071)foo"'\''|json -b2
r"foo(9)foo"$
$ echo -ne '\''r"foo(\0071)foo"'\''|json -b4
r"foo(9)foo"$
$ echo -ne '\''r"foo(\0071)foo"'\''|json -b8
r"foo(9)foo"$
$ echo -ne '\''r"foo(\0072)foo"'\''|json -b1
r"foo(:)foo"$
$ echo -ne '\''r"foo(\0072)foo"'\''|json -b2
r"foo(:)foo"$
$ echo -ne '\''r"foo(\0072)foo"'\''|json -b4
r"foo(:)foo"$
$ echo -ne '\''r"foo(\0072)foo"'\''|json -b8
r"foo(:)foo"$
$ echo -ne '\''r"foo(\0073)foo"'\''|json -b1
r"foo(;)foo"$
$ echo -ne '\''r"foo(\0073)foo"'\''|json -b2
r"foo(;)foo"$
$ echo -ne '\''r"foo(\0073)foo"'\''|json -b4
r"foo(;)foo"$
$ echo -ne '\''r"foo(\0073)foo"'\''|json -b8
r"foo(;)foo"$
$ echo -ne '\''r"foo(\0074)foo"'\''|json -b1
r"foo(<)foo"$
$ echo -ne '\''r"foo(\0074)foo"'\''|json -b2
r"foo(<)foo"$
$ echo -ne '\''r"foo(\0074)foo"'\''|json -b4
r"foo(<)foo"$
$ echo -ne '\''r"foo(\0074)foo"'\''|json -b8
r"foo(<)foo"$
$ echo -ne '\''r"foo(\0075)foo"'\''|json -b1
r"foo(=)foo"$
$ echo -ne '\''r"foo(\0075)foo"'\''|json -b2
r"foo(=)foo"$
$ echo -ne '\''r"foo(\0075)foo"'\''|json -b4
r"foo(=)foo"$
$ echo -ne '\''r"foo(\0075)foo"'\''|json -b8
r"foo(=)foo"$
$ echo -ne '\''r"foo(\0076)foo"'\''|json -b1
r"foo(>)foo"$
$ echo -ne '\''r"foo(\0076)foo"'\''|json -b2
r"foo(>)foo"$
$ echo -ne '\''r"foo(\0076)foo"'\''|json -b4
r"foo(>)foo"$
$ echo -ne '\''r"foo(\0076)foo"'\''|json -b8
r"foo(>)foo"$
$ echo -ne '\''r"foo(\0077)foo"'\''|json -b1
r"foo(?)foo"$
$ echo -ne '\''r"foo(\0077)foo"'\''|json -b2
r"foo(?)foo"$
$ echo -ne '\''r"foo(\0077)foo"'\''|json -b4
r"foo(?)foo"$
$ echo -ne '\''r"foo(\0077)foo"'\''|json -b8
r"foo(?)foo"$
$ echo -ne '\''r"foo(\0100)foo"'\''|json -b1
r"foo(@)foo"$
$ echo -ne '\''r"foo(\0100)foo"'\''|json -b2
r"foo(@)foo"$
$ echo -ne '\''r"foo(\0100)foo"'\''|json -b4
r"foo(@)foo"$
$ echo -ne '\''r"foo(\0100)foo"'\''|json -b8
r"foo(@)foo"$
$ echo -ne '\''r"foo(\0101)foo"'\''|json -b1
r"foo(A)foo"$
$ echo -ne '\''r"foo(\0101)foo"'\''|json -b2
r"foo(A)foo"$
$ echo -ne '\''r"foo(\0101)foo"'\''|json -b4
r"foo(A)foo"$
$ echo -ne '\''r"foo(\0101)foo"'\''|json -b8
r"foo(A)foo"$
$ echo -ne '\''r"foo(\0102)foo"'\''|json -b1
r"foo(B)foo"$
$ echo -ne '\''r"foo(\0102)foo"'\''|json -b2
r"foo(B)foo"$
$ echo -ne '\''r"foo(\0102)foo"'\''|json -b4
r"foo(B)foo"$
$ echo -ne '\''r"foo(\0102)foo"'\''|json -b8
r"foo(B)foo"$
$ echo -ne '\''r"foo(\0103)foo"'\''|json -b1
r"foo(C)foo"$
$ echo -ne '\''r"foo(\0103)foo"'\''|json -b2
r"foo(C)foo"$
$ echo -ne '\''r"foo(\0103)foo"'\''|json -b4
r"foo(C)foo"$
$ echo -ne '\''r"foo(\0103)foo"'\''|json -b8
r"foo(C)foo"$
$ echo -ne '\''r"foo(\0104)foo"'\''|json -b1
r"foo(D)foo"$
$ echo -ne '\''r"foo(\0104)foo"'\''|json -b2
r"foo(D)foo"$
$ echo -ne '\''r"foo(\0104)foo"'\''|json -b4
r"foo(D)foo"$
$ echo -ne '\''r"foo(\0104)foo"'\''|json -b8
r"foo(D)foo"$
$ echo -ne '\''r"foo(\0105)foo"'\''|json -b1
r"foo(E)foo"$
$ echo -ne '\''r"foo(\0105)foo"'\''|json -b2
r"foo(E)foo"$
$ echo -ne '\''r"foo(\0105)foo"'\''|json -b4
r"foo(E)foo"$
$ echo -ne '\''r"foo(\0105)foo"'\''|json -b8
r"foo(E)foo"$
$ echo -ne '\''r"foo(\0106)foo"'\''|json -b1
r"foo(F)foo"$
$ echo -ne '\''r"foo(\0106)foo"'\''|json -b2
r"foo(F)foo"$
$ echo -ne '\''r"foo(\0106)foo"'\''|json -b4
r"foo(F)foo"$
$ echo -ne '\''r"foo(\0106)foo"'\''|json -b8
r"foo(F)foo"$
$ echo -ne '\''r"foo(\0107)foo"'\''|json -b1
r"foo(G)foo"$
$ echo -ne '\''r"foo(\0107)foo"'\''|json -b2
r"foo(G)foo"$
$ echo -ne '\''r"foo(\0107)foo"'\''|json -b4
r"foo(G)foo"$
$ echo -ne '\''r"foo(\0107)foo"'\''|json -b8
r"foo(G)foo"$
$ echo -ne '\''r"foo(\0110)foo"'\''|json -b1
r"foo(H)foo"$
$ echo -ne '\''r"foo(\0110)foo"'\''|json -b2
r"foo(H)foo"$
$ echo -ne '\''r"foo(\0110)foo"'\''|json -b4
r"foo(H)foo"$
$ echo -ne '\''r"foo(\0110)foo"'\''|json -b8
r"foo(H)foo"$
$ echo -ne '\''r"foo(\0111)foo"'\''|json -b1
r"foo(I)foo"$
$ echo -ne '\''r"foo(\0111)foo"'\''|json -b2
r"foo(I)foo"$
$ echo -ne '\''r"foo(\0111)foo"'\''|json -b4
r"foo(I)foo"$
$ echo -ne '\''r"foo(\0111)foo"'\''|json -b8
r"foo(I)foo"$
$ echo -ne '\''r"foo(\0112)foo"'\''|json -b1
r"foo(J)foo"$
$ echo -ne '\''r"foo(\0112)foo"'\''|json -b2
r"foo(J)foo"$
$ echo -ne '\''r"foo(\0112)foo"'\''|json -b4
r"foo(J)foo"$
$ echo -ne '\''r"foo(\0112)foo"'\''|json -b8
r"foo(J)foo"$
$ echo -ne '\''r"foo(\0113)foo"'\''|json -b1
r"foo(K)foo"$
$ echo -ne '\''r"foo(\0113)foo"'\''|json -b2
r"foo(K)foo"$
$ echo -ne '\''r"foo(\0113)foo"'\''|json -b4
r"foo(K)foo"$
$ echo -ne '\''r"foo(\0113)foo"'\''|json -b8
r"foo(K)foo"$
$ echo -ne '\''r"foo(\0114)foo"'\''|json -b1
r"foo(L)foo"$
$ echo -ne '\''r"foo(\0114)foo"'\''|json -b2
r"foo(L)foo"$
$ echo -ne '\''r"foo(\0114)foo"'\''|json -b4
r"foo(L)foo"$
$ echo -ne '\''r"foo(\0114)foo"'\''|json -b8
r"foo(L)foo"$
$ echo -ne '\''r"foo(\0115)foo"'\''|json -b1
r"foo(M)foo"$
$ echo -ne '\''r"foo(\0115)foo"'\''|json -b2
r"foo(M)foo"$
$ echo -ne '\''r"foo(\0115)foo"'\''|json -b4
r"foo(M)foo"$
$ echo -ne '\''r"foo(\0115)foo"'\''|json -b8
r"foo(M)foo"$
$ echo -ne '\''r"foo(\0116)foo"'\''|json -b1
r"foo(N)foo"$
$ echo -ne '\''r"foo(\0116)foo"'\''|json -b2
r"foo(N)foo"$
$ echo -ne '\''r"foo(\0116)foo"'\''|json -b4
r"foo(N)foo"$
$ echo -ne '\''r"foo(\0116)foo"'\''|json -b8
r"foo(N)foo"$
$ echo -ne '\''r"foo(\0117)foo"'\''|json -b1
r"foo(O)foo"$
$ echo -ne '\''r"foo(\0117)foo"'\''|json -b2
r"foo(O)foo"$
$ echo -ne '\''r"foo(\0117)foo"'\''|json -b4
r"foo(O)foo"$
$ echo -ne '\''r"foo(\0117)foo"'\''|json -b8
r"foo(O)foo"$
$ echo -ne '\''r"foo(\0120)foo"'\''|json -b1
r"foo(P)foo"$
$ echo -ne '\''r"foo(\0120)foo"'\''|json -b2
r"foo(P)foo"$
$ echo -ne '\''r"foo(\0120)foo"'\''|json -b4
r"foo(P)foo"$
$ echo -ne '\''r"foo(\0120)foo"'\''|json -b8
r"foo(P)foo"$
$ echo -ne '\''r"foo(\0121)foo"'\''|json -b1
r"foo(Q)foo"$
$ echo -ne '\''r"foo(\0121)foo"'\''|json -b2
r"foo(Q)foo"$
$ echo -ne '\''r"foo(\0121)foo"'\''|json -b4
r"foo(Q)foo"$
$ echo -ne '\''r"foo(\0121)foo"'\''|json -b8
r"foo(Q)foo"$
$ echo -ne '\''r"foo(\0122)foo"'\''|json -b1
r"foo(R)foo"$
$ echo -ne '\''r"foo(\0122)foo"'\''|json -b2
r"foo(R)foo"$
$ echo -ne '\''r"foo(\0122)foo"'\''|json -b4
r"foo(R)foo"$
$ echo -ne '\''r"foo(\0122)foo"'\''|json -b8
r"foo(R)foo"$
$ echo -ne '\''r"foo(\0123)foo"'\''|json -b1
r"foo(S)foo"$
$ echo -ne '\''r"foo(\0123)foo"'\''|json -b2
r"foo(S)foo"$
$ echo -ne '\''r"foo(\0123)foo"'\''|json -b4
r"foo(S)foo"$
$ echo -ne '\''r"foo(\0123)foo"'\''|json -b8
r"foo(S)foo"$
$ echo -ne '\''r"foo(\0124)foo"'\''|json -b1
r"foo(T)foo"$
$ echo -ne '\''r"foo(\0124)foo"'\''|json -b2
r"foo(T)foo"$
$ echo -ne '\''r"foo(\0124)foo"'\''|json -b4
r"foo(T)foo"$
$ echo -ne '\''r"foo(\0124)foo"'\''|json -b8
r"foo(T)foo"$
$ echo -ne '\''r"foo(\0125)foo"'\''|json -b1
r"foo(U)foo"$
$ echo -ne '\''r"foo(\0125)foo"'\''|json -b2
r"foo(U)foo"$
$ echo -ne '\''r"foo(\0125)foo"'\''|json -b4
r"foo(U)foo"$
$ echo -ne '\''r"foo(\0125)foo"'\''|json -b8
r"foo(U)foo"$
$ echo -ne '\''r"foo(\0126)foo"'\''|json -b1
r"foo(V)foo"$
$ echo -ne '\''r"foo(\0126)foo"'\''|json -b2
r"foo(V)foo"$
$ echo -ne '\''r"foo(\0126)foo"'\''|json -b4
r"foo(V)foo"$
$ echo -ne '\''r"foo(\0126)foo"'\''|json -b8
r"foo(V)foo"$
$ echo -ne '\''r"foo(\0127)foo"'\''|json -b1
r"foo(W)foo"$
$ echo -ne '\''r"foo(\0127)foo"'\''|json -b2
r"foo(W)foo"$
$ echo -ne '\''r"foo(\0127)foo"'\''|json -b4
r"foo(W)foo"$
$ echo -ne '\''r"foo(\0127)foo"'\''|json -b8
r"foo(W)foo"$
$ echo -ne '\''r"foo(\0130)foo"'\''|json -b1
r"foo(X)foo"$
$ echo -ne '\''r"foo(\0130)foo"'\''|json -b2
r"foo(X)foo"$
$ echo -ne '\''r"foo(\0130)foo"'\''|json -b4
r"foo(X)foo"$
$ echo -ne '\''r"foo(\0130)foo"'\''|json -b8
r"foo(X)foo"$
$ echo -ne '\''r"foo(\0131)foo"'\''|json -b1
r"foo(Y)foo"$
$ echo -ne '\''r"foo(\0131)foo"'\''|json -b2
r"foo(Y)foo"$
$ echo -ne '\''r"foo(\0131)foo"'\''|json -b4
r"foo(Y)foo"$
$ echo -ne '\''r"foo(\0131)foo"'\''|json -b8
r"foo(Y)foo"$
$ echo -ne '\''r"foo(\0132)foo"'\''|json -b1
r"foo(Z)foo"$
$ echo -ne '\''r"foo(\0132)foo"'\''|json -b2
r"foo(Z)foo"$
$ echo -ne '\''r"foo(\0132)foo"'\''|json -b4
r"foo(Z)foo"$
$ echo -ne '\''r"foo(\0132)foo"'\''|json -b8
r"foo(Z)foo"$
$ echo -ne '\''r"foo(\0133)foo"'\''|json -b1
r"foo([)foo"$
$ echo -ne '\''r"foo(\0133)foo"'\''|json -b2
r"foo([)foo"$
$ echo -ne '\''r"foo(\0133)foo"'\''|json -b4
r"foo([)foo"$
$ echo -ne '\''r"foo(\0133)foo"'\''|json -b8
r"foo([)foo"$
$ echo -ne '\''r"foo(\0134)foo"'\''|json -b1
r"foo(\\)foo"$
$ echo -ne '\''r"foo(\0134)foo"'\''|json -b2
r"foo(\\)foo"$
$ echo -ne '\''r"foo(\0134)foo"'\''|json -b4
r"foo(\\)foo"$
$ echo -ne '\''r"foo(\0134)foo"'\''|json -b8
r"foo(\\)foo"$
$ echo -ne '\''r"foo(\0135)foo"'\''|json -b1
r"foo(])foo"$
$ echo -ne '\''r"foo(\0135)foo"'\''|json -b2
r"foo(])foo"$
$ echo -ne '\''r"foo(\0135)foo"'\''|json -b4
r"foo(])foo"$
$ echo -ne '\''r"foo(\0135)foo"'\''|json -b8
r"foo(])foo"$
$ echo -ne '\''r"foo(\0136)foo"'\''|json -b1
r"foo(^)foo"$
$ echo -ne '\''r"foo(\0136)foo"'\''|json -b2
r"foo(^)foo"$
$ echo -ne '\''r"foo(\0136)foo"'\''|json -b4
r"foo(^)foo"$
$ echo -ne '\''r"foo(\0136)foo"'\''|json -b8
r"foo(^)foo"$
$ echo -ne '\''r"foo(\0137)foo"'\''|json -b1
r"foo(_)foo"$
$ echo -ne '\''r"foo(\0137)foo"'\''|json -b2
r"foo(_)foo"$
$ echo -ne '\''r"foo(\0137)foo"'\''|json -b4
r"foo(_)foo"$
$ echo -ne '\''r"foo(\0137)foo"'\''|json -b8
r"foo(_)foo"$
$ echo -ne '\''r"foo(\0140)foo"'\''|json -b1
r"foo(`)foo"$
$ echo -ne '\''r"foo(\0140)foo"'\''|json -b2
r"foo(`)foo"$
$ echo -ne '\''r"foo(\0140)foo"'\''|json -b4
r"foo(`)foo"$
$ echo -ne '\''r"foo(\0140)foo"'\''|json -b8
r"foo(`)foo"$
$ echo -ne '\''r"foo(\0141)foo"'\''|json -b1
r"foo(a)foo"$
$ echo -ne '\''r"foo(\0141)foo"'\''|json -b2
r"foo(a)foo"$
$ echo -ne '\''r"foo(\0141)foo"'\''|json -b4
r"foo(a)foo"$
$ echo -ne '\''r"foo(\0141)foo"'\''|json -b8
r"foo(a)foo"$
$ echo -ne '\''r"foo(\0142)foo"'\''|json -b1
r"foo(b)foo"$
$ echo -ne '\''r"foo(\0142)foo"'\''|json -b2
r"foo(b)foo"$
$ echo -ne '\''r"foo(\0142)foo"'\''|json -b4
r"foo(b)foo"$
$ echo -ne '\''r"foo(\0142)foo"'\''|json -b8
r"foo(b)foo"$
$ echo -ne '\''r"foo(\0143)foo"'\''|json -b1
r"foo(c)foo"$
$ echo -ne '\''r"foo(\0143)foo"'\''|json -b2
r"foo(c)foo"$
$ echo -ne '\''r"foo(\0143)foo"'\''|json -b4
r"foo(c)foo"$
$ echo -ne '\''r"foo(\0143)foo"'\''|json -b8
r"foo(c)foo"$
$ echo -ne '\''r"foo(\0144)foo"'\''|json -b1
r"foo(d)foo"$
$ echo -ne '\''r"foo(\0144)foo"'\''|json -b2
r"foo(d)foo"$
$ echo -ne '\''r"foo(\0144)foo"'\''|json -b4
r"foo(d)foo"$
$ echo -ne '\''r"foo(\0144)foo"'\''|json -b8
r"foo(d)foo"$
$ echo -ne '\''r"foo(\0145)foo"'\''|json -b1
r"foo(e)foo"$
$ echo -ne '\''r"foo(\0145)foo"'\''|json -b2
r"foo(e)foo"$
$ echo -ne '\''r"foo(\0145)foo"'\''|json -b4
r"foo(e)foo"$
$ echo -ne '\''r"foo(\0145)foo"'\''|json -b8
r"foo(e)foo"$
$ echo -ne '\''r"foo(\0146)foo"'\''|json -b1
r"foo(f)foo"$
$ echo -ne '\''r"foo(\0146)foo"'\''|json -b2
r"foo(f)foo"$
$ echo -ne '\''r"foo(\0146)foo"'\''|json -b4
r"foo(f)foo"$
$ echo -ne '\''r"foo(\0146)foo"'\''|json -b8
r"foo(f)foo"$
$ echo -ne '\''r"foo(\0147)foo"'\''|json -b1
r"foo(g)foo"$
$ echo -ne '\''r"foo(\0147)foo"'\''|json -b2
r"foo(g)foo"$
$ echo -ne '\''r"foo(\0147)foo"'\''|json -b4
r"foo(g)foo"$
$ echo -ne '\''r"foo(\0147)foo"'\''|json -b8
r"foo(g)foo"$
$ echo -ne '\''r"foo(\0150)foo"'\''|json -b1
r"foo(h)foo"$
$ echo -ne '\''r"foo(\0150)foo"'\''|json -b2
r"foo(h)foo"$
$ echo -ne '\''r"foo(\0150)foo"'\''|json -b4
r"foo(h)foo"$
$ echo -ne '\''r"foo(\0150)foo"'\''|json -b8
r"foo(h)foo"$
$ echo -ne '\''r"foo(\0151)foo"'\''|json -b1
r"foo(i)foo"$
$ echo -ne '\''r"foo(\0151)foo"'\''|json -b2
r"foo(i)foo"$
$ echo -ne '\''r"foo(\0151)foo"'\''|json -b4
r"foo(i)foo"$
$ echo -ne '\''r"foo(\0151)foo"'\''|json -b8
r"foo(i)foo"$
$ echo -ne '\''r"foo(\0152)foo"'\''|json -b1
r"foo(j)foo"$
$ echo -ne '\''r"foo(\0152)foo"'\''|json -b2
r"foo(j)foo"$
$ echo -ne '\''r"foo(\0152)foo"'\''|json -b4
r"foo(j)foo"$
$ echo -ne '\''r"foo(\0152)foo"'\''|json -b8
r"foo(j)foo"$
$ echo -ne '\''r"foo(\0153)foo"'\''|json -b1
r"foo(k)foo"$
$ echo -ne '\''r"foo(\0153)foo"'\''|json -b2
r"foo(k)foo"$
$ echo -ne '\''r"foo(\0153)foo"'\''|json -b4
r"foo(k)foo"$
$ echo -ne '\''r"foo(\0153)foo"'\''|json -b8
r"foo(k)foo"$
$ echo -ne '\''r"foo(\0154)foo"'\''|json -b1
r"foo(l)foo"$
$ echo -ne '\''r"foo(\0154)foo"'\''|json -b2
r"foo(l)foo"$
$ echo -ne '\''r"foo(\0154)foo"'\''|json -b4
r"foo(l)foo"$
$ echo -ne '\''r"foo(\0154)foo"'\''|json -b8
r"foo(l)foo"$
$ echo -ne '\''r"foo(\0155)foo"'\''|json -b1
r"foo(m)foo"$
$ echo -ne '\''r"foo(\0155)foo"'\''|json -b2
r"foo(m)foo"$
$ echo -ne '\''r"foo(\0155)foo"'\''|json -b4
r"foo(m)foo"$
$ echo -ne '\''r"foo(\0155)foo"'\''|json -b8
r"foo(m)foo"$
$ echo -ne '\''r"foo(\0156)foo"'\''|json -b1
r"foo(n)foo"$
$ echo -ne '\''r"foo(\0156)foo"'\''|json -b2
r"foo(n)foo"$
$ echo -ne '\''r"foo(\0156)foo"'\''|json -b4
r"foo(n)foo"$
$ echo -ne '\''r"foo(\0156)foo"'\''|json -b8
r"foo(n)foo"$
$ echo -ne '\''r"foo(\0157)foo"'\''|json -b1
r"foo(o)foo"$
$ echo -ne '\''r"foo(\0157)foo"'\''|json -b2
r"foo(o)foo"$
$ echo -ne '\''r"foo(\0157)foo"'\''|json -b4
r"foo(o)foo"$
$ echo -ne '\''r"foo(\0157)foo"'\''|json -b8
r"foo(o)foo"$
$ echo -ne '\''r"foo(\0160)foo"'\''|json -b1
r"foo(p)foo"$
$ echo -ne '\''r"foo(\0160)foo"'\''|json -b2
r"foo(p)foo"$
$ echo -ne '\''r"foo(\0160)foo"'\''|json -b4
r"foo(p)foo"$
$ echo -ne '\''r"foo(\0160)foo"'\''|json -b8
r"foo(p)foo"$
$ echo -ne '\''r"foo(\0161)foo"'\''|json -b1
r"foo(q)foo"$
$ echo -ne '\''r"foo(\0161)foo"'\''|json -b2
r"foo(q)foo"$
$ echo -ne '\''r"foo(\0161)foo"'\''|json -b4
r"foo(q)foo"$
$ echo -ne '\''r"foo(\0161)foo"'\''|json -b8
r"foo(q)foo"$
$ echo -ne '\''r"foo(\0162)foo"'\''|json -b1
r"foo(r)foo"$
$ echo -ne '\''r"foo(\0162)foo"'\''|json -b2
r"foo(r)foo"$
$ echo -ne '\''r"foo(\0162)foo"'\''|json -b4
r"foo(r)foo"$
$ echo -ne '\''r"foo(\0162)foo"'\''|json -b8
r"foo(r)foo"$
$ echo -ne '\''r"foo(\0163)foo"'\''|json -b1
r"foo(s)foo"$
$ echo -ne '\''r"foo(\0163)foo"'\''|json -b2
r"foo(s)foo"$
$ echo -ne '\''r"foo(\0163)foo"'\''|json -b4
r"foo(s)foo"$
$ echo -ne '\''r"foo(\0163)foo"'\''|json -b8
r"foo(s)foo"$
$ echo -ne '\''r"foo(\0164)foo"'\''|json -b1
r"foo(t)foo"$
$ echo -ne '\''r"foo(\0164)foo"'\''|json -b2
r"foo(t)foo"$
$ echo -ne '\''r"foo(\0164)foo"'\''|json -b4
r"foo(t)foo"$
$ echo -ne '\''r"foo(\0164)foo"'\''|json -b8
r"foo(t)foo"$
$ echo -ne '\''r"foo(\0165)foo"'\''|json -b1
r"foo(u)foo"$
$ echo -ne '\''r"foo(\0165)foo"'\''|json -b2
r"foo(u)foo"$
$ echo -ne '\''r"foo(\0165)foo"'\''|json -b4
r"foo(u)foo"$
$ echo -ne '\''r"foo(\0165)foo"'\''|json -b8
r"foo(u)foo"$
$ echo -ne '\''r"foo(\0166)foo"'\''|json -b1
r"foo(v)foo"$
$ echo -ne '\''r"foo(\0166)foo"'\''|json -b2
r"foo(v)foo"$
$ echo -ne '\''r"foo(\0166)foo"'\''|json -b4
r"foo(v)foo"$
$ echo -ne '\''r"foo(\0166)foo"'\''|json -b8
r"foo(v)foo"$
$ echo -ne '\''r"foo(\0167)foo"'\''|json -b1
r"foo(w)foo"$
$ echo -ne '\''r"foo(\0167)foo"'\''|json -b2
r"foo(w)foo"$
$ echo -ne '\''r"foo(\0167)foo"'\''|json -b4
r"foo(w)foo"$
$ echo -ne '\''r"foo(\0167)foo"'\''|json -b8
r"foo(w)foo"$
$ echo -ne '\''r"foo(\0170)foo"'\''|json -b1
r"foo(x)foo"$
$ echo -ne '\''r"foo(\0170)foo"'\''|json -b2
r"foo(x)foo"$
$ echo -ne '\''r"foo(\0170)foo"'\''|json -b4
r"foo(x)foo"$
$ echo -ne '\''r"foo(\0170)foo"'\''|json -b8
r"foo(x)foo"$
$ echo -ne '\''r"foo(\0171)foo"'\''|json -b1
r"foo(y)foo"$
$ echo -ne '\''r"foo(\0171)foo"'\''|json -b2
r"foo(y)foo"$
$ echo -ne '\''r"foo(\0171)foo"'\''|json -b4
r"foo(y)foo"$
$ echo -ne '\''r"foo(\0171)foo"'\''|json -b8
r"foo(y)foo"$
$ echo -ne '\''r"foo(\0172)foo"'\''|json -b1
r"foo(z)foo"$
$ echo -ne '\''r"foo(\0172)foo"'\''|json -b2
r"foo(z)foo"$
$ echo -ne '\''r"foo(\0172)foo"'\''|json -b4
r"foo(z)foo"$
$ echo -ne '\''r"foo(\0172)foo"'\''|json -b8
r"foo(z)foo"$
$ echo -ne '\''r"foo(\0173)foo"'\''|json -b1
r"foo({)foo"$
$ echo -ne '\''r"foo(\0173)foo"'\''|json -b2
r"foo({)foo"$
$ echo -ne '\''r"foo(\0173)foo"'\''|json -b4
r"foo({)foo"$
$ echo -ne '\''r"foo(\0173)foo"'\''|json -b8
r"foo({)foo"$
$ echo -ne '\''r"foo(\0174)foo"'\''|json -b1
r"foo(|)foo"$
$ echo -ne '\''r"foo(\0174)foo"'\''|json -b2
r"foo(|)foo"$
$ echo -ne '\''r"foo(\0174)foo"'\''|json -b4
r"foo(|)foo"$
$ echo -ne '\''r"foo(\0174)foo"'\''|json -b8
r"foo(|)foo"$
$ echo -ne '\''r"foo(\0175)foo"'\''|json -b1
r"foo(})foo"$
$ echo -ne '\''r"foo(\0175)foo"'\''|json -b2
r"foo(})foo"$
$ echo -ne '\''r"foo(\0175)foo"'\''|json -b4
r"foo(})foo"$
$ echo -ne '\''r"foo(\0175)foo"'\''|json -b8
r"foo(})foo"$
$ echo -ne '\''r"foo(\0176)foo"'\''|json -b1
r"foo(~)foo"$
$ echo -ne '\''r"foo(\0176)foo"'\''|json -b2
r"foo(~)foo"$
$ echo -ne '\''r"foo(\0176)foo"'\''|json -b4
r"foo(~)foo"$
$ echo -ne '\''r"foo(\0176)foo"'\''|json -b8
r"foo(~)foo"$
$ echo -ne '\''r"foo(\0177)foo"'\''|json -b1
r"foo(\177)foo"$
$ echo -ne '\''r"foo(\0177)foo"'\''|json -b2
r"foo(\177)foo"$
$ echo -ne '\''r"foo(\0177)foo"'\''|json -b4
r"foo(\177)foo"$
$ echo -ne '\''r"foo(\0177)foo"'\''|json -b8
r"foo(\177)foo"$
$ echo -ne '\''r"foo(\0200)foo"'\''|json -b1
r"foo(\200)foo"$
$ echo -ne '\''r"foo(\0200)foo"'\''|json -b2
r"foo(\200)foo"$
$ echo -ne '\''r"foo(\0200)foo"'\''|json -b4
r"foo(\200)foo"$
$ echo -ne '\''r"foo(\0200)foo"'\''|json -b8
r"foo(\200)foo"$
$ echo -ne '\''r"foo(\0201)foo"'\''|json -b1
r"foo(\201)foo"$
$ echo -ne '\''r"foo(\0201)foo"'\''|json -b2
r"foo(\201)foo"$
$ echo -ne '\''r"foo(\0201)foo"'\''|json -b4
r"foo(\201)foo"$
$ echo -ne '\''r"foo(\0201)foo"'\''|json -b8
r"foo(\201)foo"$
$ echo -ne '\''r"foo(\0202)foo"'\''|json -b1
r"foo(\202)foo"$
$ echo -ne '\''r"foo(\0202)foo"'\''|json -b2
r"foo(\202)foo"$
$ echo -ne '\''r"foo(\0202)foo"'\''|json -b4
r"foo(\202)foo"$
$ echo -ne '\''r"foo(\0202)foo"'\''|json -b8
r"foo(\202)foo"$
$ echo -ne '\''r"foo(\0203)foo"'\''|json -b1
r"foo(\203)foo"$
$ echo -ne '\''r"foo(\0203)foo"'\''|json -b2
r"foo(\203)foo"$
$ echo -ne '\''r"foo(\0203)foo"'\''|json -b4
r"foo(\203)foo"$
$ echo -ne '\''r"foo(\0203)foo"'\''|json -b8
r"foo(\203)foo"$
$ echo -ne '\''r"foo(\0204)foo"'\''|json -b1
r"foo(\204)foo"$
$ echo -ne '\''r"foo(\0204)foo"'\''|json -b2
r"foo(\204)foo"$
$ echo -ne '\''r"foo(\0204)foo"'\''|json -b4
r"foo(\204)foo"$
$ echo -ne '\''r"foo(\0204)foo"'\''|json -b8
r"foo(\204)foo"$
$ echo -ne '\''r"foo(\0205)foo"'\''|json -b1
r"foo(\205)foo"$
$ echo -ne '\''r"foo(\0205)foo"'\''|json -b2
r"foo(\205)foo"$
$ echo -ne '\''r"foo(\0205)foo"'\''|json -b4
r"foo(\205)foo"$
$ echo -ne '\''r"foo(\0205)foo"'\''|json -b8
r"foo(\205)foo"$
$ echo -ne '\''r"foo(\0206)foo"'\''|json -b1
r"foo(\206)foo"$
$ echo -ne '\''r"foo(\0206)foo"'\''|json -b2
r"foo(\206)foo"$
$ echo -ne '\''r"foo(\0206)foo"'\''|json -b4
r"foo(\206)foo"$
$ echo -ne '\''r"foo(\0206)foo"'\''|json -b8
r"foo(\206)foo"$
$ echo -ne '\''r"foo(\0207)foo"'\''|json -b1
r"foo(\207)foo"$
$ echo -ne '\''r"foo(\0207)foo"'\''|json -b2
r"foo(\207)foo"$
$ echo -ne '\''r"foo(\0207)foo"'\''|json -b4
r"foo(\207)foo"$
$ echo -ne '\''r"foo(\0207)foo"'\''|json -b8
r"foo(\207)foo"$
$ echo -ne '\''r"foo(\0210)foo"'\''|json -b1
r"foo(\210)foo"$
$ echo -ne '\''r"foo(\0210)foo"'\''|json -b2
r"foo(\210)foo"$
$ echo -ne '\''r"foo(\0210)foo"'\''|json -b4
r"foo(\210)foo"$
$ echo -ne '\''r"foo(\0210)foo"'\''|json -b8
r"foo(\210)foo"$
$ echo -ne '\''r"foo(\0211)foo"'\''|json -b1
r"foo(\211)foo"$
$ echo -ne '\''r"foo(\0211)foo"'\''|json -b2
r"foo(\211)foo"$
$ echo -ne '\''r"foo(\0211)foo"'\''|json -b4
r"foo(\211)foo"$
$ echo -ne '\''r"foo(\0211)foo"'\''|json -b8
r"foo(\211)foo"$
$ echo -ne '\''r"foo(\0212)foo"'\''|json -b1
r"foo(\212)foo"$
$ echo -ne '\''r"foo(\0212)foo"'\''|json -b2
r"foo(\212)foo"$
$ echo -ne '\''r"foo(\0212)foo"'\''|json -b4
r"foo(\212)foo"$
$ echo -ne '\''r"foo(\0212)foo"'\''|json -b8
r"foo(\212)foo"$
$ echo -ne '\''r"foo(\0213)foo"'\''|json -b1
r"foo(\213)foo"$
$ echo -ne '\''r"foo(\0213)foo"'\''|json -b2
r"foo(\213)foo"$
$ echo -ne '\''r"foo(\0213)foo"'\''|json -b4
r"foo(\213)foo"$
$ echo -ne '\''r"foo(\0213)foo"'\''|json -b8
r"foo(\213)foo"$
$ echo -ne '\''r"foo(\0214)foo"'\''|json -b1
r"foo(\214)foo"$
$ echo -ne '\''r"foo(\0214)foo"'\''|json -b2
r"foo(\214)foo"$
$ echo -ne '\''r"foo(\0214)foo"'\''|json -b4
r"foo(\214)foo"$
$ echo -ne '\''r"foo(\0214)foo"'\''|json -b8
r"foo(\214)foo"$
$ echo -ne '\''r"foo(\0215)foo"'\''|json -b1
r"foo(\215)foo"$
$ echo -ne '\''r"foo(\0215)foo"'\''|json -b2
r"foo(\215)foo"$
$ echo -ne '\''r"foo(\0215)foo"'\''|json -b4
r"foo(\215)foo"$
$ echo -ne '\''r"foo(\0215)foo"'\''|json -b8
r"foo(\215)foo"$
$ echo -ne '\''r"foo(\0216)foo"'\''|json -b1
r"foo(\216)foo"$
$ echo -ne '\''r"foo(\0216)foo"'\''|json -b2
r"foo(\216)foo"$
$ echo -ne '\''r"foo(\0216)foo"'\''|json -b4
r"foo(\216)foo"$
$ echo -ne '\''r"foo(\0216)foo"'\''|json -b8
r"foo(\216)foo"$
$ echo -ne '\''r"foo(\0217)foo"'\''|json -b1
r"foo(\217)foo"$
$ echo -ne '\''r"foo(\0217)foo"'\''|json -b2
r"foo(\217)foo"$
$ echo -ne '\''r"foo(\0217)foo"'\''|json -b4
r"foo(\217)foo"$
$ echo -ne '\''r"foo(\0217)foo"'\''|json -b8
r"foo(\217)foo"$
$ echo -ne '\''r"foo(\0220)foo"'\''|json -b1
r"foo(\220)foo"$
$ echo -ne '\''r"foo(\0220)foo"'\''|json -b2
r"foo(\220)foo"$
$ echo -ne '\''r"foo(\0220)foo"'\''|json -b4
r"foo(\220)foo"$
$ echo -ne '\''r"foo(\0220)foo"'\''|json -b8
r"foo(\220)foo"$
$ echo -ne '\''r"foo(\0221)foo"'\''|json -b1
r"foo(\221)foo"$
$ echo -ne '\''r"foo(\0221)foo"'\''|json -b2
r"foo(\221)foo"$
$ echo -ne '\''r"foo(\0221)foo"'\''|json -b4
r"foo(\221)foo"$
$ echo -ne '\''r"foo(\0221)foo"'\''|json -b8
r"foo(\221)foo"$
$ echo -ne '\''r"foo(\0222)foo"'\''|json -b1
r"foo(\222)foo"$
$ echo -ne '\''r"foo(\0222)foo"'\''|json -b2
r"foo(\222)foo"$
$ echo -ne '\''r"foo(\0222)foo"'\''|json -b4
r"foo(\222)foo"$
$ echo -ne '\''r"foo(\0222)foo"'\''|json -b8
r"foo(\222)foo"$
$ echo -ne '\''r"foo(\0223)foo"'\''|json -b1
r"foo(\223)foo"$
$ echo -ne '\''r"foo(\0223)foo"'\''|json -b2
r"foo(\223)foo"$
$ echo -ne '\''r"foo(\0223)foo"'\''|json -b4
r"foo(\223)foo"$
$ echo -ne '\''r"foo(\0223)foo"'\''|json -b8
r"foo(\223)foo"$
$ echo -ne '\''r"foo(\0224)foo"'\''|json -b1
r"foo(\224)foo"$
$ echo -ne '\''r"foo(\0224)foo"'\''|json -b2
r"foo(\224)foo"$
$ echo -ne '\''r"foo(\0224)foo"'\''|json -b4
r"foo(\224)foo"$
$ echo -ne '\''r"foo(\0224)foo"'\''|json -b8
r"foo(\224)foo"$
$ echo -ne '\''r"foo(\0225)foo"'\''|json -b1
r"foo(\225)foo"$
$ echo -ne '\''r"foo(\0225)foo"'\''|json -b2
r"foo(\225)foo"$
$ echo -ne '\''r"foo(\0225)foo"'\''|json -b4
r"foo(\225)foo"$
$ echo -ne '\''r"foo(\0225)foo"'\''|json -b8
r"foo(\225)foo"$
$ echo -ne '\''r"foo(\0226)foo"'\''|json -b1
r"foo(\226)foo"$
$ echo -ne '\''r"foo(\0226)foo"'\''|json -b2
r"foo(\226)foo"$
$ echo -ne '\''r"foo(\0226)foo"'\''|json -b4
r"foo(\226)foo"$
$ echo -ne '\''r"foo(\0226)foo"'\''|json -b8
r"foo(\226)foo"$
$ echo -ne '\''r"foo(\0227)foo"'\''|json -b1
r"foo(\227)foo"$
$ echo -ne '\''r"foo(\0227)foo"'\''|json -b2
r"foo(\227)foo"$
$ echo -ne '\''r"foo(\0227)foo"'\''|json -b4
r"foo(\227)foo"$
$ echo -ne '\''r"foo(\0227)foo"'\''|json -b8
r"foo(\227)foo"$
$ echo -ne '\''r"foo(\0230)foo"'\''|json -b1
r"foo(\230)foo"$
$ echo -ne '\''r"foo(\0230)foo"'\''|json -b2
r"foo(\230)foo"$
$ echo -ne '\''r"foo(\0230)foo"'\''|json -b4
r"foo(\230)foo"$
$ echo -ne '\''r"foo(\0230)foo"'\''|json -b8
r"foo(\230)foo"$
$ echo -ne '\''r"foo(\0231)foo"'\''|json -b1
r"foo(\231)foo"$
$ echo -ne '\''r"foo(\0231)foo"'\''|json -b2
r"foo(\231)foo"$
$ echo -ne '\''r"foo(\0231)foo"'\''|json -b4
r"foo(\231)foo"$
$ echo -ne '\''r"foo(\0231)foo"'\''|json -b8
r"foo(\231)foo"$
$ echo -ne '\''r"foo(\0232)foo"'\''|json -b1
r"foo(\232)foo"$
$ echo -ne '\''r"foo(\0232)foo"'\''|json -b2
r"foo(\232)foo"$
$ echo -ne '\''r"foo(\0232)foo"'\''|json -b4
r"foo(\232)foo"$
$ echo -ne '\''r"foo(\0232)foo"'\''|json -b8
r"foo(\232)foo"$
$ echo -ne '\''r"foo(\0233)foo"'\''|json -b1
r"foo(\233)foo"$
$ echo -ne '\''r"foo(\0233)foo"'\''|json -b2
r"foo(\233)foo"$
$ echo -ne '\''r"foo(\0233)foo"'\''|json -b4
r"foo(\233)foo"$
$ echo -ne '\''r"foo(\0233)foo"'\''|json -b8
r"foo(\233)foo"$
$ echo -ne '\''r"foo(\0234)foo"'\''|json -b1
r"foo(\234)foo"$
$ echo -ne '\''r"foo(\0234)foo"'\''|json -b2
r"foo(\234)foo"$
$ echo -ne '\''r"foo(\0234)foo"'\''|json -b4
r"foo(\234)foo"$
$ echo -ne '\''r"foo(\0234)foo"'\''|json -b8
r"foo(\234)foo"$
$ echo -ne '\''r"foo(\0235)foo"'\''|json -b1
r"foo(\235)foo"$
$ echo -ne '\''r"foo(\0235)foo"'\''|json -b2
r"foo(\235)foo"$
$ echo -ne '\''r"foo(\0235)foo"'\''|json -b4
r"foo(\235)foo"$
$ echo -ne '\''r"foo(\0235)foo"'\''|json -b8
r"foo(\235)foo"$
$ echo -ne '\''r"foo(\0236)foo"'\''|json -b1
r"foo(\236)foo"$
$ echo -ne '\''r"foo(\0236)foo"'\''|json -b2
r"foo(\236)foo"$
$ echo -ne '\''r"foo(\0236)foo"'\''|json -b4
r"foo(\236)foo"$
$ echo -ne '\''r"foo(\0236)foo"'\''|json -b8
r"foo(\236)foo"$
$ echo -ne '\''r"foo(\0237)foo"'\''|json -b1
r"foo(\237)foo"$
$ echo -ne '\''r"foo(\0237)foo"'\''|json -b2
r"foo(\237)foo"$
$ echo -ne '\''r"foo(\0237)foo"'\''|json -b4
r"foo(\237)foo"$
$ echo -ne '\''r"foo(\0237)foo"'\''|json -b8
r"foo(\237)foo"$
$ echo -ne '\''r"foo(\0240)foo"'\''|json -b1
r"foo(\240)foo"$
$ echo -ne '\''r"foo(\0240)foo"'\''|json -b2
r"foo(\240)foo"$
$ echo -ne '\''r"foo(\0240)foo"'\''|json -b4
r"foo(\240)foo"$
$ echo -ne '\''r"foo(\0240)foo"'\''|json -b8
r"foo(\240)foo"$
$ echo -ne '\''r"foo(\0241)foo"'\''|json -b1
r"foo(\241)foo"$
$ echo -ne '\''r"foo(\0241)foo"'\''|json -b2
r"foo(\241)foo"$
$ echo -ne '\''r"foo(\0241)foo"'\''|json -b4
r"foo(\241)foo"$
$ echo -ne '\''r"foo(\0241)foo"'\''|json -b8
r"foo(\241)foo"$
$ echo -ne '\''r"foo(\0242)foo"'\''|json -b1
r"foo(\242)foo"$
$ echo -ne '\''r"foo(\0242)foo"'\''|json -b2
r"foo(\242)foo"$
$ echo -ne '\''r"foo(\0242)foo"'\''|json -b4
r"foo(\242)foo"$
$ echo -ne '\''r"foo(\0242)foo"'\''|json -b8
r"foo(\242)foo"$
$ echo -ne '\''r"foo(\0243)foo"'\''|json -b1
r"foo(\243)foo"$
$ echo -ne '\''r"foo(\0243)foo"'\''|json -b2
r"foo(\243)foo"$
$ echo -ne '\''r"foo(\0243)foo"'\''|json -b4
r"foo(\243)foo"$
$ echo -ne '\''r"foo(\0243)foo"'\''|json -b8
r"foo(\243)foo"$
$ echo -ne '\''r"foo(\0244)foo"'\''|json -b1
r"foo(\244)foo"$
$ echo -ne '\''r"foo(\0244)foo"'\''|json -b2
r"foo(\244)foo"$
$ echo -ne '\''r"foo(\0244)foo"'\''|json -b4
r"foo(\244)foo"$
$ echo -ne '\''r"foo(\0244)foo"'\''|json -b8
r"foo(\244)foo"$
$ echo -ne '\''r"foo(\0245)foo"'\''|json -b1
r"foo(\245)foo"$
$ echo -ne '\''r"foo(\0245)foo"'\''|json -b2
r"foo(\245)foo"$
$ echo -ne '\''r"foo(\0245)foo"'\''|json -b4
r"foo(\245)foo"$
$ echo -ne '\''r"foo(\0245)foo"'\''|json -b8
r"foo(\245)foo"$
$ echo -ne '\''r"foo(\0246)foo"'\''|json -b1
r"foo(\246)foo"$
$ echo -ne '\''r"foo(\0246)foo"'\''|json -b2
r"foo(\246)foo"$
$ echo -ne '\''r"foo(\0246)foo"'\''|json -b4
r"foo(\246)foo"$
$ echo -ne '\''r"foo(\0246)foo"'\''|json -b8
r"foo(\246)foo"$
$ echo -ne '\''r"foo(\0247)foo"'\''|json -b1
r"foo(\247)foo"$
$ echo -ne '\''r"foo(\0247)foo"'\''|json -b2
r"foo(\247)foo"$
$ echo -ne '\''r"foo(\0247)foo"'\''|json -b4
r"foo(\247)foo"$
$ echo -ne '\''r"foo(\0247)foo"'\''|json -b8
r"foo(\247)foo"$
$ echo -ne '\''r"foo(\0250)foo"'\''|json -b1
r"foo(\250)foo"$
$ echo -ne '\''r"foo(\0250)foo"'\''|json -b2
r"foo(\250)foo"$
$ echo -ne '\''r"foo(\0250)foo"'\''|json -b4
r"foo(\250)foo"$
$ echo -ne '\''r"foo(\0250)foo"'\''|json -b8
r"foo(\250)foo"$
$ echo -ne '\''r"foo(\0251)foo"'\''|json -b1
r"foo(\251)foo"$
$ echo -ne '\''r"foo(\0251)foo"'\''|json -b2
r"foo(\251)foo"$
$ echo -ne '\''r"foo(\0251)foo"'\''|json -b4
r"foo(\251)foo"$
$ echo -ne '\''r"foo(\0251)foo"'\''|json -b8
r"foo(\251)foo"$
$ echo -ne '\''r"foo(\0252)foo"'\''|json -b1
r"foo(\252)foo"$
$ echo -ne '\''r"foo(\0252)foo"'\''|json -b2
r"foo(\252)foo"$
$ echo -ne '\''r"foo(\0252)foo"'\''|json -b4
r"foo(\252)foo"$
$ echo -ne '\''r"foo(\0252)foo"'\''|json -b8
r"foo(\252)foo"$
$ echo -ne '\''r"foo(\0253)foo"'\''|json -b1
r"foo(\253)foo"$
$ echo -ne '\''r"foo(\0253)foo"'\''|json -b2
r"foo(\253)foo"$
$ echo -ne '\''r"foo(\0253)foo"'\''|json -b4
r"foo(\253)foo"$
$ echo -ne '\''r"foo(\0253)foo"'\''|json -b8
r"foo(\253)foo"$
$ echo -ne '\''r"foo(\0254)foo"'\''|json -b1
r"foo(\254)foo"$
$ echo -ne '\''r"foo(\0254)foo"'\''|json -b2
r"foo(\254)foo"$
$ echo -ne '\''r"foo(\0254)foo"'\''|json -b4
r"foo(\254)foo"$
$ echo -ne '\''r"foo(\0254)foo"'\''|json -b8
r"foo(\254)foo"$
$ echo -ne '\''r"foo(\0255)foo"'\''|json -b1
r"foo(\255)foo"$
$ echo -ne '\''r"foo(\0255)foo"'\''|json -b2
r"foo(\255)foo"$
$ echo -ne '\''r"foo(\0255)foo"'\''|json -b4
r"foo(\255)foo"$
$ echo -ne '\''r"foo(\0255)foo"'\''|json -b8
r"foo(\255)foo"$
$ echo -ne '\''r"foo(\0256)foo"'\''|json -b1
r"foo(\256)foo"$
$ echo -ne '\''r"foo(\0256)foo"'\''|json -b2
r"foo(\256)foo"$
$ echo -ne '\''r"foo(\0256)foo"'\''|json -b4
r"foo(\256)foo"$
$ echo -ne '\''r"foo(\0256)foo"'\''|json -b8
r"foo(\256)foo"$
$ echo -ne '\''r"foo(\0257)foo"'\''|json -b1
r"foo(\257)foo"$
$ echo -ne '\''r"foo(\0257)foo"'\''|json -b2
r"foo(\257)foo"$
$ echo -ne '\''r"foo(\0257)foo"'\''|json -b4
r"foo(\257)foo"$
$ echo -ne '\''r"foo(\0257)foo"'\''|json -b8
r"foo(\257)foo"$
$ echo -ne '\''r"foo(\0260)foo"'\''|json -b1
r"foo(\260)foo"$
$ echo -ne '\''r"foo(\0260)foo"'\''|json -b2
r"foo(\260)foo"$
$ echo -ne '\''r"foo(\0260)foo"'\''|json -b4
r"foo(\260)foo"$
$ echo -ne '\''r"foo(\0260)foo"'\''|json -b8
r"foo(\260)foo"$
$ echo -ne '\''r"foo(\0261)foo"'\''|json -b1
r"foo(\261)foo"$
$ echo -ne '\''r"foo(\0261)foo"'\''|json -b2
r"foo(\261)foo"$
$ echo -ne '\''r"foo(\0261)foo"'\''|json -b4
r"foo(\261)foo"$
$ echo -ne '\''r"foo(\0261)foo"'\''|json -b8
r"foo(\261)foo"$
$ echo -ne '\''r"foo(\0262)foo"'\''|json -b1
r"foo(\262)foo"$
$ echo -ne '\''r"foo(\0262)foo"'\''|json -b2
r"foo(\262)foo"$
$ echo -ne '\''r"foo(\0262)foo"'\''|json -b4
r"foo(\262)foo"$
$ echo -ne '\''r"foo(\0262)foo"'\''|json -b8
r"foo(\262)foo"$
$ echo -ne '\''r"foo(\0263)foo"'\''|json -b1
r"foo(\263)foo"$
$ echo -ne '\''r"foo(\0263)foo"'\''|json -b2
r"foo(\263)foo"$
$ echo -ne '\''r"foo(\0263)foo"'\''|json -b4
r"foo(\263)foo"$
$ echo -ne '\''r"foo(\0263)foo"'\''|json -b8
r"foo(\263)foo"$
$ echo -ne '\''r"foo(\0264)foo"'\''|json -b1
r"foo(\264)foo"$
$ echo -ne '\''r"foo(\0264)foo"'\''|json -b2
r"foo(\264)foo"$
$ echo -ne '\''r"foo(\0264)foo"'\''|json -b4
r"foo(\264)foo"$
$ echo -ne '\''r"foo(\0264)foo"'\''|json -b8
r"foo(\264)foo"$
$ echo -ne '\''r"foo(\0265)foo"'\''|json -b1
r"foo(\265)foo"$
$ echo -ne '\''r"foo(\0265)foo"'\''|json -b2
r"foo(\265)foo"$
$ echo -ne '\''r"foo(\0265)foo"'\''|json -b4
r"foo(\265)foo"$
$ echo -ne '\''r"foo(\0265)foo"'\''|json -b8
r"foo(\265)foo"$
$ echo -ne '\''r"foo(\0266)foo"'\''|json -b1
r"foo(\266)foo"$
$ echo -ne '\''r"foo(\0266)foo"'\''|json -b2
r"foo(\266)foo"$
$ echo -ne '\''r"foo(\0266)foo"'\''|json -b4
r"foo(\266)foo"$
$ echo -ne '\''r"foo(\0266)foo"'\''|json -b8
r"foo(\266)foo"$
$ echo -ne '\''r"foo(\0267)foo"'\''|json -b1
r"foo(\267)foo"$
$ echo -ne '\''r"foo(\0267)foo"'\''|json -b2
r"foo(\267)foo"$
$ echo -ne '\''r"foo(\0267)foo"'\''|json -b4
r"foo(\267)foo"$
$ echo -ne '\''r"foo(\0267)foo"'\''|json -b8
r"foo(\267)foo"$
$ echo -ne '\''r"foo(\0270)foo"'\''|json -b1
r"foo(\270)foo"$
$ echo -ne '\''r"foo(\0270)foo"'\''|json -b2
r"foo(\270)foo"$
$ echo -ne '\''r"foo(\0270)foo"'\''|json -b4
r"foo(\270)foo"$
$ echo -ne '\''r"foo(\0270)foo"'\''|json -b8
r"foo(\270)foo"$
$ echo -ne '\''r"foo(\0271)foo"'\''|json -b1
r"foo(\271)foo"$
$ echo -ne '\''r"foo(\0271)foo"'\''|json -b2
r"foo(\271)foo"$
$ echo -ne '\''r"foo(\0271)foo"'\''|json -b4
r"foo(\271)foo"$
$ echo -ne '\''r"foo(\0271)foo"'\''|json -b8
r"foo(\271)foo"$
$ echo -ne '\''r"foo(\0272)foo"'\''|json -b1
r"foo(\272)foo"$
$ echo -ne '\''r"foo(\0272)foo"'\''|json -b2
r"foo(\272)foo"$
$ echo -ne '\''r"foo(\0272)foo"'\''|json -b4
r"foo(\272)foo"$
$ echo -ne '\''r"foo(\0272)foo"'\''|json -b8
r"foo(\272)foo"$
$ echo -ne '\''r"foo(\0273)foo"'\''|json -b1
r"foo(\273)foo"$
$ echo -ne '\''r"foo(\0273)foo"'\''|json -b2
r"foo(\273)foo"$
$ echo -ne '\''r"foo(\0273)foo"'\''|json -b4
r"foo(\273)foo"$
$ echo -ne '\''r"foo(\0273)foo"'\''|json -b8
r"foo(\273)foo"$
$ echo -ne '\''r"foo(\0274)foo"'\''|json -b1
r"foo(\274)foo"$
$ echo -ne '\''r"foo(\0274)foo"'\''|json -b2
r"foo(\274)foo"$
$ echo -ne '\''r"foo(\0274)foo"'\''|json -b4
r"foo(\274)foo"$
$ echo -ne '\''r"foo(\0274)foo"'\''|json -b8
r"foo(\274)foo"$
$ echo -ne '\''r"foo(\0275)foo"'\''|json -b1
r"foo(\275)foo"$
$ echo -ne '\''r"foo(\0275)foo"'\''|json -b2
r"foo(\275)foo"$
$ echo -ne '\''r"foo(\0275)foo"'\''|json -b4
r"foo(\275)foo"$
$ echo -ne '\''r"foo(\0275)foo"'\''|json -b8
r"foo(\275)foo"$
$ echo -ne '\''r"foo(\0276)foo"'\''|json -b1
r"foo(\276)foo"$
$ echo -ne '\''r"foo(\0276)foo"'\''|json -b2
r"foo(\276)foo"$
$ echo -ne '\''r"foo(\0276)foo"'\''|json -b4
r"foo(\276)foo"$
$ echo -ne '\''r"foo(\0276)foo"'\''|json -b8
r"foo(\276)foo"$
$ echo -ne '\''r"foo(\0277)foo"'\''|json -b1
r"foo(\277)foo"$
$ echo -ne '\''r"foo(\0277)foo"'\''|json -b2
r"foo(\277)foo"$
$ echo -ne '\''r"foo(\0277)foo"'\''|json -b4
r"foo(\277)foo"$
$ echo -ne '\''r"foo(\0277)foo"'\''|json -b8
r"foo(\277)foo"$
$ echo -ne '\''r"foo(\0300)foo"'\''|json -b1
r"foo(\300)foo"$
$ echo -ne '\''r"foo(\0300)foo"'\''|json -b2
r"foo(\300)foo"$
$ echo -ne '\''r"foo(\0300)foo"'\''|json -b4
r"foo(\300)foo"$
$ echo -ne '\''r"foo(\0300)foo"'\''|json -b8
r"foo(\300)foo"$
$ echo -ne '\''r"foo(\0301)foo"'\''|json -b1
r"foo(\301)foo"$
$ echo -ne '\''r"foo(\0301)foo"'\''|json -b2
r"foo(\301)foo"$
$ echo -ne '\''r"foo(\0301)foo"'\''|json -b4
r"foo(\301)foo"$
$ echo -ne '\''r"foo(\0301)foo"'\''|json -b8
r"foo(\301)foo"$
$ echo -ne '\''r"foo(\0302)foo"'\''|json -b1
r"foo(\302)foo"$
$ echo -ne '\''r"foo(\0302)foo"'\''|json -b2
r"foo(\302)foo"$
$ echo -ne '\''r"foo(\0302)foo"'\''|json -b4
r"foo(\302)foo"$
$ echo -ne '\''r"foo(\0302)foo"'\''|json -b8
r"foo(\302)foo"$
$ echo -ne '\''r"foo(\0303)foo"'\''|json -b1
r"foo(\303)foo"$
$ echo -ne '\''r"foo(\0303)foo"'\''|json -b2
r"foo(\303)foo"$
$ echo -ne '\''r"foo(\0303)foo"'\''|json -b4
r"foo(\303)foo"$
$ echo -ne '\''r"foo(\0303)foo"'\''|json -b8
r"foo(\303)foo"$
$ echo -ne '\''r"foo(\0304)foo"'\''|json -b1
r"foo(\304)foo"$
$ echo -ne '\''r"foo(\0304)foo"'\''|json -b2
r"foo(\304)foo"$
$ echo -ne '\''r"foo(\0304)foo"'\''|json -b4
r"foo(\304)foo"$
$ echo -ne '\''r"foo(\0304)foo"'\''|json -b8
r"foo(\304)foo"$
$ echo -ne '\''r"foo(\0305)foo"'\''|json -b1
r"foo(\305)foo"$
$ echo -ne '\''r"foo(\0305)foo"'\''|json -b2
r"foo(\305)foo"$
$ echo -ne '\''r"foo(\0305)foo"'\''|json -b4
r"foo(\305)foo"$
$ echo -ne '\''r"foo(\0305)foo"'\''|json -b8
r"foo(\305)foo"$
$ echo -ne '\''r"foo(\0306)foo"'\''|json -b1
r"foo(\306)foo"$
$ echo -ne '\''r"foo(\0306)foo"'\''|json -b2
r"foo(\306)foo"$
$ echo -ne '\''r"foo(\0306)foo"'\''|json -b4
r"foo(\306)foo"$
$ echo -ne '\''r"foo(\0306)foo"'\''|json -b8
r"foo(\306)foo"$
$ echo -ne '\''r"foo(\0307)foo"'\''|json -b1
r"foo(\307)foo"$
$ echo -ne '\''r"foo(\0307)foo"'\''|json -b2
r"foo(\307)foo"$
$ echo -ne '\''r"foo(\0307)foo"'\''|json -b4
r"foo(\307)foo"$
$ echo -ne '\''r"foo(\0307)foo"'\''|json -b8
r"foo(\307)foo"$
$ echo -ne '\''r"foo(\0310)foo"'\''|json -b1
r"foo(\310)foo"$
$ echo -ne '\''r"foo(\0310)foo"'\''|json -b2
r"foo(\310)foo"$
$ echo -ne '\''r"foo(\0310)foo"'\''|json -b4
r"foo(\310)foo"$
$ echo -ne '\''r"foo(\0310)foo"'\''|json -b8
r"foo(\310)foo"$
$ echo -ne '\''r"foo(\0311)foo"'\''|json -b1
r"foo(\311)foo"$
$ echo -ne '\''r"foo(\0311)foo"'\''|json -b2
r"foo(\311)foo"$
$ echo -ne '\''r"foo(\0311)foo"'\''|json -b4
r"foo(\311)foo"$
$ echo -ne '\''r"foo(\0311)foo"'\''|json -b8
r"foo(\311)foo"$
$ echo -ne '\''r"foo(\0312)foo"'\''|json -b1
r"foo(\312)foo"$
$ echo -ne '\''r"foo(\0312)foo"'\''|json -b2
r"foo(\312)foo"$
$ echo -ne '\''r"foo(\0312)foo"'\''|json -b4
r"foo(\312)foo"$
$ echo -ne '\''r"foo(\0312)foo"'\''|json -b8
r"foo(\312)foo"$
$ echo -ne '\''r"foo(\0313)foo"'\''|json -b1
r"foo(\313)foo"$
$ echo -ne '\''r"foo(\0313)foo"'\''|json -b2
r"foo(\313)foo"$
$ echo -ne '\''r"foo(\0313)foo"'\''|json -b4
r"foo(\313)foo"$
$ echo -ne '\''r"foo(\0313)foo"'\''|json -b8
r"foo(\313)foo"$
$ echo -ne '\''r"foo(\0314)foo"'\''|json -b1
r"foo(\314)foo"$
$ echo -ne '\''r"foo(\0314)foo"'\''|json -b2
r"foo(\314)foo"$
$ echo -ne '\''r"foo(\0314)foo"'\''|json -b4
r"foo(\314)foo"$
$ echo -ne '\''r"foo(\0314)foo"'\''|json -b8
r"foo(\314)foo"$
$ echo -ne '\''r"foo(\0315)foo"'\''|json -b1
r"foo(\315)foo"$
$ echo -ne '\''r"foo(\0315)foo"'\''|json -b2
r"foo(\315)foo"$
$ echo -ne '\''r"foo(\0315)foo"'\''|json -b4
r"foo(\315)foo"$
$ echo -ne '\''r"foo(\0315)foo"'\''|json -b8
r"foo(\315)foo"$
$ echo -ne '\''r"foo(\0316)foo"'\''|json -b1
r"foo(\316)foo"$
$ echo -ne '\''r"foo(\0316)foo"'\''|json -b2
r"foo(\316)foo"$
$ echo -ne '\''r"foo(\0316)foo"'\''|json -b4
r"foo(\316)foo"$
$ echo -ne '\''r"foo(\0316)foo"'\''|json -b8
r"foo(\316)foo"$
$ echo -ne '\''r"foo(\0317)foo"'\''|json -b1
r"foo(\317)foo"$
$ echo -ne '\''r"foo(\0317)foo"'\''|json -b2
r"foo(\317)foo"$
$ echo -ne '\''r"foo(\0317)foo"'\''|json -b4
r"foo(\317)foo"$
$ echo -ne '\''r"foo(\0317)foo"'\''|json -b8
r"foo(\317)foo"$
$ echo -ne '\''r"foo(\0320)foo"'\''|json -b1
r"foo(\320)foo"$
$ echo -ne '\''r"foo(\0320)foo"'\''|json -b2
r"foo(\320)foo"$
$ echo -ne '\''r"foo(\0320)foo"'\''|json -b4
r"foo(\320)foo"$
$ echo -ne '\''r"foo(\0320)foo"'\''|json -b8
r"foo(\320)foo"$
$ echo -ne '\''r"foo(\0321)foo"'\''|json -b1
r"foo(\321)foo"$
$ echo -ne '\''r"foo(\0321)foo"'\''|json -b2
r"foo(\321)foo"$
$ echo -ne '\''r"foo(\0321)foo"'\''|json -b4
r"foo(\321)foo"$
$ echo -ne '\''r"foo(\0321)foo"'\''|json -b8
r"foo(\321)foo"$
$ echo -ne '\''r"foo(\0322)foo"'\''|json -b1
r"foo(\322)foo"$
$ echo -ne '\''r"foo(\0322)foo"'\''|json -b2
r"foo(\322)foo"$
$ echo -ne '\''r"foo(\0322)foo"'\''|json -b4
r"foo(\322)foo"$
$ echo -ne '\''r"foo(\0322)foo"'\''|json -b8
r"foo(\322)foo"$
$ echo -ne '\''r"foo(\0323)foo"'\''|json -b1
r"foo(\323)foo"$
$ echo -ne '\''r"foo(\0323)foo"'\''|json -b2
r"foo(\323)foo"$
$ echo -ne '\''r"foo(\0323)foo"'\''|json -b4
r"foo(\323)foo"$
$ echo -ne '\''r"foo(\0323)foo"'\''|json -b8
r"foo(\323)foo"$
$ echo -ne '\''r"foo(\0324)foo"'\''|json -b1
r"foo(\324)foo"$
$ echo -ne '\''r"foo(\0324)foo"'\''|json -b2
r"foo(\324)foo"$
$ echo -ne '\''r"foo(\0324)foo"'\''|json -b4
r"foo(\324)foo"$
$ echo -ne '\''r"foo(\0324)foo"'\''|json -b8
r"foo(\324)foo"$
$ echo -ne '\''r"foo(\0325)foo"'\''|json -b1
r"foo(\325)foo"$
$ echo -ne '\''r"foo(\0325)foo"'\''|json -b2
r"foo(\325)foo"$
$ echo -ne '\''r"foo(\0325)foo"'\''|json -b4
r"foo(\325)foo"$
$ echo -ne '\''r"foo(\0325)foo"'\''|json -b8
r"foo(\325)foo"$
$ echo -ne '\''r"foo(\0326)foo"'\''|json -b1
r"foo(\326)foo"$
$ echo -ne '\''r"foo(\0326)foo"'\''|json -b2
r"foo(\326)foo"$
$ echo -ne '\''r"foo(\0326)foo"'\''|json -b4
r"foo(\326)foo"$
$ echo -ne '\''r"foo(\0326)foo"'\''|json -b8
r"foo(\326)foo"$
$ echo -ne '\''r"foo(\0327)foo"'\''|json -b1
r"foo(\327)foo"$
$ echo -ne '\''r"foo(\0327)foo"'\''|json -b2
r"foo(\327)foo"$
$ echo -ne '\''r"foo(\0327)foo"'\''|json -b4
r"foo(\327)foo"$
$ echo -ne '\''r"foo(\0327)foo"'\''|json -b8
r"foo(\327)foo"$
$ echo -ne '\''r"foo(\0330)foo"'\''|json -b1
r"foo(\330)foo"$
$ echo -ne '\''r"foo(\0330)foo"'\''|json -b2
r"foo(\330)foo"$
$ echo -ne '\''r"foo(\0330)foo"'\''|json -b4
r"foo(\330)foo"$
$ echo -ne '\''r"foo(\0330)foo"'\''|json -b8
r"foo(\330)foo"$
$ echo -ne '\''r"foo(\0331)foo"'\''|json -b1
r"foo(\331)foo"$
$ echo -ne '\''r"foo(\0331)foo"'\''|json -b2
r"foo(\331)foo"$
$ echo -ne '\''r"foo(\0331)foo"'\''|json -b4
r"foo(\331)foo"$
$ echo -ne '\''r"foo(\0331)foo"'\''|json -b8
r"foo(\331)foo"$
$ echo -ne '\''r"foo(\0332)foo"'\''|json -b1
r"foo(\332)foo"$
$ echo -ne '\''r"foo(\0332)foo"'\''|json -b2
r"foo(\332)foo"$
$ echo -ne '\''r"foo(\0332)foo"'\''|json -b4
r"foo(\332)foo"$
$ echo -ne '\''r"foo(\0332)foo"'\''|json -b8
r"foo(\332)foo"$
$ echo -ne '\''r"foo(\0333)foo"'\''|json -b1
r"foo(\333)foo"$
$ echo -ne '\''r"foo(\0333)foo"'\''|json -b2
r"foo(\333)foo"$
$ echo -ne '\''r"foo(\0333)foo"'\''|json -b4
r"foo(\333)foo"$
$ echo -ne '\''r"foo(\0333)foo"'\''|json -b8
r"foo(\333)foo"$
$ echo -ne '\''r"foo(\0334)foo"'\''|json -b1
r"foo(\334)foo"$
$ echo -ne '\''r"foo(\0334)foo"'\''|json -b2
r"foo(\334)foo"$
$ echo -ne '\''r"foo(\0334)foo"'\''|json -b4
r"foo(\334)foo"$
$ echo -ne '\''r"foo(\0334)foo"'\''|json -b8
r"foo(\334)foo"$
$ echo -ne '\''r"foo(\0335)foo"'\''|json -b1
r"foo(\335)foo"$
$ echo -ne '\''r"foo(\0335)foo"'\''|json -b2
r"foo(\335)foo"$
$ echo -ne '\''r"foo(\0335)foo"'\''|json -b4
r"foo(\335)foo"$
$ echo -ne '\''r"foo(\0335)foo"'\''|json -b8
r"foo(\335)foo"$
$ echo -ne '\''r"foo(\0336)foo"'\''|json -b1
r"foo(\336)foo"$
$ echo -ne '\''r"foo(\0336)foo"'\''|json -b2
r"foo(\336)foo"$
$ echo -ne '\''r"foo(\0336)foo"'\''|json -b4
r"foo(\336)foo"$
$ echo -ne '\''r"foo(\0336)foo"'\''|json -b8
r"foo(\336)foo"$
$ echo -ne '\''r"foo(\0337)foo"'\''|json -b1
r"foo(\337)foo"$
$ echo -ne '\''r"foo(\0337)foo"'\''|json -b2
r"foo(\337)foo"$
$ echo -ne '\''r"foo(\0337)foo"'\''|json -b4
r"foo(\337)foo"$
$ echo -ne '\''r"foo(\0337)foo"'\''|json -b8
r"foo(\337)foo"$
$ echo -ne '\''r"foo(\0340)foo"'\''|json -b1
r"foo(\340)foo"$
$ echo -ne '\''r"foo(\0340)foo"'\''|json -b2
r"foo(\340)foo"$
$ echo -ne '\''r"foo(\0340)foo"'\''|json -b4
r"foo(\340)foo"$
$ echo -ne '\''r"foo(\0340)foo"'\''|json -b8
r"foo(\340)foo"$
$ echo -ne '\''r"foo(\0341)foo"'\''|json -b1
r"foo(\341)foo"$
$ echo -ne '\''r"foo(\0341)foo"'\''|json -b2
r"foo(\341)foo"$
$ echo -ne '\''r"foo(\0341)foo"'\''|json -b4
r"foo(\341)foo"$
$ echo -ne '\''r"foo(\0341)foo"'\''|json -b8
r"foo(\341)foo"$
$ echo -ne '\''r"foo(\0342)foo"'\''|json -b1
r"foo(\342)foo"$
$ echo -ne '\''r"foo(\0342)foo"'\''|json -b2
r"foo(\342)foo"$
$ echo -ne '\''r"foo(\0342)foo"'\''|json -b4
r"foo(\342)foo"$
$ echo -ne '\''r"foo(\0342)foo"'\''|json -b8
r"foo(\342)foo"$
$ echo -ne '\''r"foo(\0343)foo"'\''|json -b1
r"foo(\343)foo"$
$ echo -ne '\''r"foo(\0343)foo"'\''|json -b2
r"foo(\343)foo"$
$ echo -ne '\''r"foo(\0343)foo"'\''|json -b4
r"foo(\343)foo"$
$ echo -ne '\''r"foo(\0343)foo"'\''|json -b8
r"foo(\343)foo"$
$ echo -ne '\''r"foo(\0344)foo"'\''|json -b1
r"foo(\344)foo"$
$ echo -ne '\''r"foo(\0344)foo"'\''|json -b2
r"foo(\344)foo"$
$ echo -ne '\''r"foo(\0344)foo"'\''|json -b4
r"foo(\344)foo"$
$ echo -ne '\''r"foo(\0344)foo"'\''|json -b8
r"foo(\344)foo"$
$ echo -ne '\''r"foo(\0345)foo"'\''|json -b1
r"foo(\345)foo"$
$ echo -ne '\''r"foo(\0345)foo"'\''|json -b2
r"foo(\345)foo"$
$ echo -ne '\''r"foo(\0345)foo"'\''|json -b4
r"foo(\345)foo"$
$ echo -ne '\''r"foo(\0345)foo"'\''|json -b8
r"foo(\345)foo"$
$ echo -ne '\''r"foo(\0346)foo"'\''|json -b1
r"foo(\346)foo"$
$ echo -ne '\''r"foo(\0346)foo"'\''|json -b2
r"foo(\346)foo"$
$ echo -ne '\''r"foo(\0346)foo"'\''|json -b4
r"foo(\346)foo"$
$ echo -ne '\''r"foo(\0346)foo"'\''|json -b8
r"foo(\346)foo"$
$ echo -ne '\''r"foo(\0347)foo"'\''|json -b1
r"foo(\347)foo"$
$ echo -ne '\''r"foo(\0347)foo"'\''|json -b2
r"foo(\347)foo"$
$ echo -ne '\''r"foo(\0347)foo"'\''|json -b4
r"foo(\347)foo"$
$ echo -ne '\''r"foo(\0347)foo"'\''|json -b8
r"foo(\347)foo"$
$ echo -ne '\''r"foo(\0350)foo"'\''|json -b1
r"foo(\350)foo"$
$ echo -ne '\''r"foo(\0350)foo"'\''|json -b2
r"foo(\350)foo"$
$ echo -ne '\''r"foo(\0350)foo"'\''|json -b4
r"foo(\350)foo"$
$ echo -ne '\''r"foo(\0350)foo"'\''|json -b8
r"foo(\350)foo"$
$ echo -ne '\''r"foo(\0351)foo"'\''|json -b1
r"foo(\351)foo"$
$ echo -ne '\''r"foo(\0351)foo"'\''|json -b2
r"foo(\351)foo"$
$ echo -ne '\''r"foo(\0351)foo"'\''|json -b4
r"foo(\351)foo"$
$ echo -ne '\''r"foo(\0351)foo"'\''|json -b8
r"foo(\351)foo"$
$ echo -ne '\''r"foo(\0352)foo"'\''|json -b1
r"foo(\352)foo"$
$ echo -ne '\''r"foo(\0352)foo"'\''|json -b2
r"foo(\352)foo"$
$ echo -ne '\''r"foo(\0352)foo"'\''|json -b4
r"foo(\352)foo"$
$ echo -ne '\''r"foo(\0352)foo"'\''|json -b8
r"foo(\352)foo"$
$ echo -ne '\''r"foo(\0353)foo"'\''|json -b1
r"foo(\353)foo"$
$ echo -ne '\''r"foo(\0353)foo"'\''|json -b2
r"foo(\353)foo"$
$ echo -ne '\''r"foo(\0353)foo"'\''|json -b4
r"foo(\353)foo"$
$ echo -ne '\''r"foo(\0353)foo"'\''|json -b8
r"foo(\353)foo"$
$ echo -ne '\''r"foo(\0354)foo"'\''|json -b1
r"foo(\354)foo"$
$ echo -ne '\''r"foo(\0354)foo"'\''|json -b2
r"foo(\354)foo"$
$ echo -ne '\''r"foo(\0354)foo"'\''|json -b4
r"foo(\354)foo"$
$ echo -ne '\''r"foo(\0354)foo"'\''|json -b8
r"foo(\354)foo"$
$ echo -ne '\''r"foo(\0355)foo"'\''|json -b1
r"foo(\355)foo"$
$ echo -ne '\''r"foo(\0355)foo"'\''|json -b2
r"foo(\355)foo"$
$ echo -ne '\''r"foo(\0355)foo"'\''|json -b4
r"foo(\355)foo"$
$ echo -ne '\''r"foo(\0355)foo"'\''|json -b8
r"foo(\355)foo"$
$ echo -ne '\''r"foo(\0356)foo"'\''|json -b1
r"foo(\356)foo"$
$ echo -ne '\''r"foo(\0356)foo"'\''|json -b2
r"foo(\356)foo"$
$ echo -ne '\''r"foo(\0356)foo"'\''|json -b4
r"foo(\356)foo"$
$ echo -ne '\''r"foo(\0356)foo"'\''|json -b8
r"foo(\356)foo"$
$ echo -ne '\''r"foo(\0357)foo"'\''|json -b1
r"foo(\357)foo"$
$ echo -ne '\''r"foo(\0357)foo"'\''|json -b2
r"foo(\357)foo"$
$ echo -ne '\''r"foo(\0357)foo"'\''|json -b4
r"foo(\357)foo"$
$ echo -ne '\''r"foo(\0357)foo"'\''|json -b8
r"foo(\357)foo"$
$ echo -ne '\''r"foo(\0360)foo"'\''|json -b1
r"foo(\360)foo"$
$ echo -ne '\''r"foo(\0360)foo"'\''|json -b2
r"foo(\360)foo"$
$ echo -ne '\''r"foo(\0360)foo"'\''|json -b4
r"foo(\360)foo"$
$ echo -ne '\''r"foo(\0360)foo"'\''|json -b8
r"foo(\360)foo"$
$ echo -ne '\''r"foo(\0361)foo"'\''|json -b1
r"foo(\361)foo"$
$ echo -ne '\''r"foo(\0361)foo"'\''|json -b2
r"foo(\361)foo"$
$ echo -ne '\''r"foo(\0361)foo"'\''|json -b4
r"foo(\361)foo"$
$ echo -ne '\''r"foo(\0361)foo"'\''|json -b8
r"foo(\361)foo"$
$ echo -ne '\''r"foo(\0362)foo"'\''|json -b1
r"foo(\362)foo"$
$ echo -ne '\''r"foo(\0362)foo"'\''|json -b2
r"foo(\362)foo"$
$ echo -ne '\''r"foo(\0362)foo"'\''|json -b4
r"foo(\362)foo"$
$ echo -ne '\''r"foo(\0362)foo"'\''|json -b8
r"foo(\362)foo"$
$ echo -ne '\''r"foo(\0363)foo"'\''|json -b1
r"foo(\363)foo"$
$ echo -ne '\''r"foo(\0363)foo"'\''|json -b2
r"foo(\363)foo"$
$ echo -ne '\''r"foo(\0363)foo"'\''|json -b4
r"foo(\363)foo"$
$ echo -ne '\''r"foo(\0363)foo"'\''|json -b8
r"foo(\363)foo"$
$ echo -ne '\''r"foo(\0364)foo"'\''|json -b1
r"foo(\364)foo"$
$ echo -ne '\''r"foo(\0364)foo"'\''|json -b2
r"foo(\364)foo"$
$ echo -ne '\''r"foo(\0364)foo"'\''|json -b4
r"foo(\364)foo"$
$ echo -ne '\''r"foo(\0364)foo"'\''|json -b8
r"foo(\364)foo"$
$ echo -ne '\''r"foo(\0365)foo"'\''|json -b1
r"foo(\365)foo"$
$ echo -ne '\''r"foo(\0365)foo"'\''|json -b2
r"foo(\365)foo"$
$ echo -ne '\''r"foo(\0365)foo"'\''|json -b4
r"foo(\365)foo"$
$ echo -ne '\''r"foo(\0365)foo"'\''|json -b8
r"foo(\365)foo"$
$ echo -ne '\''r"foo(\0366)foo"'\''|json -b1
r"foo(\366)foo"$
$ echo -ne '\''r"foo(\0366)foo"'\''|json -b2
r"foo(\366)foo"$
$ echo -ne '\''r"foo(\0366)foo"'\''|json -b4
r"foo(\366)foo"$
$ echo -ne '\''r"foo(\0366)foo"'\''|json -b8
r"foo(\366)foo"$
$ echo -ne '\''r"foo(\0367)foo"'\''|json -b1
r"foo(\367)foo"$
$ echo -ne '\''r"foo(\0367)foo"'\''|json -b2
r"foo(\367)foo"$
$ echo -ne '\''r"foo(\0367)foo"'\''|json -b4
r"foo(\367)foo"$
$ echo -ne '\''r"foo(\0367)foo"'\''|json -b8
r"foo(\367)foo"$
$ echo -ne '\''r"foo(\0370)foo"'\''|json -b1
r"foo(\370)foo"$
$ echo -ne '\''r"foo(\0370)foo"'\''|json -b2
r"foo(\370)foo"$
$ echo -ne '\''r"foo(\0370)foo"'\''|json -b4
r"foo(\370)foo"$
$ echo -ne '\''r"foo(\0370)foo"'\''|json -b8
r"foo(\370)foo"$
$ echo -ne '\''r"foo(\0371)foo"'\''|json -b1
r"foo(\371)foo"$
$ echo -ne '\''r"foo(\0371)foo"'\''|json -b2
r"foo(\371)foo"$
$ echo -ne '\''r"foo(\0371)foo"'\''|json -b4
r"foo(\371)foo"$
$ echo -ne '\''r"foo(\0371)foo"'\''|json -b8
r"foo(\371)foo"$
$ echo -ne '\''r"foo(\0372)foo"'\''|json -b1
r"foo(\372)foo"$
$ echo -ne '\''r"foo(\0372)foo"'\''|json -b2
r"foo(\372)foo"$
$ echo -ne '\''r"foo(\0372)foo"'\''|json -b4
r"foo(\372)foo"$
$ echo -ne '\''r"foo(\0372)foo"'\''|json -b8
r"foo(\372)foo"$
$ echo -ne '\''r"foo(\0373)foo"'\''|json -b1
r"foo(\373)foo"$
$ echo -ne '\''r"foo(\0373)foo"'\''|json -b2
r"foo(\373)foo"$
$ echo -ne '\''r"foo(\0373)foo"'\''|json -b4
r"foo(\373)foo"$
$ echo -ne '\''r"foo(\0373)foo"'\''|json -b8
r"foo(\373)foo"$
$ echo -ne '\''r"foo(\0374)foo"'\''|json -b1
r"foo(\374)foo"$
$ echo -ne '\''r"foo(\0374)foo"'\''|json -b2
r"foo(\374)foo"$
$ echo -ne '\''r"foo(\0374)foo"'\''|json -b4
r"foo(\374)foo"$
$ echo -ne '\''r"foo(\0374)foo"'\''|json -b8
r"foo(\374)foo"$
$ echo -ne '\''r"foo(\0375)foo"'\''|json -b1
r"foo(\375)foo"$
$ echo -ne '\''r"foo(\0375)foo"'\''|json -b2
r"foo(\375)foo"$
$ echo -ne '\''r"foo(\0375)foo"'\''|json -b4
r"foo(\375)foo"$
$ echo -ne '\''r"foo(\0375)foo"'\''|json -b8
r"foo(\375)foo"$
$ echo -ne '\''r"foo(\0376)foo"'\''|json -b1
r"foo(\376)foo"$
$ echo -ne '\''r"foo(\0376)foo"'\''|json -b2
r"foo(\376)foo"$
$ echo -ne '\''r"foo(\0376)foo"'\''|json -b4
r"foo(\376)foo"$
$ echo -ne '\''r"foo(\0376)foo"'\''|json -b8
r"foo(\376)foo"$
$ echo -ne '\''r"foo(\0377)foo"'\''|json -b1
r"foo(\377)foo"$
$ echo -ne '\''r"foo(\0377)foo"'\''|json -b2
r"foo(\377)foo"$
$ echo -ne '\''r"foo(\0377)foo"'\''|json -b4
r"foo(\377)foo"$
$ echo -ne '\''r"foo(\0377)foo"'\''|json -b8
r"foo(\377)foo"$'
) -L raw-string2.new <(
echo '$ json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }'
json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; } 2>&1 ||
echo 'command failed: json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }'

echo '$ json() { set -o pipefail && json0 --literal-value --raw-strings --pretty --sigpipe=no-error "$@"|sed -nr '\''/\berror\b/{p;b};l1024'\''; }'
json() { set -o pipefail && json0 --literal-value --raw-strings --pretty --sigpipe=no-error "$@"|sed -nr '/\berror\b/{p;b};l1024'; } 2>&1 ||
echo 'command failed: json() { set -o pipefail && json0 --literal-value --raw-strings --pretty --sigpipe=no-error "$@"|sed -nr '\''/\berror\b/{p;b};l1024'\''; }'

echo '$ echo -ne '\''r"foo(\0000)foo"'\''|json -b1'
echo -ne 'r"foo(\0000)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0000)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0000)foo"'\''|json -b2'
echo -ne 'r"foo(\0000)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0000)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0000)foo"'\''|json -b4'
echo -ne 'r"foo(\0000)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0000)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0000)foo"'\''|json -b8'
echo -ne 'r"foo(\0000)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0000)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0001)foo"'\''|json -b1'
echo -ne 'r"foo(\0001)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0001)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0001)foo"'\''|json -b2'
echo -ne 'r"foo(\0001)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0001)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0001)foo"'\''|json -b4'
echo -ne 'r"foo(\0001)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0001)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0001)foo"'\''|json -b8'
echo -ne 'r"foo(\0001)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0001)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0002)foo"'\''|json -b1'
echo -ne 'r"foo(\0002)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0002)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0002)foo"'\''|json -b2'
echo -ne 'r"foo(\0002)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0002)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0002)foo"'\''|json -b4'
echo -ne 'r"foo(\0002)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0002)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0002)foo"'\''|json -b8'
echo -ne 'r"foo(\0002)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0002)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0003)foo"'\''|json -b1'
echo -ne 'r"foo(\0003)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0003)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0003)foo"'\''|json -b2'
echo -ne 'r"foo(\0003)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0003)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0003)foo"'\''|json -b4'
echo -ne 'r"foo(\0003)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0003)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0003)foo"'\''|json -b8'
echo -ne 'r"foo(\0003)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0003)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0004)foo"'\''|json -b1'
echo -ne 'r"foo(\0004)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0004)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0004)foo"'\''|json -b2'
echo -ne 'r"foo(\0004)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0004)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0004)foo"'\''|json -b4'
echo -ne 'r"foo(\0004)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0004)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0004)foo"'\''|json -b8'
echo -ne 'r"foo(\0004)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0004)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0005)foo"'\''|json -b1'
echo -ne 'r"foo(\0005)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0005)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0005)foo"'\''|json -b2'
echo -ne 'r"foo(\0005)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0005)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0005)foo"'\''|json -b4'
echo -ne 'r"foo(\0005)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0005)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0005)foo"'\''|json -b8'
echo -ne 'r"foo(\0005)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0005)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0006)foo"'\''|json -b1'
echo -ne 'r"foo(\0006)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0006)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0006)foo"'\''|json -b2'
echo -ne 'r"foo(\0006)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0006)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0006)foo"'\''|json -b4'
echo -ne 'r"foo(\0006)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0006)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0006)foo"'\''|json -b8'
echo -ne 'r"foo(\0006)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0006)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0007)foo"'\''|json -b1'
echo -ne 'r"foo(\0007)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0007)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0007)foo"'\''|json -b2'
echo -ne 'r"foo(\0007)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0007)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0007)foo"'\''|json -b4'
echo -ne 'r"foo(\0007)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0007)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0007)foo"'\''|json -b8'
echo -ne 'r"foo(\0007)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0007)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0010)foo"'\''|json -b1'
echo -ne 'r"foo(\0010)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0010)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0010)foo"'\''|json -b2'
echo -ne 'r"foo(\0010)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0010)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0010)foo"'\''|json -b4'
echo -ne 'r"foo(\0010)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0010)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0010)foo"'\''|json -b8'
echo -ne 'r"foo(\0010)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0010)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0011)foo"'\''|json -b1'
echo -ne 'r"foo(\0011)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0011)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0011)foo"'\''|json -b2'
echo -ne 'r"foo(\0011)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0011)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0011)foo"'\''|json -b4'
echo -ne 'r"foo(\0011)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0011)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0011)foo"'\''|json -b8'
echo -ne 'r"foo(\0011)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0011)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0012)foo"'\''|json -b1'
echo -ne 'r"foo(\0012)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0012)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0012)foo"'\''|json -b2'
echo -ne 'r"foo(\0012)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0012)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0012)foo"'\''|json -b4'
echo -ne 'r"foo(\0012)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0012)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0012)foo"'\''|json -b8'
echo -ne 'r"foo(\0012)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0012)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0013)foo"'\''|json -b1'
echo -ne 'r"foo(\0013)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0013)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0013)foo"'\''|json -b2'
echo -ne 'r"foo(\0013)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0013)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0013)foo"'\''|json -b4'
echo -ne 'r"foo(\0013)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0013)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0013)foo"'\''|json -b8'
echo -ne 'r"foo(\0013)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0013)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0014)foo"'\''|json -b1'
echo -ne 'r"foo(\0014)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0014)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0014)foo"'\''|json -b2'
echo -ne 'r"foo(\0014)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0014)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0014)foo"'\''|json -b4'
echo -ne 'r"foo(\0014)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0014)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0014)foo"'\''|json -b8'
echo -ne 'r"foo(\0014)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0014)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0015)foo"'\''|json -b1'
echo -ne 'r"foo(\0015)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0015)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0015)foo"'\''|json -b2'
echo -ne 'r"foo(\0015)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0015)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0015)foo"'\''|json -b4'
echo -ne 'r"foo(\0015)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0015)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0015)foo"'\''|json -b8'
echo -ne 'r"foo(\0015)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0015)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0016)foo"'\''|json -b1'
echo -ne 'r"foo(\0016)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0016)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0016)foo"'\''|json -b2'
echo -ne 'r"foo(\0016)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0016)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0016)foo"'\''|json -b4'
echo -ne 'r"foo(\0016)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0016)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0016)foo"'\''|json -b8'
echo -ne 'r"foo(\0016)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0016)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0017)foo"'\''|json -b1'
echo -ne 'r"foo(\0017)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0017)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0017)foo"'\''|json -b2'
echo -ne 'r"foo(\0017)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0017)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0017)foo"'\''|json -b4'
echo -ne 'r"foo(\0017)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0017)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0017)foo"'\''|json -b8'
echo -ne 'r"foo(\0017)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0017)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0020)foo"'\''|json -b1'
echo -ne 'r"foo(\0020)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0020)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0020)foo"'\''|json -b2'
echo -ne 'r"foo(\0020)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0020)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0020)foo"'\''|json -b4'
echo -ne 'r"foo(\0020)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0020)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0020)foo"'\''|json -b8'
echo -ne 'r"foo(\0020)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0020)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0021)foo"'\''|json -b1'
echo -ne 'r"foo(\0021)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0021)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0021)foo"'\''|json -b2'
echo -ne 'r"foo(\0021)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0021)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0021)foo"'\''|json -b4'
echo -ne 'r"foo(\0021)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0021)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0021)foo"'\''|json -b8'
echo -ne 'r"foo(\0021)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0021)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0022)foo"'\''|json -b1'
echo -ne 'r"foo(\0022)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0022)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0022)foo"'\''|json -b2'
echo -ne 'r"foo(\0022)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0022)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0022)foo"'\''|json -b4'
echo -ne 'r"foo(\0022)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0022)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0022)foo"'\''|json -b8'
echo -ne 'r"foo(\0022)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0022)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0023)foo"'\''|json -b1'
echo -ne 'r"foo(\0023)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0023)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0023)foo"'\''|json -b2'
echo -ne 'r"foo(\0023)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0023)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0023)foo"'\''|json -b4'
echo -ne 'r"foo(\0023)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0023)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0023)foo"'\''|json -b8'
echo -ne 'r"foo(\0023)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0023)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0024)foo"'\''|json -b1'
echo -ne 'r"foo(\0024)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0024)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0024)foo"'\''|json -b2'
echo -ne 'r"foo(\0024)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0024)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0024)foo"'\''|json -b4'
echo -ne 'r"foo(\0024)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0024)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0024)foo"'\''|json -b8'
echo -ne 'r"foo(\0024)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0024)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0025)foo"'\''|json -b1'
echo -ne 'r"foo(\0025)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0025)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0025)foo"'\''|json -b2'
echo -ne 'r"foo(\0025)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0025)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0025)foo"'\''|json -b4'
echo -ne 'r"foo(\0025)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0025)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0025)foo"'\''|json -b8'
echo -ne 'r"foo(\0025)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0025)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0026)foo"'\''|json -b1'
echo -ne 'r"foo(\0026)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0026)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0026)foo"'\''|json -b2'
echo -ne 'r"foo(\0026)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0026)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0026)foo"'\''|json -b4'
echo -ne 'r"foo(\0026)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0026)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0026)foo"'\''|json -b8'
echo -ne 'r"foo(\0026)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0026)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0027)foo"'\''|json -b1'
echo -ne 'r"foo(\0027)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0027)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0027)foo"'\''|json -b2'
echo -ne 'r"foo(\0027)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0027)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0027)foo"'\''|json -b4'
echo -ne 'r"foo(\0027)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0027)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0027)foo"'\''|json -b8'
echo -ne 'r"foo(\0027)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0027)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0030)foo"'\''|json -b1'
echo -ne 'r"foo(\0030)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0030)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0030)foo"'\''|json -b2'
echo -ne 'r"foo(\0030)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0030)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0030)foo"'\''|json -b4'
echo -ne 'r"foo(\0030)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0030)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0030)foo"'\''|json -b8'
echo -ne 'r"foo(\0030)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0030)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0031)foo"'\''|json -b1'
echo -ne 'r"foo(\0031)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0031)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0031)foo"'\''|json -b2'
echo -ne 'r"foo(\0031)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0031)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0031)foo"'\''|json -b4'
echo -ne 'r"foo(\0031)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0031)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0031)foo"'\''|json -b8'
echo -ne 'r"foo(\0031)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0031)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0032)foo"'\''|json -b1'
echo -ne 'r"foo(\0032)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0032)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0032)foo"'\''|json -b2'
echo -ne 'r"foo(\0032)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0032)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0032)foo"'\''|json -b4'
echo -ne 'r"foo(\0032)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0032)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0032)foo"'\''|json -b8'
echo -ne 'r"foo(\0032)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0032)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0033)foo"'\''|json -b1'
echo -ne 'r"foo(\0033)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0033)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0033)foo"'\''|json -b2'
echo -ne 'r"foo(\0033)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0033)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0033)foo"'\''|json -b4'
echo -ne 'r"foo(\0033)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0033)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0033)foo"'\''|json -b8'
echo -ne 'r"foo(\0033)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0033)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0034)foo"'\''|json -b1'
echo -ne 'r"foo(\0034)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0034)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0034)foo"'\''|json -b2'
echo -ne 'r"foo(\0034)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0034)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0034)foo"'\''|json -b4'
echo -ne 'r"foo(\0034)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0034)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0034)foo"'\''|json -b8'
echo -ne 'r"foo(\0034)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0034)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0035)foo"'\''|json -b1'
echo -ne 'r"foo(\0035)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0035)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0035)foo"'\''|json -b2'
echo -ne 'r"foo(\0035)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0035)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0035)foo"'\''|json -b4'
echo -ne 'r"foo(\0035)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0035)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0035)foo"'\''|json -b8'
echo -ne 'r"foo(\0035)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0035)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0036)foo"'\''|json -b1'
echo -ne 'r"foo(\0036)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0036)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0036)foo"'\''|json -b2'
echo -ne 'r"foo(\0036)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0036)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0036)foo"'\''|json -b4'
echo -ne 'r"foo(\0036)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0036)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0036)foo"'\''|json -b8'
echo -ne 'r"foo(\0036)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0036)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0037)foo"'\''|json -b1'
echo -ne 'r"foo(\0037)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0037)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0037)foo"'\''|json -b2'
echo -ne 'r"foo(\0037)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0037)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0037)foo"'\''|json -b4'
echo -ne 'r"foo(\0037)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0037)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0037)foo"'\''|json -b8'
echo -ne 'r"foo(\0037)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0037)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0040)foo"'\''|json -b1'
echo -ne 'r"foo(\0040)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0040)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0040)foo"'\''|json -b2'
echo -ne 'r"foo(\0040)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0040)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0040)foo"'\''|json -b4'
echo -ne 'r"foo(\0040)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0040)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0040)foo"'\''|json -b8'
echo -ne 'r"foo(\0040)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0040)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0041)foo"'\''|json -b1'
echo -ne 'r"foo(\0041)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0041)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0041)foo"'\''|json -b2'
echo -ne 'r"foo(\0041)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0041)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0041)foo"'\''|json -b4'
echo -ne 'r"foo(\0041)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0041)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0041)foo"'\''|json -b8'
echo -ne 'r"foo(\0041)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0041)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0042)foo"'\''|json -b1'
echo -ne 'r"foo(\0042)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0042)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0042)foo"'\''|json -b2'
echo -ne 'r"foo(\0042)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0042)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0042)foo"'\''|json -b4'
echo -ne 'r"foo(\0042)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0042)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0042)foo"'\''|json -b8'
echo -ne 'r"foo(\0042)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0042)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0043)foo"'\''|json -b1'
echo -ne 'r"foo(\0043)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0043)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0043)foo"'\''|json -b2'
echo -ne 'r"foo(\0043)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0043)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0043)foo"'\''|json -b4'
echo -ne 'r"foo(\0043)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0043)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0043)foo"'\''|json -b8'
echo -ne 'r"foo(\0043)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0043)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0044)foo"'\''|json -b1'
echo -ne 'r"foo(\0044)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0044)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0044)foo"'\''|json -b2'
echo -ne 'r"foo(\0044)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0044)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0044)foo"'\''|json -b4'
echo -ne 'r"foo(\0044)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0044)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0044)foo"'\''|json -b8'
echo -ne 'r"foo(\0044)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0044)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0045)foo"'\''|json -b1'
echo -ne 'r"foo(\0045)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0045)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0045)foo"'\''|json -b2'
echo -ne 'r"foo(\0045)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0045)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0045)foo"'\''|json -b4'
echo -ne 'r"foo(\0045)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0045)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0045)foo"'\''|json -b8'
echo -ne 'r"foo(\0045)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0045)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0046)foo"'\''|json -b1'
echo -ne 'r"foo(\0046)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0046)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0046)foo"'\''|json -b2'
echo -ne 'r"foo(\0046)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0046)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0046)foo"'\''|json -b4'
echo -ne 'r"foo(\0046)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0046)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0046)foo"'\''|json -b8'
echo -ne 'r"foo(\0046)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0046)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0047)foo"'\''|json -b1'
echo -ne 'r"foo(\0047)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0047)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0047)foo"'\''|json -b2'
echo -ne 'r"foo(\0047)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0047)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0047)foo"'\''|json -b4'
echo -ne 'r"foo(\0047)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0047)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0047)foo"'\''|json -b8'
echo -ne 'r"foo(\0047)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0047)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0050)foo"'\''|json -b1'
echo -ne 'r"foo(\0050)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0050)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0050)foo"'\''|json -b2'
echo -ne 'r"foo(\0050)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0050)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0050)foo"'\''|json -b4'
echo -ne 'r"foo(\0050)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0050)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0050)foo"'\''|json -b8'
echo -ne 'r"foo(\0050)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0050)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0051)foo"'\''|json -b1'
echo -ne 'r"foo(\0051)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0051)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0051)foo"'\''|json -b2'
echo -ne 'r"foo(\0051)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0051)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0051)foo"'\''|json -b4'
echo -ne 'r"foo(\0051)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0051)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0051)foo"'\''|json -b8'
echo -ne 'r"foo(\0051)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0051)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0052)foo"'\''|json -b1'
echo -ne 'r"foo(\0052)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0052)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0052)foo"'\''|json -b2'
echo -ne 'r"foo(\0052)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0052)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0052)foo"'\''|json -b4'
echo -ne 'r"foo(\0052)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0052)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0052)foo"'\''|json -b8'
echo -ne 'r"foo(\0052)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0052)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0053)foo"'\''|json -b1'
echo -ne 'r"foo(\0053)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0053)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0053)foo"'\''|json -b2'
echo -ne 'r"foo(\0053)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0053)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0053)foo"'\''|json -b4'
echo -ne 'r"foo(\0053)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0053)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0053)foo"'\''|json -b8'
echo -ne 'r"foo(\0053)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0053)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0054)foo"'\''|json -b1'
echo -ne 'r"foo(\0054)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0054)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0054)foo"'\''|json -b2'
echo -ne 'r"foo(\0054)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0054)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0054)foo"'\''|json -b4'
echo -ne 'r"foo(\0054)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0054)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0054)foo"'\''|json -b8'
echo -ne 'r"foo(\0054)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0054)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0055)foo"'\''|json -b1'
echo -ne 'r"foo(\0055)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0055)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0055)foo"'\''|json -b2'
echo -ne 'r"foo(\0055)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0055)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0055)foo"'\''|json -b4'
echo -ne 'r"foo(\0055)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0055)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0055)foo"'\''|json -b8'
echo -ne 'r"foo(\0055)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0055)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0056)foo"'\''|json -b1'
echo -ne 'r"foo(\0056)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0056)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0056)foo"'\''|json -b2'
echo -ne 'r"foo(\0056)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0056)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0056)foo"'\''|json -b4'
echo -ne 'r"foo(\0056)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0056)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0056)foo"'\''|json -b8'
echo -ne 'r"foo(\0056)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0056)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0057)foo"'\''|json -b1'
echo -ne 'r"foo(\0057)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0057)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0057)foo"'\''|json -b2'
echo -ne 'r"foo(\0057)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0057)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0057)foo"'\''|json -b4'
echo -ne 'r"foo(\0057)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0057)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0057)foo"'\''|json -b8'
echo -ne 'r"foo(\0057)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0057)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0060)foo"'\''|json -b1'
echo -ne 'r"foo(\0060)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0060)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0060)foo"'\''|json -b2'
echo -ne 'r"foo(\0060)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0060)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0060)foo"'\''|json -b4'
echo -ne 'r"foo(\0060)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0060)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0060)foo"'\''|json -b8'
echo -ne 'r"foo(\0060)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0060)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0061)foo"'\''|json -b1'
echo -ne 'r"foo(\0061)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0061)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0061)foo"'\''|json -b2'
echo -ne 'r"foo(\0061)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0061)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0061)foo"'\''|json -b4'
echo -ne 'r"foo(\0061)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0061)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0061)foo"'\''|json -b8'
echo -ne 'r"foo(\0061)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0061)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0062)foo"'\''|json -b1'
echo -ne 'r"foo(\0062)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0062)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0062)foo"'\''|json -b2'
echo -ne 'r"foo(\0062)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0062)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0062)foo"'\''|json -b4'
echo -ne 'r"foo(\0062)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0062)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0062)foo"'\''|json -b8'
echo -ne 'r"foo(\0062)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0062)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0063)foo"'\''|json -b1'
echo -ne 'r"foo(\0063)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0063)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0063)foo"'\''|json -b2'
echo -ne 'r"foo(\0063)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0063)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0063)foo"'\''|json -b4'
echo -ne 'r"foo(\0063)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0063)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0063)foo"'\''|json -b8'
echo -ne 'r"foo(\0063)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0063)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0064)foo"'\''|json -b1'
echo -ne 'r"foo(\0064)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0064)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0064)foo"'\''|json -b2'
echo -ne 'r"foo(\0064)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0064)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0064)foo"'\''|json -b4'
echo -ne 'r"foo(\0064)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0064)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0064)foo"'\''|json -b8'
echo -ne 'r"foo(\0064)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0064)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0065)foo"'\''|json -b1'
echo -ne 'r"foo(\0065)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0065)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0065)foo"'\''|json -b2'
echo -ne 'r"foo(\0065)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0065)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0065)foo"'\''|json -b4'
echo -ne 'r"foo(\0065)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0065)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0065)foo"'\''|json -b8'
echo -ne 'r"foo(\0065)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0065)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0066)foo"'\''|json -b1'
echo -ne 'r"foo(\0066)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0066)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0066)foo"'\''|json -b2'
echo -ne 'r"foo(\0066)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0066)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0066)foo"'\''|json -b4'
echo -ne 'r"foo(\0066)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0066)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0066)foo"'\''|json -b8'
echo -ne 'r"foo(\0066)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0066)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0067)foo"'\''|json -b1'
echo -ne 'r"foo(\0067)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0067)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0067)foo"'\''|json -b2'
echo -ne 'r"foo(\0067)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0067)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0067)foo"'\''|json -b4'
echo -ne 'r"foo(\0067)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0067)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0067)foo"'\''|json -b8'
echo -ne 'r"foo(\0067)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0067)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0070)foo"'\''|json -b1'
echo -ne 'r"foo(\0070)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0070)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0070)foo"'\''|json -b2'
echo -ne 'r"foo(\0070)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0070)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0070)foo"'\''|json -b4'
echo -ne 'r"foo(\0070)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0070)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0070)foo"'\''|json -b8'
echo -ne 'r"foo(\0070)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0070)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0071)foo"'\''|json -b1'
echo -ne 'r"foo(\0071)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0071)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0071)foo"'\''|json -b2'
echo -ne 'r"foo(\0071)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0071)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0071)foo"'\''|json -b4'
echo -ne 'r"foo(\0071)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0071)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0071)foo"'\''|json -b8'
echo -ne 'r"foo(\0071)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0071)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0072)foo"'\''|json -b1'
echo -ne 'r"foo(\0072)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0072)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0072)foo"'\''|json -b2'
echo -ne 'r"foo(\0072)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0072)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0072)foo"'\''|json -b4'
echo -ne 'r"foo(\0072)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0072)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0072)foo"'\''|json -b8'
echo -ne 'r"foo(\0072)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0072)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0073)foo"'\''|json -b1'
echo -ne 'r"foo(\0073)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0073)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0073)foo"'\''|json -b2'
echo -ne 'r"foo(\0073)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0073)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0073)foo"'\''|json -b4'
echo -ne 'r"foo(\0073)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0073)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0073)foo"'\''|json -b8'
echo -ne 'r"foo(\0073)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0073)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0074)foo"'\''|json -b1'
echo -ne 'r"foo(\0074)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0074)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0074)foo"'\''|json -b2'
echo -ne 'r"foo(\0074)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0074)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0074)foo"'\''|json -b4'
echo -ne 'r"foo(\0074)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0074)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0074)foo"'\''|json -b8'
echo -ne 'r"foo(\0074)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0074)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0075)foo"'\''|json -b1'
echo -ne 'r"foo(\0075)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0075)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0075)foo"'\''|json -b2'
echo -ne 'r"foo(\0075)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0075)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0075)foo"'\''|json -b4'
echo -ne 'r"foo(\0075)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0075)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0075)foo"'\''|json -b8'
echo -ne 'r"foo(\0075)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0075)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0076)foo"'\''|json -b1'
echo -ne 'r"foo(\0076)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0076)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0076)foo"'\''|json -b2'
echo -ne 'r"foo(\0076)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0076)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0076)foo"'\''|json -b4'
echo -ne 'r"foo(\0076)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0076)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0076)foo"'\''|json -b8'
echo -ne 'r"foo(\0076)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0076)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0077)foo"'\''|json -b1'
echo -ne 'r"foo(\0077)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0077)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0077)foo"'\''|json -b2'
echo -ne 'r"foo(\0077)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0077)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0077)foo"'\''|json -b4'
echo -ne 'r"foo(\0077)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0077)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0077)foo"'\''|json -b8'
echo -ne 'r"foo(\0077)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0077)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0100)foo"'\''|json -b1'
echo -ne 'r"foo(\0100)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0100)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0100)foo"'\''|json -b2'
echo -ne 'r"foo(\0100)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0100)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0100)foo"'\''|json -b4'
echo -ne 'r"foo(\0100)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0100)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0100)foo"'\''|json -b8'
echo -ne 'r"foo(\0100)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0100)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0101)foo"'\''|json -b1'
echo -ne 'r"foo(\0101)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0101)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0101)foo"'\''|json -b2'
echo -ne 'r"foo(\0101)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0101)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0101)foo"'\''|json -b4'
echo -ne 'r"foo(\0101)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0101)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0101)foo"'\''|json -b8'
echo -ne 'r"foo(\0101)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0101)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0102)foo"'\''|json -b1'
echo -ne 'r"foo(\0102)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0102)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0102)foo"'\''|json -b2'
echo -ne 'r"foo(\0102)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0102)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0102)foo"'\''|json -b4'
echo -ne 'r"foo(\0102)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0102)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0102)foo"'\''|json -b8'
echo -ne 'r"foo(\0102)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0102)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0103)foo"'\''|json -b1'
echo -ne 'r"foo(\0103)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0103)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0103)foo"'\''|json -b2'
echo -ne 'r"foo(\0103)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0103)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0103)foo"'\''|json -b4'
echo -ne 'r"foo(\0103)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0103)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0103)foo"'\''|json -b8'
echo -ne 'r"foo(\0103)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0103)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0104)foo"'\''|json -b1'
echo -ne 'r"foo(\0104)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0104)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0104)foo"'\''|json -b2'
echo -ne 'r"foo(\0104)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0104)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0104)foo"'\''|json -b4'
echo -ne 'r"foo(\0104)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0104)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0104)foo"'\''|json -b8'
echo -ne 'r"foo(\0104)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0104)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0105)foo"'\''|json -b1'
echo -ne 'r"foo(\0105)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0105)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0105)foo"'\''|json -b2'
echo -ne 'r"foo(\0105)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0105)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0105)foo"'\''|json -b4'
echo -ne 'r"foo(\0105)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0105)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0105)foo"'\''|json -b8'
echo -ne 'r"foo(\0105)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0105)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0106)foo"'\''|json -b1'
echo -ne 'r"foo(\0106)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0106)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0106)foo"'\''|json -b2'
echo -ne 'r"foo(\0106)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0106)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0106)foo"'\''|json -b4'
echo -ne 'r"foo(\0106)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0106)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0106)foo"'\''|json -b8'
echo -ne 'r"foo(\0106)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0106)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0107)foo"'\''|json -b1'
echo -ne 'r"foo(\0107)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0107)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0107)foo"'\''|json -b2'
echo -ne 'r"foo(\0107)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0107)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0107)foo"'\''|json -b4'
echo -ne 'r"foo(\0107)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0107)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0107)foo"'\''|json -b8'
echo -ne 'r"foo(\0107)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0107)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0110)foo"'\''|json -b1'
echo -ne 'r"foo(\0110)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0110)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0110)foo"'\''|json -b2'
echo -ne 'r"foo(\0110)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0110)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0110)foo"'\''|json -b4'
echo -ne 'r"foo(\0110)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0110)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0110)foo"'\''|json -b8'
echo -ne 'r"foo(\0110)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0110)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0111)foo"'\''|json -b1'
echo -ne 'r"foo(\0111)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0111)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0111)foo"'\''|json -b2'
echo -ne 'r"foo(\0111)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0111)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0111)foo"'\''|json -b4'
echo -ne 'r"foo(\0111)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0111)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0111)foo"'\''|json -b8'
echo -ne 'r"foo(\0111)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0111)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0112)foo"'\''|json -b1'
echo -ne 'r"foo(\0112)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0112)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0112)foo"'\''|json -b2'
echo -ne 'r"foo(\0112)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0112)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0112)foo"'\''|json -b4'
echo -ne 'r"foo(\0112)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0112)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0112)foo"'\''|json -b8'
echo -ne 'r"foo(\0112)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0112)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0113)foo"'\''|json -b1'
echo -ne 'r"foo(\0113)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0113)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0113)foo"'\''|json -b2'
echo -ne 'r"foo(\0113)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0113)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0113)foo"'\''|json -b4'
echo -ne 'r"foo(\0113)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0113)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0113)foo"'\''|json -b8'
echo -ne 'r"foo(\0113)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0113)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0114)foo"'\''|json -b1'
echo -ne 'r"foo(\0114)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0114)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0114)foo"'\''|json -b2'
echo -ne 'r"foo(\0114)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0114)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0114)foo"'\''|json -b4'
echo -ne 'r"foo(\0114)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0114)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0114)foo"'\''|json -b8'
echo -ne 'r"foo(\0114)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0114)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0115)foo"'\''|json -b1'
echo -ne 'r"foo(\0115)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0115)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0115)foo"'\''|json -b2'
echo -ne 'r"foo(\0115)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0115)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0115)foo"'\''|json -b4'
echo -ne 'r"foo(\0115)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0115)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0115)foo"'\''|json -b8'
echo -ne 'r"foo(\0115)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0115)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0116)foo"'\''|json -b1'
echo -ne 'r"foo(\0116)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0116)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0116)foo"'\''|json -b2'
echo -ne 'r"foo(\0116)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0116)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0116)foo"'\''|json -b4'
echo -ne 'r"foo(\0116)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0116)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0116)foo"'\''|json -b8'
echo -ne 'r"foo(\0116)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0116)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0117)foo"'\''|json -b1'
echo -ne 'r"foo(\0117)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0117)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0117)foo"'\''|json -b2'
echo -ne 'r"foo(\0117)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0117)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0117)foo"'\''|json -b4'
echo -ne 'r"foo(\0117)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0117)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0117)foo"'\''|json -b8'
echo -ne 'r"foo(\0117)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0117)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0120)foo"'\''|json -b1'
echo -ne 'r"foo(\0120)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0120)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0120)foo"'\''|json -b2'
echo -ne 'r"foo(\0120)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0120)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0120)foo"'\''|json -b4'
echo -ne 'r"foo(\0120)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0120)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0120)foo"'\''|json -b8'
echo -ne 'r"foo(\0120)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0120)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0121)foo"'\''|json -b1'
echo -ne 'r"foo(\0121)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0121)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0121)foo"'\''|json -b2'
echo -ne 'r"foo(\0121)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0121)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0121)foo"'\''|json -b4'
echo -ne 'r"foo(\0121)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0121)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0121)foo"'\''|json -b8'
echo -ne 'r"foo(\0121)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0121)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0122)foo"'\''|json -b1'
echo -ne 'r"foo(\0122)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0122)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0122)foo"'\''|json -b2'
echo -ne 'r"foo(\0122)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0122)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0122)foo"'\''|json -b4'
echo -ne 'r"foo(\0122)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0122)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0122)foo"'\''|json -b8'
echo -ne 'r"foo(\0122)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0122)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0123)foo"'\''|json -b1'
echo -ne 'r"foo(\0123)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0123)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0123)foo"'\''|json -b2'
echo -ne 'r"foo(\0123)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0123)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0123)foo"'\''|json -b4'
echo -ne 'r"foo(\0123)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0123)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0123)foo"'\''|json -b8'
echo -ne 'r"foo(\0123)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0123)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0124)foo"'\''|json -b1'
echo -ne 'r"foo(\0124)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0124)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0124)foo"'\''|json -b2'
echo -ne 'r"foo(\0124)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0124)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0124)foo"'\''|json -b4'
echo -ne 'r"foo(\0124)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0124)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0124)foo"'\''|json -b8'
echo -ne 'r"foo(\0124)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0124)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0125)foo"'\''|json -b1'
echo -ne 'r"foo(\0125)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0125)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0125)foo"'\''|json -b2'
echo -ne 'r"foo(\0125)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0125)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0125)foo"'\''|json -b4'
echo -ne 'r"foo(\0125)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0125)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0125)foo"'\''|json -b8'
echo -ne 'r"foo(\0125)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0125)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0126)foo"'\''|json -b1'
echo -ne 'r"foo(\0126)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0126)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0126)foo"'\''|json -b2'
echo -ne 'r"foo(\0126)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0126)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0126)foo"'\''|json -b4'
echo -ne 'r"foo(\0126)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0126)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0126)foo"'\''|json -b8'
echo -ne 'r"foo(\0126)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0126)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0127)foo"'\''|json -b1'
echo -ne 'r"foo(\0127)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0127)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0127)foo"'\''|json -b2'
echo -ne 'r"foo(\0127)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0127)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0127)foo"'\''|json -b4'
echo -ne 'r"foo(\0127)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0127)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0127)foo"'\''|json -b8'
echo -ne 'r"foo(\0127)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0127)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0130)foo"'\''|json -b1'
echo -ne 'r"foo(\0130)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0130)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0130)foo"'\''|json -b2'
echo -ne 'r"foo(\0130)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0130)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0130)foo"'\''|json -b4'
echo -ne 'r"foo(\0130)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0130)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0130)foo"'\''|json -b8'
echo -ne 'r"foo(\0130)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0130)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0131)foo"'\''|json -b1'
echo -ne 'r"foo(\0131)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0131)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0131)foo"'\''|json -b2'
echo -ne 'r"foo(\0131)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0131)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0131)foo"'\''|json -b4'
echo -ne 'r"foo(\0131)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0131)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0131)foo"'\''|json -b8'
echo -ne 'r"foo(\0131)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0131)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0132)foo"'\''|json -b1'
echo -ne 'r"foo(\0132)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0132)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0132)foo"'\''|json -b2'
echo -ne 'r"foo(\0132)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0132)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0132)foo"'\''|json -b4'
echo -ne 'r"foo(\0132)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0132)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0132)foo"'\''|json -b8'
echo -ne 'r"foo(\0132)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0132)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0133)foo"'\''|json -b1'
echo -ne 'r"foo(\0133)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0133)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0133)foo"'\''|json -b2'
echo -ne 'r"foo(\0133)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0133)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0133)foo"'\''|json -b4'
echo -ne 'r"foo(\0133)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0133)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0133)foo"'\''|json -b8'
echo -ne 'r"foo(\0133)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0133)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0134)foo"'\''|json -b1'
echo -ne 'r"foo(\0134)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0134)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0134)foo"'\''|json -b2'
echo -ne 'r"foo(\0134)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0134)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0134)foo"'\''|json -b4'
echo -ne 'r"foo(\0134)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0134)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0134)foo"'\''|json -b8'
echo -ne 'r"foo(\0134)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0134)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0135)foo"'\''|json -b1'
echo -ne 'r"foo(\0135)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0135)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0135)foo"'\''|json -b2'
echo -ne 'r"foo(\0135)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0135)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0135)foo"'\''|json -b4'
echo -ne 'r"foo(\0135)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0135)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0135)foo"'\''|json -b8'
echo -ne 'r"foo(\0135)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0135)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0136)foo"'\''|json -b1'
echo -ne 'r"foo(\0136)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0136)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0136)foo"'\''|json -b2'
echo -ne 'r"foo(\0136)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0136)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0136)foo"'\''|json -b4'
echo -ne 'r"foo(\0136)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0136)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0136)foo"'\''|json -b8'
echo -ne 'r"foo(\0136)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0136)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0137)foo"'\''|json -b1'
echo -ne 'r"foo(\0137)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0137)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0137)foo"'\''|json -b2'
echo -ne 'r"foo(\0137)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0137)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0137)foo"'\''|json -b4'
echo -ne 'r"foo(\0137)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0137)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0137)foo"'\''|json -b8'
echo -ne 'r"foo(\0137)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0137)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0140)foo"'\''|json -b1'
echo -ne 'r"foo(\0140)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0140)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0140)foo"'\''|json -b2'
echo -ne 'r"foo(\0140)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0140)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0140)foo"'\''|json -b4'
echo -ne 'r"foo(\0140)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0140)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0140)foo"'\''|json -b8'
echo -ne 'r"foo(\0140)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0140)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0141)foo"'\''|json -b1'
echo -ne 'r"foo(\0141)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0141)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0141)foo"'\''|json -b2'
echo -ne 'r"foo(\0141)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0141)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0141)foo"'\''|json -b4'
echo -ne 'r"foo(\0141)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0141)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0141)foo"'\''|json -b8'
echo -ne 'r"foo(\0141)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0141)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0142)foo"'\''|json -b1'
echo -ne 'r"foo(\0142)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0142)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0142)foo"'\''|json -b2'
echo -ne 'r"foo(\0142)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0142)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0142)foo"'\''|json -b4'
echo -ne 'r"foo(\0142)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0142)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0142)foo"'\''|json -b8'
echo -ne 'r"foo(\0142)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0142)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0143)foo"'\''|json -b1'
echo -ne 'r"foo(\0143)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0143)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0143)foo"'\''|json -b2'
echo -ne 'r"foo(\0143)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0143)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0143)foo"'\''|json -b4'
echo -ne 'r"foo(\0143)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0143)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0143)foo"'\''|json -b8'
echo -ne 'r"foo(\0143)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0143)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0144)foo"'\''|json -b1'
echo -ne 'r"foo(\0144)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0144)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0144)foo"'\''|json -b2'
echo -ne 'r"foo(\0144)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0144)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0144)foo"'\''|json -b4'
echo -ne 'r"foo(\0144)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0144)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0144)foo"'\''|json -b8'
echo -ne 'r"foo(\0144)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0144)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0145)foo"'\''|json -b1'
echo -ne 'r"foo(\0145)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0145)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0145)foo"'\''|json -b2'
echo -ne 'r"foo(\0145)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0145)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0145)foo"'\''|json -b4'
echo -ne 'r"foo(\0145)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0145)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0145)foo"'\''|json -b8'
echo -ne 'r"foo(\0145)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0145)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0146)foo"'\''|json -b1'
echo -ne 'r"foo(\0146)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0146)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0146)foo"'\''|json -b2'
echo -ne 'r"foo(\0146)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0146)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0146)foo"'\''|json -b4'
echo -ne 'r"foo(\0146)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0146)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0146)foo"'\''|json -b8'
echo -ne 'r"foo(\0146)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0146)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0147)foo"'\''|json -b1'
echo -ne 'r"foo(\0147)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0147)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0147)foo"'\''|json -b2'
echo -ne 'r"foo(\0147)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0147)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0147)foo"'\''|json -b4'
echo -ne 'r"foo(\0147)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0147)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0147)foo"'\''|json -b8'
echo -ne 'r"foo(\0147)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0147)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0150)foo"'\''|json -b1'
echo -ne 'r"foo(\0150)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0150)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0150)foo"'\''|json -b2'
echo -ne 'r"foo(\0150)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0150)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0150)foo"'\''|json -b4'
echo -ne 'r"foo(\0150)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0150)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0150)foo"'\''|json -b8'
echo -ne 'r"foo(\0150)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0150)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0151)foo"'\''|json -b1'
echo -ne 'r"foo(\0151)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0151)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0151)foo"'\''|json -b2'
echo -ne 'r"foo(\0151)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0151)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0151)foo"'\''|json -b4'
echo -ne 'r"foo(\0151)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0151)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0151)foo"'\''|json -b8'
echo -ne 'r"foo(\0151)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0151)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0152)foo"'\''|json -b1'
echo -ne 'r"foo(\0152)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0152)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0152)foo"'\''|json -b2'
echo -ne 'r"foo(\0152)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0152)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0152)foo"'\''|json -b4'
echo -ne 'r"foo(\0152)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0152)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0152)foo"'\''|json -b8'
echo -ne 'r"foo(\0152)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0152)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0153)foo"'\''|json -b1'
echo -ne 'r"foo(\0153)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0153)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0153)foo"'\''|json -b2'
echo -ne 'r"foo(\0153)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0153)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0153)foo"'\''|json -b4'
echo -ne 'r"foo(\0153)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0153)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0153)foo"'\''|json -b8'
echo -ne 'r"foo(\0153)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0153)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0154)foo"'\''|json -b1'
echo -ne 'r"foo(\0154)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0154)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0154)foo"'\''|json -b2'
echo -ne 'r"foo(\0154)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0154)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0154)foo"'\''|json -b4'
echo -ne 'r"foo(\0154)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0154)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0154)foo"'\''|json -b8'
echo -ne 'r"foo(\0154)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0154)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0155)foo"'\''|json -b1'
echo -ne 'r"foo(\0155)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0155)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0155)foo"'\''|json -b2'
echo -ne 'r"foo(\0155)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0155)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0155)foo"'\''|json -b4'
echo -ne 'r"foo(\0155)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0155)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0155)foo"'\''|json -b8'
echo -ne 'r"foo(\0155)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0155)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0156)foo"'\''|json -b1'
echo -ne 'r"foo(\0156)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0156)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0156)foo"'\''|json -b2'
echo -ne 'r"foo(\0156)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0156)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0156)foo"'\''|json -b4'
echo -ne 'r"foo(\0156)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0156)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0156)foo"'\''|json -b8'
echo -ne 'r"foo(\0156)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0156)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0157)foo"'\''|json -b1'
echo -ne 'r"foo(\0157)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0157)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0157)foo"'\''|json -b2'
echo -ne 'r"foo(\0157)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0157)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0157)foo"'\''|json -b4'
echo -ne 'r"foo(\0157)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0157)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0157)foo"'\''|json -b8'
echo -ne 'r"foo(\0157)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0157)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0160)foo"'\''|json -b1'
echo -ne 'r"foo(\0160)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0160)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0160)foo"'\''|json -b2'
echo -ne 'r"foo(\0160)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0160)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0160)foo"'\''|json -b4'
echo -ne 'r"foo(\0160)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0160)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0160)foo"'\''|json -b8'
echo -ne 'r"foo(\0160)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0160)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0161)foo"'\''|json -b1'
echo -ne 'r"foo(\0161)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0161)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0161)foo"'\''|json -b2'
echo -ne 'r"foo(\0161)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0161)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0161)foo"'\''|json -b4'
echo -ne 'r"foo(\0161)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0161)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0161)foo"'\''|json -b8'
echo -ne 'r"foo(\0161)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0161)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0162)foo"'\''|json -b1'
echo -ne 'r"foo(\0162)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0162)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0162)foo"'\''|json -b2'
echo -ne 'r"foo(\0162)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0162)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0162)foo"'\''|json -b4'
echo -ne 'r"foo(\0162)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0162)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0162)foo"'\''|json -b8'
echo -ne 'r"foo(\0162)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0162)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0163)foo"'\''|json -b1'
echo -ne 'r"foo(\0163)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0163)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0163)foo"'\''|json -b2'
echo -ne 'r"foo(\0163)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0163)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0163)foo"'\''|json -b4'
echo -ne 'r"foo(\0163)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0163)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0163)foo"'\''|json -b8'
echo -ne 'r"foo(\0163)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0163)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0164)foo"'\''|json -b1'
echo -ne 'r"foo(\0164)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0164)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0164)foo"'\''|json -b2'
echo -ne 'r"foo(\0164)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0164)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0164)foo"'\''|json -b4'
echo -ne 'r"foo(\0164)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0164)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0164)foo"'\''|json -b8'
echo -ne 'r"foo(\0164)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0164)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0165)foo"'\''|json -b1'
echo -ne 'r"foo(\0165)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0165)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0165)foo"'\''|json -b2'
echo -ne 'r"foo(\0165)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0165)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0165)foo"'\''|json -b4'
echo -ne 'r"foo(\0165)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0165)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0165)foo"'\''|json -b8'
echo -ne 'r"foo(\0165)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0165)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0166)foo"'\''|json -b1'
echo -ne 'r"foo(\0166)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0166)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0166)foo"'\''|json -b2'
echo -ne 'r"foo(\0166)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0166)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0166)foo"'\''|json -b4'
echo -ne 'r"foo(\0166)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0166)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0166)foo"'\''|json -b8'
echo -ne 'r"foo(\0166)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0166)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0167)foo"'\''|json -b1'
echo -ne 'r"foo(\0167)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0167)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0167)foo"'\''|json -b2'
echo -ne 'r"foo(\0167)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0167)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0167)foo"'\''|json -b4'
echo -ne 'r"foo(\0167)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0167)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0167)foo"'\''|json -b8'
echo -ne 'r"foo(\0167)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0167)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0170)foo"'\''|json -b1'
echo -ne 'r"foo(\0170)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0170)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0170)foo"'\''|json -b2'
echo -ne 'r"foo(\0170)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0170)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0170)foo"'\''|json -b4'
echo -ne 'r"foo(\0170)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0170)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0170)foo"'\''|json -b8'
echo -ne 'r"foo(\0170)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0170)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0171)foo"'\''|json -b1'
echo -ne 'r"foo(\0171)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0171)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0171)foo"'\''|json -b2'
echo -ne 'r"foo(\0171)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0171)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0171)foo"'\''|json -b4'
echo -ne 'r"foo(\0171)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0171)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0171)foo"'\''|json -b8'
echo -ne 'r"foo(\0171)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0171)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0172)foo"'\''|json -b1'
echo -ne 'r"foo(\0172)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0172)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0172)foo"'\''|json -b2'
echo -ne 'r"foo(\0172)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0172)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0172)foo"'\''|json -b4'
echo -ne 'r"foo(\0172)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0172)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0172)foo"'\''|json -b8'
echo -ne 'r"foo(\0172)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0172)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0173)foo"'\''|json -b1'
echo -ne 'r"foo(\0173)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0173)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0173)foo"'\''|json -b2'
echo -ne 'r"foo(\0173)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0173)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0173)foo"'\''|json -b4'
echo -ne 'r"foo(\0173)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0173)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0173)foo"'\''|json -b8'
echo -ne 'r"foo(\0173)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0173)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0174)foo"'\''|json -b1'
echo -ne 'r"foo(\0174)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0174)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0174)foo"'\''|json -b2'
echo -ne 'r"foo(\0174)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0174)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0174)foo"'\''|json -b4'
echo -ne 'r"foo(\0174)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0174)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0174)foo"'\''|json -b8'
echo -ne 'r"foo(\0174)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0174)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0175)foo"'\''|json -b1'
echo -ne 'r"foo(\0175)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0175)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0175)foo"'\''|json -b2'
echo -ne 'r"foo(\0175)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0175)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0175)foo"'\''|json -b4'
echo -ne 'r"foo(\0175)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0175)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0175)foo"'\''|json -b8'
echo -ne 'r"foo(\0175)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0175)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0176)foo"'\''|json -b1'
echo -ne 'r"foo(\0176)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0176)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0176)foo"'\''|json -b2'
echo -ne 'r"foo(\0176)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0176)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0176)foo"'\''|json -b4'
echo -ne 'r"foo(\0176)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0176)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0176)foo"'\''|json -b8'
echo -ne 'r"foo(\0176)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0176)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0177)foo"'\''|json -b1'
echo -ne 'r"foo(\0177)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0177)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0177)foo"'\''|json -b2'
echo -ne 'r"foo(\0177)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0177)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0177)foo"'\''|json -b4'
echo -ne 'r"foo(\0177)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0177)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0177)foo"'\''|json -b8'
echo -ne 'r"foo(\0177)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0177)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0200)foo"'\''|json -b1'
echo -ne 'r"foo(\0200)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0200)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0200)foo"'\''|json -b2'
echo -ne 'r"foo(\0200)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0200)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0200)foo"'\''|json -b4'
echo -ne 'r"foo(\0200)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0200)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0200)foo"'\''|json -b8'
echo -ne 'r"foo(\0200)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0200)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0201)foo"'\''|json -b1'
echo -ne 'r"foo(\0201)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0201)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0201)foo"'\''|json -b2'
echo -ne 'r"foo(\0201)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0201)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0201)foo"'\''|json -b4'
echo -ne 'r"foo(\0201)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0201)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0201)foo"'\''|json -b8'
echo -ne 'r"foo(\0201)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0201)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0202)foo"'\''|json -b1'
echo -ne 'r"foo(\0202)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0202)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0202)foo"'\''|json -b2'
echo -ne 'r"foo(\0202)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0202)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0202)foo"'\''|json -b4'
echo -ne 'r"foo(\0202)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0202)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0202)foo"'\''|json -b8'
echo -ne 'r"foo(\0202)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0202)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0203)foo"'\''|json -b1'
echo -ne 'r"foo(\0203)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0203)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0203)foo"'\''|json -b2'
echo -ne 'r"foo(\0203)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0203)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0203)foo"'\''|json -b4'
echo -ne 'r"foo(\0203)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0203)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0203)foo"'\''|json -b8'
echo -ne 'r"foo(\0203)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0203)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0204)foo"'\''|json -b1'
echo -ne 'r"foo(\0204)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0204)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0204)foo"'\''|json -b2'
echo -ne 'r"foo(\0204)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0204)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0204)foo"'\''|json -b4'
echo -ne 'r"foo(\0204)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0204)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0204)foo"'\''|json -b8'
echo -ne 'r"foo(\0204)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0204)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0205)foo"'\''|json -b1'
echo -ne 'r"foo(\0205)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0205)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0205)foo"'\''|json -b2'
echo -ne 'r"foo(\0205)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0205)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0205)foo"'\''|json -b4'
echo -ne 'r"foo(\0205)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0205)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0205)foo"'\''|json -b8'
echo -ne 'r"foo(\0205)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0205)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0206)foo"'\''|json -b1'
echo -ne 'r"foo(\0206)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0206)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0206)foo"'\''|json -b2'
echo -ne 'r"foo(\0206)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0206)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0206)foo"'\''|json -b4'
echo -ne 'r"foo(\0206)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0206)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0206)foo"'\''|json -b8'
echo -ne 'r"foo(\0206)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0206)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0207)foo"'\''|json -b1'
echo -ne 'r"foo(\0207)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0207)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0207)foo"'\''|json -b2'
echo -ne 'r"foo(\0207)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0207)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0207)foo"'\''|json -b4'
echo -ne 'r"foo(\0207)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0207)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0207)foo"'\''|json -b8'
echo -ne 'r"foo(\0207)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0207)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0210)foo"'\''|json -b1'
echo -ne 'r"foo(\0210)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0210)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0210)foo"'\''|json -b2'
echo -ne 'r"foo(\0210)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0210)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0210)foo"'\''|json -b4'
echo -ne 'r"foo(\0210)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0210)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0210)foo"'\''|json -b8'
echo -ne 'r"foo(\0210)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0210)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0211)foo"'\''|json -b1'
echo -ne 'r"foo(\0211)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0211)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0211)foo"'\''|json -b2'
echo -ne 'r"foo(\0211)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0211)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0211)foo"'\''|json -b4'
echo -ne 'r"foo(\0211)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0211)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0211)foo"'\''|json -b8'
echo -ne 'r"foo(\0211)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0211)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0212)foo"'\''|json -b1'
echo -ne 'r"foo(\0212)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0212)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0212)foo"'\''|json -b2'
echo -ne 'r"foo(\0212)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0212)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0212)foo"'\''|json -b4'
echo -ne 'r"foo(\0212)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0212)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0212)foo"'\''|json -b8'
echo -ne 'r"foo(\0212)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0212)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0213)foo"'\''|json -b1'
echo -ne 'r"foo(\0213)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0213)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0213)foo"'\''|json -b2'
echo -ne 'r"foo(\0213)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0213)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0213)foo"'\''|json -b4'
echo -ne 'r"foo(\0213)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0213)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0213)foo"'\''|json -b8'
echo -ne 'r"foo(\0213)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0213)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0214)foo"'\''|json -b1'
echo -ne 'r"foo(\0214)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0214)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0214)foo"'\''|json -b2'
echo -ne 'r"foo(\0214)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0214)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0214)foo"'\''|json -b4'
echo -ne 'r"foo(\0214)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0214)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0214)foo"'\''|json -b8'
echo -ne 'r"foo(\0214)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0214)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0215)foo"'\''|json -b1'
echo -ne 'r"foo(\0215)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0215)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0215)foo"'\''|json -b2'
echo -ne 'r"foo(\0215)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0215)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0215)foo"'\''|json -b4'
echo -ne 'r"foo(\0215)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0215)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0215)foo"'\''|json -b8'
echo -ne 'r"foo(\0215)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0215)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0216)foo"'\''|json -b1'
echo -ne 'r"foo(\0216)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0216)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0216)foo"'\''|json -b2'
echo -ne 'r"foo(\0216)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0216)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0216)foo"'\''|json -b4'
echo -ne 'r"foo(\0216)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0216)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0216)foo"'\''|json -b8'
echo -ne 'r"foo(\0216)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0216)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0217)foo"'\''|json -b1'
echo -ne 'r"foo(\0217)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0217)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0217)foo"'\''|json -b2'
echo -ne 'r"foo(\0217)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0217)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0217)foo"'\''|json -b4'
echo -ne 'r"foo(\0217)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0217)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0217)foo"'\''|json -b8'
echo -ne 'r"foo(\0217)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0217)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0220)foo"'\''|json -b1'
echo -ne 'r"foo(\0220)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0220)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0220)foo"'\''|json -b2'
echo -ne 'r"foo(\0220)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0220)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0220)foo"'\''|json -b4'
echo -ne 'r"foo(\0220)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0220)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0220)foo"'\''|json -b8'
echo -ne 'r"foo(\0220)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0220)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0221)foo"'\''|json -b1'
echo -ne 'r"foo(\0221)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0221)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0221)foo"'\''|json -b2'
echo -ne 'r"foo(\0221)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0221)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0221)foo"'\''|json -b4'
echo -ne 'r"foo(\0221)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0221)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0221)foo"'\''|json -b8'
echo -ne 'r"foo(\0221)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0221)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0222)foo"'\''|json -b1'
echo -ne 'r"foo(\0222)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0222)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0222)foo"'\''|json -b2'
echo -ne 'r"foo(\0222)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0222)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0222)foo"'\''|json -b4'
echo -ne 'r"foo(\0222)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0222)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0222)foo"'\''|json -b8'
echo -ne 'r"foo(\0222)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0222)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0223)foo"'\''|json -b1'
echo -ne 'r"foo(\0223)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0223)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0223)foo"'\''|json -b2'
echo -ne 'r"foo(\0223)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0223)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0223)foo"'\''|json -b4'
echo -ne 'r"foo(\0223)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0223)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0223)foo"'\''|json -b8'
echo -ne 'r"foo(\0223)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0223)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0224)foo"'\''|json -b1'
echo -ne 'r"foo(\0224)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0224)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0224)foo"'\''|json -b2'
echo -ne 'r"foo(\0224)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0224)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0224)foo"'\''|json -b4'
echo -ne 'r"foo(\0224)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0224)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0224)foo"'\''|json -b8'
echo -ne 'r"foo(\0224)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0224)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0225)foo"'\''|json -b1'
echo -ne 'r"foo(\0225)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0225)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0225)foo"'\''|json -b2'
echo -ne 'r"foo(\0225)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0225)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0225)foo"'\''|json -b4'
echo -ne 'r"foo(\0225)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0225)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0225)foo"'\''|json -b8'
echo -ne 'r"foo(\0225)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0225)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0226)foo"'\''|json -b1'
echo -ne 'r"foo(\0226)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0226)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0226)foo"'\''|json -b2'
echo -ne 'r"foo(\0226)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0226)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0226)foo"'\''|json -b4'
echo -ne 'r"foo(\0226)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0226)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0226)foo"'\''|json -b8'
echo -ne 'r"foo(\0226)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0226)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0227)foo"'\''|json -b1'
echo -ne 'r"foo(\0227)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0227)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0227)foo"'\''|json -b2'
echo -ne 'r"foo(\0227)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0227)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0227)foo"'\''|json -b4'
echo -ne 'r"foo(\0227)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0227)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0227)foo"'\''|json -b8'
echo -ne 'r"foo(\0227)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0227)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0230)foo"'\''|json -b1'
echo -ne 'r"foo(\0230)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0230)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0230)foo"'\''|json -b2'
echo -ne 'r"foo(\0230)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0230)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0230)foo"'\''|json -b4'
echo -ne 'r"foo(\0230)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0230)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0230)foo"'\''|json -b8'
echo -ne 'r"foo(\0230)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0230)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0231)foo"'\''|json -b1'
echo -ne 'r"foo(\0231)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0231)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0231)foo"'\''|json -b2'
echo -ne 'r"foo(\0231)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0231)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0231)foo"'\''|json -b4'
echo -ne 'r"foo(\0231)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0231)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0231)foo"'\''|json -b8'
echo -ne 'r"foo(\0231)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0231)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0232)foo"'\''|json -b1'
echo -ne 'r"foo(\0232)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0232)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0232)foo"'\''|json -b2'
echo -ne 'r"foo(\0232)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0232)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0232)foo"'\''|json -b4'
echo -ne 'r"foo(\0232)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0232)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0232)foo"'\''|json -b8'
echo -ne 'r"foo(\0232)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0232)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0233)foo"'\''|json -b1'
echo -ne 'r"foo(\0233)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0233)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0233)foo"'\''|json -b2'
echo -ne 'r"foo(\0233)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0233)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0233)foo"'\''|json -b4'
echo -ne 'r"foo(\0233)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0233)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0233)foo"'\''|json -b8'
echo -ne 'r"foo(\0233)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0233)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0234)foo"'\''|json -b1'
echo -ne 'r"foo(\0234)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0234)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0234)foo"'\''|json -b2'
echo -ne 'r"foo(\0234)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0234)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0234)foo"'\''|json -b4'
echo -ne 'r"foo(\0234)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0234)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0234)foo"'\''|json -b8'
echo -ne 'r"foo(\0234)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0234)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0235)foo"'\''|json -b1'
echo -ne 'r"foo(\0235)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0235)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0235)foo"'\''|json -b2'
echo -ne 'r"foo(\0235)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0235)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0235)foo"'\''|json -b4'
echo -ne 'r"foo(\0235)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0235)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0235)foo"'\''|json -b8'
echo -ne 'r"foo(\0235)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0235)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0236)foo"'\''|json -b1'
echo -ne 'r"foo(\0236)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0236)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0236)foo"'\''|json -b2'
echo -ne 'r"foo(\0236)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0236)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0236)foo"'\''|json -b4'
echo -ne 'r"foo(\0236)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0236)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0236)foo"'\''|json -b8'
echo -ne 'r"foo(\0236)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0236)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0237)foo"'\''|json -b1'
echo -ne 'r"foo(\0237)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0237)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0237)foo"'\''|json -b2'
echo -ne 'r"foo(\0237)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0237)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0237)foo"'\''|json -b4'
echo -ne 'r"foo(\0237)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0237)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0237)foo"'\''|json -b8'
echo -ne 'r"foo(\0237)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0237)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0240)foo"'\''|json -b1'
echo -ne 'r"foo(\0240)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0240)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0240)foo"'\''|json -b2'
echo -ne 'r"foo(\0240)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0240)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0240)foo"'\''|json -b4'
echo -ne 'r"foo(\0240)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0240)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0240)foo"'\''|json -b8'
echo -ne 'r"foo(\0240)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0240)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0241)foo"'\''|json -b1'
echo -ne 'r"foo(\0241)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0241)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0241)foo"'\''|json -b2'
echo -ne 'r"foo(\0241)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0241)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0241)foo"'\''|json -b4'
echo -ne 'r"foo(\0241)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0241)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0241)foo"'\''|json -b8'
echo -ne 'r"foo(\0241)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0241)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0242)foo"'\''|json -b1'
echo -ne 'r"foo(\0242)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0242)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0242)foo"'\''|json -b2'
echo -ne 'r"foo(\0242)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0242)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0242)foo"'\''|json -b4'
echo -ne 'r"foo(\0242)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0242)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0242)foo"'\''|json -b8'
echo -ne 'r"foo(\0242)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0242)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0243)foo"'\''|json -b1'
echo -ne 'r"foo(\0243)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0243)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0243)foo"'\''|json -b2'
echo -ne 'r"foo(\0243)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0243)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0243)foo"'\''|json -b4'
echo -ne 'r"foo(\0243)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0243)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0243)foo"'\''|json -b8'
echo -ne 'r"foo(\0243)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0243)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0244)foo"'\''|json -b1'
echo -ne 'r"foo(\0244)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0244)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0244)foo"'\''|json -b2'
echo -ne 'r"foo(\0244)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0244)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0244)foo"'\''|json -b4'
echo -ne 'r"foo(\0244)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0244)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0244)foo"'\''|json -b8'
echo -ne 'r"foo(\0244)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0244)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0245)foo"'\''|json -b1'
echo -ne 'r"foo(\0245)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0245)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0245)foo"'\''|json -b2'
echo -ne 'r"foo(\0245)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0245)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0245)foo"'\''|json -b4'
echo -ne 'r"foo(\0245)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0245)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0245)foo"'\''|json -b8'
echo -ne 'r"foo(\0245)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0245)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0246)foo"'\''|json -b1'
echo -ne 'r"foo(\0246)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0246)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0246)foo"'\''|json -b2'
echo -ne 'r"foo(\0246)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0246)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0246)foo"'\''|json -b4'
echo -ne 'r"foo(\0246)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0246)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0246)foo"'\''|json -b8'
echo -ne 'r"foo(\0246)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0246)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0247)foo"'\''|json -b1'
echo -ne 'r"foo(\0247)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0247)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0247)foo"'\''|json -b2'
echo -ne 'r"foo(\0247)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0247)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0247)foo"'\''|json -b4'
echo -ne 'r"foo(\0247)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0247)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0247)foo"'\''|json -b8'
echo -ne 'r"foo(\0247)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0247)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0250)foo"'\''|json -b1'
echo -ne 'r"foo(\0250)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0250)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0250)foo"'\''|json -b2'
echo -ne 'r"foo(\0250)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0250)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0250)foo"'\''|json -b4'
echo -ne 'r"foo(\0250)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0250)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0250)foo"'\''|json -b8'
echo -ne 'r"foo(\0250)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0250)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0251)foo"'\''|json -b1'
echo -ne 'r"foo(\0251)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0251)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0251)foo"'\''|json -b2'
echo -ne 'r"foo(\0251)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0251)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0251)foo"'\''|json -b4'
echo -ne 'r"foo(\0251)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0251)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0251)foo"'\''|json -b8'
echo -ne 'r"foo(\0251)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0251)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0252)foo"'\''|json -b1'
echo -ne 'r"foo(\0252)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0252)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0252)foo"'\''|json -b2'
echo -ne 'r"foo(\0252)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0252)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0252)foo"'\''|json -b4'
echo -ne 'r"foo(\0252)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0252)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0252)foo"'\''|json -b8'
echo -ne 'r"foo(\0252)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0252)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0253)foo"'\''|json -b1'
echo -ne 'r"foo(\0253)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0253)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0253)foo"'\''|json -b2'
echo -ne 'r"foo(\0253)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0253)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0253)foo"'\''|json -b4'
echo -ne 'r"foo(\0253)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0253)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0253)foo"'\''|json -b8'
echo -ne 'r"foo(\0253)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0253)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0254)foo"'\''|json -b1'
echo -ne 'r"foo(\0254)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0254)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0254)foo"'\''|json -b2'
echo -ne 'r"foo(\0254)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0254)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0254)foo"'\''|json -b4'
echo -ne 'r"foo(\0254)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0254)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0254)foo"'\''|json -b8'
echo -ne 'r"foo(\0254)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0254)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0255)foo"'\''|json -b1'
echo -ne 'r"foo(\0255)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0255)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0255)foo"'\''|json -b2'
echo -ne 'r"foo(\0255)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0255)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0255)foo"'\''|json -b4'
echo -ne 'r"foo(\0255)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0255)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0255)foo"'\''|json -b8'
echo -ne 'r"foo(\0255)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0255)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0256)foo"'\''|json -b1'
echo -ne 'r"foo(\0256)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0256)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0256)foo"'\''|json -b2'
echo -ne 'r"foo(\0256)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0256)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0256)foo"'\''|json -b4'
echo -ne 'r"foo(\0256)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0256)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0256)foo"'\''|json -b8'
echo -ne 'r"foo(\0256)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0256)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0257)foo"'\''|json -b1'
echo -ne 'r"foo(\0257)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0257)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0257)foo"'\''|json -b2'
echo -ne 'r"foo(\0257)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0257)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0257)foo"'\''|json -b4'
echo -ne 'r"foo(\0257)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0257)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0257)foo"'\''|json -b8'
echo -ne 'r"foo(\0257)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0257)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0260)foo"'\''|json -b1'
echo -ne 'r"foo(\0260)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0260)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0260)foo"'\''|json -b2'
echo -ne 'r"foo(\0260)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0260)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0260)foo"'\''|json -b4'
echo -ne 'r"foo(\0260)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0260)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0260)foo"'\''|json -b8'
echo -ne 'r"foo(\0260)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0260)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0261)foo"'\''|json -b1'
echo -ne 'r"foo(\0261)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0261)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0261)foo"'\''|json -b2'
echo -ne 'r"foo(\0261)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0261)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0261)foo"'\''|json -b4'
echo -ne 'r"foo(\0261)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0261)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0261)foo"'\''|json -b8'
echo -ne 'r"foo(\0261)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0261)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0262)foo"'\''|json -b1'
echo -ne 'r"foo(\0262)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0262)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0262)foo"'\''|json -b2'
echo -ne 'r"foo(\0262)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0262)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0262)foo"'\''|json -b4'
echo -ne 'r"foo(\0262)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0262)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0262)foo"'\''|json -b8'
echo -ne 'r"foo(\0262)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0262)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0263)foo"'\''|json -b1'
echo -ne 'r"foo(\0263)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0263)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0263)foo"'\''|json -b2'
echo -ne 'r"foo(\0263)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0263)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0263)foo"'\''|json -b4'
echo -ne 'r"foo(\0263)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0263)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0263)foo"'\''|json -b8'
echo -ne 'r"foo(\0263)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0263)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0264)foo"'\''|json -b1'
echo -ne 'r"foo(\0264)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0264)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0264)foo"'\''|json -b2'
echo -ne 'r"foo(\0264)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0264)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0264)foo"'\''|json -b4'
echo -ne 'r"foo(\0264)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0264)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0264)foo"'\''|json -b8'
echo -ne 'r"foo(\0264)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0264)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0265)foo"'\''|json -b1'
echo -ne 'r"foo(\0265)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0265)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0265)foo"'\''|json -b2'
echo -ne 'r"foo(\0265)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0265)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0265)foo"'\''|json -b4'
echo -ne 'r"foo(\0265)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0265)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0265)foo"'\''|json -b8'
echo -ne 'r"foo(\0265)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0265)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0266)foo"'\''|json -b1'
echo -ne 'r"foo(\0266)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0266)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0266)foo"'\''|json -b2'
echo -ne 'r"foo(\0266)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0266)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0266)foo"'\''|json -b4'
echo -ne 'r"foo(\0266)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0266)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0266)foo"'\''|json -b8'
echo -ne 'r"foo(\0266)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0266)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0267)foo"'\''|json -b1'
echo -ne 'r"foo(\0267)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0267)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0267)foo"'\''|json -b2'
echo -ne 'r"foo(\0267)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0267)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0267)foo"'\''|json -b4'
echo -ne 'r"foo(\0267)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0267)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0267)foo"'\''|json -b8'
echo -ne 'r"foo(\0267)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0267)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0270)foo"'\''|json -b1'
echo -ne 'r"foo(\0270)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0270)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0270)foo"'\''|json -b2'
echo -ne 'r"foo(\0270)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0270)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0270)foo"'\''|json -b4'
echo -ne 'r"foo(\0270)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0270)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0270)foo"'\''|json -b8'
echo -ne 'r"foo(\0270)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0270)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0271)foo"'\''|json -b1'
echo -ne 'r"foo(\0271)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0271)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0271)foo"'\''|json -b2'
echo -ne 'r"foo(\0271)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0271)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0271)foo"'\''|json -b4'
echo -ne 'r"foo(\0271)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0271)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0271)foo"'\''|json -b8'
echo -ne 'r"foo(\0271)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0271)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0272)foo"'\''|json -b1'
echo -ne 'r"foo(\0272)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0272)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0272)foo"'\''|json -b2'
echo -ne 'r"foo(\0272)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0272)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0272)foo"'\''|json -b4'
echo -ne 'r"foo(\0272)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0272)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0272)foo"'\''|json -b8'
echo -ne 'r"foo(\0272)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0272)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0273)foo"'\''|json -b1'
echo -ne 'r"foo(\0273)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0273)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0273)foo"'\''|json -b2'
echo -ne 'r"foo(\0273)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0273)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0273)foo"'\''|json -b4'
echo -ne 'r"foo(\0273)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0273)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0273)foo"'\''|json -b8'
echo -ne 'r"foo(\0273)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0273)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0274)foo"'\''|json -b1'
echo -ne 'r"foo(\0274)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0274)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0274)foo"'\''|json -b2'
echo -ne 'r"foo(\0274)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0274)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0274)foo"'\''|json -b4'
echo -ne 'r"foo(\0274)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0274)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0274)foo"'\''|json -b8'
echo -ne 'r"foo(\0274)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0274)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0275)foo"'\''|json -b1'
echo -ne 'r"foo(\0275)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0275)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0275)foo"'\''|json -b2'
echo -ne 'r"foo(\0275)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0275)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0275)foo"'\''|json -b4'
echo -ne 'r"foo(\0275)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0275)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0275)foo"'\''|json -b8'
echo -ne 'r"foo(\0275)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0275)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0276)foo"'\''|json -b1'
echo -ne 'r"foo(\0276)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0276)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0276)foo"'\''|json -b2'
echo -ne 'r"foo(\0276)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0276)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0276)foo"'\''|json -b4'
echo -ne 'r"foo(\0276)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0276)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0276)foo"'\''|json -b8'
echo -ne 'r"foo(\0276)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0276)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0277)foo"'\''|json -b1'
echo -ne 'r"foo(\0277)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0277)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0277)foo"'\''|json -b2'
echo -ne 'r"foo(\0277)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0277)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0277)foo"'\''|json -b4'
echo -ne 'r"foo(\0277)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0277)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0277)foo"'\''|json -b8'
echo -ne 'r"foo(\0277)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0277)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0300)foo"'\''|json -b1'
echo -ne 'r"foo(\0300)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0300)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0300)foo"'\''|json -b2'
echo -ne 'r"foo(\0300)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0300)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0300)foo"'\''|json -b4'
echo -ne 'r"foo(\0300)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0300)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0300)foo"'\''|json -b8'
echo -ne 'r"foo(\0300)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0300)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0301)foo"'\''|json -b1'
echo -ne 'r"foo(\0301)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0301)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0301)foo"'\''|json -b2'
echo -ne 'r"foo(\0301)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0301)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0301)foo"'\''|json -b4'
echo -ne 'r"foo(\0301)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0301)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0301)foo"'\''|json -b8'
echo -ne 'r"foo(\0301)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0301)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0302)foo"'\''|json -b1'
echo -ne 'r"foo(\0302)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0302)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0302)foo"'\''|json -b2'
echo -ne 'r"foo(\0302)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0302)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0302)foo"'\''|json -b4'
echo -ne 'r"foo(\0302)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0302)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0302)foo"'\''|json -b8'
echo -ne 'r"foo(\0302)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0302)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0303)foo"'\''|json -b1'
echo -ne 'r"foo(\0303)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0303)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0303)foo"'\''|json -b2'
echo -ne 'r"foo(\0303)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0303)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0303)foo"'\''|json -b4'
echo -ne 'r"foo(\0303)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0303)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0303)foo"'\''|json -b8'
echo -ne 'r"foo(\0303)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0303)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0304)foo"'\''|json -b1'
echo -ne 'r"foo(\0304)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0304)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0304)foo"'\''|json -b2'
echo -ne 'r"foo(\0304)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0304)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0304)foo"'\''|json -b4'
echo -ne 'r"foo(\0304)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0304)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0304)foo"'\''|json -b8'
echo -ne 'r"foo(\0304)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0304)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0305)foo"'\''|json -b1'
echo -ne 'r"foo(\0305)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0305)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0305)foo"'\''|json -b2'
echo -ne 'r"foo(\0305)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0305)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0305)foo"'\''|json -b4'
echo -ne 'r"foo(\0305)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0305)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0305)foo"'\''|json -b8'
echo -ne 'r"foo(\0305)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0305)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0306)foo"'\''|json -b1'
echo -ne 'r"foo(\0306)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0306)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0306)foo"'\''|json -b2'
echo -ne 'r"foo(\0306)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0306)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0306)foo"'\''|json -b4'
echo -ne 'r"foo(\0306)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0306)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0306)foo"'\''|json -b8'
echo -ne 'r"foo(\0306)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0306)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0307)foo"'\''|json -b1'
echo -ne 'r"foo(\0307)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0307)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0307)foo"'\''|json -b2'
echo -ne 'r"foo(\0307)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0307)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0307)foo"'\''|json -b4'
echo -ne 'r"foo(\0307)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0307)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0307)foo"'\''|json -b8'
echo -ne 'r"foo(\0307)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0307)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0310)foo"'\''|json -b1'
echo -ne 'r"foo(\0310)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0310)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0310)foo"'\''|json -b2'
echo -ne 'r"foo(\0310)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0310)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0310)foo"'\''|json -b4'
echo -ne 'r"foo(\0310)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0310)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0310)foo"'\''|json -b8'
echo -ne 'r"foo(\0310)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0310)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0311)foo"'\''|json -b1'
echo -ne 'r"foo(\0311)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0311)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0311)foo"'\''|json -b2'
echo -ne 'r"foo(\0311)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0311)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0311)foo"'\''|json -b4'
echo -ne 'r"foo(\0311)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0311)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0311)foo"'\''|json -b8'
echo -ne 'r"foo(\0311)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0311)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0312)foo"'\''|json -b1'
echo -ne 'r"foo(\0312)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0312)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0312)foo"'\''|json -b2'
echo -ne 'r"foo(\0312)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0312)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0312)foo"'\''|json -b4'
echo -ne 'r"foo(\0312)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0312)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0312)foo"'\''|json -b8'
echo -ne 'r"foo(\0312)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0312)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0313)foo"'\''|json -b1'
echo -ne 'r"foo(\0313)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0313)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0313)foo"'\''|json -b2'
echo -ne 'r"foo(\0313)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0313)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0313)foo"'\''|json -b4'
echo -ne 'r"foo(\0313)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0313)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0313)foo"'\''|json -b8'
echo -ne 'r"foo(\0313)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0313)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0314)foo"'\''|json -b1'
echo -ne 'r"foo(\0314)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0314)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0314)foo"'\''|json -b2'
echo -ne 'r"foo(\0314)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0314)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0314)foo"'\''|json -b4'
echo -ne 'r"foo(\0314)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0314)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0314)foo"'\''|json -b8'
echo -ne 'r"foo(\0314)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0314)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0315)foo"'\''|json -b1'
echo -ne 'r"foo(\0315)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0315)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0315)foo"'\''|json -b2'
echo -ne 'r"foo(\0315)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0315)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0315)foo"'\''|json -b4'
echo -ne 'r"foo(\0315)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0315)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0315)foo"'\''|json -b8'
echo -ne 'r"foo(\0315)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0315)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0316)foo"'\''|json -b1'
echo -ne 'r"foo(\0316)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0316)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0316)foo"'\''|json -b2'
echo -ne 'r"foo(\0316)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0316)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0316)foo"'\''|json -b4'
echo -ne 'r"foo(\0316)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0316)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0316)foo"'\''|json -b8'
echo -ne 'r"foo(\0316)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0316)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0317)foo"'\''|json -b1'
echo -ne 'r"foo(\0317)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0317)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0317)foo"'\''|json -b2'
echo -ne 'r"foo(\0317)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0317)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0317)foo"'\''|json -b4'
echo -ne 'r"foo(\0317)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0317)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0317)foo"'\''|json -b8'
echo -ne 'r"foo(\0317)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0317)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0320)foo"'\''|json -b1'
echo -ne 'r"foo(\0320)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0320)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0320)foo"'\''|json -b2'
echo -ne 'r"foo(\0320)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0320)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0320)foo"'\''|json -b4'
echo -ne 'r"foo(\0320)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0320)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0320)foo"'\''|json -b8'
echo -ne 'r"foo(\0320)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0320)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0321)foo"'\''|json -b1'
echo -ne 'r"foo(\0321)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0321)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0321)foo"'\''|json -b2'
echo -ne 'r"foo(\0321)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0321)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0321)foo"'\''|json -b4'
echo -ne 'r"foo(\0321)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0321)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0321)foo"'\''|json -b8'
echo -ne 'r"foo(\0321)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0321)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0322)foo"'\''|json -b1'
echo -ne 'r"foo(\0322)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0322)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0322)foo"'\''|json -b2'
echo -ne 'r"foo(\0322)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0322)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0322)foo"'\''|json -b4'
echo -ne 'r"foo(\0322)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0322)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0322)foo"'\''|json -b8'
echo -ne 'r"foo(\0322)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0322)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0323)foo"'\''|json -b1'
echo -ne 'r"foo(\0323)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0323)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0323)foo"'\''|json -b2'
echo -ne 'r"foo(\0323)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0323)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0323)foo"'\''|json -b4'
echo -ne 'r"foo(\0323)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0323)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0323)foo"'\''|json -b8'
echo -ne 'r"foo(\0323)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0323)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0324)foo"'\''|json -b1'
echo -ne 'r"foo(\0324)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0324)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0324)foo"'\''|json -b2'
echo -ne 'r"foo(\0324)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0324)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0324)foo"'\''|json -b4'
echo -ne 'r"foo(\0324)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0324)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0324)foo"'\''|json -b8'
echo -ne 'r"foo(\0324)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0324)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0325)foo"'\''|json -b1'
echo -ne 'r"foo(\0325)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0325)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0325)foo"'\''|json -b2'
echo -ne 'r"foo(\0325)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0325)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0325)foo"'\''|json -b4'
echo -ne 'r"foo(\0325)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0325)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0325)foo"'\''|json -b8'
echo -ne 'r"foo(\0325)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0325)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0326)foo"'\''|json -b1'
echo -ne 'r"foo(\0326)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0326)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0326)foo"'\''|json -b2'
echo -ne 'r"foo(\0326)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0326)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0326)foo"'\''|json -b4'
echo -ne 'r"foo(\0326)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0326)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0326)foo"'\''|json -b8'
echo -ne 'r"foo(\0326)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0326)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0327)foo"'\''|json -b1'
echo -ne 'r"foo(\0327)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0327)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0327)foo"'\''|json -b2'
echo -ne 'r"foo(\0327)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0327)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0327)foo"'\''|json -b4'
echo -ne 'r"foo(\0327)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0327)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0327)foo"'\''|json -b8'
echo -ne 'r"foo(\0327)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0327)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0330)foo"'\''|json -b1'
echo -ne 'r"foo(\0330)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0330)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0330)foo"'\''|json -b2'
echo -ne 'r"foo(\0330)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0330)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0330)foo"'\''|json -b4'
echo -ne 'r"foo(\0330)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0330)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0330)foo"'\''|json -b8'
echo -ne 'r"foo(\0330)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0330)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0331)foo"'\''|json -b1'
echo -ne 'r"foo(\0331)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0331)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0331)foo"'\''|json -b2'
echo -ne 'r"foo(\0331)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0331)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0331)foo"'\''|json -b4'
echo -ne 'r"foo(\0331)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0331)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0331)foo"'\''|json -b8'
echo -ne 'r"foo(\0331)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0331)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0332)foo"'\''|json -b1'
echo -ne 'r"foo(\0332)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0332)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0332)foo"'\''|json -b2'
echo -ne 'r"foo(\0332)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0332)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0332)foo"'\''|json -b4'
echo -ne 'r"foo(\0332)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0332)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0332)foo"'\''|json -b8'
echo -ne 'r"foo(\0332)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0332)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0333)foo"'\''|json -b1'
echo -ne 'r"foo(\0333)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0333)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0333)foo"'\''|json -b2'
echo -ne 'r"foo(\0333)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0333)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0333)foo"'\''|json -b4'
echo -ne 'r"foo(\0333)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0333)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0333)foo"'\''|json -b8'
echo -ne 'r"foo(\0333)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0333)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0334)foo"'\''|json -b1'
echo -ne 'r"foo(\0334)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0334)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0334)foo"'\''|json -b2'
echo -ne 'r"foo(\0334)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0334)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0334)foo"'\''|json -b4'
echo -ne 'r"foo(\0334)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0334)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0334)foo"'\''|json -b8'
echo -ne 'r"foo(\0334)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0334)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0335)foo"'\''|json -b1'
echo -ne 'r"foo(\0335)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0335)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0335)foo"'\''|json -b2'
echo -ne 'r"foo(\0335)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0335)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0335)foo"'\''|json -b4'
echo -ne 'r"foo(\0335)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0335)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0335)foo"'\''|json -b8'
echo -ne 'r"foo(\0335)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0335)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0336)foo"'\''|json -b1'
echo -ne 'r"foo(\0336)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0336)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0336)foo"'\''|json -b2'
echo -ne 'r"foo(\0336)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0336)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0336)foo"'\''|json -b4'
echo -ne 'r"foo(\0336)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0336)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0336)foo"'\''|json -b8'
echo -ne 'r"foo(\0336)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0336)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0337)foo"'\''|json -b1'
echo -ne 'r"foo(\0337)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0337)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0337)foo"'\''|json -b2'
echo -ne 'r"foo(\0337)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0337)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0337)foo"'\''|json -b4'
echo -ne 'r"foo(\0337)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0337)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0337)foo"'\''|json -b8'
echo -ne 'r"foo(\0337)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0337)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0340)foo"'\''|json -b1'
echo -ne 'r"foo(\0340)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0340)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0340)foo"'\''|json -b2'
echo -ne 'r"foo(\0340)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0340)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0340)foo"'\''|json -b4'
echo -ne 'r"foo(\0340)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0340)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0340)foo"'\''|json -b8'
echo -ne 'r"foo(\0340)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0340)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0341)foo"'\''|json -b1'
echo -ne 'r"foo(\0341)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0341)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0341)foo"'\''|json -b2'
echo -ne 'r"foo(\0341)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0341)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0341)foo"'\''|json -b4'
echo -ne 'r"foo(\0341)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0341)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0341)foo"'\''|json -b8'
echo -ne 'r"foo(\0341)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0341)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0342)foo"'\''|json -b1'
echo -ne 'r"foo(\0342)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0342)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0342)foo"'\''|json -b2'
echo -ne 'r"foo(\0342)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0342)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0342)foo"'\''|json -b4'
echo -ne 'r"foo(\0342)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0342)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0342)foo"'\''|json -b8'
echo -ne 'r"foo(\0342)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0342)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0343)foo"'\''|json -b1'
echo -ne 'r"foo(\0343)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0343)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0343)foo"'\''|json -b2'
echo -ne 'r"foo(\0343)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0343)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0343)foo"'\''|json -b4'
echo -ne 'r"foo(\0343)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0343)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0343)foo"'\''|json -b8'
echo -ne 'r"foo(\0343)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0343)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0344)foo"'\''|json -b1'
echo -ne 'r"foo(\0344)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0344)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0344)foo"'\''|json -b2'
echo -ne 'r"foo(\0344)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0344)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0344)foo"'\''|json -b4'
echo -ne 'r"foo(\0344)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0344)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0344)foo"'\''|json -b8'
echo -ne 'r"foo(\0344)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0344)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0345)foo"'\''|json -b1'
echo -ne 'r"foo(\0345)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0345)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0345)foo"'\''|json -b2'
echo -ne 'r"foo(\0345)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0345)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0345)foo"'\''|json -b4'
echo -ne 'r"foo(\0345)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0345)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0345)foo"'\''|json -b8'
echo -ne 'r"foo(\0345)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0345)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0346)foo"'\''|json -b1'
echo -ne 'r"foo(\0346)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0346)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0346)foo"'\''|json -b2'
echo -ne 'r"foo(\0346)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0346)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0346)foo"'\''|json -b4'
echo -ne 'r"foo(\0346)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0346)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0346)foo"'\''|json -b8'
echo -ne 'r"foo(\0346)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0346)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0347)foo"'\''|json -b1'
echo -ne 'r"foo(\0347)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0347)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0347)foo"'\''|json -b2'
echo -ne 'r"foo(\0347)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0347)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0347)foo"'\''|json -b4'
echo -ne 'r"foo(\0347)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0347)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0347)foo"'\''|json -b8'
echo -ne 'r"foo(\0347)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0347)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0350)foo"'\''|json -b1'
echo -ne 'r"foo(\0350)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0350)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0350)foo"'\''|json -b2'
echo -ne 'r"foo(\0350)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0350)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0350)foo"'\''|json -b4'
echo -ne 'r"foo(\0350)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0350)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0350)foo"'\''|json -b8'
echo -ne 'r"foo(\0350)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0350)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0351)foo"'\''|json -b1'
echo -ne 'r"foo(\0351)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0351)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0351)foo"'\''|json -b2'
echo -ne 'r"foo(\0351)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0351)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0351)foo"'\''|json -b4'
echo -ne 'r"foo(\0351)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0351)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0351)foo"'\''|json -b8'
echo -ne 'r"foo(\0351)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0351)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0352)foo"'\''|json -b1'
echo -ne 'r"foo(\0352)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0352)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0352)foo"'\''|json -b2'
echo -ne 'r"foo(\0352)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0352)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0352)foo"'\''|json -b4'
echo -ne 'r"foo(\0352)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0352)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0352)foo"'\''|json -b8'
echo -ne 'r"foo(\0352)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0352)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0353)foo"'\''|json -b1'
echo -ne 'r"foo(\0353)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0353)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0353)foo"'\''|json -b2'
echo -ne 'r"foo(\0353)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0353)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0353)foo"'\''|json -b4'
echo -ne 'r"foo(\0353)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0353)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0353)foo"'\''|json -b8'
echo -ne 'r"foo(\0353)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0353)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0354)foo"'\''|json -b1'
echo -ne 'r"foo(\0354)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0354)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0354)foo"'\''|json -b2'
echo -ne 'r"foo(\0354)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0354)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0354)foo"'\''|json -b4'
echo -ne 'r"foo(\0354)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0354)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0354)foo"'\''|json -b8'
echo -ne 'r"foo(\0354)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0354)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0355)foo"'\''|json -b1'
echo -ne 'r"foo(\0355)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0355)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0355)foo"'\''|json -b2'
echo -ne 'r"foo(\0355)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0355)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0355)foo"'\''|json -b4'
echo -ne 'r"foo(\0355)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0355)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0355)foo"'\''|json -b8'
echo -ne 'r"foo(\0355)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0355)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0356)foo"'\''|json -b1'
echo -ne 'r"foo(\0356)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0356)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0356)foo"'\''|json -b2'
echo -ne 'r"foo(\0356)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0356)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0356)foo"'\''|json -b4'
echo -ne 'r"foo(\0356)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0356)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0356)foo"'\''|json -b8'
echo -ne 'r"foo(\0356)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0356)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0357)foo"'\''|json -b1'
echo -ne 'r"foo(\0357)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0357)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0357)foo"'\''|json -b2'
echo -ne 'r"foo(\0357)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0357)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0357)foo"'\''|json -b4'
echo -ne 'r"foo(\0357)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0357)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0357)foo"'\''|json -b8'
echo -ne 'r"foo(\0357)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0357)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0360)foo"'\''|json -b1'
echo -ne 'r"foo(\0360)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0360)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0360)foo"'\''|json -b2'
echo -ne 'r"foo(\0360)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0360)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0360)foo"'\''|json -b4'
echo -ne 'r"foo(\0360)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0360)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0360)foo"'\''|json -b8'
echo -ne 'r"foo(\0360)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0360)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0361)foo"'\''|json -b1'
echo -ne 'r"foo(\0361)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0361)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0361)foo"'\''|json -b2'
echo -ne 'r"foo(\0361)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0361)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0361)foo"'\''|json -b4'
echo -ne 'r"foo(\0361)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0361)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0361)foo"'\''|json -b8'
echo -ne 'r"foo(\0361)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0361)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0362)foo"'\''|json -b1'
echo -ne 'r"foo(\0362)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0362)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0362)foo"'\''|json -b2'
echo -ne 'r"foo(\0362)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0362)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0362)foo"'\''|json -b4'
echo -ne 'r"foo(\0362)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0362)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0362)foo"'\''|json -b8'
echo -ne 'r"foo(\0362)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0362)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0363)foo"'\''|json -b1'
echo -ne 'r"foo(\0363)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0363)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0363)foo"'\''|json -b2'
echo -ne 'r"foo(\0363)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0363)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0363)foo"'\''|json -b4'
echo -ne 'r"foo(\0363)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0363)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0363)foo"'\''|json -b8'
echo -ne 'r"foo(\0363)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0363)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0364)foo"'\''|json -b1'
echo -ne 'r"foo(\0364)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0364)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0364)foo"'\''|json -b2'
echo -ne 'r"foo(\0364)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0364)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0364)foo"'\''|json -b4'
echo -ne 'r"foo(\0364)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0364)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0364)foo"'\''|json -b8'
echo -ne 'r"foo(\0364)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0364)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0365)foo"'\''|json -b1'
echo -ne 'r"foo(\0365)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0365)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0365)foo"'\''|json -b2'
echo -ne 'r"foo(\0365)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0365)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0365)foo"'\''|json -b4'
echo -ne 'r"foo(\0365)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0365)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0365)foo"'\''|json -b8'
echo -ne 'r"foo(\0365)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0365)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0366)foo"'\''|json -b1'
echo -ne 'r"foo(\0366)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0366)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0366)foo"'\''|json -b2'
echo -ne 'r"foo(\0366)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0366)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0366)foo"'\''|json -b4'
echo -ne 'r"foo(\0366)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0366)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0366)foo"'\''|json -b8'
echo -ne 'r"foo(\0366)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0366)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0367)foo"'\''|json -b1'
echo -ne 'r"foo(\0367)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0367)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0367)foo"'\''|json -b2'
echo -ne 'r"foo(\0367)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0367)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0367)foo"'\''|json -b4'
echo -ne 'r"foo(\0367)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0367)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0367)foo"'\''|json -b8'
echo -ne 'r"foo(\0367)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0367)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0370)foo"'\''|json -b1'
echo -ne 'r"foo(\0370)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0370)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0370)foo"'\''|json -b2'
echo -ne 'r"foo(\0370)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0370)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0370)foo"'\''|json -b4'
echo -ne 'r"foo(\0370)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0370)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0370)foo"'\''|json -b8'
echo -ne 'r"foo(\0370)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0370)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0371)foo"'\''|json -b1'
echo -ne 'r"foo(\0371)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0371)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0371)foo"'\''|json -b2'
echo -ne 'r"foo(\0371)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0371)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0371)foo"'\''|json -b4'
echo -ne 'r"foo(\0371)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0371)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0371)foo"'\''|json -b8'
echo -ne 'r"foo(\0371)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0371)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0372)foo"'\''|json -b1'
echo -ne 'r"foo(\0372)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0372)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0372)foo"'\''|json -b2'
echo -ne 'r"foo(\0372)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0372)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0372)foo"'\''|json -b4'
echo -ne 'r"foo(\0372)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0372)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0372)foo"'\''|json -b8'
echo -ne 'r"foo(\0372)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0372)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0373)foo"'\''|json -b1'
echo -ne 'r"foo(\0373)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0373)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0373)foo"'\''|json -b2'
echo -ne 'r"foo(\0373)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0373)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0373)foo"'\''|json -b4'
echo -ne 'r"foo(\0373)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0373)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0373)foo"'\''|json -b8'
echo -ne 'r"foo(\0373)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0373)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0374)foo"'\''|json -b1'
echo -ne 'r"foo(\0374)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0374)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0374)foo"'\''|json -b2'
echo -ne 'r"foo(\0374)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0374)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0374)foo"'\''|json -b4'
echo -ne 'r"foo(\0374)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0374)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0374)foo"'\''|json -b8'
echo -ne 'r"foo(\0374)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0374)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0375)foo"'\''|json -b1'
echo -ne 'r"foo(\0375)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0375)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0375)foo"'\''|json -b2'
echo -ne 'r"foo(\0375)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0375)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0375)foo"'\''|json -b4'
echo -ne 'r"foo(\0375)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0375)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0375)foo"'\''|json -b8'
echo -ne 'r"foo(\0375)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0375)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0376)foo"'\''|json -b1'
echo -ne 'r"foo(\0376)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0376)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0376)foo"'\''|json -b2'
echo -ne 'r"foo(\0376)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0376)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0376)foo"'\''|json -b4'
echo -ne 'r"foo(\0376)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0376)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0376)foo"'\''|json -b8'
echo -ne 'r"foo(\0376)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0376)foo"'\''|json -b8'

echo '$ echo -ne '\''r"foo(\0377)foo"'\''|json -b1'
echo -ne 'r"foo(\0377)foo"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0377)foo"'\''|json -b1'

echo '$ echo -ne '\''r"foo(\0377)foo"'\''|json -b2'
echo -ne 'r"foo(\0377)foo"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0377)foo"'\''|json -b2'

echo '$ echo -ne '\''r"foo(\0377)foo"'\''|json -b4'
echo -ne 'r"foo(\0377)foo"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0377)foo"'\''|json -b4'

echo '$ echo -ne '\''r"foo(\0377)foo"'\''|json -b8'
echo -ne 'r"foo(\0377)foo"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo(\0377)foo"'\''|json -b8'
)

