#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -p litex -C lib:sobj-litex-lib
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L sobj-litex-lib.old <(echo \
'$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"
$ json-litex() { set -o pipefail && LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value -VF -- ../lib/json-litex.so -A "$@"|sed -r '\''s/"size":[0-9]+,"bytes":\["[0-9a-f]+"(,"[0-9a-f]+")*\]//;s/("lookup":"0x)[0-9a-f]+(")/\1...\2/g'\''|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }
$ ../lib/test-litex.so|sed -r '\''1s/[0-9]+\.[0-9]+\.[0-9]+/x.y.z/'\''
test-litex.so: litex library version: x.y.z
$ json-litex -P ../lib/test-litex.so
{
    "a": {
        "b": [
            "/^[[:ascii:]]*$/ && #`\n` <= 1",
            {
                "c": {
                    "d": "null || /^x+y+$/ && #`x` < #`y`"
                }
            }
        ]
    },
    "c": {
        "d": "null || date(`%Y-%m-%d`)"
    }
}
$ json-litex -A ../lib/test-litex.so
{
    "rexes": {
        "size": 2,
        "codes": {
            "type": "streams",
            "code": {}
        },
        "elems": null
    },
    "node": {
        "id": 33,
        "type": "object",
        "node": {
            "size": 2,
            "args": [
                {
                    "key": {
                        "val": "a",
                        "delim": null
                    },
                    "val": {
                        "id": 22,
                        "type": "object",
                        "node": {
                            "size": 1,
                            "args": [
                                {
                                    "key": {
                                        "val": "b",
                                        "delim": null
                                    },
                                    "val": {
                                        "id": 18,
                                        "type": "array",
                                        "node": {
                                            "size": 2,
                                            "args": [
                                                {
                                                    "id": 4,
                                                    "type": "string",
                                                    "node": {
                                                        "val": "/^[[:ascii:]]*$/ && #`\n` <= 1",
                                                        "delim": null
                                                    },
                                                    "attr": {
                                                        "size": 5,
                                                        "nodes": [
                                                            {
                                                                "type": "match_rex",
                                                                "val": 0
                                                            },
                                                            {
                                                                "type": "jump_false",
                                                                "val": 4
                                                            },
                                                            {
                                                                "type": "const_num",
                                                                "val": 1
                                                            },
                                                            {
                                                                "type": "count_str",
                                                                "val": "\n"
                                                            },
                                                            {
                                                                "type": "cmp_op",
                                                                "val": "ge"
                                                            }
                                                        ]
                                                    },
                                                    "parent": 18,
                                                    "path": null
                                                },
                                                {
                                                    "id": 15,
                                                    "type": "object",
                                                    "node": {
                                                        "size": 1,
                                                        "args": [
                                                            {
                                                                "key": {
                                                                    "val": "c",
                                                                    "delim": null
                                                                },
                                                                "val": {
                                                                    "id": 11,
                                                                    "type": "object",
                                                                    "node": {
                                                                        "size": 1,
                                                                        "args": [
                                                                            {
                                                                                "key": {
                                                                                    "val": "d",
                                                                                    "delim": null
                                                                                },
                                                                                "val": {
                                                                                    "id": 7,
                                                                                    "type": "string",
                                                                                    "node": {
                                                                                        "val": "null || /^x+y+$/ && #`x` < #`y`",
                                                                                        "delim": null
                                                                                    },
                                                                                    "attr": {
                                                                                        "size": 7,
                                                                                        "nodes": [
                                                                                            {
                                                                                                "type": "call_builtin",
                                                                                                "val": "null"
                                                                                            },
                                                                                            {
                                                                                                "type": "jump_true",
                                                                                                "val": 6
                                                                                            },
                                                                                            {
                                                                                                "type": "match_rex",
                                                                                                "val": 1
                                                                                            },
                                                                                            {
                                                                                                "type": "jump_false",
                                                                                                "val": 4
                                                                                            },
                                                                                            {
                                                                                                "type": "count_str",
                                                                                                "val": "x"
                                                                                            },
                                                                                            {
                                                                                                "type": "count_str",
                                                                                                "val": "y"
                                                                                            },
                                                                                            {
                                                                                                "type": "cmp_op",
                                                                                                "val": "lt"
                                                                                            }
                                                                                        ]
                                                                                    },
                                                                                    "parent": 11,
                                                                                    "path": 0
                                                                                }
                                                                            }
                                                                        ]
                                                                    },
                                                                    "attr": {
                                                                        "lookup": "0x...",
                                                                        "root": null
                                                                    },
                                                                    "parent": 15,
                                                                    "path": 0
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    "attr": {
                                                        "lookup": "0x...",
                                                        "root": null
                                                    },
                                                    "parent": 18,
                                                    "path": null
                                                }
                                            ]
                                        },
                                        "attr": {
                                            "string": 4,
                                            "object": 15
                                        },
                                        "parent": 22,
                                        "path": 0
                                    }
                                }
                            ]
                        },
                        "attr": {
                            "lookup": "0x...",
                            "root": null
                        },
                        "parent": 33,
                        "path": 0
                    }
                },
                {
                    "key": {
                        "val": "c",
                        "delim": null
                    },
                    "val": {
                        "id": 29,
                        "type": "object",
                        "node": {
                            "size": 1,
                            "args": [
                                {
                                    "key": {
                                        "val": "d",
                                        "delim": null
                                    },
                                    "val": {
                                        "id": 25,
                                        "type": "string",
                                        "node": {
                                            "val": "null || date(`%Y-%m-%d`)",
                                            "delim": null
                                        },
                                        "attr": {
                                            "size": 4,
                                            "nodes": [
                                                {
                                                    "type": "call_builtin",
                                                    "val": "null"
                                                },
                                                {
                                                    "type": "jump_true",
                                                    "val": 3
                                                },
                                                {
                                                    "type": "const_str",
                                                    "val": "%Y-%m-%d"
                                                },
                                                {
                                                    "type": "call_builtin",
                                                    "val": "date"
                                                }
                                            ]
                                        },
                                        "parent": 29,
                                        "path": 0
                                    }
                                }
                            ]
                        },
                        "attr": {
                            "lookup": "0x...",
                            "root": null
                        },
                        "parent": 33,
                        "path": 1
                    }
                }
            ]
        },
        "attr": {
            "lookup": "0x...",
            "root": null
        },
        "parent": null,
        "path": null
    }
}
$ json-litex() { set -o pipefail && LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json -VF -- ../lib/json-litex.so "$@"; }
$ json-litex -V ../lib/test-litex.so
$ json-litex() { set -o pipefail && LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json -VF -- ../lib/json-litex.so "$@"|LD_LIBRARY_PATH=../lib ../src/json --parse-only --verbose; }
$ json-litex -P ../lib/test-litex.so
$ json-litex -A ../lib/test-litex.so'
) -L sobj-litex-lib.new <(
echo '$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'
[ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib" 2>&1 ||
echo 'command failed: [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'

echo '$ json-litex() { set -o pipefail && LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value -VF -- ../lib/json-litex.so -A "$@"|sed -r '\''s/"size":[0-9]+,"bytes":\["[0-9a-f]+"(,"[0-9a-f]+")*\]//;s/("lookup":"0x)[0-9a-f]+(")/\1...\2/g'\''|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }'
json-litex() { set -o pipefail && LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value -VF -- ../lib/json-litex.so -A "$@"|sed -r 's/"size":[0-9]+,"bytes":\["[0-9a-f]+"(,"[0-9a-f]+")*\]//;s/("lookup":"0x)[0-9a-f]+(")/\1...\2/g'|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; } 2>&1 ||
echo 'command failed: json-litex() { set -o pipefail && LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value -VF -- ../lib/json-litex.so -A "$@"|sed -r '\''s/"size":[0-9]+,"bytes":\["[0-9a-f]+"(,"[0-9a-f]+")*\]//;s/("lookup":"0x)[0-9a-f]+(")/\1...\2/g'\''|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }'

echo '$ ../lib/test-litex.so|sed -r '\''1s/[0-9]+\.[0-9]+\.[0-9]+/x.y.z/'\'''
../lib/test-litex.so|sed -r '1s/[0-9]+\.[0-9]+\.[0-9]+/x.y.z/' 2>&1 ||
echo 'command failed: ../lib/test-litex.so|sed -r '\''1s/[0-9]+\.[0-9]+\.[0-9]+/x.y.z/'\'''

echo '$ json-litex -P ../lib/test-litex.so'
json-litex -P ../lib/test-litex.so 2>&1 ||
echo 'command failed: json-litex -P ../lib/test-litex.so'

echo '$ json-litex -A ../lib/test-litex.so'
json-litex -A ../lib/test-litex.so 2>&1 ||
echo 'command failed: json-litex -A ../lib/test-litex.so'

echo '$ json-litex() { set -o pipefail && LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json -VF -- ../lib/json-litex.so "$@"; }'
json-litex() { set -o pipefail && LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json -VF -- ../lib/json-litex.so "$@"; } 2>&1 ||
echo 'command failed: json-litex() { set -o pipefail && LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json -VF -- ../lib/json-litex.so "$@"; }'

echo '$ json-litex -V ../lib/test-litex.so'
json-litex -V ../lib/test-litex.so 2>&1 ||
echo 'command failed: json-litex -V ../lib/test-litex.so'

echo '$ json-litex() { set -o pipefail && LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json -VF -- ../lib/json-litex.so "$@"|LD_LIBRARY_PATH=../lib ../src/json --parse-only --verbose; }'
json-litex() { set -o pipefail && LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json -VF -- ../lib/json-litex.so "$@"|LD_LIBRARY_PATH=../lib ../src/json --parse-only --verbose; } 2>&1 ||
echo 'command failed: json-litex() { set -o pipefail && LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json -VF -- ../lib/json-litex.so "$@"|LD_LIBRARY_PATH=../lib ../src/json --parse-only --verbose; }'

echo '$ json-litex -P ../lib/test-litex.so'
json-litex -P ../lib/test-litex.so 2>&1 ||
echo 'command failed: json-litex -P ../lib/test-litex.so'

echo '$ json-litex -A ../lib/test-litex.so'
json-litex -A ../lib/test-litex.so 2>&1 ||
echo 'command failed: json-litex -A ../lib/test-litex.so'
)

