#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -p litex -C lib:inner-array
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L inner-array.old <(echo \
'$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"
$ json-litex() { set -o pipefail && LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value -VF -- ../lib/json-litex.so -A "$@"|sed -r '\''s/"size":[0-9]+,"bytes":\["[0-9a-f]+"(,"[0-9a-f]+")*\]//;s/("lookup":"0x)[0-9a-f]+(")/\1...\2/g'\''|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }
$ json-litex -d '\''[["`x`"]]'\''
json: error: <text>:1:2: filter library: attribute error: invalid array: inner arrays not allowed (the outer array begins at 1:1)
json: error: <text>:1:2: [["`x`"]]
json: error: <text>:1:2:  ^
command failed: json-litex -d '\''[["`x`"]]'\''
$ json-litex -d '\''{"foo":[["`x`"]]}'\''
json: error: <text>:1:9: filter library: attribute error: invalid array: inner arrays not allowed (the outer array begins at 1:8)
json: error: <text>:1:9: {"foo":[["`x`"]]}
json: error: <text>:1:9:         ^
command failed: json-litex -d '\''{"foo":[["`x`"]]}'\''
$ json-litex -d '\''{"bar":{"foo":[["`x`"]]}}'\''
json: error: <text>:1:16: filter library: attribute error: invalid array: inner arrays not allowed (the outer array begins at 1:15)
json: error: <text>:1:16: {"bar":{"foo":[["`x`"]]}}
json: error: <text>:1:16:                ^
command failed: json-litex -d '\''{"bar":{"foo":[["`x`"]]}}'\''
$ json-litex -d '\''[{"foo":[["`x`"]]}]'\''
json: error: <text>:1:10: filter library: attribute error: invalid array: inner arrays not allowed (the outer array begins at 1:9)
json: error: <text>:1:10: [{"foo":[["`x`"]]}]
json: error: <text>:1:10:          ^
command failed: json-litex -d '\''[{"foo":[["`x`"]]}]'\''
$ json-litex -d '\''{"baz":{"bar":{"foo":[["`x`"]]}}}'\''
json: error: <text>:1:23: filter library: attribute error: invalid array: inner arrays not allowed (the outer array begins at 1:22)
json: error: <text>:1:23: {"baz":{"bar":{"foo":[["`x`"]]}}}
json: error: <text>:1:23:                       ^
command failed: json-litex -d '\''{"baz":{"bar":{"foo":[["`x`"]]}}}'\''
$ json-litex -d '\''{"baz":{"bar":[["`x`"]]}}'\''
json: error: <text>:1:16: filter library: attribute error: invalid array: inner arrays not allowed (the outer array begins at 1:15)
json: error: <text>:1:16: {"baz":{"bar":[["`x`"]]}}
json: error: <text>:1:16:                ^
command failed: json-litex -d '\''{"baz":{"bar":[["`x`"]]}}'\''
$ json-litex -d '\''{"baz":[{"foo":[["`x`"]]}]}'\''
json: error: <text>:1:17: filter library: attribute error: invalid array: inner arrays not allowed (the outer array begins at 1:16)
json: error: <text>:1:17: {"baz":[{"foo":[["`x`"]]}]}
json: error: <text>:1:17:                 ^
command failed: json-litex -d '\''{"baz":[{"foo":[["`x`"]]}]}'\''
$ json-litex -d '\''[{"bar":{"foo":[["`x`"]]}}]'\''
json: error: <text>:1:17: filter library: attribute error: invalid array: inner arrays not allowed (the outer array begins at 1:16)
json: error: <text>:1:17: [{"bar":{"foo":[["`x`"]]}}]
json: error: <text>:1:17:                 ^
command failed: json-litex -d '\''[{"bar":{"foo":[["`x`"]]}}]'\''
$ json-litex -d '\''["`y`",["`x`"]]'\''
json: error: <text>:1:8: filter library: attribute error: invalid array: inner arrays not allowed (the outer array begins at 1:1)
json: error: <text>:1:8: ["`y`",["`x`"]]
json: error: <text>:1:8:        ^
command failed: json-litex -d '\''["`y`",["`x`"]]'\''
$ json-litex -d '\''{"foo":["`y`",["`x`"]]}'\''
json: error: <text>:1:15: filter library: attribute error: invalid array: inner arrays not allowed (the outer array begins at 1:8)
json: error: <text>:1:15: {"foo":["`y`",["`x`"]]}
json: error: <text>:1:15:               ^
command failed: json-litex -d '\''{"foo":["`y`",["`x`"]]}'\''
$ json-litex -d '\''{"bar":{"foo":["`y`",["`x`"]]}}'\''
json: error: <text>:1:22: filter library: attribute error: invalid array: inner arrays not allowed (the outer array begins at 1:15)
json: error: <text>:1:22: {"bar":{"foo":["`y`",["`x`"]]}}
json: error: <text>:1:22:                      ^
command failed: json-litex -d '\''{"bar":{"foo":["`y`",["`x`"]]}}'\''
$ json-litex -d '\''[{"foo":["`y`",["`x`"]]}]'\''
json: error: <text>:1:16: filter library: attribute error: invalid array: inner arrays not allowed (the outer array begins at 1:9)
json: error: <text>:1:16: [{"foo":["`y`",["`x`"]]}]
json: error: <text>:1:16:                ^
command failed: json-litex -d '\''[{"foo":["`y`",["`x`"]]}]'\''
$ json-litex -d '\''{"baz":{"bar":{"foo":["`y`",["`x`"]]}}}'\''
json: error: <text>:1:29: filter library: attribute error: invalid array: inner arrays not allowed (the outer array begins at 1:22)
json: error: <text>:1:29: {"baz":{"bar":{"foo":["`y`",["`x`"]]}}}
json: error: <text>:1:29:                             ^
command failed: json-litex -d '\''{"baz":{"bar":{"foo":["`y`",["`x`"]]}}}'\''
$ json-litex -d '\''{"baz":{"bar":["`y`",["`x`"]]}}'\''
json: error: <text>:1:22: filter library: attribute error: invalid array: inner arrays not allowed (the outer array begins at 1:15)
json: error: <text>:1:22: {"baz":{"bar":["`y`",["`x`"]]}}
json: error: <text>:1:22:                      ^
command failed: json-litex -d '\''{"baz":{"bar":["`y`",["`x`"]]}}'\''
$ json-litex -d '\''{"baz":[{"foo":["`y`",["`x`"]]}]}'\''
json: error: <text>:1:23: filter library: attribute error: invalid array: inner arrays not allowed (the outer array begins at 1:16)
json: error: <text>:1:23: {"baz":[{"foo":["`y`",["`x`"]]}]}
json: error: <text>:1:23:                       ^
command failed: json-litex -d '\''{"baz":[{"foo":["`y`",["`x`"]]}]}'\''
$ json-litex -d '\''[{"bar":{"foo":["`y`",["`x`"]]}}]'\''
json: error: <text>:1:23: filter library: attribute error: invalid array: inner arrays not allowed (the outer array begins at 1:16)
json: error: <text>:1:23: [{"bar":{"foo":["`y`",["`x`"]]}}]
json: error: <text>:1:23:                       ^
command failed: json-litex -d '\''[{"bar":{"foo":["`y`",["`x`"]]}}]'\''
$ json-litex -d '\''[["`x`"],"`y`"]'\''
json: error: <text>:1:2: filter library: attribute error: invalid array: inner arrays not allowed (the outer array begins at 1:1)
json: error: <text>:1:2: [["`x`"],"`y`"]
json: error: <text>:1:2:  ^
command failed: json-litex -d '\''[["`x`"],"`y`"]'\''
$ json-litex -d '\''{"foo":[["`x`"],"`y`"]}'\''
json: error: <text>:1:9: filter library: attribute error: invalid array: inner arrays not allowed (the outer array begins at 1:8)
json: error: <text>:1:9: {"foo":[["`x`"],"`y`"]}
json: error: <text>:1:9:         ^
command failed: json-litex -d '\''{"foo":[["`x`"],"`y`"]}'\''
$ json-litex -d '\''{"bar":{"foo":[["`x`"],"`y`"]}}'\''
json: error: <text>:1:16: filter library: attribute error: invalid array: inner arrays not allowed (the outer array begins at 1:15)
json: error: <text>:1:16: {"bar":{"foo":[["`x`"],"`y`"]}}
json: error: <text>:1:16:                ^
command failed: json-litex -d '\''{"bar":{"foo":[["`x`"],"`y`"]}}'\''
$ json-litex -d '\''[{"foo":[["`x`"],"`y`"]}]'\''
json: error: <text>:1:10: filter library: attribute error: invalid array: inner arrays not allowed (the outer array begins at 1:9)
json: error: <text>:1:10: [{"foo":[["`x`"],"`y`"]}]
json: error: <text>:1:10:          ^
command failed: json-litex -d '\''[{"foo":[["`x`"],"`y`"]}]'\''
$ json-litex -d '\''{"baz":{"bar":{"foo":[["`x`"],"`y`"]}}}'\''
json: error: <text>:1:23: filter library: attribute error: invalid array: inner arrays not allowed (the outer array begins at 1:22)
json: error: <text>:1:23: {"baz":{"bar":{"foo":[["`x`"],"`y`"]}}}
json: error: <text>:1:23:                       ^
command failed: json-litex -d '\''{"baz":{"bar":{"foo":[["`x`"],"`y`"]}}}'\''
$ json-litex -d '\''{"baz":{"bar":[["`x`"],"`y`"]}}'\''
json: error: <text>:1:16: filter library: attribute error: invalid array: inner arrays not allowed (the outer array begins at 1:15)
json: error: <text>:1:16: {"baz":{"bar":[["`x`"],"`y`"]}}
json: error: <text>:1:16:                ^
command failed: json-litex -d '\''{"baz":{"bar":[["`x`"],"`y`"]}}'\''
$ json-litex -d '\''{"baz":[{"foo":[["`x`"],"`y`"]}]}'\''
json: error: <text>:1:17: filter library: attribute error: invalid array: inner arrays not allowed (the outer array begins at 1:16)
json: error: <text>:1:17: {"baz":[{"foo":[["`x`"],"`y`"]}]}
json: error: <text>:1:17:                 ^
command failed: json-litex -d '\''{"baz":[{"foo":[["`x`"],"`y`"]}]}'\''
$ json-litex -d '\''[{"bar":{"foo":[["`x`"],"`y`"]}}]'\''
json: error: <text>:1:17: filter library: attribute error: invalid array: inner arrays not allowed (the outer array begins at 1:16)
json: error: <text>:1:17: [{"bar":{"foo":[["`x`"],"`y`"]}}]
json: error: <text>:1:17:                 ^
command failed: json-litex -d '\''[{"bar":{"foo":[["`x`"],"`y`"]}}]'\''
$ json-litex -d '\''[{"a":"`y`"},["`x`"]]'\''
json: error: <text>:1:14: filter library: attribute error: invalid array: inner arrays not allowed (the outer array begins at 1:1)
json: error: <text>:1:14: [{"a":"`y`"},["`x`"]]
json: error: <text>:1:14:              ^
command failed: json-litex -d '\''[{"a":"`y`"},["`x`"]]'\''
$ json-litex -d '\''{"foo":[{"a":"`y`"},["`x`"]]}'\''
json: error: <text>:1:21: filter library: attribute error: invalid array: inner arrays not allowed (the outer array begins at 1:8)
json: error: <text>:1:21: {"foo":[{"a":"`y`"},["`x`"]]}
json: error: <text>:1:21:                     ^
command failed: json-litex -d '\''{"foo":[{"a":"`y`"},["`x`"]]}'\''
$ json-litex -d '\''{"bar":{"foo":[{"a":"`y`"},["`x`"]]}}'\''
json: error: <text>:1:28: filter library: attribute error: invalid array: inner arrays not allowed (the outer array begins at 1:15)
json: error: <text>:1:28: {"bar":{"foo":[{"a":"`y`"},["`x`"]]}}
json: error: <text>:1:28:                            ^
command failed: json-litex -d '\''{"bar":{"foo":[{"a":"`y`"},["`x`"]]}}'\''
$ json-litex -d '\''[{"foo":[{"a":"`y`"},["`x`"]]}]'\''
json: error: <text>:1:22: filter library: attribute error: invalid array: inner arrays not allowed (the outer array begins at 1:9)
json: error: <text>:1:22: [{"foo":[{"a":"`y`"},["`x`"]]}]
json: error: <text>:1:22:                      ^
command failed: json-litex -d '\''[{"foo":[{"a":"`y`"},["`x`"]]}]'\''
$ json-litex -d '\''{"baz":{"bar":{"foo":[{"a":"`y`"},["`x`"]]}}}'\''
json: error: <text>:1:35: filter library: attribute error: invalid array: inner arrays not allowed (the outer array begins at 1:22)
json: error: <text>:1:35: baz":{"bar":{"foo":[{"a":"`y`"},["`x`"]]}}}
json: error: <text>:1:35:                                 ^
command failed: json-litex -d '\''{"baz":{"bar":{"foo":[{"a":"`y`"},["`x`"]]}}}'\''
$ json-litex -d '\''{"baz":{"bar":[{"a":"`y`"},["`x`"]]}}'\''
json: error: <text>:1:28: filter library: attribute error: invalid array: inner arrays not allowed (the outer array begins at 1:15)
json: error: <text>:1:28: {"baz":{"bar":[{"a":"`y`"},["`x`"]]}}
json: error: <text>:1:28:                            ^
command failed: json-litex -d '\''{"baz":{"bar":[{"a":"`y`"},["`x`"]]}}'\''
$ json-litex -d '\''{"baz":[{"foo":[{"a":"`y`"},["`x`"]]}]}'\''
json: error: <text>:1:29: filter library: attribute error: invalid array: inner arrays not allowed (the outer array begins at 1:16)
json: error: <text>:1:29: {"baz":[{"foo":[{"a":"`y`"},["`x`"]]}]}
json: error: <text>:1:29:                             ^
command failed: json-litex -d '\''{"baz":[{"foo":[{"a":"`y`"},["`x`"]]}]}'\''
$ json-litex -d '\''[{"bar":{"foo":[{"a":"`y`"},["`x`"]]}}]'\''
json: error: <text>:1:29: filter library: attribute error: invalid array: inner arrays not allowed (the outer array begins at 1:16)
json: error: <text>:1:29: [{"bar":{"foo":[{"a":"`y`"},["`x`"]]}}]
json: error: <text>:1:29:                             ^
command failed: json-litex -d '\''[{"bar":{"foo":[{"a":"`y`"},["`x`"]]}}]'\''
$ json-litex -d '\''[["`x`"],{"a":"`y`"}]'\''
json: error: <text>:1:2: filter library: attribute error: invalid array: inner arrays not allowed (the outer array begins at 1:1)
json: error: <text>:1:2: [["`x`"],{"a":"`y`"}]
json: error: <text>:1:2:  ^
command failed: json-litex -d '\''[["`x`"],{"a":"`y`"}]'\''
$ json-litex -d '\''{"foo":[["`x`"],{"a":"`y`"}]}'\''
json: error: <text>:1:9: filter library: attribute error: invalid array: inner arrays not allowed (the outer array begins at 1:8)
json: error: <text>:1:9: {"foo":[["`x`"],{"a":"`y`"}]}
json: error: <text>:1:9:         ^
command failed: json-litex -d '\''{"foo":[["`x`"],{"a":"`y`"}]}'\''
$ json-litex -d '\''{"bar":{"foo":[["`x`"],{"a":"`y`"}]}}'\''
json: error: <text>:1:16: filter library: attribute error: invalid array: inner arrays not allowed (the outer array begins at 1:15)
json: error: <text>:1:16: {"bar":{"foo":[["`x`"],{"a":"`y`"}]}}
json: error: <text>:1:16:                ^
command failed: json-litex -d '\''{"bar":{"foo":[["`x`"],{"a":"`y`"}]}}'\''
$ json-litex -d '\''[{"foo":[["`x`"],{"a":"`y`"}]}]'\''
json: error: <text>:1:10: filter library: attribute error: invalid array: inner arrays not allowed (the outer array begins at 1:9)
json: error: <text>:1:10: [{"foo":[["`x`"],{"a":"`y`"}]}]
json: error: <text>:1:10:          ^
command failed: json-litex -d '\''[{"foo":[["`x`"],{"a":"`y`"}]}]'\''
$ json-litex -d '\''{"baz":{"bar":{"foo":[["`x`"],{"a":"`y`"}]}}}'\''
json: error: <text>:1:23: filter library: attribute error: invalid array: inner arrays not allowed (the outer array begins at 1:22)
json: error: <text>:1:23: {"baz":{"bar":{"foo":[["`x`"],{"a":"`y`"}]}}}
json: error: <text>:1:23:                       ^
command failed: json-litex -d '\''{"baz":{"bar":{"foo":[["`x`"],{"a":"`y`"}]}}}'\''
$ json-litex -d '\''{"baz":{"bar":[["`x`"],{"a":"`y`"}]}}'\''
json: error: <text>:1:16: filter library: attribute error: invalid array: inner arrays not allowed (the outer array begins at 1:15)
json: error: <text>:1:16: {"baz":{"bar":[["`x`"],{"a":"`y`"}]}}
json: error: <text>:1:16:                ^
command failed: json-litex -d '\''{"baz":{"bar":[["`x`"],{"a":"`y`"}]}}'\''
$ json-litex -d '\''{"baz":[{"foo":[["`x`"],{"a":"`y`"}]}]}'\''
json: error: <text>:1:17: filter library: attribute error: invalid array: inner arrays not allowed (the outer array begins at 1:16)
json: error: <text>:1:17: {"baz":[{"foo":[["`x`"],{"a":"`y`"}]}]}
json: error: <text>:1:17:                 ^
command failed: json-litex -d '\''{"baz":[{"foo":[["`x`"],{"a":"`y`"}]}]}'\''
$ json-litex -d '\''[{"bar":{"foo":[["`x`"],{"a":"`y`"}]}}]'\''
json: error: <text>:1:17: filter library: attribute error: invalid array: inner arrays not allowed (the outer array begins at 1:16)
json: error: <text>:1:17: [{"bar":{"foo":[["`x`"],{"a":"`y`"}]}}]
json: error: <text>:1:17:                 ^
command failed: json-litex -d '\''[{"bar":{"foo":[["`x`"],{"a":"`y`"}]}}]'\'''
) -L inner-array.new <(
echo '$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'
[ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib" 2>&1 ||
echo 'command failed: [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'

echo '$ json-litex() { set -o pipefail && LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value -VF -- ../lib/json-litex.so -A "$@"|sed -r '\''s/"size":[0-9]+,"bytes":\["[0-9a-f]+"(,"[0-9a-f]+")*\]//;s/("lookup":"0x)[0-9a-f]+(")/\1...\2/g'\''|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }'
json-litex() { set -o pipefail && LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value -VF -- ../lib/json-litex.so -A "$@"|sed -r 's/"size":[0-9]+,"bytes":\["[0-9a-f]+"(,"[0-9a-f]+")*\]//;s/("lookup":"0x)[0-9a-f]+(")/\1...\2/g'|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; } 2>&1 ||
echo 'command failed: json-litex() { set -o pipefail && LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value -VF -- ../lib/json-litex.so -A "$@"|sed -r '\''s/"size":[0-9]+,"bytes":\["[0-9a-f]+"(,"[0-9a-f]+")*\]//;s/("lookup":"0x)[0-9a-f]+(")/\1...\2/g'\''|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }'

echo '$ json-litex -d '\''[["`x`"]]'\'''
json-litex -d '[["`x`"]]' 2>&1 ||
echo 'command failed: json-litex -d '\''[["`x`"]]'\'''

echo '$ json-litex -d '\''{"foo":[["`x`"]]}'\'''
json-litex -d '{"foo":[["`x`"]]}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"foo":[["`x`"]]}'\'''

echo '$ json-litex -d '\''{"bar":{"foo":[["`x`"]]}}'\'''
json-litex -d '{"bar":{"foo":[["`x`"]]}}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"bar":{"foo":[["`x`"]]}}'\'''

echo '$ json-litex -d '\''[{"foo":[["`x`"]]}]'\'''
json-litex -d '[{"foo":[["`x`"]]}]' 2>&1 ||
echo 'command failed: json-litex -d '\''[{"foo":[["`x`"]]}]'\'''

echo '$ json-litex -d '\''{"baz":{"bar":{"foo":[["`x`"]]}}}'\'''
json-litex -d '{"baz":{"bar":{"foo":[["`x`"]]}}}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"baz":{"bar":{"foo":[["`x`"]]}}}'\'''

echo '$ json-litex -d '\''{"baz":{"bar":[["`x`"]]}}'\'''
json-litex -d '{"baz":{"bar":[["`x`"]]}}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"baz":{"bar":[["`x`"]]}}'\'''

echo '$ json-litex -d '\''{"baz":[{"foo":[["`x`"]]}]}'\'''
json-litex -d '{"baz":[{"foo":[["`x`"]]}]}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"baz":[{"foo":[["`x`"]]}]}'\'''

echo '$ json-litex -d '\''[{"bar":{"foo":[["`x`"]]}}]'\'''
json-litex -d '[{"bar":{"foo":[["`x`"]]}}]' 2>&1 ||
echo 'command failed: json-litex -d '\''[{"bar":{"foo":[["`x`"]]}}]'\'''

echo '$ json-litex -d '\''["`y`",["`x`"]]'\'''
json-litex -d '["`y`",["`x`"]]' 2>&1 ||
echo 'command failed: json-litex -d '\''["`y`",["`x`"]]'\'''

echo '$ json-litex -d '\''{"foo":["`y`",["`x`"]]}'\'''
json-litex -d '{"foo":["`y`",["`x`"]]}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"foo":["`y`",["`x`"]]}'\'''

echo '$ json-litex -d '\''{"bar":{"foo":["`y`",["`x`"]]}}'\'''
json-litex -d '{"bar":{"foo":["`y`",["`x`"]]}}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"bar":{"foo":["`y`",["`x`"]]}}'\'''

echo '$ json-litex -d '\''[{"foo":["`y`",["`x`"]]}]'\'''
json-litex -d '[{"foo":["`y`",["`x`"]]}]' 2>&1 ||
echo 'command failed: json-litex -d '\''[{"foo":["`y`",["`x`"]]}]'\'''

echo '$ json-litex -d '\''{"baz":{"bar":{"foo":["`y`",["`x`"]]}}}'\'''
json-litex -d '{"baz":{"bar":{"foo":["`y`",["`x`"]]}}}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"baz":{"bar":{"foo":["`y`",["`x`"]]}}}'\'''

echo '$ json-litex -d '\''{"baz":{"bar":["`y`",["`x`"]]}}'\'''
json-litex -d '{"baz":{"bar":["`y`",["`x`"]]}}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"baz":{"bar":["`y`",["`x`"]]}}'\'''

echo '$ json-litex -d '\''{"baz":[{"foo":["`y`",["`x`"]]}]}'\'''
json-litex -d '{"baz":[{"foo":["`y`",["`x`"]]}]}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"baz":[{"foo":["`y`",["`x`"]]}]}'\'''

echo '$ json-litex -d '\''[{"bar":{"foo":["`y`",["`x`"]]}}]'\'''
json-litex -d '[{"bar":{"foo":["`y`",["`x`"]]}}]' 2>&1 ||
echo 'command failed: json-litex -d '\''[{"bar":{"foo":["`y`",["`x`"]]}}]'\'''

echo '$ json-litex -d '\''[["`x`"],"`y`"]'\'''
json-litex -d '[["`x`"],"`y`"]' 2>&1 ||
echo 'command failed: json-litex -d '\''[["`x`"],"`y`"]'\'''

echo '$ json-litex -d '\''{"foo":[["`x`"],"`y`"]}'\'''
json-litex -d '{"foo":[["`x`"],"`y`"]}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"foo":[["`x`"],"`y`"]}'\'''

echo '$ json-litex -d '\''{"bar":{"foo":[["`x`"],"`y`"]}}'\'''
json-litex -d '{"bar":{"foo":[["`x`"],"`y`"]}}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"bar":{"foo":[["`x`"],"`y`"]}}'\'''

echo '$ json-litex -d '\''[{"foo":[["`x`"],"`y`"]}]'\'''
json-litex -d '[{"foo":[["`x`"],"`y`"]}]' 2>&1 ||
echo 'command failed: json-litex -d '\''[{"foo":[["`x`"],"`y`"]}]'\'''

echo '$ json-litex -d '\''{"baz":{"bar":{"foo":[["`x`"],"`y`"]}}}'\'''
json-litex -d '{"baz":{"bar":{"foo":[["`x`"],"`y`"]}}}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"baz":{"bar":{"foo":[["`x`"],"`y`"]}}}'\'''

echo '$ json-litex -d '\''{"baz":{"bar":[["`x`"],"`y`"]}}'\'''
json-litex -d '{"baz":{"bar":[["`x`"],"`y`"]}}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"baz":{"bar":[["`x`"],"`y`"]}}'\'''

echo '$ json-litex -d '\''{"baz":[{"foo":[["`x`"],"`y`"]}]}'\'''
json-litex -d '{"baz":[{"foo":[["`x`"],"`y`"]}]}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"baz":[{"foo":[["`x`"],"`y`"]}]}'\'''

echo '$ json-litex -d '\''[{"bar":{"foo":[["`x`"],"`y`"]}}]'\'''
json-litex -d '[{"bar":{"foo":[["`x`"],"`y`"]}}]' 2>&1 ||
echo 'command failed: json-litex -d '\''[{"bar":{"foo":[["`x`"],"`y`"]}}]'\'''

echo '$ json-litex -d '\''[{"a":"`y`"},["`x`"]]'\'''
json-litex -d '[{"a":"`y`"},["`x`"]]' 2>&1 ||
echo 'command failed: json-litex -d '\''[{"a":"`y`"},["`x`"]]'\'''

echo '$ json-litex -d '\''{"foo":[{"a":"`y`"},["`x`"]]}'\'''
json-litex -d '{"foo":[{"a":"`y`"},["`x`"]]}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"foo":[{"a":"`y`"},["`x`"]]}'\'''

echo '$ json-litex -d '\''{"bar":{"foo":[{"a":"`y`"},["`x`"]]}}'\'''
json-litex -d '{"bar":{"foo":[{"a":"`y`"},["`x`"]]}}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"bar":{"foo":[{"a":"`y`"},["`x`"]]}}'\'''

echo '$ json-litex -d '\''[{"foo":[{"a":"`y`"},["`x`"]]}]'\'''
json-litex -d '[{"foo":[{"a":"`y`"},["`x`"]]}]' 2>&1 ||
echo 'command failed: json-litex -d '\''[{"foo":[{"a":"`y`"},["`x`"]]}]'\'''

echo '$ json-litex -d '\''{"baz":{"bar":{"foo":[{"a":"`y`"},["`x`"]]}}}'\'''
json-litex -d '{"baz":{"bar":{"foo":[{"a":"`y`"},["`x`"]]}}}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"baz":{"bar":{"foo":[{"a":"`y`"},["`x`"]]}}}'\'''

echo '$ json-litex -d '\''{"baz":{"bar":[{"a":"`y`"},["`x`"]]}}'\'''
json-litex -d '{"baz":{"bar":[{"a":"`y`"},["`x`"]]}}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"baz":{"bar":[{"a":"`y`"},["`x`"]]}}'\'''

echo '$ json-litex -d '\''{"baz":[{"foo":[{"a":"`y`"},["`x`"]]}]}'\'''
json-litex -d '{"baz":[{"foo":[{"a":"`y`"},["`x`"]]}]}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"baz":[{"foo":[{"a":"`y`"},["`x`"]]}]}'\'''

echo '$ json-litex -d '\''[{"bar":{"foo":[{"a":"`y`"},["`x`"]]}}]'\'''
json-litex -d '[{"bar":{"foo":[{"a":"`y`"},["`x`"]]}}]' 2>&1 ||
echo 'command failed: json-litex -d '\''[{"bar":{"foo":[{"a":"`y`"},["`x`"]]}}]'\'''

echo '$ json-litex -d '\''[["`x`"],{"a":"`y`"}]'\'''
json-litex -d '[["`x`"],{"a":"`y`"}]' 2>&1 ||
echo 'command failed: json-litex -d '\''[["`x`"],{"a":"`y`"}]'\'''

echo '$ json-litex -d '\''{"foo":[["`x`"],{"a":"`y`"}]}'\'''
json-litex -d '{"foo":[["`x`"],{"a":"`y`"}]}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"foo":[["`x`"],{"a":"`y`"}]}'\'''

echo '$ json-litex -d '\''{"bar":{"foo":[["`x`"],{"a":"`y`"}]}}'\'''
json-litex -d '{"bar":{"foo":[["`x`"],{"a":"`y`"}]}}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"bar":{"foo":[["`x`"],{"a":"`y`"}]}}'\'''

echo '$ json-litex -d '\''[{"foo":[["`x`"],{"a":"`y`"}]}]'\'''
json-litex -d '[{"foo":[["`x`"],{"a":"`y`"}]}]' 2>&1 ||
echo 'command failed: json-litex -d '\''[{"foo":[["`x`"],{"a":"`y`"}]}]'\'''

echo '$ json-litex -d '\''{"baz":{"bar":{"foo":[["`x`"],{"a":"`y`"}]}}}'\'''
json-litex -d '{"baz":{"bar":{"foo":[["`x`"],{"a":"`y`"}]}}}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"baz":{"bar":{"foo":[["`x`"],{"a":"`y`"}]}}}'\'''

echo '$ json-litex -d '\''{"baz":{"bar":[["`x`"],{"a":"`y`"}]}}'\'''
json-litex -d '{"baz":{"bar":[["`x`"],{"a":"`y`"}]}}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"baz":{"bar":[["`x`"],{"a":"`y`"}]}}'\'''

echo '$ json-litex -d '\''{"baz":[{"foo":[["`x`"],{"a":"`y`"}]}]}'\'''
json-litex -d '{"baz":[{"foo":[["`x`"],{"a":"`y`"}]}]}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"baz":[{"foo":[["`x`"],{"a":"`y`"}]}]}'\'''

echo '$ json-litex -d '\''[{"bar":{"foo":[["`x`"],{"a":"`y`"}]}}]'\'''
json-litex -d '[{"bar":{"foo":[["`x`"],{"a":"`y`"}]}}]' 2>&1 ||
echo 'command failed: json-litex -d '\''[{"bar":{"foo":[["`x`"],{"a":"`y`"}]}}]'\'''
)

