#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -p litex -C lib:basic9
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L basic9.old <(echo \
'$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"
$ json-litex() { set -o pipefail && LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value -VF -- ../lib/json-litex.so -A "$@"|sed -r '\''s/"size":[0-9]+,"bytes":\["[0-9a-f]+"(,"[0-9a-f]+")*\]//;s/("lookup":"0x)[0-9a-f]+(")/\1...\2/g'\''|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }
$ json-litex -d '\''{"baz":[{"bar":null}}]'\''
json: error: <text>:1:21: filter library: parse error: unexpected token
json: error: <text>:1:21: {"baz":[{"bar":null}}]
json: error: <text>:1:21:                     ^
command failed: json-litex -d '\''{"baz":[{"bar":null}}]'\''
$ json-litex -d '\''{"baz":[{"bar":false}}]'\''
json: error: <text>:1:22: filter library: parse error: unexpected token
json: error: <text>:1:22: {"baz":[{"bar":false}}]
json: error: <text>:1:22:                      ^
command failed: json-litex -d '\''{"baz":[{"bar":false}}]'\''
$ json-litex -d '\''{"baz":[{"bar":true}}]'\''
json: error: <text>:1:21: filter library: parse error: unexpected token
json: error: <text>:1:21: {"baz":[{"bar":true}}]
json: error: <text>:1:21:                     ^
command failed: json-litex -d '\''{"baz":[{"bar":true}}]'\''
$ json-litex -d '\''{"baz":[{"bar":123}}]'\''
json: error: <text>:1:20: filter library: parse error: unexpected token
json: error: <text>:1:20: {"baz":[{"bar":123}}]
json: error: <text>:1:20:                    ^
command failed: json-litex -d '\''{"baz":[{"bar":123}}]'\''
$ json-litex -d '\''{"baz":[{"bar":""}}]'\''
json: error: <text>:1:19: filter library: parse error: unexpected token
json: error: <text>:1:19: {"baz":[{"bar":""}}]
json: error: <text>:1:19:                   ^
command failed: json-litex -d '\''{"baz":[{"bar":""}}]'\''
$ json-litex -d '\''{"baz":[{"bar":"``"}}]'\''
json: error: <text>:1:21: filter library: parse error: unexpected token
json: error: <text>:1:21: {"baz":[{"bar":"``"}}]
json: error: <text>:1:21:                     ^
command failed: json-litex -d '\''{"baz":[{"bar":"``"}}]'\''
$ json-litex -d '\''{"baz":[{"bar":"//"}}]'\''
json: error: <text>:1:21: filter library: parse error: unexpected token
json: error: <text>:1:21: {"baz":[{"bar":"//"}}]
json: error: <text>:1:21:                     ^
command failed: json-litex -d '\''{"baz":[{"bar":"//"}}]'\''
$ json-litex -d '\''{"baz":[{"bar":"'\''\'\'''\'''\''\'\'''\''"}}]'\''
json: error: <text>:1:21: filter library: parse error: unexpected token
json: error: <text>:1:21: {"baz":[{"bar":"'\'''\''"}}]
json: error: <text>:1:21:                     ^
command failed: json-litex -d '\''{"baz":[{"bar":"'\''\'\'''\'''\''\'\'''\''"}}]'\''
$ json-litex -d '\''{"baz":[{"bar":"foo"}}]'\''
json: error: <text>:1:22: filter library: parse error: unexpected token
json: error: <text>:1:22: {"baz":[{"bar":"foo"}}]
json: error: <text>:1:22:                      ^
command failed: json-litex -d '\''{"baz":[{"bar":"foo"}}]'\''
$ json-litex -d '\''{"baz":[{"bar":"`foo`"}}]'\''
json: error: <text>:1:24: filter library: parse error: unexpected token
json: error: <text>:1:24: {"baz":[{"bar":"`foo`"}}]
json: error: <text>:1:24:                        ^
command failed: json-litex -d '\''{"baz":[{"bar":"`foo`"}}]'\''
$ json-litex -d '\''{"baz":[{"bar":"/foo/"}}]'\''
json: error: <text>:1:24: filter library: parse error: unexpected token
json: error: <text>:1:24: {"baz":[{"bar":"/foo/"}}]
json: error: <text>:1:24:                        ^
command failed: json-litex -d '\''{"baz":[{"bar":"/foo/"}}]'\''
$ json-litex -d '\''{"baz":[{"bar":"'\''\'\'''\''foo'\''\'\'''\''"}}]'\''
json: error: <text>:1:24: filter library: parse error: unexpected token
json: error: <text>:1:24: {"baz":[{"bar":"'\''foo'\''"}}]
json: error: <text>:1:24:                        ^
command failed: json-litex -d '\''{"baz":[{"bar":"'\''\'\'''\''foo'\''\'\'''\''"}}]'\''
$ json-litex -d '\''{"baz":[{"bar":{}}}]'\''
json: error: <text>:1:19: filter library: parse error: unexpected token
json: error: <text>:1:19: {"baz":[{"bar":{}}}]
json: error: <text>:1:19:                   ^
command failed: json-litex -d '\''{"baz":[{"bar":{}}}]'\''
$ json-litex -d '\''{"baz":[{"bar":[]}}]'\''
json: error: <text>:1:19: filter library: parse error: unexpected token
json: error: <text>:1:19: {"baz":[{"bar":[]}}]
json: error: <text>:1:19:                   ^
command failed: json-litex -d '\''{"baz":[{"bar":[]}}]'\'''
) -L basic9.new <(
echo '$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'
[ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib" 2>&1 ||
echo 'command failed: [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'

echo '$ json-litex() { set -o pipefail && LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value -VF -- ../lib/json-litex.so -A "$@"|sed -r '\''s/"size":[0-9]+,"bytes":\["[0-9a-f]+"(,"[0-9a-f]+")*\]//;s/("lookup":"0x)[0-9a-f]+(")/\1...\2/g'\''|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }'
json-litex() { set -o pipefail && LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value -VF -- ../lib/json-litex.so -A "$@"|sed -r 's/"size":[0-9]+,"bytes":\["[0-9a-f]+"(,"[0-9a-f]+")*\]//;s/("lookup":"0x)[0-9a-f]+(")/\1...\2/g'|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; } 2>&1 ||
echo 'command failed: json-litex() { set -o pipefail && LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value -VF -- ../lib/json-litex.so -A "$@"|sed -r '\''s/"size":[0-9]+,"bytes":\["[0-9a-f]+"(,"[0-9a-f]+")*\]//;s/("lookup":"0x)[0-9a-f]+(")/\1...\2/g'\''|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }'

echo '$ json-litex -d '\''{"baz":[{"bar":null}}]'\'''
json-litex -d '{"baz":[{"bar":null}}]' 2>&1 ||
echo 'command failed: json-litex -d '\''{"baz":[{"bar":null}}]'\'''

echo '$ json-litex -d '\''{"baz":[{"bar":false}}]'\'''
json-litex -d '{"baz":[{"bar":false}}]' 2>&1 ||
echo 'command failed: json-litex -d '\''{"baz":[{"bar":false}}]'\'''

echo '$ json-litex -d '\''{"baz":[{"bar":true}}]'\'''
json-litex -d '{"baz":[{"bar":true}}]' 2>&1 ||
echo 'command failed: json-litex -d '\''{"baz":[{"bar":true}}]'\'''

echo '$ json-litex -d '\''{"baz":[{"bar":123}}]'\'''
json-litex -d '{"baz":[{"bar":123}}]' 2>&1 ||
echo 'command failed: json-litex -d '\''{"baz":[{"bar":123}}]'\'''

echo '$ json-litex -d '\''{"baz":[{"bar":""}}]'\'''
json-litex -d '{"baz":[{"bar":""}}]' 2>&1 ||
echo 'command failed: json-litex -d '\''{"baz":[{"bar":""}}]'\'''

echo '$ json-litex -d '\''{"baz":[{"bar":"``"}}]'\'''
json-litex -d '{"baz":[{"bar":"``"}}]' 2>&1 ||
echo 'command failed: json-litex -d '\''{"baz":[{"bar":"``"}}]'\'''

echo '$ json-litex -d '\''{"baz":[{"bar":"//"}}]'\'''
json-litex -d '{"baz":[{"bar":"//"}}]' 2>&1 ||
echo 'command failed: json-litex -d '\''{"baz":[{"bar":"//"}}]'\'''

echo '$ json-litex -d '\''{"baz":[{"bar":"'\''\'\'''\'''\''\'\'''\''"}}]'\'''
json-litex -d '{"baz":[{"bar":"'\'''\''"}}]' 2>&1 ||
echo 'command failed: json-litex -d '\''{"baz":[{"bar":"'\''\'\'''\'''\''\'\'''\''"}}]'\'''

echo '$ json-litex -d '\''{"baz":[{"bar":"foo"}}]'\'''
json-litex -d '{"baz":[{"bar":"foo"}}]' 2>&1 ||
echo 'command failed: json-litex -d '\''{"baz":[{"bar":"foo"}}]'\'''

echo '$ json-litex -d '\''{"baz":[{"bar":"`foo`"}}]'\'''
json-litex -d '{"baz":[{"bar":"`foo`"}}]' 2>&1 ||
echo 'command failed: json-litex -d '\''{"baz":[{"bar":"`foo`"}}]'\'''

echo '$ json-litex -d '\''{"baz":[{"bar":"/foo/"}}]'\'''
json-litex -d '{"baz":[{"bar":"/foo/"}}]' 2>&1 ||
echo 'command failed: json-litex -d '\''{"baz":[{"bar":"/foo/"}}]'\'''

echo '$ json-litex -d '\''{"baz":[{"bar":"'\''\'\'''\''foo'\''\'\'''\''"}}]'\'''
json-litex -d '{"baz":[{"bar":"'\''foo'\''"}}]' 2>&1 ||
echo 'command failed: json-litex -d '\''{"baz":[{"bar":"'\''\'\'''\''foo'\''\'\'''\''"}}]'\'''

echo '$ json-litex -d '\''{"baz":[{"bar":{}}}]'\'''
json-litex -d '{"baz":[{"bar":{}}}]' 2>&1 ||
echo 'command failed: json-litex -d '\''{"baz":[{"bar":{}}}]'\'''

echo '$ json-litex -d '\''{"baz":[{"bar":[]}}]'\'''
json-litex -d '{"baz":[{"bar":[]}}]' 2>&1 ||
echo 'command failed: json-litex -d '\''{"baz":[{"bar":[]}}]'\'''
)

