#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -p litex -C checker:const-true
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L const-true.old <(echo \
'$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"
$ json-litex() { set -o pipefail && LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value --parse-only -Vf -- ../lib/json-litex.so "$@"; }
$ json-litex -d '\''"1"'\'' <<< '\''null'\''
$ json-litex -d '\''"1"'\'' <<< '\''false'\''
$ json-litex -d '\''"1"'\'' <<< '\''true'\''
$ json-litex -d '\''"1"'\'' <<< '\''123'\''
$ json-litex -d '\''"1"'\'' <<< '\''"zzz"'\''
$ json-litex -d '\''"1"'\'' <<< '\''[]'\''
$ json-litex -d '\''"1"'\'' <<< '\''{}'\''
$ json-litex -d '\''"1"'\'' <<< '\''[null]'\''
$ json-litex -d '\''"1"'\'' <<< '\''[false]'\''
$ json-litex -d '\''"1"'\'' <<< '\''[true]'\''
$ json-litex -d '\''"1"'\'' <<< '\''[123]'\''
$ json-litex -d '\''"1"'\'' <<< '\''["zzz"]'\''
$ json-litex -d '\''"1"'\'' <<< '\''[[]]'\''
$ json-litex -d '\''"1"'\'' <<< '\''[{}]'\''
$ json-litex -d '\''"1"'\'' <<< '\''{"foo":null}'\''
json: error: <stdin>:1:8: filter library: path check error: unexpected JSON literal
json: error: <stdin>:1:8: {"foo":null}
json: error: <stdin>:1:8:        ^
command failed: json-litex -d '\''"1"'\'' <<< '\''{"foo":null}'\''
$ json-litex -d '\''"1"'\'' <<< '\''{"foo":false}'\''
json: error: <stdin>:1:8: filter library: path check error: unexpected JSON literal
json: error: <stdin>:1:8: {"foo":false}
json: error: <stdin>:1:8:        ^
command failed: json-litex -d '\''"1"'\'' <<< '\''{"foo":false}'\''
$ json-litex -d '\''"1"'\'' <<< '\''{"foo":true}'\''
json: error: <stdin>:1:8: filter library: path check error: unexpected JSON literal
json: error: <stdin>:1:8: {"foo":true}
json: error: <stdin>:1:8:        ^
command failed: json-litex -d '\''"1"'\'' <<< '\''{"foo":true}'\''
$ json-litex -d '\''"1"'\'' <<< '\''{"foo":123}'\''
json: error: <stdin>:1:8: filter library: path check error: unexpected JSON literal
json: error: <stdin>:1:8: {"foo":123}
json: error: <stdin>:1:8:        ^
command failed: json-litex -d '\''"1"'\'' <<< '\''{"foo":123}'\''
$ json-litex -d '\''"1"'\'' <<< '\''{"foo":"zzz"}'\''
json: error: <stdin>:1:8: filter library: path check error: unexpected JSON literal
json: error: <stdin>:1:8: {"foo":"zzz"}
json: error: <stdin>:1:8:        ^
command failed: json-litex -d '\''"1"'\'' <<< '\''{"foo":"zzz"}'\''
$ json-litex -d '\''"1"'\'' <<< '\''{"foo":[]}'\''
$ json-litex -d '\''"1"'\'' <<< '\''{"foo":{}}'\''
$ json-litex -d '\''"1"'\'' <<< '\''[[null]]'\''
$ json-litex -d '\''"1"'\'' <<< '\''[[false]]'\''
$ json-litex -d '\''"1"'\'' <<< '\''[[true]]'\''
$ json-litex -d '\''"1"'\'' <<< '\''[[123]]'\''
$ json-litex -d '\''"1"'\'' <<< '\''[["zzz"]]'\''
$ json-litex -d '\''"1"'\'' <<< '\''[[[]]]'\''
$ json-litex -d '\''"1"'\'' <<< '\''[[{}]]'\''
$ json-litex -d '\''"1"'\'' <<< '\''[{"foo":null}]'\''
json: error: <stdin>:1:9: filter library: path check error: unexpected JSON literal
json: error: <stdin>:1:9: [{"foo":null}]
json: error: <stdin>:1:9:         ^
command failed: json-litex -d '\''"1"'\'' <<< '\''[{"foo":null}]'\''
$ json-litex -d '\''"1"'\'' <<< '\''[{"foo":false}]'\''
json: error: <stdin>:1:9: filter library: path check error: unexpected JSON literal
json: error: <stdin>:1:9: [{"foo":false}]
json: error: <stdin>:1:9:         ^
command failed: json-litex -d '\''"1"'\'' <<< '\''[{"foo":false}]'\''
$ json-litex -d '\''"1"'\'' <<< '\''[{"foo":true}]'\''
json: error: <stdin>:1:9: filter library: path check error: unexpected JSON literal
json: error: <stdin>:1:9: [{"foo":true}]
json: error: <stdin>:1:9:         ^
command failed: json-litex -d '\''"1"'\'' <<< '\''[{"foo":true}]'\''
$ json-litex -d '\''"1"'\'' <<< '\''[{"foo":123}]'\''
json: error: <stdin>:1:9: filter library: path check error: unexpected JSON literal
json: error: <stdin>:1:9: [{"foo":123}]
json: error: <stdin>:1:9:         ^
command failed: json-litex -d '\''"1"'\'' <<< '\''[{"foo":123}]'\''
$ json-litex -d '\''"1"'\'' <<< '\''[{"foo":"zzz"}]'\''
json: error: <stdin>:1:9: filter library: path check error: unexpected JSON literal
json: error: <stdin>:1:9: [{"foo":"zzz"}]
json: error: <stdin>:1:9:         ^
command failed: json-litex -d '\''"1"'\'' <<< '\''[{"foo":"zzz"}]'\''
$ json-litex -d '\''"1"'\'' <<< '\''[{"foo":[]}]'\''
$ json-litex -d '\''"1"'\'' <<< '\''[{"foo":{}}]'\''
$ json-litex -d '\''"1"'\'' <<< '\''{"foo":[null]}'\''
json: error: <stdin>:1:9: filter library: path check error: unexpected JSON literal
json: error: <stdin>:1:9: {"foo":[null]}
json: error: <stdin>:1:9:         ^
command failed: json-litex -d '\''"1"'\'' <<< '\''{"foo":[null]}'\''
$ json-litex -d '\''"1"'\'' <<< '\''{"foo":[false]}'\''
json: error: <stdin>:1:9: filter library: path check error: unexpected JSON literal
json: error: <stdin>:1:9: {"foo":[false]}
json: error: <stdin>:1:9:         ^
command failed: json-litex -d '\''"1"'\'' <<< '\''{"foo":[false]}'\''
$ json-litex -d '\''"1"'\'' <<< '\''{"foo":[true]}'\''
json: error: <stdin>:1:9: filter library: path check error: unexpected JSON literal
json: error: <stdin>:1:9: {"foo":[true]}
json: error: <stdin>:1:9:         ^
command failed: json-litex -d '\''"1"'\'' <<< '\''{"foo":[true]}'\''
$ json-litex -d '\''"1"'\'' <<< '\''{"foo":[123]}'\''
json: error: <stdin>:1:9: filter library: path check error: unexpected JSON literal
json: error: <stdin>:1:9: {"foo":[123]}
json: error: <stdin>:1:9:         ^
command failed: json-litex -d '\''"1"'\'' <<< '\''{"foo":[123]}'\''
$ json-litex -d '\''"1"'\'' <<< '\''{"foo":["zzz"]}'\''
json: error: <stdin>:1:9: filter library: path check error: unexpected JSON literal
json: error: <stdin>:1:9: {"foo":["zzz"]}
json: error: <stdin>:1:9:         ^
command failed: json-litex -d '\''"1"'\'' <<< '\''{"foo":["zzz"]}'\''
$ json-litex -d '\''"1"'\'' <<< '\''{"foo":[[]]}'\''
$ json-litex -d '\''"1"'\'' <<< '\''{"foo":[{}]}'\''
$ json-litex -d '\''"1"'\'' <<< '\''{"foo":{"bar":null}}'\''
json: error: <stdin>:1:15: filter library: path check error: unexpected JSON literal
json: error: <stdin>:1:15: {"foo":{"bar":null}}
json: error: <stdin>:1:15:               ^
command failed: json-litex -d '\''"1"'\'' <<< '\''{"foo":{"bar":null}}'\''
$ json-litex -d '\''"1"'\'' <<< '\''{"foo":{"bar":false}}'\''
json: error: <stdin>:1:15: filter library: path check error: unexpected JSON literal
json: error: <stdin>:1:15: {"foo":{"bar":false}}
json: error: <stdin>:1:15:               ^
command failed: json-litex -d '\''"1"'\'' <<< '\''{"foo":{"bar":false}}'\''
$ json-litex -d '\''"1"'\'' <<< '\''{"foo":{"bar":true}}'\''
json: error: <stdin>:1:15: filter library: path check error: unexpected JSON literal
json: error: <stdin>:1:15: {"foo":{"bar":true}}
json: error: <stdin>:1:15:               ^
command failed: json-litex -d '\''"1"'\'' <<< '\''{"foo":{"bar":true}}'\''
$ json-litex -d '\''"1"'\'' <<< '\''{"foo":{"bar":123}}'\''
json: error: <stdin>:1:15: filter library: path check error: unexpected JSON literal
json: error: <stdin>:1:15: {"foo":{"bar":123}}
json: error: <stdin>:1:15:               ^
command failed: json-litex -d '\''"1"'\'' <<< '\''{"foo":{"bar":123}}'\''
$ json-litex -d '\''"1"'\'' <<< '\''{"foo":{"bar":"zzz"}}'\''
json: error: <stdin>:1:15: filter library: path check error: unexpected JSON literal
json: error: <stdin>:1:15: {"foo":{"bar":"zzz"}}
json: error: <stdin>:1:15:               ^
command failed: json-litex -d '\''"1"'\'' <<< '\''{"foo":{"bar":"zzz"}}'\''
$ json-litex -d '\''"1"'\'' <<< '\''{"foo":{"bar":[]}}'\''
$ json-litex -d '\''"1"'\'' <<< '\''{"foo":{"bar":{}}}'\'''
) -L const-true.new <(
echo '$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'
[ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib" 2>&1 ||
echo 'command failed: [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'

echo '$ json-litex() { set -o pipefail && LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value --parse-only -Vf -- ../lib/json-litex.so "$@"; }'
json-litex() { set -o pipefail && LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value --parse-only -Vf -- ../lib/json-litex.so "$@"; } 2>&1 ||
echo 'command failed: json-litex() { set -o pipefail && LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value --parse-only -Vf -- ../lib/json-litex.so "$@"; }'

echo '$ json-litex -d '\''"1"'\'' <<< '\''null'\'''
json-litex -d '"1"' <<< 'null' 2>&1 ||
echo 'command failed: json-litex -d '\''"1"'\'' <<< '\''null'\'''

echo '$ json-litex -d '\''"1"'\'' <<< '\''false'\'''
json-litex -d '"1"' <<< 'false' 2>&1 ||
echo 'command failed: json-litex -d '\''"1"'\'' <<< '\''false'\'''

echo '$ json-litex -d '\''"1"'\'' <<< '\''true'\'''
json-litex -d '"1"' <<< 'true' 2>&1 ||
echo 'command failed: json-litex -d '\''"1"'\'' <<< '\''true'\'''

echo '$ json-litex -d '\''"1"'\'' <<< '\''123'\'''
json-litex -d '"1"' <<< '123' 2>&1 ||
echo 'command failed: json-litex -d '\''"1"'\'' <<< '\''123'\'''

echo '$ json-litex -d '\''"1"'\'' <<< '\''"zzz"'\'''
json-litex -d '"1"' <<< '"zzz"' 2>&1 ||
echo 'command failed: json-litex -d '\''"1"'\'' <<< '\''"zzz"'\'''

echo '$ json-litex -d '\''"1"'\'' <<< '\''[]'\'''
json-litex -d '"1"' <<< '[]' 2>&1 ||
echo 'command failed: json-litex -d '\''"1"'\'' <<< '\''[]'\'''

echo '$ json-litex -d '\''"1"'\'' <<< '\''{}'\'''
json-litex -d '"1"' <<< '{}' 2>&1 ||
echo 'command failed: json-litex -d '\''"1"'\'' <<< '\''{}'\'''

echo '$ json-litex -d '\''"1"'\'' <<< '\''[null]'\'''
json-litex -d '"1"' <<< '[null]' 2>&1 ||
echo 'command failed: json-litex -d '\''"1"'\'' <<< '\''[null]'\'''

echo '$ json-litex -d '\''"1"'\'' <<< '\''[false]'\'''
json-litex -d '"1"' <<< '[false]' 2>&1 ||
echo 'command failed: json-litex -d '\''"1"'\'' <<< '\''[false]'\'''

echo '$ json-litex -d '\''"1"'\'' <<< '\''[true]'\'''
json-litex -d '"1"' <<< '[true]' 2>&1 ||
echo 'command failed: json-litex -d '\''"1"'\'' <<< '\''[true]'\'''

echo '$ json-litex -d '\''"1"'\'' <<< '\''[123]'\'''
json-litex -d '"1"' <<< '[123]' 2>&1 ||
echo 'command failed: json-litex -d '\''"1"'\'' <<< '\''[123]'\'''

echo '$ json-litex -d '\''"1"'\'' <<< '\''["zzz"]'\'''
json-litex -d '"1"' <<< '["zzz"]' 2>&1 ||
echo 'command failed: json-litex -d '\''"1"'\'' <<< '\''["zzz"]'\'''

echo '$ json-litex -d '\''"1"'\'' <<< '\''[[]]'\'''
json-litex -d '"1"' <<< '[[]]' 2>&1 ||
echo 'command failed: json-litex -d '\''"1"'\'' <<< '\''[[]]'\'''

echo '$ json-litex -d '\''"1"'\'' <<< '\''[{}]'\'''
json-litex -d '"1"' <<< '[{}]' 2>&1 ||
echo 'command failed: json-litex -d '\''"1"'\'' <<< '\''[{}]'\'''

echo '$ json-litex -d '\''"1"'\'' <<< '\''{"foo":null}'\'''
json-litex -d '"1"' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json-litex -d '\''"1"'\'' <<< '\''{"foo":null}'\'''

echo '$ json-litex -d '\''"1"'\'' <<< '\''{"foo":false}'\'''
json-litex -d '"1"' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json-litex -d '\''"1"'\'' <<< '\''{"foo":false}'\'''

echo '$ json-litex -d '\''"1"'\'' <<< '\''{"foo":true}'\'''
json-litex -d '"1"' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json-litex -d '\''"1"'\'' <<< '\''{"foo":true}'\'''

echo '$ json-litex -d '\''"1"'\'' <<< '\''{"foo":123}'\'''
json-litex -d '"1"' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json-litex -d '\''"1"'\'' <<< '\''{"foo":123}'\'''

echo '$ json-litex -d '\''"1"'\'' <<< '\''{"foo":"zzz"}'\'''
json-litex -d '"1"' <<< '{"foo":"zzz"}' 2>&1 ||
echo 'command failed: json-litex -d '\''"1"'\'' <<< '\''{"foo":"zzz"}'\'''

echo '$ json-litex -d '\''"1"'\'' <<< '\''{"foo":[]}'\'''
json-litex -d '"1"' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json-litex -d '\''"1"'\'' <<< '\''{"foo":[]}'\'''

echo '$ json-litex -d '\''"1"'\'' <<< '\''{"foo":{}}'\'''
json-litex -d '"1"' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json-litex -d '\''"1"'\'' <<< '\''{"foo":{}}'\'''

echo '$ json-litex -d '\''"1"'\'' <<< '\''[[null]]'\'''
json-litex -d '"1"' <<< '[[null]]' 2>&1 ||
echo 'command failed: json-litex -d '\''"1"'\'' <<< '\''[[null]]'\'''

echo '$ json-litex -d '\''"1"'\'' <<< '\''[[false]]'\'''
json-litex -d '"1"' <<< '[[false]]' 2>&1 ||
echo 'command failed: json-litex -d '\''"1"'\'' <<< '\''[[false]]'\'''

echo '$ json-litex -d '\''"1"'\'' <<< '\''[[true]]'\'''
json-litex -d '"1"' <<< '[[true]]' 2>&1 ||
echo 'command failed: json-litex -d '\''"1"'\'' <<< '\''[[true]]'\'''

echo '$ json-litex -d '\''"1"'\'' <<< '\''[[123]]'\'''
json-litex -d '"1"' <<< '[[123]]' 2>&1 ||
echo 'command failed: json-litex -d '\''"1"'\'' <<< '\''[[123]]'\'''

echo '$ json-litex -d '\''"1"'\'' <<< '\''[["zzz"]]'\'''
json-litex -d '"1"' <<< '[["zzz"]]' 2>&1 ||
echo 'command failed: json-litex -d '\''"1"'\'' <<< '\''[["zzz"]]'\'''

echo '$ json-litex -d '\''"1"'\'' <<< '\''[[[]]]'\'''
json-litex -d '"1"' <<< '[[[]]]' 2>&1 ||
echo 'command failed: json-litex -d '\''"1"'\'' <<< '\''[[[]]]'\'''

echo '$ json-litex -d '\''"1"'\'' <<< '\''[[{}]]'\'''
json-litex -d '"1"' <<< '[[{}]]' 2>&1 ||
echo 'command failed: json-litex -d '\''"1"'\'' <<< '\''[[{}]]'\'''

echo '$ json-litex -d '\''"1"'\'' <<< '\''[{"foo":null}]'\'''
json-litex -d '"1"' <<< '[{"foo":null}]' 2>&1 ||
echo 'command failed: json-litex -d '\''"1"'\'' <<< '\''[{"foo":null}]'\'''

echo '$ json-litex -d '\''"1"'\'' <<< '\''[{"foo":false}]'\'''
json-litex -d '"1"' <<< '[{"foo":false}]' 2>&1 ||
echo 'command failed: json-litex -d '\''"1"'\'' <<< '\''[{"foo":false}]'\'''

echo '$ json-litex -d '\''"1"'\'' <<< '\''[{"foo":true}]'\'''
json-litex -d '"1"' <<< '[{"foo":true}]' 2>&1 ||
echo 'command failed: json-litex -d '\''"1"'\'' <<< '\''[{"foo":true}]'\'''

echo '$ json-litex -d '\''"1"'\'' <<< '\''[{"foo":123}]'\'''
json-litex -d '"1"' <<< '[{"foo":123}]' 2>&1 ||
echo 'command failed: json-litex -d '\''"1"'\'' <<< '\''[{"foo":123}]'\'''

echo '$ json-litex -d '\''"1"'\'' <<< '\''[{"foo":"zzz"}]'\'''
json-litex -d '"1"' <<< '[{"foo":"zzz"}]' 2>&1 ||
echo 'command failed: json-litex -d '\''"1"'\'' <<< '\''[{"foo":"zzz"}]'\'''

echo '$ json-litex -d '\''"1"'\'' <<< '\''[{"foo":[]}]'\'''
json-litex -d '"1"' <<< '[{"foo":[]}]' 2>&1 ||
echo 'command failed: json-litex -d '\''"1"'\'' <<< '\''[{"foo":[]}]'\'''

echo '$ json-litex -d '\''"1"'\'' <<< '\''[{"foo":{}}]'\'''
json-litex -d '"1"' <<< '[{"foo":{}}]' 2>&1 ||
echo 'command failed: json-litex -d '\''"1"'\'' <<< '\''[{"foo":{}}]'\'''

echo '$ json-litex -d '\''"1"'\'' <<< '\''{"foo":[null]}'\'''
json-litex -d '"1"' <<< '{"foo":[null]}' 2>&1 ||
echo 'command failed: json-litex -d '\''"1"'\'' <<< '\''{"foo":[null]}'\'''

echo '$ json-litex -d '\''"1"'\'' <<< '\''{"foo":[false]}'\'''
json-litex -d '"1"' <<< '{"foo":[false]}' 2>&1 ||
echo 'command failed: json-litex -d '\''"1"'\'' <<< '\''{"foo":[false]}'\'''

echo '$ json-litex -d '\''"1"'\'' <<< '\''{"foo":[true]}'\'''
json-litex -d '"1"' <<< '{"foo":[true]}' 2>&1 ||
echo 'command failed: json-litex -d '\''"1"'\'' <<< '\''{"foo":[true]}'\'''

echo '$ json-litex -d '\''"1"'\'' <<< '\''{"foo":[123]}'\'''
json-litex -d '"1"' <<< '{"foo":[123]}' 2>&1 ||
echo 'command failed: json-litex -d '\''"1"'\'' <<< '\''{"foo":[123]}'\'''

echo '$ json-litex -d '\''"1"'\'' <<< '\''{"foo":["zzz"]}'\'''
json-litex -d '"1"' <<< '{"foo":["zzz"]}' 2>&1 ||
echo 'command failed: json-litex -d '\''"1"'\'' <<< '\''{"foo":["zzz"]}'\'''

echo '$ json-litex -d '\''"1"'\'' <<< '\''{"foo":[[]]}'\'''
json-litex -d '"1"' <<< '{"foo":[[]]}' 2>&1 ||
echo 'command failed: json-litex -d '\''"1"'\'' <<< '\''{"foo":[[]]}'\'''

echo '$ json-litex -d '\''"1"'\'' <<< '\''{"foo":[{}]}'\'''
json-litex -d '"1"' <<< '{"foo":[{}]}' 2>&1 ||
echo 'command failed: json-litex -d '\''"1"'\'' <<< '\''{"foo":[{}]}'\'''

echo '$ json-litex -d '\''"1"'\'' <<< '\''{"foo":{"bar":null}}'\'''
json-litex -d '"1"' <<< '{"foo":{"bar":null}}' 2>&1 ||
echo 'command failed: json-litex -d '\''"1"'\'' <<< '\''{"foo":{"bar":null}}'\'''

echo '$ json-litex -d '\''"1"'\'' <<< '\''{"foo":{"bar":false}}'\'''
json-litex -d '"1"' <<< '{"foo":{"bar":false}}' 2>&1 ||
echo 'command failed: json-litex -d '\''"1"'\'' <<< '\''{"foo":{"bar":false}}'\'''

echo '$ json-litex -d '\''"1"'\'' <<< '\''{"foo":{"bar":true}}'\'''
json-litex -d '"1"' <<< '{"foo":{"bar":true}}' 2>&1 ||
echo 'command failed: json-litex -d '\''"1"'\'' <<< '\''{"foo":{"bar":true}}'\'''

echo '$ json-litex -d '\''"1"'\'' <<< '\''{"foo":{"bar":123}}'\'''
json-litex -d '"1"' <<< '{"foo":{"bar":123}}' 2>&1 ||
echo 'command failed: json-litex -d '\''"1"'\'' <<< '\''{"foo":{"bar":123}}'\'''

echo '$ json-litex -d '\''"1"'\'' <<< '\''{"foo":{"bar":"zzz"}}'\'''
json-litex -d '"1"' <<< '{"foo":{"bar":"zzz"}}' 2>&1 ||
echo 'command failed: json-litex -d '\''"1"'\'' <<< '\''{"foo":{"bar":"zzz"}}'\'''

echo '$ json-litex -d '\''"1"'\'' <<< '\''{"foo":{"bar":[]}}'\'''
json-litex -d '"1"' <<< '{"foo":{"bar":[]}}' 2>&1 ||
echo 'command failed: json-litex -d '\''"1"'\'' <<< '\''{"foo":{"bar":[]}}'\'''

echo '$ json-litex -d '\''"1"'\'' <<< '\''{"foo":{"bar":{}}}'\'''
json-litex -d '"1"' <<< '{"foo":{"bar":{}}}' 2>&1 ||
echo 'command failed: json-litex -d '\''"1"'\'' <<< '\''{"foo":{"bar":{}}}'\'''
)

