#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C escape:non-ascii4
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L non-ascii4.old <(echo \
'$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --no-validate-utf8 --escape-json --verbose "$@"|sed -n l; }
$ echo -ne '\''\xc2\b'\''|json -b 1
\302\\b$
$ echo -ne '\''\xc2\b'\''|json -b 2
\302\\b$
$ echo -ne '\''\xc2\f'\''|json -b 1
\302\\f$
$ echo -ne '\''\xc2\f'\''|json -b 2
\302\\f$
$ echo -ne '\''\xc2\n'\''|json -b 1
\302\\n$
$ echo -ne '\''\xc2\n'\''|json -b 2
\302\\n$
$ echo -ne '\''\xc2\r'\''|json -b 1
\302\\r$
$ echo -ne '\''\xc2\r'\''|json -b 2
\302\\r$
$ echo -ne '\''\xc2\t'\''|json -b 1
\302\\t$
$ echo -ne '\''\xc2\t'\''|json -b 2
\302\\t$
$ echo -ne '\''\xc3\b'\''|json -b 1
\303\\b$
$ echo -ne '\''\xc3\b'\''|json -b 2
\303\\b$
$ echo -ne '\''\xc3\f'\''|json -b 1
\303\\f$
$ echo -ne '\''\xc3\f'\''|json -b 2
\303\\f$
$ echo -ne '\''\xc3\n'\''|json -b 1
\303\\n$
$ echo -ne '\''\xc3\n'\''|json -b 2
\303\\n$
$ echo -ne '\''\xc3\r'\''|json -b 1
\303\\r$
$ echo -ne '\''\xc3\r'\''|json -b 2
\303\\r$
$ echo -ne '\''\xc3\t'\''|json -b 1
\303\\t$
$ echo -ne '\''\xc3\t'\''|json -b 2
\303\\t$
$ echo -ne '\''\xc4\b'\''|json -b 1
\304\\b$
$ echo -ne '\''\xc4\b'\''|json -b 2
\304\\b$
$ echo -ne '\''\xc4\f'\''|json -b 1
\304\\f$
$ echo -ne '\''\xc4\f'\''|json -b 2
\304\\f$
$ echo -ne '\''\xc4\n'\''|json -b 1
\304\\n$
$ echo -ne '\''\xc4\n'\''|json -b 2
\304\\n$
$ echo -ne '\''\xc4\r'\''|json -b 1
\304\\r$
$ echo -ne '\''\xc4\r'\''|json -b 2
\304\\r$
$ echo -ne '\''\xc4\t'\''|json -b 1
\304\\t$
$ echo -ne '\''\xc4\t'\''|json -b 2
\304\\t$
$ echo -ne '\''\xc5\b'\''|json -b 1
\305\\b$
$ echo -ne '\''\xc5\b'\''|json -b 2
\305\\b$
$ echo -ne '\''\xc5\f'\''|json -b 1
\305\\f$
$ echo -ne '\''\xc5\f'\''|json -b 2
\305\\f$
$ echo -ne '\''\xc5\n'\''|json -b 1
\305\\n$
$ echo -ne '\''\xc5\n'\''|json -b 2
\305\\n$
$ echo -ne '\''\xc5\r'\''|json -b 1
\305\\r$
$ echo -ne '\''\xc5\r'\''|json -b 2
\305\\r$
$ echo -ne '\''\xc5\t'\''|json -b 1
\305\\t$
$ echo -ne '\''\xc5\t'\''|json -b 2
\305\\t$
$ echo -ne '\''\xc6\b'\''|json -b 1
\306\\b$
$ echo -ne '\''\xc6\b'\''|json -b 2
\306\\b$
$ echo -ne '\''\xc6\f'\''|json -b 1
\306\\f$
$ echo -ne '\''\xc6\f'\''|json -b 2
\306\\f$
$ echo -ne '\''\xc6\n'\''|json -b 1
\306\\n$
$ echo -ne '\''\xc6\n'\''|json -b 2
\306\\n$
$ echo -ne '\''\xc6\r'\''|json -b 1
\306\\r$
$ echo -ne '\''\xc6\r'\''|json -b 2
\306\\r$
$ echo -ne '\''\xc6\t'\''|json -b 1
\306\\t$
$ echo -ne '\''\xc6\t'\''|json -b 2
\306\\t$
$ echo -ne '\''\xc7\b'\''|json -b 1
\307\\b$
$ echo -ne '\''\xc7\b'\''|json -b 2
\307\\b$
$ echo -ne '\''\xc7\f'\''|json -b 1
\307\\f$
$ echo -ne '\''\xc7\f'\''|json -b 2
\307\\f$
$ echo -ne '\''\xc7\n'\''|json -b 1
\307\\n$
$ echo -ne '\''\xc7\n'\''|json -b 2
\307\\n$
$ echo -ne '\''\xc7\r'\''|json -b 1
\307\\r$
$ echo -ne '\''\xc7\r'\''|json -b 2
\307\\r$
$ echo -ne '\''\xc7\t'\''|json -b 1
\307\\t$
$ echo -ne '\''\xc7\t'\''|json -b 2
\307\\t$
$ echo -ne '\''\xc8\b'\''|json -b 1
\310\\b$
$ echo -ne '\''\xc8\b'\''|json -b 2
\310\\b$
$ echo -ne '\''\xc8\f'\''|json -b 1
\310\\f$
$ echo -ne '\''\xc8\f'\''|json -b 2
\310\\f$
$ echo -ne '\''\xc8\n'\''|json -b 1
\310\\n$
$ echo -ne '\''\xc8\n'\''|json -b 2
\310\\n$
$ echo -ne '\''\xc8\r'\''|json -b 1
\310\\r$
$ echo -ne '\''\xc8\r'\''|json -b 2
\310\\r$
$ echo -ne '\''\xc8\t'\''|json -b 1
\310\\t$
$ echo -ne '\''\xc8\t'\''|json -b 2
\310\\t$
$ echo -ne '\''\xc9\b'\''|json -b 1
\311\\b$
$ echo -ne '\''\xc9\b'\''|json -b 2
\311\\b$
$ echo -ne '\''\xc9\f'\''|json -b 1
\311\\f$
$ echo -ne '\''\xc9\f'\''|json -b 2
\311\\f$
$ echo -ne '\''\xc9\n'\''|json -b 1
\311\\n$
$ echo -ne '\''\xc9\n'\''|json -b 2
\311\\n$
$ echo -ne '\''\xc9\r'\''|json -b 1
\311\\r$
$ echo -ne '\''\xc9\r'\''|json -b 2
\311\\r$
$ echo -ne '\''\xc9\t'\''|json -b 1
\311\\t$
$ echo -ne '\''\xc9\t'\''|json -b 2
\311\\t$
$ echo -ne '\''\xca\b'\''|json -b 1
\312\\b$
$ echo -ne '\''\xca\b'\''|json -b 2
\312\\b$
$ echo -ne '\''\xca\f'\''|json -b 1
\312\\f$
$ echo -ne '\''\xca\f'\''|json -b 2
\312\\f$
$ echo -ne '\''\xca\n'\''|json -b 1
\312\\n$
$ echo -ne '\''\xca\n'\''|json -b 2
\312\\n$
$ echo -ne '\''\xca\r'\''|json -b 1
\312\\r$
$ echo -ne '\''\xca\r'\''|json -b 2
\312\\r$
$ echo -ne '\''\xca\t'\''|json -b 1
\312\\t$
$ echo -ne '\''\xca\t'\''|json -b 2
\312\\t$
$ echo -ne '\''\xcb\b'\''|json -b 1
\313\\b$
$ echo -ne '\''\xcb\b'\''|json -b 2
\313\\b$
$ echo -ne '\''\xcb\f'\''|json -b 1
\313\\f$
$ echo -ne '\''\xcb\f'\''|json -b 2
\313\\f$
$ echo -ne '\''\xcb\n'\''|json -b 1
\313\\n$
$ echo -ne '\''\xcb\n'\''|json -b 2
\313\\n$
$ echo -ne '\''\xcb\r'\''|json -b 1
\313\\r$
$ echo -ne '\''\xcb\r'\''|json -b 2
\313\\r$
$ echo -ne '\''\xcb\t'\''|json -b 1
\313\\t$
$ echo -ne '\''\xcb\t'\''|json -b 2
\313\\t$
$ echo -ne '\''\xcc\b'\''|json -b 1
\314\\b$
$ echo -ne '\''\xcc\b'\''|json -b 2
\314\\b$
$ echo -ne '\''\xcc\f'\''|json -b 1
\314\\f$
$ echo -ne '\''\xcc\f'\''|json -b 2
\314\\f$
$ echo -ne '\''\xcc\n'\''|json -b 1
\314\\n$
$ echo -ne '\''\xcc\n'\''|json -b 2
\314\\n$
$ echo -ne '\''\xcc\r'\''|json -b 1
\314\\r$
$ echo -ne '\''\xcc\r'\''|json -b 2
\314\\r$
$ echo -ne '\''\xcc\t'\''|json -b 1
\314\\t$
$ echo -ne '\''\xcc\t'\''|json -b 2
\314\\t$
$ echo -ne '\''\xcd\b'\''|json -b 1
\315\\b$
$ echo -ne '\''\xcd\b'\''|json -b 2
\315\\b$
$ echo -ne '\''\xcd\f'\''|json -b 1
\315\\f$
$ echo -ne '\''\xcd\f'\''|json -b 2
\315\\f$
$ echo -ne '\''\xcd\n'\''|json -b 1
\315\\n$
$ echo -ne '\''\xcd\n'\''|json -b 2
\315\\n$
$ echo -ne '\''\xcd\r'\''|json -b 1
\315\\r$
$ echo -ne '\''\xcd\r'\''|json -b 2
\315\\r$
$ echo -ne '\''\xcd\t'\''|json -b 1
\315\\t$
$ echo -ne '\''\xcd\t'\''|json -b 2
\315\\t$
$ echo -ne '\''\xce\b'\''|json -b 1
\316\\b$
$ echo -ne '\''\xce\b'\''|json -b 2
\316\\b$
$ echo -ne '\''\xce\f'\''|json -b 1
\316\\f$
$ echo -ne '\''\xce\f'\''|json -b 2
\316\\f$
$ echo -ne '\''\xce\n'\''|json -b 1
\316\\n$
$ echo -ne '\''\xce\n'\''|json -b 2
\316\\n$
$ echo -ne '\''\xce\r'\''|json -b 1
\316\\r$
$ echo -ne '\''\xce\r'\''|json -b 2
\316\\r$
$ echo -ne '\''\xce\t'\''|json -b 1
\316\\t$
$ echo -ne '\''\xce\t'\''|json -b 2
\316\\t$
$ echo -ne '\''\xcf\b'\''|json -b 1
\317\\b$
$ echo -ne '\''\xcf\b'\''|json -b 2
\317\\b$
$ echo -ne '\''\xcf\f'\''|json -b 1
\317\\f$
$ echo -ne '\''\xcf\f'\''|json -b 2
\317\\f$
$ echo -ne '\''\xcf\n'\''|json -b 1
\317\\n$
$ echo -ne '\''\xcf\n'\''|json -b 2
\317\\n$
$ echo -ne '\''\xcf\r'\''|json -b 1
\317\\r$
$ echo -ne '\''\xcf\r'\''|json -b 2
\317\\r$
$ echo -ne '\''\xcf\t'\''|json -b 1
\317\\t$
$ echo -ne '\''\xcf\t'\''|json -b 2
\317\\t$
$ echo -ne '\''\xd0\b'\''|json -b 1
\320\\b$
$ echo -ne '\''\xd0\b'\''|json -b 2
\320\\b$
$ echo -ne '\''\xd0\f'\''|json -b 1
\320\\f$
$ echo -ne '\''\xd0\f'\''|json -b 2
\320\\f$
$ echo -ne '\''\xd0\n'\''|json -b 1
\320\\n$
$ echo -ne '\''\xd0\n'\''|json -b 2
\320\\n$
$ echo -ne '\''\xd0\r'\''|json -b 1
\320\\r$
$ echo -ne '\''\xd0\r'\''|json -b 2
\320\\r$
$ echo -ne '\''\xd0\t'\''|json -b 1
\320\\t$
$ echo -ne '\''\xd0\t'\''|json -b 2
\320\\t$
$ echo -ne '\''\xd1\b'\''|json -b 1
\321\\b$
$ echo -ne '\''\xd1\b'\''|json -b 2
\321\\b$
$ echo -ne '\''\xd1\f'\''|json -b 1
\321\\f$
$ echo -ne '\''\xd1\f'\''|json -b 2
\321\\f$
$ echo -ne '\''\xd1\n'\''|json -b 1
\321\\n$
$ echo -ne '\''\xd1\n'\''|json -b 2
\321\\n$
$ echo -ne '\''\xd1\r'\''|json -b 1
\321\\r$
$ echo -ne '\''\xd1\r'\''|json -b 2
\321\\r$
$ echo -ne '\''\xd1\t'\''|json -b 1
\321\\t$
$ echo -ne '\''\xd1\t'\''|json -b 2
\321\\t$
$ echo -ne '\''\xd2\b'\''|json -b 1
\322\\b$
$ echo -ne '\''\xd2\b'\''|json -b 2
\322\\b$
$ echo -ne '\''\xd2\f'\''|json -b 1
\322\\f$
$ echo -ne '\''\xd2\f'\''|json -b 2
\322\\f$
$ echo -ne '\''\xd2\n'\''|json -b 1
\322\\n$
$ echo -ne '\''\xd2\n'\''|json -b 2
\322\\n$
$ echo -ne '\''\xd2\r'\''|json -b 1
\322\\r$
$ echo -ne '\''\xd2\r'\''|json -b 2
\322\\r$
$ echo -ne '\''\xd2\t'\''|json -b 1
\322\\t$
$ echo -ne '\''\xd2\t'\''|json -b 2
\322\\t$
$ echo -ne '\''\xd3\b'\''|json -b 1
\323\\b$
$ echo -ne '\''\xd3\b'\''|json -b 2
\323\\b$
$ echo -ne '\''\xd3\f'\''|json -b 1
\323\\f$
$ echo -ne '\''\xd3\f'\''|json -b 2
\323\\f$
$ echo -ne '\''\xd3\n'\''|json -b 1
\323\\n$
$ echo -ne '\''\xd3\n'\''|json -b 2
\323\\n$
$ echo -ne '\''\xd3\r'\''|json -b 1
\323\\r$
$ echo -ne '\''\xd3\r'\''|json -b 2
\323\\r$
$ echo -ne '\''\xd3\t'\''|json -b 1
\323\\t$
$ echo -ne '\''\xd3\t'\''|json -b 2
\323\\t$
$ echo -ne '\''\xd4\b'\''|json -b 1
\324\\b$
$ echo -ne '\''\xd4\b'\''|json -b 2
\324\\b$
$ echo -ne '\''\xd4\f'\''|json -b 1
\324\\f$
$ echo -ne '\''\xd4\f'\''|json -b 2
\324\\f$
$ echo -ne '\''\xd4\n'\''|json -b 1
\324\\n$
$ echo -ne '\''\xd4\n'\''|json -b 2
\324\\n$
$ echo -ne '\''\xd4\r'\''|json -b 1
\324\\r$
$ echo -ne '\''\xd4\r'\''|json -b 2
\324\\r$
$ echo -ne '\''\xd4\t'\''|json -b 1
\324\\t$
$ echo -ne '\''\xd4\t'\''|json -b 2
\324\\t$
$ echo -ne '\''\xd5\b'\''|json -b 1
\325\\b$
$ echo -ne '\''\xd5\b'\''|json -b 2
\325\\b$
$ echo -ne '\''\xd5\f'\''|json -b 1
\325\\f$
$ echo -ne '\''\xd5\f'\''|json -b 2
\325\\f$
$ echo -ne '\''\xd5\n'\''|json -b 1
\325\\n$
$ echo -ne '\''\xd5\n'\''|json -b 2
\325\\n$
$ echo -ne '\''\xd5\r'\''|json -b 1
\325\\r$
$ echo -ne '\''\xd5\r'\''|json -b 2
\325\\r$
$ echo -ne '\''\xd5\t'\''|json -b 1
\325\\t$
$ echo -ne '\''\xd5\t'\''|json -b 2
\325\\t$
$ echo -ne '\''\xd6\b'\''|json -b 1
\326\\b$
$ echo -ne '\''\xd6\b'\''|json -b 2
\326\\b$
$ echo -ne '\''\xd6\f'\''|json -b 1
\326\\f$
$ echo -ne '\''\xd6\f'\''|json -b 2
\326\\f$
$ echo -ne '\''\xd6\n'\''|json -b 1
\326\\n$
$ echo -ne '\''\xd6\n'\''|json -b 2
\326\\n$
$ echo -ne '\''\xd6\r'\''|json -b 1
\326\\r$
$ echo -ne '\''\xd6\r'\''|json -b 2
\326\\r$
$ echo -ne '\''\xd6\t'\''|json -b 1
\326\\t$
$ echo -ne '\''\xd6\t'\''|json -b 2
\326\\t$
$ echo -ne '\''\xd7\b'\''|json -b 1
\327\\b$
$ echo -ne '\''\xd7\b'\''|json -b 2
\327\\b$
$ echo -ne '\''\xd7\f'\''|json -b 1
\327\\f$
$ echo -ne '\''\xd7\f'\''|json -b 2
\327\\f$
$ echo -ne '\''\xd7\n'\''|json -b 1
\327\\n$
$ echo -ne '\''\xd7\n'\''|json -b 2
\327\\n$
$ echo -ne '\''\xd7\r'\''|json -b 1
\327\\r$
$ echo -ne '\''\xd7\r'\''|json -b 2
\327\\r$
$ echo -ne '\''\xd7\t'\''|json -b 1
\327\\t$
$ echo -ne '\''\xd7\t'\''|json -b 2
\327\\t$
$ echo -ne '\''\xd8\b'\''|json -b 1
\330\\b$
$ echo -ne '\''\xd8\b'\''|json -b 2
\330\\b$
$ echo -ne '\''\xd8\f'\''|json -b 1
\330\\f$
$ echo -ne '\''\xd8\f'\''|json -b 2
\330\\f$
$ echo -ne '\''\xd8\n'\''|json -b 1
\330\\n$
$ echo -ne '\''\xd8\n'\''|json -b 2
\330\\n$
$ echo -ne '\''\xd8\r'\''|json -b 1
\330\\r$
$ echo -ne '\''\xd8\r'\''|json -b 2
\330\\r$
$ echo -ne '\''\xd8\t'\''|json -b 1
\330\\t$
$ echo -ne '\''\xd8\t'\''|json -b 2
\330\\t$
$ echo -ne '\''\xd9\b'\''|json -b 1
\331\\b$
$ echo -ne '\''\xd9\b'\''|json -b 2
\331\\b$
$ echo -ne '\''\xd9\f'\''|json -b 1
\331\\f$
$ echo -ne '\''\xd9\f'\''|json -b 2
\331\\f$
$ echo -ne '\''\xd9\n'\''|json -b 1
\331\\n$
$ echo -ne '\''\xd9\n'\''|json -b 2
\331\\n$
$ echo -ne '\''\xd9\r'\''|json -b 1
\331\\r$
$ echo -ne '\''\xd9\r'\''|json -b 2
\331\\r$
$ echo -ne '\''\xd9\t'\''|json -b 1
\331\\t$
$ echo -ne '\''\xd9\t'\''|json -b 2
\331\\t$
$ echo -ne '\''\xda\b'\''|json -b 1
\332\\b$
$ echo -ne '\''\xda\b'\''|json -b 2
\332\\b$
$ echo -ne '\''\xda\f'\''|json -b 1
\332\\f$
$ echo -ne '\''\xda\f'\''|json -b 2
\332\\f$
$ echo -ne '\''\xda\n'\''|json -b 1
\332\\n$
$ echo -ne '\''\xda\n'\''|json -b 2
\332\\n$
$ echo -ne '\''\xda\r'\''|json -b 1
\332\\r$
$ echo -ne '\''\xda\r'\''|json -b 2
\332\\r$
$ echo -ne '\''\xda\t'\''|json -b 1
\332\\t$
$ echo -ne '\''\xda\t'\''|json -b 2
\332\\t$
$ echo -ne '\''\xdb\b'\''|json -b 1
\333\\b$
$ echo -ne '\''\xdb\b'\''|json -b 2
\333\\b$
$ echo -ne '\''\xdb\f'\''|json -b 1
\333\\f$
$ echo -ne '\''\xdb\f'\''|json -b 2
\333\\f$
$ echo -ne '\''\xdb\n'\''|json -b 1
\333\\n$
$ echo -ne '\''\xdb\n'\''|json -b 2
\333\\n$
$ echo -ne '\''\xdb\r'\''|json -b 1
\333\\r$
$ echo -ne '\''\xdb\r'\''|json -b 2
\333\\r$
$ echo -ne '\''\xdb\t'\''|json -b 1
\333\\t$
$ echo -ne '\''\xdb\t'\''|json -b 2
\333\\t$
$ echo -ne '\''\xdc\b'\''|json -b 1
\334\\b$
$ echo -ne '\''\xdc\b'\''|json -b 2
\334\\b$
$ echo -ne '\''\xdc\f'\''|json -b 1
\334\\f$
$ echo -ne '\''\xdc\f'\''|json -b 2
\334\\f$
$ echo -ne '\''\xdc\n'\''|json -b 1
\334\\n$
$ echo -ne '\''\xdc\n'\''|json -b 2
\334\\n$
$ echo -ne '\''\xdc\r'\''|json -b 1
\334\\r$
$ echo -ne '\''\xdc\r'\''|json -b 2
\334\\r$
$ echo -ne '\''\xdc\t'\''|json -b 1
\334\\t$
$ echo -ne '\''\xdc\t'\''|json -b 2
\334\\t$
$ echo -ne '\''\xdd\b'\''|json -b 1
\335\\b$
$ echo -ne '\''\xdd\b'\''|json -b 2
\335\\b$
$ echo -ne '\''\xdd\f'\''|json -b 1
\335\\f$
$ echo -ne '\''\xdd\f'\''|json -b 2
\335\\f$
$ echo -ne '\''\xdd\n'\''|json -b 1
\335\\n$
$ echo -ne '\''\xdd\n'\''|json -b 2
\335\\n$
$ echo -ne '\''\xdd\r'\''|json -b 1
\335\\r$
$ echo -ne '\''\xdd\r'\''|json -b 2
\335\\r$
$ echo -ne '\''\xdd\t'\''|json -b 1
\335\\t$
$ echo -ne '\''\xdd\t'\''|json -b 2
\335\\t$
$ echo -ne '\''\xde\b'\''|json -b 1
\336\\b$
$ echo -ne '\''\xde\b'\''|json -b 2
\336\\b$
$ echo -ne '\''\xde\f'\''|json -b 1
\336\\f$
$ echo -ne '\''\xde\f'\''|json -b 2
\336\\f$
$ echo -ne '\''\xde\n'\''|json -b 1
\336\\n$
$ echo -ne '\''\xde\n'\''|json -b 2
\336\\n$
$ echo -ne '\''\xde\r'\''|json -b 1
\336\\r$
$ echo -ne '\''\xde\r'\''|json -b 2
\336\\r$
$ echo -ne '\''\xde\t'\''|json -b 1
\336\\t$
$ echo -ne '\''\xde\t'\''|json -b 2
\336\\t$
$ echo -ne '\''\xdf\b'\''|json -b 1
\337\\b$
$ echo -ne '\''\xdf\b'\''|json -b 2
\337\\b$
$ echo -ne '\''\xdf\f'\''|json -b 1
\337\\f$
$ echo -ne '\''\xdf\f'\''|json -b 2
\337\\f$
$ echo -ne '\''\xdf\n'\''|json -b 1
\337\\n$
$ echo -ne '\''\xdf\n'\''|json -b 2
\337\\n$
$ echo -ne '\''\xdf\r'\''|json -b 1
\337\\r$
$ echo -ne '\''\xdf\r'\''|json -b 2
\337\\r$
$ echo -ne '\''\xdf\t'\''|json -b 1
\337\\t$
$ echo -ne '\''\xdf\t'\''|json -b 2
\337\\t$
$ echo -ne '\''\xe0\xbf\b'\''|json -b 1
\340\277\\b$
$ echo -ne '\''\xe0\xbf\b'\''|json -b 3
\340\277\\b$
$ echo -ne '\''\xe0\xbf\f'\''|json -b 1
\340\277\\f$
$ echo -ne '\''\xe0\xbf\f'\''|json -b 3
\340\277\\f$
$ echo -ne '\''\xe0\xbf\n'\''|json -b 1
\340\277\\n$
$ echo -ne '\''\xe0\xbf\n'\''|json -b 3
\340\277\\n$
$ echo -ne '\''\xe0\xbf\r'\''|json -b 1
\340\277\\r$
$ echo -ne '\''\xe0\xbf\r'\''|json -b 3
\340\277\\r$
$ echo -ne '\''\xe0\xbf\t'\''|json -b 1
\340\277\\t$
$ echo -ne '\''\xe0\xbf\t'\''|json -b 3
\340\277\\t$
$ echo -ne '\''\xe1\xbf\b'\''|json -b 1
\341\277\\b$
$ echo -ne '\''\xe1\xbf\b'\''|json -b 3
\341\277\\b$
$ echo -ne '\''\xe1\xbf\f'\''|json -b 1
\341\277\\f$
$ echo -ne '\''\xe1\xbf\f'\''|json -b 3
\341\277\\f$
$ echo -ne '\''\xe1\xbf\n'\''|json -b 1
\341\277\\n$
$ echo -ne '\''\xe1\xbf\n'\''|json -b 3
\341\277\\n$
$ echo -ne '\''\xe1\xbf\r'\''|json -b 1
\341\277\\r$
$ echo -ne '\''\xe1\xbf\r'\''|json -b 3
\341\277\\r$
$ echo -ne '\''\xe1\xbf\t'\''|json -b 1
\341\277\\t$
$ echo -ne '\''\xe1\xbf\t'\''|json -b 3
\341\277\\t$
$ echo -ne '\''\xe2\xbf\b'\''|json -b 1
\342\277\\b$
$ echo -ne '\''\xe2\xbf\b'\''|json -b 3
\342\277\\b$
$ echo -ne '\''\xe2\xbf\f'\''|json -b 1
\342\277\\f$
$ echo -ne '\''\xe2\xbf\f'\''|json -b 3
\342\277\\f$
$ echo -ne '\''\xe2\xbf\n'\''|json -b 1
\342\277\\n$
$ echo -ne '\''\xe2\xbf\n'\''|json -b 3
\342\277\\n$
$ echo -ne '\''\xe2\xbf\r'\''|json -b 1
\342\277\\r$
$ echo -ne '\''\xe2\xbf\r'\''|json -b 3
\342\277\\r$
$ echo -ne '\''\xe2\xbf\t'\''|json -b 1
\342\277\\t$
$ echo -ne '\''\xe2\xbf\t'\''|json -b 3
\342\277\\t$
$ echo -ne '\''\xe3\xbf\b'\''|json -b 1
\343\277\\b$
$ echo -ne '\''\xe3\xbf\b'\''|json -b 3
\343\277\\b$
$ echo -ne '\''\xe3\xbf\f'\''|json -b 1
\343\277\\f$
$ echo -ne '\''\xe3\xbf\f'\''|json -b 3
\343\277\\f$
$ echo -ne '\''\xe3\xbf\n'\''|json -b 1
\343\277\\n$
$ echo -ne '\''\xe3\xbf\n'\''|json -b 3
\343\277\\n$
$ echo -ne '\''\xe3\xbf\r'\''|json -b 1
\343\277\\r$
$ echo -ne '\''\xe3\xbf\r'\''|json -b 3
\343\277\\r$
$ echo -ne '\''\xe3\xbf\t'\''|json -b 1
\343\277\\t$
$ echo -ne '\''\xe3\xbf\t'\''|json -b 3
\343\277\\t$
$ echo -ne '\''\xe4\xbf\b'\''|json -b 1
\344\277\\b$
$ echo -ne '\''\xe4\xbf\b'\''|json -b 3
\344\277\\b$
$ echo -ne '\''\xe4\xbf\f'\''|json -b 1
\344\277\\f$
$ echo -ne '\''\xe4\xbf\f'\''|json -b 3
\344\277\\f$
$ echo -ne '\''\xe4\xbf\n'\''|json -b 1
\344\277\\n$
$ echo -ne '\''\xe4\xbf\n'\''|json -b 3
\344\277\\n$
$ echo -ne '\''\xe4\xbf\r'\''|json -b 1
\344\277\\r$
$ echo -ne '\''\xe4\xbf\r'\''|json -b 3
\344\277\\r$
$ echo -ne '\''\xe4\xbf\t'\''|json -b 1
\344\277\\t$
$ echo -ne '\''\xe4\xbf\t'\''|json -b 3
\344\277\\t$
$ echo -ne '\''\xe5\xbf\b'\''|json -b 1
\345\277\\b$
$ echo -ne '\''\xe5\xbf\b'\''|json -b 3
\345\277\\b$
$ echo -ne '\''\xe5\xbf\f'\''|json -b 1
\345\277\\f$
$ echo -ne '\''\xe5\xbf\f'\''|json -b 3
\345\277\\f$
$ echo -ne '\''\xe5\xbf\n'\''|json -b 1
\345\277\\n$
$ echo -ne '\''\xe5\xbf\n'\''|json -b 3
\345\277\\n$
$ echo -ne '\''\xe5\xbf\r'\''|json -b 1
\345\277\\r$
$ echo -ne '\''\xe5\xbf\r'\''|json -b 3
\345\277\\r$
$ echo -ne '\''\xe5\xbf\t'\''|json -b 1
\345\277\\t$
$ echo -ne '\''\xe5\xbf\t'\''|json -b 3
\345\277\\t$
$ echo -ne '\''\xe6\xbf\b'\''|json -b 1
\346\277\\b$
$ echo -ne '\''\xe6\xbf\b'\''|json -b 3
\346\277\\b$
$ echo -ne '\''\xe6\xbf\f'\''|json -b 1
\346\277\\f$
$ echo -ne '\''\xe6\xbf\f'\''|json -b 3
\346\277\\f$
$ echo -ne '\''\xe6\xbf\n'\''|json -b 1
\346\277\\n$
$ echo -ne '\''\xe6\xbf\n'\''|json -b 3
\346\277\\n$
$ echo -ne '\''\xe6\xbf\r'\''|json -b 1
\346\277\\r$
$ echo -ne '\''\xe6\xbf\r'\''|json -b 3
\346\277\\r$
$ echo -ne '\''\xe6\xbf\t'\''|json -b 1
\346\277\\t$
$ echo -ne '\''\xe6\xbf\t'\''|json -b 3
\346\277\\t$
$ echo -ne '\''\xe7\xbf\b'\''|json -b 1
\347\277\\b$
$ echo -ne '\''\xe7\xbf\b'\''|json -b 3
\347\277\\b$
$ echo -ne '\''\xe7\xbf\f'\''|json -b 1
\347\277\\f$
$ echo -ne '\''\xe7\xbf\f'\''|json -b 3
\347\277\\f$
$ echo -ne '\''\xe7\xbf\n'\''|json -b 1
\347\277\\n$
$ echo -ne '\''\xe7\xbf\n'\''|json -b 3
\347\277\\n$
$ echo -ne '\''\xe7\xbf\r'\''|json -b 1
\347\277\\r$
$ echo -ne '\''\xe7\xbf\r'\''|json -b 3
\347\277\\r$
$ echo -ne '\''\xe7\xbf\t'\''|json -b 1
\347\277\\t$
$ echo -ne '\''\xe7\xbf\t'\''|json -b 3
\347\277\\t$
$ echo -ne '\''\xe8\xbf\b'\''|json -b 1
\350\277\\b$
$ echo -ne '\''\xe8\xbf\b'\''|json -b 3
\350\277\\b$
$ echo -ne '\''\xe8\xbf\f'\''|json -b 1
\350\277\\f$
$ echo -ne '\''\xe8\xbf\f'\''|json -b 3
\350\277\\f$
$ echo -ne '\''\xe8\xbf\n'\''|json -b 1
\350\277\\n$
$ echo -ne '\''\xe8\xbf\n'\''|json -b 3
\350\277\\n$
$ echo -ne '\''\xe8\xbf\r'\''|json -b 1
\350\277\\r$
$ echo -ne '\''\xe8\xbf\r'\''|json -b 3
\350\277\\r$
$ echo -ne '\''\xe8\xbf\t'\''|json -b 1
\350\277\\t$
$ echo -ne '\''\xe8\xbf\t'\''|json -b 3
\350\277\\t$
$ echo -ne '\''\xe9\xbf\b'\''|json -b 1
\351\277\\b$
$ echo -ne '\''\xe9\xbf\b'\''|json -b 3
\351\277\\b$
$ echo -ne '\''\xe9\xbf\f'\''|json -b 1
\351\277\\f$
$ echo -ne '\''\xe9\xbf\f'\''|json -b 3
\351\277\\f$
$ echo -ne '\''\xe9\xbf\n'\''|json -b 1
\351\277\\n$
$ echo -ne '\''\xe9\xbf\n'\''|json -b 3
\351\277\\n$
$ echo -ne '\''\xe9\xbf\r'\''|json -b 1
\351\277\\r$
$ echo -ne '\''\xe9\xbf\r'\''|json -b 3
\351\277\\r$
$ echo -ne '\''\xe9\xbf\t'\''|json -b 1
\351\277\\t$
$ echo -ne '\''\xe9\xbf\t'\''|json -b 3
\351\277\\t$
$ echo -ne '\''\xea\xbf\b'\''|json -b 1
\352\277\\b$
$ echo -ne '\''\xea\xbf\b'\''|json -b 3
\352\277\\b$
$ echo -ne '\''\xea\xbf\f'\''|json -b 1
\352\277\\f$
$ echo -ne '\''\xea\xbf\f'\''|json -b 3
\352\277\\f$
$ echo -ne '\''\xea\xbf\n'\''|json -b 1
\352\277\\n$
$ echo -ne '\''\xea\xbf\n'\''|json -b 3
\352\277\\n$
$ echo -ne '\''\xea\xbf\r'\''|json -b 1
\352\277\\r$
$ echo -ne '\''\xea\xbf\r'\''|json -b 3
\352\277\\r$
$ echo -ne '\''\xea\xbf\t'\''|json -b 1
\352\277\\t$
$ echo -ne '\''\xea\xbf\t'\''|json -b 3
\352\277\\t$
$ echo -ne '\''\xeb\xbf\b'\''|json -b 1
\353\277\\b$
$ echo -ne '\''\xeb\xbf\b'\''|json -b 3
\353\277\\b$
$ echo -ne '\''\xeb\xbf\f'\''|json -b 1
\353\277\\f$
$ echo -ne '\''\xeb\xbf\f'\''|json -b 3
\353\277\\f$
$ echo -ne '\''\xeb\xbf\n'\''|json -b 1
\353\277\\n$
$ echo -ne '\''\xeb\xbf\n'\''|json -b 3
\353\277\\n$
$ echo -ne '\''\xeb\xbf\r'\''|json -b 1
\353\277\\r$
$ echo -ne '\''\xeb\xbf\r'\''|json -b 3
\353\277\\r$
$ echo -ne '\''\xeb\xbf\t'\''|json -b 1
\353\277\\t$
$ echo -ne '\''\xeb\xbf\t'\''|json -b 3
\353\277\\t$
$ echo -ne '\''\xec\xbf\b'\''|json -b 1
\354\277\\b$
$ echo -ne '\''\xec\xbf\b'\''|json -b 3
\354\277\\b$
$ echo -ne '\''\xec\xbf\f'\''|json -b 1
\354\277\\f$
$ echo -ne '\''\xec\xbf\f'\''|json -b 3
\354\277\\f$
$ echo -ne '\''\xec\xbf\n'\''|json -b 1
\354\277\\n$
$ echo -ne '\''\xec\xbf\n'\''|json -b 3
\354\277\\n$
$ echo -ne '\''\xec\xbf\r'\''|json -b 1
\354\277\\r$
$ echo -ne '\''\xec\xbf\r'\''|json -b 3
\354\277\\r$
$ echo -ne '\''\xec\xbf\t'\''|json -b 1
\354\277\\t$
$ echo -ne '\''\xec\xbf\t'\''|json -b 3
\354\277\\t$
$ echo -ne '\''\xed\xbf\b'\''|json -b 1
\355\277\\b$
$ echo -ne '\''\xed\xbf\b'\''|json -b 3
\355\277\\b$
$ echo -ne '\''\xed\xbf\f'\''|json -b 1
\355\277\\f$
$ echo -ne '\''\xed\xbf\f'\''|json -b 3
\355\277\\f$
$ echo -ne '\''\xed\xbf\n'\''|json -b 1
\355\277\\n$
$ echo -ne '\''\xed\xbf\n'\''|json -b 3
\355\277\\n$
$ echo -ne '\''\xed\xbf\r'\''|json -b 1
\355\277\\r$
$ echo -ne '\''\xed\xbf\r'\''|json -b 3
\355\277\\r$
$ echo -ne '\''\xed\xbf\t'\''|json -b 1
\355\277\\t$
$ echo -ne '\''\xed\xbf\t'\''|json -b 3
\355\277\\t$
$ echo -ne '\''\xee\xbf\b'\''|json -b 1
\356\277\\b$
$ echo -ne '\''\xee\xbf\b'\''|json -b 3
\356\277\\b$
$ echo -ne '\''\xee\xbf\f'\''|json -b 1
\356\277\\f$
$ echo -ne '\''\xee\xbf\f'\''|json -b 3
\356\277\\f$
$ echo -ne '\''\xee\xbf\n'\''|json -b 1
\356\277\\n$
$ echo -ne '\''\xee\xbf\n'\''|json -b 3
\356\277\\n$
$ echo -ne '\''\xee\xbf\r'\''|json -b 1
\356\277\\r$
$ echo -ne '\''\xee\xbf\r'\''|json -b 3
\356\277\\r$
$ echo -ne '\''\xee\xbf\t'\''|json -b 1
\356\277\\t$
$ echo -ne '\''\xee\xbf\t'\''|json -b 3
\356\277\\t$
$ echo -ne '\''\xef\xbf\b'\''|json -b 1
\357\277\\b$
$ echo -ne '\''\xef\xbf\b'\''|json -b 3
\357\277\\b$
$ echo -ne '\''\xef\xbf\f'\''|json -b 1
\357\277\\f$
$ echo -ne '\''\xef\xbf\f'\''|json -b 3
\357\277\\f$
$ echo -ne '\''\xef\xbf\n'\''|json -b 1
\357\277\\n$
$ echo -ne '\''\xef\xbf\n'\''|json -b 3
\357\277\\n$
$ echo -ne '\''\xef\xbf\r'\''|json -b 1
\357\277\\r$
$ echo -ne '\''\xef\xbf\r'\''|json -b 3
\357\277\\r$
$ echo -ne '\''\xef\xbf\t'\''|json -b 1
\357\277\\t$
$ echo -ne '\''\xef\xbf\t'\''|json -b 3
\357\277\\t$
$ echo -ne '\''\xf0\xbf\xbf\b'\''|json -b 1
\360\277\277\\b$
$ echo -ne '\''\xf0\xbf\xbf\b'\''|json -b 4
\360\277\277\\b$
$ echo -ne '\''\xf0\xbf\xbf\f'\''|json -b 1
\360\277\277\\f$
$ echo -ne '\''\xf0\xbf\xbf\f'\''|json -b 4
\360\277\277\\f$
$ echo -ne '\''\xf0\xbf\xbf\n'\''|json -b 1
\360\277\277\\n$
$ echo -ne '\''\xf0\xbf\xbf\n'\''|json -b 4
\360\277\277\\n$
$ echo -ne '\''\xf0\xbf\xbf\r'\''|json -b 1
\360\277\277\\r$
$ echo -ne '\''\xf0\xbf\xbf\r'\''|json -b 4
\360\277\277\\r$
$ echo -ne '\''\xf0\xbf\xbf\t'\''|json -b 1
\360\277\277\\t$
$ echo -ne '\''\xf0\xbf\xbf\t'\''|json -b 4
\360\277\277\\t$
$ echo -ne '\''\xf1\xbf\xbf\b'\''|json -b 1
\361\277\277\\b$
$ echo -ne '\''\xf1\xbf\xbf\b'\''|json -b 4
\361\277\277\\b$
$ echo -ne '\''\xf1\xbf\xbf\f'\''|json -b 1
\361\277\277\\f$
$ echo -ne '\''\xf1\xbf\xbf\f'\''|json -b 4
\361\277\277\\f$
$ echo -ne '\''\xf1\xbf\xbf\n'\''|json -b 1
\361\277\277\\n$
$ echo -ne '\''\xf1\xbf\xbf\n'\''|json -b 4
\361\277\277\\n$
$ echo -ne '\''\xf1\xbf\xbf\r'\''|json -b 1
\361\277\277\\r$
$ echo -ne '\''\xf1\xbf\xbf\r'\''|json -b 4
\361\277\277\\r$
$ echo -ne '\''\xf1\xbf\xbf\t'\''|json -b 1
\361\277\277\\t$
$ echo -ne '\''\xf1\xbf\xbf\t'\''|json -b 4
\361\277\277\\t$
$ echo -ne '\''\xf2\xbf\xbf\b'\''|json -b 1
\362\277\277\\b$
$ echo -ne '\''\xf2\xbf\xbf\b'\''|json -b 4
\362\277\277\\b$
$ echo -ne '\''\xf2\xbf\xbf\f'\''|json -b 1
\362\277\277\\f$
$ echo -ne '\''\xf2\xbf\xbf\f'\''|json -b 4
\362\277\277\\f$
$ echo -ne '\''\xf2\xbf\xbf\n'\''|json -b 1
\362\277\277\\n$
$ echo -ne '\''\xf2\xbf\xbf\n'\''|json -b 4
\362\277\277\\n$
$ echo -ne '\''\xf2\xbf\xbf\r'\''|json -b 1
\362\277\277\\r$
$ echo -ne '\''\xf2\xbf\xbf\r'\''|json -b 4
\362\277\277\\r$
$ echo -ne '\''\xf2\xbf\xbf\t'\''|json -b 1
\362\277\277\\t$
$ echo -ne '\''\xf2\xbf\xbf\t'\''|json -b 4
\362\277\277\\t$
$ echo -ne '\''\xf3\xbf\xbf\b'\''|json -b 1
\363\277\277\\b$
$ echo -ne '\''\xf3\xbf\xbf\b'\''|json -b 4
\363\277\277\\b$
$ echo -ne '\''\xf3\xbf\xbf\f'\''|json -b 1
\363\277\277\\f$
$ echo -ne '\''\xf3\xbf\xbf\f'\''|json -b 4
\363\277\277\\f$
$ echo -ne '\''\xf3\xbf\xbf\n'\''|json -b 1
\363\277\277\\n$
$ echo -ne '\''\xf3\xbf\xbf\n'\''|json -b 4
\363\277\277\\n$
$ echo -ne '\''\xf3\xbf\xbf\r'\''|json -b 1
\363\277\277\\r$
$ echo -ne '\''\xf3\xbf\xbf\r'\''|json -b 4
\363\277\277\\r$
$ echo -ne '\''\xf3\xbf\xbf\t'\''|json -b 1
\363\277\277\\t$
$ echo -ne '\''\xf3\xbf\xbf\t'\''|json -b 4
\363\277\277\\t$
$ echo -ne '\''\xf4\xbf\xbf\b'\''|json -b 1
\364\277\277\\b$
$ echo -ne '\''\xf4\xbf\xbf\b'\''|json -b 4
\364\277\277\\b$
$ echo -ne '\''\xf4\xbf\xbf\f'\''|json -b 1
\364\277\277\\f$
$ echo -ne '\''\xf4\xbf\xbf\f'\''|json -b 4
\364\277\277\\f$
$ echo -ne '\''\xf4\xbf\xbf\n'\''|json -b 1
\364\277\277\\n$
$ echo -ne '\''\xf4\xbf\xbf\n'\''|json -b 4
\364\277\277\\n$
$ echo -ne '\''\xf4\xbf\xbf\r'\''|json -b 1
\364\277\277\\r$
$ echo -ne '\''\xf4\xbf\xbf\r'\''|json -b 4
\364\277\277\\r$
$ echo -ne '\''\xf4\xbf\xbf\t'\''|json -b 1
\364\277\277\\t$
$ echo -ne '\''\xf4\xbf\xbf\t'\''|json -b 4
\364\277\277\\t$'
) -L non-ascii4.new <(
echo '$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --no-validate-utf8 --escape-json --verbose "$@"|sed -n l; }'
json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --no-validate-utf8 --escape-json --verbose "$@"|sed -n l; } 2>&1 ||
echo 'command failed: json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --no-validate-utf8 --escape-json --verbose "$@"|sed -n l; }'

echo '$ echo -ne '\''\xc2\b'\''|json -b 1'
echo -ne '\xc2\b'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xc2\b'\''|json -b 1'

echo '$ echo -ne '\''\xc2\b'\''|json -b 2'
echo -ne '\xc2\b'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xc2\b'\''|json -b 2'

echo '$ echo -ne '\''\xc2\f'\''|json -b 1'
echo -ne '\xc2\f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xc2\f'\''|json -b 1'

echo '$ echo -ne '\''\xc2\f'\''|json -b 2'
echo -ne '\xc2\f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xc2\f'\''|json -b 2'

echo '$ echo -ne '\''\xc2\n'\''|json -b 1'
echo -ne '\xc2\n'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xc2\n'\''|json -b 1'

echo '$ echo -ne '\''\xc2\n'\''|json -b 2'
echo -ne '\xc2\n'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xc2\n'\''|json -b 2'

echo '$ echo -ne '\''\xc2\r'\''|json -b 1'
echo -ne '\xc2\r'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xc2\r'\''|json -b 1'

echo '$ echo -ne '\''\xc2\r'\''|json -b 2'
echo -ne '\xc2\r'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xc2\r'\''|json -b 2'

echo '$ echo -ne '\''\xc2\t'\''|json -b 1'
echo -ne '\xc2\t'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xc2\t'\''|json -b 1'

echo '$ echo -ne '\''\xc2\t'\''|json -b 2'
echo -ne '\xc2\t'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xc2\t'\''|json -b 2'

echo '$ echo -ne '\''\xc3\b'\''|json -b 1'
echo -ne '\xc3\b'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xc3\b'\''|json -b 1'

echo '$ echo -ne '\''\xc3\b'\''|json -b 2'
echo -ne '\xc3\b'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xc3\b'\''|json -b 2'

echo '$ echo -ne '\''\xc3\f'\''|json -b 1'
echo -ne '\xc3\f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xc3\f'\''|json -b 1'

echo '$ echo -ne '\''\xc3\f'\''|json -b 2'
echo -ne '\xc3\f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xc3\f'\''|json -b 2'

echo '$ echo -ne '\''\xc3\n'\''|json -b 1'
echo -ne '\xc3\n'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xc3\n'\''|json -b 1'

echo '$ echo -ne '\''\xc3\n'\''|json -b 2'
echo -ne '\xc3\n'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xc3\n'\''|json -b 2'

echo '$ echo -ne '\''\xc3\r'\''|json -b 1'
echo -ne '\xc3\r'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xc3\r'\''|json -b 1'

echo '$ echo -ne '\''\xc3\r'\''|json -b 2'
echo -ne '\xc3\r'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xc3\r'\''|json -b 2'

echo '$ echo -ne '\''\xc3\t'\''|json -b 1'
echo -ne '\xc3\t'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xc3\t'\''|json -b 1'

echo '$ echo -ne '\''\xc3\t'\''|json -b 2'
echo -ne '\xc3\t'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xc3\t'\''|json -b 2'

echo '$ echo -ne '\''\xc4\b'\''|json -b 1'
echo -ne '\xc4\b'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xc4\b'\''|json -b 1'

echo '$ echo -ne '\''\xc4\b'\''|json -b 2'
echo -ne '\xc4\b'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xc4\b'\''|json -b 2'

echo '$ echo -ne '\''\xc4\f'\''|json -b 1'
echo -ne '\xc4\f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xc4\f'\''|json -b 1'

echo '$ echo -ne '\''\xc4\f'\''|json -b 2'
echo -ne '\xc4\f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xc4\f'\''|json -b 2'

echo '$ echo -ne '\''\xc4\n'\''|json -b 1'
echo -ne '\xc4\n'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xc4\n'\''|json -b 1'

echo '$ echo -ne '\''\xc4\n'\''|json -b 2'
echo -ne '\xc4\n'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xc4\n'\''|json -b 2'

echo '$ echo -ne '\''\xc4\r'\''|json -b 1'
echo -ne '\xc4\r'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xc4\r'\''|json -b 1'

echo '$ echo -ne '\''\xc4\r'\''|json -b 2'
echo -ne '\xc4\r'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xc4\r'\''|json -b 2'

echo '$ echo -ne '\''\xc4\t'\''|json -b 1'
echo -ne '\xc4\t'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xc4\t'\''|json -b 1'

echo '$ echo -ne '\''\xc4\t'\''|json -b 2'
echo -ne '\xc4\t'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xc4\t'\''|json -b 2'

echo '$ echo -ne '\''\xc5\b'\''|json -b 1'
echo -ne '\xc5\b'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xc5\b'\''|json -b 1'

echo '$ echo -ne '\''\xc5\b'\''|json -b 2'
echo -ne '\xc5\b'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xc5\b'\''|json -b 2'

echo '$ echo -ne '\''\xc5\f'\''|json -b 1'
echo -ne '\xc5\f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xc5\f'\''|json -b 1'

echo '$ echo -ne '\''\xc5\f'\''|json -b 2'
echo -ne '\xc5\f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xc5\f'\''|json -b 2'

echo '$ echo -ne '\''\xc5\n'\''|json -b 1'
echo -ne '\xc5\n'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xc5\n'\''|json -b 1'

echo '$ echo -ne '\''\xc5\n'\''|json -b 2'
echo -ne '\xc5\n'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xc5\n'\''|json -b 2'

echo '$ echo -ne '\''\xc5\r'\''|json -b 1'
echo -ne '\xc5\r'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xc5\r'\''|json -b 1'

echo '$ echo -ne '\''\xc5\r'\''|json -b 2'
echo -ne '\xc5\r'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xc5\r'\''|json -b 2'

echo '$ echo -ne '\''\xc5\t'\''|json -b 1'
echo -ne '\xc5\t'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xc5\t'\''|json -b 1'

echo '$ echo -ne '\''\xc5\t'\''|json -b 2'
echo -ne '\xc5\t'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xc5\t'\''|json -b 2'

echo '$ echo -ne '\''\xc6\b'\''|json -b 1'
echo -ne '\xc6\b'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xc6\b'\''|json -b 1'

echo '$ echo -ne '\''\xc6\b'\''|json -b 2'
echo -ne '\xc6\b'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xc6\b'\''|json -b 2'

echo '$ echo -ne '\''\xc6\f'\''|json -b 1'
echo -ne '\xc6\f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xc6\f'\''|json -b 1'

echo '$ echo -ne '\''\xc6\f'\''|json -b 2'
echo -ne '\xc6\f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xc6\f'\''|json -b 2'

echo '$ echo -ne '\''\xc6\n'\''|json -b 1'
echo -ne '\xc6\n'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xc6\n'\''|json -b 1'

echo '$ echo -ne '\''\xc6\n'\''|json -b 2'
echo -ne '\xc6\n'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xc6\n'\''|json -b 2'

echo '$ echo -ne '\''\xc6\r'\''|json -b 1'
echo -ne '\xc6\r'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xc6\r'\''|json -b 1'

echo '$ echo -ne '\''\xc6\r'\''|json -b 2'
echo -ne '\xc6\r'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xc6\r'\''|json -b 2'

echo '$ echo -ne '\''\xc6\t'\''|json -b 1'
echo -ne '\xc6\t'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xc6\t'\''|json -b 1'

echo '$ echo -ne '\''\xc6\t'\''|json -b 2'
echo -ne '\xc6\t'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xc6\t'\''|json -b 2'

echo '$ echo -ne '\''\xc7\b'\''|json -b 1'
echo -ne '\xc7\b'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xc7\b'\''|json -b 1'

echo '$ echo -ne '\''\xc7\b'\''|json -b 2'
echo -ne '\xc7\b'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xc7\b'\''|json -b 2'

echo '$ echo -ne '\''\xc7\f'\''|json -b 1'
echo -ne '\xc7\f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xc7\f'\''|json -b 1'

echo '$ echo -ne '\''\xc7\f'\''|json -b 2'
echo -ne '\xc7\f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xc7\f'\''|json -b 2'

echo '$ echo -ne '\''\xc7\n'\''|json -b 1'
echo -ne '\xc7\n'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xc7\n'\''|json -b 1'

echo '$ echo -ne '\''\xc7\n'\''|json -b 2'
echo -ne '\xc7\n'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xc7\n'\''|json -b 2'

echo '$ echo -ne '\''\xc7\r'\''|json -b 1'
echo -ne '\xc7\r'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xc7\r'\''|json -b 1'

echo '$ echo -ne '\''\xc7\r'\''|json -b 2'
echo -ne '\xc7\r'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xc7\r'\''|json -b 2'

echo '$ echo -ne '\''\xc7\t'\''|json -b 1'
echo -ne '\xc7\t'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xc7\t'\''|json -b 1'

echo '$ echo -ne '\''\xc7\t'\''|json -b 2'
echo -ne '\xc7\t'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xc7\t'\''|json -b 2'

echo '$ echo -ne '\''\xc8\b'\''|json -b 1'
echo -ne '\xc8\b'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xc8\b'\''|json -b 1'

echo '$ echo -ne '\''\xc8\b'\''|json -b 2'
echo -ne '\xc8\b'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xc8\b'\''|json -b 2'

echo '$ echo -ne '\''\xc8\f'\''|json -b 1'
echo -ne '\xc8\f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xc8\f'\''|json -b 1'

echo '$ echo -ne '\''\xc8\f'\''|json -b 2'
echo -ne '\xc8\f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xc8\f'\''|json -b 2'

echo '$ echo -ne '\''\xc8\n'\''|json -b 1'
echo -ne '\xc8\n'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xc8\n'\''|json -b 1'

echo '$ echo -ne '\''\xc8\n'\''|json -b 2'
echo -ne '\xc8\n'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xc8\n'\''|json -b 2'

echo '$ echo -ne '\''\xc8\r'\''|json -b 1'
echo -ne '\xc8\r'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xc8\r'\''|json -b 1'

echo '$ echo -ne '\''\xc8\r'\''|json -b 2'
echo -ne '\xc8\r'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xc8\r'\''|json -b 2'

echo '$ echo -ne '\''\xc8\t'\''|json -b 1'
echo -ne '\xc8\t'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xc8\t'\''|json -b 1'

echo '$ echo -ne '\''\xc8\t'\''|json -b 2'
echo -ne '\xc8\t'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xc8\t'\''|json -b 2'

echo '$ echo -ne '\''\xc9\b'\''|json -b 1'
echo -ne '\xc9\b'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xc9\b'\''|json -b 1'

echo '$ echo -ne '\''\xc9\b'\''|json -b 2'
echo -ne '\xc9\b'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xc9\b'\''|json -b 2'

echo '$ echo -ne '\''\xc9\f'\''|json -b 1'
echo -ne '\xc9\f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xc9\f'\''|json -b 1'

echo '$ echo -ne '\''\xc9\f'\''|json -b 2'
echo -ne '\xc9\f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xc9\f'\''|json -b 2'

echo '$ echo -ne '\''\xc9\n'\''|json -b 1'
echo -ne '\xc9\n'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xc9\n'\''|json -b 1'

echo '$ echo -ne '\''\xc9\n'\''|json -b 2'
echo -ne '\xc9\n'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xc9\n'\''|json -b 2'

echo '$ echo -ne '\''\xc9\r'\''|json -b 1'
echo -ne '\xc9\r'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xc9\r'\''|json -b 1'

echo '$ echo -ne '\''\xc9\r'\''|json -b 2'
echo -ne '\xc9\r'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xc9\r'\''|json -b 2'

echo '$ echo -ne '\''\xc9\t'\''|json -b 1'
echo -ne '\xc9\t'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xc9\t'\''|json -b 1'

echo '$ echo -ne '\''\xc9\t'\''|json -b 2'
echo -ne '\xc9\t'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xc9\t'\''|json -b 2'

echo '$ echo -ne '\''\xca\b'\''|json -b 1'
echo -ne '\xca\b'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xca\b'\''|json -b 1'

echo '$ echo -ne '\''\xca\b'\''|json -b 2'
echo -ne '\xca\b'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xca\b'\''|json -b 2'

echo '$ echo -ne '\''\xca\f'\''|json -b 1'
echo -ne '\xca\f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xca\f'\''|json -b 1'

echo '$ echo -ne '\''\xca\f'\''|json -b 2'
echo -ne '\xca\f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xca\f'\''|json -b 2'

echo '$ echo -ne '\''\xca\n'\''|json -b 1'
echo -ne '\xca\n'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xca\n'\''|json -b 1'

echo '$ echo -ne '\''\xca\n'\''|json -b 2'
echo -ne '\xca\n'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xca\n'\''|json -b 2'

echo '$ echo -ne '\''\xca\r'\''|json -b 1'
echo -ne '\xca\r'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xca\r'\''|json -b 1'

echo '$ echo -ne '\''\xca\r'\''|json -b 2'
echo -ne '\xca\r'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xca\r'\''|json -b 2'

echo '$ echo -ne '\''\xca\t'\''|json -b 1'
echo -ne '\xca\t'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xca\t'\''|json -b 1'

echo '$ echo -ne '\''\xca\t'\''|json -b 2'
echo -ne '\xca\t'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xca\t'\''|json -b 2'

echo '$ echo -ne '\''\xcb\b'\''|json -b 1'
echo -ne '\xcb\b'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xcb\b'\''|json -b 1'

echo '$ echo -ne '\''\xcb\b'\''|json -b 2'
echo -ne '\xcb\b'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xcb\b'\''|json -b 2'

echo '$ echo -ne '\''\xcb\f'\''|json -b 1'
echo -ne '\xcb\f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xcb\f'\''|json -b 1'

echo '$ echo -ne '\''\xcb\f'\''|json -b 2'
echo -ne '\xcb\f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xcb\f'\''|json -b 2'

echo '$ echo -ne '\''\xcb\n'\''|json -b 1'
echo -ne '\xcb\n'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xcb\n'\''|json -b 1'

echo '$ echo -ne '\''\xcb\n'\''|json -b 2'
echo -ne '\xcb\n'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xcb\n'\''|json -b 2'

echo '$ echo -ne '\''\xcb\r'\''|json -b 1'
echo -ne '\xcb\r'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xcb\r'\''|json -b 1'

echo '$ echo -ne '\''\xcb\r'\''|json -b 2'
echo -ne '\xcb\r'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xcb\r'\''|json -b 2'

echo '$ echo -ne '\''\xcb\t'\''|json -b 1'
echo -ne '\xcb\t'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xcb\t'\''|json -b 1'

echo '$ echo -ne '\''\xcb\t'\''|json -b 2'
echo -ne '\xcb\t'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xcb\t'\''|json -b 2'

echo '$ echo -ne '\''\xcc\b'\''|json -b 1'
echo -ne '\xcc\b'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xcc\b'\''|json -b 1'

echo '$ echo -ne '\''\xcc\b'\''|json -b 2'
echo -ne '\xcc\b'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xcc\b'\''|json -b 2'

echo '$ echo -ne '\''\xcc\f'\''|json -b 1'
echo -ne '\xcc\f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xcc\f'\''|json -b 1'

echo '$ echo -ne '\''\xcc\f'\''|json -b 2'
echo -ne '\xcc\f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xcc\f'\''|json -b 2'

echo '$ echo -ne '\''\xcc\n'\''|json -b 1'
echo -ne '\xcc\n'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xcc\n'\''|json -b 1'

echo '$ echo -ne '\''\xcc\n'\''|json -b 2'
echo -ne '\xcc\n'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xcc\n'\''|json -b 2'

echo '$ echo -ne '\''\xcc\r'\''|json -b 1'
echo -ne '\xcc\r'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xcc\r'\''|json -b 1'

echo '$ echo -ne '\''\xcc\r'\''|json -b 2'
echo -ne '\xcc\r'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xcc\r'\''|json -b 2'

echo '$ echo -ne '\''\xcc\t'\''|json -b 1'
echo -ne '\xcc\t'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xcc\t'\''|json -b 1'

echo '$ echo -ne '\''\xcc\t'\''|json -b 2'
echo -ne '\xcc\t'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xcc\t'\''|json -b 2'

echo '$ echo -ne '\''\xcd\b'\''|json -b 1'
echo -ne '\xcd\b'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xcd\b'\''|json -b 1'

echo '$ echo -ne '\''\xcd\b'\''|json -b 2'
echo -ne '\xcd\b'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xcd\b'\''|json -b 2'

echo '$ echo -ne '\''\xcd\f'\''|json -b 1'
echo -ne '\xcd\f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xcd\f'\''|json -b 1'

echo '$ echo -ne '\''\xcd\f'\''|json -b 2'
echo -ne '\xcd\f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xcd\f'\''|json -b 2'

echo '$ echo -ne '\''\xcd\n'\''|json -b 1'
echo -ne '\xcd\n'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xcd\n'\''|json -b 1'

echo '$ echo -ne '\''\xcd\n'\''|json -b 2'
echo -ne '\xcd\n'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xcd\n'\''|json -b 2'

echo '$ echo -ne '\''\xcd\r'\''|json -b 1'
echo -ne '\xcd\r'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xcd\r'\''|json -b 1'

echo '$ echo -ne '\''\xcd\r'\''|json -b 2'
echo -ne '\xcd\r'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xcd\r'\''|json -b 2'

echo '$ echo -ne '\''\xcd\t'\''|json -b 1'
echo -ne '\xcd\t'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xcd\t'\''|json -b 1'

echo '$ echo -ne '\''\xcd\t'\''|json -b 2'
echo -ne '\xcd\t'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xcd\t'\''|json -b 2'

echo '$ echo -ne '\''\xce\b'\''|json -b 1'
echo -ne '\xce\b'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xce\b'\''|json -b 1'

echo '$ echo -ne '\''\xce\b'\''|json -b 2'
echo -ne '\xce\b'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xce\b'\''|json -b 2'

echo '$ echo -ne '\''\xce\f'\''|json -b 1'
echo -ne '\xce\f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xce\f'\''|json -b 1'

echo '$ echo -ne '\''\xce\f'\''|json -b 2'
echo -ne '\xce\f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xce\f'\''|json -b 2'

echo '$ echo -ne '\''\xce\n'\''|json -b 1'
echo -ne '\xce\n'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xce\n'\''|json -b 1'

echo '$ echo -ne '\''\xce\n'\''|json -b 2'
echo -ne '\xce\n'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xce\n'\''|json -b 2'

echo '$ echo -ne '\''\xce\r'\''|json -b 1'
echo -ne '\xce\r'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xce\r'\''|json -b 1'

echo '$ echo -ne '\''\xce\r'\''|json -b 2'
echo -ne '\xce\r'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xce\r'\''|json -b 2'

echo '$ echo -ne '\''\xce\t'\''|json -b 1'
echo -ne '\xce\t'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xce\t'\''|json -b 1'

echo '$ echo -ne '\''\xce\t'\''|json -b 2'
echo -ne '\xce\t'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xce\t'\''|json -b 2'

echo '$ echo -ne '\''\xcf\b'\''|json -b 1'
echo -ne '\xcf\b'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xcf\b'\''|json -b 1'

echo '$ echo -ne '\''\xcf\b'\''|json -b 2'
echo -ne '\xcf\b'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xcf\b'\''|json -b 2'

echo '$ echo -ne '\''\xcf\f'\''|json -b 1'
echo -ne '\xcf\f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xcf\f'\''|json -b 1'

echo '$ echo -ne '\''\xcf\f'\''|json -b 2'
echo -ne '\xcf\f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xcf\f'\''|json -b 2'

echo '$ echo -ne '\''\xcf\n'\''|json -b 1'
echo -ne '\xcf\n'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xcf\n'\''|json -b 1'

echo '$ echo -ne '\''\xcf\n'\''|json -b 2'
echo -ne '\xcf\n'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xcf\n'\''|json -b 2'

echo '$ echo -ne '\''\xcf\r'\''|json -b 1'
echo -ne '\xcf\r'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xcf\r'\''|json -b 1'

echo '$ echo -ne '\''\xcf\r'\''|json -b 2'
echo -ne '\xcf\r'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xcf\r'\''|json -b 2'

echo '$ echo -ne '\''\xcf\t'\''|json -b 1'
echo -ne '\xcf\t'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xcf\t'\''|json -b 1'

echo '$ echo -ne '\''\xcf\t'\''|json -b 2'
echo -ne '\xcf\t'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xcf\t'\''|json -b 2'

echo '$ echo -ne '\''\xd0\b'\''|json -b 1'
echo -ne '\xd0\b'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xd0\b'\''|json -b 1'

echo '$ echo -ne '\''\xd0\b'\''|json -b 2'
echo -ne '\xd0\b'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xd0\b'\''|json -b 2'

echo '$ echo -ne '\''\xd0\f'\''|json -b 1'
echo -ne '\xd0\f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xd0\f'\''|json -b 1'

echo '$ echo -ne '\''\xd0\f'\''|json -b 2'
echo -ne '\xd0\f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xd0\f'\''|json -b 2'

echo '$ echo -ne '\''\xd0\n'\''|json -b 1'
echo -ne '\xd0\n'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xd0\n'\''|json -b 1'

echo '$ echo -ne '\''\xd0\n'\''|json -b 2'
echo -ne '\xd0\n'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xd0\n'\''|json -b 2'

echo '$ echo -ne '\''\xd0\r'\''|json -b 1'
echo -ne '\xd0\r'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xd0\r'\''|json -b 1'

echo '$ echo -ne '\''\xd0\r'\''|json -b 2'
echo -ne '\xd0\r'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xd0\r'\''|json -b 2'

echo '$ echo -ne '\''\xd0\t'\''|json -b 1'
echo -ne '\xd0\t'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xd0\t'\''|json -b 1'

echo '$ echo -ne '\''\xd0\t'\''|json -b 2'
echo -ne '\xd0\t'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xd0\t'\''|json -b 2'

echo '$ echo -ne '\''\xd1\b'\''|json -b 1'
echo -ne '\xd1\b'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xd1\b'\''|json -b 1'

echo '$ echo -ne '\''\xd1\b'\''|json -b 2'
echo -ne '\xd1\b'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xd1\b'\''|json -b 2'

echo '$ echo -ne '\''\xd1\f'\''|json -b 1'
echo -ne '\xd1\f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xd1\f'\''|json -b 1'

echo '$ echo -ne '\''\xd1\f'\''|json -b 2'
echo -ne '\xd1\f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xd1\f'\''|json -b 2'

echo '$ echo -ne '\''\xd1\n'\''|json -b 1'
echo -ne '\xd1\n'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xd1\n'\''|json -b 1'

echo '$ echo -ne '\''\xd1\n'\''|json -b 2'
echo -ne '\xd1\n'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xd1\n'\''|json -b 2'

echo '$ echo -ne '\''\xd1\r'\''|json -b 1'
echo -ne '\xd1\r'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xd1\r'\''|json -b 1'

echo '$ echo -ne '\''\xd1\r'\''|json -b 2'
echo -ne '\xd1\r'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xd1\r'\''|json -b 2'

echo '$ echo -ne '\''\xd1\t'\''|json -b 1'
echo -ne '\xd1\t'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xd1\t'\''|json -b 1'

echo '$ echo -ne '\''\xd1\t'\''|json -b 2'
echo -ne '\xd1\t'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xd1\t'\''|json -b 2'

echo '$ echo -ne '\''\xd2\b'\''|json -b 1'
echo -ne '\xd2\b'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xd2\b'\''|json -b 1'

echo '$ echo -ne '\''\xd2\b'\''|json -b 2'
echo -ne '\xd2\b'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xd2\b'\''|json -b 2'

echo '$ echo -ne '\''\xd2\f'\''|json -b 1'
echo -ne '\xd2\f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xd2\f'\''|json -b 1'

echo '$ echo -ne '\''\xd2\f'\''|json -b 2'
echo -ne '\xd2\f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xd2\f'\''|json -b 2'

echo '$ echo -ne '\''\xd2\n'\''|json -b 1'
echo -ne '\xd2\n'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xd2\n'\''|json -b 1'

echo '$ echo -ne '\''\xd2\n'\''|json -b 2'
echo -ne '\xd2\n'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xd2\n'\''|json -b 2'

echo '$ echo -ne '\''\xd2\r'\''|json -b 1'
echo -ne '\xd2\r'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xd2\r'\''|json -b 1'

echo '$ echo -ne '\''\xd2\r'\''|json -b 2'
echo -ne '\xd2\r'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xd2\r'\''|json -b 2'

echo '$ echo -ne '\''\xd2\t'\''|json -b 1'
echo -ne '\xd2\t'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xd2\t'\''|json -b 1'

echo '$ echo -ne '\''\xd2\t'\''|json -b 2'
echo -ne '\xd2\t'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xd2\t'\''|json -b 2'

echo '$ echo -ne '\''\xd3\b'\''|json -b 1'
echo -ne '\xd3\b'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xd3\b'\''|json -b 1'

echo '$ echo -ne '\''\xd3\b'\''|json -b 2'
echo -ne '\xd3\b'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xd3\b'\''|json -b 2'

echo '$ echo -ne '\''\xd3\f'\''|json -b 1'
echo -ne '\xd3\f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xd3\f'\''|json -b 1'

echo '$ echo -ne '\''\xd3\f'\''|json -b 2'
echo -ne '\xd3\f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xd3\f'\''|json -b 2'

echo '$ echo -ne '\''\xd3\n'\''|json -b 1'
echo -ne '\xd3\n'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xd3\n'\''|json -b 1'

echo '$ echo -ne '\''\xd3\n'\''|json -b 2'
echo -ne '\xd3\n'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xd3\n'\''|json -b 2'

echo '$ echo -ne '\''\xd3\r'\''|json -b 1'
echo -ne '\xd3\r'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xd3\r'\''|json -b 1'

echo '$ echo -ne '\''\xd3\r'\''|json -b 2'
echo -ne '\xd3\r'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xd3\r'\''|json -b 2'

echo '$ echo -ne '\''\xd3\t'\''|json -b 1'
echo -ne '\xd3\t'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xd3\t'\''|json -b 1'

echo '$ echo -ne '\''\xd3\t'\''|json -b 2'
echo -ne '\xd3\t'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xd3\t'\''|json -b 2'

echo '$ echo -ne '\''\xd4\b'\''|json -b 1'
echo -ne '\xd4\b'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xd4\b'\''|json -b 1'

echo '$ echo -ne '\''\xd4\b'\''|json -b 2'
echo -ne '\xd4\b'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xd4\b'\''|json -b 2'

echo '$ echo -ne '\''\xd4\f'\''|json -b 1'
echo -ne '\xd4\f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xd4\f'\''|json -b 1'

echo '$ echo -ne '\''\xd4\f'\''|json -b 2'
echo -ne '\xd4\f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xd4\f'\''|json -b 2'

echo '$ echo -ne '\''\xd4\n'\''|json -b 1'
echo -ne '\xd4\n'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xd4\n'\''|json -b 1'

echo '$ echo -ne '\''\xd4\n'\''|json -b 2'
echo -ne '\xd4\n'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xd4\n'\''|json -b 2'

echo '$ echo -ne '\''\xd4\r'\''|json -b 1'
echo -ne '\xd4\r'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xd4\r'\''|json -b 1'

echo '$ echo -ne '\''\xd4\r'\''|json -b 2'
echo -ne '\xd4\r'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xd4\r'\''|json -b 2'

echo '$ echo -ne '\''\xd4\t'\''|json -b 1'
echo -ne '\xd4\t'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xd4\t'\''|json -b 1'

echo '$ echo -ne '\''\xd4\t'\''|json -b 2'
echo -ne '\xd4\t'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xd4\t'\''|json -b 2'

echo '$ echo -ne '\''\xd5\b'\''|json -b 1'
echo -ne '\xd5\b'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xd5\b'\''|json -b 1'

echo '$ echo -ne '\''\xd5\b'\''|json -b 2'
echo -ne '\xd5\b'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xd5\b'\''|json -b 2'

echo '$ echo -ne '\''\xd5\f'\''|json -b 1'
echo -ne '\xd5\f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xd5\f'\''|json -b 1'

echo '$ echo -ne '\''\xd5\f'\''|json -b 2'
echo -ne '\xd5\f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xd5\f'\''|json -b 2'

echo '$ echo -ne '\''\xd5\n'\''|json -b 1'
echo -ne '\xd5\n'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xd5\n'\''|json -b 1'

echo '$ echo -ne '\''\xd5\n'\''|json -b 2'
echo -ne '\xd5\n'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xd5\n'\''|json -b 2'

echo '$ echo -ne '\''\xd5\r'\''|json -b 1'
echo -ne '\xd5\r'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xd5\r'\''|json -b 1'

echo '$ echo -ne '\''\xd5\r'\''|json -b 2'
echo -ne '\xd5\r'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xd5\r'\''|json -b 2'

echo '$ echo -ne '\''\xd5\t'\''|json -b 1'
echo -ne '\xd5\t'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xd5\t'\''|json -b 1'

echo '$ echo -ne '\''\xd5\t'\''|json -b 2'
echo -ne '\xd5\t'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xd5\t'\''|json -b 2'

echo '$ echo -ne '\''\xd6\b'\''|json -b 1'
echo -ne '\xd6\b'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xd6\b'\''|json -b 1'

echo '$ echo -ne '\''\xd6\b'\''|json -b 2'
echo -ne '\xd6\b'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xd6\b'\''|json -b 2'

echo '$ echo -ne '\''\xd6\f'\''|json -b 1'
echo -ne '\xd6\f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xd6\f'\''|json -b 1'

echo '$ echo -ne '\''\xd6\f'\''|json -b 2'
echo -ne '\xd6\f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xd6\f'\''|json -b 2'

echo '$ echo -ne '\''\xd6\n'\''|json -b 1'
echo -ne '\xd6\n'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xd6\n'\''|json -b 1'

echo '$ echo -ne '\''\xd6\n'\''|json -b 2'
echo -ne '\xd6\n'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xd6\n'\''|json -b 2'

echo '$ echo -ne '\''\xd6\r'\''|json -b 1'
echo -ne '\xd6\r'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xd6\r'\''|json -b 1'

echo '$ echo -ne '\''\xd6\r'\''|json -b 2'
echo -ne '\xd6\r'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xd6\r'\''|json -b 2'

echo '$ echo -ne '\''\xd6\t'\''|json -b 1'
echo -ne '\xd6\t'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xd6\t'\''|json -b 1'

echo '$ echo -ne '\''\xd6\t'\''|json -b 2'
echo -ne '\xd6\t'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xd6\t'\''|json -b 2'

echo '$ echo -ne '\''\xd7\b'\''|json -b 1'
echo -ne '\xd7\b'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xd7\b'\''|json -b 1'

echo '$ echo -ne '\''\xd7\b'\''|json -b 2'
echo -ne '\xd7\b'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xd7\b'\''|json -b 2'

echo '$ echo -ne '\''\xd7\f'\''|json -b 1'
echo -ne '\xd7\f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xd7\f'\''|json -b 1'

echo '$ echo -ne '\''\xd7\f'\''|json -b 2'
echo -ne '\xd7\f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xd7\f'\''|json -b 2'

echo '$ echo -ne '\''\xd7\n'\''|json -b 1'
echo -ne '\xd7\n'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xd7\n'\''|json -b 1'

echo '$ echo -ne '\''\xd7\n'\''|json -b 2'
echo -ne '\xd7\n'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xd7\n'\''|json -b 2'

echo '$ echo -ne '\''\xd7\r'\''|json -b 1'
echo -ne '\xd7\r'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xd7\r'\''|json -b 1'

echo '$ echo -ne '\''\xd7\r'\''|json -b 2'
echo -ne '\xd7\r'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xd7\r'\''|json -b 2'

echo '$ echo -ne '\''\xd7\t'\''|json -b 1'
echo -ne '\xd7\t'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xd7\t'\''|json -b 1'

echo '$ echo -ne '\''\xd7\t'\''|json -b 2'
echo -ne '\xd7\t'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xd7\t'\''|json -b 2'

echo '$ echo -ne '\''\xd8\b'\''|json -b 1'
echo -ne '\xd8\b'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xd8\b'\''|json -b 1'

echo '$ echo -ne '\''\xd8\b'\''|json -b 2'
echo -ne '\xd8\b'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xd8\b'\''|json -b 2'

echo '$ echo -ne '\''\xd8\f'\''|json -b 1'
echo -ne '\xd8\f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xd8\f'\''|json -b 1'

echo '$ echo -ne '\''\xd8\f'\''|json -b 2'
echo -ne '\xd8\f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xd8\f'\''|json -b 2'

echo '$ echo -ne '\''\xd8\n'\''|json -b 1'
echo -ne '\xd8\n'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xd8\n'\''|json -b 1'

echo '$ echo -ne '\''\xd8\n'\''|json -b 2'
echo -ne '\xd8\n'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xd8\n'\''|json -b 2'

echo '$ echo -ne '\''\xd8\r'\''|json -b 1'
echo -ne '\xd8\r'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xd8\r'\''|json -b 1'

echo '$ echo -ne '\''\xd8\r'\''|json -b 2'
echo -ne '\xd8\r'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xd8\r'\''|json -b 2'

echo '$ echo -ne '\''\xd8\t'\''|json -b 1'
echo -ne '\xd8\t'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xd8\t'\''|json -b 1'

echo '$ echo -ne '\''\xd8\t'\''|json -b 2'
echo -ne '\xd8\t'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xd8\t'\''|json -b 2'

echo '$ echo -ne '\''\xd9\b'\''|json -b 1'
echo -ne '\xd9\b'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xd9\b'\''|json -b 1'

echo '$ echo -ne '\''\xd9\b'\''|json -b 2'
echo -ne '\xd9\b'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xd9\b'\''|json -b 2'

echo '$ echo -ne '\''\xd9\f'\''|json -b 1'
echo -ne '\xd9\f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xd9\f'\''|json -b 1'

echo '$ echo -ne '\''\xd9\f'\''|json -b 2'
echo -ne '\xd9\f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xd9\f'\''|json -b 2'

echo '$ echo -ne '\''\xd9\n'\''|json -b 1'
echo -ne '\xd9\n'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xd9\n'\''|json -b 1'

echo '$ echo -ne '\''\xd9\n'\''|json -b 2'
echo -ne '\xd9\n'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xd9\n'\''|json -b 2'

echo '$ echo -ne '\''\xd9\r'\''|json -b 1'
echo -ne '\xd9\r'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xd9\r'\''|json -b 1'

echo '$ echo -ne '\''\xd9\r'\''|json -b 2'
echo -ne '\xd9\r'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xd9\r'\''|json -b 2'

echo '$ echo -ne '\''\xd9\t'\''|json -b 1'
echo -ne '\xd9\t'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xd9\t'\''|json -b 1'

echo '$ echo -ne '\''\xd9\t'\''|json -b 2'
echo -ne '\xd9\t'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xd9\t'\''|json -b 2'

echo '$ echo -ne '\''\xda\b'\''|json -b 1'
echo -ne '\xda\b'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xda\b'\''|json -b 1'

echo '$ echo -ne '\''\xda\b'\''|json -b 2'
echo -ne '\xda\b'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xda\b'\''|json -b 2'

echo '$ echo -ne '\''\xda\f'\''|json -b 1'
echo -ne '\xda\f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xda\f'\''|json -b 1'

echo '$ echo -ne '\''\xda\f'\''|json -b 2'
echo -ne '\xda\f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xda\f'\''|json -b 2'

echo '$ echo -ne '\''\xda\n'\''|json -b 1'
echo -ne '\xda\n'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xda\n'\''|json -b 1'

echo '$ echo -ne '\''\xda\n'\''|json -b 2'
echo -ne '\xda\n'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xda\n'\''|json -b 2'

echo '$ echo -ne '\''\xda\r'\''|json -b 1'
echo -ne '\xda\r'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xda\r'\''|json -b 1'

echo '$ echo -ne '\''\xda\r'\''|json -b 2'
echo -ne '\xda\r'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xda\r'\''|json -b 2'

echo '$ echo -ne '\''\xda\t'\''|json -b 1'
echo -ne '\xda\t'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xda\t'\''|json -b 1'

echo '$ echo -ne '\''\xda\t'\''|json -b 2'
echo -ne '\xda\t'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xda\t'\''|json -b 2'

echo '$ echo -ne '\''\xdb\b'\''|json -b 1'
echo -ne '\xdb\b'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xdb\b'\''|json -b 1'

echo '$ echo -ne '\''\xdb\b'\''|json -b 2'
echo -ne '\xdb\b'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xdb\b'\''|json -b 2'

echo '$ echo -ne '\''\xdb\f'\''|json -b 1'
echo -ne '\xdb\f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xdb\f'\''|json -b 1'

echo '$ echo -ne '\''\xdb\f'\''|json -b 2'
echo -ne '\xdb\f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xdb\f'\''|json -b 2'

echo '$ echo -ne '\''\xdb\n'\''|json -b 1'
echo -ne '\xdb\n'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xdb\n'\''|json -b 1'

echo '$ echo -ne '\''\xdb\n'\''|json -b 2'
echo -ne '\xdb\n'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xdb\n'\''|json -b 2'

echo '$ echo -ne '\''\xdb\r'\''|json -b 1'
echo -ne '\xdb\r'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xdb\r'\''|json -b 1'

echo '$ echo -ne '\''\xdb\r'\''|json -b 2'
echo -ne '\xdb\r'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xdb\r'\''|json -b 2'

echo '$ echo -ne '\''\xdb\t'\''|json -b 1'
echo -ne '\xdb\t'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xdb\t'\''|json -b 1'

echo '$ echo -ne '\''\xdb\t'\''|json -b 2'
echo -ne '\xdb\t'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xdb\t'\''|json -b 2'

echo '$ echo -ne '\''\xdc\b'\''|json -b 1'
echo -ne '\xdc\b'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xdc\b'\''|json -b 1'

echo '$ echo -ne '\''\xdc\b'\''|json -b 2'
echo -ne '\xdc\b'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xdc\b'\''|json -b 2'

echo '$ echo -ne '\''\xdc\f'\''|json -b 1'
echo -ne '\xdc\f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xdc\f'\''|json -b 1'

echo '$ echo -ne '\''\xdc\f'\''|json -b 2'
echo -ne '\xdc\f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xdc\f'\''|json -b 2'

echo '$ echo -ne '\''\xdc\n'\''|json -b 1'
echo -ne '\xdc\n'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xdc\n'\''|json -b 1'

echo '$ echo -ne '\''\xdc\n'\''|json -b 2'
echo -ne '\xdc\n'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xdc\n'\''|json -b 2'

echo '$ echo -ne '\''\xdc\r'\''|json -b 1'
echo -ne '\xdc\r'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xdc\r'\''|json -b 1'

echo '$ echo -ne '\''\xdc\r'\''|json -b 2'
echo -ne '\xdc\r'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xdc\r'\''|json -b 2'

echo '$ echo -ne '\''\xdc\t'\''|json -b 1'
echo -ne '\xdc\t'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xdc\t'\''|json -b 1'

echo '$ echo -ne '\''\xdc\t'\''|json -b 2'
echo -ne '\xdc\t'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xdc\t'\''|json -b 2'

echo '$ echo -ne '\''\xdd\b'\''|json -b 1'
echo -ne '\xdd\b'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xdd\b'\''|json -b 1'

echo '$ echo -ne '\''\xdd\b'\''|json -b 2'
echo -ne '\xdd\b'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xdd\b'\''|json -b 2'

echo '$ echo -ne '\''\xdd\f'\''|json -b 1'
echo -ne '\xdd\f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xdd\f'\''|json -b 1'

echo '$ echo -ne '\''\xdd\f'\''|json -b 2'
echo -ne '\xdd\f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xdd\f'\''|json -b 2'

echo '$ echo -ne '\''\xdd\n'\''|json -b 1'
echo -ne '\xdd\n'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xdd\n'\''|json -b 1'

echo '$ echo -ne '\''\xdd\n'\''|json -b 2'
echo -ne '\xdd\n'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xdd\n'\''|json -b 2'

echo '$ echo -ne '\''\xdd\r'\''|json -b 1'
echo -ne '\xdd\r'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xdd\r'\''|json -b 1'

echo '$ echo -ne '\''\xdd\r'\''|json -b 2'
echo -ne '\xdd\r'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xdd\r'\''|json -b 2'

echo '$ echo -ne '\''\xdd\t'\''|json -b 1'
echo -ne '\xdd\t'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xdd\t'\''|json -b 1'

echo '$ echo -ne '\''\xdd\t'\''|json -b 2'
echo -ne '\xdd\t'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xdd\t'\''|json -b 2'

echo '$ echo -ne '\''\xde\b'\''|json -b 1'
echo -ne '\xde\b'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xde\b'\''|json -b 1'

echo '$ echo -ne '\''\xde\b'\''|json -b 2'
echo -ne '\xde\b'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xde\b'\''|json -b 2'

echo '$ echo -ne '\''\xde\f'\''|json -b 1'
echo -ne '\xde\f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xde\f'\''|json -b 1'

echo '$ echo -ne '\''\xde\f'\''|json -b 2'
echo -ne '\xde\f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xde\f'\''|json -b 2'

echo '$ echo -ne '\''\xde\n'\''|json -b 1'
echo -ne '\xde\n'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xde\n'\''|json -b 1'

echo '$ echo -ne '\''\xde\n'\''|json -b 2'
echo -ne '\xde\n'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xde\n'\''|json -b 2'

echo '$ echo -ne '\''\xde\r'\''|json -b 1'
echo -ne '\xde\r'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xde\r'\''|json -b 1'

echo '$ echo -ne '\''\xde\r'\''|json -b 2'
echo -ne '\xde\r'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xde\r'\''|json -b 2'

echo '$ echo -ne '\''\xde\t'\''|json -b 1'
echo -ne '\xde\t'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xde\t'\''|json -b 1'

echo '$ echo -ne '\''\xde\t'\''|json -b 2'
echo -ne '\xde\t'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xde\t'\''|json -b 2'

echo '$ echo -ne '\''\xdf\b'\''|json -b 1'
echo -ne '\xdf\b'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xdf\b'\''|json -b 1'

echo '$ echo -ne '\''\xdf\b'\''|json -b 2'
echo -ne '\xdf\b'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xdf\b'\''|json -b 2'

echo '$ echo -ne '\''\xdf\f'\''|json -b 1'
echo -ne '\xdf\f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xdf\f'\''|json -b 1'

echo '$ echo -ne '\''\xdf\f'\''|json -b 2'
echo -ne '\xdf\f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xdf\f'\''|json -b 2'

echo '$ echo -ne '\''\xdf\n'\''|json -b 1'
echo -ne '\xdf\n'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xdf\n'\''|json -b 1'

echo '$ echo -ne '\''\xdf\n'\''|json -b 2'
echo -ne '\xdf\n'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xdf\n'\''|json -b 2'

echo '$ echo -ne '\''\xdf\r'\''|json -b 1'
echo -ne '\xdf\r'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xdf\r'\''|json -b 1'

echo '$ echo -ne '\''\xdf\r'\''|json -b 2'
echo -ne '\xdf\r'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xdf\r'\''|json -b 2'

echo '$ echo -ne '\''\xdf\t'\''|json -b 1'
echo -ne '\xdf\t'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xdf\t'\''|json -b 1'

echo '$ echo -ne '\''\xdf\t'\''|json -b 2'
echo -ne '\xdf\t'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xdf\t'\''|json -b 2'

echo '$ echo -ne '\''\xe0\xbf\b'\''|json -b 1'
echo -ne '\xe0\xbf\b'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xe0\xbf\b'\''|json -b 1'

echo '$ echo -ne '\''\xe0\xbf\b'\''|json -b 3'
echo -ne '\xe0\xbf\b'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xe0\xbf\b'\''|json -b 3'

echo '$ echo -ne '\''\xe0\xbf\f'\''|json -b 1'
echo -ne '\xe0\xbf\f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xe0\xbf\f'\''|json -b 1'

echo '$ echo -ne '\''\xe0\xbf\f'\''|json -b 3'
echo -ne '\xe0\xbf\f'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xe0\xbf\f'\''|json -b 3'

echo '$ echo -ne '\''\xe0\xbf\n'\''|json -b 1'
echo -ne '\xe0\xbf\n'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xe0\xbf\n'\''|json -b 1'

echo '$ echo -ne '\''\xe0\xbf\n'\''|json -b 3'
echo -ne '\xe0\xbf\n'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xe0\xbf\n'\''|json -b 3'

echo '$ echo -ne '\''\xe0\xbf\r'\''|json -b 1'
echo -ne '\xe0\xbf\r'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xe0\xbf\r'\''|json -b 1'

echo '$ echo -ne '\''\xe0\xbf\r'\''|json -b 3'
echo -ne '\xe0\xbf\r'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xe0\xbf\r'\''|json -b 3'

echo '$ echo -ne '\''\xe0\xbf\t'\''|json -b 1'
echo -ne '\xe0\xbf\t'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xe0\xbf\t'\''|json -b 1'

echo '$ echo -ne '\''\xe0\xbf\t'\''|json -b 3'
echo -ne '\xe0\xbf\t'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xe0\xbf\t'\''|json -b 3'

echo '$ echo -ne '\''\xe1\xbf\b'\''|json -b 1'
echo -ne '\xe1\xbf\b'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xe1\xbf\b'\''|json -b 1'

echo '$ echo -ne '\''\xe1\xbf\b'\''|json -b 3'
echo -ne '\xe1\xbf\b'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xe1\xbf\b'\''|json -b 3'

echo '$ echo -ne '\''\xe1\xbf\f'\''|json -b 1'
echo -ne '\xe1\xbf\f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xe1\xbf\f'\''|json -b 1'

echo '$ echo -ne '\''\xe1\xbf\f'\''|json -b 3'
echo -ne '\xe1\xbf\f'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xe1\xbf\f'\''|json -b 3'

echo '$ echo -ne '\''\xe1\xbf\n'\''|json -b 1'
echo -ne '\xe1\xbf\n'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xe1\xbf\n'\''|json -b 1'

echo '$ echo -ne '\''\xe1\xbf\n'\''|json -b 3'
echo -ne '\xe1\xbf\n'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xe1\xbf\n'\''|json -b 3'

echo '$ echo -ne '\''\xe1\xbf\r'\''|json -b 1'
echo -ne '\xe1\xbf\r'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xe1\xbf\r'\''|json -b 1'

echo '$ echo -ne '\''\xe1\xbf\r'\''|json -b 3'
echo -ne '\xe1\xbf\r'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xe1\xbf\r'\''|json -b 3'

echo '$ echo -ne '\''\xe1\xbf\t'\''|json -b 1'
echo -ne '\xe1\xbf\t'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xe1\xbf\t'\''|json -b 1'

echo '$ echo -ne '\''\xe1\xbf\t'\''|json -b 3'
echo -ne '\xe1\xbf\t'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xe1\xbf\t'\''|json -b 3'

echo '$ echo -ne '\''\xe2\xbf\b'\''|json -b 1'
echo -ne '\xe2\xbf\b'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xe2\xbf\b'\''|json -b 1'

echo '$ echo -ne '\''\xe2\xbf\b'\''|json -b 3'
echo -ne '\xe2\xbf\b'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xe2\xbf\b'\''|json -b 3'

echo '$ echo -ne '\''\xe2\xbf\f'\''|json -b 1'
echo -ne '\xe2\xbf\f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xe2\xbf\f'\''|json -b 1'

echo '$ echo -ne '\''\xe2\xbf\f'\''|json -b 3'
echo -ne '\xe2\xbf\f'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xe2\xbf\f'\''|json -b 3'

echo '$ echo -ne '\''\xe2\xbf\n'\''|json -b 1'
echo -ne '\xe2\xbf\n'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xe2\xbf\n'\''|json -b 1'

echo '$ echo -ne '\''\xe2\xbf\n'\''|json -b 3'
echo -ne '\xe2\xbf\n'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xe2\xbf\n'\''|json -b 3'

echo '$ echo -ne '\''\xe2\xbf\r'\''|json -b 1'
echo -ne '\xe2\xbf\r'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xe2\xbf\r'\''|json -b 1'

echo '$ echo -ne '\''\xe2\xbf\r'\''|json -b 3'
echo -ne '\xe2\xbf\r'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xe2\xbf\r'\''|json -b 3'

echo '$ echo -ne '\''\xe2\xbf\t'\''|json -b 1'
echo -ne '\xe2\xbf\t'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xe2\xbf\t'\''|json -b 1'

echo '$ echo -ne '\''\xe2\xbf\t'\''|json -b 3'
echo -ne '\xe2\xbf\t'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xe2\xbf\t'\''|json -b 3'

echo '$ echo -ne '\''\xe3\xbf\b'\''|json -b 1'
echo -ne '\xe3\xbf\b'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xe3\xbf\b'\''|json -b 1'

echo '$ echo -ne '\''\xe3\xbf\b'\''|json -b 3'
echo -ne '\xe3\xbf\b'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xe3\xbf\b'\''|json -b 3'

echo '$ echo -ne '\''\xe3\xbf\f'\''|json -b 1'
echo -ne '\xe3\xbf\f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xe3\xbf\f'\''|json -b 1'

echo '$ echo -ne '\''\xe3\xbf\f'\''|json -b 3'
echo -ne '\xe3\xbf\f'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xe3\xbf\f'\''|json -b 3'

echo '$ echo -ne '\''\xe3\xbf\n'\''|json -b 1'
echo -ne '\xe3\xbf\n'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xe3\xbf\n'\''|json -b 1'

echo '$ echo -ne '\''\xe3\xbf\n'\''|json -b 3'
echo -ne '\xe3\xbf\n'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xe3\xbf\n'\''|json -b 3'

echo '$ echo -ne '\''\xe3\xbf\r'\''|json -b 1'
echo -ne '\xe3\xbf\r'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xe3\xbf\r'\''|json -b 1'

echo '$ echo -ne '\''\xe3\xbf\r'\''|json -b 3'
echo -ne '\xe3\xbf\r'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xe3\xbf\r'\''|json -b 3'

echo '$ echo -ne '\''\xe3\xbf\t'\''|json -b 1'
echo -ne '\xe3\xbf\t'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xe3\xbf\t'\''|json -b 1'

echo '$ echo -ne '\''\xe3\xbf\t'\''|json -b 3'
echo -ne '\xe3\xbf\t'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xe3\xbf\t'\''|json -b 3'

echo '$ echo -ne '\''\xe4\xbf\b'\''|json -b 1'
echo -ne '\xe4\xbf\b'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xe4\xbf\b'\''|json -b 1'

echo '$ echo -ne '\''\xe4\xbf\b'\''|json -b 3'
echo -ne '\xe4\xbf\b'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xe4\xbf\b'\''|json -b 3'

echo '$ echo -ne '\''\xe4\xbf\f'\''|json -b 1'
echo -ne '\xe4\xbf\f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xe4\xbf\f'\''|json -b 1'

echo '$ echo -ne '\''\xe4\xbf\f'\''|json -b 3'
echo -ne '\xe4\xbf\f'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xe4\xbf\f'\''|json -b 3'

echo '$ echo -ne '\''\xe4\xbf\n'\''|json -b 1'
echo -ne '\xe4\xbf\n'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xe4\xbf\n'\''|json -b 1'

echo '$ echo -ne '\''\xe4\xbf\n'\''|json -b 3'
echo -ne '\xe4\xbf\n'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xe4\xbf\n'\''|json -b 3'

echo '$ echo -ne '\''\xe4\xbf\r'\''|json -b 1'
echo -ne '\xe4\xbf\r'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xe4\xbf\r'\''|json -b 1'

echo '$ echo -ne '\''\xe4\xbf\r'\''|json -b 3'
echo -ne '\xe4\xbf\r'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xe4\xbf\r'\''|json -b 3'

echo '$ echo -ne '\''\xe4\xbf\t'\''|json -b 1'
echo -ne '\xe4\xbf\t'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xe4\xbf\t'\''|json -b 1'

echo '$ echo -ne '\''\xe4\xbf\t'\''|json -b 3'
echo -ne '\xe4\xbf\t'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xe4\xbf\t'\''|json -b 3'

echo '$ echo -ne '\''\xe5\xbf\b'\''|json -b 1'
echo -ne '\xe5\xbf\b'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xe5\xbf\b'\''|json -b 1'

echo '$ echo -ne '\''\xe5\xbf\b'\''|json -b 3'
echo -ne '\xe5\xbf\b'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xe5\xbf\b'\''|json -b 3'

echo '$ echo -ne '\''\xe5\xbf\f'\''|json -b 1'
echo -ne '\xe5\xbf\f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xe5\xbf\f'\''|json -b 1'

echo '$ echo -ne '\''\xe5\xbf\f'\''|json -b 3'
echo -ne '\xe5\xbf\f'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xe5\xbf\f'\''|json -b 3'

echo '$ echo -ne '\''\xe5\xbf\n'\''|json -b 1'
echo -ne '\xe5\xbf\n'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xe5\xbf\n'\''|json -b 1'

echo '$ echo -ne '\''\xe5\xbf\n'\''|json -b 3'
echo -ne '\xe5\xbf\n'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xe5\xbf\n'\''|json -b 3'

echo '$ echo -ne '\''\xe5\xbf\r'\''|json -b 1'
echo -ne '\xe5\xbf\r'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xe5\xbf\r'\''|json -b 1'

echo '$ echo -ne '\''\xe5\xbf\r'\''|json -b 3'
echo -ne '\xe5\xbf\r'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xe5\xbf\r'\''|json -b 3'

echo '$ echo -ne '\''\xe5\xbf\t'\''|json -b 1'
echo -ne '\xe5\xbf\t'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xe5\xbf\t'\''|json -b 1'

echo '$ echo -ne '\''\xe5\xbf\t'\''|json -b 3'
echo -ne '\xe5\xbf\t'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xe5\xbf\t'\''|json -b 3'

echo '$ echo -ne '\''\xe6\xbf\b'\''|json -b 1'
echo -ne '\xe6\xbf\b'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xe6\xbf\b'\''|json -b 1'

echo '$ echo -ne '\''\xe6\xbf\b'\''|json -b 3'
echo -ne '\xe6\xbf\b'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xe6\xbf\b'\''|json -b 3'

echo '$ echo -ne '\''\xe6\xbf\f'\''|json -b 1'
echo -ne '\xe6\xbf\f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xe6\xbf\f'\''|json -b 1'

echo '$ echo -ne '\''\xe6\xbf\f'\''|json -b 3'
echo -ne '\xe6\xbf\f'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xe6\xbf\f'\''|json -b 3'

echo '$ echo -ne '\''\xe6\xbf\n'\''|json -b 1'
echo -ne '\xe6\xbf\n'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xe6\xbf\n'\''|json -b 1'

echo '$ echo -ne '\''\xe6\xbf\n'\''|json -b 3'
echo -ne '\xe6\xbf\n'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xe6\xbf\n'\''|json -b 3'

echo '$ echo -ne '\''\xe6\xbf\r'\''|json -b 1'
echo -ne '\xe6\xbf\r'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xe6\xbf\r'\''|json -b 1'

echo '$ echo -ne '\''\xe6\xbf\r'\''|json -b 3'
echo -ne '\xe6\xbf\r'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xe6\xbf\r'\''|json -b 3'

echo '$ echo -ne '\''\xe6\xbf\t'\''|json -b 1'
echo -ne '\xe6\xbf\t'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xe6\xbf\t'\''|json -b 1'

echo '$ echo -ne '\''\xe6\xbf\t'\''|json -b 3'
echo -ne '\xe6\xbf\t'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xe6\xbf\t'\''|json -b 3'

echo '$ echo -ne '\''\xe7\xbf\b'\''|json -b 1'
echo -ne '\xe7\xbf\b'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xe7\xbf\b'\''|json -b 1'

echo '$ echo -ne '\''\xe7\xbf\b'\''|json -b 3'
echo -ne '\xe7\xbf\b'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xe7\xbf\b'\''|json -b 3'

echo '$ echo -ne '\''\xe7\xbf\f'\''|json -b 1'
echo -ne '\xe7\xbf\f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xe7\xbf\f'\''|json -b 1'

echo '$ echo -ne '\''\xe7\xbf\f'\''|json -b 3'
echo -ne '\xe7\xbf\f'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xe7\xbf\f'\''|json -b 3'

echo '$ echo -ne '\''\xe7\xbf\n'\''|json -b 1'
echo -ne '\xe7\xbf\n'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xe7\xbf\n'\''|json -b 1'

echo '$ echo -ne '\''\xe7\xbf\n'\''|json -b 3'
echo -ne '\xe7\xbf\n'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xe7\xbf\n'\''|json -b 3'

echo '$ echo -ne '\''\xe7\xbf\r'\''|json -b 1'
echo -ne '\xe7\xbf\r'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xe7\xbf\r'\''|json -b 1'

echo '$ echo -ne '\''\xe7\xbf\r'\''|json -b 3'
echo -ne '\xe7\xbf\r'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xe7\xbf\r'\''|json -b 3'

echo '$ echo -ne '\''\xe7\xbf\t'\''|json -b 1'
echo -ne '\xe7\xbf\t'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xe7\xbf\t'\''|json -b 1'

echo '$ echo -ne '\''\xe7\xbf\t'\''|json -b 3'
echo -ne '\xe7\xbf\t'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xe7\xbf\t'\''|json -b 3'

echo '$ echo -ne '\''\xe8\xbf\b'\''|json -b 1'
echo -ne '\xe8\xbf\b'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xe8\xbf\b'\''|json -b 1'

echo '$ echo -ne '\''\xe8\xbf\b'\''|json -b 3'
echo -ne '\xe8\xbf\b'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xe8\xbf\b'\''|json -b 3'

echo '$ echo -ne '\''\xe8\xbf\f'\''|json -b 1'
echo -ne '\xe8\xbf\f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xe8\xbf\f'\''|json -b 1'

echo '$ echo -ne '\''\xe8\xbf\f'\''|json -b 3'
echo -ne '\xe8\xbf\f'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xe8\xbf\f'\''|json -b 3'

echo '$ echo -ne '\''\xe8\xbf\n'\''|json -b 1'
echo -ne '\xe8\xbf\n'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xe8\xbf\n'\''|json -b 1'

echo '$ echo -ne '\''\xe8\xbf\n'\''|json -b 3'
echo -ne '\xe8\xbf\n'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xe8\xbf\n'\''|json -b 3'

echo '$ echo -ne '\''\xe8\xbf\r'\''|json -b 1'
echo -ne '\xe8\xbf\r'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xe8\xbf\r'\''|json -b 1'

echo '$ echo -ne '\''\xe8\xbf\r'\''|json -b 3'
echo -ne '\xe8\xbf\r'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xe8\xbf\r'\''|json -b 3'

echo '$ echo -ne '\''\xe8\xbf\t'\''|json -b 1'
echo -ne '\xe8\xbf\t'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xe8\xbf\t'\''|json -b 1'

echo '$ echo -ne '\''\xe8\xbf\t'\''|json -b 3'
echo -ne '\xe8\xbf\t'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xe8\xbf\t'\''|json -b 3'

echo '$ echo -ne '\''\xe9\xbf\b'\''|json -b 1'
echo -ne '\xe9\xbf\b'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xe9\xbf\b'\''|json -b 1'

echo '$ echo -ne '\''\xe9\xbf\b'\''|json -b 3'
echo -ne '\xe9\xbf\b'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xe9\xbf\b'\''|json -b 3'

echo '$ echo -ne '\''\xe9\xbf\f'\''|json -b 1'
echo -ne '\xe9\xbf\f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xe9\xbf\f'\''|json -b 1'

echo '$ echo -ne '\''\xe9\xbf\f'\''|json -b 3'
echo -ne '\xe9\xbf\f'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xe9\xbf\f'\''|json -b 3'

echo '$ echo -ne '\''\xe9\xbf\n'\''|json -b 1'
echo -ne '\xe9\xbf\n'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xe9\xbf\n'\''|json -b 1'

echo '$ echo -ne '\''\xe9\xbf\n'\''|json -b 3'
echo -ne '\xe9\xbf\n'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xe9\xbf\n'\''|json -b 3'

echo '$ echo -ne '\''\xe9\xbf\r'\''|json -b 1'
echo -ne '\xe9\xbf\r'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xe9\xbf\r'\''|json -b 1'

echo '$ echo -ne '\''\xe9\xbf\r'\''|json -b 3'
echo -ne '\xe9\xbf\r'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xe9\xbf\r'\''|json -b 3'

echo '$ echo -ne '\''\xe9\xbf\t'\''|json -b 1'
echo -ne '\xe9\xbf\t'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xe9\xbf\t'\''|json -b 1'

echo '$ echo -ne '\''\xe9\xbf\t'\''|json -b 3'
echo -ne '\xe9\xbf\t'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xe9\xbf\t'\''|json -b 3'

echo '$ echo -ne '\''\xea\xbf\b'\''|json -b 1'
echo -ne '\xea\xbf\b'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xea\xbf\b'\''|json -b 1'

echo '$ echo -ne '\''\xea\xbf\b'\''|json -b 3'
echo -ne '\xea\xbf\b'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xea\xbf\b'\''|json -b 3'

echo '$ echo -ne '\''\xea\xbf\f'\''|json -b 1'
echo -ne '\xea\xbf\f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xea\xbf\f'\''|json -b 1'

echo '$ echo -ne '\''\xea\xbf\f'\''|json -b 3'
echo -ne '\xea\xbf\f'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xea\xbf\f'\''|json -b 3'

echo '$ echo -ne '\''\xea\xbf\n'\''|json -b 1'
echo -ne '\xea\xbf\n'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xea\xbf\n'\''|json -b 1'

echo '$ echo -ne '\''\xea\xbf\n'\''|json -b 3'
echo -ne '\xea\xbf\n'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xea\xbf\n'\''|json -b 3'

echo '$ echo -ne '\''\xea\xbf\r'\''|json -b 1'
echo -ne '\xea\xbf\r'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xea\xbf\r'\''|json -b 1'

echo '$ echo -ne '\''\xea\xbf\r'\''|json -b 3'
echo -ne '\xea\xbf\r'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xea\xbf\r'\''|json -b 3'

echo '$ echo -ne '\''\xea\xbf\t'\''|json -b 1'
echo -ne '\xea\xbf\t'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xea\xbf\t'\''|json -b 1'

echo '$ echo -ne '\''\xea\xbf\t'\''|json -b 3'
echo -ne '\xea\xbf\t'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xea\xbf\t'\''|json -b 3'

echo '$ echo -ne '\''\xeb\xbf\b'\''|json -b 1'
echo -ne '\xeb\xbf\b'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xeb\xbf\b'\''|json -b 1'

echo '$ echo -ne '\''\xeb\xbf\b'\''|json -b 3'
echo -ne '\xeb\xbf\b'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xeb\xbf\b'\''|json -b 3'

echo '$ echo -ne '\''\xeb\xbf\f'\''|json -b 1'
echo -ne '\xeb\xbf\f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xeb\xbf\f'\''|json -b 1'

echo '$ echo -ne '\''\xeb\xbf\f'\''|json -b 3'
echo -ne '\xeb\xbf\f'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xeb\xbf\f'\''|json -b 3'

echo '$ echo -ne '\''\xeb\xbf\n'\''|json -b 1'
echo -ne '\xeb\xbf\n'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xeb\xbf\n'\''|json -b 1'

echo '$ echo -ne '\''\xeb\xbf\n'\''|json -b 3'
echo -ne '\xeb\xbf\n'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xeb\xbf\n'\''|json -b 3'

echo '$ echo -ne '\''\xeb\xbf\r'\''|json -b 1'
echo -ne '\xeb\xbf\r'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xeb\xbf\r'\''|json -b 1'

echo '$ echo -ne '\''\xeb\xbf\r'\''|json -b 3'
echo -ne '\xeb\xbf\r'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xeb\xbf\r'\''|json -b 3'

echo '$ echo -ne '\''\xeb\xbf\t'\''|json -b 1'
echo -ne '\xeb\xbf\t'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xeb\xbf\t'\''|json -b 1'

echo '$ echo -ne '\''\xeb\xbf\t'\''|json -b 3'
echo -ne '\xeb\xbf\t'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xeb\xbf\t'\''|json -b 3'

echo '$ echo -ne '\''\xec\xbf\b'\''|json -b 1'
echo -ne '\xec\xbf\b'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xec\xbf\b'\''|json -b 1'

echo '$ echo -ne '\''\xec\xbf\b'\''|json -b 3'
echo -ne '\xec\xbf\b'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xec\xbf\b'\''|json -b 3'

echo '$ echo -ne '\''\xec\xbf\f'\''|json -b 1'
echo -ne '\xec\xbf\f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xec\xbf\f'\''|json -b 1'

echo '$ echo -ne '\''\xec\xbf\f'\''|json -b 3'
echo -ne '\xec\xbf\f'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xec\xbf\f'\''|json -b 3'

echo '$ echo -ne '\''\xec\xbf\n'\''|json -b 1'
echo -ne '\xec\xbf\n'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xec\xbf\n'\''|json -b 1'

echo '$ echo -ne '\''\xec\xbf\n'\''|json -b 3'
echo -ne '\xec\xbf\n'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xec\xbf\n'\''|json -b 3'

echo '$ echo -ne '\''\xec\xbf\r'\''|json -b 1'
echo -ne '\xec\xbf\r'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xec\xbf\r'\''|json -b 1'

echo '$ echo -ne '\''\xec\xbf\r'\''|json -b 3'
echo -ne '\xec\xbf\r'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xec\xbf\r'\''|json -b 3'

echo '$ echo -ne '\''\xec\xbf\t'\''|json -b 1'
echo -ne '\xec\xbf\t'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xec\xbf\t'\''|json -b 1'

echo '$ echo -ne '\''\xec\xbf\t'\''|json -b 3'
echo -ne '\xec\xbf\t'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xec\xbf\t'\''|json -b 3'

echo '$ echo -ne '\''\xed\xbf\b'\''|json -b 1'
echo -ne '\xed\xbf\b'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xed\xbf\b'\''|json -b 1'

echo '$ echo -ne '\''\xed\xbf\b'\''|json -b 3'
echo -ne '\xed\xbf\b'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xed\xbf\b'\''|json -b 3'

echo '$ echo -ne '\''\xed\xbf\f'\''|json -b 1'
echo -ne '\xed\xbf\f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xed\xbf\f'\''|json -b 1'

echo '$ echo -ne '\''\xed\xbf\f'\''|json -b 3'
echo -ne '\xed\xbf\f'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xed\xbf\f'\''|json -b 3'

echo '$ echo -ne '\''\xed\xbf\n'\''|json -b 1'
echo -ne '\xed\xbf\n'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xed\xbf\n'\''|json -b 1'

echo '$ echo -ne '\''\xed\xbf\n'\''|json -b 3'
echo -ne '\xed\xbf\n'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xed\xbf\n'\''|json -b 3'

echo '$ echo -ne '\''\xed\xbf\r'\''|json -b 1'
echo -ne '\xed\xbf\r'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xed\xbf\r'\''|json -b 1'

echo '$ echo -ne '\''\xed\xbf\r'\''|json -b 3'
echo -ne '\xed\xbf\r'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xed\xbf\r'\''|json -b 3'

echo '$ echo -ne '\''\xed\xbf\t'\''|json -b 1'
echo -ne '\xed\xbf\t'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xed\xbf\t'\''|json -b 1'

echo '$ echo -ne '\''\xed\xbf\t'\''|json -b 3'
echo -ne '\xed\xbf\t'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xed\xbf\t'\''|json -b 3'

echo '$ echo -ne '\''\xee\xbf\b'\''|json -b 1'
echo -ne '\xee\xbf\b'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xee\xbf\b'\''|json -b 1'

echo '$ echo -ne '\''\xee\xbf\b'\''|json -b 3'
echo -ne '\xee\xbf\b'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xee\xbf\b'\''|json -b 3'

echo '$ echo -ne '\''\xee\xbf\f'\''|json -b 1'
echo -ne '\xee\xbf\f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xee\xbf\f'\''|json -b 1'

echo '$ echo -ne '\''\xee\xbf\f'\''|json -b 3'
echo -ne '\xee\xbf\f'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xee\xbf\f'\''|json -b 3'

echo '$ echo -ne '\''\xee\xbf\n'\''|json -b 1'
echo -ne '\xee\xbf\n'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xee\xbf\n'\''|json -b 1'

echo '$ echo -ne '\''\xee\xbf\n'\''|json -b 3'
echo -ne '\xee\xbf\n'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xee\xbf\n'\''|json -b 3'

echo '$ echo -ne '\''\xee\xbf\r'\''|json -b 1'
echo -ne '\xee\xbf\r'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xee\xbf\r'\''|json -b 1'

echo '$ echo -ne '\''\xee\xbf\r'\''|json -b 3'
echo -ne '\xee\xbf\r'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xee\xbf\r'\''|json -b 3'

echo '$ echo -ne '\''\xee\xbf\t'\''|json -b 1'
echo -ne '\xee\xbf\t'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xee\xbf\t'\''|json -b 1'

echo '$ echo -ne '\''\xee\xbf\t'\''|json -b 3'
echo -ne '\xee\xbf\t'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xee\xbf\t'\''|json -b 3'

echo '$ echo -ne '\''\xef\xbf\b'\''|json -b 1'
echo -ne '\xef\xbf\b'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xef\xbf\b'\''|json -b 1'

echo '$ echo -ne '\''\xef\xbf\b'\''|json -b 3'
echo -ne '\xef\xbf\b'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xef\xbf\b'\''|json -b 3'

echo '$ echo -ne '\''\xef\xbf\f'\''|json -b 1'
echo -ne '\xef\xbf\f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xef\xbf\f'\''|json -b 1'

echo '$ echo -ne '\''\xef\xbf\f'\''|json -b 3'
echo -ne '\xef\xbf\f'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xef\xbf\f'\''|json -b 3'

echo '$ echo -ne '\''\xef\xbf\n'\''|json -b 1'
echo -ne '\xef\xbf\n'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xef\xbf\n'\''|json -b 1'

echo '$ echo -ne '\''\xef\xbf\n'\''|json -b 3'
echo -ne '\xef\xbf\n'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xef\xbf\n'\''|json -b 3'

echo '$ echo -ne '\''\xef\xbf\r'\''|json -b 1'
echo -ne '\xef\xbf\r'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xef\xbf\r'\''|json -b 1'

echo '$ echo -ne '\''\xef\xbf\r'\''|json -b 3'
echo -ne '\xef\xbf\r'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xef\xbf\r'\''|json -b 3'

echo '$ echo -ne '\''\xef\xbf\t'\''|json -b 1'
echo -ne '\xef\xbf\t'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xef\xbf\t'\''|json -b 1'

echo '$ echo -ne '\''\xef\xbf\t'\''|json -b 3'
echo -ne '\xef\xbf\t'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xef\xbf\t'\''|json -b 3'

echo '$ echo -ne '\''\xf0\xbf\xbf\b'\''|json -b 1'
echo -ne '\xf0\xbf\xbf\b'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\xbf\xbf\b'\''|json -b 1'

echo '$ echo -ne '\''\xf0\xbf\xbf\b'\''|json -b 4'
echo -ne '\xf0\xbf\xbf\b'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\xbf\xbf\b'\''|json -b 4'

echo '$ echo -ne '\''\xf0\xbf\xbf\f'\''|json -b 1'
echo -ne '\xf0\xbf\xbf\f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\xbf\xbf\f'\''|json -b 1'

echo '$ echo -ne '\''\xf0\xbf\xbf\f'\''|json -b 4'
echo -ne '\xf0\xbf\xbf\f'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\xbf\xbf\f'\''|json -b 4'

echo '$ echo -ne '\''\xf0\xbf\xbf\n'\''|json -b 1'
echo -ne '\xf0\xbf\xbf\n'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\xbf\xbf\n'\''|json -b 1'

echo '$ echo -ne '\''\xf0\xbf\xbf\n'\''|json -b 4'
echo -ne '\xf0\xbf\xbf\n'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\xbf\xbf\n'\''|json -b 4'

echo '$ echo -ne '\''\xf0\xbf\xbf\r'\''|json -b 1'
echo -ne '\xf0\xbf\xbf\r'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\xbf\xbf\r'\''|json -b 1'

echo '$ echo -ne '\''\xf0\xbf\xbf\r'\''|json -b 4'
echo -ne '\xf0\xbf\xbf\r'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\xbf\xbf\r'\''|json -b 4'

echo '$ echo -ne '\''\xf0\xbf\xbf\t'\''|json -b 1'
echo -ne '\xf0\xbf\xbf\t'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\xbf\xbf\t'\''|json -b 1'

echo '$ echo -ne '\''\xf0\xbf\xbf\t'\''|json -b 4'
echo -ne '\xf0\xbf\xbf\t'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\xbf\xbf\t'\''|json -b 4'

echo '$ echo -ne '\''\xf1\xbf\xbf\b'\''|json -b 1'
echo -ne '\xf1\xbf\xbf\b'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf1\xbf\xbf\b'\''|json -b 1'

echo '$ echo -ne '\''\xf1\xbf\xbf\b'\''|json -b 4'
echo -ne '\xf1\xbf\xbf\b'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xf1\xbf\xbf\b'\''|json -b 4'

echo '$ echo -ne '\''\xf1\xbf\xbf\f'\''|json -b 1'
echo -ne '\xf1\xbf\xbf\f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf1\xbf\xbf\f'\''|json -b 1'

echo '$ echo -ne '\''\xf1\xbf\xbf\f'\''|json -b 4'
echo -ne '\xf1\xbf\xbf\f'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xf1\xbf\xbf\f'\''|json -b 4'

echo '$ echo -ne '\''\xf1\xbf\xbf\n'\''|json -b 1'
echo -ne '\xf1\xbf\xbf\n'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf1\xbf\xbf\n'\''|json -b 1'

echo '$ echo -ne '\''\xf1\xbf\xbf\n'\''|json -b 4'
echo -ne '\xf1\xbf\xbf\n'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xf1\xbf\xbf\n'\''|json -b 4'

echo '$ echo -ne '\''\xf1\xbf\xbf\r'\''|json -b 1'
echo -ne '\xf1\xbf\xbf\r'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf1\xbf\xbf\r'\''|json -b 1'

echo '$ echo -ne '\''\xf1\xbf\xbf\r'\''|json -b 4'
echo -ne '\xf1\xbf\xbf\r'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xf1\xbf\xbf\r'\''|json -b 4'

echo '$ echo -ne '\''\xf1\xbf\xbf\t'\''|json -b 1'
echo -ne '\xf1\xbf\xbf\t'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf1\xbf\xbf\t'\''|json -b 1'

echo '$ echo -ne '\''\xf1\xbf\xbf\t'\''|json -b 4'
echo -ne '\xf1\xbf\xbf\t'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xf1\xbf\xbf\t'\''|json -b 4'

echo '$ echo -ne '\''\xf2\xbf\xbf\b'\''|json -b 1'
echo -ne '\xf2\xbf\xbf\b'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf2\xbf\xbf\b'\''|json -b 1'

echo '$ echo -ne '\''\xf2\xbf\xbf\b'\''|json -b 4'
echo -ne '\xf2\xbf\xbf\b'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xf2\xbf\xbf\b'\''|json -b 4'

echo '$ echo -ne '\''\xf2\xbf\xbf\f'\''|json -b 1'
echo -ne '\xf2\xbf\xbf\f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf2\xbf\xbf\f'\''|json -b 1'

echo '$ echo -ne '\''\xf2\xbf\xbf\f'\''|json -b 4'
echo -ne '\xf2\xbf\xbf\f'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xf2\xbf\xbf\f'\''|json -b 4'

echo '$ echo -ne '\''\xf2\xbf\xbf\n'\''|json -b 1'
echo -ne '\xf2\xbf\xbf\n'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf2\xbf\xbf\n'\''|json -b 1'

echo '$ echo -ne '\''\xf2\xbf\xbf\n'\''|json -b 4'
echo -ne '\xf2\xbf\xbf\n'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xf2\xbf\xbf\n'\''|json -b 4'

echo '$ echo -ne '\''\xf2\xbf\xbf\r'\''|json -b 1'
echo -ne '\xf2\xbf\xbf\r'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf2\xbf\xbf\r'\''|json -b 1'

echo '$ echo -ne '\''\xf2\xbf\xbf\r'\''|json -b 4'
echo -ne '\xf2\xbf\xbf\r'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xf2\xbf\xbf\r'\''|json -b 4'

echo '$ echo -ne '\''\xf2\xbf\xbf\t'\''|json -b 1'
echo -ne '\xf2\xbf\xbf\t'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf2\xbf\xbf\t'\''|json -b 1'

echo '$ echo -ne '\''\xf2\xbf\xbf\t'\''|json -b 4'
echo -ne '\xf2\xbf\xbf\t'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xf2\xbf\xbf\t'\''|json -b 4'

echo '$ echo -ne '\''\xf3\xbf\xbf\b'\''|json -b 1'
echo -ne '\xf3\xbf\xbf\b'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf3\xbf\xbf\b'\''|json -b 1'

echo '$ echo -ne '\''\xf3\xbf\xbf\b'\''|json -b 4'
echo -ne '\xf3\xbf\xbf\b'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xf3\xbf\xbf\b'\''|json -b 4'

echo '$ echo -ne '\''\xf3\xbf\xbf\f'\''|json -b 1'
echo -ne '\xf3\xbf\xbf\f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf3\xbf\xbf\f'\''|json -b 1'

echo '$ echo -ne '\''\xf3\xbf\xbf\f'\''|json -b 4'
echo -ne '\xf3\xbf\xbf\f'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xf3\xbf\xbf\f'\''|json -b 4'

echo '$ echo -ne '\''\xf3\xbf\xbf\n'\''|json -b 1'
echo -ne '\xf3\xbf\xbf\n'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf3\xbf\xbf\n'\''|json -b 1'

echo '$ echo -ne '\''\xf3\xbf\xbf\n'\''|json -b 4'
echo -ne '\xf3\xbf\xbf\n'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xf3\xbf\xbf\n'\''|json -b 4'

echo '$ echo -ne '\''\xf3\xbf\xbf\r'\''|json -b 1'
echo -ne '\xf3\xbf\xbf\r'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf3\xbf\xbf\r'\''|json -b 1'

echo '$ echo -ne '\''\xf3\xbf\xbf\r'\''|json -b 4'
echo -ne '\xf3\xbf\xbf\r'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xf3\xbf\xbf\r'\''|json -b 4'

echo '$ echo -ne '\''\xf3\xbf\xbf\t'\''|json -b 1'
echo -ne '\xf3\xbf\xbf\t'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf3\xbf\xbf\t'\''|json -b 1'

echo '$ echo -ne '\''\xf3\xbf\xbf\t'\''|json -b 4'
echo -ne '\xf3\xbf\xbf\t'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xf3\xbf\xbf\t'\''|json -b 4'

echo '$ echo -ne '\''\xf4\xbf\xbf\b'\''|json -b 1'
echo -ne '\xf4\xbf\xbf\b'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf4\xbf\xbf\b'\''|json -b 1'

echo '$ echo -ne '\''\xf4\xbf\xbf\b'\''|json -b 4'
echo -ne '\xf4\xbf\xbf\b'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xf4\xbf\xbf\b'\''|json -b 4'

echo '$ echo -ne '\''\xf4\xbf\xbf\f'\''|json -b 1'
echo -ne '\xf4\xbf\xbf\f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf4\xbf\xbf\f'\''|json -b 1'

echo '$ echo -ne '\''\xf4\xbf\xbf\f'\''|json -b 4'
echo -ne '\xf4\xbf\xbf\f'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xf4\xbf\xbf\f'\''|json -b 4'

echo '$ echo -ne '\''\xf4\xbf\xbf\n'\''|json -b 1'
echo -ne '\xf4\xbf\xbf\n'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf4\xbf\xbf\n'\''|json -b 1'

echo '$ echo -ne '\''\xf4\xbf\xbf\n'\''|json -b 4'
echo -ne '\xf4\xbf\xbf\n'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xf4\xbf\xbf\n'\''|json -b 4'

echo '$ echo -ne '\''\xf4\xbf\xbf\r'\''|json -b 1'
echo -ne '\xf4\xbf\xbf\r'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf4\xbf\xbf\r'\''|json -b 1'

echo '$ echo -ne '\''\xf4\xbf\xbf\r'\''|json -b 4'
echo -ne '\xf4\xbf\xbf\r'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xf4\xbf\xbf\r'\''|json -b 4'

echo '$ echo -ne '\''\xf4\xbf\xbf\t'\''|json -b 1'
echo -ne '\xf4\xbf\xbf\t'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf4\xbf\xbf\t'\''|json -b 1'

echo '$ echo -ne '\''\xf4\xbf\xbf\t'\''|json -b 4'
echo -ne '\xf4\xbf\xbf\t'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xf4\xbf\xbf\t'\''|json -b 4'
)

