#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-cases:83
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L 83.old <(echo \
'$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@" 2>&1|sed -r '\''/error:/s|(/dev/fd/)[0-9]+|\1??|'\''; }
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< null
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"dict","args":[...]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< null
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< false
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"dict","args":[...]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< false
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< 123
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"dict","args":[...]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< 123
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"dict","args":[...]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"dict","args":[...]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{}'\''
{}
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":"bar"}'\''
{"foo":"bar"}
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":"bar","foo":true}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"bar","foo":true}
json: error: <stdin>:1:13:             ^
{"foo":"bar"
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":"bar","foo":true}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":"bar","faa":true}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"bar","faa":true}
json: error: <stdin>:1:13:             ^
{"foo":"bar"
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":"bar","faa":true}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"faa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "foo"
json: error: <stdin>:1:2: {"faa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"faa":true}'\'''
) -L 83.new <(
echo '$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@" 2>&1|sed -r '\''/error:/s|(/dev/fd/)[0-9]+|\1??|'\''; }'
json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@" 2>&1|sed -r '/error:/s|(/dev/fd/)[0-9]+|\1??|'; } 2>&1 ||
echo 'command failed: json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@" 2>&1|sed -r '\''/error:/s|(/dev/fd/)[0-9]+|\1??|'\''; }'

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< null'
json -d '{"type":"dict","args":[{"name":"foo","type":"type"}]}' <<< null 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< null'

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< false'
json -d '{"type":"dict","args":[{"name":"foo","type":"type"}]}' <<< false 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< false'

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< 123'
json -d '{"type":"dict","args":[{"name":"foo","type":"type"}]}' <<< 123 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< 123'

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"type"}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''[]'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"type"}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"type"}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"type"}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":"bar","foo":true}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"type"}]}' <<< '{"foo":"bar","foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":"bar","foo":true}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":"bar","faa":true}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"type"}]}' <<< '{"foo":"bar","faa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":"bar","faa":true}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"faa":true}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"type"}]}' <<< '{"faa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"faa":true}'\'''
)

