#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-cases:29
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L 29.old <(echo \
'$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@" 2>&1|sed -r '\''/error:/s|(/dev/fd/)[0-9]+|\1??|'\''; }
$ set -o pipefail
$ gen-type() { local n; [[ "$1" =~ ^[0-9]+$ ]] && n="$1" || n=0; printf '\''{"type":"list","args":['\''; local k; for((k=0; k<n; k++)); do printf '\''{"type":"object","args":[{"name":"foo","type":{"plain":%d}}]}'\'' $k; test "$k" -lt $((n - 1)) && printf '\'','\''; done; printf '\'']}\n'\''; }
$ gen-type
{"type":"list","args":[]}
$ gen-type 1
{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":{"plain":0}}]}]}
$ gen-type 2
{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":{"plain":0}}]},{"type":"object","args":[{"name":"foo","type":{"plain":1}}]}]}
$ gen-type 32|json -Tc
$ gen-type 33|json -Tc
$ gen-type 512|json -Tc'
) -L 29.new <(
echo '$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@" 2>&1|sed -r '\''/error:/s|(/dev/fd/)[0-9]+|\1??|'\''; }'
json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@" 2>&1|sed -r '/error:/s|(/dev/fd/)[0-9]+|\1??|'; } 2>&1 ||
echo 'command failed: json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@" 2>&1|sed -r '\''/error:/s|(/dev/fd/)[0-9]+|\1??|'\''; }'

echo '$ set -o pipefail'
set -o pipefail 2>&1 ||
echo 'command failed: set -o pipefail'

echo '$ gen-type() { local n; [[ "$1" =~ ^[0-9]+$ ]] && n="$1" || n=0; printf '\''{"type":"list","args":['\''; local k; for((k=0; k<n; k++)); do printf '\''{"type":"object","args":[{"name":"foo","type":{"plain":%d}}]}'\'' $k; test "$k" -lt $((n - 1)) && printf '\'','\''; done; printf '\'']}\n'\''; }'
gen-type() { local n; [[ "$1" =~ ^[0-9]+$ ]] && n="$1" || n=0; printf '{"type":"list","args":['; local k; for((k=0; k<n; k++)); do printf '{"type":"object","args":[{"name":"foo","type":{"plain":%d}}]}' $k; test "$k" -lt $((n - 1)) && printf ','; done; printf ']}\n'; } 2>&1 ||
echo 'command failed: gen-type() { local n; [[ "$1" =~ ^[0-9]+$ ]] && n="$1" || n=0; printf '\''{"type":"list","args":['\''; local k; for((k=0; k<n; k++)); do printf '\''{"type":"object","args":[{"name":"foo","type":{"plain":%d}}]}'\'' $k; test "$k" -lt $((n - 1)) && printf '\'','\''; done; printf '\'']}\n'\''; }'

echo '$ gen-type'
gen-type 2>&1 ||
echo 'command failed: gen-type'

echo '$ gen-type 1'
gen-type 1 2>&1 ||
echo 'command failed: gen-type 1'

echo '$ gen-type 2'
gen-type 2 2>&1 ||
echo 'command failed: gen-type 2'

echo '$ gen-type 32|json -Tc'
gen-type 32|json -Tc 2>&1 ||
echo 'command failed: gen-type 32|json -Tc'

echo '$ gen-type 33|json -Tc'
gen-type 33|json -Tc 2>&1 ||
echo 'command failed: gen-type 33|json -Tc'

echo '$ gen-type 512|json -Tc'
gen-type 512|json -Tc 2>&1 ||
echo 'command failed: gen-type 512|json -Tc'
)

