#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -w63 -G type-lib
#

w=63
c=""
q=""

if [[ "$1" =~ ^-w[1-9][0-9]*$ ]]; then
    w="${1:2}"
    shift
fi
if [ "$1" == "-c" ]; then
    c="c"
    shift
fi
if [ "$1" == "-q" ]; then
    q="q"
fi

p=0
f=0

for t in \
    literal-value \
    object-value \
    array-value \
    array-value2 \
    type \
    plain \
    plain2 \
    name \
    name2 \
    name3 \
    name4 \
    object \
    open-array \
    closed-array \
    dict \
    dict2 \
    dict-dup \
    dict-expr-ascii \
    dict-expr-escape \
    dict-expr-const \
    dict-expr-keys \
    dict-expr-keys2 \
    dict-expr-keys3 \
    dict-expr-keys4 \
    dict-expr-keys5 \
    dict-expr-keys6 \
    dict-expr-keys7 \
    dict-expr-keys8 \
    dict-expr-keys9 \
    dict-expr-quote \
    dict-expr-attr \
    list \
    list-any-type \
    list-any-type2 \
    list-plain \
    list-plain2 \
    list-plain3 \
    list-empty-object \
    list-object \
    list-object-any-type \
    list-object-any-null \
    list-object-any-boolean \
    list-object-any-number \
    list-object-any-string \
    list-object-any-object \
    list-object-any-array \
    list-object-object \
    list-object-object2 \
    list-object-array \
    list-object-array2 \
    list-empty-closed-array \
    list-open-array-any-empty-closed-array \
    list-open-array-any-type-closed-array \
    list-open-array-any-null-closed-array \
    list-open-array-any-boolean-closed-array \
    list-open-array-any-number-closed-array \
    list-open-array-any-string-closed-array \
    list-open-array-any-object-closed-array \
    list-open-array-any-array-closed-array \
    list-open-array-object-closed-array \
    list-open-array-object2-closed-array \
    list-open-array-array-closed-array \
    list-open-array-array2-closed-array \
    list-closed-array-any-closed-array-any \
    list-closed-array-any-type-closed-array \
    list-closed-array-any-null-closed-array \
    list-closed-array-any-boolean-closed-array \
    list-closed-array-any-number-closed-array \
    list-closed-array-any-string-closed-array \
    list-closed-array-any-object-closed-array \
    list-closed-array-any-array-closed-array \
    list-closed-array-object-closed-array \
    list-closed-array-object2-closed-array \
    list-closed-array-array-closed-array \
    list-closed-array-array2-closed-array \
    list-open-array-any-type-closed-array-any-type \
    list-open-array-any-type-closed-array-any-null \
    list-open-array-any-type-closed-array-any-boolean \
    list-open-array-any-type-closed-array-any-number \
    list-open-array-any-type-closed-array-any-string \
    list-open-array-any-type-closed-array-any-object \
    list-open-array-any-type-closed-array-any-array \
    list-open-array-any-type-closed-array-object \
    list-open-array-any-type-closed-array-object2 \
    list-open-array-any-type-closed-array-array \
    list-open-array-any-type-closed-array-array2 \
    list-open-array-any-null-closed-array-any-type \
    list-open-array-any-null-closed-array-any-null \
    list-open-array-any-null-closed-array-any-boolean \
    list-open-array-any-null-closed-array-any-number \
    list-open-array-any-null-closed-array-any-string \
    list-open-array-any-null-closed-array-any-object \
    list-open-array-any-null-closed-array-any-array \
    list-open-array-any-null-closed-array-object \
    list-open-array-any-null-closed-array-object2 \
    list-open-array-any-null-closed-array-array \
    list-open-array-any-null-closed-array-array2 \
    list-open-array-any-boolean-closed-array-any-type \
    list-open-array-any-boolean-closed-array-any-null \
    list-open-array-any-boolean-closed-array-any-boolean \
    list-open-array-any-boolean-closed-array-any-number \
    list-open-array-any-boolean-closed-array-any-string \
    list-open-array-any-boolean-closed-array-any-object \
    list-open-array-any-boolean-closed-array-any-array \
    list-open-array-any-boolean-closed-array-object \
    list-open-array-any-boolean-closed-array-object2 \
    list-open-array-any-boolean-closed-array-array \
    list-open-array-any-boolean-closed-array-array2 \
    list-open-array-any-number-closed-array-any-type \
    list-open-array-any-number-closed-array-any-null \
    list-open-array-any-number-closed-array-any-boolean \
    list-open-array-any-number-closed-array-any-number \
    list-open-array-any-number-closed-array-any-string \
    list-open-array-any-number-closed-array-any-object \
    list-open-array-any-number-closed-array-any-array \
    list-open-array-any-number-closed-array-object \
    list-open-array-any-number-closed-array-object2 \
    list-open-array-any-number-closed-array-array \
    list-open-array-any-number-closed-array-array2 \
    list-open-array-any-string-closed-array-any-type \
    list-open-array-any-string-closed-array-any-null \
    list-open-array-any-string-closed-array-any-boolean \
    list-open-array-any-string-closed-array-any-number \
    list-open-array-any-string-closed-array-any-string \
    list-open-array-any-string-closed-array-any-object \
    list-open-array-any-string-closed-array-any-array \
    list-open-array-any-string-closed-array-object \
    list-open-array-any-string-closed-array-object2 \
    list-open-array-any-string-closed-array-array \
    list-open-array-any-string-closed-array-array2 \
    list-open-array-any-object-closed-array-any-type \
    list-open-array-any-object-closed-array-any-null \
    list-open-array-any-object-closed-array-any-boolean \
    list-open-array-any-object-closed-array-any-number \
    list-open-array-any-object-closed-array-any-string \
    list-open-array-any-object-closed-array-any-object \
    list-open-array-any-object-closed-array-any-array \
    list-open-array-any-object-closed-array-object \
    list-open-array-any-object-closed-array-object2 \
    list-open-array-any-object-closed-array-array \
    list-open-array-any-object-closed-array-array2 \
    list-open-array-any-array-closed-array-any-type \
    list-open-array-any-array-closed-array-any-null \
    list-open-array-any-array-closed-array-any-boolean \
    list-open-array-any-array-closed-array-any-number \
    list-open-array-any-array-closed-array-any-string \
    list-open-array-any-array-closed-array-any-object \
    list-open-array-any-array-closed-array-any-array \
    list-open-array-any-array-closed-array-object \
    list-open-array-any-array-closed-array-object2 \
    list-open-array-any-array-closed-array-array \
    list-open-array-any-array-closed-array-array2 \
    list-open-array-object-closed-array-any-type \
    list-open-array-object-closed-array-any-null \
    list-open-array-object-closed-array-any-boolean \
    list-open-array-object-closed-array-any-number \
    list-open-array-object-closed-array-any-string \
    list-open-array-object-closed-array-any-object \
    list-open-array-object-closed-array-any-array \
    list-open-array-object-closed-array-object \
    list-open-array-object-closed-array-object2 \
    list-open-array-object-closed-array-array \
    list-open-array-object-closed-array-array2 \
    list-open-array-object2-closed-array-any-type \
    list-open-array-object2-closed-array-any-null \
    list-open-array-object2-closed-array-any-boolean \
    list-open-array-object2-closed-array-any-number \
    list-open-array-object2-closed-array-any-string \
    list-open-array-object2-closed-array-any-object \
    list-open-array-object2-closed-array-any-array \
    list-open-array-object2-closed-array-object \
    list-open-array-object2-closed-array-object2 \
    list-open-array-object2-closed-array-array \
    list-open-array-object2-closed-array-array2 \
    list-open-array-array-closed-array-any-type \
    list-open-array-array-closed-array-any-null \
    list-open-array-array-closed-array-any-boolean \
    list-open-array-array-closed-array-any-number \
    list-open-array-array-closed-array-any-string \
    list-open-array-array-closed-array-any-object \
    list-open-array-array-closed-array-any-array \
    list-open-array-array-closed-array-object \
    list-open-array-array-closed-array-object2 \
    list-open-array-array-closed-array-array \
    list-open-array-array-closed-array-array2 \
    list-open-array-array2-closed-array-any-type \
    list-open-array-array2-closed-array-any-null \
    list-open-array-array2-closed-array-any-boolean \
    list-open-array-array2-closed-array-any-number \
    list-open-array-array2-closed-array-any-string \
    list-open-array-array2-closed-array-any-object \
    list-open-array-array2-closed-array-any-array \
    list-open-array-array2-closed-array-object \
    list-open-array-array2-closed-array-object2 \
    list-open-array-array2-closed-array-array \
    list-open-array-array2-closed-array-array2 \
    list-closed-array-any-type-closed-array-any-type \
    list-closed-array-any-type-closed-array-any-null \
    list-closed-array-any-type-closed-array-any-boolean \
    list-closed-array-any-type-closed-array-any-number \
    list-closed-array-any-type-closed-array-any-string \
    list-closed-array-any-type-closed-array-any-object \
    list-closed-array-any-type-closed-array-any-array \
    list-closed-array-any-type-closed-array-object \
    list-closed-array-any-type-closed-array-object2 \
    list-closed-array-any-type-closed-array-array \
    list-closed-array-any-type-closed-array-array2 \
    list-closed-array-any-null-closed-array-any-type \
    list-closed-array-any-null-closed-array-any-null \
    list-closed-array-any-null-closed-array-any-boolean \
    list-closed-array-any-null-closed-array-any-number \
    list-closed-array-any-null-closed-array-any-string \
    list-closed-array-any-null-closed-array-any-object \
    list-closed-array-any-null-closed-array-any-array \
    list-closed-array-any-null-closed-array-object \
    list-closed-array-any-null-closed-array-object2 \
    list-closed-array-any-null-closed-array-array \
    list-closed-array-any-null-closed-array-array2 \
    list-closed-array-any-boolean-closed-array-any-type \
    list-closed-array-any-boolean-closed-array-any-null \
    list-closed-array-any-boolean-closed-array-any-boolean \
    list-closed-array-any-boolean-closed-array-any-number \
    list-closed-array-any-boolean-closed-array-any-string \
    list-closed-array-any-boolean-closed-array-any-object \
    list-closed-array-any-boolean-closed-array-any-array \
    list-closed-array-any-boolean-closed-array-object \
    list-closed-array-any-boolean-closed-array-object2 \
    list-closed-array-any-boolean-closed-array-array \
    list-closed-array-any-boolean-closed-array-array2 \
    list-closed-array-any-number-closed-array-any-type \
    list-closed-array-any-number-closed-array-any-null \
    list-closed-array-any-number-closed-array-any-boolean \
    list-closed-array-any-number-closed-array-any-number \
    list-closed-array-any-number-closed-array-any-string \
    list-closed-array-any-number-closed-array-any-object \
    list-closed-array-any-number-closed-array-any-array \
    list-closed-array-any-number-closed-array-object \
    list-closed-array-any-number-closed-array-object2 \
    list-closed-array-any-number-closed-array-array \
    list-closed-array-any-number-closed-array-array2 \
    list-closed-array-any-string-closed-array-any-type \
    list-closed-array-any-string-closed-array-any-null \
    list-closed-array-any-string-closed-array-any-boolean \
    list-closed-array-any-string-closed-array-any-number \
    list-closed-array-any-string-closed-array-any-string \
    list-closed-array-any-string-closed-array-any-object \
    list-closed-array-any-string-closed-array-any-array \
    list-closed-array-any-string-closed-array-object \
    list-closed-array-any-string-closed-array-object2 \
    list-closed-array-any-string-closed-array-array \
    list-closed-array-any-string-closed-array-array2 \
    list-closed-array-any-object-closed-array-any-type \
    list-closed-array-any-object-closed-array-any-null \
    list-closed-array-any-object-closed-array-any-boolean \
    list-closed-array-any-object-closed-array-any-number \
    list-closed-array-any-object-closed-array-any-string \
    list-closed-array-any-object-closed-array-any-object \
    list-closed-array-any-object-closed-array-any-array \
    list-closed-array-any-object-closed-array-object \
    list-closed-array-any-object-closed-array-object2 \
    list-closed-array-any-object-closed-array-array \
    list-closed-array-any-object-closed-array-array2 \
    list-closed-array-any-array-closed-array-any-type \
    list-closed-array-any-array-closed-array-any-null \
    list-closed-array-any-array-closed-array-any-boolean \
    list-closed-array-any-array-closed-array-any-number \
    list-closed-array-any-array-closed-array-any-string \
    list-closed-array-any-array-closed-array-any-object \
    list-closed-array-any-array-closed-array-any-array \
    list-closed-array-any-array-closed-array-object \
    list-closed-array-any-array-closed-array-object2 \
    list-closed-array-any-array-closed-array-array \
    list-closed-array-any-array-closed-array-array2 \
    list-closed-array-object-closed-array-any-type \
    list-closed-array-object-closed-array-any-null \
    list-closed-array-object-closed-array-any-boolean \
    list-closed-array-object-closed-array-any-number \
    list-closed-array-object-closed-array-any-string \
    list-closed-array-object-closed-array-any-object \
    list-closed-array-object-closed-array-any-array \
    list-closed-array-object-closed-array-object \
    list-closed-array-object-closed-array-object2 \
    list-closed-array-object-closed-array-array \
    list-closed-array-object-closed-array-array2 \
    list-closed-array-object2-closed-array-any-type \
    list-closed-array-object2-closed-array-any-null \
    list-closed-array-object2-closed-array-any-boolean \
    list-closed-array-object2-closed-array-any-number \
    list-closed-array-object2-closed-array-any-string \
    list-closed-array-object2-closed-array-any-object \
    list-closed-array-object2-closed-array-any-array \
    list-closed-array-object2-closed-array-object \
    list-closed-array-object2-closed-array-object2 \
    list-closed-array-object2-closed-array-array \
    list-closed-array-object2-closed-array-array2 \
    list-closed-array-array-closed-array-any-type \
    list-closed-array-array-closed-array-any-null \
    list-closed-array-array-closed-array-any-boolean \
    list-closed-array-array-closed-array-any-number \
    list-closed-array-array-closed-array-any-string \
    list-closed-array-array-closed-array-any-object \
    list-closed-array-array-closed-array-any-array \
    list-closed-array-array-closed-array-object \
    list-closed-array-array-closed-array-object2 \
    list-closed-array-array-closed-array-array \
    list-closed-array-array-closed-array-array2 \
    list-closed-array-array2-closed-array-any-type \
    list-closed-array-array2-closed-array-any-null \
    list-closed-array-array2-closed-array-any-boolean \
    list-closed-array-array2-closed-array-any-number \
    list-closed-array-array2-closed-array-any-string \
    list-closed-array-array2-closed-array-any-object \
    list-closed-array-array2-closed-array-any-array \
    list-closed-array-array2-closed-array-object \
    list-closed-array-array2-closed-array-object2 \
    list-closed-array-array2-closed-array-array \
    list-closed-array-array2-closed-array-array2 \
    list-closed-array-empty-open-array-any \
    list-list \
    list-dict \
    list-dup \
    obj-type-first-key \
    obj-type-name \
    obj-type-basic \
    obj-type-basic2 \
    obj-type-basic3 \
    json-type \
    text-type-lib \
    sobj-type-lib
do
    test -z "$q" &&
    printf >&2 "%-$((w + 6))s " "test: type-lib:$t"
    if ! type-lib/test-$t.sh &>/dev/null; then
        (( f ++ ))

        test -n "$q" &&
        echo >&2 -n "test: type-lib:$t "
        echo >&2 failed
    else
        (( p ++ ))

        test -z "$q" &&
        echo >&2 OK
    fi
done

if [ -z "$c" ]; then
    [ -z "$q" -o "$f" -gt 0 ] &&
    echo >&2
    echo "tests passed: $p"
    echo "tests failed: $f"
else
    echo "$p"
    echo "$f"
fi

exit $(( f != 0 ))

