#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -p litex -C lib:multi-obj
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L multi-obj.old <(echo \
'$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"
$ json-litex() { set -o pipefail && LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value -VF -- ../lib/json-litex.so -A "$@"|sed -r '\''s/"size":[0-9]+,"bytes":\["[0-9a-f]+"(,"[0-9a-f]+")*\]//;s/("lookup":"0x)[0-9a-f]+(")/\1...\2/g'\''|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }
$ json-litex -d '\''[{"a":"`x`"},{"b":"`y`"}]'\''
json: error: <text>:1:14: filter library: attribute error: invalid array: multiple inner objects (previous defined at 1:2)
json: error: <text>:1:14: [{"a":"`x`"},{"b":"`y`"}]
json: error: <text>:1:14:              ^
command failed: json-litex -d '\''[{"a":"`x`"},{"b":"`y`"}]'\''
$ json-litex -d '\''{"foo":[{"a":"`x`"},{"b":"`y`"}]}'\''
json: error: <text>:1:21: filter library: attribute error: invalid array: multiple inner objects (previous defined at 1:9)
json: error: <text>:1:21: {"foo":[{"a":"`x`"},{"b":"`y`"}]}
json: error: <text>:1:21:                     ^
command failed: json-litex -d '\''{"foo":[{"a":"`x`"},{"b":"`y`"}]}'\''
$ json-litex -d '\''{"bar":{"foo":[{"a":"`x`"},{"b":"`y`"}]}}'\''
json: error: <text>:1:28: filter library: attribute error: invalid array: multiple inner objects (previous defined at 1:16)
json: error: <text>:1:28: {"bar":{"foo":[{"a":"`x`"},{"b":"`y`"}]}}
json: error: <text>:1:28:                            ^
command failed: json-litex -d '\''{"bar":{"foo":[{"a":"`x`"},{"b":"`y`"}]}}'\''
$ json-litex -d '\''[{"foo":[{"a":"`x`"},{"b":"`y`"}]}]'\''
json: error: <text>:1:22: filter library: attribute error: invalid array: multiple inner objects (previous defined at 1:10)
json: error: <text>:1:22: [{"foo":[{"a":"`x`"},{"b":"`y`"}]}]
json: error: <text>:1:22:                      ^
command failed: json-litex -d '\''[{"foo":[{"a":"`x`"},{"b":"`y`"}]}]'\''
$ json-litex -d '\''{"baz":{"bar":{"foo":[{"a":"`x`"},{"b":"`y`"}]}}}'\''
json: error: <text>:1:35: filter library: attribute error: invalid array: multiple inner objects (previous defined at 1:23)
json: error: <text>:1:35: baz":{"bar":{"foo":[{"a":"`x`"},{"b":"`y`"}]}}}
json: error: <text>:1:35:                                 ^
command failed: json-litex -d '\''{"baz":{"bar":{"foo":[{"a":"`x`"},{"b":"`y`"}]}}}'\''
$ json-litex -d '\''{"baz":[{"foo":[{"a":"`x`"},{"b":"`y`"}]}]}'\''
json: error: <text>:1:29: filter library: attribute error: invalid array: multiple inner objects (previous defined at 1:17)
json: error: <text>:1:29: {"baz":[{"foo":[{"a":"`x`"},{"b":"`y`"}]}]}
json: error: <text>:1:29:                             ^
command failed: json-litex -d '\''{"baz":[{"foo":[{"a":"`x`"},{"b":"`y`"}]}]}'\''
$ json-litex -d '\''[{"bar":{"foo":[{"a":"`x`"},{"b":"`y`"}]}}]'\''
json: error: <text>:1:29: filter library: attribute error: invalid array: multiple inner objects (previous defined at 1:17)
json: error: <text>:1:29: [{"bar":{"foo":[{"a":"`x`"},{"b":"`y`"}]}}]
json: error: <text>:1:29:                             ^
command failed: json-litex -d '\''[{"bar":{"foo":[{"a":"`x`"},{"b":"`y`"}]}}]'\''
$ json-litex -d '\''["c",{"a":"`x`"},{"b":"`y`"}]'\''
json: error: <text>:1:18: filter library: attribute error: invalid array: multiple inner objects (previous defined at 1:6)
json: error: <text>:1:18: ["c",{"a":"`x`"},{"b":"`y`"}]
json: error: <text>:1:18:                  ^
command failed: json-litex -d '\''["c",{"a":"`x`"},{"b":"`y`"}]'\''
$ json-litex -d '\''{"foo":["c",{"a":"`x`"},{"b":"`y`"}]}'\''
json: error: <text>:1:25: filter library: attribute error: invalid array: multiple inner objects (previous defined at 1:13)
json: error: <text>:1:25: {"foo":["c",{"a":"`x`"},{"b":"`y`"}]}
json: error: <text>:1:25:                         ^
command failed: json-litex -d '\''{"foo":["c",{"a":"`x`"},{"b":"`y`"}]}'\''
$ json-litex -d '\''{"bar":{"foo":["c",{"a":"`x`"},{"b":"`y`"}]}}'\''
json: error: <text>:1:32: filter library: attribute error: invalid array: multiple inner objects (previous defined at 1:20)
json: error: <text>:1:32: {"bar":{"foo":["c",{"a":"`x`"},{"b":"`y`"}]}}
json: error: <text>:1:32:                                ^
command failed: json-litex -d '\''{"bar":{"foo":["c",{"a":"`x`"},{"b":"`y`"}]}}'\''
$ json-litex -d '\''[{"foo":["c",{"a":"`x`"},{"b":"`y`"}]}]'\''
json: error: <text>:1:26: filter library: attribute error: invalid array: multiple inner objects (previous defined at 1:14)
json: error: <text>:1:26: [{"foo":["c",{"a":"`x`"},{"b":"`y`"}]}]
json: error: <text>:1:26:                          ^
command failed: json-litex -d '\''[{"foo":["c",{"a":"`x`"},{"b":"`y`"}]}]'\''
$ json-litex -d '\''{"baz":{"bar":{"foo":["c",{"a":"`x`"},{"b":"`y`"}]}}}'\''
json: error: <text>:1:39: filter library: attribute error: invalid array: multiple inner objects (previous defined at 1:27)
json: error: <text>:1:39: :{"bar":{"foo":["c",{"a":"`x`"},{"b":"`y`"}]}}}
json: error: <text>:1:39:                                 ^
command failed: json-litex -d '\''{"baz":{"bar":{"foo":["c",{"a":"`x`"},{"b":"`y`"}]}}}'\''
$ json-litex -d '\''{"baz":[{"foo":["c",{"a":"`x`"},{"b":"`y`"}]}]}'\''
json: error: <text>:1:33: filter library: attribute error: invalid array: multiple inner objects (previous defined at 1:21)
json: error: <text>:1:33: {"baz":[{"foo":["c",{"a":"`x`"},{"b":"`y`"}]}]}
json: error: <text>:1:33:                                 ^
command failed: json-litex -d '\''{"baz":[{"foo":["c",{"a":"`x`"},{"b":"`y`"}]}]}'\''
$ json-litex -d '\''[{"bar":{"foo":["c",{"a":"`x`"},{"b":"`y`"}]}}]'\''
json: error: <text>:1:33: filter library: attribute error: invalid array: multiple inner objects (previous defined at 1:21)
json: error: <text>:1:33: [{"bar":{"foo":["c",{"a":"`x`"},{"b":"`y`"}]}}]
json: error: <text>:1:33:                                 ^
command failed: json-litex -d '\''[{"bar":{"foo":["c",{"a":"`x`"},{"b":"`y`"}]}}]'\''
$ json-litex -d '\''[{"a":"`x`"},"c",{"b":"`y`"}]'\''
json: error: <text>:1:18: filter library: attribute error: invalid array: multiple inner objects (previous defined at 1:2)
json: error: <text>:1:18: [{"a":"`x`"},"c",{"b":"`y`"}]
json: error: <text>:1:18:                  ^
command failed: json-litex -d '\''[{"a":"`x`"},"c",{"b":"`y`"}]'\''
$ json-litex -d '\''{"foo":[{"a":"`x`"},"c",{"b":"`y`"}]}'\''
json: error: <text>:1:25: filter library: attribute error: invalid array: multiple inner objects (previous defined at 1:9)
json: error: <text>:1:25: {"foo":[{"a":"`x`"},"c",{"b":"`y`"}]}
json: error: <text>:1:25:                         ^
command failed: json-litex -d '\''{"foo":[{"a":"`x`"},"c",{"b":"`y`"}]}'\''
$ json-litex -d '\''{"bar":{"foo":[{"a":"`x`"},"c",{"b":"`y`"}]}}'\''
json: error: <text>:1:32: filter library: attribute error: invalid array: multiple inner objects (previous defined at 1:16)
json: error: <text>:1:32: {"bar":{"foo":[{"a":"`x`"},"c",{"b":"`y`"}]}}
json: error: <text>:1:32:                                ^
command failed: json-litex -d '\''{"bar":{"foo":[{"a":"`x`"},"c",{"b":"`y`"}]}}'\''
$ json-litex -d '\''[{"foo":[{"a":"`x`"},"c",{"b":"`y`"}]}]'\''
json: error: <text>:1:26: filter library: attribute error: invalid array: multiple inner objects (previous defined at 1:10)
json: error: <text>:1:26: [{"foo":[{"a":"`x`"},"c",{"b":"`y`"}]}]
json: error: <text>:1:26:                          ^
command failed: json-litex -d '\''[{"foo":[{"a":"`x`"},"c",{"b":"`y`"}]}]'\''
$ json-litex -d '\''{"baz":{"bar":{"foo":[{"a":"`x`"},"c",{"b":"`y`"}]}}}'\''
json: error: <text>:1:39: filter library: attribute error: invalid array: multiple inner objects (previous defined at 1:23)
json: error: <text>:1:39: :{"bar":{"foo":[{"a":"`x`"},"c",{"b":"`y`"}]}}}
json: error: <text>:1:39:                                 ^
command failed: json-litex -d '\''{"baz":{"bar":{"foo":[{"a":"`x`"},"c",{"b":"`y`"}]}}}'\''
$ json-litex -d '\''{"baz":[{"foo":[{"a":"`x`"},"c",{"b":"`y`"}]}]}'\''
json: error: <text>:1:33: filter library: attribute error: invalid array: multiple inner objects (previous defined at 1:17)
json: error: <text>:1:33: {"baz":[{"foo":[{"a":"`x`"},"c",{"b":"`y`"}]}]}
json: error: <text>:1:33:                                 ^
command failed: json-litex -d '\''{"baz":[{"foo":[{"a":"`x`"},"c",{"b":"`y`"}]}]}'\''
$ json-litex -d '\''[{"bar":{"foo":[{"a":"`x`"},"c",{"b":"`y`"}]}}]'\''
json: error: <text>:1:33: filter library: attribute error: invalid array: multiple inner objects (previous defined at 1:17)
json: error: <text>:1:33: [{"bar":{"foo":[{"a":"`x`"},"c",{"b":"`y`"}]}}]
json: error: <text>:1:33:                                 ^
command failed: json-litex -d '\''[{"bar":{"foo":[{"a":"`x`"},"c",{"b":"`y`"}]}}]'\''
$ json-litex -d '\''[{"a":"`x`"},{"b":"`y`"},"c"]'\''
json: error: <text>:1:14: filter library: attribute error: invalid array: multiple inner objects (previous defined at 1:2)
json: error: <text>:1:14: [{"a":"`x`"},{"b":"`y`"},"c"]
json: error: <text>:1:14:              ^
command failed: json-litex -d '\''[{"a":"`x`"},{"b":"`y`"},"c"]'\''
$ json-litex -d '\''{"foo":[{"a":"`x`"},{"b":"`y`"},"c"]}'\''
json: error: <text>:1:21: filter library: attribute error: invalid array: multiple inner objects (previous defined at 1:9)
json: error: <text>:1:21: {"foo":[{"a":"`x`"},{"b":"`y`"},"c"]}
json: error: <text>:1:21:                     ^
command failed: json-litex -d '\''{"foo":[{"a":"`x`"},{"b":"`y`"},"c"]}'\''
$ json-litex -d '\''{"bar":{"foo":[{"a":"`x`"},{"b":"`y`"},"c"]}}'\''
json: error: <text>:1:28: filter library: attribute error: invalid array: multiple inner objects (previous defined at 1:16)
json: error: <text>:1:28: {"bar":{"foo":[{"a":"`x`"},{"b":"`y`"},"c"]}}
json: error: <text>:1:28:                            ^
command failed: json-litex -d '\''{"bar":{"foo":[{"a":"`x`"},{"b":"`y`"},"c"]}}'\''
$ json-litex -d '\''[{"foo":[{"a":"`x`"},{"b":"`y`"},"c"]}]'\''
json: error: <text>:1:22: filter library: attribute error: invalid array: multiple inner objects (previous defined at 1:10)
json: error: <text>:1:22: [{"foo":[{"a":"`x`"},{"b":"`y`"},"c"]}]
json: error: <text>:1:22:                      ^
command failed: json-litex -d '\''[{"foo":[{"a":"`x`"},{"b":"`y`"},"c"]}]'\''
$ json-litex -d '\''{"baz":{"bar":{"foo":[{"a":"`x`"},{"b":"`y`"},"c"]}}}'\''
json: error: <text>:1:35: filter library: attribute error: invalid array: multiple inner objects (previous defined at 1:23)
json: error: <text>:1:35: baz":{"bar":{"foo":[{"a":"`x`"},{"b":"`y`"},"c"]}}}
json: error: <text>:1:35:                                 ^
command failed: json-litex -d '\''{"baz":{"bar":{"foo":[{"a":"`x`"},{"b":"`y`"},"c"]}}}'\''
$ json-litex -d '\''{"baz":[{"foo":[{"a":"`x`"},{"b":"`y`"},"c"]}]}'\''
json: error: <text>:1:29: filter library: attribute error: invalid array: multiple inner objects (previous defined at 1:17)
json: error: <text>:1:29: {"baz":[{"foo":[{"a":"`x`"},{"b":"`y`"},"c"]}]}
json: error: <text>:1:29:                             ^
command failed: json-litex -d '\''{"baz":[{"foo":[{"a":"`x`"},{"b":"`y`"},"c"]}]}'\''
$ json-litex -d '\''[{"bar":{"foo":[{"a":"`x`"},{"b":"`y`"},"c"]}}]'\''
json: error: <text>:1:29: filter library: attribute error: invalid array: multiple inner objects (previous defined at 1:17)
json: error: <text>:1:29: [{"bar":{"foo":[{"a":"`x`"},{"b":"`y`"},"c"]}}]
json: error: <text>:1:29:                             ^
command failed: json-litex -d '\''[{"bar":{"foo":[{"a":"`x`"},{"b":"`y`"},"c"]}}]'\'''
) -L multi-obj.new <(
echo '$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'
[ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib" 2>&1 ||
echo 'command failed: [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'

echo '$ json-litex() { set -o pipefail && LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value -VF -- ../lib/json-litex.so -A "$@"|sed -r '\''s/"size":[0-9]+,"bytes":\["[0-9a-f]+"(,"[0-9a-f]+")*\]//;s/("lookup":"0x)[0-9a-f]+(")/\1...\2/g'\''|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }'
json-litex() { set -o pipefail && LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value -VF -- ../lib/json-litex.so -A "$@"|sed -r 's/"size":[0-9]+,"bytes":\["[0-9a-f]+"(,"[0-9a-f]+")*\]//;s/("lookup":"0x)[0-9a-f]+(")/\1...\2/g'|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; } 2>&1 ||
echo 'command failed: json-litex() { set -o pipefail && LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value -VF -- ../lib/json-litex.so -A "$@"|sed -r '\''s/"size":[0-9]+,"bytes":\["[0-9a-f]+"(,"[0-9a-f]+")*\]//;s/("lookup":"0x)[0-9a-f]+(")/\1...\2/g'\''|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }'

echo '$ json-litex -d '\''[{"a":"`x`"},{"b":"`y`"}]'\'''
json-litex -d '[{"a":"`x`"},{"b":"`y`"}]' 2>&1 ||
echo 'command failed: json-litex -d '\''[{"a":"`x`"},{"b":"`y`"}]'\'''

echo '$ json-litex -d '\''{"foo":[{"a":"`x`"},{"b":"`y`"}]}'\'''
json-litex -d '{"foo":[{"a":"`x`"},{"b":"`y`"}]}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"foo":[{"a":"`x`"},{"b":"`y`"}]}'\'''

echo '$ json-litex -d '\''{"bar":{"foo":[{"a":"`x`"},{"b":"`y`"}]}}'\'''
json-litex -d '{"bar":{"foo":[{"a":"`x`"},{"b":"`y`"}]}}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"bar":{"foo":[{"a":"`x`"},{"b":"`y`"}]}}'\'''

echo '$ json-litex -d '\''[{"foo":[{"a":"`x`"},{"b":"`y`"}]}]'\'''
json-litex -d '[{"foo":[{"a":"`x`"},{"b":"`y`"}]}]' 2>&1 ||
echo 'command failed: json-litex -d '\''[{"foo":[{"a":"`x`"},{"b":"`y`"}]}]'\'''

echo '$ json-litex -d '\''{"baz":{"bar":{"foo":[{"a":"`x`"},{"b":"`y`"}]}}}'\'''
json-litex -d '{"baz":{"bar":{"foo":[{"a":"`x`"},{"b":"`y`"}]}}}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"baz":{"bar":{"foo":[{"a":"`x`"},{"b":"`y`"}]}}}'\'''

echo '$ json-litex -d '\''{"baz":[{"foo":[{"a":"`x`"},{"b":"`y`"}]}]}'\'''
json-litex -d '{"baz":[{"foo":[{"a":"`x`"},{"b":"`y`"}]}]}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"baz":[{"foo":[{"a":"`x`"},{"b":"`y`"}]}]}'\'''

echo '$ json-litex -d '\''[{"bar":{"foo":[{"a":"`x`"},{"b":"`y`"}]}}]'\'''
json-litex -d '[{"bar":{"foo":[{"a":"`x`"},{"b":"`y`"}]}}]' 2>&1 ||
echo 'command failed: json-litex -d '\''[{"bar":{"foo":[{"a":"`x`"},{"b":"`y`"}]}}]'\'''

echo '$ json-litex -d '\''["c",{"a":"`x`"},{"b":"`y`"}]'\'''
json-litex -d '["c",{"a":"`x`"},{"b":"`y`"}]' 2>&1 ||
echo 'command failed: json-litex -d '\''["c",{"a":"`x`"},{"b":"`y`"}]'\'''

echo '$ json-litex -d '\''{"foo":["c",{"a":"`x`"},{"b":"`y`"}]}'\'''
json-litex -d '{"foo":["c",{"a":"`x`"},{"b":"`y`"}]}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"foo":["c",{"a":"`x`"},{"b":"`y`"}]}'\'''

echo '$ json-litex -d '\''{"bar":{"foo":["c",{"a":"`x`"},{"b":"`y`"}]}}'\'''
json-litex -d '{"bar":{"foo":["c",{"a":"`x`"},{"b":"`y`"}]}}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"bar":{"foo":["c",{"a":"`x`"},{"b":"`y`"}]}}'\'''

echo '$ json-litex -d '\''[{"foo":["c",{"a":"`x`"},{"b":"`y`"}]}]'\'''
json-litex -d '[{"foo":["c",{"a":"`x`"},{"b":"`y`"}]}]' 2>&1 ||
echo 'command failed: json-litex -d '\''[{"foo":["c",{"a":"`x`"},{"b":"`y`"}]}]'\'''

echo '$ json-litex -d '\''{"baz":{"bar":{"foo":["c",{"a":"`x`"},{"b":"`y`"}]}}}'\'''
json-litex -d '{"baz":{"bar":{"foo":["c",{"a":"`x`"},{"b":"`y`"}]}}}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"baz":{"bar":{"foo":["c",{"a":"`x`"},{"b":"`y`"}]}}}'\'''

echo '$ json-litex -d '\''{"baz":[{"foo":["c",{"a":"`x`"},{"b":"`y`"}]}]}'\'''
json-litex -d '{"baz":[{"foo":["c",{"a":"`x`"},{"b":"`y`"}]}]}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"baz":[{"foo":["c",{"a":"`x`"},{"b":"`y`"}]}]}'\'''

echo '$ json-litex -d '\''[{"bar":{"foo":["c",{"a":"`x`"},{"b":"`y`"}]}}]'\'''
json-litex -d '[{"bar":{"foo":["c",{"a":"`x`"},{"b":"`y`"}]}}]' 2>&1 ||
echo 'command failed: json-litex -d '\''[{"bar":{"foo":["c",{"a":"`x`"},{"b":"`y`"}]}}]'\'''

echo '$ json-litex -d '\''[{"a":"`x`"},"c",{"b":"`y`"}]'\'''
json-litex -d '[{"a":"`x`"},"c",{"b":"`y`"}]' 2>&1 ||
echo 'command failed: json-litex -d '\''[{"a":"`x`"},"c",{"b":"`y`"}]'\'''

echo '$ json-litex -d '\''{"foo":[{"a":"`x`"},"c",{"b":"`y`"}]}'\'''
json-litex -d '{"foo":[{"a":"`x`"},"c",{"b":"`y`"}]}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"foo":[{"a":"`x`"},"c",{"b":"`y`"}]}'\'''

echo '$ json-litex -d '\''{"bar":{"foo":[{"a":"`x`"},"c",{"b":"`y`"}]}}'\'''
json-litex -d '{"bar":{"foo":[{"a":"`x`"},"c",{"b":"`y`"}]}}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"bar":{"foo":[{"a":"`x`"},"c",{"b":"`y`"}]}}'\'''

echo '$ json-litex -d '\''[{"foo":[{"a":"`x`"},"c",{"b":"`y`"}]}]'\'''
json-litex -d '[{"foo":[{"a":"`x`"},"c",{"b":"`y`"}]}]' 2>&1 ||
echo 'command failed: json-litex -d '\''[{"foo":[{"a":"`x`"},"c",{"b":"`y`"}]}]'\'''

echo '$ json-litex -d '\''{"baz":{"bar":{"foo":[{"a":"`x`"},"c",{"b":"`y`"}]}}}'\'''
json-litex -d '{"baz":{"bar":{"foo":[{"a":"`x`"},"c",{"b":"`y`"}]}}}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"baz":{"bar":{"foo":[{"a":"`x`"},"c",{"b":"`y`"}]}}}'\'''

echo '$ json-litex -d '\''{"baz":[{"foo":[{"a":"`x`"},"c",{"b":"`y`"}]}]}'\'''
json-litex -d '{"baz":[{"foo":[{"a":"`x`"},"c",{"b":"`y`"}]}]}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"baz":[{"foo":[{"a":"`x`"},"c",{"b":"`y`"}]}]}'\'''

echo '$ json-litex -d '\''[{"bar":{"foo":[{"a":"`x`"},"c",{"b":"`y`"}]}}]'\'''
json-litex -d '[{"bar":{"foo":[{"a":"`x`"},"c",{"b":"`y`"}]}}]' 2>&1 ||
echo 'command failed: json-litex -d '\''[{"bar":{"foo":[{"a":"`x`"},"c",{"b":"`y`"}]}}]'\'''

echo '$ json-litex -d '\''[{"a":"`x`"},{"b":"`y`"},"c"]'\'''
json-litex -d '[{"a":"`x`"},{"b":"`y`"},"c"]' 2>&1 ||
echo 'command failed: json-litex -d '\''[{"a":"`x`"},{"b":"`y`"},"c"]'\'''

echo '$ json-litex -d '\''{"foo":[{"a":"`x`"},{"b":"`y`"},"c"]}'\'''
json-litex -d '{"foo":[{"a":"`x`"},{"b":"`y`"},"c"]}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"foo":[{"a":"`x`"},{"b":"`y`"},"c"]}'\'''

echo '$ json-litex -d '\''{"bar":{"foo":[{"a":"`x`"},{"b":"`y`"},"c"]}}'\'''
json-litex -d '{"bar":{"foo":[{"a":"`x`"},{"b":"`y`"},"c"]}}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"bar":{"foo":[{"a":"`x`"},{"b":"`y`"},"c"]}}'\'''

echo '$ json-litex -d '\''[{"foo":[{"a":"`x`"},{"b":"`y`"},"c"]}]'\'''
json-litex -d '[{"foo":[{"a":"`x`"},{"b":"`y`"},"c"]}]' 2>&1 ||
echo 'command failed: json-litex -d '\''[{"foo":[{"a":"`x`"},{"b":"`y`"},"c"]}]'\'''

echo '$ json-litex -d '\''{"baz":{"bar":{"foo":[{"a":"`x`"},{"b":"`y`"},"c"]}}}'\'''
json-litex -d '{"baz":{"bar":{"foo":[{"a":"`x`"},{"b":"`y`"},"c"]}}}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"baz":{"bar":{"foo":[{"a":"`x`"},{"b":"`y`"},"c"]}}}'\'''

echo '$ json-litex -d '\''{"baz":[{"foo":[{"a":"`x`"},{"b":"`y`"},"c"]}]}'\'''
json-litex -d '{"baz":[{"foo":[{"a":"`x`"},{"b":"`y`"},"c"]}]}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"baz":[{"foo":[{"a":"`x`"},{"b":"`y`"},"c"]}]}'\'''

echo '$ json-litex -d '\''[{"bar":{"foo":[{"a":"`x`"},{"b":"`y`"},"c"]}}]'\'''
json-litex -d '[{"bar":{"foo":[{"a":"`x`"},{"b":"`y`"},"c"]}}]' 2>&1 ||
echo 'command failed: json-litex -d '\''[{"bar":{"foo":[{"a":"`x`"},{"b":"`y`"},"c"]}}]'\'''
)

