#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -p litex -C lib:dup-key
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L dup-key.old <(echo \
'$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"
$ json-litex() { set -o pipefail && LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value -VF -- ../lib/json-litex.so -A "$@"|sed -r '\''s/"size":[0-9]+,"bytes":\["[0-9a-f]+"(,"[0-9a-f]+")*\]//;s/("lookup":"0x)[0-9a-f]+(")/\1...\2/g'\''|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }
$ json-litex -d '\''{"a":"`x`","a":"`y`"}'\''
json: error: <text>:1:12: filter library: attribute error: invalid object: duplicated key name (previous defined at 1:2)
json: error: <text>:1:12: {"a":"`x`","a":"`y`"}
json: error: <text>:1:12:            ^
command failed: json-litex -d '\''{"a":"`x`","a":"`y`"}'\''
$ json-litex -d '\''{"foo":{"a":"`x`","a":"`y`"}}'\''
json: error: <text>:1:19: filter library: attribute error: invalid object: duplicated key name (previous defined at 1:9)
json: error: <text>:1:19: {"foo":{"a":"`x`","a":"`y`"}}
json: error: <text>:1:19:                   ^
command failed: json-litex -d '\''{"foo":{"a":"`x`","a":"`y`"}}'\''
$ json-litex -d '\''[{"a":"`x`","a":"`y`"}]'\''
json: error: <text>:1:13: filter library: attribute error: invalid object: duplicated key name (previous defined at 1:3)
json: error: <text>:1:13: [{"a":"`x`","a":"`y`"}]
json: error: <text>:1:13:             ^
command failed: json-litex -d '\''[{"a":"`x`","a":"`y`"}]'\''
$ json-litex -d '\''{"bar":{"foo":{"a":"`x`","a":"`y`"}}}'\''
json: error: <text>:1:26: filter library: attribute error: invalid object: duplicated key name (previous defined at 1:16)
json: error: <text>:1:26: {"bar":{"foo":{"a":"`x`","a":"`y`"}}}
json: error: <text>:1:26:                          ^
command failed: json-litex -d '\''{"bar":{"foo":{"a":"`x`","a":"`y`"}}}'\''
$ json-litex -d '\''{"bar":[{"a":"`x`","a":"`y`"}]}'\''
json: error: <text>:1:20: filter library: attribute error: invalid object: duplicated key name (previous defined at 1:10)
json: error: <text>:1:20: {"bar":[{"a":"`x`","a":"`y`"}]}
json: error: <text>:1:20:                    ^
command failed: json-litex -d '\''{"bar":[{"a":"`x`","a":"`y`"}]}'\''
$ json-litex -d '\''[{"foo":{"a":"`x`","a":"`y`"}}]'\''
json: error: <text>:1:20: filter library: attribute error: invalid object: duplicated key name (previous defined at 1:10)
json: error: <text>:1:20: [{"foo":{"a":"`x`","a":"`y`"}}]
json: error: <text>:1:20:                    ^
command failed: json-litex -d '\''[{"foo":{"a":"`x`","a":"`y`"}}]'\''
$ json-litex -d '\''{"baz":{"bar":{"foo":{"a":"`x`","a":"`y`"}}}}'\''
json: error: <text>:1:33: filter library: attribute error: invalid object: duplicated key name (previous defined at 1:23)
json: error: <text>:1:33: {"baz":{"bar":{"foo":{"a":"`x`","a":"`y`"}}}}
json: error: <text>:1:33:                                 ^
command failed: json-litex -d '\''{"baz":{"bar":{"foo":{"a":"`x`","a":"`y`"}}}}'\''
$ json-litex -d '\''{"baz":{"bar":[{"a":"`x`","a":"`y`"}]}}'\''
json: error: <text>:1:27: filter library: attribute error: invalid object: duplicated key name (previous defined at 1:17)
json: error: <text>:1:27: {"baz":{"bar":[{"a":"`x`","a":"`y`"}]}}
json: error: <text>:1:27:                           ^
command failed: json-litex -d '\''{"baz":{"bar":[{"a":"`x`","a":"`y`"}]}}'\''
$ json-litex -d '\''{"baz":[{"foo":{"a":"`x`","a":"`y`"}}]}'\''
json: error: <text>:1:27: filter library: attribute error: invalid object: duplicated key name (previous defined at 1:17)
json: error: <text>:1:27: {"baz":[{"foo":{"a":"`x`","a":"`y`"}}]}
json: error: <text>:1:27:                           ^
command failed: json-litex -d '\''{"baz":[{"foo":{"a":"`x`","a":"`y`"}}]}'\''
$ json-litex -d '\''[{"bar":{"foo":{"a":"`x`","a":"`y`"}}}]'\''
json: error: <text>:1:27: filter library: attribute error: invalid object: duplicated key name (previous defined at 1:17)
json: error: <text>:1:27: [{"bar":{"foo":{"a":"`x`","a":"`y`"}}}]
json: error: <text>:1:27:                           ^
command failed: json-litex -d '\''[{"bar":{"foo":{"a":"`x`","a":"`y`"}}}]'\''
$ json-litex -d '\''[{"bar":[{"a":"`x`","a":"`y`"}]}]'\''
json: error: <text>:1:21: filter library: attribute error: invalid object: duplicated key name (previous defined at 1:11)
json: error: <text>:1:21: [{"bar":[{"a":"`x`","a":"`y`"}]}]
json: error: <text>:1:21:                     ^
command failed: json-litex -d '\''[{"bar":[{"a":"`x`","a":"`y`"}]}]'\''
$ json-litex -d '\''{"b":"`z`","a":"`x`","a":"`y`"}'\''
json: error: <text>:1:22: filter library: attribute error: invalid object: duplicated key name (previous defined at 1:12)
json: error: <text>:1:22: {"b":"`z`","a":"`x`","a":"`y`"}
json: error: <text>:1:22:                      ^
command failed: json-litex -d '\''{"b":"`z`","a":"`x`","a":"`y`"}'\''
$ json-litex -d '\''{"foo":{"b":"`z`","a":"`x`","a":"`y`"}}'\''
json: error: <text>:1:29: filter library: attribute error: invalid object: duplicated key name (previous defined at 1:19)
json: error: <text>:1:29: {"foo":{"b":"`z`","a":"`x`","a":"`y`"}}
json: error: <text>:1:29:                             ^
command failed: json-litex -d '\''{"foo":{"b":"`z`","a":"`x`","a":"`y`"}}'\''
$ json-litex -d '\''[{"b":"`z`","a":"`x`","a":"`y`"}]'\''
json: error: <text>:1:23: filter library: attribute error: invalid object: duplicated key name (previous defined at 1:13)
json: error: <text>:1:23: [{"b":"`z`","a":"`x`","a":"`y`"}]
json: error: <text>:1:23:                       ^
command failed: json-litex -d '\''[{"b":"`z`","a":"`x`","a":"`y`"}]'\''
$ json-litex -d '\''{"bar":{"foo":{"b":"`z`","a":"`x`","a":"`y`"}}}'\''
json: error: <text>:1:36: filter library: attribute error: invalid object: duplicated key name (previous defined at 1:26)
json: error: <text>:1:36: ar":{"foo":{"b":"`z`","a":"`x`","a":"`y`"}}}
json: error: <text>:1:36:                                 ^
command failed: json-litex -d '\''{"bar":{"foo":{"b":"`z`","a":"`x`","a":"`y`"}}}'\''
$ json-litex -d '\''{"bar":[{"b":"`z`","a":"`x`","a":"`y`"}]}'\''
json: error: <text>:1:30: filter library: attribute error: invalid object: duplicated key name (previous defined at 1:20)
json: error: <text>:1:30: {"bar":[{"b":"`z`","a":"`x`","a":"`y`"}]}
json: error: <text>:1:30:                              ^
command failed: json-litex -d '\''{"bar":[{"b":"`z`","a":"`x`","a":"`y`"}]}'\''
$ json-litex -d '\''[{"foo":{"b":"`z`","a":"`x`","a":"`y`"}}]'\''
json: error: <text>:1:30: filter library: attribute error: invalid object: duplicated key name (previous defined at 1:20)
json: error: <text>:1:30: [{"foo":{"b":"`z`","a":"`x`","a":"`y`"}}]
json: error: <text>:1:30:                              ^
command failed: json-litex -d '\''[{"foo":{"b":"`z`","a":"`x`","a":"`y`"}}]'\''
$ json-litex -d '\''{"baz":{"bar":{"foo":{"b":"`z`","a":"`x`","a":"`y`"}}}}'\''
json: error: <text>:1:43: filter library: attribute error: invalid object: duplicated key name (previous defined at 1:33)
json: error: <text>:1:43: ar":{"foo":{"b":"`z`","a":"`x`","a":"`y`"}}}}
json: error: <text>:1:43:                                 ^
command failed: json-litex -d '\''{"baz":{"bar":{"foo":{"b":"`z`","a":"`x`","a":"`y`"}}}}'\''
$ json-litex -d '\''{"baz":{"bar":[{"b":"`z`","a":"`x`","a":"`y`"}]}}'\''
json: error: <text>:1:37: filter library: attribute error: invalid object: duplicated key name (previous defined at 1:27)
json: error: <text>:1:37: z":{"bar":[{"b":"`z`","a":"`x`","a":"`y`"}]}}
json: error: <text>:1:37:                                 ^
command failed: json-litex -d '\''{"baz":{"bar":[{"b":"`z`","a":"`x`","a":"`y`"}]}}'\''
$ json-litex -d '\''{"baz":[{"foo":{"b":"`z`","a":"`x`","a":"`y`"}}]}'\''
json: error: <text>:1:37: filter library: attribute error: invalid object: duplicated key name (previous defined at 1:27)
json: error: <text>:1:37: z":[{"foo":{"b":"`z`","a":"`x`","a":"`y`"}}]}
json: error: <text>:1:37:                                 ^
command failed: json-litex -d '\''{"baz":[{"foo":{"b":"`z`","a":"`x`","a":"`y`"}}]}'\''
$ json-litex -d '\''[{"bar":{"foo":{"b":"`z`","a":"`x`","a":"`y`"}}}]'\''
json: error: <text>:1:37: filter library: attribute error: invalid object: duplicated key name (previous defined at 1:27)
json: error: <text>:1:37: ar":{"foo":{"b":"`z`","a":"`x`","a":"`y`"}}}]
json: error: <text>:1:37:                                 ^
command failed: json-litex -d '\''[{"bar":{"foo":{"b":"`z`","a":"`x`","a":"`y`"}}}]'\''
$ json-litex -d '\''[{"bar":[{"b":"`z`","a":"`x`","a":"`y`"}]}]'\''
json: error: <text>:1:31: filter library: attribute error: invalid object: duplicated key name (previous defined at 1:21)
json: error: <text>:1:31: [{"bar":[{"b":"`z`","a":"`x`","a":"`y`"}]}]
json: error: <text>:1:31:                               ^
command failed: json-litex -d '\''[{"bar":[{"b":"`z`","a":"`x`","a":"`y`"}]}]'\''
$ json-litex -d '\''{"a":"`x`","b":"`z`","a":"`y`"}'\''
json: error: <text>:1:22: filter library: attribute error: invalid object: duplicated key name (previous defined at 1:2)
json: error: <text>:1:22: {"a":"`x`","b":"`z`","a":"`y`"}
json: error: <text>:1:22:                      ^
command failed: json-litex -d '\''{"a":"`x`","b":"`z`","a":"`y`"}'\''
$ json-litex -d '\''{"foo":{"a":"`x`","b":"`z`","a":"`y`"}}'\''
json: error: <text>:1:29: filter library: attribute error: invalid object: duplicated key name (previous defined at 1:9)
json: error: <text>:1:29: {"foo":{"a":"`x`","b":"`z`","a":"`y`"}}
json: error: <text>:1:29:                             ^
command failed: json-litex -d '\''{"foo":{"a":"`x`","b":"`z`","a":"`y`"}}'\''
$ json-litex -d '\''[{"a":"`x`","b":"`z`","a":"`y`"}]'\''
json: error: <text>:1:23: filter library: attribute error: invalid object: duplicated key name (previous defined at 1:3)
json: error: <text>:1:23: [{"a":"`x`","b":"`z`","a":"`y`"}]
json: error: <text>:1:23:                       ^
command failed: json-litex -d '\''[{"a":"`x`","b":"`z`","a":"`y`"}]'\''
$ json-litex -d '\''{"bar":{"foo":{"a":"`x`","b":"`z`","a":"`y`"}}}'\''
json: error: <text>:1:36: filter library: attribute error: invalid object: duplicated key name (previous defined at 1:16)
json: error: <text>:1:36: ar":{"foo":{"a":"`x`","b":"`z`","a":"`y`"}}}
json: error: <text>:1:36:                                 ^
command failed: json-litex -d '\''{"bar":{"foo":{"a":"`x`","b":"`z`","a":"`y`"}}}'\''
$ json-litex -d '\''{"bar":[{"a":"`x`","b":"`z`","a":"`y`"}]}'\''
json: error: <text>:1:30: filter library: attribute error: invalid object: duplicated key name (previous defined at 1:10)
json: error: <text>:1:30: {"bar":[{"a":"`x`","b":"`z`","a":"`y`"}]}
json: error: <text>:1:30:                              ^
command failed: json-litex -d '\''{"bar":[{"a":"`x`","b":"`z`","a":"`y`"}]}'\''
$ json-litex -d '\''[{"foo":{"a":"`x`","b":"`z`","a":"`y`"}}]'\''
json: error: <text>:1:30: filter library: attribute error: invalid object: duplicated key name (previous defined at 1:10)
json: error: <text>:1:30: [{"foo":{"a":"`x`","b":"`z`","a":"`y`"}}]
json: error: <text>:1:30:                              ^
command failed: json-litex -d '\''[{"foo":{"a":"`x`","b":"`z`","a":"`y`"}}]'\''
$ json-litex -d '\''{"baz":{"bar":{"foo":{"a":"`x`","b":"`z`","a":"`y`"}}}}'\''
json: error: <text>:1:43: filter library: attribute error: invalid object: duplicated key name (previous defined at 1:23)
json: error: <text>:1:43: ar":{"foo":{"a":"`x`","b":"`z`","a":"`y`"}}}}
json: error: <text>:1:43:                                 ^
command failed: json-litex -d '\''{"baz":{"bar":{"foo":{"a":"`x`","b":"`z`","a":"`y`"}}}}'\''
$ json-litex -d '\''{"baz":{"bar":[{"a":"`x`","b":"`z`","a":"`y`"}]}}'\''
json: error: <text>:1:37: filter library: attribute error: invalid object: duplicated key name (previous defined at 1:17)
json: error: <text>:1:37: z":{"bar":[{"a":"`x`","b":"`z`","a":"`y`"}]}}
json: error: <text>:1:37:                                 ^
command failed: json-litex -d '\''{"baz":{"bar":[{"a":"`x`","b":"`z`","a":"`y`"}]}}'\''
$ json-litex -d '\''{"baz":[{"foo":{"a":"`x`","b":"`z`","a":"`y`"}}]}'\''
json: error: <text>:1:37: filter library: attribute error: invalid object: duplicated key name (previous defined at 1:17)
json: error: <text>:1:37: z":[{"foo":{"a":"`x`","b":"`z`","a":"`y`"}}]}
json: error: <text>:1:37:                                 ^
command failed: json-litex -d '\''{"baz":[{"foo":{"a":"`x`","b":"`z`","a":"`y`"}}]}'\''
$ json-litex -d '\''[{"bar":{"foo":{"a":"`x`","b":"`z`","a":"`y`"}}}]'\''
json: error: <text>:1:37: filter library: attribute error: invalid object: duplicated key name (previous defined at 1:17)
json: error: <text>:1:37: ar":{"foo":{"a":"`x`","b":"`z`","a":"`y`"}}}]
json: error: <text>:1:37:                                 ^
command failed: json-litex -d '\''[{"bar":{"foo":{"a":"`x`","b":"`z`","a":"`y`"}}}]'\''
$ json-litex -d '\''[{"bar":[{"a":"`x`","b":"`z`","a":"`y`"}]}]'\''
json: error: <text>:1:31: filter library: attribute error: invalid object: duplicated key name (previous defined at 1:11)
json: error: <text>:1:31: [{"bar":[{"a":"`x`","b":"`z`","a":"`y`"}]}]
json: error: <text>:1:31:                               ^
command failed: json-litex -d '\''[{"bar":[{"a":"`x`","b":"`z`","a":"`y`"}]}]'\''
$ json-litex -d '\''{"a":"`x`","a":"`y`","b":"`z`"}'\''
json: error: <text>:1:12: filter library: attribute error: invalid object: duplicated key name (previous defined at 1:2)
json: error: <text>:1:12: {"a":"`x`","a":"`y`","b":"`z`"}
json: error: <text>:1:12:            ^
command failed: json-litex -d '\''{"a":"`x`","a":"`y`","b":"`z`"}'\''
$ json-litex -d '\''{"foo":{"a":"`x`","a":"`y`","b":"`z`"}}'\''
json: error: <text>:1:19: filter library: attribute error: invalid object: duplicated key name (previous defined at 1:9)
json: error: <text>:1:19: {"foo":{"a":"`x`","a":"`y`","b":"`z`"}}
json: error: <text>:1:19:                   ^
command failed: json-litex -d '\''{"foo":{"a":"`x`","a":"`y`","b":"`z`"}}'\''
$ json-litex -d '\''[{"a":"`x`","a":"`y`","b":"`z`"}]'\''
json: error: <text>:1:13: filter library: attribute error: invalid object: duplicated key name (previous defined at 1:3)
json: error: <text>:1:13: [{"a":"`x`","a":"`y`","b":"`z`"}]
json: error: <text>:1:13:             ^
command failed: json-litex -d '\''[{"a":"`x`","a":"`y`","b":"`z`"}]'\''
$ json-litex -d '\''{"bar":{"foo":{"a":"`x`","a":"`y`","b":"`z`"}}}'\''
json: error: <text>:1:26: filter library: attribute error: invalid object: duplicated key name (previous defined at 1:16)
json: error: <text>:1:26: {"bar":{"foo":{"a":"`x`","a":"`y`","b":"`z`"}}}
json: error: <text>:1:26:                          ^
command failed: json-litex -d '\''{"bar":{"foo":{"a":"`x`","a":"`y`","b":"`z`"}}}'\''
$ json-litex -d '\''{"bar":[{"a":"`x`","a":"`y`","b":"`z`"}]}'\''
json: error: <text>:1:20: filter library: attribute error: invalid object: duplicated key name (previous defined at 1:10)
json: error: <text>:1:20: {"bar":[{"a":"`x`","a":"`y`","b":"`z`"}]}
json: error: <text>:1:20:                    ^
command failed: json-litex -d '\''{"bar":[{"a":"`x`","a":"`y`","b":"`z`"}]}'\''
$ json-litex -d '\''[{"foo":{"a":"`x`","a":"`y`","b":"`z`"}}]'\''
json: error: <text>:1:20: filter library: attribute error: invalid object: duplicated key name (previous defined at 1:10)
json: error: <text>:1:20: [{"foo":{"a":"`x`","a":"`y`","b":"`z`"}}]
json: error: <text>:1:20:                    ^
command failed: json-litex -d '\''[{"foo":{"a":"`x`","a":"`y`","b":"`z`"}}]'\''
$ json-litex -d '\''{"baz":{"bar":{"foo":{"a":"`x`","a":"`y`","b":"`z`"}}}}'\''
json: error: <text>:1:33: filter library: attribute error: invalid object: duplicated key name (previous defined at 1:23)
json: error: <text>:1:33: {"baz":{"bar":{"foo":{"a":"`x`","a":"`y`","b":"`z`"}}}}
json: error: <text>:1:33:                                 ^
command failed: json-litex -d '\''{"baz":{"bar":{"foo":{"a":"`x`","a":"`y`","b":"`z`"}}}}'\''
$ json-litex -d '\''{"baz":{"bar":[{"a":"`x`","a":"`y`","b":"`z`"}]}}'\''
json: error: <text>:1:27: filter library: attribute error: invalid object: duplicated key name (previous defined at 1:17)
json: error: <text>:1:27: {"baz":{"bar":[{"a":"`x`","a":"`y`","b":"`z`"}]}}
json: error: <text>:1:27:                           ^
command failed: json-litex -d '\''{"baz":{"bar":[{"a":"`x`","a":"`y`","b":"`z`"}]}}'\''
$ json-litex -d '\''{"baz":[{"foo":{"a":"`x`","a":"`y`","b":"`z`"}}]}'\''
json: error: <text>:1:27: filter library: attribute error: invalid object: duplicated key name (previous defined at 1:17)
json: error: <text>:1:27: {"baz":[{"foo":{"a":"`x`","a":"`y`","b":"`z`"}}]}
json: error: <text>:1:27:                           ^
command failed: json-litex -d '\''{"baz":[{"foo":{"a":"`x`","a":"`y`","b":"`z`"}}]}'\''
$ json-litex -d '\''[{"bar":{"foo":{"a":"`x`","a":"`y`","b":"`z`"}}}]'\''
json: error: <text>:1:27: filter library: attribute error: invalid object: duplicated key name (previous defined at 1:17)
json: error: <text>:1:27: [{"bar":{"foo":{"a":"`x`","a":"`y`","b":"`z`"}}}]
json: error: <text>:1:27:                           ^
command failed: json-litex -d '\''[{"bar":{"foo":{"a":"`x`","a":"`y`","b":"`z`"}}}]'\''
$ json-litex -d '\''[{"bar":[{"a":"`x`","a":"`y`","b":"`z`"}]}]'\''
json: error: <text>:1:21: filter library: attribute error: invalid object: duplicated key name (previous defined at 1:11)
json: error: <text>:1:21: [{"bar":[{"a":"`x`","a":"`y`","b":"`z`"}]}]
json: error: <text>:1:21:                     ^
command failed: json-litex -d '\''[{"bar":[{"a":"`x`","a":"`y`","b":"`z`"}]}]'\'''
) -L dup-key.new <(
echo '$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'
[ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib" 2>&1 ||
echo 'command failed: [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'

echo '$ json-litex() { set -o pipefail && LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value -VF -- ../lib/json-litex.so -A "$@"|sed -r '\''s/"size":[0-9]+,"bytes":\["[0-9a-f]+"(,"[0-9a-f]+")*\]//;s/("lookup":"0x)[0-9a-f]+(")/\1...\2/g'\''|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }'
json-litex() { set -o pipefail && LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value -VF -- ../lib/json-litex.so -A "$@"|sed -r 's/"size":[0-9]+,"bytes":\["[0-9a-f]+"(,"[0-9a-f]+")*\]//;s/("lookup":"0x)[0-9a-f]+(")/\1...\2/g'|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; } 2>&1 ||
echo 'command failed: json-litex() { set -o pipefail && LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value -VF -- ../lib/json-litex.so -A "$@"|sed -r '\''s/"size":[0-9]+,"bytes":\["[0-9a-f]+"(,"[0-9a-f]+")*\]//;s/("lookup":"0x)[0-9a-f]+(")/\1...\2/g'\''|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }'

echo '$ json-litex -d '\''{"a":"`x`","a":"`y`"}'\'''
json-litex -d '{"a":"`x`","a":"`y`"}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"a":"`x`","a":"`y`"}'\'''

echo '$ json-litex -d '\''{"foo":{"a":"`x`","a":"`y`"}}'\'''
json-litex -d '{"foo":{"a":"`x`","a":"`y`"}}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"foo":{"a":"`x`","a":"`y`"}}'\'''

echo '$ json-litex -d '\''[{"a":"`x`","a":"`y`"}]'\'''
json-litex -d '[{"a":"`x`","a":"`y`"}]' 2>&1 ||
echo 'command failed: json-litex -d '\''[{"a":"`x`","a":"`y`"}]'\'''

echo '$ json-litex -d '\''{"bar":{"foo":{"a":"`x`","a":"`y`"}}}'\'''
json-litex -d '{"bar":{"foo":{"a":"`x`","a":"`y`"}}}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"bar":{"foo":{"a":"`x`","a":"`y`"}}}'\'''

echo '$ json-litex -d '\''{"bar":[{"a":"`x`","a":"`y`"}]}'\'''
json-litex -d '{"bar":[{"a":"`x`","a":"`y`"}]}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"bar":[{"a":"`x`","a":"`y`"}]}'\'''

echo '$ json-litex -d '\''[{"foo":{"a":"`x`","a":"`y`"}}]'\'''
json-litex -d '[{"foo":{"a":"`x`","a":"`y`"}}]' 2>&1 ||
echo 'command failed: json-litex -d '\''[{"foo":{"a":"`x`","a":"`y`"}}]'\'''

echo '$ json-litex -d '\''{"baz":{"bar":{"foo":{"a":"`x`","a":"`y`"}}}}'\'''
json-litex -d '{"baz":{"bar":{"foo":{"a":"`x`","a":"`y`"}}}}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"baz":{"bar":{"foo":{"a":"`x`","a":"`y`"}}}}'\'''

echo '$ json-litex -d '\''{"baz":{"bar":[{"a":"`x`","a":"`y`"}]}}'\'''
json-litex -d '{"baz":{"bar":[{"a":"`x`","a":"`y`"}]}}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"baz":{"bar":[{"a":"`x`","a":"`y`"}]}}'\'''

echo '$ json-litex -d '\''{"baz":[{"foo":{"a":"`x`","a":"`y`"}}]}'\'''
json-litex -d '{"baz":[{"foo":{"a":"`x`","a":"`y`"}}]}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"baz":[{"foo":{"a":"`x`","a":"`y`"}}]}'\'''

echo '$ json-litex -d '\''[{"bar":{"foo":{"a":"`x`","a":"`y`"}}}]'\'''
json-litex -d '[{"bar":{"foo":{"a":"`x`","a":"`y`"}}}]' 2>&1 ||
echo 'command failed: json-litex -d '\''[{"bar":{"foo":{"a":"`x`","a":"`y`"}}}]'\'''

echo '$ json-litex -d '\''[{"bar":[{"a":"`x`","a":"`y`"}]}]'\'''
json-litex -d '[{"bar":[{"a":"`x`","a":"`y`"}]}]' 2>&1 ||
echo 'command failed: json-litex -d '\''[{"bar":[{"a":"`x`","a":"`y`"}]}]'\'''

echo '$ json-litex -d '\''{"b":"`z`","a":"`x`","a":"`y`"}'\'''
json-litex -d '{"b":"`z`","a":"`x`","a":"`y`"}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"b":"`z`","a":"`x`","a":"`y`"}'\'''

echo '$ json-litex -d '\''{"foo":{"b":"`z`","a":"`x`","a":"`y`"}}'\'''
json-litex -d '{"foo":{"b":"`z`","a":"`x`","a":"`y`"}}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"foo":{"b":"`z`","a":"`x`","a":"`y`"}}'\'''

echo '$ json-litex -d '\''[{"b":"`z`","a":"`x`","a":"`y`"}]'\'''
json-litex -d '[{"b":"`z`","a":"`x`","a":"`y`"}]' 2>&1 ||
echo 'command failed: json-litex -d '\''[{"b":"`z`","a":"`x`","a":"`y`"}]'\'''

echo '$ json-litex -d '\''{"bar":{"foo":{"b":"`z`","a":"`x`","a":"`y`"}}}'\'''
json-litex -d '{"bar":{"foo":{"b":"`z`","a":"`x`","a":"`y`"}}}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"bar":{"foo":{"b":"`z`","a":"`x`","a":"`y`"}}}'\'''

echo '$ json-litex -d '\''{"bar":[{"b":"`z`","a":"`x`","a":"`y`"}]}'\'''
json-litex -d '{"bar":[{"b":"`z`","a":"`x`","a":"`y`"}]}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"bar":[{"b":"`z`","a":"`x`","a":"`y`"}]}'\'''

echo '$ json-litex -d '\''[{"foo":{"b":"`z`","a":"`x`","a":"`y`"}}]'\'''
json-litex -d '[{"foo":{"b":"`z`","a":"`x`","a":"`y`"}}]' 2>&1 ||
echo 'command failed: json-litex -d '\''[{"foo":{"b":"`z`","a":"`x`","a":"`y`"}}]'\'''

echo '$ json-litex -d '\''{"baz":{"bar":{"foo":{"b":"`z`","a":"`x`","a":"`y`"}}}}'\'''
json-litex -d '{"baz":{"bar":{"foo":{"b":"`z`","a":"`x`","a":"`y`"}}}}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"baz":{"bar":{"foo":{"b":"`z`","a":"`x`","a":"`y`"}}}}'\'''

echo '$ json-litex -d '\''{"baz":{"bar":[{"b":"`z`","a":"`x`","a":"`y`"}]}}'\'''
json-litex -d '{"baz":{"bar":[{"b":"`z`","a":"`x`","a":"`y`"}]}}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"baz":{"bar":[{"b":"`z`","a":"`x`","a":"`y`"}]}}'\'''

echo '$ json-litex -d '\''{"baz":[{"foo":{"b":"`z`","a":"`x`","a":"`y`"}}]}'\'''
json-litex -d '{"baz":[{"foo":{"b":"`z`","a":"`x`","a":"`y`"}}]}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"baz":[{"foo":{"b":"`z`","a":"`x`","a":"`y`"}}]}'\'''

echo '$ json-litex -d '\''[{"bar":{"foo":{"b":"`z`","a":"`x`","a":"`y`"}}}]'\'''
json-litex -d '[{"bar":{"foo":{"b":"`z`","a":"`x`","a":"`y`"}}}]' 2>&1 ||
echo 'command failed: json-litex -d '\''[{"bar":{"foo":{"b":"`z`","a":"`x`","a":"`y`"}}}]'\'''

echo '$ json-litex -d '\''[{"bar":[{"b":"`z`","a":"`x`","a":"`y`"}]}]'\'''
json-litex -d '[{"bar":[{"b":"`z`","a":"`x`","a":"`y`"}]}]' 2>&1 ||
echo 'command failed: json-litex -d '\''[{"bar":[{"b":"`z`","a":"`x`","a":"`y`"}]}]'\'''

echo '$ json-litex -d '\''{"a":"`x`","b":"`z`","a":"`y`"}'\'''
json-litex -d '{"a":"`x`","b":"`z`","a":"`y`"}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"a":"`x`","b":"`z`","a":"`y`"}'\'''

echo '$ json-litex -d '\''{"foo":{"a":"`x`","b":"`z`","a":"`y`"}}'\'''
json-litex -d '{"foo":{"a":"`x`","b":"`z`","a":"`y`"}}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"foo":{"a":"`x`","b":"`z`","a":"`y`"}}'\'''

echo '$ json-litex -d '\''[{"a":"`x`","b":"`z`","a":"`y`"}]'\'''
json-litex -d '[{"a":"`x`","b":"`z`","a":"`y`"}]' 2>&1 ||
echo 'command failed: json-litex -d '\''[{"a":"`x`","b":"`z`","a":"`y`"}]'\'''

echo '$ json-litex -d '\''{"bar":{"foo":{"a":"`x`","b":"`z`","a":"`y`"}}}'\'''
json-litex -d '{"bar":{"foo":{"a":"`x`","b":"`z`","a":"`y`"}}}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"bar":{"foo":{"a":"`x`","b":"`z`","a":"`y`"}}}'\'''

echo '$ json-litex -d '\''{"bar":[{"a":"`x`","b":"`z`","a":"`y`"}]}'\'''
json-litex -d '{"bar":[{"a":"`x`","b":"`z`","a":"`y`"}]}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"bar":[{"a":"`x`","b":"`z`","a":"`y`"}]}'\'''

echo '$ json-litex -d '\''[{"foo":{"a":"`x`","b":"`z`","a":"`y`"}}]'\'''
json-litex -d '[{"foo":{"a":"`x`","b":"`z`","a":"`y`"}}]' 2>&1 ||
echo 'command failed: json-litex -d '\''[{"foo":{"a":"`x`","b":"`z`","a":"`y`"}}]'\'''

echo '$ json-litex -d '\''{"baz":{"bar":{"foo":{"a":"`x`","b":"`z`","a":"`y`"}}}}'\'''
json-litex -d '{"baz":{"bar":{"foo":{"a":"`x`","b":"`z`","a":"`y`"}}}}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"baz":{"bar":{"foo":{"a":"`x`","b":"`z`","a":"`y`"}}}}'\'''

echo '$ json-litex -d '\''{"baz":{"bar":[{"a":"`x`","b":"`z`","a":"`y`"}]}}'\'''
json-litex -d '{"baz":{"bar":[{"a":"`x`","b":"`z`","a":"`y`"}]}}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"baz":{"bar":[{"a":"`x`","b":"`z`","a":"`y`"}]}}'\'''

echo '$ json-litex -d '\''{"baz":[{"foo":{"a":"`x`","b":"`z`","a":"`y`"}}]}'\'''
json-litex -d '{"baz":[{"foo":{"a":"`x`","b":"`z`","a":"`y`"}}]}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"baz":[{"foo":{"a":"`x`","b":"`z`","a":"`y`"}}]}'\'''

echo '$ json-litex -d '\''[{"bar":{"foo":{"a":"`x`","b":"`z`","a":"`y`"}}}]'\'''
json-litex -d '[{"bar":{"foo":{"a":"`x`","b":"`z`","a":"`y`"}}}]' 2>&1 ||
echo 'command failed: json-litex -d '\''[{"bar":{"foo":{"a":"`x`","b":"`z`","a":"`y`"}}}]'\'''

echo '$ json-litex -d '\''[{"bar":[{"a":"`x`","b":"`z`","a":"`y`"}]}]'\'''
json-litex -d '[{"bar":[{"a":"`x`","b":"`z`","a":"`y`"}]}]' 2>&1 ||
echo 'command failed: json-litex -d '\''[{"bar":[{"a":"`x`","b":"`z`","a":"`y`"}]}]'\'''

echo '$ json-litex -d '\''{"a":"`x`","a":"`y`","b":"`z`"}'\'''
json-litex -d '{"a":"`x`","a":"`y`","b":"`z`"}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"a":"`x`","a":"`y`","b":"`z`"}'\'''

echo '$ json-litex -d '\''{"foo":{"a":"`x`","a":"`y`","b":"`z`"}}'\'''
json-litex -d '{"foo":{"a":"`x`","a":"`y`","b":"`z`"}}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"foo":{"a":"`x`","a":"`y`","b":"`z`"}}'\'''

echo '$ json-litex -d '\''[{"a":"`x`","a":"`y`","b":"`z`"}]'\'''
json-litex -d '[{"a":"`x`","a":"`y`","b":"`z`"}]' 2>&1 ||
echo 'command failed: json-litex -d '\''[{"a":"`x`","a":"`y`","b":"`z`"}]'\'''

echo '$ json-litex -d '\''{"bar":{"foo":{"a":"`x`","a":"`y`","b":"`z`"}}}'\'''
json-litex -d '{"bar":{"foo":{"a":"`x`","a":"`y`","b":"`z`"}}}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"bar":{"foo":{"a":"`x`","a":"`y`","b":"`z`"}}}'\'''

echo '$ json-litex -d '\''{"bar":[{"a":"`x`","a":"`y`","b":"`z`"}]}'\'''
json-litex -d '{"bar":[{"a":"`x`","a":"`y`","b":"`z`"}]}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"bar":[{"a":"`x`","a":"`y`","b":"`z`"}]}'\'''

echo '$ json-litex -d '\''[{"foo":{"a":"`x`","a":"`y`","b":"`z`"}}]'\'''
json-litex -d '[{"foo":{"a":"`x`","a":"`y`","b":"`z`"}}]' 2>&1 ||
echo 'command failed: json-litex -d '\''[{"foo":{"a":"`x`","a":"`y`","b":"`z`"}}]'\'''

echo '$ json-litex -d '\''{"baz":{"bar":{"foo":{"a":"`x`","a":"`y`","b":"`z`"}}}}'\'''
json-litex -d '{"baz":{"bar":{"foo":{"a":"`x`","a":"`y`","b":"`z`"}}}}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"baz":{"bar":{"foo":{"a":"`x`","a":"`y`","b":"`z`"}}}}'\'''

echo '$ json-litex -d '\''{"baz":{"bar":[{"a":"`x`","a":"`y`","b":"`z`"}]}}'\'''
json-litex -d '{"baz":{"bar":[{"a":"`x`","a":"`y`","b":"`z`"}]}}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"baz":{"bar":[{"a":"`x`","a":"`y`","b":"`z`"}]}}'\'''

echo '$ json-litex -d '\''{"baz":[{"foo":{"a":"`x`","a":"`y`","b":"`z`"}}]}'\'''
json-litex -d '{"baz":[{"foo":{"a":"`x`","a":"`y`","b":"`z`"}}]}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"baz":[{"foo":{"a":"`x`","a":"`y`","b":"`z`"}}]}'\'''

echo '$ json-litex -d '\''[{"bar":{"foo":{"a":"`x`","a":"`y`","b":"`z`"}}}]'\'''
json-litex -d '[{"bar":{"foo":{"a":"`x`","a":"`y`","b":"`z`"}}}]' 2>&1 ||
echo 'command failed: json-litex -d '\''[{"bar":{"foo":{"a":"`x`","a":"`y`","b":"`z`"}}}]'\'''

echo '$ json-litex -d '\''[{"bar":[{"a":"`x`","a":"`y`","b":"`z`"}]}]'\'''
json-litex -d '[{"bar":[{"a":"`x`","a":"`y`","b":"`z`"}]}]' 2>&1 ||
echo 'command failed: json-litex -d '\''[{"bar":[{"a":"`x`","a":"`y`","b":"`z`"}]}]'\'''
)

