#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -p litex -C expr:regex
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L regex.old <(echo \
'$ shopt -s expand_aliases
$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"
$ test-expr() { LD_LIBRARY_PATH="$JSON_LITEX_TEST_PCRE2_LIB" ../lib/test-expr "$@" -vb default -E; }
$ test-expr --dump-opt|sed -nr '\''s/^sizes-exec-ovector-max:\s+([0-9]+)\s*$/\1/p'\''
32
$ test-expr '\''/(0)(1)(2)(3)(4)(5)(6)(7)(8)(9)(0)(1)(2)(3)(4)(5)(6)(7)(8)(9)(0)(1)(2)(3)(4)(5)(6)(7)(8)(9)(0)(1)(2)/'\'' '\''""'\''
0
$ test-expr '\''/(0)(1)(2)(3)(4)(5)(6)(7)(8)(9)(0)(1)(2)(3)(4)(5)(6)(7)(8)(9)(0)(1)(2)(3)(4)(5)(6)(7)(8)(9)(0)(1)(2)/'\'' '\''"foo"'\''
0
$ test-expr '\''/(0)(1)(2)(3)(4)(5)(6)(7)(8)(9)(0)(1)(2)(3)(4)(5)(6)(7)(8)(9)(0)(1)(2)(3)(4)(5)(6)(7)(8)(9)(0)(1)(2)/'\'' '\''"012345678901234567890123456789012"'\''
test-expr: error: executor error: pcre2 function '\''match'\'' failed: too many capturing subpatterns
command failed: test-expr '\''/(0)(1)(2)(3)(4)(5)(6)(7)(8)(9)(0)(1)(2)(3)(4)(5)(6)(7)(8)(9)(0)(1)(2)(3)(4)(5)(6)(7)(8)(9)(0)(1)(2)/'\'' '\''"012345678901234567890123456789012"'\''
$ test-expr '\''/(0)(1)(2)(3)(4)(5)(6)(7)(8)(9)(0)(1)(2)(3)(4)(5)(6)(7)(8)(9)(0)(1)(2)(3)(4)(5)(6)(7)(8)(9)(0)(1)/'\'' '\''"012345678901234567890123456789012"'\''
test-expr: error: executor error: pcre2 function '\''match'\'' failed: too many capturing subpatterns
command failed: test-expr '\''/(0)(1)(2)(3)(4)(5)(6)(7)(8)(9)(0)(1)(2)(3)(4)(5)(6)(7)(8)(9)(0)(1)(2)(3)(4)(5)(6)(7)(8)(9)(0)(1)/'\'' '\''"012345678901234567890123456789012"'\''
$ test-expr '\''/(0)(1)(2)(3)(4)(5)(6)(7)(8)(9)(0)(1)(2)(3)(4)(5)(6)(7)(8)(9)(0)(1)(2)(3)(4)(5)(6)(7)(8)(9)(0)/'\'' '\''"012345678901234567890123456789012"'\''
1'
) -L regex.new <(
echo '$ shopt -s expand_aliases'
shopt -s expand_aliases 2>&1 ||
echo 'command failed: shopt -s expand_aliases'

echo '$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'
[ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib" 2>&1 ||
echo 'command failed: [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'

echo '$ test-expr() { LD_LIBRARY_PATH="$JSON_LITEX_TEST_PCRE2_LIB" ../lib/test-expr "$@" -vb default -E; }'
test-expr() { LD_LIBRARY_PATH="$JSON_LITEX_TEST_PCRE2_LIB" ../lib/test-expr "$@" -vb default -E; } 2>&1 ||
echo 'command failed: test-expr() { LD_LIBRARY_PATH="$JSON_LITEX_TEST_PCRE2_LIB" ../lib/test-expr "$@" -vb default -E; }'

echo '$ test-expr --dump-opt|sed -nr '\''s/^sizes-exec-ovector-max:\s+([0-9]+)\s*$/\1/p'\'''
test-expr --dump-opt|sed -nr 's/^sizes-exec-ovector-max:\s+([0-9]+)\s*$/\1/p' 2>&1 ||
echo 'command failed: test-expr --dump-opt|sed -nr '\''s/^sizes-exec-ovector-max:\s+([0-9]+)\s*$/\1/p'\'''

echo '$ test-expr '\''/(0)(1)(2)(3)(4)(5)(6)(7)(8)(9)(0)(1)(2)(3)(4)(5)(6)(7)(8)(9)(0)(1)(2)(3)(4)(5)(6)(7)(8)(9)(0)(1)(2)/'\'' '\''""'\'''
test-expr '/(0)(1)(2)(3)(4)(5)(6)(7)(8)(9)(0)(1)(2)(3)(4)(5)(6)(7)(8)(9)(0)(1)(2)(3)(4)(5)(6)(7)(8)(9)(0)(1)(2)/' '""' 2>&1 ||
echo 'command failed: test-expr '\''/(0)(1)(2)(3)(4)(5)(6)(7)(8)(9)(0)(1)(2)(3)(4)(5)(6)(7)(8)(9)(0)(1)(2)(3)(4)(5)(6)(7)(8)(9)(0)(1)(2)/'\'' '\''""'\'''

echo '$ test-expr '\''/(0)(1)(2)(3)(4)(5)(6)(7)(8)(9)(0)(1)(2)(3)(4)(5)(6)(7)(8)(9)(0)(1)(2)(3)(4)(5)(6)(7)(8)(9)(0)(1)(2)/'\'' '\''"foo"'\'''
test-expr '/(0)(1)(2)(3)(4)(5)(6)(7)(8)(9)(0)(1)(2)(3)(4)(5)(6)(7)(8)(9)(0)(1)(2)(3)(4)(5)(6)(7)(8)(9)(0)(1)(2)/' '"foo"' 2>&1 ||
echo 'command failed: test-expr '\''/(0)(1)(2)(3)(4)(5)(6)(7)(8)(9)(0)(1)(2)(3)(4)(5)(6)(7)(8)(9)(0)(1)(2)(3)(4)(5)(6)(7)(8)(9)(0)(1)(2)/'\'' '\''"foo"'\'''

echo '$ test-expr '\''/(0)(1)(2)(3)(4)(5)(6)(7)(8)(9)(0)(1)(2)(3)(4)(5)(6)(7)(8)(9)(0)(1)(2)(3)(4)(5)(6)(7)(8)(9)(0)(1)(2)/'\'' '\''"012345678901234567890123456789012"'\'''
test-expr '/(0)(1)(2)(3)(4)(5)(6)(7)(8)(9)(0)(1)(2)(3)(4)(5)(6)(7)(8)(9)(0)(1)(2)(3)(4)(5)(6)(7)(8)(9)(0)(1)(2)/' '"012345678901234567890123456789012"' 2>&1 ||
echo 'command failed: test-expr '\''/(0)(1)(2)(3)(4)(5)(6)(7)(8)(9)(0)(1)(2)(3)(4)(5)(6)(7)(8)(9)(0)(1)(2)(3)(4)(5)(6)(7)(8)(9)(0)(1)(2)/'\'' '\''"012345678901234567890123456789012"'\'''

echo '$ test-expr '\''/(0)(1)(2)(3)(4)(5)(6)(7)(8)(9)(0)(1)(2)(3)(4)(5)(6)(7)(8)(9)(0)(1)(2)(3)(4)(5)(6)(7)(8)(9)(0)(1)/'\'' '\''"012345678901234567890123456789012"'\'''
test-expr '/(0)(1)(2)(3)(4)(5)(6)(7)(8)(9)(0)(1)(2)(3)(4)(5)(6)(7)(8)(9)(0)(1)(2)(3)(4)(5)(6)(7)(8)(9)(0)(1)/' '"012345678901234567890123456789012"' 2>&1 ||
echo 'command failed: test-expr '\''/(0)(1)(2)(3)(4)(5)(6)(7)(8)(9)(0)(1)(2)(3)(4)(5)(6)(7)(8)(9)(0)(1)(2)(3)(4)(5)(6)(7)(8)(9)(0)(1)/'\'' '\''"012345678901234567890123456789012"'\'''

echo '$ test-expr '\''/(0)(1)(2)(3)(4)(5)(6)(7)(8)(9)(0)(1)(2)(3)(4)(5)(6)(7)(8)(9)(0)(1)(2)(3)(4)(5)(6)(7)(8)(9)(0)/'\'' '\''"012345678901234567890123456789012"'\'''
test-expr '/(0)(1)(2)(3)(4)(5)(6)(7)(8)(9)(0)(1)(2)(3)(4)(5)(6)(7)(8)(9)(0)(1)(2)(3)(4)(5)(6)(7)(8)(9)(0)/' '"012345678901234567890123456789012"' 2>&1 ||
echo 'command failed: test-expr '\''/(0)(1)(2)(3)(4)(5)(6)(7)(8)(9)(0)(1)(2)(3)(4)(5)(6)(7)(8)(9)(0)(1)(2)(3)(4)(5)(6)(7)(8)(9)(0)/'\'' '\''"012345678901234567890123456789012"'\'''
)

