#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C filter:fail-twice
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L fail-twice.old <(echo \
'$ json0() { LD_LIBRARY_PATH=../lib ../src/json "$@"; }
$ json() { json0 -f "$@" <<< '\''{"a":{"b":"c"}}'\''; }
$ json -- ../lib/test-filter.so --no-fail -- ../lib/test-filter.so --fail=init -- ../lib/test-filter.so --fail=init
json: error: ../lib/test-filter.so: filter library #3: init failure
command failed: json -- ../lib/test-filter.so --no-fail -- ../lib/test-filter.so --fail=init -- ../lib/test-filter.so --fail=init
$ json -- ../lib/test-filter.so --no-fail -- ../lib/test-filter.so --fail=handler -- ../lib/test-filter.so --fail=handler
json: error: <stdin>: filter library #2: handler failure
command failed: json -- ../lib/test-filter.so --no-fail -- ../lib/test-filter.so --fail=handler -- ../lib/test-filter.so --fail=handler
$ json -- ../lib/test-filter.so --no-fail -- ../lib/test-filter.so --fail=exec -- ../lib/test-filter.so --fail=exec
/a/b=c
$ json -- ../lib/test-filter.so --fail=init -- ../lib/test-filter.so --no-fail -- ../lib/test-filter.so --fail=init
json: error: ../lib/test-filter.so: filter library #3: init failure
command failed: json -- ../lib/test-filter.so --fail=init -- ../lib/test-filter.so --no-fail -- ../lib/test-filter.so --fail=init
$ json -- ../lib/test-filter.so --fail=handler -- ../lib/test-filter.so --no-fail -- ../lib/test-filter.so --fail=handler
json: error: <stdin>: filter library #1: handler failure
command failed: json -- ../lib/test-filter.so --fail=handler -- ../lib/test-filter.so --no-fail -- ../lib/test-filter.so --fail=handler
$ json -- ../lib/test-filter.so --fail=exec -- ../lib/test-filter.so --no-fail -- ../lib/test-filter.so --fail=exec
/a/b=c
$ json -- ../lib/test-filter.so --fail=init -- ../lib/test-filter.so --fail=init -- ../lib/test-filter.so --no-fail
json: error: ../lib/test-filter.so: filter library #2: init failure
command failed: json -- ../lib/test-filter.so --fail=init -- ../lib/test-filter.so --fail=init -- ../lib/test-filter.so --no-fail
$ json -- ../lib/test-filter.so --fail=handler -- ../lib/test-filter.so --fail=handler -- ../lib/test-filter.so --no-fail
json: error: <stdin>: filter library #1: handler failure
command failed: json -- ../lib/test-filter.so --fail=handler -- ../lib/test-filter.so --fail=handler -- ../lib/test-filter.so --no-fail
$ json -- ../lib/test-filter.so --fail=exec -- ../lib/test-filter.so --fail=exec -- ../lib/test-filter.so --no-fail
/a/b=c'
) -L fail-twice.new <(
echo '$ json0() { LD_LIBRARY_PATH=../lib ../src/json "$@"; }'
json0() { LD_LIBRARY_PATH=../lib ../src/json "$@"; } 2>&1 ||
echo 'command failed: json0() { LD_LIBRARY_PATH=../lib ../src/json "$@"; }'

echo '$ json() { json0 -f "$@" <<< '\''{"a":{"b":"c"}}'\''; }'
json() { json0 -f "$@" <<< '{"a":{"b":"c"}}'; } 2>&1 ||
echo 'command failed: json() { json0 -f "$@" <<< '\''{"a":{"b":"c"}}'\''; }'

echo '$ json -- ../lib/test-filter.so --no-fail -- ../lib/test-filter.so --fail=init -- ../lib/test-filter.so --fail=init'
json -- ../lib/test-filter.so --no-fail -- ../lib/test-filter.so --fail=init -- ../lib/test-filter.so --fail=init 2>&1 ||
echo 'command failed: json -- ../lib/test-filter.so --no-fail -- ../lib/test-filter.so --fail=init -- ../lib/test-filter.so --fail=init'

echo '$ json -- ../lib/test-filter.so --no-fail -- ../lib/test-filter.so --fail=handler -- ../lib/test-filter.so --fail=handler'
json -- ../lib/test-filter.so --no-fail -- ../lib/test-filter.so --fail=handler -- ../lib/test-filter.so --fail=handler 2>&1 ||
echo 'command failed: json -- ../lib/test-filter.so --no-fail -- ../lib/test-filter.so --fail=handler -- ../lib/test-filter.so --fail=handler'

echo '$ json -- ../lib/test-filter.so --no-fail -- ../lib/test-filter.so --fail=exec -- ../lib/test-filter.so --fail=exec'
json -- ../lib/test-filter.so --no-fail -- ../lib/test-filter.so --fail=exec -- ../lib/test-filter.so --fail=exec 2>&1 ||
echo 'command failed: json -- ../lib/test-filter.so --no-fail -- ../lib/test-filter.so --fail=exec -- ../lib/test-filter.so --fail=exec'

echo '$ json -- ../lib/test-filter.so --fail=init -- ../lib/test-filter.so --no-fail -- ../lib/test-filter.so --fail=init'
json -- ../lib/test-filter.so --fail=init -- ../lib/test-filter.so --no-fail -- ../lib/test-filter.so --fail=init 2>&1 ||
echo 'command failed: json -- ../lib/test-filter.so --fail=init -- ../lib/test-filter.so --no-fail -- ../lib/test-filter.so --fail=init'

echo '$ json -- ../lib/test-filter.so --fail=handler -- ../lib/test-filter.so --no-fail -- ../lib/test-filter.so --fail=handler'
json -- ../lib/test-filter.so --fail=handler -- ../lib/test-filter.so --no-fail -- ../lib/test-filter.so --fail=handler 2>&1 ||
echo 'command failed: json -- ../lib/test-filter.so --fail=handler -- ../lib/test-filter.so --no-fail -- ../lib/test-filter.so --fail=handler'

echo '$ json -- ../lib/test-filter.so --fail=exec -- ../lib/test-filter.so --no-fail -- ../lib/test-filter.so --fail=exec'
json -- ../lib/test-filter.so --fail=exec -- ../lib/test-filter.so --no-fail -- ../lib/test-filter.so --fail=exec 2>&1 ||
echo 'command failed: json -- ../lib/test-filter.so --fail=exec -- ../lib/test-filter.so --no-fail -- ../lib/test-filter.so --fail=exec'

echo '$ json -- ../lib/test-filter.so --fail=init -- ../lib/test-filter.so --fail=init -- ../lib/test-filter.so --no-fail'
json -- ../lib/test-filter.so --fail=init -- ../lib/test-filter.so --fail=init -- ../lib/test-filter.so --no-fail 2>&1 ||
echo 'command failed: json -- ../lib/test-filter.so --fail=init -- ../lib/test-filter.so --fail=init -- ../lib/test-filter.so --no-fail'

echo '$ json -- ../lib/test-filter.so --fail=handler -- ../lib/test-filter.so --fail=handler -- ../lib/test-filter.so --no-fail'
json -- ../lib/test-filter.so --fail=handler -- ../lib/test-filter.so --fail=handler -- ../lib/test-filter.so --no-fail 2>&1 ||
echo 'command failed: json -- ../lib/test-filter.so --fail=handler -- ../lib/test-filter.so --fail=handler -- ../lib/test-filter.so --no-fail'

echo '$ json -- ../lib/test-filter.so --fail=exec -- ../lib/test-filter.so --fail=exec -- ../lib/test-filter.so --no-fail'
json -- ../lib/test-filter.so --fail=exec -- ../lib/test-filter.so --fail=exec -- ../lib/test-filter.so --no-fail 2>&1 ||
echo 'command failed: json -- ../lib/test-filter.so --fail=exec -- ../lib/test-filter.so --fail=exec -- ../lib/test-filter.so --no-fail'
)

