#!/bin/bash

# Copyright (C) 2016, 2017, 2018  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-cases:40
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L 40.old <(echo \
'$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@" 2>&1|sed -r '\''/error:/s|(/dev/fd/)[0-9]+|\1??|'\''; }
$ json -d '\''{"type":"list","args":[{"type":"array","args":{"type":"array","args":{"type":"list","args":["number","string"]}}},{"type":"array","args":["number"]},{"type":"array","args":["string"]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"array",...}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"type":"array","args":{"type":"list","args":["number","string"]}}},{"type":"array","args":["number"]},{"type":"array","args":["string"]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":{"type":"array","args":{"type":"list","args":["number","string"]}}},{"type":"array","args":["number"]},{"type":"array","args":["string"]}]}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"list","args":[{"type":"array","args":{"type":"array","args":{"type":"list","args":["number","string"]}}},{"type":"array","args":["number"]},{"type":"array","args":["string"]}]}'\'' <<< '\''[0]'\''
[0]
$ json -d '\''{"type":"list","args":[{"type":"array","args":{"type":"array","args":{"type":"list","args":["number","string"]}}},{"type":"array","args":["number"]},{"type":"array","args":["string"]}]}'\'' <<< '\''[0,1]'\''
json: error: <stdin>:1:3: type check error: too many arguments
json: error: <stdin>:1:3: [0,1]
json: error: <stdin>:1:3:   ^
[0
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"type":"array","args":{"type":"list","args":["number","string"]}}},{"type":"array","args":["number"]},{"type":"array","args":["string"]}]}'\'' <<< '\''[0,1]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":{"type":"array","args":{"type":"list","args":["number","string"]}}},{"type":"array","args":["number"]},{"type":"array","args":["string"]}]}'\'' <<< '\''[""]'\''
[""]
$ json -d '\''{"type":"list","args":[{"type":"array","args":{"type":"array","args":{"type":"list","args":["number","string"]}}},{"type":"array","args":["number"]},{"type":"array","args":["string"]}]}'\'' <<< '\''["",""]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: ["",""]
json: error: <stdin>:1:4:    ^
[""
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"type":"array","args":{"type":"list","args":["number","string"]}}},{"type":"array","args":["number"]},{"type":"array","args":["string"]}]}'\'' <<< '\''["",""]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":{"type":"array","args":{"type":"list","args":["number","string"]}}},{"type":"array","args":["number"]},{"type":"array","args":["string"]}]}'\'' <<< '\''[[0]]'\''
[[0]]
$ json -d '\''{"type":"list","args":[{"type":"array","args":{"type":"array","args":{"type":"list","args":["number","string"]}}},{"type":"array","args":["number"]},{"type":"array","args":["string"]}]}'\'' <<< '\''[[0,1]]'\''
[[0,1]]
$ json -d '\''{"type":"list","args":[{"type":"array","args":{"type":"array","args":{"type":"list","args":["number","string"]}}},{"type":"array","args":["number"]},{"type":"array","args":["string"]}]}'\'' <<< '\''[[0,false]]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `"number"'\'' or `"string"'\''
json: error: <stdin>:1:5: [[0,false]]
json: error: <stdin>:1:5:     ^
[[0,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"type":"array","args":{"type":"list","args":["number","string"]}}},{"type":"array","args":["number"]},{"type":"array","args":["string"]}]}'\'' <<< '\''[[0,false]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":{"type":"array","args":{"type":"list","args":["number","string"]}}},{"type":"array","args":["number"]},{"type":"array","args":["string"]}]}'\'' <<< '\''[[0,""]]'\''
[[0,""]]
$ json -d '\''{"type":"list","args":[{"type":"array","args":{"type":"array","args":{"type":"list","args":["number","string"]}}},{"type":"array","args":["number"]},{"type":"array","args":["string"]}]}'\'' <<< '\''[[""]]'\''
[[""]]
$ json -d '\''{"type":"list","args":[{"type":"array","args":{"type":"array","args":{"type":"list","args":["number","string"]}}},{"type":"array","args":["number"]},{"type":"array","args":["string"]}]}'\'' <<< '\''[["",""]]'\''
[["",""]]
$ json -d '\''{"type":"list","args":[{"type":"array","args":{"type":"array","args":{"type":"list","args":["number","string"]}}},{"type":"array","args":["number"]},{"type":"array","args":["string"]}]}'\'' <<< '\''[["",false]]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `"number"'\'' or `"string"'\''
json: error: <stdin>:1:6: [["",false]]
json: error: <stdin>:1:6:      ^
[["",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"type":"array","args":{"type":"list","args":["number","string"]}}},{"type":"array","args":["number"]},{"type":"array","args":["string"]}]}'\'' <<< '\''[["",false]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":{"type":"array","args":{"type":"list","args":["number","string"]}}},{"type":"array","args":["number"]},{"type":"array","args":["string"]}]}'\'' <<< '\''[["",1]]'\''
[["",1]]'
) -L 40.new <(
echo '$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@" 2>&1|sed -r '\''/error:/s|(/dev/fd/)[0-9]+|\1??|'\''; }'
json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@" 2>&1|sed -r '/error:/s|(/dev/fd/)[0-9]+|\1??|'; } 2>&1 ||
echo 'command failed: json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@" 2>&1|sed -r '\''/error:/s|(/dev/fd/)[0-9]+|\1??|'\''; }'

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":{"type":"array","args":{"type":"list","args":["number","string"]}}},{"type":"array","args":["number"]},{"type":"array","args":["string"]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":{"type":"array","args":{"type":"list","args":["number","string"]}}},{"type":"array","args":["number"]},{"type":"array","args":["string"]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"type":"array","args":{"type":"list","args":["number","string"]}}},{"type":"array","args":["number"]},{"type":"array","args":["string"]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":{"type":"array","args":{"type":"list","args":["number","string"]}}},{"type":"array","args":["number"]},{"type":"array","args":["string"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":{"type":"array","args":{"type":"list","args":["number","string"]}}},{"type":"array","args":["number"]},{"type":"array","args":["string"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"type":"array","args":{"type":"list","args":["number","string"]}}},{"type":"array","args":["number"]},{"type":"array","args":["string"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":{"type":"array","args":{"type":"list","args":["number","string"]}}},{"type":"array","args":["number"]},{"type":"array","args":["string"]}]}'\'' <<< '\''[0]'\'''
json -d '{"type":"list","args":[{"type":"array","args":{"type":"array","args":{"type":"list","args":["number","string"]}}},{"type":"array","args":["number"]},{"type":"array","args":["string"]}]}' <<< '[0]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"type":"array","args":{"type":"list","args":["number","string"]}}},{"type":"array","args":["number"]},{"type":"array","args":["string"]}]}'\'' <<< '\''[0]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":{"type":"array","args":{"type":"list","args":["number","string"]}}},{"type":"array","args":["number"]},{"type":"array","args":["string"]}]}'\'' <<< '\''[0,1]'\'''
json -d '{"type":"list","args":[{"type":"array","args":{"type":"array","args":{"type":"list","args":["number","string"]}}},{"type":"array","args":["number"]},{"type":"array","args":["string"]}]}' <<< '[0,1]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"type":"array","args":{"type":"list","args":["number","string"]}}},{"type":"array","args":["number"]},{"type":"array","args":["string"]}]}'\'' <<< '\''[0,1]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":{"type":"array","args":{"type":"list","args":["number","string"]}}},{"type":"array","args":["number"]},{"type":"array","args":["string"]}]}'\'' <<< '\''[""]'\'''
json -d '{"type":"list","args":[{"type":"array","args":{"type":"array","args":{"type":"list","args":["number","string"]}}},{"type":"array","args":["number"]},{"type":"array","args":["string"]}]}' <<< '[""]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"type":"array","args":{"type":"list","args":["number","string"]}}},{"type":"array","args":["number"]},{"type":"array","args":["string"]}]}'\'' <<< '\''[""]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":{"type":"array","args":{"type":"list","args":["number","string"]}}},{"type":"array","args":["number"]},{"type":"array","args":["string"]}]}'\'' <<< '\''["",""]'\'''
json -d '{"type":"list","args":[{"type":"array","args":{"type":"array","args":{"type":"list","args":["number","string"]}}},{"type":"array","args":["number"]},{"type":"array","args":["string"]}]}' <<< '["",""]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"type":"array","args":{"type":"list","args":["number","string"]}}},{"type":"array","args":["number"]},{"type":"array","args":["string"]}]}'\'' <<< '\''["",""]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":{"type":"array","args":{"type":"list","args":["number","string"]}}},{"type":"array","args":["number"]},{"type":"array","args":["string"]}]}'\'' <<< '\''[[0]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":{"type":"array","args":{"type":"list","args":["number","string"]}}},{"type":"array","args":["number"]},{"type":"array","args":["string"]}]}' <<< '[[0]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"type":"array","args":{"type":"list","args":["number","string"]}}},{"type":"array","args":["number"]},{"type":"array","args":["string"]}]}'\'' <<< '\''[[0]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":{"type":"array","args":{"type":"list","args":["number","string"]}}},{"type":"array","args":["number"]},{"type":"array","args":["string"]}]}'\'' <<< '\''[[0,1]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":{"type":"array","args":{"type":"list","args":["number","string"]}}},{"type":"array","args":["number"]},{"type":"array","args":["string"]}]}' <<< '[[0,1]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"type":"array","args":{"type":"list","args":["number","string"]}}},{"type":"array","args":["number"]},{"type":"array","args":["string"]}]}'\'' <<< '\''[[0,1]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":{"type":"array","args":{"type":"list","args":["number","string"]}}},{"type":"array","args":["number"]},{"type":"array","args":["string"]}]}'\'' <<< '\''[[0,false]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":{"type":"array","args":{"type":"list","args":["number","string"]}}},{"type":"array","args":["number"]},{"type":"array","args":["string"]}]}' <<< '[[0,false]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"type":"array","args":{"type":"list","args":["number","string"]}}},{"type":"array","args":["number"]},{"type":"array","args":["string"]}]}'\'' <<< '\''[[0,false]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":{"type":"array","args":{"type":"list","args":["number","string"]}}},{"type":"array","args":["number"]},{"type":"array","args":["string"]}]}'\'' <<< '\''[[0,""]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":{"type":"array","args":{"type":"list","args":["number","string"]}}},{"type":"array","args":["number"]},{"type":"array","args":["string"]}]}' <<< '[[0,""]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"type":"array","args":{"type":"list","args":["number","string"]}}},{"type":"array","args":["number"]},{"type":"array","args":["string"]}]}'\'' <<< '\''[[0,""]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":{"type":"array","args":{"type":"list","args":["number","string"]}}},{"type":"array","args":["number"]},{"type":"array","args":["string"]}]}'\'' <<< '\''[[""]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":{"type":"array","args":{"type":"list","args":["number","string"]}}},{"type":"array","args":["number"]},{"type":"array","args":["string"]}]}' <<< '[[""]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"type":"array","args":{"type":"list","args":["number","string"]}}},{"type":"array","args":["number"]},{"type":"array","args":["string"]}]}'\'' <<< '\''[[""]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":{"type":"array","args":{"type":"list","args":["number","string"]}}},{"type":"array","args":["number"]},{"type":"array","args":["string"]}]}'\'' <<< '\''[["",""]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":{"type":"array","args":{"type":"list","args":["number","string"]}}},{"type":"array","args":["number"]},{"type":"array","args":["string"]}]}' <<< '[["",""]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"type":"array","args":{"type":"list","args":["number","string"]}}},{"type":"array","args":["number"]},{"type":"array","args":["string"]}]}'\'' <<< '\''[["",""]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":{"type":"array","args":{"type":"list","args":["number","string"]}}},{"type":"array","args":["number"]},{"type":"array","args":["string"]}]}'\'' <<< '\''[["",false]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":{"type":"array","args":{"type":"list","args":["number","string"]}}},{"type":"array","args":["number"]},{"type":"array","args":["string"]}]}' <<< '[["",false]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"type":"array","args":{"type":"list","args":["number","string"]}}},{"type":"array","args":["number"]},{"type":"array","args":["string"]}]}'\'' <<< '\''[["",false]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":{"type":"array","args":{"type":"list","args":["number","string"]}}},{"type":"array","args":["number"]},{"type":"array","args":["string"]}]}'\'' <<< '\''[["",1]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":{"type":"array","args":{"type":"list","args":["number","string"]}}},{"type":"array","args":["number"]},{"type":"array","args":["string"]}]}' <<< '[["",1]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"type":"array","args":{"type":"list","args":["number","string"]}}},{"type":"array","args":["number"]},{"type":"array","args":["string"]}]}'\'' <<< '\''[["",1]]'\'''
)

