#!/bin/bash

# Copyright (C) 2016, 2017, 2018  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C parser:char
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L char.old <(echo \
'$ json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }
$ json() { json0 --literal-value "$@"; }
$ echo '\''a'\''|json
json: error: <stdin>:1:1: lex error: invalid char
json: error: <stdin>:1:1: a
json: error: <stdin>:1:1: ^
command failed: echo '\''a'\''|json
$ echo -n '\''a'\''|json
json: error: <stdin>:1:1: lex error: invalid char
json: error: <stdin>:1:1: a
json: error: <stdin>:1:1: ^
command failed: echo -n '\''a'\''|json
$ echo -e '\''a\n'\''|json
json: error: <stdin>:1:1: lex error: invalid char
json: error: <stdin>:1:1: a\n
json: error: <stdin>:1:1: ^
command failed: echo -e '\''a\n'\''|json
$ echo -e '\''\na'\''|json
json: error: <stdin>:2:1: lex error: invalid char
json: error: <stdin>:2:1: \na
json: error: <stdin>:2:1:   ^
command failed: echo -e '\''\na'\''|json
$ echo '\''a '\''|json
json: error: <stdin>:1:1: lex error: invalid char
json: error: <stdin>:1:1: a 
json: error: <stdin>:1:1: ^
command failed: echo '\''a '\''|json
$ echo '\'' a'\''|json
json: error: <stdin>:1:2: lex error: invalid char
json: error: <stdin>:1:2:  a
json: error: <stdin>:1:2:  ^
command failed: echo '\'' a'\''|json
$ echo -e '\''a\t'\''|json
json: error: <stdin>:1:1: lex error: invalid char
json: error: <stdin>:1:1: a\t
json: error: <stdin>:1:1: ^
command failed: echo -e '\''a\t'\''|json
$ echo -e '\''\ta'\''|json
json: error: <stdin>:1:2: lex error: invalid char
json: error: <stdin>:1:2: \ta
json: error: <stdin>:1:2:   ^
command failed: echo -e '\''\ta'\''|json
$ echo -e '\''a\r'\''|json
json: error: <stdin>:1:1: lex error: invalid char
json: error: <stdin>:1:1: a\r
json: error: <stdin>:1:1: ^
command failed: echo -e '\''a\r'\''|json
$ echo -e '\''\ra'\''|json
json: error: <stdin>:1:2: lex error: invalid char
json: error: <stdin>:1:2: \ra
json: error: <stdin>:1:2:   ^
command failed: echo -e '\''\ra'\''|json'
) -L char.new <(
echo '$ json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }'
json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; } 2>&1 ||
echo 'command failed: json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }'

echo '$ json() { json0 --literal-value "$@"; }'
json() { json0 --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { json0 --literal-value "$@"; }'

echo '$ echo '\''a'\''|json'
echo 'a'|json 2>&1 ||
echo 'command failed: echo '\''a'\''|json'

echo '$ echo -n '\''a'\''|json'
echo -n 'a'|json 2>&1 ||
echo 'command failed: echo -n '\''a'\''|json'

echo '$ echo -e '\''a\n'\''|json'
echo -e 'a\n'|json 2>&1 ||
echo 'command failed: echo -e '\''a\n'\''|json'

echo '$ echo -e '\''\na'\''|json'
echo -e '\na'|json 2>&1 ||
echo 'command failed: echo -e '\''\na'\''|json'

echo '$ echo '\''a '\''|json'
echo 'a '|json 2>&1 ||
echo 'command failed: echo '\''a '\''|json'

echo '$ echo '\'' a'\''|json'
echo ' a'|json 2>&1 ||
echo 'command failed: echo '\'' a'\''|json'

echo '$ echo -e '\''a\t'\''|json'
echo -e 'a\t'|json 2>&1 ||
echo 'command failed: echo -e '\''a\t'\''|json'

echo '$ echo -e '\''\ta'\''|json'
echo -e '\ta'|json 2>&1 ||
echo 'command failed: echo -e '\''\ta'\''|json'

echo '$ echo -e '\''a\r'\''|json'
echo -e 'a\r'|json 2>&1 ||
echo 'command failed: echo -e '\''a\r'\''|json'

echo '$ echo -e '\''\ra'\''|json'
echo -e '\ra'|json 2>&1 ||
echo 'command failed: echo -e '\''\ra'\''|json'
)

