#!/bin/bash

# Copyright (C) 2016, 2017, 2018  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-checker:open-array5
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L open-array5.old <(echo \
'$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes
$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }
$ json -d '\''{"type":"array","args":"type"}'\'' <<< '\''[false,null]'\''
[false,null]
$ json -d '\''{"type":"array","args":"type"}'\'' <<< '\''[false,false]'\''
[false,false]
$ json -d '\''{"type":"array","args":"type"}'\'' <<< '\''[false,true]'\''
[false,true]
$ json -d '\''{"type":"array","args":"type"}'\'' <<< '\''[false,123]'\''
[false,123]
$ json -d '\''{"type":"array","args":"type"}'\'' <<< '\''[false,"foo"]'\''
[false,"foo"]
$ json -d '\''{"type":"array","args":"type"}'\'' <<< '\''[false,{}]'\''
[false,{}]
$ json -d '\''{"type":"array","args":"type"}'\'' <<< '\''[false,[]]'\''
[false,[]]
$ json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[false,null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:2: [false,null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[false,null]'\''
$ json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[false,false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:2: [false,false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[false,false]'\''
$ json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[false,true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:2: [false,true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[false,true]'\''
$ json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[false,123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:2: [false,123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[false,123]'\''
$ json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[false,"foo"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:2: [false,"foo"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[false,"foo"]'\''
$ json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[false,{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:2: [false,{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[false,{}]'\''
$ json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[false,[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:2: [false,[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[false,[]]'\''
$ json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[false,null]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: [false,null]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[false,null]'\''
$ json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[false,false]'\''
[false,false]
$ json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[false,true]'\''
[false,true]
$ json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[false,123]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: [false,123]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[false,123]'\''
$ json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[false,"foo"]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: [false,"foo"]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[false,"foo"]'\''
$ json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[false,{}]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: [false,{}]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[false,{}]'\''
$ json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[false,[]]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: [false,[]]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[false,[]]'\''
$ json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[false,null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:2: [false,null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[false,null]'\''
$ json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[false,false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:2: [false,false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[false,false]'\''
$ json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[false,true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:2: [false,true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[false,true]'\''
$ json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[false,123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:2: [false,123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[false,123]'\''
$ json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[false,"foo"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:2: [false,"foo"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[false,"foo"]'\''
$ json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[false,{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:2: [false,{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[false,{}]'\''
$ json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[false,[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:2: [false,[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[false,[]]'\''
$ json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[false,null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:2: [false,null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[false,null]'\''
$ json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[false,false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:2: [false,false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[false,false]'\''
$ json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[false,true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:2: [false,true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[false,true]'\''
$ json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[false,123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:2: [false,123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[false,123]'\''
$ json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[false,"foo"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:2: [false,"foo"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[false,"foo"]'\''
$ json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[false,{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:2: [false,{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[false,{}]'\''
$ json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[false,[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:2: [false,[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[false,[]]'\''
$ json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[false,null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:2: [false,null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[false,null]'\''
$ json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[false,false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:2: [false,false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[false,false]'\''
$ json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[false,true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:2: [false,true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[false,true]'\''
$ json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[false,123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:2: [false,123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[false,123]'\''
$ json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[false,"foo"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:2: [false,"foo"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[false,"foo"]'\''
$ json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[false,{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:2: [false,{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[false,{}]'\''
$ json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[false,[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:2: [false,[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[false,[]]'\''
$ json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[false,null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:2: [false,null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[false,null]'\''
$ json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[false,false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:2: [false,false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[false,false]'\''
$ json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[false,true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:2: [false,true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[false,true]'\''
$ json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[false,123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:2: [false,123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[false,123]'\''
$ json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[false,"foo"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:2: [false,"foo"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[false,"foo"]'\''
$ json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[false,{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:2: [false,{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[false,{}]'\''
$ json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[false,[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:2: [false,[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[false,[]]'\'''
) -L open-array5.new <(
echo '$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'
export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes 2>&1 ||
echo 'command failed: export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'

echo '$ json -d '\''{"type":"array","args":"type"}'\'' <<< '\''[false,null]'\'''
json -d '{"type":"array","args":"type"}' <<< '[false,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"type"}'\'' <<< '\''[false,null]'\'''

echo '$ json -d '\''{"type":"array","args":"type"}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"array","args":"type"}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"type"}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"array","args":"type"}'\'' <<< '\''[false,true]'\'''
json -d '{"type":"array","args":"type"}' <<< '[false,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"type"}'\'' <<< '\''[false,true]'\'''

echo '$ json -d '\''{"type":"array","args":"type"}'\'' <<< '\''[false,123]'\'''
json -d '{"type":"array","args":"type"}' <<< '[false,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"type"}'\'' <<< '\''[false,123]'\'''

echo '$ json -d '\''{"type":"array","args":"type"}'\'' <<< '\''[false,"foo"]'\'''
json -d '{"type":"array","args":"type"}' <<< '[false,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"type"}'\'' <<< '\''[false,"foo"]'\'''

echo '$ json -d '\''{"type":"array","args":"type"}'\'' <<< '\''[false,{}]'\'''
json -d '{"type":"array","args":"type"}' <<< '[false,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"type"}'\'' <<< '\''[false,{}]'\'''

echo '$ json -d '\''{"type":"array","args":"type"}'\'' <<< '\''[false,[]]'\'''
json -d '{"type":"array","args":"type"}' <<< '[false,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"type"}'\'' <<< '\''[false,[]]'\'''

echo '$ json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[false,null]'\'''
json -d '{"type":"array","args":"null"}' <<< '[false,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[false,null]'\'''

echo '$ json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"array","args":"null"}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[false,true]'\'''
json -d '{"type":"array","args":"null"}' <<< '[false,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[false,true]'\'''

echo '$ json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[false,123]'\'''
json -d '{"type":"array","args":"null"}' <<< '[false,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[false,123]'\'''

echo '$ json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[false,"foo"]'\'''
json -d '{"type":"array","args":"null"}' <<< '[false,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[false,"foo"]'\'''

echo '$ json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[false,{}]'\'''
json -d '{"type":"array","args":"null"}' <<< '[false,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[false,{}]'\'''

echo '$ json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[false,[]]'\'''
json -d '{"type":"array","args":"null"}' <<< '[false,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[false,[]]'\'''

echo '$ json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[false,null]'\'''
json -d '{"type":"array","args":"boolean"}' <<< '[false,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[false,null]'\'''

echo '$ json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"array","args":"boolean"}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[false,true]'\'''
json -d '{"type":"array","args":"boolean"}' <<< '[false,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[false,true]'\'''

echo '$ json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[false,123]'\'''
json -d '{"type":"array","args":"boolean"}' <<< '[false,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[false,123]'\'''

echo '$ json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[false,"foo"]'\'''
json -d '{"type":"array","args":"boolean"}' <<< '[false,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[false,"foo"]'\'''

echo '$ json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[false,{}]'\'''
json -d '{"type":"array","args":"boolean"}' <<< '[false,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[false,{}]'\'''

echo '$ json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[false,[]]'\'''
json -d '{"type":"array","args":"boolean"}' <<< '[false,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[false,[]]'\'''

echo '$ json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[false,null]'\'''
json -d '{"type":"array","args":"number"}' <<< '[false,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[false,null]'\'''

echo '$ json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"array","args":"number"}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[false,true]'\'''
json -d '{"type":"array","args":"number"}' <<< '[false,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[false,true]'\'''

echo '$ json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[false,123]'\'''
json -d '{"type":"array","args":"number"}' <<< '[false,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[false,123]'\'''

echo '$ json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[false,"foo"]'\'''
json -d '{"type":"array","args":"number"}' <<< '[false,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[false,"foo"]'\'''

echo '$ json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[false,{}]'\'''
json -d '{"type":"array","args":"number"}' <<< '[false,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[false,{}]'\'''

echo '$ json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[false,[]]'\'''
json -d '{"type":"array","args":"number"}' <<< '[false,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[false,[]]'\'''

echo '$ json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[false,null]'\'''
json -d '{"type":"array","args":"string"}' <<< '[false,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[false,null]'\'''

echo '$ json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"array","args":"string"}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[false,true]'\'''
json -d '{"type":"array","args":"string"}' <<< '[false,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[false,true]'\'''

echo '$ json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[false,123]'\'''
json -d '{"type":"array","args":"string"}' <<< '[false,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[false,123]'\'''

echo '$ json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[false,"foo"]'\'''
json -d '{"type":"array","args":"string"}' <<< '[false,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[false,"foo"]'\'''

echo '$ json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[false,{}]'\'''
json -d '{"type":"array","args":"string"}' <<< '[false,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[false,{}]'\'''

echo '$ json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[false,[]]'\'''
json -d '{"type":"array","args":"string"}' <<< '[false,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[false,[]]'\'''

echo '$ json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[false,null]'\'''
json -d '{"type":"array","args":"object"}' <<< '[false,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[false,null]'\'''

echo '$ json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"array","args":"object"}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[false,true]'\'''
json -d '{"type":"array","args":"object"}' <<< '[false,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[false,true]'\'''

echo '$ json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[false,123]'\'''
json -d '{"type":"array","args":"object"}' <<< '[false,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[false,123]'\'''

echo '$ json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[false,"foo"]'\'''
json -d '{"type":"array","args":"object"}' <<< '[false,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[false,"foo"]'\'''

echo '$ json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[false,{}]'\'''
json -d '{"type":"array","args":"object"}' <<< '[false,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[false,{}]'\'''

echo '$ json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[false,[]]'\'''
json -d '{"type":"array","args":"object"}' <<< '[false,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[false,[]]'\'''

echo '$ json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[false,null]'\'''
json -d '{"type":"array","args":"array"}' <<< '[false,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[false,null]'\'''

echo '$ json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"array","args":"array"}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[false,true]'\'''
json -d '{"type":"array","args":"array"}' <<< '[false,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[false,true]'\'''

echo '$ json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[false,123]'\'''
json -d '{"type":"array","args":"array"}' <<< '[false,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[false,123]'\'''

echo '$ json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[false,"foo"]'\'''
json -d '{"type":"array","args":"array"}' <<< '[false,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[false,"foo"]'\'''

echo '$ json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[false,{}]'\'''
json -d '{"type":"array","args":"array"}' <<< '[false,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[false,{}]'\'''

echo '$ json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[false,[]]'\'''
json -d '{"type":"array","args":"array"}' <<< '[false,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[false,[]]'\'''
)

