#!/bin/bash

# Copyright (C) 2016, 2017, 2018  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-checker:dict-expr4
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L dict-expr4.old <(echo \
'$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes
$ json() { set -o pipefail && ../lib/test-gen --dict -V -d1 -k3 -ae "$2"|LD_LIBRARY_PATH=../lib ../src/json -EV -t <(../lib/test-gen --dict -T -d1 -k3 -ae "$1"); }
$ json '\''a ~a b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a ~a ~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a ~a c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a ~a ~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a b ~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a b ~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a b c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a b ~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a ~b ~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a ~b b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a ~b c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a ~b ~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a c ~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a c b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a c ~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a c ~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a ~c ~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a ~c b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a ~c ~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a ~c c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a a b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a a ~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a a c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a a ~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a b a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a b ~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a b c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a b ~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a ~b a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a ~b b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a ~b c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a ~b c'\'' '\''a,b'\''
$ json '\''~a ~b ~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a c a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a c b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a c ~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a c ~b'\'' '\''a,b'\''
$ json '\''~a c ~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a ~c a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a ~c b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a ~c ~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a ~c c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b a ~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b a ~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b a c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b a ~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b ~a a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b ~a ~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b ~a c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b ~a ~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b ~b a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b ~b ~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b ~b c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b ~b ~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b c a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b c ~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b c ~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b c ~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b ~c a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b ~c ~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b ~c ~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b ~c c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b a ~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b a b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b a c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b a ~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b ~a a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b ~a b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b ~a c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b ~a c'\'' '\''a,b'\''
$ json '\''~b ~a ~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b b a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b b ~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b b c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b b ~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b c a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b c ~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b c ~a'\'' '\''a,b'\''
$ json '\''~b c b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b c ~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b ~c a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b ~c ~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b ~c b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b ~c c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c a ~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c a b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c a ~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c a ~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c ~a a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c ~a b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c ~a ~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c ~a ~b'\'' '\''a,b'\''
$ json '\''c ~a ~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c b a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c b ~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c b ~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c b ~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c ~b a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c ~b ~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c ~b ~a'\'' '\''a,b'\''
$ json '\''c ~b b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c ~b ~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c ~c a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c ~c ~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c ~c b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c ~c ~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c a ~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c a b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c a ~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c a c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c ~a a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c ~a b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c ~a ~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c ~a c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c b a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c b ~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c b ~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c b c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c ~b a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c ~b ~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c ~b b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c ~b c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c c a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c c ~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c c b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c c ~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a ~a|b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a ~a|~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''a ~a|~b'\'' '\''a,b'\''
$ json '\''a ~a|c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''a ~a|c'\'' '\''a,b'\''
$ json '\''a ~a|~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a b|~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''a b|~a'\'' '\''a,b'\''
$ json '\''a b|~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''a b|~b'\'' '\''a,b'\''
$ json '\''a b|c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''a b|c'\'' '\''a,b'\''
$ json '\''a b|~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a ~b|~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''a ~b|~a'\'' '\''a,b'\''
$ json '\''a ~b|b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a ~b|c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''a ~b|c'\'' '\''a,b'\''
$ json '\''a ~b|~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a c|~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''a c|~a'\'' '\''a,b'\''
$ json '\''a c|b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a c|~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''a c|~b'\'' '\''a,b'\''
$ json '\''a c|~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a ~c|~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''a ~c|~a'\'' '\''a,b'\''
$ json '\''a ~c|b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a ~c|~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''a ~c|~b'\'' '\''a,b'\''
$ json '\''a ~c|c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''a ~c|c'\'' '\''a,b'\''
$ json '\''~a a|b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a a|~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a a|~b'\'' '\''a,b'\''
$ json '\''~a a|c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a a|c'\'' '\''a,b'\''
$ json '\''~a a|~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a b|a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a b|~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a b|~b'\'' '\''a,b'\''
$ json '\''~a b|c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a b|c'\'' '\''a,b'\''
$ json '\''~a b|~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a ~b|a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a ~b|a'\'' '\''a,b'\''
$ json '\''~a ~b|b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a ~b|b'\'' '\''a,b'\''
$ json '\''~a ~b|c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a ~b|c'\'' '\''a,b'\''
$ json '\''~a ~b|~c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a ~b|~c'\'' '\''a,b'\''
$ json '\''~a c|a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a c|a'\'' '\''a,b'\''
$ json '\''~a c|b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a c|b'\'' '\''a,b'\''
$ json '\''~a c|~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a c|~b'\'' '\''a,b'\''
$ json '\''~a c|~c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a c|~c'\'' '\''a,b'\''
$ json '\''~a ~c|a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a ~c|b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a ~c|~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a ~c|~b'\'' '\''a,b'\''
$ json '\''~a ~c|c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a ~c|c'\'' '\''a,b'\''
$ json '\''b a|~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''b a|~a'\'' '\''a,b'\''
$ json '\''b a|~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''b a|~b'\'' '\''a,b'\''
$ json '\''b a|c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''b a|c'\'' '\''a,b'\''
$ json '\''b a|~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b ~a|a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b ~a|~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''b ~a|~b'\'' '\''a,b'\''
$ json '\''b ~a|c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''b ~a|c'\'' '\''a,b'\''
$ json '\''b ~a|~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b ~b|a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b ~b|~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''b ~b|~a'\'' '\''a,b'\''
$ json '\''b ~b|c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''b ~b|c'\'' '\''a,b'\''
$ json '\''b ~b|~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b c|a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b c|~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''b c|~a'\'' '\''a,b'\''
$ json '\''b c|~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''b c|~b'\'' '\''a,b'\''
$ json '\''b c|~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b ~c|a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b ~c|~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''b ~c|~a'\'' '\''a,b'\''
$ json '\''b ~c|~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''b ~c|~b'\'' '\''a,b'\''
$ json '\''b ~c|c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''b ~c|c'\'' '\''a,b'\''
$ json '\''~b a|~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b a|~a'\'' '\''a,b'\''
$ json '\''~b a|b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b a|c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b a|c'\'' '\''a,b'\''
$ json '\''~b a|~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b ~a|a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b ~a|a'\'' '\''a,b'\''
$ json '\''~b ~a|b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b ~a|b'\'' '\''a,b'\''
$ json '\''~b ~a|c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b ~a|c'\'' '\''a,b'\''
$ json '\''~b ~a|~c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b ~a|~c'\'' '\''a,b'\''
$ json '\''~b b|a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b b|~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b b|~a'\'' '\''a,b'\''
$ json '\''~b b|c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b b|c'\'' '\''a,b'\''
$ json '\''~b b|~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b c|a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b c|a'\'' '\''a,b'\''
$ json '\''~b c|~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b c|~a'\'' '\''a,b'\''
$ json '\''~b c|b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b c|b'\'' '\''a,b'\''
$ json '\''~b c|~c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b c|~c'\'' '\''a,b'\''
$ json '\''~b ~c|a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b ~c|~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b ~c|~a'\'' '\''a,b'\''
$ json '\''~b ~c|b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b ~c|c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b ~c|c'\'' '\''a,b'\''
$ json '\''c a|~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c a|~a'\'' '\''a,b'\''
$ json '\''c a|b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c a|~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c a|~b'\'' '\''a,b'\''
$ json '\''c a|~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c ~a|a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c ~a|a'\'' '\''a,b'\''
$ json '\''c ~a|b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c ~a|b'\'' '\''a,b'\''
$ json '\''c ~a|~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c ~a|~b'\'' '\''a,b'\''
$ json '\''c ~a|~c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c ~a|~c'\'' '\''a,b'\''
$ json '\''c b|a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c b|~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c b|~a'\'' '\''a,b'\''
$ json '\''c b|~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c b|~b'\'' '\''a,b'\''
$ json '\''c b|~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c ~b|a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c ~b|a'\'' '\''a,b'\''
$ json '\''c ~b|~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c ~b|~a'\'' '\''a,b'\''
$ json '\''c ~b|b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c ~b|b'\'' '\''a,b'\''
$ json '\''c ~b|~c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c ~b|~c'\'' '\''a,b'\''
$ json '\''c ~c|a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c ~c|~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c ~c|~a'\'' '\''a,b'\''
$ json '\''c ~c|b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c ~c|~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c ~c|~b'\'' '\''a,b'\''
$ json '\''~c a|~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~c a|~a'\'' '\''a,b'\''
$ json '\''~c a|b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c a|~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~c a|~b'\'' '\''a,b'\''
$ json '\''~c a|c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~c a|c'\'' '\''a,b'\''
$ json '\''~c ~a|a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c ~a|b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c ~a|~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~c ~a|~b'\'' '\''a,b'\''
$ json '\''~c ~a|c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~c ~a|c'\'' '\''a,b'\''
$ json '\''~c b|a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c b|~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~c b|~a'\'' '\''a,b'\''
$ json '\''~c b|~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~c b|~b'\'' '\''a,b'\''
$ json '\''~c b|c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~c b|c'\'' '\''a,b'\''
$ json '\''~c ~b|a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c ~b|~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~c ~b|~a'\'' '\''a,b'\''
$ json '\''~c ~b|b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c ~b|c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~c ~b|c'\'' '\''a,b'\''
$ json '\''~c c|a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c c|~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~c c|~a'\'' '\''a,b'\''
$ json '\''~c c|b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c c|~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~c c|~b'\'' '\''a,b'\''
$ json '\''a ~a||b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a ~a||~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a ~a||c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a ~a||~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a b||~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a b||~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a b||c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a b||~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a ~b||~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a ~b||b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a ~b||c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a ~b||~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a c||~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a c||b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a c||~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a c||~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a ~c||~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a ~c||b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a ~c||~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a ~c||c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a a||b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a a||~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a a||c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a a||~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a b||a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a b||~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a b||c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a b||~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a ~b||a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a ~b||b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a ~b||c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a ~b||c'\'' '\''a,b'\''
$ json '\''~a ~b||~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a c||a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a c||b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a c||~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a c||~b'\'' '\''a,b'\''
$ json '\''~a c||~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a ~c||a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a ~c||b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a ~c||~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a ~c||c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b a||~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b a||~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b a||c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b a||~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b ~a||a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b ~a||~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b ~a||c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b ~a||~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b ~b||a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b ~b||~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b ~b||c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b ~b||~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b c||a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b c||~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b c||~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b c||~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b ~c||a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b ~c||~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b ~c||~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b ~c||c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b a||~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b a||b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b a||c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b a||~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b ~a||a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b ~a||b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b ~a||c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b ~a||c'\'' '\''a,b'\''
$ json '\''~b ~a||~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b b||a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b b||~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b b||c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b b||~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b c||a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b c||~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b c||~a'\'' '\''a,b'\''
$ json '\''~b c||b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b c||~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b ~c||a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b ~c||~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b ~c||b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b ~c||c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c a||~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c a||b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c a||~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c a||~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c ~a||a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c ~a||b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c ~a||~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c ~a||~b'\'' '\''a,b'\''
$ json '\''c ~a||~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c b||a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c b||~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c b||~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c b||~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c ~b||a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c ~b||~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c ~b||~a'\'' '\''a,b'\''
$ json '\''c ~b||b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c ~b||~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c ~c||a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c ~c||~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c ~c||b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c ~c||~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c a||~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c a||b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c a||~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c a||c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c ~a||a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c ~a||b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c ~a||~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c ~a||c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c b||a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c b||~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c b||~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c b||c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c ~b||a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c ~b||~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c ~b||b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c ~b||c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c c||a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c c||~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c c||b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c c||~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a|~a b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a|~a ~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''a|~a ~b'\'' '\''a,b'\''
$ json '\''a|~a c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''a|~a c'\'' '\''a,b'\''
$ json '\''a|~a ~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a|b ~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a|b ~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a|b c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a|b ~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a|~b ~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''a|~b ~a'\'' '\''a,b'\''
$ json '\''a|~b b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a|~b c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''a|~b c'\'' '\''a,b'\''
$ json '\''a|~b ~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a|c ~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''a|c ~a'\'' '\''a,b'\''
$ json '\''a|c b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a|c ~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''a|c ~b'\'' '\''a,b'\''
$ json '\''a|c ~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a|~c ~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a|~c b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a|~c ~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a|~c c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a|a b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a|a b'\'' '\''a,b'\''
$ json '\''~a|a ~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a|a ~b'\'' '\''a,b'\''
$ json '\''~a|a c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a|a c'\'' '\''a,b'\''
$ json '\''~a|a ~c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a|a ~c'\'' '\''a,b'\''
$ json '\''~a|b a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a|b a'\'' '\''a,b'\''
$ json '\''~a|b ~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a|b ~b'\'' '\''a,b'\''
$ json '\''~a|b c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a|b c'\'' '\''a,b'\''
$ json '\''~a|b ~c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a|b ~c'\'' '\''a,b'\''
$ json '\''~a|~b a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a|~b a'\'' '\''a,b'\''
$ json '\''~a|~b b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a|~b b'\'' '\''a,b'\''
$ json '\''~a|~b c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a|~b c'\'' '\''a,b'\''
$ json '\''~a|~b ~c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a|~b ~c'\'' '\''a,b'\''
$ json '\''~a|c a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a|c a'\'' '\''a,b'\''
$ json '\''~a|c b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a|c b'\'' '\''a,b'\''
$ json '\''~a|c ~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a|c ~b'\'' '\''a,b'\''
$ json '\''~a|c ~c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a|c ~c'\'' '\''a,b'\''
$ json '\''~a|~c a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a|~c a'\'' '\''a,b'\''
$ json '\''~a|~c b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a|~c b'\'' '\''a,b'\''
$ json '\''~a|~c ~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a|~c ~b'\'' '\''a,b'\''
$ json '\''~a|~c c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a|~c c'\'' '\''a,b'\''
$ json '\''b|a ~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b|a ~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b|a c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b|a ~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b|~a a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b|~a ~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''b|~a ~b'\'' '\''a,b'\''
$ json '\''b|~a c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''b|~a c'\'' '\''a,b'\''
$ json '\''b|~a ~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b|~b a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b|~b ~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''b|~b ~a'\'' '\''a,b'\''
$ json '\''b|~b c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''b|~b c'\'' '\''a,b'\''
$ json '\''b|~b ~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b|c a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b|c ~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''b|c ~a'\'' '\''a,b'\''
$ json '\''b|c ~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''b|c ~b'\'' '\''a,b'\''
$ json '\''b|c ~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b|~c a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b|~c ~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b|~c ~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b|~c c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b|a ~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b|a ~a'\'' '\''a,b'\''
$ json '\''~b|a b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b|a b'\'' '\''a,b'\''
$ json '\''~b|a c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b|a c'\'' '\''a,b'\''
$ json '\''~b|a ~c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b|a ~c'\'' '\''a,b'\''
$ json '\''~b|~a a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b|~a a'\'' '\''a,b'\''
$ json '\''~b|~a b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b|~a b'\'' '\''a,b'\''
$ json '\''~b|~a c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b|~a c'\'' '\''a,b'\''
$ json '\''~b|~a ~c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b|~a ~c'\'' '\''a,b'\''
$ json '\''~b|b a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b|b a'\'' '\''a,b'\''
$ json '\''~b|b ~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b|b ~a'\'' '\''a,b'\''
$ json '\''~b|b c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b|b c'\'' '\''a,b'\''
$ json '\''~b|b ~c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b|b ~c'\'' '\''a,b'\''
$ json '\''~b|c a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b|c a'\'' '\''a,b'\''
$ json '\''~b|c ~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b|c ~a'\'' '\''a,b'\''
$ json '\''~b|c b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b|c b'\'' '\''a,b'\''
$ json '\''~b|c ~c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b|c ~c'\'' '\''a,b'\''
$ json '\''~b|~c a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b|~c a'\'' '\''a,b'\''
$ json '\''~b|~c ~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b|~c ~a'\'' '\''a,b'\''
$ json '\''~b|~c b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b|~c b'\'' '\''a,b'\''
$ json '\''~b|~c c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b|~c c'\'' '\''a,b'\''
$ json '\''c|a ~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c|a ~a'\'' '\''a,b'\''
$ json '\''c|a b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c|a b'\'' '\''a,b'\''
$ json '\''c|a ~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c|a ~b'\'' '\''a,b'\''
$ json '\''c|a ~c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c|a ~c'\'' '\''a,b'\''
$ json '\''c|~a a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c|~a a'\'' '\''a,b'\''
$ json '\''c|~a b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c|~a b'\'' '\''a,b'\''
$ json '\''c|~a ~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c|~a ~b'\'' '\''a,b'\''
$ json '\''c|~a ~c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c|~a ~c'\'' '\''a,b'\''
$ json '\''c|b a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c|b a'\'' '\''a,b'\''
$ json '\''c|b ~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c|b ~a'\'' '\''a,b'\''
$ json '\''c|b ~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c|b ~b'\'' '\''a,b'\''
$ json '\''c|b ~c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c|b ~c'\'' '\''a,b'\''
$ json '\''c|~b a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c|~b a'\'' '\''a,b'\''
$ json '\''c|~b ~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c|~b ~a'\'' '\''a,b'\''
$ json '\''c|~b b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c|~b b'\'' '\''a,b'\''
$ json '\''c|~b ~c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c|~b ~c'\'' '\''a,b'\''
$ json '\''c|~c a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c|~c a'\'' '\''a,b'\''
$ json '\''c|~c ~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c|~c ~a'\'' '\''a,b'\''
$ json '\''c|~c b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c|~c b'\'' '\''a,b'\''
$ json '\''c|~c ~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c|~c ~b'\'' '\''a,b'\''
$ json '\''~c|a ~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c|a b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c|a ~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c|a c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c|~a a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c|~a b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c|~a ~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~c|~a ~b'\'' '\''a,b'\''
$ json '\''~c|~a c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~c|~a c'\'' '\''a,b'\''
$ json '\''~c|b a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c|b ~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c|b ~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c|b c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c|~b a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c|~b ~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~c|~b ~a'\'' '\''a,b'\''
$ json '\''~c|~b b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c|~b c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~c|~b c'\'' '\''a,b'\''
$ json '\''~c|c a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c|c ~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~c|c ~a'\'' '\''a,b'\''
$ json '\''~c|c b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c|c ~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~c|c ~b'\'' '\''a,b'\''
$ json '\''a|~a|b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''a|~a|b'\'' '\''a,b'\''
$ json '\''a|~a|~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''a|~a|~b'\'' '\''a,b'\''
$ json '\''a|~a|c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''a|~a|c'\'' '\''a,b'\''
$ json '\''a|~a|~c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''a|~a|~c'\'' '\''a,b'\''
$ json '\''a|b|~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''a|b|~a'\'' '\''a,b'\''
$ json '\''a|b|~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''a|b|~b'\'' '\''a,b'\''
$ json '\''a|b|c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''a|b|c'\'' '\''a,b'\''
$ json '\''a|b|~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a|~b|~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''a|~b|~a'\'' '\''a,b'\''
$ json '\''a|~b|b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''a|~b|b'\'' '\''a,b'\''
$ json '\''a|~b|c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''a|~b|c'\'' '\''a,b'\''
$ json '\''a|~b|~c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''a|~b|~c'\'' '\''a,b'\''
$ json '\''a|c|~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''a|c|~a'\'' '\''a,b'\''
$ json '\''a|c|b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''a|c|b'\'' '\''a,b'\''
$ json '\''a|c|~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''a|c|~b'\'' '\''a,b'\''
$ json '\''a|c|~c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''a|c|~c'\'' '\''a,b'\''
$ json '\''a|~c|~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''a|~c|~a'\'' '\''a,b'\''
$ json '\''a|~c|b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a|~c|~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''a|~c|~b'\'' '\''a,b'\''
$ json '\''a|~c|c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''a|~c|c'\'' '\''a,b'\''
$ json '\''~a|a|b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a|a|b'\'' '\''a,b'\''
$ json '\''~a|a|~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a|a|~b'\'' '\''a,b'\''
$ json '\''~a|a|c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a|a|c'\'' '\''a,b'\''
$ json '\''~a|a|~c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a|a|~c'\'' '\''a,b'\''
$ json '\''~a|b|a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a|b|a'\'' '\''a,b'\''
$ json '\''~a|b|~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a|b|~b'\'' '\''a,b'\''
$ json '\''~a|b|c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a|b|c'\'' '\''a,b'\''
$ json '\''~a|b|~c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a|b|~c'\'' '\''a,b'\''
$ json '\''~a|~b|a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a|~b|a'\'' '\''a,b'\''
$ json '\''~a|~b|b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a|~b|b'\'' '\''a,b'\''
$ json '\''~a|~b|c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a|~b|c'\'' '\''a,b'\''
$ json '\''~a|~b|~c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a|~b|~c'\'' '\''a,b'\''
$ json '\''~a|c|a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a|c|a'\'' '\''a,b'\''
$ json '\''~a|c|b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a|c|b'\'' '\''a,b'\''
$ json '\''~a|c|~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a|c|~b'\'' '\''a,b'\''
$ json '\''~a|c|~c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a|c|~c'\'' '\''a,b'\''
$ json '\''~a|~c|a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a|~c|a'\'' '\''a,b'\''
$ json '\''~a|~c|b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a|~c|b'\'' '\''a,b'\''
$ json '\''~a|~c|~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a|~c|~b'\'' '\''a,b'\''
$ json '\''~a|~c|c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a|~c|c'\'' '\''a,b'\''
$ json '\''b|a|~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''b|a|~a'\'' '\''a,b'\''
$ json '\''b|a|~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''b|a|~b'\'' '\''a,b'\''
$ json '\''b|a|c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''b|a|c'\'' '\''a,b'\''
$ json '\''b|a|~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b|~a|a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''b|~a|a'\'' '\''a,b'\''
$ json '\''b|~a|~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''b|~a|~b'\'' '\''a,b'\''
$ json '\''b|~a|c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''b|~a|c'\'' '\''a,b'\''
$ json '\''b|~a|~c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''b|~a|~c'\'' '\''a,b'\''
$ json '\''b|~b|a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''b|~b|a'\'' '\''a,b'\''
$ json '\''b|~b|~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''b|~b|~a'\'' '\''a,b'\''
$ json '\''b|~b|c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''b|~b|c'\'' '\''a,b'\''
$ json '\''b|~b|~c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''b|~b|~c'\'' '\''a,b'\''
$ json '\''b|c|a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''b|c|a'\'' '\''a,b'\''
$ json '\''b|c|~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''b|c|~a'\'' '\''a,b'\''
$ json '\''b|c|~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''b|c|~b'\'' '\''a,b'\''
$ json '\''b|c|~c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''b|c|~c'\'' '\''a,b'\''
$ json '\''b|~c|a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b|~c|~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''b|~c|~a'\'' '\''a,b'\''
$ json '\''b|~c|~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''b|~c|~b'\'' '\''a,b'\''
$ json '\''b|~c|c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''b|~c|c'\'' '\''a,b'\''
$ json '\''~b|a|~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b|a|~a'\'' '\''a,b'\''
$ json '\''~b|a|b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b|a|b'\'' '\''a,b'\''
$ json '\''~b|a|c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b|a|c'\'' '\''a,b'\''
$ json '\''~b|a|~c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b|a|~c'\'' '\''a,b'\''
$ json '\''~b|~a|a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b|~a|a'\'' '\''a,b'\''
$ json '\''~b|~a|b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b|~a|b'\'' '\''a,b'\''
$ json '\''~b|~a|c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b|~a|c'\'' '\''a,b'\''
$ json '\''~b|~a|~c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b|~a|~c'\'' '\''a,b'\''
$ json '\''~b|b|a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b|b|a'\'' '\''a,b'\''
$ json '\''~b|b|~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b|b|~a'\'' '\''a,b'\''
$ json '\''~b|b|c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b|b|c'\'' '\''a,b'\''
$ json '\''~b|b|~c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b|b|~c'\'' '\''a,b'\''
$ json '\''~b|c|a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b|c|a'\'' '\''a,b'\''
$ json '\''~b|c|~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b|c|~a'\'' '\''a,b'\''
$ json '\''~b|c|b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b|c|b'\'' '\''a,b'\''
$ json '\''~b|c|~c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b|c|~c'\'' '\''a,b'\''
$ json '\''~b|~c|a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b|~c|a'\'' '\''a,b'\''
$ json '\''~b|~c|~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b|~c|~a'\'' '\''a,b'\''
$ json '\''~b|~c|b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b|~c|b'\'' '\''a,b'\''
$ json '\''~b|~c|c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b|~c|c'\'' '\''a,b'\''
$ json '\''c|a|~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c|a|~a'\'' '\''a,b'\''
$ json '\''c|a|b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c|a|b'\'' '\''a,b'\''
$ json '\''c|a|~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c|a|~b'\'' '\''a,b'\''
$ json '\''c|a|~c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c|a|~c'\'' '\''a,b'\''
$ json '\''c|~a|a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c|~a|a'\'' '\''a,b'\''
$ json '\''c|~a|b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c|~a|b'\'' '\''a,b'\''
$ json '\''c|~a|~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c|~a|~b'\'' '\''a,b'\''
$ json '\''c|~a|~c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c|~a|~c'\'' '\''a,b'\''
$ json '\''c|b|a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c|b|a'\'' '\''a,b'\''
$ json '\''c|b|~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c|b|~a'\'' '\''a,b'\''
$ json '\''c|b|~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c|b|~b'\'' '\''a,b'\''
$ json '\''c|b|~c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c|b|~c'\'' '\''a,b'\''
$ json '\''c|~b|a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c|~b|a'\'' '\''a,b'\''
$ json '\''c|~b|~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c|~b|~a'\'' '\''a,b'\''
$ json '\''c|~b|b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c|~b|b'\'' '\''a,b'\''
$ json '\''c|~b|~c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c|~b|~c'\'' '\''a,b'\''
$ json '\''c|~c|a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c|~c|a'\'' '\''a,b'\''
$ json '\''c|~c|~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c|~c|~a'\'' '\''a,b'\''
$ json '\''c|~c|b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c|~c|b'\'' '\''a,b'\''
$ json '\''c|~c|~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c|~c|~b'\'' '\''a,b'\''
$ json '\''~c|a|~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~c|a|~a'\'' '\''a,b'\''
$ json '\''~c|a|b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c|a|~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~c|a|~b'\'' '\''a,b'\''
$ json '\''~c|a|c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~c|a|c'\'' '\''a,b'\''
$ json '\''~c|~a|a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~c|~a|a'\'' '\''a,b'\''
$ json '\''~c|~a|b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~c|~a|b'\'' '\''a,b'\''
$ json '\''~c|~a|~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~c|~a|~b'\'' '\''a,b'\''
$ json '\''~c|~a|c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~c|~a|c'\'' '\''a,b'\''
$ json '\''~c|b|a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c|b|~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~c|b|~a'\'' '\''a,b'\''
$ json '\''~c|b|~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~c|b|~b'\'' '\''a,b'\''
$ json '\''~c|b|c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~c|b|c'\'' '\''a,b'\''
$ json '\''~c|~b|a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~c|~b|a'\'' '\''a,b'\''
$ json '\''~c|~b|~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~c|~b|~a'\'' '\''a,b'\''
$ json '\''~c|~b|b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~c|~b|b'\'' '\''a,b'\''
$ json '\''~c|~b|c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~c|~b|c'\'' '\''a,b'\''
$ json '\''~c|c|a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~c|c|a'\'' '\''a,b'\''
$ json '\''~c|c|~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~c|c|~a'\'' '\''a,b'\''
$ json '\''~c|c|b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~c|c|b'\'' '\''a,b'\''
$ json '\''~c|c|~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~c|c|~b'\'' '\''a,b'\''
$ json '\''a|~a||b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a|~a||~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''a|~a||~b'\'' '\''a,b'\''
$ json '\''a|~a||c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''a|~a||c'\'' '\''a,b'\''
$ json '\''a|~a||~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a|b||~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a|b||~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a|b||c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a|b||~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a|~b||~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''a|~b||~a'\'' '\''a,b'\''
$ json '\''a|~b||b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a|~b||c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''a|~b||c'\'' '\''a,b'\''
$ json '\''a|~b||~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a|c||~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''a|c||~a'\'' '\''a,b'\''
$ json '\''a|c||b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a|c||~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''a|c||~b'\'' '\''a,b'\''
$ json '\''a|c||~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a|~c||~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a|~c||b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a|~c||~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a|~c||c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a|a||b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a|a||~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a|a||~b'\'' '\''a,b'\''
$ json '\''~a|a||c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a|a||c'\'' '\''a,b'\''
$ json '\''~a|a||~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a|b||a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a|b||~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a|b||~b'\'' '\''a,b'\''
$ json '\''~a|b||c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a|b||c'\'' '\''a,b'\''
$ json '\''~a|b||~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a|~b||a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a|~b||b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a|~b||c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a|~b||c'\'' '\''a,b'\''
$ json '\''~a|~b||~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a|c||a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a|c||b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a|c||~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a|c||~b'\'' '\''a,b'\''
$ json '\''~a|c||~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a|~c||a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a|~c||b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a|~c||~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a|~c||~b'\'' '\''a,b'\''
$ json '\''~a|~c||c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a|~c||c'\'' '\''a,b'\''
$ json '\''b|a||~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b|a||~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b|a||c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b|a||~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b|~a||a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b|~a||~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''b|~a||~b'\'' '\''a,b'\''
$ json '\''b|~a||c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''b|~a||c'\'' '\''a,b'\''
$ json '\''b|~a||~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b|~b||a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b|~b||~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''b|~b||~a'\'' '\''a,b'\''
$ json '\''b|~b||c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''b|~b||c'\'' '\''a,b'\''
$ json '\''b|~b||~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b|c||a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b|c||~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''b|c||~a'\'' '\''a,b'\''
$ json '\''b|c||~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''b|c||~b'\'' '\''a,b'\''
$ json '\''b|c||~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b|~c||a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b|~c||~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b|~c||~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b|~c||c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b|a||~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b|a||~a'\'' '\''a,b'\''
$ json '\''~b|a||b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b|a||c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b|a||c'\'' '\''a,b'\''
$ json '\''~b|a||~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b|~a||a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b|~a||b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b|~a||c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b|~a||c'\'' '\''a,b'\''
$ json '\''~b|~a||~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b|b||a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b|b||~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b|b||~a'\'' '\''a,b'\''
$ json '\''~b|b||c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b|b||c'\'' '\''a,b'\''
$ json '\''~b|b||~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b|c||a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b|c||~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b|c||~a'\'' '\''a,b'\''
$ json '\''~b|c||b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b|c||~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b|~c||a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b|~c||~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b|~c||~a'\'' '\''a,b'\''
$ json '\''~b|~c||b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b|~c||c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b|~c||c'\'' '\''a,b'\''
$ json '\''c|a||~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c|a||~a'\'' '\''a,b'\''
$ json '\''c|a||b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c|a||~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c|a||~b'\'' '\''a,b'\''
$ json '\''c|a||~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c|~a||a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c|~a||b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c|~a||~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c|~a||~b'\'' '\''a,b'\''
$ json '\''c|~a||~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c|b||a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c|b||~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c|b||~a'\'' '\''a,b'\''
$ json '\''c|b||~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c|b||~b'\'' '\''a,b'\''
$ json '\''c|b||~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c|~b||a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c|~b||~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c|~b||~a'\'' '\''a,b'\''
$ json '\''c|~b||b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c|~b||~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c|~c||a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c|~c||~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c|~c||~a'\'' '\''a,b'\''
$ json '\''c|~c||b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c|~c||~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c|~c||~b'\'' '\''a,b'\''
$ json '\''~c|a||~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c|a||b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c|a||~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c|a||c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c|~a||a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c|~a||b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c|~a||~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~c|~a||~b'\'' '\''a,b'\''
$ json '\''~c|~a||c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~c|~a||c'\'' '\''a,b'\''
$ json '\''~c|b||a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c|b||~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c|b||~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c|b||c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c|~b||a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c|~b||~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~c|~b||~a'\'' '\''a,b'\''
$ json '\''~c|~b||b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c|~b||c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~c|~b||c'\'' '\''a,b'\''
$ json '\''~c|c||a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c|c||~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~c|c||~a'\'' '\''a,b'\''
$ json '\''~c|c||b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c|c||~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~c|c||~b'\'' '\''a,b'\''
$ json '\''a||~a b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a||~a ~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a||~a c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a||~a ~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a||b ~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a||b ~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a||b c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a||b ~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a||~b ~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a||~b b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a||~b c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a||~b ~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a||c ~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a||c b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a||c ~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a||c ~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a||~c ~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a||~c b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a||~c ~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a||~c c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a||a b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a||a ~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a||a c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a||a ~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a||b a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a||b ~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a||b c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a||b ~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a||~b a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a||~b b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a||~b c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a||~b c'\'' '\''a,b'\''
$ json '\''~a||~b ~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a||c a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a||c b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a||c ~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a||c ~b'\'' '\''a,b'\''
$ json '\''~a||c ~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a||~c a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a||~c b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a||~c ~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a||~c c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b||a ~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b||a ~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b||a c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b||a ~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b||~a a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b||~a ~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b||~a c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b||~a ~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b||~b a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b||~b ~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b||~b c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b||~b ~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b||c a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b||c ~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b||c ~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b||c ~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b||~c a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b||~c ~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b||~c ~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b||~c c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b||a ~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b||a b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b||a c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b||a ~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b||~a a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b||~a b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b||~a c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b||~a c'\'' '\''a,b'\''
$ json '\''~b||~a ~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b||b a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b||b ~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b||b c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b||b ~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b||c a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b||c ~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b||c ~a'\'' '\''a,b'\''
$ json '\''~b||c b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b||c ~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b||~c a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b||~c ~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b||~c b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b||~c c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c||a ~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c||a b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c||a ~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c||a ~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c||~a a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c||~a b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c||~a ~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c||~a ~b'\'' '\''a,b'\''
$ json '\''c||~a ~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c||b a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c||b ~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c||b ~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c||b ~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c||~b a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c||~b ~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c||~b ~a'\'' '\''a,b'\''
$ json '\''c||~b b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c||~b ~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c||~c a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c||~c ~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c||~c b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c||~c ~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c||a ~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c||a b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c||a ~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c||a c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c||~a a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c||~a b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c||~a ~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c||~a c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c||b a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c||b ~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c||b ~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c||b c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c||~b a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c||~b ~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c||~b b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c||~b c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c||c a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c||c ~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c||c b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c||c ~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a||~a|b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a||~a|~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a||~a|c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a||~a|~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a||b|~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a||b|~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a||b|c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a||b|~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a||~b|~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a||~b|b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a||~b|c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a||~b|~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a||c|~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a||c|b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a||c|~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a||c|~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a||~c|~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a||~c|b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a||~c|~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a||~c|c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a||a|b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a||a|~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a||a|~b'\'' '\''a,b'\''
$ json '\''~a||a|c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a||a|c'\'' '\''a,b'\''
$ json '\''~a||a|~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a||b|a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a||b|~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a||b|~b'\'' '\''a,b'\''
$ json '\''~a||b|c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a||b|c'\'' '\''a,b'\''
$ json '\''~a||b|~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a||~b|a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a||~b|a'\'' '\''a,b'\''
$ json '\''~a||~b|b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a||~b|b'\'' '\''a,b'\''
$ json '\''~a||~b|c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a||~b|c'\'' '\''a,b'\''
$ json '\''~a||~b|~c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a||~b|~c'\'' '\''a,b'\''
$ json '\''~a||c|a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a||c|a'\'' '\''a,b'\''
$ json '\''~a||c|b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a||c|b'\'' '\''a,b'\''
$ json '\''~a||c|~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a||c|~b'\'' '\''a,b'\''
$ json '\''~a||c|~c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a||c|~c'\'' '\''a,b'\''
$ json '\''~a||~c|a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a||~c|b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a||~c|~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a||~c|~b'\'' '\''a,b'\''
$ json '\''~a||~c|c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a||~c|c'\'' '\''a,b'\''
$ json '\''b||a|~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b||a|~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b||a|c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b||a|~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b||~a|a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b||~a|~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b||~a|c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b||~a|~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b||~b|a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b||~b|~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b||~b|c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b||~b|~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b||c|a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b||c|~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b||c|~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b||c|~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b||~c|a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b||~c|~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b||~c|~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b||~c|c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b||a|~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b||a|~a'\'' '\''a,b'\''
$ json '\''~b||a|b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b||a|c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b||a|c'\'' '\''a,b'\''
$ json '\''~b||a|~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b||~a|a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b||~a|a'\'' '\''a,b'\''
$ json '\''~b||~a|b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b||~a|b'\'' '\''a,b'\''
$ json '\''~b||~a|c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b||~a|c'\'' '\''a,b'\''
$ json '\''~b||~a|~c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b||~a|~c'\'' '\''a,b'\''
$ json '\''~b||b|a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b||b|~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b||b|~a'\'' '\''a,b'\''
$ json '\''~b||b|c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b||b|c'\'' '\''a,b'\''
$ json '\''~b||b|~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b||c|a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b||c|a'\'' '\''a,b'\''
$ json '\''~b||c|~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b||c|~a'\'' '\''a,b'\''
$ json '\''~b||c|b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b||c|b'\'' '\''a,b'\''
$ json '\''~b||c|~c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b||c|~c'\'' '\''a,b'\''
$ json '\''~b||~c|a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b||~c|~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b||~c|~a'\'' '\''a,b'\''
$ json '\''~b||~c|b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b||~c|c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b||~c|c'\'' '\''a,b'\''
$ json '\''c||a|~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c||a|~a'\'' '\''a,b'\''
$ json '\''c||a|b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c||a|~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c||a|~b'\'' '\''a,b'\''
$ json '\''c||a|~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c||~a|a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c||~a|a'\'' '\''a,b'\''
$ json '\''c||~a|b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c||~a|b'\'' '\''a,b'\''
$ json '\''c||~a|~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c||~a|~b'\'' '\''a,b'\''
$ json '\''c||~a|~c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c||~a|~c'\'' '\''a,b'\''
$ json '\''c||b|a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c||b|~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c||b|~a'\'' '\''a,b'\''
$ json '\''c||b|~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c||b|~b'\'' '\''a,b'\''
$ json '\''c||b|~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c||~b|a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c||~b|a'\'' '\''a,b'\''
$ json '\''c||~b|~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c||~b|~a'\'' '\''a,b'\''
$ json '\''c||~b|b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c||~b|b'\'' '\''a,b'\''
$ json '\''c||~b|~c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c||~b|~c'\'' '\''a,b'\''
$ json '\''c||~c|a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c||~c|~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c||~c|~a'\'' '\''a,b'\''
$ json '\''c||~c|b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c||~c|~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c||~c|~b'\'' '\''a,b'\''
$ json '\''~c||a|~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c||a|b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c||a|~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c||a|c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c||~a|a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c||~a|b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c||~a|~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c||~a|c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c||b|a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c||b|~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c||b|~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c||b|c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c||~b|a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c||~b|~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c||~b|b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c||~b|c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c||c|a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c||c|~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c||c|b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c||c|~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a||~a||b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a||~a||~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a||~a||c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a||~a||~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a||b||~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a||b||~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a||b||c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a||b||~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a||~b||~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a||~b||b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a||~b||c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a||~b||~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a||c||~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a||c||b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a||c||~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a||c||~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a||~c||~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a||~c||b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a||~c||~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a||~c||c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a||a||b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a||a||~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a||a||c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a||a||~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a||b||a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a||b||~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a||b||c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a||b||~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a||~b||a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a||~b||b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a||~b||c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"; 3rd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a||~b||c'\'' '\''a,b'\''
$ json '\''~a||~b||~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a||c||a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a||c||b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a||c||~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"; 3rd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a||c||~b'\'' '\''a,b'\''
$ json '\''~a||c||~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a||~c||a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a||~c||b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a||~c||~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a||~c||c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b||a||~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b||a||~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b||a||c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b||a||~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b||~a||a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b||~a||~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b||~a||c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b||~a||~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b||~b||a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b||~b||~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b||~b||c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b||~b||~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b||c||a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b||c||~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b||c||~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b||c||~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b||~c||a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b||~c||~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b||~c||~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b||~c||c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b||a||~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b||a||b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b||a||c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b||a||~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b||~a||a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b||~a||b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b||~a||c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"; 3rd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b||~a||c'\'' '\''a,b'\''
$ json '\''~b||~a||~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b||b||a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b||b||~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b||b||c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b||b||~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b||c||a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b||c||~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"; 3rd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b||c||~a'\'' '\''a,b'\''
$ json '\''~b||c||b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b||c||~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b||~c||a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b||~c||~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b||~c||b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b||~c||c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c||a||~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c||a||b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c||a||~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c||a||~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c||~a||a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c||~a||b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c||~a||~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"; 3rd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c||~a||~b'\'' '\''a,b'\''
$ json '\''c||~a||~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c||b||a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c||b||~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c||b||~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c||b||~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c||~b||a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c||~b||~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"; 3rd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c||~b||~a'\'' '\''a,b'\''
$ json '\''c||~b||b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c||~b||~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c||~c||a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c||~c||~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c||~c||b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c||~c||~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c||a||~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c||a||b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c||a||~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c||a||c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c||~a||a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c||~a||b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c||~a||~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c||~a||c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c||b||a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c||b||~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c||b||~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c||b||c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c||~b||a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c||~b||~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c||~b||b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c||~b||c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c||c||a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c||c||~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c||c||b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c||c||~b'\'' '\''a,b'\''
{"a":0,"b":1}'
) -L dict-expr4.new <(
echo '$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'
export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes 2>&1 ||
echo 'command failed: export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'

echo '$ json() { set -o pipefail && ../lib/test-gen --dict -V -d1 -k3 -ae "$2"|LD_LIBRARY_PATH=../lib ../src/json -EV -t <(../lib/test-gen --dict -T -d1 -k3 -ae "$1"); }'
json() { set -o pipefail && ../lib/test-gen --dict -V -d1 -k3 -ae "$2"|LD_LIBRARY_PATH=../lib ../src/json -EV -t <(../lib/test-gen --dict -T -d1 -k3 -ae "$1"); } 2>&1 ||
echo 'command failed: json() { set -o pipefail && ../lib/test-gen --dict -V -d1 -k3 -ae "$2"|LD_LIBRARY_PATH=../lib ../src/json -EV -t <(../lib/test-gen --dict -T -d1 -k3 -ae "$1"); }'

echo '$ json '\''a ~a b'\'' '\''a,b'\'''
json 'a ~a b' 'a,b' 2>&1 ||
echo 'command failed: json '\''a ~a b'\'' '\''a,b'\'''

echo '$ json '\''a ~a ~b'\'' '\''a,b'\'''
json 'a ~a ~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''a ~a ~b'\'' '\''a,b'\'''

echo '$ json '\''a ~a c'\'' '\''a,b'\'''
json 'a ~a c' 'a,b' 2>&1 ||
echo 'command failed: json '\''a ~a c'\'' '\''a,b'\'''

echo '$ json '\''a ~a ~c'\'' '\''a,b'\'''
json 'a ~a ~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''a ~a ~c'\'' '\''a,b'\'''

echo '$ json '\''a b ~a'\'' '\''a,b'\'''
json 'a b ~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''a b ~a'\'' '\''a,b'\'''

echo '$ json '\''a b ~b'\'' '\''a,b'\'''
json 'a b ~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''a b ~b'\'' '\''a,b'\'''

echo '$ json '\''a b c'\'' '\''a,b'\'''
json 'a b c' 'a,b' 2>&1 ||
echo 'command failed: json '\''a b c'\'' '\''a,b'\'''

echo '$ json '\''a b ~c'\'' '\''a,b'\'''
json 'a b ~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''a b ~c'\'' '\''a,b'\'''

echo '$ json '\''a ~b ~a'\'' '\''a,b'\'''
json 'a ~b ~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''a ~b ~a'\'' '\''a,b'\'''

echo '$ json '\''a ~b b'\'' '\''a,b'\'''
json 'a ~b b' 'a,b' 2>&1 ||
echo 'command failed: json '\''a ~b b'\'' '\''a,b'\'''

echo '$ json '\''a ~b c'\'' '\''a,b'\'''
json 'a ~b c' 'a,b' 2>&1 ||
echo 'command failed: json '\''a ~b c'\'' '\''a,b'\'''

echo '$ json '\''a ~b ~c'\'' '\''a,b'\'''
json 'a ~b ~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''a ~b ~c'\'' '\''a,b'\'''

echo '$ json '\''a c ~a'\'' '\''a,b'\'''
json 'a c ~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''a c ~a'\'' '\''a,b'\'''

echo '$ json '\''a c b'\'' '\''a,b'\'''
json 'a c b' 'a,b' 2>&1 ||
echo 'command failed: json '\''a c b'\'' '\''a,b'\'''

echo '$ json '\''a c ~b'\'' '\''a,b'\'''
json 'a c ~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''a c ~b'\'' '\''a,b'\'''

echo '$ json '\''a c ~c'\'' '\''a,b'\'''
json 'a c ~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''a c ~c'\'' '\''a,b'\'''

echo '$ json '\''a ~c ~a'\'' '\''a,b'\'''
json 'a ~c ~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''a ~c ~a'\'' '\''a,b'\'''

echo '$ json '\''a ~c b'\'' '\''a,b'\'''
json 'a ~c b' 'a,b' 2>&1 ||
echo 'command failed: json '\''a ~c b'\'' '\''a,b'\'''

echo '$ json '\''a ~c ~b'\'' '\''a,b'\'''
json 'a ~c ~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''a ~c ~b'\'' '\''a,b'\'''

echo '$ json '\''a ~c c'\'' '\''a,b'\'''
json 'a ~c c' 'a,b' 2>&1 ||
echo 'command failed: json '\''a ~c c'\'' '\''a,b'\'''

echo '$ json '\''~a a b'\'' '\''a,b'\'''
json '~a a b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a a b'\'' '\''a,b'\'''

echo '$ json '\''~a a ~b'\'' '\''a,b'\'''
json '~a a ~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a a ~b'\'' '\''a,b'\'''

echo '$ json '\''~a a c'\'' '\''a,b'\'''
json '~a a c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a a c'\'' '\''a,b'\'''

echo '$ json '\''~a a ~c'\'' '\''a,b'\'''
json '~a a ~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a a ~c'\'' '\''a,b'\'''

echo '$ json '\''~a b a'\'' '\''a,b'\'''
json '~a b a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a b a'\'' '\''a,b'\'''

echo '$ json '\''~a b ~b'\'' '\''a,b'\'''
json '~a b ~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a b ~b'\'' '\''a,b'\'''

echo '$ json '\''~a b c'\'' '\''a,b'\'''
json '~a b c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a b c'\'' '\''a,b'\'''

echo '$ json '\''~a b ~c'\'' '\''a,b'\'''
json '~a b ~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a b ~c'\'' '\''a,b'\'''

echo '$ json '\''~a ~b a'\'' '\''a,b'\'''
json '~a ~b a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a ~b a'\'' '\''a,b'\'''

echo '$ json '\''~a ~b b'\'' '\''a,b'\'''
json '~a ~b b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a ~b b'\'' '\''a,b'\'''

echo '$ json '\''~a ~b c'\'' '\''a,b'\'''
json '~a ~b c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a ~b c'\'' '\''a,b'\'''

echo '$ json '\''~a ~b ~c'\'' '\''a,b'\'''
json '~a ~b ~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a ~b ~c'\'' '\''a,b'\'''

echo '$ json '\''~a c a'\'' '\''a,b'\'''
json '~a c a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a c a'\'' '\''a,b'\'''

echo '$ json '\''~a c b'\'' '\''a,b'\'''
json '~a c b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a c b'\'' '\''a,b'\'''

echo '$ json '\''~a c ~b'\'' '\''a,b'\'''
json '~a c ~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a c ~b'\'' '\''a,b'\'''

echo '$ json '\''~a c ~c'\'' '\''a,b'\'''
json '~a c ~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a c ~c'\'' '\''a,b'\'''

echo '$ json '\''~a ~c a'\'' '\''a,b'\'''
json '~a ~c a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a ~c a'\'' '\''a,b'\'''

echo '$ json '\''~a ~c b'\'' '\''a,b'\'''
json '~a ~c b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a ~c b'\'' '\''a,b'\'''

echo '$ json '\''~a ~c ~b'\'' '\''a,b'\'''
json '~a ~c ~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a ~c ~b'\'' '\''a,b'\'''

echo '$ json '\''~a ~c c'\'' '\''a,b'\'''
json '~a ~c c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a ~c c'\'' '\''a,b'\'''

echo '$ json '\''b a ~a'\'' '\''a,b'\'''
json 'b a ~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''b a ~a'\'' '\''a,b'\'''

echo '$ json '\''b a ~b'\'' '\''a,b'\'''
json 'b a ~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''b a ~b'\'' '\''a,b'\'''

echo '$ json '\''b a c'\'' '\''a,b'\'''
json 'b a c' 'a,b' 2>&1 ||
echo 'command failed: json '\''b a c'\'' '\''a,b'\'''

echo '$ json '\''b a ~c'\'' '\''a,b'\'''
json 'b a ~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''b a ~c'\'' '\''a,b'\'''

echo '$ json '\''b ~a a'\'' '\''a,b'\'''
json 'b ~a a' 'a,b' 2>&1 ||
echo 'command failed: json '\''b ~a a'\'' '\''a,b'\'''

echo '$ json '\''b ~a ~b'\'' '\''a,b'\'''
json 'b ~a ~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''b ~a ~b'\'' '\''a,b'\'''

echo '$ json '\''b ~a c'\'' '\''a,b'\'''
json 'b ~a c' 'a,b' 2>&1 ||
echo 'command failed: json '\''b ~a c'\'' '\''a,b'\'''

echo '$ json '\''b ~a ~c'\'' '\''a,b'\'''
json 'b ~a ~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''b ~a ~c'\'' '\''a,b'\'''

echo '$ json '\''b ~b a'\'' '\''a,b'\'''
json 'b ~b a' 'a,b' 2>&1 ||
echo 'command failed: json '\''b ~b a'\'' '\''a,b'\'''

echo '$ json '\''b ~b ~a'\'' '\''a,b'\'''
json 'b ~b ~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''b ~b ~a'\'' '\''a,b'\'''

echo '$ json '\''b ~b c'\'' '\''a,b'\'''
json 'b ~b c' 'a,b' 2>&1 ||
echo 'command failed: json '\''b ~b c'\'' '\''a,b'\'''

echo '$ json '\''b ~b ~c'\'' '\''a,b'\'''
json 'b ~b ~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''b ~b ~c'\'' '\''a,b'\'''

echo '$ json '\''b c a'\'' '\''a,b'\'''
json 'b c a' 'a,b' 2>&1 ||
echo 'command failed: json '\''b c a'\'' '\''a,b'\'''

echo '$ json '\''b c ~a'\'' '\''a,b'\'''
json 'b c ~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''b c ~a'\'' '\''a,b'\'''

echo '$ json '\''b c ~b'\'' '\''a,b'\'''
json 'b c ~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''b c ~b'\'' '\''a,b'\'''

echo '$ json '\''b c ~c'\'' '\''a,b'\'''
json 'b c ~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''b c ~c'\'' '\''a,b'\'''

echo '$ json '\''b ~c a'\'' '\''a,b'\'''
json 'b ~c a' 'a,b' 2>&1 ||
echo 'command failed: json '\''b ~c a'\'' '\''a,b'\'''

echo '$ json '\''b ~c ~a'\'' '\''a,b'\'''
json 'b ~c ~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''b ~c ~a'\'' '\''a,b'\'''

echo '$ json '\''b ~c ~b'\'' '\''a,b'\'''
json 'b ~c ~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''b ~c ~b'\'' '\''a,b'\'''

echo '$ json '\''b ~c c'\'' '\''a,b'\'''
json 'b ~c c' 'a,b' 2>&1 ||
echo 'command failed: json '\''b ~c c'\'' '\''a,b'\'''

echo '$ json '\''~b a ~a'\'' '\''a,b'\'''
json '~b a ~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b a ~a'\'' '\''a,b'\'''

echo '$ json '\''~b a b'\'' '\''a,b'\'''
json '~b a b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b a b'\'' '\''a,b'\'''

echo '$ json '\''~b a c'\'' '\''a,b'\'''
json '~b a c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b a c'\'' '\''a,b'\'''

echo '$ json '\''~b a ~c'\'' '\''a,b'\'''
json '~b a ~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b a ~c'\'' '\''a,b'\'''

echo '$ json '\''~b ~a a'\'' '\''a,b'\'''
json '~b ~a a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b ~a a'\'' '\''a,b'\'''

echo '$ json '\''~b ~a b'\'' '\''a,b'\'''
json '~b ~a b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b ~a b'\'' '\''a,b'\'''

echo '$ json '\''~b ~a c'\'' '\''a,b'\'''
json '~b ~a c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b ~a c'\'' '\''a,b'\'''

echo '$ json '\''~b ~a ~c'\'' '\''a,b'\'''
json '~b ~a ~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b ~a ~c'\'' '\''a,b'\'''

echo '$ json '\''~b b a'\'' '\''a,b'\'''
json '~b b a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b b a'\'' '\''a,b'\'''

echo '$ json '\''~b b ~a'\'' '\''a,b'\'''
json '~b b ~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b b ~a'\'' '\''a,b'\'''

echo '$ json '\''~b b c'\'' '\''a,b'\'''
json '~b b c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b b c'\'' '\''a,b'\'''

echo '$ json '\''~b b ~c'\'' '\''a,b'\'''
json '~b b ~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b b ~c'\'' '\''a,b'\'''

echo '$ json '\''~b c a'\'' '\''a,b'\'''
json '~b c a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b c a'\'' '\''a,b'\'''

echo '$ json '\''~b c ~a'\'' '\''a,b'\'''
json '~b c ~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b c ~a'\'' '\''a,b'\'''

echo '$ json '\''~b c b'\'' '\''a,b'\'''
json '~b c b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b c b'\'' '\''a,b'\'''

echo '$ json '\''~b c ~c'\'' '\''a,b'\'''
json '~b c ~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b c ~c'\'' '\''a,b'\'''

echo '$ json '\''~b ~c a'\'' '\''a,b'\'''
json '~b ~c a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b ~c a'\'' '\''a,b'\'''

echo '$ json '\''~b ~c ~a'\'' '\''a,b'\'''
json '~b ~c ~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b ~c ~a'\'' '\''a,b'\'''

echo '$ json '\''~b ~c b'\'' '\''a,b'\'''
json '~b ~c b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b ~c b'\'' '\''a,b'\'''

echo '$ json '\''~b ~c c'\'' '\''a,b'\'''
json '~b ~c c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b ~c c'\'' '\''a,b'\'''

echo '$ json '\''c a ~a'\'' '\''a,b'\'''
json 'c a ~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''c a ~a'\'' '\''a,b'\'''

echo '$ json '\''c a b'\'' '\''a,b'\'''
json 'c a b' 'a,b' 2>&1 ||
echo 'command failed: json '\''c a b'\'' '\''a,b'\'''

echo '$ json '\''c a ~b'\'' '\''a,b'\'''
json 'c a ~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''c a ~b'\'' '\''a,b'\'''

echo '$ json '\''c a ~c'\'' '\''a,b'\'''
json 'c a ~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''c a ~c'\'' '\''a,b'\'''

echo '$ json '\''c ~a a'\'' '\''a,b'\'''
json 'c ~a a' 'a,b' 2>&1 ||
echo 'command failed: json '\''c ~a a'\'' '\''a,b'\'''

echo '$ json '\''c ~a b'\'' '\''a,b'\'''
json 'c ~a b' 'a,b' 2>&1 ||
echo 'command failed: json '\''c ~a b'\'' '\''a,b'\'''

echo '$ json '\''c ~a ~b'\'' '\''a,b'\'''
json 'c ~a ~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''c ~a ~b'\'' '\''a,b'\'''

echo '$ json '\''c ~a ~c'\'' '\''a,b'\'''
json 'c ~a ~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''c ~a ~c'\'' '\''a,b'\'''

echo '$ json '\''c b a'\'' '\''a,b'\'''
json 'c b a' 'a,b' 2>&1 ||
echo 'command failed: json '\''c b a'\'' '\''a,b'\'''

echo '$ json '\''c b ~a'\'' '\''a,b'\'''
json 'c b ~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''c b ~a'\'' '\''a,b'\'''

echo '$ json '\''c b ~b'\'' '\''a,b'\'''
json 'c b ~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''c b ~b'\'' '\''a,b'\'''

echo '$ json '\''c b ~c'\'' '\''a,b'\'''
json 'c b ~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''c b ~c'\'' '\''a,b'\'''

echo '$ json '\''c ~b a'\'' '\''a,b'\'''
json 'c ~b a' 'a,b' 2>&1 ||
echo 'command failed: json '\''c ~b a'\'' '\''a,b'\'''

echo '$ json '\''c ~b ~a'\'' '\''a,b'\'''
json 'c ~b ~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''c ~b ~a'\'' '\''a,b'\'''

echo '$ json '\''c ~b b'\'' '\''a,b'\'''
json 'c ~b b' 'a,b' 2>&1 ||
echo 'command failed: json '\''c ~b b'\'' '\''a,b'\'''

echo '$ json '\''c ~b ~c'\'' '\''a,b'\'''
json 'c ~b ~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''c ~b ~c'\'' '\''a,b'\'''

echo '$ json '\''c ~c a'\'' '\''a,b'\'''
json 'c ~c a' 'a,b' 2>&1 ||
echo 'command failed: json '\''c ~c a'\'' '\''a,b'\'''

echo '$ json '\''c ~c ~a'\'' '\''a,b'\'''
json 'c ~c ~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''c ~c ~a'\'' '\''a,b'\'''

echo '$ json '\''c ~c b'\'' '\''a,b'\'''
json 'c ~c b' 'a,b' 2>&1 ||
echo 'command failed: json '\''c ~c b'\'' '\''a,b'\'''

echo '$ json '\''c ~c ~b'\'' '\''a,b'\'''
json 'c ~c ~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''c ~c ~b'\'' '\''a,b'\'''

echo '$ json '\''~c a ~a'\'' '\''a,b'\'''
json '~c a ~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c a ~a'\'' '\''a,b'\'''

echo '$ json '\''~c a b'\'' '\''a,b'\'''
json '~c a b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c a b'\'' '\''a,b'\'''

echo '$ json '\''~c a ~b'\'' '\''a,b'\'''
json '~c a ~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c a ~b'\'' '\''a,b'\'''

echo '$ json '\''~c a c'\'' '\''a,b'\'''
json '~c a c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c a c'\'' '\''a,b'\'''

echo '$ json '\''~c ~a a'\'' '\''a,b'\'''
json '~c ~a a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c ~a a'\'' '\''a,b'\'''

echo '$ json '\''~c ~a b'\'' '\''a,b'\'''
json '~c ~a b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c ~a b'\'' '\''a,b'\'''

echo '$ json '\''~c ~a ~b'\'' '\''a,b'\'''
json '~c ~a ~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c ~a ~b'\'' '\''a,b'\'''

echo '$ json '\''~c ~a c'\'' '\''a,b'\'''
json '~c ~a c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c ~a c'\'' '\''a,b'\'''

echo '$ json '\''~c b a'\'' '\''a,b'\'''
json '~c b a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c b a'\'' '\''a,b'\'''

echo '$ json '\''~c b ~a'\'' '\''a,b'\'''
json '~c b ~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c b ~a'\'' '\''a,b'\'''

echo '$ json '\''~c b ~b'\'' '\''a,b'\'''
json '~c b ~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c b ~b'\'' '\''a,b'\'''

echo '$ json '\''~c b c'\'' '\''a,b'\'''
json '~c b c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c b c'\'' '\''a,b'\'''

echo '$ json '\''~c ~b a'\'' '\''a,b'\'''
json '~c ~b a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c ~b a'\'' '\''a,b'\'''

echo '$ json '\''~c ~b ~a'\'' '\''a,b'\'''
json '~c ~b ~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c ~b ~a'\'' '\''a,b'\'''

echo '$ json '\''~c ~b b'\'' '\''a,b'\'''
json '~c ~b b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c ~b b'\'' '\''a,b'\'''

echo '$ json '\''~c ~b c'\'' '\''a,b'\'''
json '~c ~b c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c ~b c'\'' '\''a,b'\'''

echo '$ json '\''~c c a'\'' '\''a,b'\'''
json '~c c a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c c a'\'' '\''a,b'\'''

echo '$ json '\''~c c ~a'\'' '\''a,b'\'''
json '~c c ~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c c ~a'\'' '\''a,b'\'''

echo '$ json '\''~c c b'\'' '\''a,b'\'''
json '~c c b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c c b'\'' '\''a,b'\'''

echo '$ json '\''~c c ~b'\'' '\''a,b'\'''
json '~c c ~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c c ~b'\'' '\''a,b'\'''

echo '$ json '\''a ~a|b'\'' '\''a,b'\'''
json 'a ~a|b' 'a,b' 2>&1 ||
echo 'command failed: json '\''a ~a|b'\'' '\''a,b'\'''

echo '$ json '\''a ~a|~b'\'' '\''a,b'\'''
json 'a ~a|~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''a ~a|~b'\'' '\''a,b'\'''

echo '$ json '\''a ~a|c'\'' '\''a,b'\'''
json 'a ~a|c' 'a,b' 2>&1 ||
echo 'command failed: json '\''a ~a|c'\'' '\''a,b'\'''

echo '$ json '\''a ~a|~c'\'' '\''a,b'\'''
json 'a ~a|~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''a ~a|~c'\'' '\''a,b'\'''

echo '$ json '\''a b|~a'\'' '\''a,b'\'''
json 'a b|~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''a b|~a'\'' '\''a,b'\'''

echo '$ json '\''a b|~b'\'' '\''a,b'\'''
json 'a b|~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''a b|~b'\'' '\''a,b'\'''

echo '$ json '\''a b|c'\'' '\''a,b'\'''
json 'a b|c' 'a,b' 2>&1 ||
echo 'command failed: json '\''a b|c'\'' '\''a,b'\'''

echo '$ json '\''a b|~c'\'' '\''a,b'\'''
json 'a b|~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''a b|~c'\'' '\''a,b'\'''

echo '$ json '\''a ~b|~a'\'' '\''a,b'\'''
json 'a ~b|~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''a ~b|~a'\'' '\''a,b'\'''

echo '$ json '\''a ~b|b'\'' '\''a,b'\'''
json 'a ~b|b' 'a,b' 2>&1 ||
echo 'command failed: json '\''a ~b|b'\'' '\''a,b'\'''

echo '$ json '\''a ~b|c'\'' '\''a,b'\'''
json 'a ~b|c' 'a,b' 2>&1 ||
echo 'command failed: json '\''a ~b|c'\'' '\''a,b'\'''

echo '$ json '\''a ~b|~c'\'' '\''a,b'\'''
json 'a ~b|~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''a ~b|~c'\'' '\''a,b'\'''

echo '$ json '\''a c|~a'\'' '\''a,b'\'''
json 'a c|~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''a c|~a'\'' '\''a,b'\'''

echo '$ json '\''a c|b'\'' '\''a,b'\'''
json 'a c|b' 'a,b' 2>&1 ||
echo 'command failed: json '\''a c|b'\'' '\''a,b'\'''

echo '$ json '\''a c|~b'\'' '\''a,b'\'''
json 'a c|~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''a c|~b'\'' '\''a,b'\'''

echo '$ json '\''a c|~c'\'' '\''a,b'\'''
json 'a c|~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''a c|~c'\'' '\''a,b'\'''

echo '$ json '\''a ~c|~a'\'' '\''a,b'\'''
json 'a ~c|~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''a ~c|~a'\'' '\''a,b'\'''

echo '$ json '\''a ~c|b'\'' '\''a,b'\'''
json 'a ~c|b' 'a,b' 2>&1 ||
echo 'command failed: json '\''a ~c|b'\'' '\''a,b'\'''

echo '$ json '\''a ~c|~b'\'' '\''a,b'\'''
json 'a ~c|~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''a ~c|~b'\'' '\''a,b'\'''

echo '$ json '\''a ~c|c'\'' '\''a,b'\'''
json 'a ~c|c' 'a,b' 2>&1 ||
echo 'command failed: json '\''a ~c|c'\'' '\''a,b'\'''

echo '$ json '\''~a a|b'\'' '\''a,b'\'''
json '~a a|b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a a|b'\'' '\''a,b'\'''

echo '$ json '\''~a a|~b'\'' '\''a,b'\'''
json '~a a|~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a a|~b'\'' '\''a,b'\'''

echo '$ json '\''~a a|c'\'' '\''a,b'\'''
json '~a a|c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a a|c'\'' '\''a,b'\'''

echo '$ json '\''~a a|~c'\'' '\''a,b'\'''
json '~a a|~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a a|~c'\'' '\''a,b'\'''

echo '$ json '\''~a b|a'\'' '\''a,b'\'''
json '~a b|a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a b|a'\'' '\''a,b'\'''

echo '$ json '\''~a b|~b'\'' '\''a,b'\'''
json '~a b|~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a b|~b'\'' '\''a,b'\'''

echo '$ json '\''~a b|c'\'' '\''a,b'\'''
json '~a b|c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a b|c'\'' '\''a,b'\'''

echo '$ json '\''~a b|~c'\'' '\''a,b'\'''
json '~a b|~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a b|~c'\'' '\''a,b'\'''

echo '$ json '\''~a ~b|a'\'' '\''a,b'\'''
json '~a ~b|a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a ~b|a'\'' '\''a,b'\'''

echo '$ json '\''~a ~b|b'\'' '\''a,b'\'''
json '~a ~b|b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a ~b|b'\'' '\''a,b'\'''

echo '$ json '\''~a ~b|c'\'' '\''a,b'\'''
json '~a ~b|c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a ~b|c'\'' '\''a,b'\'''

echo '$ json '\''~a ~b|~c'\'' '\''a,b'\'''
json '~a ~b|~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a ~b|~c'\'' '\''a,b'\'''

echo '$ json '\''~a c|a'\'' '\''a,b'\'''
json '~a c|a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a c|a'\'' '\''a,b'\'''

echo '$ json '\''~a c|b'\'' '\''a,b'\'''
json '~a c|b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a c|b'\'' '\''a,b'\'''

echo '$ json '\''~a c|~b'\'' '\''a,b'\'''
json '~a c|~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a c|~b'\'' '\''a,b'\'''

echo '$ json '\''~a c|~c'\'' '\''a,b'\'''
json '~a c|~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a c|~c'\'' '\''a,b'\'''

echo '$ json '\''~a ~c|a'\'' '\''a,b'\'''
json '~a ~c|a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a ~c|a'\'' '\''a,b'\'''

echo '$ json '\''~a ~c|b'\'' '\''a,b'\'''
json '~a ~c|b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a ~c|b'\'' '\''a,b'\'''

echo '$ json '\''~a ~c|~b'\'' '\''a,b'\'''
json '~a ~c|~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a ~c|~b'\'' '\''a,b'\'''

echo '$ json '\''~a ~c|c'\'' '\''a,b'\'''
json '~a ~c|c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a ~c|c'\'' '\''a,b'\'''

echo '$ json '\''b a|~a'\'' '\''a,b'\'''
json 'b a|~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''b a|~a'\'' '\''a,b'\'''

echo '$ json '\''b a|~b'\'' '\''a,b'\'''
json 'b a|~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''b a|~b'\'' '\''a,b'\'''

echo '$ json '\''b a|c'\'' '\''a,b'\'''
json 'b a|c' 'a,b' 2>&1 ||
echo 'command failed: json '\''b a|c'\'' '\''a,b'\'''

echo '$ json '\''b a|~c'\'' '\''a,b'\'''
json 'b a|~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''b a|~c'\'' '\''a,b'\'''

echo '$ json '\''b ~a|a'\'' '\''a,b'\'''
json 'b ~a|a' 'a,b' 2>&1 ||
echo 'command failed: json '\''b ~a|a'\'' '\''a,b'\'''

echo '$ json '\''b ~a|~b'\'' '\''a,b'\'''
json 'b ~a|~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''b ~a|~b'\'' '\''a,b'\'''

echo '$ json '\''b ~a|c'\'' '\''a,b'\'''
json 'b ~a|c' 'a,b' 2>&1 ||
echo 'command failed: json '\''b ~a|c'\'' '\''a,b'\'''

echo '$ json '\''b ~a|~c'\'' '\''a,b'\'''
json 'b ~a|~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''b ~a|~c'\'' '\''a,b'\'''

echo '$ json '\''b ~b|a'\'' '\''a,b'\'''
json 'b ~b|a' 'a,b' 2>&1 ||
echo 'command failed: json '\''b ~b|a'\'' '\''a,b'\'''

echo '$ json '\''b ~b|~a'\'' '\''a,b'\'''
json 'b ~b|~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''b ~b|~a'\'' '\''a,b'\'''

echo '$ json '\''b ~b|c'\'' '\''a,b'\'''
json 'b ~b|c' 'a,b' 2>&1 ||
echo 'command failed: json '\''b ~b|c'\'' '\''a,b'\'''

echo '$ json '\''b ~b|~c'\'' '\''a,b'\'''
json 'b ~b|~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''b ~b|~c'\'' '\''a,b'\'''

echo '$ json '\''b c|a'\'' '\''a,b'\'''
json 'b c|a' 'a,b' 2>&1 ||
echo 'command failed: json '\''b c|a'\'' '\''a,b'\'''

echo '$ json '\''b c|~a'\'' '\''a,b'\'''
json 'b c|~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''b c|~a'\'' '\''a,b'\'''

echo '$ json '\''b c|~b'\'' '\''a,b'\'''
json 'b c|~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''b c|~b'\'' '\''a,b'\'''

echo '$ json '\''b c|~c'\'' '\''a,b'\'''
json 'b c|~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''b c|~c'\'' '\''a,b'\'''

echo '$ json '\''b ~c|a'\'' '\''a,b'\'''
json 'b ~c|a' 'a,b' 2>&1 ||
echo 'command failed: json '\''b ~c|a'\'' '\''a,b'\'''

echo '$ json '\''b ~c|~a'\'' '\''a,b'\'''
json 'b ~c|~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''b ~c|~a'\'' '\''a,b'\'''

echo '$ json '\''b ~c|~b'\'' '\''a,b'\'''
json 'b ~c|~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''b ~c|~b'\'' '\''a,b'\'''

echo '$ json '\''b ~c|c'\'' '\''a,b'\'''
json 'b ~c|c' 'a,b' 2>&1 ||
echo 'command failed: json '\''b ~c|c'\'' '\''a,b'\'''

echo '$ json '\''~b a|~a'\'' '\''a,b'\'''
json '~b a|~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b a|~a'\'' '\''a,b'\'''

echo '$ json '\''~b a|b'\'' '\''a,b'\'''
json '~b a|b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b a|b'\'' '\''a,b'\'''

echo '$ json '\''~b a|c'\'' '\''a,b'\'''
json '~b a|c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b a|c'\'' '\''a,b'\'''

echo '$ json '\''~b a|~c'\'' '\''a,b'\'''
json '~b a|~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b a|~c'\'' '\''a,b'\'''

echo '$ json '\''~b ~a|a'\'' '\''a,b'\'''
json '~b ~a|a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b ~a|a'\'' '\''a,b'\'''

echo '$ json '\''~b ~a|b'\'' '\''a,b'\'''
json '~b ~a|b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b ~a|b'\'' '\''a,b'\'''

echo '$ json '\''~b ~a|c'\'' '\''a,b'\'''
json '~b ~a|c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b ~a|c'\'' '\''a,b'\'''

echo '$ json '\''~b ~a|~c'\'' '\''a,b'\'''
json '~b ~a|~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b ~a|~c'\'' '\''a,b'\'''

echo '$ json '\''~b b|a'\'' '\''a,b'\'''
json '~b b|a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b b|a'\'' '\''a,b'\'''

echo '$ json '\''~b b|~a'\'' '\''a,b'\'''
json '~b b|~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b b|~a'\'' '\''a,b'\'''

echo '$ json '\''~b b|c'\'' '\''a,b'\'''
json '~b b|c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b b|c'\'' '\''a,b'\'''

echo '$ json '\''~b b|~c'\'' '\''a,b'\'''
json '~b b|~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b b|~c'\'' '\''a,b'\'''

echo '$ json '\''~b c|a'\'' '\''a,b'\'''
json '~b c|a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b c|a'\'' '\''a,b'\'''

echo '$ json '\''~b c|~a'\'' '\''a,b'\'''
json '~b c|~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b c|~a'\'' '\''a,b'\'''

echo '$ json '\''~b c|b'\'' '\''a,b'\'''
json '~b c|b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b c|b'\'' '\''a,b'\'''

echo '$ json '\''~b c|~c'\'' '\''a,b'\'''
json '~b c|~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b c|~c'\'' '\''a,b'\'''

echo '$ json '\''~b ~c|a'\'' '\''a,b'\'''
json '~b ~c|a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b ~c|a'\'' '\''a,b'\'''

echo '$ json '\''~b ~c|~a'\'' '\''a,b'\'''
json '~b ~c|~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b ~c|~a'\'' '\''a,b'\'''

echo '$ json '\''~b ~c|b'\'' '\''a,b'\'''
json '~b ~c|b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b ~c|b'\'' '\''a,b'\'''

echo '$ json '\''~b ~c|c'\'' '\''a,b'\'''
json '~b ~c|c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b ~c|c'\'' '\''a,b'\'''

echo '$ json '\''c a|~a'\'' '\''a,b'\'''
json 'c a|~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''c a|~a'\'' '\''a,b'\'''

echo '$ json '\''c a|b'\'' '\''a,b'\'''
json 'c a|b' 'a,b' 2>&1 ||
echo 'command failed: json '\''c a|b'\'' '\''a,b'\'''

echo '$ json '\''c a|~b'\'' '\''a,b'\'''
json 'c a|~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''c a|~b'\'' '\''a,b'\'''

echo '$ json '\''c a|~c'\'' '\''a,b'\'''
json 'c a|~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''c a|~c'\'' '\''a,b'\'''

echo '$ json '\''c ~a|a'\'' '\''a,b'\'''
json 'c ~a|a' 'a,b' 2>&1 ||
echo 'command failed: json '\''c ~a|a'\'' '\''a,b'\'''

echo '$ json '\''c ~a|b'\'' '\''a,b'\'''
json 'c ~a|b' 'a,b' 2>&1 ||
echo 'command failed: json '\''c ~a|b'\'' '\''a,b'\'''

echo '$ json '\''c ~a|~b'\'' '\''a,b'\'''
json 'c ~a|~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''c ~a|~b'\'' '\''a,b'\'''

echo '$ json '\''c ~a|~c'\'' '\''a,b'\'''
json 'c ~a|~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''c ~a|~c'\'' '\''a,b'\'''

echo '$ json '\''c b|a'\'' '\''a,b'\'''
json 'c b|a' 'a,b' 2>&1 ||
echo 'command failed: json '\''c b|a'\'' '\''a,b'\'''

echo '$ json '\''c b|~a'\'' '\''a,b'\'''
json 'c b|~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''c b|~a'\'' '\''a,b'\'''

echo '$ json '\''c b|~b'\'' '\''a,b'\'''
json 'c b|~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''c b|~b'\'' '\''a,b'\'''

echo '$ json '\''c b|~c'\'' '\''a,b'\'''
json 'c b|~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''c b|~c'\'' '\''a,b'\'''

echo '$ json '\''c ~b|a'\'' '\''a,b'\'''
json 'c ~b|a' 'a,b' 2>&1 ||
echo 'command failed: json '\''c ~b|a'\'' '\''a,b'\'''

echo '$ json '\''c ~b|~a'\'' '\''a,b'\'''
json 'c ~b|~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''c ~b|~a'\'' '\''a,b'\'''

echo '$ json '\''c ~b|b'\'' '\''a,b'\'''
json 'c ~b|b' 'a,b' 2>&1 ||
echo 'command failed: json '\''c ~b|b'\'' '\''a,b'\'''

echo '$ json '\''c ~b|~c'\'' '\''a,b'\'''
json 'c ~b|~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''c ~b|~c'\'' '\''a,b'\'''

echo '$ json '\''c ~c|a'\'' '\''a,b'\'''
json 'c ~c|a' 'a,b' 2>&1 ||
echo 'command failed: json '\''c ~c|a'\'' '\''a,b'\'''

echo '$ json '\''c ~c|~a'\'' '\''a,b'\'''
json 'c ~c|~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''c ~c|~a'\'' '\''a,b'\'''

echo '$ json '\''c ~c|b'\'' '\''a,b'\'''
json 'c ~c|b' 'a,b' 2>&1 ||
echo 'command failed: json '\''c ~c|b'\'' '\''a,b'\'''

echo '$ json '\''c ~c|~b'\'' '\''a,b'\'''
json 'c ~c|~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''c ~c|~b'\'' '\''a,b'\'''

echo '$ json '\''~c a|~a'\'' '\''a,b'\'''
json '~c a|~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c a|~a'\'' '\''a,b'\'''

echo '$ json '\''~c a|b'\'' '\''a,b'\'''
json '~c a|b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c a|b'\'' '\''a,b'\'''

echo '$ json '\''~c a|~b'\'' '\''a,b'\'''
json '~c a|~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c a|~b'\'' '\''a,b'\'''

echo '$ json '\''~c a|c'\'' '\''a,b'\'''
json '~c a|c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c a|c'\'' '\''a,b'\'''

echo '$ json '\''~c ~a|a'\'' '\''a,b'\'''
json '~c ~a|a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c ~a|a'\'' '\''a,b'\'''

echo '$ json '\''~c ~a|b'\'' '\''a,b'\'''
json '~c ~a|b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c ~a|b'\'' '\''a,b'\'''

echo '$ json '\''~c ~a|~b'\'' '\''a,b'\'''
json '~c ~a|~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c ~a|~b'\'' '\''a,b'\'''

echo '$ json '\''~c ~a|c'\'' '\''a,b'\'''
json '~c ~a|c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c ~a|c'\'' '\''a,b'\'''

echo '$ json '\''~c b|a'\'' '\''a,b'\'''
json '~c b|a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c b|a'\'' '\''a,b'\'''

echo '$ json '\''~c b|~a'\'' '\''a,b'\'''
json '~c b|~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c b|~a'\'' '\''a,b'\'''

echo '$ json '\''~c b|~b'\'' '\''a,b'\'''
json '~c b|~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c b|~b'\'' '\''a,b'\'''

echo '$ json '\''~c b|c'\'' '\''a,b'\'''
json '~c b|c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c b|c'\'' '\''a,b'\'''

echo '$ json '\''~c ~b|a'\'' '\''a,b'\'''
json '~c ~b|a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c ~b|a'\'' '\''a,b'\'''

echo '$ json '\''~c ~b|~a'\'' '\''a,b'\'''
json '~c ~b|~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c ~b|~a'\'' '\''a,b'\'''

echo '$ json '\''~c ~b|b'\'' '\''a,b'\'''
json '~c ~b|b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c ~b|b'\'' '\''a,b'\'''

echo '$ json '\''~c ~b|c'\'' '\''a,b'\'''
json '~c ~b|c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c ~b|c'\'' '\''a,b'\'''

echo '$ json '\''~c c|a'\'' '\''a,b'\'''
json '~c c|a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c c|a'\'' '\''a,b'\'''

echo '$ json '\''~c c|~a'\'' '\''a,b'\'''
json '~c c|~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c c|~a'\'' '\''a,b'\'''

echo '$ json '\''~c c|b'\'' '\''a,b'\'''
json '~c c|b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c c|b'\'' '\''a,b'\'''

echo '$ json '\''~c c|~b'\'' '\''a,b'\'''
json '~c c|~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c c|~b'\'' '\''a,b'\'''

echo '$ json '\''a ~a||b'\'' '\''a,b'\'''
json 'a ~a||b' 'a,b' 2>&1 ||
echo 'command failed: json '\''a ~a||b'\'' '\''a,b'\'''

echo '$ json '\''a ~a||~b'\'' '\''a,b'\'''
json 'a ~a||~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''a ~a||~b'\'' '\''a,b'\'''

echo '$ json '\''a ~a||c'\'' '\''a,b'\'''
json 'a ~a||c' 'a,b' 2>&1 ||
echo 'command failed: json '\''a ~a||c'\'' '\''a,b'\'''

echo '$ json '\''a ~a||~c'\'' '\''a,b'\'''
json 'a ~a||~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''a ~a||~c'\'' '\''a,b'\'''

echo '$ json '\''a b||~a'\'' '\''a,b'\'''
json 'a b||~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''a b||~a'\'' '\''a,b'\'''

echo '$ json '\''a b||~b'\'' '\''a,b'\'''
json 'a b||~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''a b||~b'\'' '\''a,b'\'''

echo '$ json '\''a b||c'\'' '\''a,b'\'''
json 'a b||c' 'a,b' 2>&1 ||
echo 'command failed: json '\''a b||c'\'' '\''a,b'\'''

echo '$ json '\''a b||~c'\'' '\''a,b'\'''
json 'a b||~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''a b||~c'\'' '\''a,b'\'''

echo '$ json '\''a ~b||~a'\'' '\''a,b'\'''
json 'a ~b||~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''a ~b||~a'\'' '\''a,b'\'''

echo '$ json '\''a ~b||b'\'' '\''a,b'\'''
json 'a ~b||b' 'a,b' 2>&1 ||
echo 'command failed: json '\''a ~b||b'\'' '\''a,b'\'''

echo '$ json '\''a ~b||c'\'' '\''a,b'\'''
json 'a ~b||c' 'a,b' 2>&1 ||
echo 'command failed: json '\''a ~b||c'\'' '\''a,b'\'''

echo '$ json '\''a ~b||~c'\'' '\''a,b'\'''
json 'a ~b||~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''a ~b||~c'\'' '\''a,b'\'''

echo '$ json '\''a c||~a'\'' '\''a,b'\'''
json 'a c||~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''a c||~a'\'' '\''a,b'\'''

echo '$ json '\''a c||b'\'' '\''a,b'\'''
json 'a c||b' 'a,b' 2>&1 ||
echo 'command failed: json '\''a c||b'\'' '\''a,b'\'''

echo '$ json '\''a c||~b'\'' '\''a,b'\'''
json 'a c||~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''a c||~b'\'' '\''a,b'\'''

echo '$ json '\''a c||~c'\'' '\''a,b'\'''
json 'a c||~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''a c||~c'\'' '\''a,b'\'''

echo '$ json '\''a ~c||~a'\'' '\''a,b'\'''
json 'a ~c||~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''a ~c||~a'\'' '\''a,b'\'''

echo '$ json '\''a ~c||b'\'' '\''a,b'\'''
json 'a ~c||b' 'a,b' 2>&1 ||
echo 'command failed: json '\''a ~c||b'\'' '\''a,b'\'''

echo '$ json '\''a ~c||~b'\'' '\''a,b'\'''
json 'a ~c||~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''a ~c||~b'\'' '\''a,b'\'''

echo '$ json '\''a ~c||c'\'' '\''a,b'\'''
json 'a ~c||c' 'a,b' 2>&1 ||
echo 'command failed: json '\''a ~c||c'\'' '\''a,b'\'''

echo '$ json '\''~a a||b'\'' '\''a,b'\'''
json '~a a||b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a a||b'\'' '\''a,b'\'''

echo '$ json '\''~a a||~b'\'' '\''a,b'\'''
json '~a a||~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a a||~b'\'' '\''a,b'\'''

echo '$ json '\''~a a||c'\'' '\''a,b'\'''
json '~a a||c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a a||c'\'' '\''a,b'\'''

echo '$ json '\''~a a||~c'\'' '\''a,b'\'''
json '~a a||~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a a||~c'\'' '\''a,b'\'''

echo '$ json '\''~a b||a'\'' '\''a,b'\'''
json '~a b||a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a b||a'\'' '\''a,b'\'''

echo '$ json '\''~a b||~b'\'' '\''a,b'\'''
json '~a b||~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a b||~b'\'' '\''a,b'\'''

echo '$ json '\''~a b||c'\'' '\''a,b'\'''
json '~a b||c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a b||c'\'' '\''a,b'\'''

echo '$ json '\''~a b||~c'\'' '\''a,b'\'''
json '~a b||~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a b||~c'\'' '\''a,b'\'''

echo '$ json '\''~a ~b||a'\'' '\''a,b'\'''
json '~a ~b||a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a ~b||a'\'' '\''a,b'\'''

echo '$ json '\''~a ~b||b'\'' '\''a,b'\'''
json '~a ~b||b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a ~b||b'\'' '\''a,b'\'''

echo '$ json '\''~a ~b||c'\'' '\''a,b'\'''
json '~a ~b||c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a ~b||c'\'' '\''a,b'\'''

echo '$ json '\''~a ~b||~c'\'' '\''a,b'\'''
json '~a ~b||~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a ~b||~c'\'' '\''a,b'\'''

echo '$ json '\''~a c||a'\'' '\''a,b'\'''
json '~a c||a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a c||a'\'' '\''a,b'\'''

echo '$ json '\''~a c||b'\'' '\''a,b'\'''
json '~a c||b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a c||b'\'' '\''a,b'\'''

echo '$ json '\''~a c||~b'\'' '\''a,b'\'''
json '~a c||~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a c||~b'\'' '\''a,b'\'''

echo '$ json '\''~a c||~c'\'' '\''a,b'\'''
json '~a c||~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a c||~c'\'' '\''a,b'\'''

echo '$ json '\''~a ~c||a'\'' '\''a,b'\'''
json '~a ~c||a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a ~c||a'\'' '\''a,b'\'''

echo '$ json '\''~a ~c||b'\'' '\''a,b'\'''
json '~a ~c||b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a ~c||b'\'' '\''a,b'\'''

echo '$ json '\''~a ~c||~b'\'' '\''a,b'\'''
json '~a ~c||~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a ~c||~b'\'' '\''a,b'\'''

echo '$ json '\''~a ~c||c'\'' '\''a,b'\'''
json '~a ~c||c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a ~c||c'\'' '\''a,b'\'''

echo '$ json '\''b a||~a'\'' '\''a,b'\'''
json 'b a||~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''b a||~a'\'' '\''a,b'\'''

echo '$ json '\''b a||~b'\'' '\''a,b'\'''
json 'b a||~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''b a||~b'\'' '\''a,b'\'''

echo '$ json '\''b a||c'\'' '\''a,b'\'''
json 'b a||c' 'a,b' 2>&1 ||
echo 'command failed: json '\''b a||c'\'' '\''a,b'\'''

echo '$ json '\''b a||~c'\'' '\''a,b'\'''
json 'b a||~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''b a||~c'\'' '\''a,b'\'''

echo '$ json '\''b ~a||a'\'' '\''a,b'\'''
json 'b ~a||a' 'a,b' 2>&1 ||
echo 'command failed: json '\''b ~a||a'\'' '\''a,b'\'''

echo '$ json '\''b ~a||~b'\'' '\''a,b'\'''
json 'b ~a||~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''b ~a||~b'\'' '\''a,b'\'''

echo '$ json '\''b ~a||c'\'' '\''a,b'\'''
json 'b ~a||c' 'a,b' 2>&1 ||
echo 'command failed: json '\''b ~a||c'\'' '\''a,b'\'''

echo '$ json '\''b ~a||~c'\'' '\''a,b'\'''
json 'b ~a||~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''b ~a||~c'\'' '\''a,b'\'''

echo '$ json '\''b ~b||a'\'' '\''a,b'\'''
json 'b ~b||a' 'a,b' 2>&1 ||
echo 'command failed: json '\''b ~b||a'\'' '\''a,b'\'''

echo '$ json '\''b ~b||~a'\'' '\''a,b'\'''
json 'b ~b||~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''b ~b||~a'\'' '\''a,b'\'''

echo '$ json '\''b ~b||c'\'' '\''a,b'\'''
json 'b ~b||c' 'a,b' 2>&1 ||
echo 'command failed: json '\''b ~b||c'\'' '\''a,b'\'''

echo '$ json '\''b ~b||~c'\'' '\''a,b'\'''
json 'b ~b||~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''b ~b||~c'\'' '\''a,b'\'''

echo '$ json '\''b c||a'\'' '\''a,b'\'''
json 'b c||a' 'a,b' 2>&1 ||
echo 'command failed: json '\''b c||a'\'' '\''a,b'\'''

echo '$ json '\''b c||~a'\'' '\''a,b'\'''
json 'b c||~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''b c||~a'\'' '\''a,b'\'''

echo '$ json '\''b c||~b'\'' '\''a,b'\'''
json 'b c||~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''b c||~b'\'' '\''a,b'\'''

echo '$ json '\''b c||~c'\'' '\''a,b'\'''
json 'b c||~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''b c||~c'\'' '\''a,b'\'''

echo '$ json '\''b ~c||a'\'' '\''a,b'\'''
json 'b ~c||a' 'a,b' 2>&1 ||
echo 'command failed: json '\''b ~c||a'\'' '\''a,b'\'''

echo '$ json '\''b ~c||~a'\'' '\''a,b'\'''
json 'b ~c||~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''b ~c||~a'\'' '\''a,b'\'''

echo '$ json '\''b ~c||~b'\'' '\''a,b'\'''
json 'b ~c||~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''b ~c||~b'\'' '\''a,b'\'''

echo '$ json '\''b ~c||c'\'' '\''a,b'\'''
json 'b ~c||c' 'a,b' 2>&1 ||
echo 'command failed: json '\''b ~c||c'\'' '\''a,b'\'''

echo '$ json '\''~b a||~a'\'' '\''a,b'\'''
json '~b a||~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b a||~a'\'' '\''a,b'\'''

echo '$ json '\''~b a||b'\'' '\''a,b'\'''
json '~b a||b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b a||b'\'' '\''a,b'\'''

echo '$ json '\''~b a||c'\'' '\''a,b'\'''
json '~b a||c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b a||c'\'' '\''a,b'\'''

echo '$ json '\''~b a||~c'\'' '\''a,b'\'''
json '~b a||~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b a||~c'\'' '\''a,b'\'''

echo '$ json '\''~b ~a||a'\'' '\''a,b'\'''
json '~b ~a||a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b ~a||a'\'' '\''a,b'\'''

echo '$ json '\''~b ~a||b'\'' '\''a,b'\'''
json '~b ~a||b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b ~a||b'\'' '\''a,b'\'''

echo '$ json '\''~b ~a||c'\'' '\''a,b'\'''
json '~b ~a||c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b ~a||c'\'' '\''a,b'\'''

echo '$ json '\''~b ~a||~c'\'' '\''a,b'\'''
json '~b ~a||~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b ~a||~c'\'' '\''a,b'\'''

echo '$ json '\''~b b||a'\'' '\''a,b'\'''
json '~b b||a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b b||a'\'' '\''a,b'\'''

echo '$ json '\''~b b||~a'\'' '\''a,b'\'''
json '~b b||~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b b||~a'\'' '\''a,b'\'''

echo '$ json '\''~b b||c'\'' '\''a,b'\'''
json '~b b||c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b b||c'\'' '\''a,b'\'''

echo '$ json '\''~b b||~c'\'' '\''a,b'\'''
json '~b b||~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b b||~c'\'' '\''a,b'\'''

echo '$ json '\''~b c||a'\'' '\''a,b'\'''
json '~b c||a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b c||a'\'' '\''a,b'\'''

echo '$ json '\''~b c||~a'\'' '\''a,b'\'''
json '~b c||~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b c||~a'\'' '\''a,b'\'''

echo '$ json '\''~b c||b'\'' '\''a,b'\'''
json '~b c||b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b c||b'\'' '\''a,b'\'''

echo '$ json '\''~b c||~c'\'' '\''a,b'\'''
json '~b c||~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b c||~c'\'' '\''a,b'\'''

echo '$ json '\''~b ~c||a'\'' '\''a,b'\'''
json '~b ~c||a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b ~c||a'\'' '\''a,b'\'''

echo '$ json '\''~b ~c||~a'\'' '\''a,b'\'''
json '~b ~c||~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b ~c||~a'\'' '\''a,b'\'''

echo '$ json '\''~b ~c||b'\'' '\''a,b'\'''
json '~b ~c||b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b ~c||b'\'' '\''a,b'\'''

echo '$ json '\''~b ~c||c'\'' '\''a,b'\'''
json '~b ~c||c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b ~c||c'\'' '\''a,b'\'''

echo '$ json '\''c a||~a'\'' '\''a,b'\'''
json 'c a||~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''c a||~a'\'' '\''a,b'\'''

echo '$ json '\''c a||b'\'' '\''a,b'\'''
json 'c a||b' 'a,b' 2>&1 ||
echo 'command failed: json '\''c a||b'\'' '\''a,b'\'''

echo '$ json '\''c a||~b'\'' '\''a,b'\'''
json 'c a||~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''c a||~b'\'' '\''a,b'\'''

echo '$ json '\''c a||~c'\'' '\''a,b'\'''
json 'c a||~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''c a||~c'\'' '\''a,b'\'''

echo '$ json '\''c ~a||a'\'' '\''a,b'\'''
json 'c ~a||a' 'a,b' 2>&1 ||
echo 'command failed: json '\''c ~a||a'\'' '\''a,b'\'''

echo '$ json '\''c ~a||b'\'' '\''a,b'\'''
json 'c ~a||b' 'a,b' 2>&1 ||
echo 'command failed: json '\''c ~a||b'\'' '\''a,b'\'''

echo '$ json '\''c ~a||~b'\'' '\''a,b'\'''
json 'c ~a||~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''c ~a||~b'\'' '\''a,b'\'''

echo '$ json '\''c ~a||~c'\'' '\''a,b'\'''
json 'c ~a||~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''c ~a||~c'\'' '\''a,b'\'''

echo '$ json '\''c b||a'\'' '\''a,b'\'''
json 'c b||a' 'a,b' 2>&1 ||
echo 'command failed: json '\''c b||a'\'' '\''a,b'\'''

echo '$ json '\''c b||~a'\'' '\''a,b'\'''
json 'c b||~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''c b||~a'\'' '\''a,b'\'''

echo '$ json '\''c b||~b'\'' '\''a,b'\'''
json 'c b||~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''c b||~b'\'' '\''a,b'\'''

echo '$ json '\''c b||~c'\'' '\''a,b'\'''
json 'c b||~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''c b||~c'\'' '\''a,b'\'''

echo '$ json '\''c ~b||a'\'' '\''a,b'\'''
json 'c ~b||a' 'a,b' 2>&1 ||
echo 'command failed: json '\''c ~b||a'\'' '\''a,b'\'''

echo '$ json '\''c ~b||~a'\'' '\''a,b'\'''
json 'c ~b||~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''c ~b||~a'\'' '\''a,b'\'''

echo '$ json '\''c ~b||b'\'' '\''a,b'\'''
json 'c ~b||b' 'a,b' 2>&1 ||
echo 'command failed: json '\''c ~b||b'\'' '\''a,b'\'''

echo '$ json '\''c ~b||~c'\'' '\''a,b'\'''
json 'c ~b||~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''c ~b||~c'\'' '\''a,b'\'''

echo '$ json '\''c ~c||a'\'' '\''a,b'\'''
json 'c ~c||a' 'a,b' 2>&1 ||
echo 'command failed: json '\''c ~c||a'\'' '\''a,b'\'''

echo '$ json '\''c ~c||~a'\'' '\''a,b'\'''
json 'c ~c||~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''c ~c||~a'\'' '\''a,b'\'''

echo '$ json '\''c ~c||b'\'' '\''a,b'\'''
json 'c ~c||b' 'a,b' 2>&1 ||
echo 'command failed: json '\''c ~c||b'\'' '\''a,b'\'''

echo '$ json '\''c ~c||~b'\'' '\''a,b'\'''
json 'c ~c||~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''c ~c||~b'\'' '\''a,b'\'''

echo '$ json '\''~c a||~a'\'' '\''a,b'\'''
json '~c a||~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c a||~a'\'' '\''a,b'\'''

echo '$ json '\''~c a||b'\'' '\''a,b'\'''
json '~c a||b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c a||b'\'' '\''a,b'\'''

echo '$ json '\''~c a||~b'\'' '\''a,b'\'''
json '~c a||~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c a||~b'\'' '\''a,b'\'''

echo '$ json '\''~c a||c'\'' '\''a,b'\'''
json '~c a||c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c a||c'\'' '\''a,b'\'''

echo '$ json '\''~c ~a||a'\'' '\''a,b'\'''
json '~c ~a||a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c ~a||a'\'' '\''a,b'\'''

echo '$ json '\''~c ~a||b'\'' '\''a,b'\'''
json '~c ~a||b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c ~a||b'\'' '\''a,b'\'''

echo '$ json '\''~c ~a||~b'\'' '\''a,b'\'''
json '~c ~a||~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c ~a||~b'\'' '\''a,b'\'''

echo '$ json '\''~c ~a||c'\'' '\''a,b'\'''
json '~c ~a||c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c ~a||c'\'' '\''a,b'\'''

echo '$ json '\''~c b||a'\'' '\''a,b'\'''
json '~c b||a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c b||a'\'' '\''a,b'\'''

echo '$ json '\''~c b||~a'\'' '\''a,b'\'''
json '~c b||~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c b||~a'\'' '\''a,b'\'''

echo '$ json '\''~c b||~b'\'' '\''a,b'\'''
json '~c b||~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c b||~b'\'' '\''a,b'\'''

echo '$ json '\''~c b||c'\'' '\''a,b'\'''
json '~c b||c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c b||c'\'' '\''a,b'\'''

echo '$ json '\''~c ~b||a'\'' '\''a,b'\'''
json '~c ~b||a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c ~b||a'\'' '\''a,b'\'''

echo '$ json '\''~c ~b||~a'\'' '\''a,b'\'''
json '~c ~b||~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c ~b||~a'\'' '\''a,b'\'''

echo '$ json '\''~c ~b||b'\'' '\''a,b'\'''
json '~c ~b||b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c ~b||b'\'' '\''a,b'\'''

echo '$ json '\''~c ~b||c'\'' '\''a,b'\'''
json '~c ~b||c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c ~b||c'\'' '\''a,b'\'''

echo '$ json '\''~c c||a'\'' '\''a,b'\'''
json '~c c||a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c c||a'\'' '\''a,b'\'''

echo '$ json '\''~c c||~a'\'' '\''a,b'\'''
json '~c c||~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c c||~a'\'' '\''a,b'\'''

echo '$ json '\''~c c||b'\'' '\''a,b'\'''
json '~c c||b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c c||b'\'' '\''a,b'\'''

echo '$ json '\''~c c||~b'\'' '\''a,b'\'''
json '~c c||~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c c||~b'\'' '\''a,b'\'''

echo '$ json '\''a|~a b'\'' '\''a,b'\'''
json 'a|~a b' 'a,b' 2>&1 ||
echo 'command failed: json '\''a|~a b'\'' '\''a,b'\'''

echo '$ json '\''a|~a ~b'\'' '\''a,b'\'''
json 'a|~a ~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''a|~a ~b'\'' '\''a,b'\'''

echo '$ json '\''a|~a c'\'' '\''a,b'\'''
json 'a|~a c' 'a,b' 2>&1 ||
echo 'command failed: json '\''a|~a c'\'' '\''a,b'\'''

echo '$ json '\''a|~a ~c'\'' '\''a,b'\'''
json 'a|~a ~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''a|~a ~c'\'' '\''a,b'\'''

echo '$ json '\''a|b ~a'\'' '\''a,b'\'''
json 'a|b ~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''a|b ~a'\'' '\''a,b'\'''

echo '$ json '\''a|b ~b'\'' '\''a,b'\'''
json 'a|b ~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''a|b ~b'\'' '\''a,b'\'''

echo '$ json '\''a|b c'\'' '\''a,b'\'''
json 'a|b c' 'a,b' 2>&1 ||
echo 'command failed: json '\''a|b c'\'' '\''a,b'\'''

echo '$ json '\''a|b ~c'\'' '\''a,b'\'''
json 'a|b ~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''a|b ~c'\'' '\''a,b'\'''

echo '$ json '\''a|~b ~a'\'' '\''a,b'\'''
json 'a|~b ~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''a|~b ~a'\'' '\''a,b'\'''

echo '$ json '\''a|~b b'\'' '\''a,b'\'''
json 'a|~b b' 'a,b' 2>&1 ||
echo 'command failed: json '\''a|~b b'\'' '\''a,b'\'''

echo '$ json '\''a|~b c'\'' '\''a,b'\'''
json 'a|~b c' 'a,b' 2>&1 ||
echo 'command failed: json '\''a|~b c'\'' '\''a,b'\'''

echo '$ json '\''a|~b ~c'\'' '\''a,b'\'''
json 'a|~b ~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''a|~b ~c'\'' '\''a,b'\'''

echo '$ json '\''a|c ~a'\'' '\''a,b'\'''
json 'a|c ~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''a|c ~a'\'' '\''a,b'\'''

echo '$ json '\''a|c b'\'' '\''a,b'\'''
json 'a|c b' 'a,b' 2>&1 ||
echo 'command failed: json '\''a|c b'\'' '\''a,b'\'''

echo '$ json '\''a|c ~b'\'' '\''a,b'\'''
json 'a|c ~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''a|c ~b'\'' '\''a,b'\'''

echo '$ json '\''a|c ~c'\'' '\''a,b'\'''
json 'a|c ~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''a|c ~c'\'' '\''a,b'\'''

echo '$ json '\''a|~c ~a'\'' '\''a,b'\'''
json 'a|~c ~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''a|~c ~a'\'' '\''a,b'\'''

echo '$ json '\''a|~c b'\'' '\''a,b'\'''
json 'a|~c b' 'a,b' 2>&1 ||
echo 'command failed: json '\''a|~c b'\'' '\''a,b'\'''

echo '$ json '\''a|~c ~b'\'' '\''a,b'\'''
json 'a|~c ~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''a|~c ~b'\'' '\''a,b'\'''

echo '$ json '\''a|~c c'\'' '\''a,b'\'''
json 'a|~c c' 'a,b' 2>&1 ||
echo 'command failed: json '\''a|~c c'\'' '\''a,b'\'''

echo '$ json '\''~a|a b'\'' '\''a,b'\'''
json '~a|a b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a|a b'\'' '\''a,b'\'''

echo '$ json '\''~a|a ~b'\'' '\''a,b'\'''
json '~a|a ~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a|a ~b'\'' '\''a,b'\'''

echo '$ json '\''~a|a c'\'' '\''a,b'\'''
json '~a|a c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a|a c'\'' '\''a,b'\'''

echo '$ json '\''~a|a ~c'\'' '\''a,b'\'''
json '~a|a ~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a|a ~c'\'' '\''a,b'\'''

echo '$ json '\''~a|b a'\'' '\''a,b'\'''
json '~a|b a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a|b a'\'' '\''a,b'\'''

echo '$ json '\''~a|b ~b'\'' '\''a,b'\'''
json '~a|b ~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a|b ~b'\'' '\''a,b'\'''

echo '$ json '\''~a|b c'\'' '\''a,b'\'''
json '~a|b c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a|b c'\'' '\''a,b'\'''

echo '$ json '\''~a|b ~c'\'' '\''a,b'\'''
json '~a|b ~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a|b ~c'\'' '\''a,b'\'''

echo '$ json '\''~a|~b a'\'' '\''a,b'\'''
json '~a|~b a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a|~b a'\'' '\''a,b'\'''

echo '$ json '\''~a|~b b'\'' '\''a,b'\'''
json '~a|~b b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a|~b b'\'' '\''a,b'\'''

echo '$ json '\''~a|~b c'\'' '\''a,b'\'''
json '~a|~b c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a|~b c'\'' '\''a,b'\'''

echo '$ json '\''~a|~b ~c'\'' '\''a,b'\'''
json '~a|~b ~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a|~b ~c'\'' '\''a,b'\'''

echo '$ json '\''~a|c a'\'' '\''a,b'\'''
json '~a|c a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a|c a'\'' '\''a,b'\'''

echo '$ json '\''~a|c b'\'' '\''a,b'\'''
json '~a|c b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a|c b'\'' '\''a,b'\'''

echo '$ json '\''~a|c ~b'\'' '\''a,b'\'''
json '~a|c ~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a|c ~b'\'' '\''a,b'\'''

echo '$ json '\''~a|c ~c'\'' '\''a,b'\'''
json '~a|c ~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a|c ~c'\'' '\''a,b'\'''

echo '$ json '\''~a|~c a'\'' '\''a,b'\'''
json '~a|~c a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a|~c a'\'' '\''a,b'\'''

echo '$ json '\''~a|~c b'\'' '\''a,b'\'''
json '~a|~c b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a|~c b'\'' '\''a,b'\'''

echo '$ json '\''~a|~c ~b'\'' '\''a,b'\'''
json '~a|~c ~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a|~c ~b'\'' '\''a,b'\'''

echo '$ json '\''~a|~c c'\'' '\''a,b'\'''
json '~a|~c c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a|~c c'\'' '\''a,b'\'''

echo '$ json '\''b|a ~a'\'' '\''a,b'\'''
json 'b|a ~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''b|a ~a'\'' '\''a,b'\'''

echo '$ json '\''b|a ~b'\'' '\''a,b'\'''
json 'b|a ~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''b|a ~b'\'' '\''a,b'\'''

echo '$ json '\''b|a c'\'' '\''a,b'\'''
json 'b|a c' 'a,b' 2>&1 ||
echo 'command failed: json '\''b|a c'\'' '\''a,b'\'''

echo '$ json '\''b|a ~c'\'' '\''a,b'\'''
json 'b|a ~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''b|a ~c'\'' '\''a,b'\'''

echo '$ json '\''b|~a a'\'' '\''a,b'\'''
json 'b|~a a' 'a,b' 2>&1 ||
echo 'command failed: json '\''b|~a a'\'' '\''a,b'\'''

echo '$ json '\''b|~a ~b'\'' '\''a,b'\'''
json 'b|~a ~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''b|~a ~b'\'' '\''a,b'\'''

echo '$ json '\''b|~a c'\'' '\''a,b'\'''
json 'b|~a c' 'a,b' 2>&1 ||
echo 'command failed: json '\''b|~a c'\'' '\''a,b'\'''

echo '$ json '\''b|~a ~c'\'' '\''a,b'\'''
json 'b|~a ~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''b|~a ~c'\'' '\''a,b'\'''

echo '$ json '\''b|~b a'\'' '\''a,b'\'''
json 'b|~b a' 'a,b' 2>&1 ||
echo 'command failed: json '\''b|~b a'\'' '\''a,b'\'''

echo '$ json '\''b|~b ~a'\'' '\''a,b'\'''
json 'b|~b ~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''b|~b ~a'\'' '\''a,b'\'''

echo '$ json '\''b|~b c'\'' '\''a,b'\'''
json 'b|~b c' 'a,b' 2>&1 ||
echo 'command failed: json '\''b|~b c'\'' '\''a,b'\'''

echo '$ json '\''b|~b ~c'\'' '\''a,b'\'''
json 'b|~b ~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''b|~b ~c'\'' '\''a,b'\'''

echo '$ json '\''b|c a'\'' '\''a,b'\'''
json 'b|c a' 'a,b' 2>&1 ||
echo 'command failed: json '\''b|c a'\'' '\''a,b'\'''

echo '$ json '\''b|c ~a'\'' '\''a,b'\'''
json 'b|c ~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''b|c ~a'\'' '\''a,b'\'''

echo '$ json '\''b|c ~b'\'' '\''a,b'\'''
json 'b|c ~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''b|c ~b'\'' '\''a,b'\'''

echo '$ json '\''b|c ~c'\'' '\''a,b'\'''
json 'b|c ~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''b|c ~c'\'' '\''a,b'\'''

echo '$ json '\''b|~c a'\'' '\''a,b'\'''
json 'b|~c a' 'a,b' 2>&1 ||
echo 'command failed: json '\''b|~c a'\'' '\''a,b'\'''

echo '$ json '\''b|~c ~a'\'' '\''a,b'\'''
json 'b|~c ~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''b|~c ~a'\'' '\''a,b'\'''

echo '$ json '\''b|~c ~b'\'' '\''a,b'\'''
json 'b|~c ~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''b|~c ~b'\'' '\''a,b'\'''

echo '$ json '\''b|~c c'\'' '\''a,b'\'''
json 'b|~c c' 'a,b' 2>&1 ||
echo 'command failed: json '\''b|~c c'\'' '\''a,b'\'''

echo '$ json '\''~b|a ~a'\'' '\''a,b'\'''
json '~b|a ~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b|a ~a'\'' '\''a,b'\'''

echo '$ json '\''~b|a b'\'' '\''a,b'\'''
json '~b|a b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b|a b'\'' '\''a,b'\'''

echo '$ json '\''~b|a c'\'' '\''a,b'\'''
json '~b|a c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b|a c'\'' '\''a,b'\'''

echo '$ json '\''~b|a ~c'\'' '\''a,b'\'''
json '~b|a ~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b|a ~c'\'' '\''a,b'\'''

echo '$ json '\''~b|~a a'\'' '\''a,b'\'''
json '~b|~a a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b|~a a'\'' '\''a,b'\'''

echo '$ json '\''~b|~a b'\'' '\''a,b'\'''
json '~b|~a b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b|~a b'\'' '\''a,b'\'''

echo '$ json '\''~b|~a c'\'' '\''a,b'\'''
json '~b|~a c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b|~a c'\'' '\''a,b'\'''

echo '$ json '\''~b|~a ~c'\'' '\''a,b'\'''
json '~b|~a ~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b|~a ~c'\'' '\''a,b'\'''

echo '$ json '\''~b|b a'\'' '\''a,b'\'''
json '~b|b a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b|b a'\'' '\''a,b'\'''

echo '$ json '\''~b|b ~a'\'' '\''a,b'\'''
json '~b|b ~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b|b ~a'\'' '\''a,b'\'''

echo '$ json '\''~b|b c'\'' '\''a,b'\'''
json '~b|b c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b|b c'\'' '\''a,b'\'''

echo '$ json '\''~b|b ~c'\'' '\''a,b'\'''
json '~b|b ~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b|b ~c'\'' '\''a,b'\'''

echo '$ json '\''~b|c a'\'' '\''a,b'\'''
json '~b|c a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b|c a'\'' '\''a,b'\'''

echo '$ json '\''~b|c ~a'\'' '\''a,b'\'''
json '~b|c ~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b|c ~a'\'' '\''a,b'\'''

echo '$ json '\''~b|c b'\'' '\''a,b'\'''
json '~b|c b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b|c b'\'' '\''a,b'\'''

echo '$ json '\''~b|c ~c'\'' '\''a,b'\'''
json '~b|c ~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b|c ~c'\'' '\''a,b'\'''

echo '$ json '\''~b|~c a'\'' '\''a,b'\'''
json '~b|~c a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b|~c a'\'' '\''a,b'\'''

echo '$ json '\''~b|~c ~a'\'' '\''a,b'\'''
json '~b|~c ~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b|~c ~a'\'' '\''a,b'\'''

echo '$ json '\''~b|~c b'\'' '\''a,b'\'''
json '~b|~c b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b|~c b'\'' '\''a,b'\'''

echo '$ json '\''~b|~c c'\'' '\''a,b'\'''
json '~b|~c c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b|~c c'\'' '\''a,b'\'''

echo '$ json '\''c|a ~a'\'' '\''a,b'\'''
json 'c|a ~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''c|a ~a'\'' '\''a,b'\'''

echo '$ json '\''c|a b'\'' '\''a,b'\'''
json 'c|a b' 'a,b' 2>&1 ||
echo 'command failed: json '\''c|a b'\'' '\''a,b'\'''

echo '$ json '\''c|a ~b'\'' '\''a,b'\'''
json 'c|a ~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''c|a ~b'\'' '\''a,b'\'''

echo '$ json '\''c|a ~c'\'' '\''a,b'\'''
json 'c|a ~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''c|a ~c'\'' '\''a,b'\'''

echo '$ json '\''c|~a a'\'' '\''a,b'\'''
json 'c|~a a' 'a,b' 2>&1 ||
echo 'command failed: json '\''c|~a a'\'' '\''a,b'\'''

echo '$ json '\''c|~a b'\'' '\''a,b'\'''
json 'c|~a b' 'a,b' 2>&1 ||
echo 'command failed: json '\''c|~a b'\'' '\''a,b'\'''

echo '$ json '\''c|~a ~b'\'' '\''a,b'\'''
json 'c|~a ~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''c|~a ~b'\'' '\''a,b'\'''

echo '$ json '\''c|~a ~c'\'' '\''a,b'\'''
json 'c|~a ~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''c|~a ~c'\'' '\''a,b'\'''

echo '$ json '\''c|b a'\'' '\''a,b'\'''
json 'c|b a' 'a,b' 2>&1 ||
echo 'command failed: json '\''c|b a'\'' '\''a,b'\'''

echo '$ json '\''c|b ~a'\'' '\''a,b'\'''
json 'c|b ~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''c|b ~a'\'' '\''a,b'\'''

echo '$ json '\''c|b ~b'\'' '\''a,b'\'''
json 'c|b ~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''c|b ~b'\'' '\''a,b'\'''

echo '$ json '\''c|b ~c'\'' '\''a,b'\'''
json 'c|b ~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''c|b ~c'\'' '\''a,b'\'''

echo '$ json '\''c|~b a'\'' '\''a,b'\'''
json 'c|~b a' 'a,b' 2>&1 ||
echo 'command failed: json '\''c|~b a'\'' '\''a,b'\'''

echo '$ json '\''c|~b ~a'\'' '\''a,b'\'''
json 'c|~b ~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''c|~b ~a'\'' '\''a,b'\'''

echo '$ json '\''c|~b b'\'' '\''a,b'\'''
json 'c|~b b' 'a,b' 2>&1 ||
echo 'command failed: json '\''c|~b b'\'' '\''a,b'\'''

echo '$ json '\''c|~b ~c'\'' '\''a,b'\'''
json 'c|~b ~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''c|~b ~c'\'' '\''a,b'\'''

echo '$ json '\''c|~c a'\'' '\''a,b'\'''
json 'c|~c a' 'a,b' 2>&1 ||
echo 'command failed: json '\''c|~c a'\'' '\''a,b'\'''

echo '$ json '\''c|~c ~a'\'' '\''a,b'\'''
json 'c|~c ~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''c|~c ~a'\'' '\''a,b'\'''

echo '$ json '\''c|~c b'\'' '\''a,b'\'''
json 'c|~c b' 'a,b' 2>&1 ||
echo 'command failed: json '\''c|~c b'\'' '\''a,b'\'''

echo '$ json '\''c|~c ~b'\'' '\''a,b'\'''
json 'c|~c ~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''c|~c ~b'\'' '\''a,b'\'''

echo '$ json '\''~c|a ~a'\'' '\''a,b'\'''
json '~c|a ~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c|a ~a'\'' '\''a,b'\'''

echo '$ json '\''~c|a b'\'' '\''a,b'\'''
json '~c|a b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c|a b'\'' '\''a,b'\'''

echo '$ json '\''~c|a ~b'\'' '\''a,b'\'''
json '~c|a ~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c|a ~b'\'' '\''a,b'\'''

echo '$ json '\''~c|a c'\'' '\''a,b'\'''
json '~c|a c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c|a c'\'' '\''a,b'\'''

echo '$ json '\''~c|~a a'\'' '\''a,b'\'''
json '~c|~a a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c|~a a'\'' '\''a,b'\'''

echo '$ json '\''~c|~a b'\'' '\''a,b'\'''
json '~c|~a b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c|~a b'\'' '\''a,b'\'''

echo '$ json '\''~c|~a ~b'\'' '\''a,b'\'''
json '~c|~a ~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c|~a ~b'\'' '\''a,b'\'''

echo '$ json '\''~c|~a c'\'' '\''a,b'\'''
json '~c|~a c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c|~a c'\'' '\''a,b'\'''

echo '$ json '\''~c|b a'\'' '\''a,b'\'''
json '~c|b a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c|b a'\'' '\''a,b'\'''

echo '$ json '\''~c|b ~a'\'' '\''a,b'\'''
json '~c|b ~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c|b ~a'\'' '\''a,b'\'''

echo '$ json '\''~c|b ~b'\'' '\''a,b'\'''
json '~c|b ~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c|b ~b'\'' '\''a,b'\'''

echo '$ json '\''~c|b c'\'' '\''a,b'\'''
json '~c|b c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c|b c'\'' '\''a,b'\'''

echo '$ json '\''~c|~b a'\'' '\''a,b'\'''
json '~c|~b a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c|~b a'\'' '\''a,b'\'''

echo '$ json '\''~c|~b ~a'\'' '\''a,b'\'''
json '~c|~b ~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c|~b ~a'\'' '\''a,b'\'''

echo '$ json '\''~c|~b b'\'' '\''a,b'\'''
json '~c|~b b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c|~b b'\'' '\''a,b'\'''

echo '$ json '\''~c|~b c'\'' '\''a,b'\'''
json '~c|~b c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c|~b c'\'' '\''a,b'\'''

echo '$ json '\''~c|c a'\'' '\''a,b'\'''
json '~c|c a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c|c a'\'' '\''a,b'\'''

echo '$ json '\''~c|c ~a'\'' '\''a,b'\'''
json '~c|c ~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c|c ~a'\'' '\''a,b'\'''

echo '$ json '\''~c|c b'\'' '\''a,b'\'''
json '~c|c b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c|c b'\'' '\''a,b'\'''

echo '$ json '\''~c|c ~b'\'' '\''a,b'\'''
json '~c|c ~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c|c ~b'\'' '\''a,b'\'''

echo '$ json '\''a|~a|b'\'' '\''a,b'\'''
json 'a|~a|b' 'a,b' 2>&1 ||
echo 'command failed: json '\''a|~a|b'\'' '\''a,b'\'''

echo '$ json '\''a|~a|~b'\'' '\''a,b'\'''
json 'a|~a|~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''a|~a|~b'\'' '\''a,b'\'''

echo '$ json '\''a|~a|c'\'' '\''a,b'\'''
json 'a|~a|c' 'a,b' 2>&1 ||
echo 'command failed: json '\''a|~a|c'\'' '\''a,b'\'''

echo '$ json '\''a|~a|~c'\'' '\''a,b'\'''
json 'a|~a|~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''a|~a|~c'\'' '\''a,b'\'''

echo '$ json '\''a|b|~a'\'' '\''a,b'\'''
json 'a|b|~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''a|b|~a'\'' '\''a,b'\'''

echo '$ json '\''a|b|~b'\'' '\''a,b'\'''
json 'a|b|~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''a|b|~b'\'' '\''a,b'\'''

echo '$ json '\''a|b|c'\'' '\''a,b'\'''
json 'a|b|c' 'a,b' 2>&1 ||
echo 'command failed: json '\''a|b|c'\'' '\''a,b'\'''

echo '$ json '\''a|b|~c'\'' '\''a,b'\'''
json 'a|b|~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''a|b|~c'\'' '\''a,b'\'''

echo '$ json '\''a|~b|~a'\'' '\''a,b'\'''
json 'a|~b|~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''a|~b|~a'\'' '\''a,b'\'''

echo '$ json '\''a|~b|b'\'' '\''a,b'\'''
json 'a|~b|b' 'a,b' 2>&1 ||
echo 'command failed: json '\''a|~b|b'\'' '\''a,b'\'''

echo '$ json '\''a|~b|c'\'' '\''a,b'\'''
json 'a|~b|c' 'a,b' 2>&1 ||
echo 'command failed: json '\''a|~b|c'\'' '\''a,b'\'''

echo '$ json '\''a|~b|~c'\'' '\''a,b'\'''
json 'a|~b|~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''a|~b|~c'\'' '\''a,b'\'''

echo '$ json '\''a|c|~a'\'' '\''a,b'\'''
json 'a|c|~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''a|c|~a'\'' '\''a,b'\'''

echo '$ json '\''a|c|b'\'' '\''a,b'\'''
json 'a|c|b' 'a,b' 2>&1 ||
echo 'command failed: json '\''a|c|b'\'' '\''a,b'\'''

echo '$ json '\''a|c|~b'\'' '\''a,b'\'''
json 'a|c|~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''a|c|~b'\'' '\''a,b'\'''

echo '$ json '\''a|c|~c'\'' '\''a,b'\'''
json 'a|c|~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''a|c|~c'\'' '\''a,b'\'''

echo '$ json '\''a|~c|~a'\'' '\''a,b'\'''
json 'a|~c|~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''a|~c|~a'\'' '\''a,b'\'''

echo '$ json '\''a|~c|b'\'' '\''a,b'\'''
json 'a|~c|b' 'a,b' 2>&1 ||
echo 'command failed: json '\''a|~c|b'\'' '\''a,b'\'''

echo '$ json '\''a|~c|~b'\'' '\''a,b'\'''
json 'a|~c|~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''a|~c|~b'\'' '\''a,b'\'''

echo '$ json '\''a|~c|c'\'' '\''a,b'\'''
json 'a|~c|c' 'a,b' 2>&1 ||
echo 'command failed: json '\''a|~c|c'\'' '\''a,b'\'''

echo '$ json '\''~a|a|b'\'' '\''a,b'\'''
json '~a|a|b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a|a|b'\'' '\''a,b'\'''

echo '$ json '\''~a|a|~b'\'' '\''a,b'\'''
json '~a|a|~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a|a|~b'\'' '\''a,b'\'''

echo '$ json '\''~a|a|c'\'' '\''a,b'\'''
json '~a|a|c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a|a|c'\'' '\''a,b'\'''

echo '$ json '\''~a|a|~c'\'' '\''a,b'\'''
json '~a|a|~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a|a|~c'\'' '\''a,b'\'''

echo '$ json '\''~a|b|a'\'' '\''a,b'\'''
json '~a|b|a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a|b|a'\'' '\''a,b'\'''

echo '$ json '\''~a|b|~b'\'' '\''a,b'\'''
json '~a|b|~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a|b|~b'\'' '\''a,b'\'''

echo '$ json '\''~a|b|c'\'' '\''a,b'\'''
json '~a|b|c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a|b|c'\'' '\''a,b'\'''

echo '$ json '\''~a|b|~c'\'' '\''a,b'\'''
json '~a|b|~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a|b|~c'\'' '\''a,b'\'''

echo '$ json '\''~a|~b|a'\'' '\''a,b'\'''
json '~a|~b|a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a|~b|a'\'' '\''a,b'\'''

echo '$ json '\''~a|~b|b'\'' '\''a,b'\'''
json '~a|~b|b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a|~b|b'\'' '\''a,b'\'''

echo '$ json '\''~a|~b|c'\'' '\''a,b'\'''
json '~a|~b|c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a|~b|c'\'' '\''a,b'\'''

echo '$ json '\''~a|~b|~c'\'' '\''a,b'\'''
json '~a|~b|~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a|~b|~c'\'' '\''a,b'\'''

echo '$ json '\''~a|c|a'\'' '\''a,b'\'''
json '~a|c|a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a|c|a'\'' '\''a,b'\'''

echo '$ json '\''~a|c|b'\'' '\''a,b'\'''
json '~a|c|b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a|c|b'\'' '\''a,b'\'''

echo '$ json '\''~a|c|~b'\'' '\''a,b'\'''
json '~a|c|~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a|c|~b'\'' '\''a,b'\'''

echo '$ json '\''~a|c|~c'\'' '\''a,b'\'''
json '~a|c|~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a|c|~c'\'' '\''a,b'\'''

echo '$ json '\''~a|~c|a'\'' '\''a,b'\'''
json '~a|~c|a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a|~c|a'\'' '\''a,b'\'''

echo '$ json '\''~a|~c|b'\'' '\''a,b'\'''
json '~a|~c|b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a|~c|b'\'' '\''a,b'\'''

echo '$ json '\''~a|~c|~b'\'' '\''a,b'\'''
json '~a|~c|~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a|~c|~b'\'' '\''a,b'\'''

echo '$ json '\''~a|~c|c'\'' '\''a,b'\'''
json '~a|~c|c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a|~c|c'\'' '\''a,b'\'''

echo '$ json '\''b|a|~a'\'' '\''a,b'\'''
json 'b|a|~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''b|a|~a'\'' '\''a,b'\'''

echo '$ json '\''b|a|~b'\'' '\''a,b'\'''
json 'b|a|~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''b|a|~b'\'' '\''a,b'\'''

echo '$ json '\''b|a|c'\'' '\''a,b'\'''
json 'b|a|c' 'a,b' 2>&1 ||
echo 'command failed: json '\''b|a|c'\'' '\''a,b'\'''

echo '$ json '\''b|a|~c'\'' '\''a,b'\'''
json 'b|a|~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''b|a|~c'\'' '\''a,b'\'''

echo '$ json '\''b|~a|a'\'' '\''a,b'\'''
json 'b|~a|a' 'a,b' 2>&1 ||
echo 'command failed: json '\''b|~a|a'\'' '\''a,b'\'''

echo '$ json '\''b|~a|~b'\'' '\''a,b'\'''
json 'b|~a|~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''b|~a|~b'\'' '\''a,b'\'''

echo '$ json '\''b|~a|c'\'' '\''a,b'\'''
json 'b|~a|c' 'a,b' 2>&1 ||
echo 'command failed: json '\''b|~a|c'\'' '\''a,b'\'''

echo '$ json '\''b|~a|~c'\'' '\''a,b'\'''
json 'b|~a|~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''b|~a|~c'\'' '\''a,b'\'''

echo '$ json '\''b|~b|a'\'' '\''a,b'\'''
json 'b|~b|a' 'a,b' 2>&1 ||
echo 'command failed: json '\''b|~b|a'\'' '\''a,b'\'''

echo '$ json '\''b|~b|~a'\'' '\''a,b'\'''
json 'b|~b|~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''b|~b|~a'\'' '\''a,b'\'''

echo '$ json '\''b|~b|c'\'' '\''a,b'\'''
json 'b|~b|c' 'a,b' 2>&1 ||
echo 'command failed: json '\''b|~b|c'\'' '\''a,b'\'''

echo '$ json '\''b|~b|~c'\'' '\''a,b'\'''
json 'b|~b|~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''b|~b|~c'\'' '\''a,b'\'''

echo '$ json '\''b|c|a'\'' '\''a,b'\'''
json 'b|c|a' 'a,b' 2>&1 ||
echo 'command failed: json '\''b|c|a'\'' '\''a,b'\'''

echo '$ json '\''b|c|~a'\'' '\''a,b'\'''
json 'b|c|~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''b|c|~a'\'' '\''a,b'\'''

echo '$ json '\''b|c|~b'\'' '\''a,b'\'''
json 'b|c|~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''b|c|~b'\'' '\''a,b'\'''

echo '$ json '\''b|c|~c'\'' '\''a,b'\'''
json 'b|c|~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''b|c|~c'\'' '\''a,b'\'''

echo '$ json '\''b|~c|a'\'' '\''a,b'\'''
json 'b|~c|a' 'a,b' 2>&1 ||
echo 'command failed: json '\''b|~c|a'\'' '\''a,b'\'''

echo '$ json '\''b|~c|~a'\'' '\''a,b'\'''
json 'b|~c|~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''b|~c|~a'\'' '\''a,b'\'''

echo '$ json '\''b|~c|~b'\'' '\''a,b'\'''
json 'b|~c|~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''b|~c|~b'\'' '\''a,b'\'''

echo '$ json '\''b|~c|c'\'' '\''a,b'\'''
json 'b|~c|c' 'a,b' 2>&1 ||
echo 'command failed: json '\''b|~c|c'\'' '\''a,b'\'''

echo '$ json '\''~b|a|~a'\'' '\''a,b'\'''
json '~b|a|~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b|a|~a'\'' '\''a,b'\'''

echo '$ json '\''~b|a|b'\'' '\''a,b'\'''
json '~b|a|b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b|a|b'\'' '\''a,b'\'''

echo '$ json '\''~b|a|c'\'' '\''a,b'\'''
json '~b|a|c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b|a|c'\'' '\''a,b'\'''

echo '$ json '\''~b|a|~c'\'' '\''a,b'\'''
json '~b|a|~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b|a|~c'\'' '\''a,b'\'''

echo '$ json '\''~b|~a|a'\'' '\''a,b'\'''
json '~b|~a|a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b|~a|a'\'' '\''a,b'\'''

echo '$ json '\''~b|~a|b'\'' '\''a,b'\'''
json '~b|~a|b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b|~a|b'\'' '\''a,b'\'''

echo '$ json '\''~b|~a|c'\'' '\''a,b'\'''
json '~b|~a|c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b|~a|c'\'' '\''a,b'\'''

echo '$ json '\''~b|~a|~c'\'' '\''a,b'\'''
json '~b|~a|~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b|~a|~c'\'' '\''a,b'\'''

echo '$ json '\''~b|b|a'\'' '\''a,b'\'''
json '~b|b|a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b|b|a'\'' '\''a,b'\'''

echo '$ json '\''~b|b|~a'\'' '\''a,b'\'''
json '~b|b|~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b|b|~a'\'' '\''a,b'\'''

echo '$ json '\''~b|b|c'\'' '\''a,b'\'''
json '~b|b|c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b|b|c'\'' '\''a,b'\'''

echo '$ json '\''~b|b|~c'\'' '\''a,b'\'''
json '~b|b|~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b|b|~c'\'' '\''a,b'\'''

echo '$ json '\''~b|c|a'\'' '\''a,b'\'''
json '~b|c|a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b|c|a'\'' '\''a,b'\'''

echo '$ json '\''~b|c|~a'\'' '\''a,b'\'''
json '~b|c|~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b|c|~a'\'' '\''a,b'\'''

echo '$ json '\''~b|c|b'\'' '\''a,b'\'''
json '~b|c|b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b|c|b'\'' '\''a,b'\'''

echo '$ json '\''~b|c|~c'\'' '\''a,b'\'''
json '~b|c|~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b|c|~c'\'' '\''a,b'\'''

echo '$ json '\''~b|~c|a'\'' '\''a,b'\'''
json '~b|~c|a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b|~c|a'\'' '\''a,b'\'''

echo '$ json '\''~b|~c|~a'\'' '\''a,b'\'''
json '~b|~c|~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b|~c|~a'\'' '\''a,b'\'''

echo '$ json '\''~b|~c|b'\'' '\''a,b'\'''
json '~b|~c|b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b|~c|b'\'' '\''a,b'\'''

echo '$ json '\''~b|~c|c'\'' '\''a,b'\'''
json '~b|~c|c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b|~c|c'\'' '\''a,b'\'''

echo '$ json '\''c|a|~a'\'' '\''a,b'\'''
json 'c|a|~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''c|a|~a'\'' '\''a,b'\'''

echo '$ json '\''c|a|b'\'' '\''a,b'\'''
json 'c|a|b' 'a,b' 2>&1 ||
echo 'command failed: json '\''c|a|b'\'' '\''a,b'\'''

echo '$ json '\''c|a|~b'\'' '\''a,b'\'''
json 'c|a|~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''c|a|~b'\'' '\''a,b'\'''

echo '$ json '\''c|a|~c'\'' '\''a,b'\'''
json 'c|a|~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''c|a|~c'\'' '\''a,b'\'''

echo '$ json '\''c|~a|a'\'' '\''a,b'\'''
json 'c|~a|a' 'a,b' 2>&1 ||
echo 'command failed: json '\''c|~a|a'\'' '\''a,b'\'''

echo '$ json '\''c|~a|b'\'' '\''a,b'\'''
json 'c|~a|b' 'a,b' 2>&1 ||
echo 'command failed: json '\''c|~a|b'\'' '\''a,b'\'''

echo '$ json '\''c|~a|~b'\'' '\''a,b'\'''
json 'c|~a|~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''c|~a|~b'\'' '\''a,b'\'''

echo '$ json '\''c|~a|~c'\'' '\''a,b'\'''
json 'c|~a|~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''c|~a|~c'\'' '\''a,b'\'''

echo '$ json '\''c|b|a'\'' '\''a,b'\'''
json 'c|b|a' 'a,b' 2>&1 ||
echo 'command failed: json '\''c|b|a'\'' '\''a,b'\'''

echo '$ json '\''c|b|~a'\'' '\''a,b'\'''
json 'c|b|~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''c|b|~a'\'' '\''a,b'\'''

echo '$ json '\''c|b|~b'\'' '\''a,b'\'''
json 'c|b|~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''c|b|~b'\'' '\''a,b'\'''

echo '$ json '\''c|b|~c'\'' '\''a,b'\'''
json 'c|b|~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''c|b|~c'\'' '\''a,b'\'''

echo '$ json '\''c|~b|a'\'' '\''a,b'\'''
json 'c|~b|a' 'a,b' 2>&1 ||
echo 'command failed: json '\''c|~b|a'\'' '\''a,b'\'''

echo '$ json '\''c|~b|~a'\'' '\''a,b'\'''
json 'c|~b|~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''c|~b|~a'\'' '\''a,b'\'''

echo '$ json '\''c|~b|b'\'' '\''a,b'\'''
json 'c|~b|b' 'a,b' 2>&1 ||
echo 'command failed: json '\''c|~b|b'\'' '\''a,b'\'''

echo '$ json '\''c|~b|~c'\'' '\''a,b'\'''
json 'c|~b|~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''c|~b|~c'\'' '\''a,b'\'''

echo '$ json '\''c|~c|a'\'' '\''a,b'\'''
json 'c|~c|a' 'a,b' 2>&1 ||
echo 'command failed: json '\''c|~c|a'\'' '\''a,b'\'''

echo '$ json '\''c|~c|~a'\'' '\''a,b'\'''
json 'c|~c|~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''c|~c|~a'\'' '\''a,b'\'''

echo '$ json '\''c|~c|b'\'' '\''a,b'\'''
json 'c|~c|b' 'a,b' 2>&1 ||
echo 'command failed: json '\''c|~c|b'\'' '\''a,b'\'''

echo '$ json '\''c|~c|~b'\'' '\''a,b'\'''
json 'c|~c|~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''c|~c|~b'\'' '\''a,b'\'''

echo '$ json '\''~c|a|~a'\'' '\''a,b'\'''
json '~c|a|~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c|a|~a'\'' '\''a,b'\'''

echo '$ json '\''~c|a|b'\'' '\''a,b'\'''
json '~c|a|b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c|a|b'\'' '\''a,b'\'''

echo '$ json '\''~c|a|~b'\'' '\''a,b'\'''
json '~c|a|~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c|a|~b'\'' '\''a,b'\'''

echo '$ json '\''~c|a|c'\'' '\''a,b'\'''
json '~c|a|c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c|a|c'\'' '\''a,b'\'''

echo '$ json '\''~c|~a|a'\'' '\''a,b'\'''
json '~c|~a|a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c|~a|a'\'' '\''a,b'\'''

echo '$ json '\''~c|~a|b'\'' '\''a,b'\'''
json '~c|~a|b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c|~a|b'\'' '\''a,b'\'''

echo '$ json '\''~c|~a|~b'\'' '\''a,b'\'''
json '~c|~a|~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c|~a|~b'\'' '\''a,b'\'''

echo '$ json '\''~c|~a|c'\'' '\''a,b'\'''
json '~c|~a|c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c|~a|c'\'' '\''a,b'\'''

echo '$ json '\''~c|b|a'\'' '\''a,b'\'''
json '~c|b|a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c|b|a'\'' '\''a,b'\'''

echo '$ json '\''~c|b|~a'\'' '\''a,b'\'''
json '~c|b|~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c|b|~a'\'' '\''a,b'\'''

echo '$ json '\''~c|b|~b'\'' '\''a,b'\'''
json '~c|b|~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c|b|~b'\'' '\''a,b'\'''

echo '$ json '\''~c|b|c'\'' '\''a,b'\'''
json '~c|b|c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c|b|c'\'' '\''a,b'\'''

echo '$ json '\''~c|~b|a'\'' '\''a,b'\'''
json '~c|~b|a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c|~b|a'\'' '\''a,b'\'''

echo '$ json '\''~c|~b|~a'\'' '\''a,b'\'''
json '~c|~b|~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c|~b|~a'\'' '\''a,b'\'''

echo '$ json '\''~c|~b|b'\'' '\''a,b'\'''
json '~c|~b|b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c|~b|b'\'' '\''a,b'\'''

echo '$ json '\''~c|~b|c'\'' '\''a,b'\'''
json '~c|~b|c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c|~b|c'\'' '\''a,b'\'''

echo '$ json '\''~c|c|a'\'' '\''a,b'\'''
json '~c|c|a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c|c|a'\'' '\''a,b'\'''

echo '$ json '\''~c|c|~a'\'' '\''a,b'\'''
json '~c|c|~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c|c|~a'\'' '\''a,b'\'''

echo '$ json '\''~c|c|b'\'' '\''a,b'\'''
json '~c|c|b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c|c|b'\'' '\''a,b'\'''

echo '$ json '\''~c|c|~b'\'' '\''a,b'\'''
json '~c|c|~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c|c|~b'\'' '\''a,b'\'''

echo '$ json '\''a|~a||b'\'' '\''a,b'\'''
json 'a|~a||b' 'a,b' 2>&1 ||
echo 'command failed: json '\''a|~a||b'\'' '\''a,b'\'''

echo '$ json '\''a|~a||~b'\'' '\''a,b'\'''
json 'a|~a||~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''a|~a||~b'\'' '\''a,b'\'''

echo '$ json '\''a|~a||c'\'' '\''a,b'\'''
json 'a|~a||c' 'a,b' 2>&1 ||
echo 'command failed: json '\''a|~a||c'\'' '\''a,b'\'''

echo '$ json '\''a|~a||~c'\'' '\''a,b'\'''
json 'a|~a||~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''a|~a||~c'\'' '\''a,b'\'''

echo '$ json '\''a|b||~a'\'' '\''a,b'\'''
json 'a|b||~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''a|b||~a'\'' '\''a,b'\'''

echo '$ json '\''a|b||~b'\'' '\''a,b'\'''
json 'a|b||~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''a|b||~b'\'' '\''a,b'\'''

echo '$ json '\''a|b||c'\'' '\''a,b'\'''
json 'a|b||c' 'a,b' 2>&1 ||
echo 'command failed: json '\''a|b||c'\'' '\''a,b'\'''

echo '$ json '\''a|b||~c'\'' '\''a,b'\'''
json 'a|b||~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''a|b||~c'\'' '\''a,b'\'''

echo '$ json '\''a|~b||~a'\'' '\''a,b'\'''
json 'a|~b||~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''a|~b||~a'\'' '\''a,b'\'''

echo '$ json '\''a|~b||b'\'' '\''a,b'\'''
json 'a|~b||b' 'a,b' 2>&1 ||
echo 'command failed: json '\''a|~b||b'\'' '\''a,b'\'''

echo '$ json '\''a|~b||c'\'' '\''a,b'\'''
json 'a|~b||c' 'a,b' 2>&1 ||
echo 'command failed: json '\''a|~b||c'\'' '\''a,b'\'''

echo '$ json '\''a|~b||~c'\'' '\''a,b'\'''
json 'a|~b||~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''a|~b||~c'\'' '\''a,b'\'''

echo '$ json '\''a|c||~a'\'' '\''a,b'\'''
json 'a|c||~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''a|c||~a'\'' '\''a,b'\'''

echo '$ json '\''a|c||b'\'' '\''a,b'\'''
json 'a|c||b' 'a,b' 2>&1 ||
echo 'command failed: json '\''a|c||b'\'' '\''a,b'\'''

echo '$ json '\''a|c||~b'\'' '\''a,b'\'''
json 'a|c||~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''a|c||~b'\'' '\''a,b'\'''

echo '$ json '\''a|c||~c'\'' '\''a,b'\'''
json 'a|c||~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''a|c||~c'\'' '\''a,b'\'''

echo '$ json '\''a|~c||~a'\'' '\''a,b'\'''
json 'a|~c||~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''a|~c||~a'\'' '\''a,b'\'''

echo '$ json '\''a|~c||b'\'' '\''a,b'\'''
json 'a|~c||b' 'a,b' 2>&1 ||
echo 'command failed: json '\''a|~c||b'\'' '\''a,b'\'''

echo '$ json '\''a|~c||~b'\'' '\''a,b'\'''
json 'a|~c||~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''a|~c||~b'\'' '\''a,b'\'''

echo '$ json '\''a|~c||c'\'' '\''a,b'\'''
json 'a|~c||c' 'a,b' 2>&1 ||
echo 'command failed: json '\''a|~c||c'\'' '\''a,b'\'''

echo '$ json '\''~a|a||b'\'' '\''a,b'\'''
json '~a|a||b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a|a||b'\'' '\''a,b'\'''

echo '$ json '\''~a|a||~b'\'' '\''a,b'\'''
json '~a|a||~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a|a||~b'\'' '\''a,b'\'''

echo '$ json '\''~a|a||c'\'' '\''a,b'\'''
json '~a|a||c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a|a||c'\'' '\''a,b'\'''

echo '$ json '\''~a|a||~c'\'' '\''a,b'\'''
json '~a|a||~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a|a||~c'\'' '\''a,b'\'''

echo '$ json '\''~a|b||a'\'' '\''a,b'\'''
json '~a|b||a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a|b||a'\'' '\''a,b'\'''

echo '$ json '\''~a|b||~b'\'' '\''a,b'\'''
json '~a|b||~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a|b||~b'\'' '\''a,b'\'''

echo '$ json '\''~a|b||c'\'' '\''a,b'\'''
json '~a|b||c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a|b||c'\'' '\''a,b'\'''

echo '$ json '\''~a|b||~c'\'' '\''a,b'\'''
json '~a|b||~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a|b||~c'\'' '\''a,b'\'''

echo '$ json '\''~a|~b||a'\'' '\''a,b'\'''
json '~a|~b||a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a|~b||a'\'' '\''a,b'\'''

echo '$ json '\''~a|~b||b'\'' '\''a,b'\'''
json '~a|~b||b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a|~b||b'\'' '\''a,b'\'''

echo '$ json '\''~a|~b||c'\'' '\''a,b'\'''
json '~a|~b||c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a|~b||c'\'' '\''a,b'\'''

echo '$ json '\''~a|~b||~c'\'' '\''a,b'\'''
json '~a|~b||~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a|~b||~c'\'' '\''a,b'\'''

echo '$ json '\''~a|c||a'\'' '\''a,b'\'''
json '~a|c||a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a|c||a'\'' '\''a,b'\'''

echo '$ json '\''~a|c||b'\'' '\''a,b'\'''
json '~a|c||b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a|c||b'\'' '\''a,b'\'''

echo '$ json '\''~a|c||~b'\'' '\''a,b'\'''
json '~a|c||~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a|c||~b'\'' '\''a,b'\'''

echo '$ json '\''~a|c||~c'\'' '\''a,b'\'''
json '~a|c||~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a|c||~c'\'' '\''a,b'\'''

echo '$ json '\''~a|~c||a'\'' '\''a,b'\'''
json '~a|~c||a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a|~c||a'\'' '\''a,b'\'''

echo '$ json '\''~a|~c||b'\'' '\''a,b'\'''
json '~a|~c||b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a|~c||b'\'' '\''a,b'\'''

echo '$ json '\''~a|~c||~b'\'' '\''a,b'\'''
json '~a|~c||~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a|~c||~b'\'' '\''a,b'\'''

echo '$ json '\''~a|~c||c'\'' '\''a,b'\'''
json '~a|~c||c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a|~c||c'\'' '\''a,b'\'''

echo '$ json '\''b|a||~a'\'' '\''a,b'\'''
json 'b|a||~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''b|a||~a'\'' '\''a,b'\'''

echo '$ json '\''b|a||~b'\'' '\''a,b'\'''
json 'b|a||~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''b|a||~b'\'' '\''a,b'\'''

echo '$ json '\''b|a||c'\'' '\''a,b'\'''
json 'b|a||c' 'a,b' 2>&1 ||
echo 'command failed: json '\''b|a||c'\'' '\''a,b'\'''

echo '$ json '\''b|a||~c'\'' '\''a,b'\'''
json 'b|a||~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''b|a||~c'\'' '\''a,b'\'''

echo '$ json '\''b|~a||a'\'' '\''a,b'\'''
json 'b|~a||a' 'a,b' 2>&1 ||
echo 'command failed: json '\''b|~a||a'\'' '\''a,b'\'''

echo '$ json '\''b|~a||~b'\'' '\''a,b'\'''
json 'b|~a||~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''b|~a||~b'\'' '\''a,b'\'''

echo '$ json '\''b|~a||c'\'' '\''a,b'\'''
json 'b|~a||c' 'a,b' 2>&1 ||
echo 'command failed: json '\''b|~a||c'\'' '\''a,b'\'''

echo '$ json '\''b|~a||~c'\'' '\''a,b'\'''
json 'b|~a||~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''b|~a||~c'\'' '\''a,b'\'''

echo '$ json '\''b|~b||a'\'' '\''a,b'\'''
json 'b|~b||a' 'a,b' 2>&1 ||
echo 'command failed: json '\''b|~b||a'\'' '\''a,b'\'''

echo '$ json '\''b|~b||~a'\'' '\''a,b'\'''
json 'b|~b||~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''b|~b||~a'\'' '\''a,b'\'''

echo '$ json '\''b|~b||c'\'' '\''a,b'\'''
json 'b|~b||c' 'a,b' 2>&1 ||
echo 'command failed: json '\''b|~b||c'\'' '\''a,b'\'''

echo '$ json '\''b|~b||~c'\'' '\''a,b'\'''
json 'b|~b||~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''b|~b||~c'\'' '\''a,b'\'''

echo '$ json '\''b|c||a'\'' '\''a,b'\'''
json 'b|c||a' 'a,b' 2>&1 ||
echo 'command failed: json '\''b|c||a'\'' '\''a,b'\'''

echo '$ json '\''b|c||~a'\'' '\''a,b'\'''
json 'b|c||~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''b|c||~a'\'' '\''a,b'\'''

echo '$ json '\''b|c||~b'\'' '\''a,b'\'''
json 'b|c||~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''b|c||~b'\'' '\''a,b'\'''

echo '$ json '\''b|c||~c'\'' '\''a,b'\'''
json 'b|c||~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''b|c||~c'\'' '\''a,b'\'''

echo '$ json '\''b|~c||a'\'' '\''a,b'\'''
json 'b|~c||a' 'a,b' 2>&1 ||
echo 'command failed: json '\''b|~c||a'\'' '\''a,b'\'''

echo '$ json '\''b|~c||~a'\'' '\''a,b'\'''
json 'b|~c||~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''b|~c||~a'\'' '\''a,b'\'''

echo '$ json '\''b|~c||~b'\'' '\''a,b'\'''
json 'b|~c||~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''b|~c||~b'\'' '\''a,b'\'''

echo '$ json '\''b|~c||c'\'' '\''a,b'\'''
json 'b|~c||c' 'a,b' 2>&1 ||
echo 'command failed: json '\''b|~c||c'\'' '\''a,b'\'''

echo '$ json '\''~b|a||~a'\'' '\''a,b'\'''
json '~b|a||~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b|a||~a'\'' '\''a,b'\'''

echo '$ json '\''~b|a||b'\'' '\''a,b'\'''
json '~b|a||b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b|a||b'\'' '\''a,b'\'''

echo '$ json '\''~b|a||c'\'' '\''a,b'\'''
json '~b|a||c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b|a||c'\'' '\''a,b'\'''

echo '$ json '\''~b|a||~c'\'' '\''a,b'\'''
json '~b|a||~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b|a||~c'\'' '\''a,b'\'''

echo '$ json '\''~b|~a||a'\'' '\''a,b'\'''
json '~b|~a||a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b|~a||a'\'' '\''a,b'\'''

echo '$ json '\''~b|~a||b'\'' '\''a,b'\'''
json '~b|~a||b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b|~a||b'\'' '\''a,b'\'''

echo '$ json '\''~b|~a||c'\'' '\''a,b'\'''
json '~b|~a||c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b|~a||c'\'' '\''a,b'\'''

echo '$ json '\''~b|~a||~c'\'' '\''a,b'\'''
json '~b|~a||~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b|~a||~c'\'' '\''a,b'\'''

echo '$ json '\''~b|b||a'\'' '\''a,b'\'''
json '~b|b||a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b|b||a'\'' '\''a,b'\'''

echo '$ json '\''~b|b||~a'\'' '\''a,b'\'''
json '~b|b||~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b|b||~a'\'' '\''a,b'\'''

echo '$ json '\''~b|b||c'\'' '\''a,b'\'''
json '~b|b||c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b|b||c'\'' '\''a,b'\'''

echo '$ json '\''~b|b||~c'\'' '\''a,b'\'''
json '~b|b||~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b|b||~c'\'' '\''a,b'\'''

echo '$ json '\''~b|c||a'\'' '\''a,b'\'''
json '~b|c||a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b|c||a'\'' '\''a,b'\'''

echo '$ json '\''~b|c||~a'\'' '\''a,b'\'''
json '~b|c||~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b|c||~a'\'' '\''a,b'\'''

echo '$ json '\''~b|c||b'\'' '\''a,b'\'''
json '~b|c||b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b|c||b'\'' '\''a,b'\'''

echo '$ json '\''~b|c||~c'\'' '\''a,b'\'''
json '~b|c||~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b|c||~c'\'' '\''a,b'\'''

echo '$ json '\''~b|~c||a'\'' '\''a,b'\'''
json '~b|~c||a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b|~c||a'\'' '\''a,b'\'''

echo '$ json '\''~b|~c||~a'\'' '\''a,b'\'''
json '~b|~c||~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b|~c||~a'\'' '\''a,b'\'''

echo '$ json '\''~b|~c||b'\'' '\''a,b'\'''
json '~b|~c||b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b|~c||b'\'' '\''a,b'\'''

echo '$ json '\''~b|~c||c'\'' '\''a,b'\'''
json '~b|~c||c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b|~c||c'\'' '\''a,b'\'''

echo '$ json '\''c|a||~a'\'' '\''a,b'\'''
json 'c|a||~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''c|a||~a'\'' '\''a,b'\'''

echo '$ json '\''c|a||b'\'' '\''a,b'\'''
json 'c|a||b' 'a,b' 2>&1 ||
echo 'command failed: json '\''c|a||b'\'' '\''a,b'\'''

echo '$ json '\''c|a||~b'\'' '\''a,b'\'''
json 'c|a||~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''c|a||~b'\'' '\''a,b'\'''

echo '$ json '\''c|a||~c'\'' '\''a,b'\'''
json 'c|a||~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''c|a||~c'\'' '\''a,b'\'''

echo '$ json '\''c|~a||a'\'' '\''a,b'\'''
json 'c|~a||a' 'a,b' 2>&1 ||
echo 'command failed: json '\''c|~a||a'\'' '\''a,b'\'''

echo '$ json '\''c|~a||b'\'' '\''a,b'\'''
json 'c|~a||b' 'a,b' 2>&1 ||
echo 'command failed: json '\''c|~a||b'\'' '\''a,b'\'''

echo '$ json '\''c|~a||~b'\'' '\''a,b'\'''
json 'c|~a||~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''c|~a||~b'\'' '\''a,b'\'''

echo '$ json '\''c|~a||~c'\'' '\''a,b'\'''
json 'c|~a||~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''c|~a||~c'\'' '\''a,b'\'''

echo '$ json '\''c|b||a'\'' '\''a,b'\'''
json 'c|b||a' 'a,b' 2>&1 ||
echo 'command failed: json '\''c|b||a'\'' '\''a,b'\'''

echo '$ json '\''c|b||~a'\'' '\''a,b'\'''
json 'c|b||~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''c|b||~a'\'' '\''a,b'\'''

echo '$ json '\''c|b||~b'\'' '\''a,b'\'''
json 'c|b||~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''c|b||~b'\'' '\''a,b'\'''

echo '$ json '\''c|b||~c'\'' '\''a,b'\'''
json 'c|b||~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''c|b||~c'\'' '\''a,b'\'''

echo '$ json '\''c|~b||a'\'' '\''a,b'\'''
json 'c|~b||a' 'a,b' 2>&1 ||
echo 'command failed: json '\''c|~b||a'\'' '\''a,b'\'''

echo '$ json '\''c|~b||~a'\'' '\''a,b'\'''
json 'c|~b||~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''c|~b||~a'\'' '\''a,b'\'''

echo '$ json '\''c|~b||b'\'' '\''a,b'\'''
json 'c|~b||b' 'a,b' 2>&1 ||
echo 'command failed: json '\''c|~b||b'\'' '\''a,b'\'''

echo '$ json '\''c|~b||~c'\'' '\''a,b'\'''
json 'c|~b||~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''c|~b||~c'\'' '\''a,b'\'''

echo '$ json '\''c|~c||a'\'' '\''a,b'\'''
json 'c|~c||a' 'a,b' 2>&1 ||
echo 'command failed: json '\''c|~c||a'\'' '\''a,b'\'''

echo '$ json '\''c|~c||~a'\'' '\''a,b'\'''
json 'c|~c||~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''c|~c||~a'\'' '\''a,b'\'''

echo '$ json '\''c|~c||b'\'' '\''a,b'\'''
json 'c|~c||b' 'a,b' 2>&1 ||
echo 'command failed: json '\''c|~c||b'\'' '\''a,b'\'''

echo '$ json '\''c|~c||~b'\'' '\''a,b'\'''
json 'c|~c||~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''c|~c||~b'\'' '\''a,b'\'''

echo '$ json '\''~c|a||~a'\'' '\''a,b'\'''
json '~c|a||~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c|a||~a'\'' '\''a,b'\'''

echo '$ json '\''~c|a||b'\'' '\''a,b'\'''
json '~c|a||b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c|a||b'\'' '\''a,b'\'''

echo '$ json '\''~c|a||~b'\'' '\''a,b'\'''
json '~c|a||~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c|a||~b'\'' '\''a,b'\'''

echo '$ json '\''~c|a||c'\'' '\''a,b'\'''
json '~c|a||c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c|a||c'\'' '\''a,b'\'''

echo '$ json '\''~c|~a||a'\'' '\''a,b'\'''
json '~c|~a||a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c|~a||a'\'' '\''a,b'\'''

echo '$ json '\''~c|~a||b'\'' '\''a,b'\'''
json '~c|~a||b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c|~a||b'\'' '\''a,b'\'''

echo '$ json '\''~c|~a||~b'\'' '\''a,b'\'''
json '~c|~a||~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c|~a||~b'\'' '\''a,b'\'''

echo '$ json '\''~c|~a||c'\'' '\''a,b'\'''
json '~c|~a||c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c|~a||c'\'' '\''a,b'\'''

echo '$ json '\''~c|b||a'\'' '\''a,b'\'''
json '~c|b||a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c|b||a'\'' '\''a,b'\'''

echo '$ json '\''~c|b||~a'\'' '\''a,b'\'''
json '~c|b||~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c|b||~a'\'' '\''a,b'\'''

echo '$ json '\''~c|b||~b'\'' '\''a,b'\'''
json '~c|b||~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c|b||~b'\'' '\''a,b'\'''

echo '$ json '\''~c|b||c'\'' '\''a,b'\'''
json '~c|b||c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c|b||c'\'' '\''a,b'\'''

echo '$ json '\''~c|~b||a'\'' '\''a,b'\'''
json '~c|~b||a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c|~b||a'\'' '\''a,b'\'''

echo '$ json '\''~c|~b||~a'\'' '\''a,b'\'''
json '~c|~b||~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c|~b||~a'\'' '\''a,b'\'''

echo '$ json '\''~c|~b||b'\'' '\''a,b'\'''
json '~c|~b||b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c|~b||b'\'' '\''a,b'\'''

echo '$ json '\''~c|~b||c'\'' '\''a,b'\'''
json '~c|~b||c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c|~b||c'\'' '\''a,b'\'''

echo '$ json '\''~c|c||a'\'' '\''a,b'\'''
json '~c|c||a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c|c||a'\'' '\''a,b'\'''

echo '$ json '\''~c|c||~a'\'' '\''a,b'\'''
json '~c|c||~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c|c||~a'\'' '\''a,b'\'''

echo '$ json '\''~c|c||b'\'' '\''a,b'\'''
json '~c|c||b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c|c||b'\'' '\''a,b'\'''

echo '$ json '\''~c|c||~b'\'' '\''a,b'\'''
json '~c|c||~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c|c||~b'\'' '\''a,b'\'''

echo '$ json '\''a||~a b'\'' '\''a,b'\'''
json 'a||~a b' 'a,b' 2>&1 ||
echo 'command failed: json '\''a||~a b'\'' '\''a,b'\'''

echo '$ json '\''a||~a ~b'\'' '\''a,b'\'''
json 'a||~a ~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''a||~a ~b'\'' '\''a,b'\'''

echo '$ json '\''a||~a c'\'' '\''a,b'\'''
json 'a||~a c' 'a,b' 2>&1 ||
echo 'command failed: json '\''a||~a c'\'' '\''a,b'\'''

echo '$ json '\''a||~a ~c'\'' '\''a,b'\'''
json 'a||~a ~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''a||~a ~c'\'' '\''a,b'\'''

echo '$ json '\''a||b ~a'\'' '\''a,b'\'''
json 'a||b ~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''a||b ~a'\'' '\''a,b'\'''

echo '$ json '\''a||b ~b'\'' '\''a,b'\'''
json 'a||b ~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''a||b ~b'\'' '\''a,b'\'''

echo '$ json '\''a||b c'\'' '\''a,b'\'''
json 'a||b c' 'a,b' 2>&1 ||
echo 'command failed: json '\''a||b c'\'' '\''a,b'\'''

echo '$ json '\''a||b ~c'\'' '\''a,b'\'''
json 'a||b ~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''a||b ~c'\'' '\''a,b'\'''

echo '$ json '\''a||~b ~a'\'' '\''a,b'\'''
json 'a||~b ~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''a||~b ~a'\'' '\''a,b'\'''

echo '$ json '\''a||~b b'\'' '\''a,b'\'''
json 'a||~b b' 'a,b' 2>&1 ||
echo 'command failed: json '\''a||~b b'\'' '\''a,b'\'''

echo '$ json '\''a||~b c'\'' '\''a,b'\'''
json 'a||~b c' 'a,b' 2>&1 ||
echo 'command failed: json '\''a||~b c'\'' '\''a,b'\'''

echo '$ json '\''a||~b ~c'\'' '\''a,b'\'''
json 'a||~b ~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''a||~b ~c'\'' '\''a,b'\'''

echo '$ json '\''a||c ~a'\'' '\''a,b'\'''
json 'a||c ~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''a||c ~a'\'' '\''a,b'\'''

echo '$ json '\''a||c b'\'' '\''a,b'\'''
json 'a||c b' 'a,b' 2>&1 ||
echo 'command failed: json '\''a||c b'\'' '\''a,b'\'''

echo '$ json '\''a||c ~b'\'' '\''a,b'\'''
json 'a||c ~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''a||c ~b'\'' '\''a,b'\'''

echo '$ json '\''a||c ~c'\'' '\''a,b'\'''
json 'a||c ~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''a||c ~c'\'' '\''a,b'\'''

echo '$ json '\''a||~c ~a'\'' '\''a,b'\'''
json 'a||~c ~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''a||~c ~a'\'' '\''a,b'\'''

echo '$ json '\''a||~c b'\'' '\''a,b'\'''
json 'a||~c b' 'a,b' 2>&1 ||
echo 'command failed: json '\''a||~c b'\'' '\''a,b'\'''

echo '$ json '\''a||~c ~b'\'' '\''a,b'\'''
json 'a||~c ~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''a||~c ~b'\'' '\''a,b'\'''

echo '$ json '\''a||~c c'\'' '\''a,b'\'''
json 'a||~c c' 'a,b' 2>&1 ||
echo 'command failed: json '\''a||~c c'\'' '\''a,b'\'''

echo '$ json '\''~a||a b'\'' '\''a,b'\'''
json '~a||a b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a||a b'\'' '\''a,b'\'''

echo '$ json '\''~a||a ~b'\'' '\''a,b'\'''
json '~a||a ~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a||a ~b'\'' '\''a,b'\'''

echo '$ json '\''~a||a c'\'' '\''a,b'\'''
json '~a||a c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a||a c'\'' '\''a,b'\'''

echo '$ json '\''~a||a ~c'\'' '\''a,b'\'''
json '~a||a ~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a||a ~c'\'' '\''a,b'\'''

echo '$ json '\''~a||b a'\'' '\''a,b'\'''
json '~a||b a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a||b a'\'' '\''a,b'\'''

echo '$ json '\''~a||b ~b'\'' '\''a,b'\'''
json '~a||b ~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a||b ~b'\'' '\''a,b'\'''

echo '$ json '\''~a||b c'\'' '\''a,b'\'''
json '~a||b c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a||b c'\'' '\''a,b'\'''

echo '$ json '\''~a||b ~c'\'' '\''a,b'\'''
json '~a||b ~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a||b ~c'\'' '\''a,b'\'''

echo '$ json '\''~a||~b a'\'' '\''a,b'\'''
json '~a||~b a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a||~b a'\'' '\''a,b'\'''

echo '$ json '\''~a||~b b'\'' '\''a,b'\'''
json '~a||~b b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a||~b b'\'' '\''a,b'\'''

echo '$ json '\''~a||~b c'\'' '\''a,b'\'''
json '~a||~b c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a||~b c'\'' '\''a,b'\'''

echo '$ json '\''~a||~b ~c'\'' '\''a,b'\'''
json '~a||~b ~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a||~b ~c'\'' '\''a,b'\'''

echo '$ json '\''~a||c a'\'' '\''a,b'\'''
json '~a||c a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a||c a'\'' '\''a,b'\'''

echo '$ json '\''~a||c b'\'' '\''a,b'\'''
json '~a||c b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a||c b'\'' '\''a,b'\'''

echo '$ json '\''~a||c ~b'\'' '\''a,b'\'''
json '~a||c ~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a||c ~b'\'' '\''a,b'\'''

echo '$ json '\''~a||c ~c'\'' '\''a,b'\'''
json '~a||c ~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a||c ~c'\'' '\''a,b'\'''

echo '$ json '\''~a||~c a'\'' '\''a,b'\'''
json '~a||~c a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a||~c a'\'' '\''a,b'\'''

echo '$ json '\''~a||~c b'\'' '\''a,b'\'''
json '~a||~c b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a||~c b'\'' '\''a,b'\'''

echo '$ json '\''~a||~c ~b'\'' '\''a,b'\'''
json '~a||~c ~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a||~c ~b'\'' '\''a,b'\'''

echo '$ json '\''~a||~c c'\'' '\''a,b'\'''
json '~a||~c c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a||~c c'\'' '\''a,b'\'''

echo '$ json '\''b||a ~a'\'' '\''a,b'\'''
json 'b||a ~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''b||a ~a'\'' '\''a,b'\'''

echo '$ json '\''b||a ~b'\'' '\''a,b'\'''
json 'b||a ~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''b||a ~b'\'' '\''a,b'\'''

echo '$ json '\''b||a c'\'' '\''a,b'\'''
json 'b||a c' 'a,b' 2>&1 ||
echo 'command failed: json '\''b||a c'\'' '\''a,b'\'''

echo '$ json '\''b||a ~c'\'' '\''a,b'\'''
json 'b||a ~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''b||a ~c'\'' '\''a,b'\'''

echo '$ json '\''b||~a a'\'' '\''a,b'\'''
json 'b||~a a' 'a,b' 2>&1 ||
echo 'command failed: json '\''b||~a a'\'' '\''a,b'\'''

echo '$ json '\''b||~a ~b'\'' '\''a,b'\'''
json 'b||~a ~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''b||~a ~b'\'' '\''a,b'\'''

echo '$ json '\''b||~a c'\'' '\''a,b'\'''
json 'b||~a c' 'a,b' 2>&1 ||
echo 'command failed: json '\''b||~a c'\'' '\''a,b'\'''

echo '$ json '\''b||~a ~c'\'' '\''a,b'\'''
json 'b||~a ~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''b||~a ~c'\'' '\''a,b'\'''

echo '$ json '\''b||~b a'\'' '\''a,b'\'''
json 'b||~b a' 'a,b' 2>&1 ||
echo 'command failed: json '\''b||~b a'\'' '\''a,b'\'''

echo '$ json '\''b||~b ~a'\'' '\''a,b'\'''
json 'b||~b ~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''b||~b ~a'\'' '\''a,b'\'''

echo '$ json '\''b||~b c'\'' '\''a,b'\'''
json 'b||~b c' 'a,b' 2>&1 ||
echo 'command failed: json '\''b||~b c'\'' '\''a,b'\'''

echo '$ json '\''b||~b ~c'\'' '\''a,b'\'''
json 'b||~b ~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''b||~b ~c'\'' '\''a,b'\'''

echo '$ json '\''b||c a'\'' '\''a,b'\'''
json 'b||c a' 'a,b' 2>&1 ||
echo 'command failed: json '\''b||c a'\'' '\''a,b'\'''

echo '$ json '\''b||c ~a'\'' '\''a,b'\'''
json 'b||c ~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''b||c ~a'\'' '\''a,b'\'''

echo '$ json '\''b||c ~b'\'' '\''a,b'\'''
json 'b||c ~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''b||c ~b'\'' '\''a,b'\'''

echo '$ json '\''b||c ~c'\'' '\''a,b'\'''
json 'b||c ~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''b||c ~c'\'' '\''a,b'\'''

echo '$ json '\''b||~c a'\'' '\''a,b'\'''
json 'b||~c a' 'a,b' 2>&1 ||
echo 'command failed: json '\''b||~c a'\'' '\''a,b'\'''

echo '$ json '\''b||~c ~a'\'' '\''a,b'\'''
json 'b||~c ~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''b||~c ~a'\'' '\''a,b'\'''

echo '$ json '\''b||~c ~b'\'' '\''a,b'\'''
json 'b||~c ~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''b||~c ~b'\'' '\''a,b'\'''

echo '$ json '\''b||~c c'\'' '\''a,b'\'''
json 'b||~c c' 'a,b' 2>&1 ||
echo 'command failed: json '\''b||~c c'\'' '\''a,b'\'''

echo '$ json '\''~b||a ~a'\'' '\''a,b'\'''
json '~b||a ~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b||a ~a'\'' '\''a,b'\'''

echo '$ json '\''~b||a b'\'' '\''a,b'\'''
json '~b||a b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b||a b'\'' '\''a,b'\'''

echo '$ json '\''~b||a c'\'' '\''a,b'\'''
json '~b||a c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b||a c'\'' '\''a,b'\'''

echo '$ json '\''~b||a ~c'\'' '\''a,b'\'''
json '~b||a ~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b||a ~c'\'' '\''a,b'\'''

echo '$ json '\''~b||~a a'\'' '\''a,b'\'''
json '~b||~a a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b||~a a'\'' '\''a,b'\'''

echo '$ json '\''~b||~a b'\'' '\''a,b'\'''
json '~b||~a b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b||~a b'\'' '\''a,b'\'''

echo '$ json '\''~b||~a c'\'' '\''a,b'\'''
json '~b||~a c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b||~a c'\'' '\''a,b'\'''

echo '$ json '\''~b||~a ~c'\'' '\''a,b'\'''
json '~b||~a ~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b||~a ~c'\'' '\''a,b'\'''

echo '$ json '\''~b||b a'\'' '\''a,b'\'''
json '~b||b a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b||b a'\'' '\''a,b'\'''

echo '$ json '\''~b||b ~a'\'' '\''a,b'\'''
json '~b||b ~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b||b ~a'\'' '\''a,b'\'''

echo '$ json '\''~b||b c'\'' '\''a,b'\'''
json '~b||b c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b||b c'\'' '\''a,b'\'''

echo '$ json '\''~b||b ~c'\'' '\''a,b'\'''
json '~b||b ~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b||b ~c'\'' '\''a,b'\'''

echo '$ json '\''~b||c a'\'' '\''a,b'\'''
json '~b||c a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b||c a'\'' '\''a,b'\'''

echo '$ json '\''~b||c ~a'\'' '\''a,b'\'''
json '~b||c ~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b||c ~a'\'' '\''a,b'\'''

echo '$ json '\''~b||c b'\'' '\''a,b'\'''
json '~b||c b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b||c b'\'' '\''a,b'\'''

echo '$ json '\''~b||c ~c'\'' '\''a,b'\'''
json '~b||c ~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b||c ~c'\'' '\''a,b'\'''

echo '$ json '\''~b||~c a'\'' '\''a,b'\'''
json '~b||~c a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b||~c a'\'' '\''a,b'\'''

echo '$ json '\''~b||~c ~a'\'' '\''a,b'\'''
json '~b||~c ~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b||~c ~a'\'' '\''a,b'\'''

echo '$ json '\''~b||~c b'\'' '\''a,b'\'''
json '~b||~c b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b||~c b'\'' '\''a,b'\'''

echo '$ json '\''~b||~c c'\'' '\''a,b'\'''
json '~b||~c c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b||~c c'\'' '\''a,b'\'''

echo '$ json '\''c||a ~a'\'' '\''a,b'\'''
json 'c||a ~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''c||a ~a'\'' '\''a,b'\'''

echo '$ json '\''c||a b'\'' '\''a,b'\'''
json 'c||a b' 'a,b' 2>&1 ||
echo 'command failed: json '\''c||a b'\'' '\''a,b'\'''

echo '$ json '\''c||a ~b'\'' '\''a,b'\'''
json 'c||a ~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''c||a ~b'\'' '\''a,b'\'''

echo '$ json '\''c||a ~c'\'' '\''a,b'\'''
json 'c||a ~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''c||a ~c'\'' '\''a,b'\'''

echo '$ json '\''c||~a a'\'' '\''a,b'\'''
json 'c||~a a' 'a,b' 2>&1 ||
echo 'command failed: json '\''c||~a a'\'' '\''a,b'\'''

echo '$ json '\''c||~a b'\'' '\''a,b'\'''
json 'c||~a b' 'a,b' 2>&1 ||
echo 'command failed: json '\''c||~a b'\'' '\''a,b'\'''

echo '$ json '\''c||~a ~b'\'' '\''a,b'\'''
json 'c||~a ~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''c||~a ~b'\'' '\''a,b'\'''

echo '$ json '\''c||~a ~c'\'' '\''a,b'\'''
json 'c||~a ~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''c||~a ~c'\'' '\''a,b'\'''

echo '$ json '\''c||b a'\'' '\''a,b'\'''
json 'c||b a' 'a,b' 2>&1 ||
echo 'command failed: json '\''c||b a'\'' '\''a,b'\'''

echo '$ json '\''c||b ~a'\'' '\''a,b'\'''
json 'c||b ~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''c||b ~a'\'' '\''a,b'\'''

echo '$ json '\''c||b ~b'\'' '\''a,b'\'''
json 'c||b ~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''c||b ~b'\'' '\''a,b'\'''

echo '$ json '\''c||b ~c'\'' '\''a,b'\'''
json 'c||b ~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''c||b ~c'\'' '\''a,b'\'''

echo '$ json '\''c||~b a'\'' '\''a,b'\'''
json 'c||~b a' 'a,b' 2>&1 ||
echo 'command failed: json '\''c||~b a'\'' '\''a,b'\'''

echo '$ json '\''c||~b ~a'\'' '\''a,b'\'''
json 'c||~b ~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''c||~b ~a'\'' '\''a,b'\'''

echo '$ json '\''c||~b b'\'' '\''a,b'\'''
json 'c||~b b' 'a,b' 2>&1 ||
echo 'command failed: json '\''c||~b b'\'' '\''a,b'\'''

echo '$ json '\''c||~b ~c'\'' '\''a,b'\'''
json 'c||~b ~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''c||~b ~c'\'' '\''a,b'\'''

echo '$ json '\''c||~c a'\'' '\''a,b'\'''
json 'c||~c a' 'a,b' 2>&1 ||
echo 'command failed: json '\''c||~c a'\'' '\''a,b'\'''

echo '$ json '\''c||~c ~a'\'' '\''a,b'\'''
json 'c||~c ~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''c||~c ~a'\'' '\''a,b'\'''

echo '$ json '\''c||~c b'\'' '\''a,b'\'''
json 'c||~c b' 'a,b' 2>&1 ||
echo 'command failed: json '\''c||~c b'\'' '\''a,b'\'''

echo '$ json '\''c||~c ~b'\'' '\''a,b'\'''
json 'c||~c ~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''c||~c ~b'\'' '\''a,b'\'''

echo '$ json '\''~c||a ~a'\'' '\''a,b'\'''
json '~c||a ~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c||a ~a'\'' '\''a,b'\'''

echo '$ json '\''~c||a b'\'' '\''a,b'\'''
json '~c||a b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c||a b'\'' '\''a,b'\'''

echo '$ json '\''~c||a ~b'\'' '\''a,b'\'''
json '~c||a ~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c||a ~b'\'' '\''a,b'\'''

echo '$ json '\''~c||a c'\'' '\''a,b'\'''
json '~c||a c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c||a c'\'' '\''a,b'\'''

echo '$ json '\''~c||~a a'\'' '\''a,b'\'''
json '~c||~a a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c||~a a'\'' '\''a,b'\'''

echo '$ json '\''~c||~a b'\'' '\''a,b'\'''
json '~c||~a b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c||~a b'\'' '\''a,b'\'''

echo '$ json '\''~c||~a ~b'\'' '\''a,b'\'''
json '~c||~a ~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c||~a ~b'\'' '\''a,b'\'''

echo '$ json '\''~c||~a c'\'' '\''a,b'\'''
json '~c||~a c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c||~a c'\'' '\''a,b'\'''

echo '$ json '\''~c||b a'\'' '\''a,b'\'''
json '~c||b a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c||b a'\'' '\''a,b'\'''

echo '$ json '\''~c||b ~a'\'' '\''a,b'\'''
json '~c||b ~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c||b ~a'\'' '\''a,b'\'''

echo '$ json '\''~c||b ~b'\'' '\''a,b'\'''
json '~c||b ~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c||b ~b'\'' '\''a,b'\'''

echo '$ json '\''~c||b c'\'' '\''a,b'\'''
json '~c||b c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c||b c'\'' '\''a,b'\'''

echo '$ json '\''~c||~b a'\'' '\''a,b'\'''
json '~c||~b a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c||~b a'\'' '\''a,b'\'''

echo '$ json '\''~c||~b ~a'\'' '\''a,b'\'''
json '~c||~b ~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c||~b ~a'\'' '\''a,b'\'''

echo '$ json '\''~c||~b b'\'' '\''a,b'\'''
json '~c||~b b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c||~b b'\'' '\''a,b'\'''

echo '$ json '\''~c||~b c'\'' '\''a,b'\'''
json '~c||~b c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c||~b c'\'' '\''a,b'\'''

echo '$ json '\''~c||c a'\'' '\''a,b'\'''
json '~c||c a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c||c a'\'' '\''a,b'\'''

echo '$ json '\''~c||c ~a'\'' '\''a,b'\'''
json '~c||c ~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c||c ~a'\'' '\''a,b'\'''

echo '$ json '\''~c||c b'\'' '\''a,b'\'''
json '~c||c b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c||c b'\'' '\''a,b'\'''

echo '$ json '\''~c||c ~b'\'' '\''a,b'\'''
json '~c||c ~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c||c ~b'\'' '\''a,b'\'''

echo '$ json '\''a||~a|b'\'' '\''a,b'\'''
json 'a||~a|b' 'a,b' 2>&1 ||
echo 'command failed: json '\''a||~a|b'\'' '\''a,b'\'''

echo '$ json '\''a||~a|~b'\'' '\''a,b'\'''
json 'a||~a|~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''a||~a|~b'\'' '\''a,b'\'''

echo '$ json '\''a||~a|c'\'' '\''a,b'\'''
json 'a||~a|c' 'a,b' 2>&1 ||
echo 'command failed: json '\''a||~a|c'\'' '\''a,b'\'''

echo '$ json '\''a||~a|~c'\'' '\''a,b'\'''
json 'a||~a|~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''a||~a|~c'\'' '\''a,b'\'''

echo '$ json '\''a||b|~a'\'' '\''a,b'\'''
json 'a||b|~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''a||b|~a'\'' '\''a,b'\'''

echo '$ json '\''a||b|~b'\'' '\''a,b'\'''
json 'a||b|~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''a||b|~b'\'' '\''a,b'\'''

echo '$ json '\''a||b|c'\'' '\''a,b'\'''
json 'a||b|c' 'a,b' 2>&1 ||
echo 'command failed: json '\''a||b|c'\'' '\''a,b'\'''

echo '$ json '\''a||b|~c'\'' '\''a,b'\'''
json 'a||b|~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''a||b|~c'\'' '\''a,b'\'''

echo '$ json '\''a||~b|~a'\'' '\''a,b'\'''
json 'a||~b|~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''a||~b|~a'\'' '\''a,b'\'''

echo '$ json '\''a||~b|b'\'' '\''a,b'\'''
json 'a||~b|b' 'a,b' 2>&1 ||
echo 'command failed: json '\''a||~b|b'\'' '\''a,b'\'''

echo '$ json '\''a||~b|c'\'' '\''a,b'\'''
json 'a||~b|c' 'a,b' 2>&1 ||
echo 'command failed: json '\''a||~b|c'\'' '\''a,b'\'''

echo '$ json '\''a||~b|~c'\'' '\''a,b'\'''
json 'a||~b|~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''a||~b|~c'\'' '\''a,b'\'''

echo '$ json '\''a||c|~a'\'' '\''a,b'\'''
json 'a||c|~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''a||c|~a'\'' '\''a,b'\'''

echo '$ json '\''a||c|b'\'' '\''a,b'\'''
json 'a||c|b' 'a,b' 2>&1 ||
echo 'command failed: json '\''a||c|b'\'' '\''a,b'\'''

echo '$ json '\''a||c|~b'\'' '\''a,b'\'''
json 'a||c|~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''a||c|~b'\'' '\''a,b'\'''

echo '$ json '\''a||c|~c'\'' '\''a,b'\'''
json 'a||c|~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''a||c|~c'\'' '\''a,b'\'''

echo '$ json '\''a||~c|~a'\'' '\''a,b'\'''
json 'a||~c|~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''a||~c|~a'\'' '\''a,b'\'''

echo '$ json '\''a||~c|b'\'' '\''a,b'\'''
json 'a||~c|b' 'a,b' 2>&1 ||
echo 'command failed: json '\''a||~c|b'\'' '\''a,b'\'''

echo '$ json '\''a||~c|~b'\'' '\''a,b'\'''
json 'a||~c|~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''a||~c|~b'\'' '\''a,b'\'''

echo '$ json '\''a||~c|c'\'' '\''a,b'\'''
json 'a||~c|c' 'a,b' 2>&1 ||
echo 'command failed: json '\''a||~c|c'\'' '\''a,b'\'''

echo '$ json '\''~a||a|b'\'' '\''a,b'\'''
json '~a||a|b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a||a|b'\'' '\''a,b'\'''

echo '$ json '\''~a||a|~b'\'' '\''a,b'\'''
json '~a||a|~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a||a|~b'\'' '\''a,b'\'''

echo '$ json '\''~a||a|c'\'' '\''a,b'\'''
json '~a||a|c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a||a|c'\'' '\''a,b'\'''

echo '$ json '\''~a||a|~c'\'' '\''a,b'\'''
json '~a||a|~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a||a|~c'\'' '\''a,b'\'''

echo '$ json '\''~a||b|a'\'' '\''a,b'\'''
json '~a||b|a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a||b|a'\'' '\''a,b'\'''

echo '$ json '\''~a||b|~b'\'' '\''a,b'\'''
json '~a||b|~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a||b|~b'\'' '\''a,b'\'''

echo '$ json '\''~a||b|c'\'' '\''a,b'\'''
json '~a||b|c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a||b|c'\'' '\''a,b'\'''

echo '$ json '\''~a||b|~c'\'' '\''a,b'\'''
json '~a||b|~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a||b|~c'\'' '\''a,b'\'''

echo '$ json '\''~a||~b|a'\'' '\''a,b'\'''
json '~a||~b|a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a||~b|a'\'' '\''a,b'\'''

echo '$ json '\''~a||~b|b'\'' '\''a,b'\'''
json '~a||~b|b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a||~b|b'\'' '\''a,b'\'''

echo '$ json '\''~a||~b|c'\'' '\''a,b'\'''
json '~a||~b|c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a||~b|c'\'' '\''a,b'\'''

echo '$ json '\''~a||~b|~c'\'' '\''a,b'\'''
json '~a||~b|~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a||~b|~c'\'' '\''a,b'\'''

echo '$ json '\''~a||c|a'\'' '\''a,b'\'''
json '~a||c|a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a||c|a'\'' '\''a,b'\'''

echo '$ json '\''~a||c|b'\'' '\''a,b'\'''
json '~a||c|b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a||c|b'\'' '\''a,b'\'''

echo '$ json '\''~a||c|~b'\'' '\''a,b'\'''
json '~a||c|~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a||c|~b'\'' '\''a,b'\'''

echo '$ json '\''~a||c|~c'\'' '\''a,b'\'''
json '~a||c|~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a||c|~c'\'' '\''a,b'\'''

echo '$ json '\''~a||~c|a'\'' '\''a,b'\'''
json '~a||~c|a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a||~c|a'\'' '\''a,b'\'''

echo '$ json '\''~a||~c|b'\'' '\''a,b'\'''
json '~a||~c|b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a||~c|b'\'' '\''a,b'\'''

echo '$ json '\''~a||~c|~b'\'' '\''a,b'\'''
json '~a||~c|~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a||~c|~b'\'' '\''a,b'\'''

echo '$ json '\''~a||~c|c'\'' '\''a,b'\'''
json '~a||~c|c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a||~c|c'\'' '\''a,b'\'''

echo '$ json '\''b||a|~a'\'' '\''a,b'\'''
json 'b||a|~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''b||a|~a'\'' '\''a,b'\'''

echo '$ json '\''b||a|~b'\'' '\''a,b'\'''
json 'b||a|~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''b||a|~b'\'' '\''a,b'\'''

echo '$ json '\''b||a|c'\'' '\''a,b'\'''
json 'b||a|c' 'a,b' 2>&1 ||
echo 'command failed: json '\''b||a|c'\'' '\''a,b'\'''

echo '$ json '\''b||a|~c'\'' '\''a,b'\'''
json 'b||a|~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''b||a|~c'\'' '\''a,b'\'''

echo '$ json '\''b||~a|a'\'' '\''a,b'\'''
json 'b||~a|a' 'a,b' 2>&1 ||
echo 'command failed: json '\''b||~a|a'\'' '\''a,b'\'''

echo '$ json '\''b||~a|~b'\'' '\''a,b'\'''
json 'b||~a|~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''b||~a|~b'\'' '\''a,b'\'''

echo '$ json '\''b||~a|c'\'' '\''a,b'\'''
json 'b||~a|c' 'a,b' 2>&1 ||
echo 'command failed: json '\''b||~a|c'\'' '\''a,b'\'''

echo '$ json '\''b||~a|~c'\'' '\''a,b'\'''
json 'b||~a|~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''b||~a|~c'\'' '\''a,b'\'''

echo '$ json '\''b||~b|a'\'' '\''a,b'\'''
json 'b||~b|a' 'a,b' 2>&1 ||
echo 'command failed: json '\''b||~b|a'\'' '\''a,b'\'''

echo '$ json '\''b||~b|~a'\'' '\''a,b'\'''
json 'b||~b|~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''b||~b|~a'\'' '\''a,b'\'''

echo '$ json '\''b||~b|c'\'' '\''a,b'\'''
json 'b||~b|c' 'a,b' 2>&1 ||
echo 'command failed: json '\''b||~b|c'\'' '\''a,b'\'''

echo '$ json '\''b||~b|~c'\'' '\''a,b'\'''
json 'b||~b|~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''b||~b|~c'\'' '\''a,b'\'''

echo '$ json '\''b||c|a'\'' '\''a,b'\'''
json 'b||c|a' 'a,b' 2>&1 ||
echo 'command failed: json '\''b||c|a'\'' '\''a,b'\'''

echo '$ json '\''b||c|~a'\'' '\''a,b'\'''
json 'b||c|~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''b||c|~a'\'' '\''a,b'\'''

echo '$ json '\''b||c|~b'\'' '\''a,b'\'''
json 'b||c|~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''b||c|~b'\'' '\''a,b'\'''

echo '$ json '\''b||c|~c'\'' '\''a,b'\'''
json 'b||c|~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''b||c|~c'\'' '\''a,b'\'''

echo '$ json '\''b||~c|a'\'' '\''a,b'\'''
json 'b||~c|a' 'a,b' 2>&1 ||
echo 'command failed: json '\''b||~c|a'\'' '\''a,b'\'''

echo '$ json '\''b||~c|~a'\'' '\''a,b'\'''
json 'b||~c|~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''b||~c|~a'\'' '\''a,b'\'''

echo '$ json '\''b||~c|~b'\'' '\''a,b'\'''
json 'b||~c|~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''b||~c|~b'\'' '\''a,b'\'''

echo '$ json '\''b||~c|c'\'' '\''a,b'\'''
json 'b||~c|c' 'a,b' 2>&1 ||
echo 'command failed: json '\''b||~c|c'\'' '\''a,b'\'''

echo '$ json '\''~b||a|~a'\'' '\''a,b'\'''
json '~b||a|~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b||a|~a'\'' '\''a,b'\'''

echo '$ json '\''~b||a|b'\'' '\''a,b'\'''
json '~b||a|b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b||a|b'\'' '\''a,b'\'''

echo '$ json '\''~b||a|c'\'' '\''a,b'\'''
json '~b||a|c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b||a|c'\'' '\''a,b'\'''

echo '$ json '\''~b||a|~c'\'' '\''a,b'\'''
json '~b||a|~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b||a|~c'\'' '\''a,b'\'''

echo '$ json '\''~b||~a|a'\'' '\''a,b'\'''
json '~b||~a|a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b||~a|a'\'' '\''a,b'\'''

echo '$ json '\''~b||~a|b'\'' '\''a,b'\'''
json '~b||~a|b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b||~a|b'\'' '\''a,b'\'''

echo '$ json '\''~b||~a|c'\'' '\''a,b'\'''
json '~b||~a|c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b||~a|c'\'' '\''a,b'\'''

echo '$ json '\''~b||~a|~c'\'' '\''a,b'\'''
json '~b||~a|~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b||~a|~c'\'' '\''a,b'\'''

echo '$ json '\''~b||b|a'\'' '\''a,b'\'''
json '~b||b|a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b||b|a'\'' '\''a,b'\'''

echo '$ json '\''~b||b|~a'\'' '\''a,b'\'''
json '~b||b|~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b||b|~a'\'' '\''a,b'\'''

echo '$ json '\''~b||b|c'\'' '\''a,b'\'''
json '~b||b|c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b||b|c'\'' '\''a,b'\'''

echo '$ json '\''~b||b|~c'\'' '\''a,b'\'''
json '~b||b|~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b||b|~c'\'' '\''a,b'\'''

echo '$ json '\''~b||c|a'\'' '\''a,b'\'''
json '~b||c|a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b||c|a'\'' '\''a,b'\'''

echo '$ json '\''~b||c|~a'\'' '\''a,b'\'''
json '~b||c|~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b||c|~a'\'' '\''a,b'\'''

echo '$ json '\''~b||c|b'\'' '\''a,b'\'''
json '~b||c|b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b||c|b'\'' '\''a,b'\'''

echo '$ json '\''~b||c|~c'\'' '\''a,b'\'''
json '~b||c|~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b||c|~c'\'' '\''a,b'\'''

echo '$ json '\''~b||~c|a'\'' '\''a,b'\'''
json '~b||~c|a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b||~c|a'\'' '\''a,b'\'''

echo '$ json '\''~b||~c|~a'\'' '\''a,b'\'''
json '~b||~c|~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b||~c|~a'\'' '\''a,b'\'''

echo '$ json '\''~b||~c|b'\'' '\''a,b'\'''
json '~b||~c|b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b||~c|b'\'' '\''a,b'\'''

echo '$ json '\''~b||~c|c'\'' '\''a,b'\'''
json '~b||~c|c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b||~c|c'\'' '\''a,b'\'''

echo '$ json '\''c||a|~a'\'' '\''a,b'\'''
json 'c||a|~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''c||a|~a'\'' '\''a,b'\'''

echo '$ json '\''c||a|b'\'' '\''a,b'\'''
json 'c||a|b' 'a,b' 2>&1 ||
echo 'command failed: json '\''c||a|b'\'' '\''a,b'\'''

echo '$ json '\''c||a|~b'\'' '\''a,b'\'''
json 'c||a|~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''c||a|~b'\'' '\''a,b'\'''

echo '$ json '\''c||a|~c'\'' '\''a,b'\'''
json 'c||a|~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''c||a|~c'\'' '\''a,b'\'''

echo '$ json '\''c||~a|a'\'' '\''a,b'\'''
json 'c||~a|a' 'a,b' 2>&1 ||
echo 'command failed: json '\''c||~a|a'\'' '\''a,b'\'''

echo '$ json '\''c||~a|b'\'' '\''a,b'\'''
json 'c||~a|b' 'a,b' 2>&1 ||
echo 'command failed: json '\''c||~a|b'\'' '\''a,b'\'''

echo '$ json '\''c||~a|~b'\'' '\''a,b'\'''
json 'c||~a|~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''c||~a|~b'\'' '\''a,b'\'''

echo '$ json '\''c||~a|~c'\'' '\''a,b'\'''
json 'c||~a|~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''c||~a|~c'\'' '\''a,b'\'''

echo '$ json '\''c||b|a'\'' '\''a,b'\'''
json 'c||b|a' 'a,b' 2>&1 ||
echo 'command failed: json '\''c||b|a'\'' '\''a,b'\'''

echo '$ json '\''c||b|~a'\'' '\''a,b'\'''
json 'c||b|~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''c||b|~a'\'' '\''a,b'\'''

echo '$ json '\''c||b|~b'\'' '\''a,b'\'''
json 'c||b|~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''c||b|~b'\'' '\''a,b'\'''

echo '$ json '\''c||b|~c'\'' '\''a,b'\'''
json 'c||b|~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''c||b|~c'\'' '\''a,b'\'''

echo '$ json '\''c||~b|a'\'' '\''a,b'\'''
json 'c||~b|a' 'a,b' 2>&1 ||
echo 'command failed: json '\''c||~b|a'\'' '\''a,b'\'''

echo '$ json '\''c||~b|~a'\'' '\''a,b'\'''
json 'c||~b|~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''c||~b|~a'\'' '\''a,b'\'''

echo '$ json '\''c||~b|b'\'' '\''a,b'\'''
json 'c||~b|b' 'a,b' 2>&1 ||
echo 'command failed: json '\''c||~b|b'\'' '\''a,b'\'''

echo '$ json '\''c||~b|~c'\'' '\''a,b'\'''
json 'c||~b|~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''c||~b|~c'\'' '\''a,b'\'''

echo '$ json '\''c||~c|a'\'' '\''a,b'\'''
json 'c||~c|a' 'a,b' 2>&1 ||
echo 'command failed: json '\''c||~c|a'\'' '\''a,b'\'''

echo '$ json '\''c||~c|~a'\'' '\''a,b'\'''
json 'c||~c|~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''c||~c|~a'\'' '\''a,b'\'''

echo '$ json '\''c||~c|b'\'' '\''a,b'\'''
json 'c||~c|b' 'a,b' 2>&1 ||
echo 'command failed: json '\''c||~c|b'\'' '\''a,b'\'''

echo '$ json '\''c||~c|~b'\'' '\''a,b'\'''
json 'c||~c|~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''c||~c|~b'\'' '\''a,b'\'''

echo '$ json '\''~c||a|~a'\'' '\''a,b'\'''
json '~c||a|~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c||a|~a'\'' '\''a,b'\'''

echo '$ json '\''~c||a|b'\'' '\''a,b'\'''
json '~c||a|b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c||a|b'\'' '\''a,b'\'''

echo '$ json '\''~c||a|~b'\'' '\''a,b'\'''
json '~c||a|~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c||a|~b'\'' '\''a,b'\'''

echo '$ json '\''~c||a|c'\'' '\''a,b'\'''
json '~c||a|c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c||a|c'\'' '\''a,b'\'''

echo '$ json '\''~c||~a|a'\'' '\''a,b'\'''
json '~c||~a|a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c||~a|a'\'' '\''a,b'\'''

echo '$ json '\''~c||~a|b'\'' '\''a,b'\'''
json '~c||~a|b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c||~a|b'\'' '\''a,b'\'''

echo '$ json '\''~c||~a|~b'\'' '\''a,b'\'''
json '~c||~a|~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c||~a|~b'\'' '\''a,b'\'''

echo '$ json '\''~c||~a|c'\'' '\''a,b'\'''
json '~c||~a|c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c||~a|c'\'' '\''a,b'\'''

echo '$ json '\''~c||b|a'\'' '\''a,b'\'''
json '~c||b|a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c||b|a'\'' '\''a,b'\'''

echo '$ json '\''~c||b|~a'\'' '\''a,b'\'''
json '~c||b|~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c||b|~a'\'' '\''a,b'\'''

echo '$ json '\''~c||b|~b'\'' '\''a,b'\'''
json '~c||b|~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c||b|~b'\'' '\''a,b'\'''

echo '$ json '\''~c||b|c'\'' '\''a,b'\'''
json '~c||b|c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c||b|c'\'' '\''a,b'\'''

echo '$ json '\''~c||~b|a'\'' '\''a,b'\'''
json '~c||~b|a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c||~b|a'\'' '\''a,b'\'''

echo '$ json '\''~c||~b|~a'\'' '\''a,b'\'''
json '~c||~b|~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c||~b|~a'\'' '\''a,b'\'''

echo '$ json '\''~c||~b|b'\'' '\''a,b'\'''
json '~c||~b|b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c||~b|b'\'' '\''a,b'\'''

echo '$ json '\''~c||~b|c'\'' '\''a,b'\'''
json '~c||~b|c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c||~b|c'\'' '\''a,b'\'''

echo '$ json '\''~c||c|a'\'' '\''a,b'\'''
json '~c||c|a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c||c|a'\'' '\''a,b'\'''

echo '$ json '\''~c||c|~a'\'' '\''a,b'\'''
json '~c||c|~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c||c|~a'\'' '\''a,b'\'''

echo '$ json '\''~c||c|b'\'' '\''a,b'\'''
json '~c||c|b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c||c|b'\'' '\''a,b'\'''

echo '$ json '\''~c||c|~b'\'' '\''a,b'\'''
json '~c||c|~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c||c|~b'\'' '\''a,b'\'''

echo '$ json '\''a||~a||b'\'' '\''a,b'\'''
json 'a||~a||b' 'a,b' 2>&1 ||
echo 'command failed: json '\''a||~a||b'\'' '\''a,b'\'''

echo '$ json '\''a||~a||~b'\'' '\''a,b'\'''
json 'a||~a||~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''a||~a||~b'\'' '\''a,b'\'''

echo '$ json '\''a||~a||c'\'' '\''a,b'\'''
json 'a||~a||c' 'a,b' 2>&1 ||
echo 'command failed: json '\''a||~a||c'\'' '\''a,b'\'''

echo '$ json '\''a||~a||~c'\'' '\''a,b'\'''
json 'a||~a||~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''a||~a||~c'\'' '\''a,b'\'''

echo '$ json '\''a||b||~a'\'' '\''a,b'\'''
json 'a||b||~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''a||b||~a'\'' '\''a,b'\'''

echo '$ json '\''a||b||~b'\'' '\''a,b'\'''
json 'a||b||~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''a||b||~b'\'' '\''a,b'\'''

echo '$ json '\''a||b||c'\'' '\''a,b'\'''
json 'a||b||c' 'a,b' 2>&1 ||
echo 'command failed: json '\''a||b||c'\'' '\''a,b'\'''

echo '$ json '\''a||b||~c'\'' '\''a,b'\'''
json 'a||b||~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''a||b||~c'\'' '\''a,b'\'''

echo '$ json '\''a||~b||~a'\'' '\''a,b'\'''
json 'a||~b||~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''a||~b||~a'\'' '\''a,b'\'''

echo '$ json '\''a||~b||b'\'' '\''a,b'\'''
json 'a||~b||b' 'a,b' 2>&1 ||
echo 'command failed: json '\''a||~b||b'\'' '\''a,b'\'''

echo '$ json '\''a||~b||c'\'' '\''a,b'\'''
json 'a||~b||c' 'a,b' 2>&1 ||
echo 'command failed: json '\''a||~b||c'\'' '\''a,b'\'''

echo '$ json '\''a||~b||~c'\'' '\''a,b'\'''
json 'a||~b||~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''a||~b||~c'\'' '\''a,b'\'''

echo '$ json '\''a||c||~a'\'' '\''a,b'\'''
json 'a||c||~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''a||c||~a'\'' '\''a,b'\'''

echo '$ json '\''a||c||b'\'' '\''a,b'\'''
json 'a||c||b' 'a,b' 2>&1 ||
echo 'command failed: json '\''a||c||b'\'' '\''a,b'\'''

echo '$ json '\''a||c||~b'\'' '\''a,b'\'''
json 'a||c||~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''a||c||~b'\'' '\''a,b'\'''

echo '$ json '\''a||c||~c'\'' '\''a,b'\'''
json 'a||c||~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''a||c||~c'\'' '\''a,b'\'''

echo '$ json '\''a||~c||~a'\'' '\''a,b'\'''
json 'a||~c||~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''a||~c||~a'\'' '\''a,b'\'''

echo '$ json '\''a||~c||b'\'' '\''a,b'\'''
json 'a||~c||b' 'a,b' 2>&1 ||
echo 'command failed: json '\''a||~c||b'\'' '\''a,b'\'''

echo '$ json '\''a||~c||~b'\'' '\''a,b'\'''
json 'a||~c||~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''a||~c||~b'\'' '\''a,b'\'''

echo '$ json '\''a||~c||c'\'' '\''a,b'\'''
json 'a||~c||c' 'a,b' 2>&1 ||
echo 'command failed: json '\''a||~c||c'\'' '\''a,b'\'''

echo '$ json '\''~a||a||b'\'' '\''a,b'\'''
json '~a||a||b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a||a||b'\'' '\''a,b'\'''

echo '$ json '\''~a||a||~b'\'' '\''a,b'\'''
json '~a||a||~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a||a||~b'\'' '\''a,b'\'''

echo '$ json '\''~a||a||c'\'' '\''a,b'\'''
json '~a||a||c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a||a||c'\'' '\''a,b'\'''

echo '$ json '\''~a||a||~c'\'' '\''a,b'\'''
json '~a||a||~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a||a||~c'\'' '\''a,b'\'''

echo '$ json '\''~a||b||a'\'' '\''a,b'\'''
json '~a||b||a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a||b||a'\'' '\''a,b'\'''

echo '$ json '\''~a||b||~b'\'' '\''a,b'\'''
json '~a||b||~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a||b||~b'\'' '\''a,b'\'''

echo '$ json '\''~a||b||c'\'' '\''a,b'\'''
json '~a||b||c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a||b||c'\'' '\''a,b'\'''

echo '$ json '\''~a||b||~c'\'' '\''a,b'\'''
json '~a||b||~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a||b||~c'\'' '\''a,b'\'''

echo '$ json '\''~a||~b||a'\'' '\''a,b'\'''
json '~a||~b||a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a||~b||a'\'' '\''a,b'\'''

echo '$ json '\''~a||~b||b'\'' '\''a,b'\'''
json '~a||~b||b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a||~b||b'\'' '\''a,b'\'''

echo '$ json '\''~a||~b||c'\'' '\''a,b'\'''
json '~a||~b||c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a||~b||c'\'' '\''a,b'\'''

echo '$ json '\''~a||~b||~c'\'' '\''a,b'\'''
json '~a||~b||~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a||~b||~c'\'' '\''a,b'\'''

echo '$ json '\''~a||c||a'\'' '\''a,b'\'''
json '~a||c||a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a||c||a'\'' '\''a,b'\'''

echo '$ json '\''~a||c||b'\'' '\''a,b'\'''
json '~a||c||b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a||c||b'\'' '\''a,b'\'''

echo '$ json '\''~a||c||~b'\'' '\''a,b'\'''
json '~a||c||~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a||c||~b'\'' '\''a,b'\'''

echo '$ json '\''~a||c||~c'\'' '\''a,b'\'''
json '~a||c||~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a||c||~c'\'' '\''a,b'\'''

echo '$ json '\''~a||~c||a'\'' '\''a,b'\'''
json '~a||~c||a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a||~c||a'\'' '\''a,b'\'''

echo '$ json '\''~a||~c||b'\'' '\''a,b'\'''
json '~a||~c||b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a||~c||b'\'' '\''a,b'\'''

echo '$ json '\''~a||~c||~b'\'' '\''a,b'\'''
json '~a||~c||~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a||~c||~b'\'' '\''a,b'\'''

echo '$ json '\''~a||~c||c'\'' '\''a,b'\'''
json '~a||~c||c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a||~c||c'\'' '\''a,b'\'''

echo '$ json '\''b||a||~a'\'' '\''a,b'\'''
json 'b||a||~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''b||a||~a'\'' '\''a,b'\'''

echo '$ json '\''b||a||~b'\'' '\''a,b'\'''
json 'b||a||~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''b||a||~b'\'' '\''a,b'\'''

echo '$ json '\''b||a||c'\'' '\''a,b'\'''
json 'b||a||c' 'a,b' 2>&1 ||
echo 'command failed: json '\''b||a||c'\'' '\''a,b'\'''

echo '$ json '\''b||a||~c'\'' '\''a,b'\'''
json 'b||a||~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''b||a||~c'\'' '\''a,b'\'''

echo '$ json '\''b||~a||a'\'' '\''a,b'\'''
json 'b||~a||a' 'a,b' 2>&1 ||
echo 'command failed: json '\''b||~a||a'\'' '\''a,b'\'''

echo '$ json '\''b||~a||~b'\'' '\''a,b'\'''
json 'b||~a||~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''b||~a||~b'\'' '\''a,b'\'''

echo '$ json '\''b||~a||c'\'' '\''a,b'\'''
json 'b||~a||c' 'a,b' 2>&1 ||
echo 'command failed: json '\''b||~a||c'\'' '\''a,b'\'''

echo '$ json '\''b||~a||~c'\'' '\''a,b'\'''
json 'b||~a||~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''b||~a||~c'\'' '\''a,b'\'''

echo '$ json '\''b||~b||a'\'' '\''a,b'\'''
json 'b||~b||a' 'a,b' 2>&1 ||
echo 'command failed: json '\''b||~b||a'\'' '\''a,b'\'''

echo '$ json '\''b||~b||~a'\'' '\''a,b'\'''
json 'b||~b||~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''b||~b||~a'\'' '\''a,b'\'''

echo '$ json '\''b||~b||c'\'' '\''a,b'\'''
json 'b||~b||c' 'a,b' 2>&1 ||
echo 'command failed: json '\''b||~b||c'\'' '\''a,b'\'''

echo '$ json '\''b||~b||~c'\'' '\''a,b'\'''
json 'b||~b||~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''b||~b||~c'\'' '\''a,b'\'''

echo '$ json '\''b||c||a'\'' '\''a,b'\'''
json 'b||c||a' 'a,b' 2>&1 ||
echo 'command failed: json '\''b||c||a'\'' '\''a,b'\'''

echo '$ json '\''b||c||~a'\'' '\''a,b'\'''
json 'b||c||~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''b||c||~a'\'' '\''a,b'\'''

echo '$ json '\''b||c||~b'\'' '\''a,b'\'''
json 'b||c||~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''b||c||~b'\'' '\''a,b'\'''

echo '$ json '\''b||c||~c'\'' '\''a,b'\'''
json 'b||c||~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''b||c||~c'\'' '\''a,b'\'''

echo '$ json '\''b||~c||a'\'' '\''a,b'\'''
json 'b||~c||a' 'a,b' 2>&1 ||
echo 'command failed: json '\''b||~c||a'\'' '\''a,b'\'''

echo '$ json '\''b||~c||~a'\'' '\''a,b'\'''
json 'b||~c||~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''b||~c||~a'\'' '\''a,b'\'''

echo '$ json '\''b||~c||~b'\'' '\''a,b'\'''
json 'b||~c||~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''b||~c||~b'\'' '\''a,b'\'''

echo '$ json '\''b||~c||c'\'' '\''a,b'\'''
json 'b||~c||c' 'a,b' 2>&1 ||
echo 'command failed: json '\''b||~c||c'\'' '\''a,b'\'''

echo '$ json '\''~b||a||~a'\'' '\''a,b'\'''
json '~b||a||~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b||a||~a'\'' '\''a,b'\'''

echo '$ json '\''~b||a||b'\'' '\''a,b'\'''
json '~b||a||b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b||a||b'\'' '\''a,b'\'''

echo '$ json '\''~b||a||c'\'' '\''a,b'\'''
json '~b||a||c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b||a||c'\'' '\''a,b'\'''

echo '$ json '\''~b||a||~c'\'' '\''a,b'\'''
json '~b||a||~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b||a||~c'\'' '\''a,b'\'''

echo '$ json '\''~b||~a||a'\'' '\''a,b'\'''
json '~b||~a||a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b||~a||a'\'' '\''a,b'\'''

echo '$ json '\''~b||~a||b'\'' '\''a,b'\'''
json '~b||~a||b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b||~a||b'\'' '\''a,b'\'''

echo '$ json '\''~b||~a||c'\'' '\''a,b'\'''
json '~b||~a||c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b||~a||c'\'' '\''a,b'\'''

echo '$ json '\''~b||~a||~c'\'' '\''a,b'\'''
json '~b||~a||~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b||~a||~c'\'' '\''a,b'\'''

echo '$ json '\''~b||b||a'\'' '\''a,b'\'''
json '~b||b||a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b||b||a'\'' '\''a,b'\'''

echo '$ json '\''~b||b||~a'\'' '\''a,b'\'''
json '~b||b||~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b||b||~a'\'' '\''a,b'\'''

echo '$ json '\''~b||b||c'\'' '\''a,b'\'''
json '~b||b||c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b||b||c'\'' '\''a,b'\'''

echo '$ json '\''~b||b||~c'\'' '\''a,b'\'''
json '~b||b||~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b||b||~c'\'' '\''a,b'\'''

echo '$ json '\''~b||c||a'\'' '\''a,b'\'''
json '~b||c||a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b||c||a'\'' '\''a,b'\'''

echo '$ json '\''~b||c||~a'\'' '\''a,b'\'''
json '~b||c||~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b||c||~a'\'' '\''a,b'\'''

echo '$ json '\''~b||c||b'\'' '\''a,b'\'''
json '~b||c||b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b||c||b'\'' '\''a,b'\'''

echo '$ json '\''~b||c||~c'\'' '\''a,b'\'''
json '~b||c||~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b||c||~c'\'' '\''a,b'\'''

echo '$ json '\''~b||~c||a'\'' '\''a,b'\'''
json '~b||~c||a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b||~c||a'\'' '\''a,b'\'''

echo '$ json '\''~b||~c||~a'\'' '\''a,b'\'''
json '~b||~c||~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b||~c||~a'\'' '\''a,b'\'''

echo '$ json '\''~b||~c||b'\'' '\''a,b'\'''
json '~b||~c||b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b||~c||b'\'' '\''a,b'\'''

echo '$ json '\''~b||~c||c'\'' '\''a,b'\'''
json '~b||~c||c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b||~c||c'\'' '\''a,b'\'''

echo '$ json '\''c||a||~a'\'' '\''a,b'\'''
json 'c||a||~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''c||a||~a'\'' '\''a,b'\'''

echo '$ json '\''c||a||b'\'' '\''a,b'\'''
json 'c||a||b' 'a,b' 2>&1 ||
echo 'command failed: json '\''c||a||b'\'' '\''a,b'\'''

echo '$ json '\''c||a||~b'\'' '\''a,b'\'''
json 'c||a||~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''c||a||~b'\'' '\''a,b'\'''

echo '$ json '\''c||a||~c'\'' '\''a,b'\'''
json 'c||a||~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''c||a||~c'\'' '\''a,b'\'''

echo '$ json '\''c||~a||a'\'' '\''a,b'\'''
json 'c||~a||a' 'a,b' 2>&1 ||
echo 'command failed: json '\''c||~a||a'\'' '\''a,b'\'''

echo '$ json '\''c||~a||b'\'' '\''a,b'\'''
json 'c||~a||b' 'a,b' 2>&1 ||
echo 'command failed: json '\''c||~a||b'\'' '\''a,b'\'''

echo '$ json '\''c||~a||~b'\'' '\''a,b'\'''
json 'c||~a||~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''c||~a||~b'\'' '\''a,b'\'''

echo '$ json '\''c||~a||~c'\'' '\''a,b'\'''
json 'c||~a||~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''c||~a||~c'\'' '\''a,b'\'''

echo '$ json '\''c||b||a'\'' '\''a,b'\'''
json 'c||b||a' 'a,b' 2>&1 ||
echo 'command failed: json '\''c||b||a'\'' '\''a,b'\'''

echo '$ json '\''c||b||~a'\'' '\''a,b'\'''
json 'c||b||~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''c||b||~a'\'' '\''a,b'\'''

echo '$ json '\''c||b||~b'\'' '\''a,b'\'''
json 'c||b||~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''c||b||~b'\'' '\''a,b'\'''

echo '$ json '\''c||b||~c'\'' '\''a,b'\'''
json 'c||b||~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''c||b||~c'\'' '\''a,b'\'''

echo '$ json '\''c||~b||a'\'' '\''a,b'\'''
json 'c||~b||a' 'a,b' 2>&1 ||
echo 'command failed: json '\''c||~b||a'\'' '\''a,b'\'''

echo '$ json '\''c||~b||~a'\'' '\''a,b'\'''
json 'c||~b||~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''c||~b||~a'\'' '\''a,b'\'''

echo '$ json '\''c||~b||b'\'' '\''a,b'\'''
json 'c||~b||b' 'a,b' 2>&1 ||
echo 'command failed: json '\''c||~b||b'\'' '\''a,b'\'''

echo '$ json '\''c||~b||~c'\'' '\''a,b'\'''
json 'c||~b||~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''c||~b||~c'\'' '\''a,b'\'''

echo '$ json '\''c||~c||a'\'' '\''a,b'\'''
json 'c||~c||a' 'a,b' 2>&1 ||
echo 'command failed: json '\''c||~c||a'\'' '\''a,b'\'''

echo '$ json '\''c||~c||~a'\'' '\''a,b'\'''
json 'c||~c||~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''c||~c||~a'\'' '\''a,b'\'''

echo '$ json '\''c||~c||b'\'' '\''a,b'\'''
json 'c||~c||b' 'a,b' 2>&1 ||
echo 'command failed: json '\''c||~c||b'\'' '\''a,b'\'''

echo '$ json '\''c||~c||~b'\'' '\''a,b'\'''
json 'c||~c||~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''c||~c||~b'\'' '\''a,b'\'''

echo '$ json '\''~c||a||~a'\'' '\''a,b'\'''
json '~c||a||~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c||a||~a'\'' '\''a,b'\'''

echo '$ json '\''~c||a||b'\'' '\''a,b'\'''
json '~c||a||b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c||a||b'\'' '\''a,b'\'''

echo '$ json '\''~c||a||~b'\'' '\''a,b'\'''
json '~c||a||~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c||a||~b'\'' '\''a,b'\'''

echo '$ json '\''~c||a||c'\'' '\''a,b'\'''
json '~c||a||c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c||a||c'\'' '\''a,b'\'''

echo '$ json '\''~c||~a||a'\'' '\''a,b'\'''
json '~c||~a||a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c||~a||a'\'' '\''a,b'\'''

echo '$ json '\''~c||~a||b'\'' '\''a,b'\'''
json '~c||~a||b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c||~a||b'\'' '\''a,b'\'''

echo '$ json '\''~c||~a||~b'\'' '\''a,b'\'''
json '~c||~a||~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c||~a||~b'\'' '\''a,b'\'''

echo '$ json '\''~c||~a||c'\'' '\''a,b'\'''
json '~c||~a||c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c||~a||c'\'' '\''a,b'\'''

echo '$ json '\''~c||b||a'\'' '\''a,b'\'''
json '~c||b||a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c||b||a'\'' '\''a,b'\'''

echo '$ json '\''~c||b||~a'\'' '\''a,b'\'''
json '~c||b||~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c||b||~a'\'' '\''a,b'\'''

echo '$ json '\''~c||b||~b'\'' '\''a,b'\'''
json '~c||b||~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c||b||~b'\'' '\''a,b'\'''

echo '$ json '\''~c||b||c'\'' '\''a,b'\'''
json '~c||b||c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c||b||c'\'' '\''a,b'\'''

echo '$ json '\''~c||~b||a'\'' '\''a,b'\'''
json '~c||~b||a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c||~b||a'\'' '\''a,b'\'''

echo '$ json '\''~c||~b||~a'\'' '\''a,b'\'''
json '~c||~b||~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c||~b||~a'\'' '\''a,b'\'''

echo '$ json '\''~c||~b||b'\'' '\''a,b'\'''
json '~c||~b||b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c||~b||b'\'' '\''a,b'\'''

echo '$ json '\''~c||~b||c'\'' '\''a,b'\'''
json '~c||~b||c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c||~b||c'\'' '\''a,b'\'''

echo '$ json '\''~c||c||a'\'' '\''a,b'\'''
json '~c||c||a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c||c||a'\'' '\''a,b'\'''

echo '$ json '\''~c||c||~a'\'' '\''a,b'\'''
json '~c||c||~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c||c||~a'\'' '\''a,b'\'''

echo '$ json '\''~c||c||b'\'' '\''a,b'\'''
json '~c||c||b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c||c||b'\'' '\''a,b'\'''

echo '$ json '\''~c||c||~b'\'' '\''a,b'\'''
json '~c||c||~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c||c||~b'\'' '\''a,b'\'''
)

