#!/bin/bash

# Copyright (C) 2016, 2017, 2018  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-checker-list:list-object-basic-plain-val-object-basic-basic3
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L list-object-basic-plain-val-object-basic-basic3.old <(echo \
'$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes
$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[{}],"baa":null}'\''
{"faa":[{}],"baa":null}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[{}],"baa":false}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:19: {"faa":[{}],"baa":false}
json: error: <stdin>:1:19:                   ^
{"faa":[{}],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[{}],"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[{}],"baa":true}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:19: {"faa":[{}],"baa":true}
json: error: <stdin>:1:19:                   ^
{"faa":[{}],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[{}],"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[{}],"baa":123}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:19: {"faa":[{}],"baa":123}
json: error: <stdin>:1:19:                   ^
{"faa":[{}],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[{}],"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[{}],"baa":456}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:19: {"faa":[{}],"baa":456}
json: error: <stdin>:1:19:                   ^
{"faa":[{}],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[{}],"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[{}],"baa":"foo"}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:19: {"faa":[{}],"baa":"foo"}
json: error: <stdin>:1:19:                   ^
{"faa":[{}],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[{}],"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[{}],"baa":"bar"}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:19: {"faa":[{}],"baa":"bar"}
json: error: <stdin>:1:19:                   ^
{"faa":[{}],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[{}],"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[{}],"baa":{}}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:19: {"faa":[{}],"baa":{}}
json: error: <stdin>:1:19:                   ^
{"faa":[{}],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[{}],"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[{}],"baa":[]}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:19: {"faa":[{}],"baa":[]}
json: error: <stdin>:1:19:                   ^
{"faa":[{}],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[{}],"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[{}],"baa":null}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:19: {"faa":[{}],"baa":null}
json: error: <stdin>:1:19:                   ^
{"faa":[{}],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[{}],"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[{}],"baa":false}'\''
{"faa":[{}],"baa":false}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[{}],"baa":true}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:19: {"faa":[{}],"baa":true}
json: error: <stdin>:1:19:                   ^
{"faa":[{}],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[{}],"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[{}],"baa":123}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:19: {"faa":[{}],"baa":123}
json: error: <stdin>:1:19:                   ^
{"faa":[{}],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[{}],"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[{}],"baa":456}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:19: {"faa":[{}],"baa":456}
json: error: <stdin>:1:19:                   ^
{"faa":[{}],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[{}],"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[{}],"baa":"foo"}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:19: {"faa":[{}],"baa":"foo"}
json: error: <stdin>:1:19:                   ^
{"faa":[{}],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[{}],"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[{}],"baa":"bar"}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:19: {"faa":[{}],"baa":"bar"}
json: error: <stdin>:1:19:                   ^
{"faa":[{}],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[{}],"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[{}],"baa":{}}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:19: {"faa":[{}],"baa":{}}
json: error: <stdin>:1:19:                   ^
{"faa":[{}],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[{}],"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[{}],"baa":[]}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:19: {"faa":[{}],"baa":[]}
json: error: <stdin>:1:19:                   ^
{"faa":[{}],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[{}],"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[{}],"baa":null}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:19: {"faa":[{}],"baa":null}
json: error: <stdin>:1:19:                   ^
{"faa":[{}],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[{}],"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[{}],"baa":false}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:19: {"faa":[{}],"baa":false}
json: error: <stdin>:1:19:                   ^
{"faa":[{}],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[{}],"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[{}],"baa":true}'\''
{"faa":[{}],"baa":true}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[{}],"baa":123}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:19: {"faa":[{}],"baa":123}
json: error: <stdin>:1:19:                   ^
{"faa":[{}],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[{}],"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[{}],"baa":456}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:19: {"faa":[{}],"baa":456}
json: error: <stdin>:1:19:                   ^
{"faa":[{}],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[{}],"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[{}],"baa":"foo"}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:19: {"faa":[{}],"baa":"foo"}
json: error: <stdin>:1:19:                   ^
{"faa":[{}],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[{}],"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[{}],"baa":"bar"}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:19: {"faa":[{}],"baa":"bar"}
json: error: <stdin>:1:19:                   ^
{"faa":[{}],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[{}],"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[{}],"baa":{}}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:19: {"faa":[{}],"baa":{}}
json: error: <stdin>:1:19:                   ^
{"faa":[{}],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[{}],"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[{}],"baa":[]}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:19: {"faa":[{}],"baa":[]}
json: error: <stdin>:1:19:                   ^
{"faa":[{}],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[{}],"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[{}],"baa":null}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:19: {"faa":[{}],"baa":null}
json: error: <stdin>:1:19:                   ^
{"faa":[{}],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[{}],"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[{}],"baa":false}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:19: {"faa":[{}],"baa":false}
json: error: <stdin>:1:19:                   ^
{"faa":[{}],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[{}],"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[{}],"baa":true}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:19: {"faa":[{}],"baa":true}
json: error: <stdin>:1:19:                   ^
{"faa":[{}],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[{}],"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[{}],"baa":123}'\''
{"faa":[{}],"baa":123}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[{}],"baa":456}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:19: {"faa":[{}],"baa":456}
json: error: <stdin>:1:19:                   ^
{"faa":[{}],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[{}],"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[{}],"baa":"foo"}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:19: {"faa":[{}],"baa":"foo"}
json: error: <stdin>:1:19:                   ^
{"faa":[{}],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[{}],"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[{}],"baa":"bar"}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:19: {"faa":[{}],"baa":"bar"}
json: error: <stdin>:1:19:                   ^
{"faa":[{}],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[{}],"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[{}],"baa":{}}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:19: {"faa":[{}],"baa":{}}
json: error: <stdin>:1:19:                   ^
{"faa":[{}],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[{}],"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[{}],"baa":[]}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:19: {"faa":[{}],"baa":[]}
json: error: <stdin>:1:19:                   ^
{"faa":[{}],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[{}],"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[{}],"baa":null}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:19: {"faa":[{}],"baa":null}
json: error: <stdin>:1:19:                   ^
{"faa":[{}],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[{}],"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[{}],"baa":false}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:19: {"faa":[{}],"baa":false}
json: error: <stdin>:1:19:                   ^
{"faa":[{}],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[{}],"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[{}],"baa":true}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:19: {"faa":[{}],"baa":true}
json: error: <stdin>:1:19:                   ^
{"faa":[{}],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[{}],"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[{}],"baa":123}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:19: {"faa":[{}],"baa":123}
json: error: <stdin>:1:19:                   ^
{"faa":[{}],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[{}],"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[{}],"baa":456}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:19: {"faa":[{}],"baa":456}
json: error: <stdin>:1:19:                   ^
{"faa":[{}],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[{}],"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[{}],"baa":"foo"}'\''
{"faa":[{}],"baa":"foo"}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[{}],"baa":"bar"}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:19: {"faa":[{}],"baa":"bar"}
json: error: <stdin>:1:19:                   ^
{"faa":[{}],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[{}],"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[{}],"baa":{}}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:19: {"faa":[{}],"baa":{}}
json: error: <stdin>:1:19:                   ^
{"faa":[{}],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[{}],"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[{}],"baa":[]}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:19: {"faa":[{}],"baa":[]}
json: error: <stdin>:1:19:                   ^
{"faa":[{}],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[{}],"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\''
{"faa":null,"baa":null}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:19: {"faa":null,"baa":false}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:19: {"faa":null,"baa":true}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:19: {"faa":null,"baa":123}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":456}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:19: {"faa":null,"baa":456}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:19: {"faa":null,"baa":"foo"}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":"bar"}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:19: {"faa":null,"baa":"bar"}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:19: {"faa":null,"baa":{}}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:19: {"faa":null,"baa":[]}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:19: {"faa":null,"baa":null}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\''
{"faa":null,"baa":false}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:19: {"faa":null,"baa":true}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:19: {"faa":null,"baa":123}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null,"baa":456}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:19: {"faa":null,"baa":456}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:19: {"faa":null,"baa":"foo"}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null,"baa":"bar"}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:19: {"faa":null,"baa":"bar"}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:19: {"faa":null,"baa":{}}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:19: {"faa":null,"baa":[]}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:19: {"faa":null,"baa":null}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:19: {"faa":null,"baa":false}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\''
{"faa":null,"baa":true}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:19: {"faa":null,"baa":123}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null,"baa":456}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:19: {"faa":null,"baa":456}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:19: {"faa":null,"baa":"foo"}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null,"baa":"bar"}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:19: {"faa":null,"baa":"bar"}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:19: {"faa":null,"baa":{}}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:19: {"faa":null,"baa":[]}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:19: {"faa":null,"baa":null}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:19: {"faa":null,"baa":false}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:19: {"faa":null,"baa":true}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\''
{"faa":null,"baa":123}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null,"baa":456}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:19: {"faa":null,"baa":456}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:19: {"faa":null,"baa":"foo"}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null,"baa":"bar"}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:19: {"faa":null,"baa":"bar"}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:19: {"faa":null,"baa":{}}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:19: {"faa":null,"baa":[]}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:19: {"faa":null,"baa":null}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:19: {"faa":null,"baa":false}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:19: {"faa":null,"baa":true}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:19: {"faa":null,"baa":123}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null,"baa":456}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:19: {"faa":null,"baa":456}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\''
{"faa":null,"baa":"foo"}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null,"baa":"bar"}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:19: {"faa":null,"baa":"bar"}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:19: {"faa":null,"baa":{}}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:19: {"faa":null,"baa":[]}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\''
{"faa":false,"baa":null}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:20: {"faa":false,"baa":false}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:20: {"faa":false,"baa":true}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:20: {"faa":false,"baa":123}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false,"baa":456}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:20: {"faa":false,"baa":456}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:20: {"faa":false,"baa":"foo"}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false,"baa":"bar"}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:20: {"faa":false,"baa":"bar"}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:20: {"faa":false,"baa":{}}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:20: {"faa":false,"baa":[]}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:20: {"faa":false,"baa":null}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\''
{"faa":false,"baa":false}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:20: {"faa":false,"baa":true}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:20: {"faa":false,"baa":123}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":456}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:20: {"faa":false,"baa":456}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:20: {"faa":false,"baa":"foo"}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":"bar"}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:20: {"faa":false,"baa":"bar"}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:20: {"faa":false,"baa":{}}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:20: {"faa":false,"baa":[]}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:20: {"faa":false,"baa":null}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:20: {"faa":false,"baa":false}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\''
{"faa":false,"baa":true}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:20: {"faa":false,"baa":123}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false,"baa":456}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:20: {"faa":false,"baa":456}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:20: {"faa":false,"baa":"foo"}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false,"baa":"bar"}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:20: {"faa":false,"baa":"bar"}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:20: {"faa":false,"baa":{}}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:20: {"faa":false,"baa":[]}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:20: {"faa":false,"baa":null}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:20: {"faa":false,"baa":false}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:20: {"faa":false,"baa":true}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\''
{"faa":false,"baa":123}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false,"baa":456}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:20: {"faa":false,"baa":456}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:20: {"faa":false,"baa":"foo"}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false,"baa":"bar"}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:20: {"faa":false,"baa":"bar"}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:20: {"faa":false,"baa":{}}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:20: {"faa":false,"baa":[]}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:20: {"faa":false,"baa":null}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:20: {"faa":false,"baa":false}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:20: {"faa":false,"baa":true}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:20: {"faa":false,"baa":123}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false,"baa":456}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:20: {"faa":false,"baa":456}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\''
{"faa":false,"baa":"foo"}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false,"baa":"bar"}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:20: {"faa":false,"baa":"bar"}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:20: {"faa":false,"baa":{}}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:20: {"faa":false,"baa":[]}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456,"baa":null}'\''
{"faa":456,"baa":null}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456,"baa":false}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:18: {"faa":456,"baa":false}
json: error: <stdin>:1:18:                  ^
{"faa":456,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456,"baa":true}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:18: {"faa":456,"baa":true}
json: error: <stdin>:1:18:                  ^
{"faa":456,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456,"baa":123}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:18: {"faa":456,"baa":123}
json: error: <stdin>:1:18:                  ^
{"faa":456,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456,"baa":456}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:18: {"faa":456,"baa":456}
json: error: <stdin>:1:18:                  ^
{"faa":456,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456,"baa":"foo"}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:18: {"faa":456,"baa":"foo"}
json: error: <stdin>:1:18:                  ^
{"faa":456,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456,"baa":"bar"}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:18: {"faa":456,"baa":"bar"}
json: error: <stdin>:1:18:                  ^
{"faa":456,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456,"baa":{}}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:18: {"faa":456,"baa":{}}
json: error: <stdin>:1:18:                  ^
{"faa":456,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456,"baa":[]}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:18: {"faa":456,"baa":[]}
json: error: <stdin>:1:18:                  ^
{"faa":456,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456,"baa":null}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:18: {"faa":456,"baa":null}
json: error: <stdin>:1:18:                  ^
{"faa":456,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456,"baa":false}'\''
{"faa":456,"baa":false}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456,"baa":true}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:18: {"faa":456,"baa":true}
json: error: <stdin>:1:18:                  ^
{"faa":456,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456,"baa":123}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:18: {"faa":456,"baa":123}
json: error: <stdin>:1:18:                  ^
{"faa":456,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456,"baa":456}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:18: {"faa":456,"baa":456}
json: error: <stdin>:1:18:                  ^
{"faa":456,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456,"baa":"foo"}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:18: {"faa":456,"baa":"foo"}
json: error: <stdin>:1:18:                  ^
{"faa":456,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456,"baa":"bar"}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:18: {"faa":456,"baa":"bar"}
json: error: <stdin>:1:18:                  ^
{"faa":456,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456,"baa":{}}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:18: {"faa":456,"baa":{}}
json: error: <stdin>:1:18:                  ^
{"faa":456,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456,"baa":[]}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:18: {"faa":456,"baa":[]}
json: error: <stdin>:1:18:                  ^
{"faa":456,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456,"baa":null}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:18: {"faa":456,"baa":null}
json: error: <stdin>:1:18:                  ^
{"faa":456,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456,"baa":false}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:18: {"faa":456,"baa":false}
json: error: <stdin>:1:18:                  ^
{"faa":456,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456,"baa":true}'\''
{"faa":456,"baa":true}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456,"baa":123}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:18: {"faa":456,"baa":123}
json: error: <stdin>:1:18:                  ^
{"faa":456,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456,"baa":456}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:18: {"faa":456,"baa":456}
json: error: <stdin>:1:18:                  ^
{"faa":456,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456,"baa":"foo"}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:18: {"faa":456,"baa":"foo"}
json: error: <stdin>:1:18:                  ^
{"faa":456,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456,"baa":"bar"}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:18: {"faa":456,"baa":"bar"}
json: error: <stdin>:1:18:                  ^
{"faa":456,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456,"baa":{}}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:18: {"faa":456,"baa":{}}
json: error: <stdin>:1:18:                  ^
{"faa":456,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456,"baa":[]}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:18: {"faa":456,"baa":[]}
json: error: <stdin>:1:18:                  ^
{"faa":456,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456,"baa":null}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:18: {"faa":456,"baa":null}
json: error: <stdin>:1:18:                  ^
{"faa":456,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456,"baa":false}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:18: {"faa":456,"baa":false}
json: error: <stdin>:1:18:                  ^
{"faa":456,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456,"baa":true}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:18: {"faa":456,"baa":true}
json: error: <stdin>:1:18:                  ^
{"faa":456,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456,"baa":123}'\''
{"faa":456,"baa":123}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456,"baa":456}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:18: {"faa":456,"baa":456}
json: error: <stdin>:1:18:                  ^
{"faa":456,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456,"baa":"foo"}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:18: {"faa":456,"baa":"foo"}
json: error: <stdin>:1:18:                  ^
{"faa":456,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456,"baa":"bar"}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:18: {"faa":456,"baa":"bar"}
json: error: <stdin>:1:18:                  ^
{"faa":456,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456,"baa":{}}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:18: {"faa":456,"baa":{}}
json: error: <stdin>:1:18:                  ^
{"faa":456,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456,"baa":[]}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:18: {"faa":456,"baa":[]}
json: error: <stdin>:1:18:                  ^
{"faa":456,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456,"baa":null}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:18: {"faa":456,"baa":null}
json: error: <stdin>:1:18:                  ^
{"faa":456,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456,"baa":false}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:18: {"faa":456,"baa":false}
json: error: <stdin>:1:18:                  ^
{"faa":456,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456,"baa":true}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:18: {"faa":456,"baa":true}
json: error: <stdin>:1:18:                  ^
{"faa":456,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456,"baa":123}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:18: {"faa":456,"baa":123}
json: error: <stdin>:1:18:                  ^
{"faa":456,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456,"baa":456}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:18: {"faa":456,"baa":456}
json: error: <stdin>:1:18:                  ^
{"faa":456,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456,"baa":"foo"}'\''
{"faa":456,"baa":"foo"}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456,"baa":"bar"}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:18: {"faa":456,"baa":"bar"}
json: error: <stdin>:1:18:                  ^
{"faa":456,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456,"baa":{}}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:18: {"faa":456,"baa":{}}
json: error: <stdin>:1:18:                  ^
{"faa":456,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456,"baa":[]}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:18: {"faa":456,"baa":[]}
json: error: <stdin>:1:18:                  ^
{"faa":456,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar","baa":null}'\''
{"faa":"bar","baa":null}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar","baa":false}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:20: {"faa":"bar","baa":false}
json: error: <stdin>:1:20:                    ^
{"faa":"bar","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar","baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar","baa":true}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:20: {"faa":"bar","baa":true}
json: error: <stdin>:1:20:                    ^
{"faa":"bar","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar","baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar","baa":123}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:20: {"faa":"bar","baa":123}
json: error: <stdin>:1:20:                    ^
{"faa":"bar","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar","baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar","baa":456}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:20: {"faa":"bar","baa":456}
json: error: <stdin>:1:20:                    ^
{"faa":"bar","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar","baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar","baa":"foo"}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:20: {"faa":"bar","baa":"foo"}
json: error: <stdin>:1:20:                    ^
{"faa":"bar","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar","baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar","baa":"bar"}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:20: {"faa":"bar","baa":"bar"}
json: error: <stdin>:1:20:                    ^
{"faa":"bar","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar","baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar","baa":{}}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:20: {"faa":"bar","baa":{}}
json: error: <stdin>:1:20:                    ^
{"faa":"bar","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar","baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar","baa":[]}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:20: {"faa":"bar","baa":[]}
json: error: <stdin>:1:20:                    ^
{"faa":"bar","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar","baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar","baa":null}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:20: {"faa":"bar","baa":null}
json: error: <stdin>:1:20:                    ^
{"faa":"bar","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar","baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar","baa":false}'\''
{"faa":"bar","baa":false}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar","baa":true}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:20: {"faa":"bar","baa":true}
json: error: <stdin>:1:20:                    ^
{"faa":"bar","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar","baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar","baa":123}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:20: {"faa":"bar","baa":123}
json: error: <stdin>:1:20:                    ^
{"faa":"bar","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar","baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar","baa":456}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:20: {"faa":"bar","baa":456}
json: error: <stdin>:1:20:                    ^
{"faa":"bar","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar","baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar","baa":"foo"}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:20: {"faa":"bar","baa":"foo"}
json: error: <stdin>:1:20:                    ^
{"faa":"bar","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar","baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar","baa":"bar"}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:20: {"faa":"bar","baa":"bar"}
json: error: <stdin>:1:20:                    ^
{"faa":"bar","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar","baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar","baa":{}}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:20: {"faa":"bar","baa":{}}
json: error: <stdin>:1:20:                    ^
{"faa":"bar","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar","baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar","baa":[]}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:20: {"faa":"bar","baa":[]}
json: error: <stdin>:1:20:                    ^
{"faa":"bar","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar","baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar","baa":null}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:20: {"faa":"bar","baa":null}
json: error: <stdin>:1:20:                    ^
{"faa":"bar","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar","baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar","baa":false}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:20: {"faa":"bar","baa":false}
json: error: <stdin>:1:20:                    ^
{"faa":"bar","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar","baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar","baa":true}'\''
{"faa":"bar","baa":true}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar","baa":123}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:20: {"faa":"bar","baa":123}
json: error: <stdin>:1:20:                    ^
{"faa":"bar","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar","baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar","baa":456}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:20: {"faa":"bar","baa":456}
json: error: <stdin>:1:20:                    ^
{"faa":"bar","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar","baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar","baa":"foo"}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:20: {"faa":"bar","baa":"foo"}
json: error: <stdin>:1:20:                    ^
{"faa":"bar","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar","baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar","baa":"bar"}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:20: {"faa":"bar","baa":"bar"}
json: error: <stdin>:1:20:                    ^
{"faa":"bar","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar","baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar","baa":{}}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:20: {"faa":"bar","baa":{}}
json: error: <stdin>:1:20:                    ^
{"faa":"bar","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar","baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar","baa":[]}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:20: {"faa":"bar","baa":[]}
json: error: <stdin>:1:20:                    ^
{"faa":"bar","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar","baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar","baa":null}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:20: {"faa":"bar","baa":null}
json: error: <stdin>:1:20:                    ^
{"faa":"bar","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar","baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar","baa":false}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:20: {"faa":"bar","baa":false}
json: error: <stdin>:1:20:                    ^
{"faa":"bar","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar","baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar","baa":true}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:20: {"faa":"bar","baa":true}
json: error: <stdin>:1:20:                    ^
{"faa":"bar","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar","baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar","baa":123}'\''
{"faa":"bar","baa":123}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar","baa":456}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:20: {"faa":"bar","baa":456}
json: error: <stdin>:1:20:                    ^
{"faa":"bar","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar","baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar","baa":"foo"}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:20: {"faa":"bar","baa":"foo"}
json: error: <stdin>:1:20:                    ^
{"faa":"bar","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar","baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar","baa":"bar"}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:20: {"faa":"bar","baa":"bar"}
json: error: <stdin>:1:20:                    ^
{"faa":"bar","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar","baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar","baa":{}}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:20: {"faa":"bar","baa":{}}
json: error: <stdin>:1:20:                    ^
{"faa":"bar","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar","baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar","baa":[]}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:20: {"faa":"bar","baa":[]}
json: error: <stdin>:1:20:                    ^
{"faa":"bar","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar","baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar","baa":null}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:20: {"faa":"bar","baa":null}
json: error: <stdin>:1:20:                    ^
{"faa":"bar","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar","baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar","baa":false}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:20: {"faa":"bar","baa":false}
json: error: <stdin>:1:20:                    ^
{"faa":"bar","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar","baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar","baa":true}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:20: {"faa":"bar","baa":true}
json: error: <stdin>:1:20:                    ^
{"faa":"bar","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar","baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar","baa":123}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:20: {"faa":"bar","baa":123}
json: error: <stdin>:1:20:                    ^
{"faa":"bar","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar","baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar","baa":456}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:20: {"faa":"bar","baa":456}
json: error: <stdin>:1:20:                    ^
{"faa":"bar","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar","baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar","baa":"foo"}'\''
{"faa":"bar","baa":"foo"}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar","baa":"bar"}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:20: {"faa":"bar","baa":"bar"}
json: error: <stdin>:1:20:                    ^
{"faa":"bar","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar","baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar","baa":{}}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:20: {"faa":"bar","baa":{}}
json: error: <stdin>:1:20:                    ^
{"faa":"bar","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar","baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar","baa":[]}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:20: {"faa":"bar","baa":[]}
json: error: <stdin>:1:20:                    ^
{"faa":"bar","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar","baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{},"baa":null}'\''
{"faa":{},"baa":null}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{},"baa":false}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:17: {"faa":{},"baa":false}
json: error: <stdin>:1:17:                 ^
{"faa":{},"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{},"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{},"baa":true}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:17: {"faa":{},"baa":true}
json: error: <stdin>:1:17:                 ^
{"faa":{},"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{},"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{},"baa":123}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:17: {"faa":{},"baa":123}
json: error: <stdin>:1:17:                 ^
{"faa":{},"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{},"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{},"baa":456}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:17: {"faa":{},"baa":456}
json: error: <stdin>:1:17:                 ^
{"faa":{},"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{},"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{},"baa":"foo"}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:17: {"faa":{},"baa":"foo"}
json: error: <stdin>:1:17:                 ^
{"faa":{},"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{},"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{},"baa":"bar"}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:17: {"faa":{},"baa":"bar"}
json: error: <stdin>:1:17:                 ^
{"faa":{},"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{},"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{},"baa":{}}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:17: {"faa":{},"baa":{}}
json: error: <stdin>:1:17:                 ^
{"faa":{},"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{},"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{},"baa":[]}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:17: {"faa":{},"baa":[]}
json: error: <stdin>:1:17:                 ^
{"faa":{},"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{},"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{},"baa":null}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:17: {"faa":{},"baa":null}
json: error: <stdin>:1:17:                 ^
{"faa":{},"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{},"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{},"baa":false}'\''
{"faa":{},"baa":false}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{},"baa":true}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:17: {"faa":{},"baa":true}
json: error: <stdin>:1:17:                 ^
{"faa":{},"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{},"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{},"baa":123}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:17: {"faa":{},"baa":123}
json: error: <stdin>:1:17:                 ^
{"faa":{},"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{},"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{},"baa":456}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:17: {"faa":{},"baa":456}
json: error: <stdin>:1:17:                 ^
{"faa":{},"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{},"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{},"baa":"foo"}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:17: {"faa":{},"baa":"foo"}
json: error: <stdin>:1:17:                 ^
{"faa":{},"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{},"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{},"baa":"bar"}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:17: {"faa":{},"baa":"bar"}
json: error: <stdin>:1:17:                 ^
{"faa":{},"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{},"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{},"baa":{}}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:17: {"faa":{},"baa":{}}
json: error: <stdin>:1:17:                 ^
{"faa":{},"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{},"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{},"baa":[]}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:17: {"faa":{},"baa":[]}
json: error: <stdin>:1:17:                 ^
{"faa":{},"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{},"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{},"baa":null}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:17: {"faa":{},"baa":null}
json: error: <stdin>:1:17:                 ^
{"faa":{},"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{},"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{},"baa":false}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:17: {"faa":{},"baa":false}
json: error: <stdin>:1:17:                 ^
{"faa":{},"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{},"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{},"baa":true}'\''
{"faa":{},"baa":true}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{},"baa":123}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:17: {"faa":{},"baa":123}
json: error: <stdin>:1:17:                 ^
{"faa":{},"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{},"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{},"baa":456}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:17: {"faa":{},"baa":456}
json: error: <stdin>:1:17:                 ^
{"faa":{},"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{},"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{},"baa":"foo"}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:17: {"faa":{},"baa":"foo"}
json: error: <stdin>:1:17:                 ^
{"faa":{},"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{},"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{},"baa":"bar"}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:17: {"faa":{},"baa":"bar"}
json: error: <stdin>:1:17:                 ^
{"faa":{},"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{},"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{},"baa":{}}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:17: {"faa":{},"baa":{}}
json: error: <stdin>:1:17:                 ^
{"faa":{},"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{},"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{},"baa":[]}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:17: {"faa":{},"baa":[]}
json: error: <stdin>:1:17:                 ^
{"faa":{},"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{},"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{},"baa":null}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:17: {"faa":{},"baa":null}
json: error: <stdin>:1:17:                 ^
{"faa":{},"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{},"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{},"baa":false}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:17: {"faa":{},"baa":false}
json: error: <stdin>:1:17:                 ^
{"faa":{},"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{},"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{},"baa":true}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:17: {"faa":{},"baa":true}
json: error: <stdin>:1:17:                 ^
{"faa":{},"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{},"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{},"baa":123}'\''
{"faa":{},"baa":123}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{},"baa":456}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:17: {"faa":{},"baa":456}
json: error: <stdin>:1:17:                 ^
{"faa":{},"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{},"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{},"baa":"foo"}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:17: {"faa":{},"baa":"foo"}
json: error: <stdin>:1:17:                 ^
{"faa":{},"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{},"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{},"baa":"bar"}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:17: {"faa":{},"baa":"bar"}
json: error: <stdin>:1:17:                 ^
{"faa":{},"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{},"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{},"baa":{}}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:17: {"faa":{},"baa":{}}
json: error: <stdin>:1:17:                 ^
{"faa":{},"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{},"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{},"baa":[]}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:17: {"faa":{},"baa":[]}
json: error: <stdin>:1:17:                 ^
{"faa":{},"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{},"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{},"baa":null}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:17: {"faa":{},"baa":null}
json: error: <stdin>:1:17:                 ^
{"faa":{},"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{},"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{},"baa":false}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:17: {"faa":{},"baa":false}
json: error: <stdin>:1:17:                 ^
{"faa":{},"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{},"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{},"baa":true}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:17: {"faa":{},"baa":true}
json: error: <stdin>:1:17:                 ^
{"faa":{},"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{},"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{},"baa":123}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:17: {"faa":{},"baa":123}
json: error: <stdin>:1:17:                 ^
{"faa":{},"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{},"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{},"baa":456}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:17: {"faa":{},"baa":456}
json: error: <stdin>:1:17:                 ^
{"faa":{},"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{},"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{},"baa":"foo"}'\''
{"faa":{},"baa":"foo"}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{},"baa":"bar"}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:17: {"faa":{},"baa":"bar"}
json: error: <stdin>:1:17:                 ^
{"faa":{},"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{},"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{},"baa":{}}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:17: {"faa":{},"baa":{}}
json: error: <stdin>:1:17:                 ^
{"faa":{},"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{},"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{},"baa":[]}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:17: {"faa":{},"baa":[]}
json: error: <stdin>:1:17:                 ^
{"faa":{},"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{},"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[],"baa":null}'\''
{"faa":[],"baa":null}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[],"baa":false}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:17: {"faa":[],"baa":false}
json: error: <stdin>:1:17:                 ^
{"faa":[],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[],"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[],"baa":true}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:17: {"faa":[],"baa":true}
json: error: <stdin>:1:17:                 ^
{"faa":[],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[],"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[],"baa":123}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:17: {"faa":[],"baa":123}
json: error: <stdin>:1:17:                 ^
{"faa":[],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[],"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[],"baa":456}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:17: {"faa":[],"baa":456}
json: error: <stdin>:1:17:                 ^
{"faa":[],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[],"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[],"baa":"foo"}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:17: {"faa":[],"baa":"foo"}
json: error: <stdin>:1:17:                 ^
{"faa":[],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[],"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[],"baa":"bar"}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:17: {"faa":[],"baa":"bar"}
json: error: <stdin>:1:17:                 ^
{"faa":[],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[],"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[],"baa":{}}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:17: {"faa":[],"baa":{}}
json: error: <stdin>:1:17:                 ^
{"faa":[],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[],"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[],"baa":[]}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:17: {"faa":[],"baa":[]}
json: error: <stdin>:1:17:                 ^
{"faa":[],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[],"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[],"baa":null}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:17: {"faa":[],"baa":null}
json: error: <stdin>:1:17:                 ^
{"faa":[],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[],"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[],"baa":false}'\''
{"faa":[],"baa":false}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[],"baa":true}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:17: {"faa":[],"baa":true}
json: error: <stdin>:1:17:                 ^
{"faa":[],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[],"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[],"baa":123}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:17: {"faa":[],"baa":123}
json: error: <stdin>:1:17:                 ^
{"faa":[],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[],"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[],"baa":456}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:17: {"faa":[],"baa":456}
json: error: <stdin>:1:17:                 ^
{"faa":[],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[],"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[],"baa":"foo"}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:17: {"faa":[],"baa":"foo"}
json: error: <stdin>:1:17:                 ^
{"faa":[],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[],"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[],"baa":"bar"}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:17: {"faa":[],"baa":"bar"}
json: error: <stdin>:1:17:                 ^
{"faa":[],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[],"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[],"baa":{}}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:17: {"faa":[],"baa":{}}
json: error: <stdin>:1:17:                 ^
{"faa":[],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[],"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[],"baa":[]}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:17: {"faa":[],"baa":[]}
json: error: <stdin>:1:17:                 ^
{"faa":[],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[],"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[],"baa":null}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:17: {"faa":[],"baa":null}
json: error: <stdin>:1:17:                 ^
{"faa":[],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[],"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[],"baa":false}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:17: {"faa":[],"baa":false}
json: error: <stdin>:1:17:                 ^
{"faa":[],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[],"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[],"baa":true}'\''
{"faa":[],"baa":true}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[],"baa":123}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:17: {"faa":[],"baa":123}
json: error: <stdin>:1:17:                 ^
{"faa":[],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[],"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[],"baa":456}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:17: {"faa":[],"baa":456}
json: error: <stdin>:1:17:                 ^
{"faa":[],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[],"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[],"baa":"foo"}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:17: {"faa":[],"baa":"foo"}
json: error: <stdin>:1:17:                 ^
{"faa":[],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[],"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[],"baa":"bar"}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:17: {"faa":[],"baa":"bar"}
json: error: <stdin>:1:17:                 ^
{"faa":[],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[],"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[],"baa":{}}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:17: {"faa":[],"baa":{}}
json: error: <stdin>:1:17:                 ^
{"faa":[],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[],"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[],"baa":[]}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:17: {"faa":[],"baa":[]}
json: error: <stdin>:1:17:                 ^
{"faa":[],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[],"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[],"baa":null}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:17: {"faa":[],"baa":null}
json: error: <stdin>:1:17:                 ^
{"faa":[],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[],"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[],"baa":false}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:17: {"faa":[],"baa":false}
json: error: <stdin>:1:17:                 ^
{"faa":[],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[],"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[],"baa":true}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:17: {"faa":[],"baa":true}
json: error: <stdin>:1:17:                 ^
{"faa":[],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[],"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[],"baa":123}'\''
{"faa":[],"baa":123}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[],"baa":456}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:17: {"faa":[],"baa":456}
json: error: <stdin>:1:17:                 ^
{"faa":[],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[],"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[],"baa":"foo"}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:17: {"faa":[],"baa":"foo"}
json: error: <stdin>:1:17:                 ^
{"faa":[],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[],"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[],"baa":"bar"}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:17: {"faa":[],"baa":"bar"}
json: error: <stdin>:1:17:                 ^
{"faa":[],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[],"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[],"baa":{}}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:17: {"faa":[],"baa":{}}
json: error: <stdin>:1:17:                 ^
{"faa":[],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[],"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[],"baa":[]}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:17: {"faa":[],"baa":[]}
json: error: <stdin>:1:17:                 ^
{"faa":[],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[],"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[],"baa":null}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:17: {"faa":[],"baa":null}
json: error: <stdin>:1:17:                 ^
{"faa":[],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[],"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[],"baa":false}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:17: {"faa":[],"baa":false}
json: error: <stdin>:1:17:                 ^
{"faa":[],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[],"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[],"baa":true}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:17: {"faa":[],"baa":true}
json: error: <stdin>:1:17:                 ^
{"faa":[],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[],"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[],"baa":123}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:17: {"faa":[],"baa":123}
json: error: <stdin>:1:17:                 ^
{"faa":[],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[],"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[],"baa":456}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:17: {"faa":[],"baa":456}
json: error: <stdin>:1:17:                 ^
{"faa":[],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[],"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[],"baa":"foo"}'\''
{"faa":[],"baa":"foo"}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[],"baa":"bar"}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:17: {"faa":[],"baa":"bar"}
json: error: <stdin>:1:17:                 ^
{"faa":[],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[],"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[],"baa":{}}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:17: {"faa":[],"baa":{}}
json: error: <stdin>:1:17:                 ^
{"faa":[],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[],"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[],"baa":[]}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:17: {"faa":[],"baa":[]}
json: error: <stdin>:1:17:                 ^
{"faa":[],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[],"baa":[]}'\'''
) -L list-object-basic-plain-val-object-basic-basic3.new <(
echo '$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'
export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes 2>&1 ||
echo 'command failed: export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[{}],"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":[{}],"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[{}],"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[{}],"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":[{}],"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[{}],"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[{}],"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":[{}],"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[{}],"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[{}],"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":[{}],"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[{}],"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[{}],"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":[{}],"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[{}],"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[{}],"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":[{}],"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[{}],"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[{}],"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":[{}],"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[{}],"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[{}],"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":[{}],"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[{}],"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[{}],"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":[{}],"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[{}],"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[{}],"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":[{}],"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[{}],"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[{}],"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":[{}],"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[{}],"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[{}],"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":[{}],"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[{}],"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[{}],"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":[{}],"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[{}],"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[{}],"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":[{}],"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[{}],"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[{}],"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":[{}],"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[{}],"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[{}],"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":[{}],"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[{}],"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[{}],"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":[{}],"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[{}],"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[{}],"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":[{}],"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[{}],"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[{}],"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":[{}],"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[{}],"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[{}],"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":[{}],"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[{}],"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[{}],"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":[{}],"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[{}],"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[{}],"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":[{}],"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[{}],"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[{}],"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":[{}],"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[{}],"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[{}],"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":[{}],"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[{}],"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[{}],"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":[{}],"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[{}],"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[{}],"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":[{}],"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[{}],"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[{}],"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":[{}],"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[{}],"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[{}],"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":[{}],"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[{}],"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[{}],"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":[{}],"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[{}],"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[{}],"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":[{}],"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[{}],"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[{}],"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":[{}],"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[{}],"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[{}],"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":[{}],"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[{}],"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[{}],"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":[{}],"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[{}],"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[{}],"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":[{}],"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[{}],"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[{}],"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":[{}],"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[{}],"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[{}],"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":[{}],"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[{}],"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[{}],"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":[{}],"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[{}],"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[{}],"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":[{}],"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[{}],"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[{}],"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":[{}],"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[{}],"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[{}],"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":[{}],"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[{}],"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[{}],"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":[{}],"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[{}],"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[{}],"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":[{}],"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[{}],"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[{}],"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":[{}],"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[{}],"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[{}],"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":[{}],"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[{}],"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[{}],"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":[{}],"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[{}],"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":null,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":null,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":null,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":null,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":null,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":null,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":null,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":null,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":null,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":null,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":null,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":null,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":null,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":null,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":null,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":null,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":null,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":null,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":null,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":null,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":null,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":null,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":null,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":null,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":null,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":null,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":null,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":null,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":null,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":null,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":null,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":null,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":null,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":null,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":null,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":null,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":null,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":null,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":null,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":null,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":null,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":null,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":null,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":null,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":null,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":false,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":false,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":false,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":false,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":false,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":false,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":false,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":false,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":false,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":false,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":false,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":false,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":false,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":false,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":false,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":false,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":false,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":false,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":false,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":false,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":false,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":false,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":false,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":false,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":false,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":false,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":false,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":false,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":false,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":false,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":false,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":false,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":false,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":false,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":false,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":false,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":false,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":false,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":false,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":false,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":false,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":false,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":false,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":false,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":false,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":456,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":456,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":456,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":456,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":456,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":456,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":456,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":456,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":456,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":456,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":456,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":456,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":456,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":456,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":456,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":456,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":456,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":456,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":456,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":456,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":456,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":456,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":456,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":456,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":456,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":456,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":456,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":456,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":456,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":456,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":456,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":456,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":456,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":456,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":456,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":456,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":456,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":456,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":456,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":456,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":456,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":456,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":456,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":456,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":456,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar","baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":"bar","baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar","baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar","baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":"bar","baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar","baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar","baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":"bar","baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar","baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar","baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":"bar","baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar","baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar","baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":"bar","baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar","baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar","baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":"bar","baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar","baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar","baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":"bar","baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar","baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar","baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":"bar","baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar","baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar","baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":"bar","baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar","baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar","baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":"bar","baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar","baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar","baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":"bar","baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar","baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar","baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":"bar","baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar","baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar","baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":"bar","baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar","baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar","baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":"bar","baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar","baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar","baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":"bar","baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar","baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar","baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":"bar","baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar","baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar","baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":"bar","baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar","baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar","baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":"bar","baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar","baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar","baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":"bar","baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar","baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar","baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":"bar","baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar","baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar","baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":"bar","baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar","baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar","baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":"bar","baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar","baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar","baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":"bar","baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar","baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar","baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":"bar","baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar","baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar","baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":"bar","baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar","baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar","baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":"bar","baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar","baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar","baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":"bar","baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar","baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar","baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":"bar","baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar","baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar","baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":"bar","baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar","baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar","baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":"bar","baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar","baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar","baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":"bar","baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar","baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar","baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":"bar","baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar","baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar","baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":"bar","baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar","baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar","baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":"bar","baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar","baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar","baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":"bar","baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar","baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar","baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":"bar","baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar","baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar","baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":"bar","baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar","baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar","baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":"bar","baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar","baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar","baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":"bar","baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar","baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar","baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":"bar","baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar","baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar","baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":"bar","baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar","baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar","baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":"bar","baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar","baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar","baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":"bar","baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar","baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar","baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":"bar","baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar","baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar","baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":"bar","baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar","baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{},"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":{},"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{},"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{},"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":{},"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{},"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{},"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":{},"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{},"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{},"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":{},"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{},"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{},"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":{},"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{},"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{},"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":{},"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{},"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{},"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":{},"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{},"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{},"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":{},"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{},"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{},"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":{},"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{},"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{},"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":{},"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{},"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{},"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":{},"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{},"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{},"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":{},"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{},"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{},"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":{},"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{},"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{},"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":{},"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{},"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{},"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":{},"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{},"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{},"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":{},"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{},"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{},"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":{},"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{},"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{},"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":{},"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{},"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{},"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":{},"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{},"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{},"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":{},"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{},"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{},"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":{},"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{},"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{},"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":{},"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{},"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{},"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":{},"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{},"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{},"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":{},"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{},"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{},"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":{},"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{},"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{},"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":{},"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{},"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{},"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":{},"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{},"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{},"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":{},"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{},"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{},"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":{},"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{},"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{},"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":{},"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{},"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{},"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":{},"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{},"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{},"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":{},"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{},"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{},"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":{},"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{},"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{},"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":{},"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{},"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{},"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":{},"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{},"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{},"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":{},"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{},"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{},"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":{},"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{},"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{},"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":{},"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{},"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{},"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":{},"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{},"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{},"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":{},"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{},"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{},"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":{},"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{},"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{},"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":{},"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{},"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{},"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":{},"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{},"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{},"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":{},"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{},"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{},"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":{},"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{},"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[],"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":[],"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[],"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[],"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":[],"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[],"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[],"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":[],"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[],"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[],"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":[],"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[],"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[],"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":[],"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[],"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[],"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":[],"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[],"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[],"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":[],"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[],"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[],"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":[],"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[],"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[],"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":[],"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[],"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[],"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":[],"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[],"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[],"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":[],"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[],"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[],"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":[],"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[],"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[],"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":[],"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[],"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[],"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":[],"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[],"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[],"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":[],"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[],"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[],"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":[],"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[],"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[],"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":[],"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[],"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[],"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":[],"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[],"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[],"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":[],"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[],"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[],"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":[],"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[],"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[],"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":[],"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[],"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[],"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":[],"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[],"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[],"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":[],"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[],"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[],"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":[],"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[],"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[],"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":[],"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[],"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[],"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":[],"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[],"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[],"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":[],"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[],"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[],"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":[],"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[],"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[],"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":[],"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[],"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[],"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":[],"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[],"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[],"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":[],"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[],"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[],"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":[],"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[],"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[],"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":[],"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[],"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[],"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":[],"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[],"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[],"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":[],"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[],"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[],"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":[],"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[],"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[],"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":[],"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[],"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[],"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":[],"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[],"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[],"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":[],"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[],"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[],"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":[],"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[],"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[],"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":[],"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[],"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[],"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":[],"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[],"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[],"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":[],"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[],"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[],"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":[],"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[],"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[],"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":[],"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[],"baa":[]}'\'''
)

