#!/bin/bash

# Copyright (C) 2016, 2017, 2018  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-cases:25
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L 25.old <(echo \
'$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@" 2>&1|sed -r '\''/error:/s|(/dev/fd/)[0-9]+|\1??|'\''; }
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]},{"type":"array","args":["boolean","string"]},{"type":"array","args":["number","number"]},{"type":"array","args":["number","string"]}]}'\'' <<< '\''[null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"boolean"'\'' or `"number"'\''
json: error: <stdin>:1:2: [null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]},{"type":"array","args":["boolean","string"]},{"type":"array","args":["number","number"]},{"type":"array","args":["number","string"]}]}'\'' <<< '\''[null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]},{"type":"array","args":["boolean","string"]},{"type":"array","args":["number","number"]},{"type":"array","args":["number","string"]}]}'\'' <<< '\''[false]'\''
json: error: <stdin>:1:7: type check error: too few arguments
json: error: <stdin>:1:7: [false]
json: error: <stdin>:1:7:       ^
[false
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]},{"type":"array","args":["boolean","string"]},{"type":"array","args":["number","number"]},{"type":"array","args":["number","string"]}]}'\'' <<< '\''[false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]},{"type":"array","args":["boolean","string"]},{"type":"array","args":["number","number"]},{"type":"array","args":["number","string"]}]}'\'' <<< '\''[0]'\''
json: error: <stdin>:1:3: type check error: too few arguments
json: error: <stdin>:1:3: [0]
json: error: <stdin>:1:3:   ^
[0
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]},{"type":"array","args":["boolean","string"]},{"type":"array","args":["number","number"]},{"type":"array","args":["number","string"]}]}'\'' <<< '\''[0]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]},{"type":"array","args":["boolean","string"]},{"type":"array","args":["number","number"]},{"type":"array","args":["number","string"]}]}'\'' <<< '\''[false,0]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\'' or `"string"'\''
json: error: <stdin>:1:8: [false,0]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]},{"type":"array","args":["boolean","string"]},{"type":"array","args":["number","number"]},{"type":"array","args":["number","string"]}]}'\'' <<< '\''[false,0]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]},{"type":"array","args":["boolean","string"]},{"type":"array","args":["number","number"]},{"type":"array","args":["number","string"]}]}'\'' <<< '\''[0,false]'\''
json: error: <stdin>:1:4: type check error: type mismatch: expected a value of type `"number"'\'' or `"string"'\''
json: error: <stdin>:1:4: [0,false]
json: error: <stdin>:1:4:    ^
[0,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]},{"type":"array","args":["boolean","string"]},{"type":"array","args":["number","number"]},{"type":"array","args":["number","string"]}]}'\'' <<< '\''[0,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]},{"type":"array","args":["boolean","string"]},{"type":"array","args":["number","number"]},{"type":"array","args":["number","string"]}]}'\'' <<< '\''[false,""]'\''
[false,""]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]},{"type":"array","args":["boolean","string"]},{"type":"array","args":["number","number"]},{"type":"array","args":["number","string"]}]}'\'' <<< '\''[0,""]'\''
[0,""]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]},{"type":"array","args":["boolean","string"]},{"type":"array","args":["number","number"]},{"type":"array","args":["number","string"]}]}'\'' <<< '\''[false,false]'\''
[false,false]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]},{"type":"array","args":["boolean","string"]},{"type":"array","args":["number","number"]},{"type":"array","args":["number","string"]}]}'\'' <<< '\''[0,0]'\''
[0,0]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]},{"type":"array","args":["boolean","string"]},{"type":"array","args":["number","number"]},{"type":"array","args":["number","string"]}]}'\'' <<< '\''[false,true]'\''
[false,true]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]},{"type":"array","args":["boolean","string"]},{"type":"array","args":["number","number"]},{"type":"array","args":["number","string"]}]}'\'' <<< '\''[0,1]'\''
[0,1]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]},{"type":"array","args":["boolean","string"]},{"type":"array","args":["number","number"]},{"type":"array","args":["number","string"]}]}'\'' <<< '\''[false,true,'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: [false,true,
json: error: <stdin>:1:12:            ^
[false,true
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]},{"type":"array","args":["boolean","string"]},{"type":"array","args":["number","number"]},{"type":"array","args":["number","string"]}]}'\'' <<< '\''[false,true,'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]},{"type":"array","args":["boolean","string"]},{"type":"array","args":["number","number"]},{"type":"array","args":["number","string"]}]}'\'' <<< '\''[0,1,'\''
json: error: <stdin>:1:5: type check error: too many arguments
json: error: <stdin>:1:5: [0,1,
json: error: <stdin>:1:5:     ^
[0,1
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]},{"type":"array","args":["boolean","string"]},{"type":"array","args":["number","number"]},{"type":"array","args":["number","string"]}]}'\'' <<< '\''[0,1,'\'''
) -L 25.new <(
echo '$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@" 2>&1|sed -r '\''/error:/s|(/dev/fd/)[0-9]+|\1??|'\''; }'
json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@" 2>&1|sed -r '/error:/s|(/dev/fd/)[0-9]+|\1??|'; } 2>&1 ||
echo 'command failed: json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@" 2>&1|sed -r '\''/error:/s|(/dev/fd/)[0-9]+|\1??|'\''; }'

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]},{"type":"array","args":["boolean","string"]},{"type":"array","args":["number","number"]},{"type":"array","args":["number","string"]}]}'\'' <<< '\''[null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","boolean"]},{"type":"array","args":["boolean","string"]},{"type":"array","args":["number","number"]},{"type":"array","args":["number","string"]}]}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]},{"type":"array","args":["boolean","string"]},{"type":"array","args":["number","number"]},{"type":"array","args":["number","string"]}]}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]},{"type":"array","args":["boolean","string"]},{"type":"array","args":["number","number"]},{"type":"array","args":["number","string"]}]}'\'' <<< '\''[false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","boolean"]},{"type":"array","args":["boolean","string"]},{"type":"array","args":["number","number"]},{"type":"array","args":["number","string"]}]}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]},{"type":"array","args":["boolean","string"]},{"type":"array","args":["number","number"]},{"type":"array","args":["number","string"]}]}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]},{"type":"array","args":["boolean","string"]},{"type":"array","args":["number","number"]},{"type":"array","args":["number","string"]}]}'\'' <<< '\''[0]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","boolean"]},{"type":"array","args":["boolean","string"]},{"type":"array","args":["number","number"]},{"type":"array","args":["number","string"]}]}' <<< '[0]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]},{"type":"array","args":["boolean","string"]},{"type":"array","args":["number","number"]},{"type":"array","args":["number","string"]}]}'\'' <<< '\''[0]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]},{"type":"array","args":["boolean","string"]},{"type":"array","args":["number","number"]},{"type":"array","args":["number","string"]}]}'\'' <<< '\''[false,0]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","boolean"]},{"type":"array","args":["boolean","string"]},{"type":"array","args":["number","number"]},{"type":"array","args":["number","string"]}]}' <<< '[false,0]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]},{"type":"array","args":["boolean","string"]},{"type":"array","args":["number","number"]},{"type":"array","args":["number","string"]}]}'\'' <<< '\''[false,0]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]},{"type":"array","args":["boolean","string"]},{"type":"array","args":["number","number"]},{"type":"array","args":["number","string"]}]}'\'' <<< '\''[0,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","boolean"]},{"type":"array","args":["boolean","string"]},{"type":"array","args":["number","number"]},{"type":"array","args":["number","string"]}]}' <<< '[0,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]},{"type":"array","args":["boolean","string"]},{"type":"array","args":["number","number"]},{"type":"array","args":["number","string"]}]}'\'' <<< '\''[0,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]},{"type":"array","args":["boolean","string"]},{"type":"array","args":["number","number"]},{"type":"array","args":["number","string"]}]}'\'' <<< '\''[false,""]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","boolean"]},{"type":"array","args":["boolean","string"]},{"type":"array","args":["number","number"]},{"type":"array","args":["number","string"]}]}' <<< '[false,""]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]},{"type":"array","args":["boolean","string"]},{"type":"array","args":["number","number"]},{"type":"array","args":["number","string"]}]}'\'' <<< '\''[false,""]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]},{"type":"array","args":["boolean","string"]},{"type":"array","args":["number","number"]},{"type":"array","args":["number","string"]}]}'\'' <<< '\''[0,""]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","boolean"]},{"type":"array","args":["boolean","string"]},{"type":"array","args":["number","number"]},{"type":"array","args":["number","string"]}]}' <<< '[0,""]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]},{"type":"array","args":["boolean","string"]},{"type":"array","args":["number","number"]},{"type":"array","args":["number","string"]}]}'\'' <<< '\''[0,""]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]},{"type":"array","args":["boolean","string"]},{"type":"array","args":["number","number"]},{"type":"array","args":["number","string"]}]}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","boolean"]},{"type":"array","args":["boolean","string"]},{"type":"array","args":["number","number"]},{"type":"array","args":["number","string"]}]}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]},{"type":"array","args":["boolean","string"]},{"type":"array","args":["number","number"]},{"type":"array","args":["number","string"]}]}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]},{"type":"array","args":["boolean","string"]},{"type":"array","args":["number","number"]},{"type":"array","args":["number","string"]}]}'\'' <<< '\''[0,0]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","boolean"]},{"type":"array","args":["boolean","string"]},{"type":"array","args":["number","number"]},{"type":"array","args":["number","string"]}]}' <<< '[0,0]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]},{"type":"array","args":["boolean","string"]},{"type":"array","args":["number","number"]},{"type":"array","args":["number","string"]}]}'\'' <<< '\''[0,0]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]},{"type":"array","args":["boolean","string"]},{"type":"array","args":["number","number"]},{"type":"array","args":["number","string"]}]}'\'' <<< '\''[false,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","boolean"]},{"type":"array","args":["boolean","string"]},{"type":"array","args":["number","number"]},{"type":"array","args":["number","string"]}]}' <<< '[false,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]},{"type":"array","args":["boolean","string"]},{"type":"array","args":["number","number"]},{"type":"array","args":["number","string"]}]}'\'' <<< '\''[false,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]},{"type":"array","args":["boolean","string"]},{"type":"array","args":["number","number"]},{"type":"array","args":["number","string"]}]}'\'' <<< '\''[0,1]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","boolean"]},{"type":"array","args":["boolean","string"]},{"type":"array","args":["number","number"]},{"type":"array","args":["number","string"]}]}' <<< '[0,1]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]},{"type":"array","args":["boolean","string"]},{"type":"array","args":["number","number"]},{"type":"array","args":["number","string"]}]}'\'' <<< '\''[0,1]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]},{"type":"array","args":["boolean","string"]},{"type":"array","args":["number","number"]},{"type":"array","args":["number","string"]}]}'\'' <<< '\''[false,true,'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","boolean"]},{"type":"array","args":["boolean","string"]},{"type":"array","args":["number","number"]},{"type":"array","args":["number","string"]}]}' <<< '[false,true,' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]},{"type":"array","args":["boolean","string"]},{"type":"array","args":["number","number"]},{"type":"array","args":["number","string"]}]}'\'' <<< '\''[false,true,'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]},{"type":"array","args":["boolean","string"]},{"type":"array","args":["number","number"]},{"type":"array","args":["number","string"]}]}'\'' <<< '\''[0,1,'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","boolean"]},{"type":"array","args":["boolean","string"]},{"type":"array","args":["number","number"]},{"type":"array","args":["number","string"]}]}' <<< '[0,1,' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]},{"type":"array","args":["boolean","string"]},{"type":"array","args":["number","number"]},{"type":"array","args":["number","string"]}]}'\'' <<< '\''[0,1,'\'''
)

