#!/bin/bash

# Copyright (C) 2016, 2017, 2018  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C parser:string-esc2
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L string-esc2.old <(echo \
'$ json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }
$ json() { json0 --literal-value "$@"; }
$ echo '\''"\ "'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\ "
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\ "'\''|json -b 1
$ echo '\''"\ "'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\ "
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\ "'\''|json -b 2
$ echo '\''"\ "'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\ "
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\ "'\''|json -b 3
$ echo '\''"\ "'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\ "
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\ "'\''|json -b 4
$ echo '\''"\ "'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\ "
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\ "'\''|json -b 5
$ echo '\''"\!"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\!"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\!"'\''|json -b 1
$ echo '\''"\!"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\!"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\!"'\''|json -b 2
$ echo '\''"\!"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\!"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\!"'\''|json -b 3
$ echo '\''"\!"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\!"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\!"'\''|json -b 4
$ echo '\''"\!"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\!"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\!"'\''|json -b 5
$ echo '\''"\""'\''|json -b 1
"\""
$ echo '\''"\""'\''|json -b 2
"\""
$ echo '\''"\""'\''|json -b 3
"\""
$ echo '\''"\""'\''|json -b 4
"\""
$ echo '\''"\""'\''|json -b 5
"\""
$ echo '\''"\#"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\#"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\#"'\''|json -b 1
$ echo '\''"\#"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\#"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\#"'\''|json -b 2
$ echo '\''"\#"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\#"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\#"'\''|json -b 3
$ echo '\''"\#"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\#"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\#"'\''|json -b 4
$ echo '\''"\#"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\#"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\#"'\''|json -b 5
$ echo '\''"\$"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\$"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\$"'\''|json -b 1
$ echo '\''"\$"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\$"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\$"'\''|json -b 2
$ echo '\''"\$"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\$"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\$"'\''|json -b 3
$ echo '\''"\$"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\$"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\$"'\''|json -b 4
$ echo '\''"\$"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\$"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\$"'\''|json -b 5
$ echo '\''"\%"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\%"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\%"'\''|json -b 1
$ echo '\''"\%"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\%"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\%"'\''|json -b 2
$ echo '\''"\%"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\%"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\%"'\''|json -b 3
$ echo '\''"\%"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\%"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\%"'\''|json -b 4
$ echo '\''"\%"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\%"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\%"'\''|json -b 5
$ echo '\''"\&"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\&"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\&"'\''|json -b 1
$ echo '\''"\&"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\&"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\&"'\''|json -b 2
$ echo '\''"\&"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\&"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\&"'\''|json -b 3
$ echo '\''"\&"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\&"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\&"'\''|json -b 4
$ echo '\''"\&"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\&"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\&"'\''|json -b 5
$ echo -e '\''"\\\x27"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\'\''"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x27"'\''|json -b 1
$ echo -e '\''"\\\x27"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\'\''"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x27"'\''|json -b 2
$ echo -e '\''"\\\x27"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\'\''"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x27"'\''|json -b 3
$ echo -e '\''"\\\x27"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\'\''"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x27"'\''|json -b 4
$ echo -e '\''"\\\x27"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\'\''"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x27"'\''|json -b 5
$ echo '\''"\("'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\("
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\("'\''|json -b 1
$ echo '\''"\("'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\("
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\("'\''|json -b 2
$ echo '\''"\("'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\("
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\("'\''|json -b 3
$ echo '\''"\("'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\("
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\("'\''|json -b 4
$ echo '\''"\("'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\("
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\("'\''|json -b 5
$ echo '\''"\)"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\)"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\)"'\''|json -b 1
$ echo '\''"\)"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\)"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\)"'\''|json -b 2
$ echo '\''"\)"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\)"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\)"'\''|json -b 3
$ echo '\''"\)"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\)"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\)"'\''|json -b 4
$ echo '\''"\)"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\)"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\)"'\''|json -b 5
$ echo '\''"\*"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\*"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\*"'\''|json -b 1
$ echo '\''"\*"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\*"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\*"'\''|json -b 2
$ echo '\''"\*"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\*"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\*"'\''|json -b 3
$ echo '\''"\*"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\*"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\*"'\''|json -b 4
$ echo '\''"\*"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\*"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\*"'\''|json -b 5
$ echo '\''"\+"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\+"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\+"'\''|json -b 1
$ echo '\''"\+"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\+"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\+"'\''|json -b 2
$ echo '\''"\+"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\+"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\+"'\''|json -b 3
$ echo '\''"\+"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\+"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\+"'\''|json -b 4
$ echo '\''"\+"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\+"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\+"'\''|json -b 5
$ echo '\''"\,"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\,"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\,"'\''|json -b 1
$ echo '\''"\,"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\,"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\,"'\''|json -b 2
$ echo '\''"\,"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\,"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\,"'\''|json -b 3
$ echo '\''"\,"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\,"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\,"'\''|json -b 4
$ echo '\''"\,"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\,"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\,"'\''|json -b 5
$ echo '\''"\-"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\-"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\-"'\''|json -b 1
$ echo '\''"\-"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\-"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\-"'\''|json -b 2
$ echo '\''"\-"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\-"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\-"'\''|json -b 3
$ echo '\''"\-"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\-"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\-"'\''|json -b 4
$ echo '\''"\-"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\-"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\-"'\''|json -b 5
$ echo '\''"\."'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\."
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\."'\''|json -b 1
$ echo '\''"\."'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\."
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\."'\''|json -b 2
$ echo '\''"\."'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\."
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\."'\''|json -b 3
$ echo '\''"\."'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\."
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\."'\''|json -b 4
$ echo '\''"\."'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\."
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\."'\''|json -b 5
$ echo '\''"\/"'\''|json -b 1
"/"
$ echo '\''"\/"'\''|json -b 2
"/"
$ echo '\''"\/"'\''|json -b 3
"/"
$ echo '\''"\/"'\''|json -b 4
"/"
$ echo '\''"\/"'\''|json -b 5
"/"
$ echo '\''"\0"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\0"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\0"'\''|json -b 1
$ echo '\''"\0"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\0"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\0"'\''|json -b 2
$ echo '\''"\0"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\0"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\0"'\''|json -b 3
$ echo '\''"\0"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\0"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\0"'\''|json -b 4
$ echo '\''"\0"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\0"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\0"'\''|json -b 5
$ echo '\''"\1"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\1"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\1"'\''|json -b 1
$ echo '\''"\1"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\1"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\1"'\''|json -b 2
$ echo '\''"\1"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\1"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\1"'\''|json -b 3
$ echo '\''"\1"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\1"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\1"'\''|json -b 4
$ echo '\''"\1"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\1"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\1"'\''|json -b 5
$ echo '\''"\2"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\2"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\2"'\''|json -b 1
$ echo '\''"\2"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\2"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\2"'\''|json -b 2
$ echo '\''"\2"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\2"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\2"'\''|json -b 3
$ echo '\''"\2"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\2"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\2"'\''|json -b 4
$ echo '\''"\2"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\2"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\2"'\''|json -b 5
$ echo '\''"\3"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\3"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\3"'\''|json -b 1
$ echo '\''"\3"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\3"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\3"'\''|json -b 2
$ echo '\''"\3"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\3"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\3"'\''|json -b 3
$ echo '\''"\3"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\3"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\3"'\''|json -b 4
$ echo '\''"\3"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\3"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\3"'\''|json -b 5
$ echo '\''"\4"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\4"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\4"'\''|json -b 1
$ echo '\''"\4"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\4"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\4"'\''|json -b 2
$ echo '\''"\4"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\4"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\4"'\''|json -b 3
$ echo '\''"\4"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\4"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\4"'\''|json -b 4
$ echo '\''"\4"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\4"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\4"'\''|json -b 5
$ echo '\''"\5"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\5"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\5"'\''|json -b 1
$ echo '\''"\5"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\5"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\5"'\''|json -b 2
$ echo '\''"\5"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\5"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\5"'\''|json -b 3
$ echo '\''"\5"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\5"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\5"'\''|json -b 4
$ echo '\''"\5"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\5"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\5"'\''|json -b 5
$ echo '\''"\6"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\6"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\6"'\''|json -b 1
$ echo '\''"\6"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\6"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\6"'\''|json -b 2
$ echo '\''"\6"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\6"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\6"'\''|json -b 3
$ echo '\''"\6"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\6"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\6"'\''|json -b 4
$ echo '\''"\6"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\6"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\6"'\''|json -b 5
$ echo '\''"\7"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\7"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\7"'\''|json -b 1
$ echo '\''"\7"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\7"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\7"'\''|json -b 2
$ echo '\''"\7"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\7"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\7"'\''|json -b 3
$ echo '\''"\7"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\7"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\7"'\''|json -b 4
$ echo '\''"\7"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\7"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\7"'\''|json -b 5
$ echo '\''"\8"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\8"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\8"'\''|json -b 1
$ echo '\''"\8"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\8"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\8"'\''|json -b 2
$ echo '\''"\8"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\8"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\8"'\''|json -b 3
$ echo '\''"\8"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\8"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\8"'\''|json -b 4
$ echo '\''"\8"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\8"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\8"'\''|json -b 5
$ echo '\''"\9"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\9"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\9"'\''|json -b 1
$ echo '\''"\9"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\9"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\9"'\''|json -b 2
$ echo '\''"\9"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\9"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\9"'\''|json -b 3
$ echo '\''"\9"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\9"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\9"'\''|json -b 4
$ echo '\''"\9"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\9"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\9"'\''|json -b 5
$ echo '\''"\:"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\:"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\:"'\''|json -b 1
$ echo '\''"\:"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\:"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\:"'\''|json -b 2
$ echo '\''"\:"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\:"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\:"'\''|json -b 3
$ echo '\''"\:"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\:"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\:"'\''|json -b 4
$ echo '\''"\:"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\:"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\:"'\''|json -b 5
$ echo '\''"\;"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\;"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\;"'\''|json -b 1
$ echo '\''"\;"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\;"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\;"'\''|json -b 2
$ echo '\''"\;"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\;"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\;"'\''|json -b 3
$ echo '\''"\;"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\;"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\;"'\''|json -b 4
$ echo '\''"\;"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\;"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\;"'\''|json -b 5
$ echo '\''"\<"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\<"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\<"'\''|json -b 1
$ echo '\''"\<"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\<"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\<"'\''|json -b 2
$ echo '\''"\<"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\<"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\<"'\''|json -b 3
$ echo '\''"\<"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\<"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\<"'\''|json -b 4
$ echo '\''"\<"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\<"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\<"'\''|json -b 5
$ echo '\''"\="'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\="
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\="'\''|json -b 1
$ echo '\''"\="'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\="
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\="'\''|json -b 2
$ echo '\''"\="'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\="
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\="'\''|json -b 3
$ echo '\''"\="'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\="
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\="'\''|json -b 4
$ echo '\''"\="'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\="
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\="'\''|json -b 5
$ echo '\''"\>"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\>"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\>"'\''|json -b 1
$ echo '\''"\>"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\>"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\>"'\''|json -b 2
$ echo '\''"\>"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\>"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\>"'\''|json -b 3
$ echo '\''"\>"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\>"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\>"'\''|json -b 4
$ echo '\''"\>"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\>"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\>"'\''|json -b 5
$ echo '\''"\?"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\?"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\?"'\''|json -b 1
$ echo '\''"\?"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\?"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\?"'\''|json -b 2
$ echo '\''"\?"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\?"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\?"'\''|json -b 3
$ echo '\''"\?"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\?"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\?"'\''|json -b 4
$ echo '\''"\?"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\?"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\?"'\''|json -b 5'
) -L string-esc2.new <(
echo '$ json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }'
json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; } 2>&1 ||
echo 'command failed: json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }'

echo '$ json() { json0 --literal-value "$@"; }'
json() { json0 --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { json0 --literal-value "$@"; }'

echo '$ echo '\''"\ "'\''|json -b 1'
echo '"\ "'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\ "'\''|json -b 1'

echo '$ echo '\''"\ "'\''|json -b 2'
echo '"\ "'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\ "'\''|json -b 2'

echo '$ echo '\''"\ "'\''|json -b 3'
echo '"\ "'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\ "'\''|json -b 3'

echo '$ echo '\''"\ "'\''|json -b 4'
echo '"\ "'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\ "'\''|json -b 4'

echo '$ echo '\''"\ "'\''|json -b 5'
echo '"\ "'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\ "'\''|json -b 5'

echo '$ echo '\''"\!"'\''|json -b 1'
echo '"\!"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\!"'\''|json -b 1'

echo '$ echo '\''"\!"'\''|json -b 2'
echo '"\!"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\!"'\''|json -b 2'

echo '$ echo '\''"\!"'\''|json -b 3'
echo '"\!"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\!"'\''|json -b 3'

echo '$ echo '\''"\!"'\''|json -b 4'
echo '"\!"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\!"'\''|json -b 4'

echo '$ echo '\''"\!"'\''|json -b 5'
echo '"\!"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\!"'\''|json -b 5'

echo '$ echo '\''"\""'\''|json -b 1'
echo '"\""'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\""'\''|json -b 1'

echo '$ echo '\''"\""'\''|json -b 2'
echo '"\""'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\""'\''|json -b 2'

echo '$ echo '\''"\""'\''|json -b 3'
echo '"\""'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\""'\''|json -b 3'

echo '$ echo '\''"\""'\''|json -b 4'
echo '"\""'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\""'\''|json -b 4'

echo '$ echo '\''"\""'\''|json -b 5'
echo '"\""'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\""'\''|json -b 5'

echo '$ echo '\''"\#"'\''|json -b 1'
echo '"\#"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\#"'\''|json -b 1'

echo '$ echo '\''"\#"'\''|json -b 2'
echo '"\#"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\#"'\''|json -b 2'

echo '$ echo '\''"\#"'\''|json -b 3'
echo '"\#"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\#"'\''|json -b 3'

echo '$ echo '\''"\#"'\''|json -b 4'
echo '"\#"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\#"'\''|json -b 4'

echo '$ echo '\''"\#"'\''|json -b 5'
echo '"\#"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\#"'\''|json -b 5'

echo '$ echo '\''"\$"'\''|json -b 1'
echo '"\$"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\$"'\''|json -b 1'

echo '$ echo '\''"\$"'\''|json -b 2'
echo '"\$"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\$"'\''|json -b 2'

echo '$ echo '\''"\$"'\''|json -b 3'
echo '"\$"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\$"'\''|json -b 3'

echo '$ echo '\''"\$"'\''|json -b 4'
echo '"\$"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\$"'\''|json -b 4'

echo '$ echo '\''"\$"'\''|json -b 5'
echo '"\$"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\$"'\''|json -b 5'

echo '$ echo '\''"\%"'\''|json -b 1'
echo '"\%"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\%"'\''|json -b 1'

echo '$ echo '\''"\%"'\''|json -b 2'
echo '"\%"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\%"'\''|json -b 2'

echo '$ echo '\''"\%"'\''|json -b 3'
echo '"\%"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\%"'\''|json -b 3'

echo '$ echo '\''"\%"'\''|json -b 4'
echo '"\%"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\%"'\''|json -b 4'

echo '$ echo '\''"\%"'\''|json -b 5'
echo '"\%"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\%"'\''|json -b 5'

echo '$ echo '\''"\&"'\''|json -b 1'
echo '"\&"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\&"'\''|json -b 1'

echo '$ echo '\''"\&"'\''|json -b 2'
echo '"\&"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\&"'\''|json -b 2'

echo '$ echo '\''"\&"'\''|json -b 3'
echo '"\&"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\&"'\''|json -b 3'

echo '$ echo '\''"\&"'\''|json -b 4'
echo '"\&"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\&"'\''|json -b 4'

echo '$ echo '\''"\&"'\''|json -b 5'
echo '"\&"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\&"'\''|json -b 5'

echo '$ echo -e '\''"\\\x27"'\''|json -b 1'
echo -e '"\\\x27"'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''"\\\x27"'\''|json -b 1'

echo '$ echo -e '\''"\\\x27"'\''|json -b 2'
echo -e '"\\\x27"'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''"\\\x27"'\''|json -b 2'

echo '$ echo -e '\''"\\\x27"'\''|json -b 3'
echo -e '"\\\x27"'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''"\\\x27"'\''|json -b 3'

echo '$ echo -e '\''"\\\x27"'\''|json -b 4'
echo -e '"\\\x27"'|json -b 4 2>&1 ||
echo 'command failed: echo -e '\''"\\\x27"'\''|json -b 4'

echo '$ echo -e '\''"\\\x27"'\''|json -b 5'
echo -e '"\\\x27"'|json -b 5 2>&1 ||
echo 'command failed: echo -e '\''"\\\x27"'\''|json -b 5'

echo '$ echo '\''"\("'\''|json -b 1'
echo '"\("'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\("'\''|json -b 1'

echo '$ echo '\''"\("'\''|json -b 2'
echo '"\("'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\("'\''|json -b 2'

echo '$ echo '\''"\("'\''|json -b 3'
echo '"\("'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\("'\''|json -b 3'

echo '$ echo '\''"\("'\''|json -b 4'
echo '"\("'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\("'\''|json -b 4'

echo '$ echo '\''"\("'\''|json -b 5'
echo '"\("'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\("'\''|json -b 5'

echo '$ echo '\''"\)"'\''|json -b 1'
echo '"\)"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\)"'\''|json -b 1'

echo '$ echo '\''"\)"'\''|json -b 2'
echo '"\)"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\)"'\''|json -b 2'

echo '$ echo '\''"\)"'\''|json -b 3'
echo '"\)"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\)"'\''|json -b 3'

echo '$ echo '\''"\)"'\''|json -b 4'
echo '"\)"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\)"'\''|json -b 4'

echo '$ echo '\''"\)"'\''|json -b 5'
echo '"\)"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\)"'\''|json -b 5'

echo '$ echo '\''"\*"'\''|json -b 1'
echo '"\*"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\*"'\''|json -b 1'

echo '$ echo '\''"\*"'\''|json -b 2'
echo '"\*"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\*"'\''|json -b 2'

echo '$ echo '\''"\*"'\''|json -b 3'
echo '"\*"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\*"'\''|json -b 3'

echo '$ echo '\''"\*"'\''|json -b 4'
echo '"\*"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\*"'\''|json -b 4'

echo '$ echo '\''"\*"'\''|json -b 5'
echo '"\*"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\*"'\''|json -b 5'

echo '$ echo '\''"\+"'\''|json -b 1'
echo '"\+"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\+"'\''|json -b 1'

echo '$ echo '\''"\+"'\''|json -b 2'
echo '"\+"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\+"'\''|json -b 2'

echo '$ echo '\''"\+"'\''|json -b 3'
echo '"\+"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\+"'\''|json -b 3'

echo '$ echo '\''"\+"'\''|json -b 4'
echo '"\+"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\+"'\''|json -b 4'

echo '$ echo '\''"\+"'\''|json -b 5'
echo '"\+"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\+"'\''|json -b 5'

echo '$ echo '\''"\,"'\''|json -b 1'
echo '"\,"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\,"'\''|json -b 1'

echo '$ echo '\''"\,"'\''|json -b 2'
echo '"\,"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\,"'\''|json -b 2'

echo '$ echo '\''"\,"'\''|json -b 3'
echo '"\,"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\,"'\''|json -b 3'

echo '$ echo '\''"\,"'\''|json -b 4'
echo '"\,"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\,"'\''|json -b 4'

echo '$ echo '\''"\,"'\''|json -b 5'
echo '"\,"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\,"'\''|json -b 5'

echo '$ echo '\''"\-"'\''|json -b 1'
echo '"\-"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\-"'\''|json -b 1'

echo '$ echo '\''"\-"'\''|json -b 2'
echo '"\-"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\-"'\''|json -b 2'

echo '$ echo '\''"\-"'\''|json -b 3'
echo '"\-"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\-"'\''|json -b 3'

echo '$ echo '\''"\-"'\''|json -b 4'
echo '"\-"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\-"'\''|json -b 4'

echo '$ echo '\''"\-"'\''|json -b 5'
echo '"\-"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\-"'\''|json -b 5'

echo '$ echo '\''"\."'\''|json -b 1'
echo '"\."'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\."'\''|json -b 1'

echo '$ echo '\''"\."'\''|json -b 2'
echo '"\."'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\."'\''|json -b 2'

echo '$ echo '\''"\."'\''|json -b 3'
echo '"\."'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\."'\''|json -b 3'

echo '$ echo '\''"\."'\''|json -b 4'
echo '"\."'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\."'\''|json -b 4'

echo '$ echo '\''"\."'\''|json -b 5'
echo '"\."'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\."'\''|json -b 5'

echo '$ echo '\''"\/"'\''|json -b 1'
echo '"\/"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\/"'\''|json -b 1'

echo '$ echo '\''"\/"'\''|json -b 2'
echo '"\/"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\/"'\''|json -b 2'

echo '$ echo '\''"\/"'\''|json -b 3'
echo '"\/"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\/"'\''|json -b 3'

echo '$ echo '\''"\/"'\''|json -b 4'
echo '"\/"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\/"'\''|json -b 4'

echo '$ echo '\''"\/"'\''|json -b 5'
echo '"\/"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\/"'\''|json -b 5'

echo '$ echo '\''"\0"'\''|json -b 1'
echo '"\0"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\0"'\''|json -b 1'

echo '$ echo '\''"\0"'\''|json -b 2'
echo '"\0"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\0"'\''|json -b 2'

echo '$ echo '\''"\0"'\''|json -b 3'
echo '"\0"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\0"'\''|json -b 3'

echo '$ echo '\''"\0"'\''|json -b 4'
echo '"\0"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\0"'\''|json -b 4'

echo '$ echo '\''"\0"'\''|json -b 5'
echo '"\0"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\0"'\''|json -b 5'

echo '$ echo '\''"\1"'\''|json -b 1'
echo '"\1"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\1"'\''|json -b 1'

echo '$ echo '\''"\1"'\''|json -b 2'
echo '"\1"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\1"'\''|json -b 2'

echo '$ echo '\''"\1"'\''|json -b 3'
echo '"\1"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\1"'\''|json -b 3'

echo '$ echo '\''"\1"'\''|json -b 4'
echo '"\1"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\1"'\''|json -b 4'

echo '$ echo '\''"\1"'\''|json -b 5'
echo '"\1"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\1"'\''|json -b 5'

echo '$ echo '\''"\2"'\''|json -b 1'
echo '"\2"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\2"'\''|json -b 1'

echo '$ echo '\''"\2"'\''|json -b 2'
echo '"\2"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\2"'\''|json -b 2'

echo '$ echo '\''"\2"'\''|json -b 3'
echo '"\2"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\2"'\''|json -b 3'

echo '$ echo '\''"\2"'\''|json -b 4'
echo '"\2"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\2"'\''|json -b 4'

echo '$ echo '\''"\2"'\''|json -b 5'
echo '"\2"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\2"'\''|json -b 5'

echo '$ echo '\''"\3"'\''|json -b 1'
echo '"\3"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\3"'\''|json -b 1'

echo '$ echo '\''"\3"'\''|json -b 2'
echo '"\3"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\3"'\''|json -b 2'

echo '$ echo '\''"\3"'\''|json -b 3'
echo '"\3"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\3"'\''|json -b 3'

echo '$ echo '\''"\3"'\''|json -b 4'
echo '"\3"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\3"'\''|json -b 4'

echo '$ echo '\''"\3"'\''|json -b 5'
echo '"\3"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\3"'\''|json -b 5'

echo '$ echo '\''"\4"'\''|json -b 1'
echo '"\4"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\4"'\''|json -b 1'

echo '$ echo '\''"\4"'\''|json -b 2'
echo '"\4"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\4"'\''|json -b 2'

echo '$ echo '\''"\4"'\''|json -b 3'
echo '"\4"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\4"'\''|json -b 3'

echo '$ echo '\''"\4"'\''|json -b 4'
echo '"\4"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\4"'\''|json -b 4'

echo '$ echo '\''"\4"'\''|json -b 5'
echo '"\4"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\4"'\''|json -b 5'

echo '$ echo '\''"\5"'\''|json -b 1'
echo '"\5"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\5"'\''|json -b 1'

echo '$ echo '\''"\5"'\''|json -b 2'
echo '"\5"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\5"'\''|json -b 2'

echo '$ echo '\''"\5"'\''|json -b 3'
echo '"\5"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\5"'\''|json -b 3'

echo '$ echo '\''"\5"'\''|json -b 4'
echo '"\5"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\5"'\''|json -b 4'

echo '$ echo '\''"\5"'\''|json -b 5'
echo '"\5"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\5"'\''|json -b 5'

echo '$ echo '\''"\6"'\''|json -b 1'
echo '"\6"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\6"'\''|json -b 1'

echo '$ echo '\''"\6"'\''|json -b 2'
echo '"\6"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\6"'\''|json -b 2'

echo '$ echo '\''"\6"'\''|json -b 3'
echo '"\6"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\6"'\''|json -b 3'

echo '$ echo '\''"\6"'\''|json -b 4'
echo '"\6"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\6"'\''|json -b 4'

echo '$ echo '\''"\6"'\''|json -b 5'
echo '"\6"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\6"'\''|json -b 5'

echo '$ echo '\''"\7"'\''|json -b 1'
echo '"\7"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\7"'\''|json -b 1'

echo '$ echo '\''"\7"'\''|json -b 2'
echo '"\7"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\7"'\''|json -b 2'

echo '$ echo '\''"\7"'\''|json -b 3'
echo '"\7"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\7"'\''|json -b 3'

echo '$ echo '\''"\7"'\''|json -b 4'
echo '"\7"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\7"'\''|json -b 4'

echo '$ echo '\''"\7"'\''|json -b 5'
echo '"\7"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\7"'\''|json -b 5'

echo '$ echo '\''"\8"'\''|json -b 1'
echo '"\8"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\8"'\''|json -b 1'

echo '$ echo '\''"\8"'\''|json -b 2'
echo '"\8"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\8"'\''|json -b 2'

echo '$ echo '\''"\8"'\''|json -b 3'
echo '"\8"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\8"'\''|json -b 3'

echo '$ echo '\''"\8"'\''|json -b 4'
echo '"\8"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\8"'\''|json -b 4'

echo '$ echo '\''"\8"'\''|json -b 5'
echo '"\8"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\8"'\''|json -b 5'

echo '$ echo '\''"\9"'\''|json -b 1'
echo '"\9"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\9"'\''|json -b 1'

echo '$ echo '\''"\9"'\''|json -b 2'
echo '"\9"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\9"'\''|json -b 2'

echo '$ echo '\''"\9"'\''|json -b 3'
echo '"\9"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\9"'\''|json -b 3'

echo '$ echo '\''"\9"'\''|json -b 4'
echo '"\9"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\9"'\''|json -b 4'

echo '$ echo '\''"\9"'\''|json -b 5'
echo '"\9"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\9"'\''|json -b 5'

echo '$ echo '\''"\:"'\''|json -b 1'
echo '"\:"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\:"'\''|json -b 1'

echo '$ echo '\''"\:"'\''|json -b 2'
echo '"\:"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\:"'\''|json -b 2'

echo '$ echo '\''"\:"'\''|json -b 3'
echo '"\:"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\:"'\''|json -b 3'

echo '$ echo '\''"\:"'\''|json -b 4'
echo '"\:"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\:"'\''|json -b 4'

echo '$ echo '\''"\:"'\''|json -b 5'
echo '"\:"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\:"'\''|json -b 5'

echo '$ echo '\''"\;"'\''|json -b 1'
echo '"\;"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\;"'\''|json -b 1'

echo '$ echo '\''"\;"'\''|json -b 2'
echo '"\;"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\;"'\''|json -b 2'

echo '$ echo '\''"\;"'\''|json -b 3'
echo '"\;"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\;"'\''|json -b 3'

echo '$ echo '\''"\;"'\''|json -b 4'
echo '"\;"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\;"'\''|json -b 4'

echo '$ echo '\''"\;"'\''|json -b 5'
echo '"\;"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\;"'\''|json -b 5'

echo '$ echo '\''"\<"'\''|json -b 1'
echo '"\<"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\<"'\''|json -b 1'

echo '$ echo '\''"\<"'\''|json -b 2'
echo '"\<"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\<"'\''|json -b 2'

echo '$ echo '\''"\<"'\''|json -b 3'
echo '"\<"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\<"'\''|json -b 3'

echo '$ echo '\''"\<"'\''|json -b 4'
echo '"\<"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\<"'\''|json -b 4'

echo '$ echo '\''"\<"'\''|json -b 5'
echo '"\<"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\<"'\''|json -b 5'

echo '$ echo '\''"\="'\''|json -b 1'
echo '"\="'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\="'\''|json -b 1'

echo '$ echo '\''"\="'\''|json -b 2'
echo '"\="'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\="'\''|json -b 2'

echo '$ echo '\''"\="'\''|json -b 3'
echo '"\="'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\="'\''|json -b 3'

echo '$ echo '\''"\="'\''|json -b 4'
echo '"\="'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\="'\''|json -b 4'

echo '$ echo '\''"\="'\''|json -b 5'
echo '"\="'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\="'\''|json -b 5'

echo '$ echo '\''"\>"'\''|json -b 1'
echo '"\>"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\>"'\''|json -b 1'

echo '$ echo '\''"\>"'\''|json -b 2'
echo '"\>"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\>"'\''|json -b 2'

echo '$ echo '\''"\>"'\''|json -b 3'
echo '"\>"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\>"'\''|json -b 3'

echo '$ echo '\''"\>"'\''|json -b 4'
echo '"\>"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\>"'\''|json -b 4'

echo '$ echo '\''"\>"'\''|json -b 5'
echo '"\>"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\>"'\''|json -b 5'

echo '$ echo '\''"\?"'\''|json -b 1'
echo '"\?"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\?"'\''|json -b 1'

echo '$ echo '\''"\?"'\''|json -b 2'
echo '"\?"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\?"'\''|json -b 2'

echo '$ echo '\''"\?"'\''|json -b 3'
echo '"\?"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\?"'\''|json -b 3'

echo '$ echo '\''"\?"'\''|json -b 4'
echo '"\?"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\?"'\''|json -b 4'

echo '$ echo '\''"\?"'\''|json -b 5'
echo '"\?"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\?"'\''|json -b 5'
)

