#!/bin/bash

# Copyright (C) 2016, 2017, 2018  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-checker:dict5
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L dict5.old <(echo \
'$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes
$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"bar":null,"foo":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "foo"
json: error: <stdin>:1:2: {"bar":null,"foo":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"bar":null,"foo":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"bar":false,"foo":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "foo"
json: error: <stdin>:1:2: {"bar":false,"foo":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"bar":false,"foo":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"bar":true,"foo":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "foo"
json: error: <stdin>:1:2: {"bar":true,"foo":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"bar":true,"foo":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"bar":123,"foo":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "foo"
json: error: <stdin>:1:2: {"bar":123,"foo":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"bar":123,"foo":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"bar":"foo","foo":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "foo"
json: error: <stdin>:1:2: {"bar":"foo","foo":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"bar":"foo","foo":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"bar":{},"foo":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "foo"
json: error: <stdin>:1:2: {"bar":{},"foo":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"bar":{},"foo":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"bar":[],"foo":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "foo"
json: error: <stdin>:1:2: {"bar":[],"foo":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"bar":[],"foo":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "foo"
json: error: <stdin>:1:2: {"bar":null,"foo":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"bar":false,"foo":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "foo"
json: error: <stdin>:1:2: {"bar":false,"foo":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"bar":false,"foo":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"bar":true,"foo":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "foo"
json: error: <stdin>:1:2: {"bar":true,"foo":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"bar":true,"foo":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"bar":123,"foo":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "foo"
json: error: <stdin>:1:2: {"bar":123,"foo":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"bar":123,"foo":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"bar":"foo","foo":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "foo"
json: error: <stdin>:1:2: {"bar":"foo","foo":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"bar":"foo","foo":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"bar":{},"foo":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "foo"
json: error: <stdin>:1:2: {"bar":{},"foo":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"bar":{},"foo":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"bar":[],"foo":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "foo"
json: error: <stdin>:1:2: {"bar":[],"foo":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"bar":[],"foo":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"bar":null,"foo":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "foo"
json: error: <stdin>:1:2: {"bar":null,"foo":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"bar":null,"foo":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"bar":false,"foo":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "foo"
json: error: <stdin>:1:2: {"bar":false,"foo":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"bar":false,"foo":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"bar":true,"foo":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "foo"
json: error: <stdin>:1:2: {"bar":true,"foo":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"bar":true,"foo":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"bar":123,"foo":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "foo"
json: error: <stdin>:1:2: {"bar":123,"foo":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"bar":123,"foo":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"bar":"foo","foo":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "foo"
json: error: <stdin>:1:2: {"bar":"foo","foo":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"bar":"foo","foo":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"bar":{},"foo":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "foo"
json: error: <stdin>:1:2: {"bar":{},"foo":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"bar":{},"foo":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"bar":[],"foo":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "foo"
json: error: <stdin>:1:2: {"bar":[],"foo":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"bar":[],"foo":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"bar":null,"foo":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "foo"
json: error: <stdin>:1:2: {"bar":null,"foo":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"bar":null,"foo":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"bar":false,"foo":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "foo"
json: error: <stdin>:1:2: {"bar":false,"foo":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"bar":false,"foo":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"bar":true,"foo":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "foo"
json: error: <stdin>:1:2: {"bar":true,"foo":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"bar":true,"foo":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"bar":123,"foo":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "foo"
json: error: <stdin>:1:2: {"bar":123,"foo":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"bar":123,"foo":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"bar":"foo","foo":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "foo"
json: error: <stdin>:1:2: {"bar":"foo","foo":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"bar":"foo","foo":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"bar":{},"foo":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "foo"
json: error: <stdin>:1:2: {"bar":{},"foo":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"bar":{},"foo":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"bar":[],"foo":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "foo"
json: error: <stdin>:1:2: {"bar":[],"foo":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"bar":[],"foo":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"bar":null,"foo":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "foo"
json: error: <stdin>:1:2: {"bar":null,"foo":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"bar":null,"foo":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"bar":false,"foo":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "foo"
json: error: <stdin>:1:2: {"bar":false,"foo":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"bar":false,"foo":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"bar":true,"foo":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "foo"
json: error: <stdin>:1:2: {"bar":true,"foo":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"bar":true,"foo":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"bar":123,"foo":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "foo"
json: error: <stdin>:1:2: {"bar":123,"foo":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"bar":123,"foo":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"bar":"foo","foo":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "foo"
json: error: <stdin>:1:2: {"bar":"foo","foo":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"bar":"foo","foo":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"bar":{},"foo":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "foo"
json: error: <stdin>:1:2: {"bar":{},"foo":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"bar":{},"foo":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"bar":[],"foo":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "foo"
json: error: <stdin>:1:2: {"bar":[],"foo":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"bar":[],"foo":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"bar":null,"foo":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "foo"
json: error: <stdin>:1:2: {"bar":null,"foo":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"bar":null,"foo":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"bar":false,"foo":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "foo"
json: error: <stdin>:1:2: {"bar":false,"foo":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"bar":false,"foo":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"bar":true,"foo":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "foo"
json: error: <stdin>:1:2: {"bar":true,"foo":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"bar":true,"foo":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"bar":123,"foo":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "foo"
json: error: <stdin>:1:2: {"bar":123,"foo":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"bar":123,"foo":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"bar":"foo","foo":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "foo"
json: error: <stdin>:1:2: {"bar":"foo","foo":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"bar":"foo","foo":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"bar":{},"foo":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "foo"
json: error: <stdin>:1:2: {"bar":{},"foo":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"bar":{},"foo":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"bar":[],"foo":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "foo"
json: error: <stdin>:1:2: {"bar":[],"foo":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"bar":[],"foo":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"bar":null,"foo":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "foo"
json: error: <stdin>:1:2: {"bar":null,"foo":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"bar":null,"foo":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"bar":false,"foo":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "foo"
json: error: <stdin>:1:2: {"bar":false,"foo":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"bar":false,"foo":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"bar":true,"foo":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "foo"
json: error: <stdin>:1:2: {"bar":true,"foo":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"bar":true,"foo":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"bar":123,"foo":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "foo"
json: error: <stdin>:1:2: {"bar":123,"foo":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"bar":123,"foo":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"bar":"foo","foo":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "foo"
json: error: <stdin>:1:2: {"bar":"foo","foo":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"bar":"foo","foo":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"bar":{},"foo":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "foo"
json: error: <stdin>:1:2: {"bar":{},"foo":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"bar":{},"foo":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"bar":[],"foo":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "foo"
json: error: <stdin>:1:2: {"bar":[],"foo":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"bar":[],"foo":null}'\'''
) -L dict5.new <(
echo '$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'
export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes 2>&1 ||
echo 'command failed: export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"bar":null,"foo":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"type"}]}' <<< '{"bar":null,"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"bar":null,"foo":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"bar":false,"foo":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"type"}]}' <<< '{"bar":false,"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"bar":false,"foo":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"bar":true,"foo":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"type"}]}' <<< '{"bar":true,"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"bar":true,"foo":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"bar":123,"foo":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"type"}]}' <<< '{"bar":123,"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"bar":123,"foo":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"bar":"foo","foo":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"type"}]}' <<< '{"bar":"foo","foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"bar":"foo","foo":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"bar":{},"foo":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"type"}]}' <<< '{"bar":{},"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"bar":{},"foo":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"bar":[],"foo":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"type"}]}' <<< '{"bar":[],"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"bar":[],"foo":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"null"}]}' <<< '{"bar":null,"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"bar":false,"foo":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"null"}]}' <<< '{"bar":false,"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"bar":false,"foo":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"bar":true,"foo":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"null"}]}' <<< '{"bar":true,"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"bar":true,"foo":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"bar":123,"foo":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"null"}]}' <<< '{"bar":123,"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"bar":123,"foo":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"bar":"foo","foo":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"null"}]}' <<< '{"bar":"foo","foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"bar":"foo","foo":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"bar":{},"foo":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"null"}]}' <<< '{"bar":{},"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"bar":{},"foo":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"bar":[],"foo":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"null"}]}' <<< '{"bar":[],"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"bar":[],"foo":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"bar":null,"foo":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"boolean"}]}' <<< '{"bar":null,"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"bar":null,"foo":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"bar":false,"foo":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"boolean"}]}' <<< '{"bar":false,"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"bar":false,"foo":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"bar":true,"foo":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"boolean"}]}' <<< '{"bar":true,"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"bar":true,"foo":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"bar":123,"foo":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"boolean"}]}' <<< '{"bar":123,"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"bar":123,"foo":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"bar":"foo","foo":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"boolean"}]}' <<< '{"bar":"foo","foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"bar":"foo","foo":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"bar":{},"foo":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"boolean"}]}' <<< '{"bar":{},"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"bar":{},"foo":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"bar":[],"foo":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"boolean"}]}' <<< '{"bar":[],"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"bar":[],"foo":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"bar":null,"foo":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"number"}]}' <<< '{"bar":null,"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"bar":null,"foo":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"bar":false,"foo":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"number"}]}' <<< '{"bar":false,"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"bar":false,"foo":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"bar":true,"foo":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"number"}]}' <<< '{"bar":true,"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"bar":true,"foo":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"bar":123,"foo":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"number"}]}' <<< '{"bar":123,"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"bar":123,"foo":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"bar":"foo","foo":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"number"}]}' <<< '{"bar":"foo","foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"bar":"foo","foo":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"bar":{},"foo":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"number"}]}' <<< '{"bar":{},"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"bar":{},"foo":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"bar":[],"foo":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"number"}]}' <<< '{"bar":[],"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"bar":[],"foo":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"bar":null,"foo":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"string"}]}' <<< '{"bar":null,"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"bar":null,"foo":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"bar":false,"foo":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"string"}]}' <<< '{"bar":false,"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"bar":false,"foo":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"bar":true,"foo":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"string"}]}' <<< '{"bar":true,"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"bar":true,"foo":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"bar":123,"foo":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"string"}]}' <<< '{"bar":123,"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"bar":123,"foo":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"bar":"foo","foo":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"string"}]}' <<< '{"bar":"foo","foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"bar":"foo","foo":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"bar":{},"foo":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"string"}]}' <<< '{"bar":{},"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"bar":{},"foo":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"bar":[],"foo":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"string"}]}' <<< '{"bar":[],"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"bar":[],"foo":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"bar":null,"foo":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"object"}]}' <<< '{"bar":null,"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"bar":null,"foo":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"bar":false,"foo":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"object"}]}' <<< '{"bar":false,"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"bar":false,"foo":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"bar":true,"foo":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"object"}]}' <<< '{"bar":true,"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"bar":true,"foo":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"bar":123,"foo":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"object"}]}' <<< '{"bar":123,"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"bar":123,"foo":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"bar":"foo","foo":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"object"}]}' <<< '{"bar":"foo","foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"bar":"foo","foo":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"bar":{},"foo":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"object"}]}' <<< '{"bar":{},"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"bar":{},"foo":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"bar":[],"foo":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"object"}]}' <<< '{"bar":[],"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"bar":[],"foo":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"bar":null,"foo":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"array"}]}' <<< '{"bar":null,"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"bar":null,"foo":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"bar":false,"foo":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"array"}]}' <<< '{"bar":false,"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"bar":false,"foo":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"bar":true,"foo":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"array"}]}' <<< '{"bar":true,"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"bar":true,"foo":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"bar":123,"foo":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"array"}]}' <<< '{"bar":123,"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"bar":123,"foo":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"bar":"foo","foo":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"array"}]}' <<< '{"bar":"foo","foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"bar":"foo","foo":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"bar":{},"foo":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"array"}]}' <<< '{"bar":{},"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"bar":{},"foo":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"bar":[],"foo":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"array"}]}' <<< '{"bar":[],"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"bar":[],"foo":null}'\'''
)

