#!/bin/bash

# Copyright (C) 2016, 2017, 2018  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-checker:dict3
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L dict3.old <(echo \
'$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes
$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":null}'\''
{"foo":null}
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":false}'\''
{"foo":false}
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":true}'\''
{"foo":true}
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":123}'\''
{"foo":123}
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":"foo"}'\''
{"foo":"foo"}
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":{}}'\''
{"foo":{}}
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":{"foo":null}}'\''
{"foo":{"foo":null}}
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":{"foo":false,"bar":123}}'\''
{"foo":{"foo":false,"bar":123}}
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":{"foo":{},"bar":[]}}'\''
{"foo":{"foo":{},"bar":[]}}
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":{"foo":{"bar":{"baz":[]}}}}'\''
{"foo":{"foo":{"bar":{"baz":[]}}}}
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":[]}'\''
{"foo":[]}
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":[null]}'\''
{"foo":[null]}
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":[false]}'\''
{"foo":[false]}
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":[456]}'\''
{"foo":[456]}
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":[""]}'\''
{"foo":[""]}
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":[{}]}'\''
{"foo":[{}]}
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":[{"foo":null}]}'\''
{"foo":[{"foo":null}]}
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":[{"foo":null,"bar":false}]}'\''
{"foo":[{"foo":null,"bar":false}]}
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":[{"foo":[],"bar":{}}]}'\''
{"foo":[{"foo":[],"bar":{}}]}
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":[[]]}'\''
{"foo":[[]]}
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":[[],[]]}'\''
{"foo":[[],[]]}
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":null}'\''
{"foo":null}
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"foo":false}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":false}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"foo":true}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":true}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"foo":123}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":123}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":"foo"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"foo":"foo"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":"foo"}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"foo":{}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":{}}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":{"foo":null}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"foo":{"foo":null}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":{"foo":null}}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":{"foo":false,"bar":123}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"foo":{"foo":false,"bar":123}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":{"foo":false,"bar":123}}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":{"foo":{},"bar":[]}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"foo":{"foo":{},"bar":[]}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":{"foo":{},"bar":[]}}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":{"foo":{"bar":{"baz":[]}}}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"foo":{"foo":{"bar":{"baz":[]}}}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":{"foo":{"bar":{"baz":[]}}}}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"foo":[]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":[]}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":[null]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"foo":[null]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":[null]}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":[false]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"foo":[false]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":[false]}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":[456]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"foo":[456]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":[456]}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":[""]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"foo":[""]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":[""]}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":[{}]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"foo":[{}]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":[{}]}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":[{"foo":null}]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"foo":[{"foo":null}]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":[{"foo":null}]}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":[{"foo":null,"bar":false}]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"foo":[{"foo":null,"bar":false}]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":[{"foo":null,"bar":false}]}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":[{"foo":[],"bar":{}}]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"foo":[{"foo":[],"bar":{}}]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":[{"foo":[],"bar":{}}]}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":[[]]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"foo":[[]]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":[[]]}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":[[],[]]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"foo":[[],[]]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":[[],[]]}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"foo":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":false}'\''
{"foo":false}
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":true}'\''
{"foo":true}
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"foo":123}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":123}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":"foo"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"foo":"foo"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":"foo"}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"foo":{}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":{}}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":{"foo":null}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"foo":{"foo":null}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":{"foo":null}}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":{"foo":false,"bar":123}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"foo":{"foo":false,"bar":123}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":{"foo":false,"bar":123}}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":{"foo":{},"bar":[]}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"foo":{"foo":{},"bar":[]}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":{"foo":{},"bar":[]}}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":{"foo":{"bar":{"baz":[]}}}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"foo":{"foo":{"bar":{"baz":[]}}}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":{"foo":{"bar":{"baz":[]}}}}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"foo":[]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":[]}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":[null]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"foo":[null]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":[null]}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":[false]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"foo":[false]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":[false]}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":[456]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"foo":[456]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":[456]}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":[""]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"foo":[""]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":[""]}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":[{}]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"foo":[{}]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":[{}]}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":[{"foo":null}]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"foo":[{"foo":null}]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":[{"foo":null}]}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":[{"foo":null,"bar":false}]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"foo":[{"foo":null,"bar":false}]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":[{"foo":null,"bar":false}]}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":[{"foo":[],"bar":{}}]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"foo":[{"foo":[],"bar":{}}]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":[{"foo":[],"bar":{}}]}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":[[]]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"foo":[[]]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":[[]]}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":[[],[]]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"foo":[[],[]]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":[[],[]]}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"foo":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"foo":false}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":false}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"foo":true}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":true}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":123}'\''
{"foo":123}
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":"foo"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"foo":"foo"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":"foo"}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"foo":{}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":{}}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":{"foo":null}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"foo":{"foo":null}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":{"foo":null}}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":{"foo":false,"bar":123}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"foo":{"foo":false,"bar":123}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":{"foo":false,"bar":123}}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":{"foo":{},"bar":[]}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"foo":{"foo":{},"bar":[]}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":{"foo":{},"bar":[]}}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":{"foo":{"bar":{"baz":[]}}}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"foo":{"foo":{"bar":{"baz":[]}}}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":{"foo":{"bar":{"baz":[]}}}}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"foo":[]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":[]}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":[null]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"foo":[null]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":[null]}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":[false]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"foo":[false]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":[false]}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":[456]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"foo":[456]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":[456]}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":[""]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"foo":[""]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":[""]}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":[{}]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"foo":[{}]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":[{}]}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":[{"foo":null}]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"foo":[{"foo":null}]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":[{"foo":null}]}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":[{"foo":null,"bar":false}]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"foo":[{"foo":null,"bar":false}]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":[{"foo":null,"bar":false}]}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":[{"foo":[],"bar":{}}]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"foo":[{"foo":[],"bar":{}}]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":[{"foo":[],"bar":{}}]}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":[[]]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"foo":[[]]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":[[]]}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":[[],[]]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"foo":[[],[]]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":[[],[]]}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"foo":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"foo":false}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":false}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"foo":true}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":true}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"foo":123}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":123}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":"foo"}'\''
{"foo":"foo"}
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"foo":{}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":{}}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":{"foo":null}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"foo":{"foo":null}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":{"foo":null}}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":{"foo":false,"bar":123}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"foo":{"foo":false,"bar":123}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":{"foo":false,"bar":123}}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":{"foo":{},"bar":[]}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"foo":{"foo":{},"bar":[]}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":{"foo":{},"bar":[]}}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":{"foo":{"bar":{"baz":[]}}}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"foo":{"foo":{"bar":{"baz":[]}}}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":{"foo":{"bar":{"baz":[]}}}}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"foo":[]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":[]}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":[null]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"foo":[null]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":[null]}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":[false]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"foo":[false]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":[false]}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":[456]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"foo":[456]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":[456]}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":[""]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"foo":[""]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":[""]}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":[{}]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"foo":[{}]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":[{}]}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":[{"foo":null}]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"foo":[{"foo":null}]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":[{"foo":null}]}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":[{"foo":null,"bar":false}]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"foo":[{"foo":null,"bar":false}]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":[{"foo":null,"bar":false}]}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":[{"foo":[],"bar":{}}]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"foo":[{"foo":[],"bar":{}}]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":[{"foo":[],"bar":{}}]}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":[[]]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"foo":[[]]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":[[]]}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":[[],[]]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"foo":[[],[]]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":[[],[]]}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"foo":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"foo":false}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":false}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"foo":true}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":true}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"foo":123}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":123}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":"foo"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"foo":"foo"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":"foo"}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":{}}'\''
{"foo":{}}
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":{"foo":null}}'\''
{"foo":{"foo":null}}
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":{"foo":false,"bar":123}}'\''
{"foo":{"foo":false,"bar":123}}
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":{"foo":{},"bar":[]}}'\''
{"foo":{"foo":{},"bar":[]}}
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":{"foo":{"bar":{"baz":[]}}}}'\''
{"foo":{"foo":{"bar":{"baz":[]}}}}
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"foo":[]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":[]}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":[null]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"foo":[null]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":[null]}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":[false]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"foo":[false]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":[false]}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":[456]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"foo":[456]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":[456]}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":[""]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"foo":[""]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":[""]}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":[{}]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"foo":[{}]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":[{}]}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":[{"foo":null}]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"foo":[{"foo":null}]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":[{"foo":null}]}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":[{"foo":null,"bar":false}]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"foo":[{"foo":null,"bar":false}]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":[{"foo":null,"bar":false}]}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":[{"foo":[],"bar":{}}]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"foo":[{"foo":[],"bar":{}}]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":[{"foo":[],"bar":{}}]}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":[[]]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"foo":[[]]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":[[]]}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":[[],[]]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"foo":[[],[]]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":[[],[]]}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"foo":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"foo":false}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":false}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"foo":true}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":true}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"foo":123}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":123}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":"foo"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"foo":"foo"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":"foo"}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"foo":{}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":{}}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":{"foo":null}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"foo":{"foo":null}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":{"foo":null}}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":{"foo":false,"bar":123}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"foo":{"foo":false,"bar":123}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":{"foo":false,"bar":123}}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":{"foo":{},"bar":[]}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"foo":{"foo":{},"bar":[]}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":{"foo":{},"bar":[]}}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":{"foo":{"bar":{"baz":[]}}}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"foo":{"foo":{"bar":{"baz":[]}}}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":{"foo":{"bar":{"baz":[]}}}}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":[]}'\''
{"foo":[]}
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":[null]}'\''
{"foo":[null]}
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":[false]}'\''
{"foo":[false]}
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":[456]}'\''
{"foo":[456]}
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":[""]}'\''
{"foo":[""]}
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":[{}]}'\''
{"foo":[{}]}
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":[{"foo":null}]}'\''
{"foo":[{"foo":null}]}
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":[{"foo":null,"bar":false}]}'\''
{"foo":[{"foo":null,"bar":false}]}
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":[{"foo":[],"bar":{}}]}'\''
{"foo":[{"foo":[],"bar":{}}]}
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":[[]]}'\''
{"foo":[[]]}
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":[[],[]]}'\''
{"foo":[[],[]]}'
) -L dict3.new <(
echo '$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'
export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes 2>&1 ||
echo 'command failed: export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"type"}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"type"}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"type"}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"type"}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":"foo"}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"type"}]}' <<< '{"foo":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":"foo"}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"type"}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":{"foo":null}}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"type"}]}' <<< '{"foo":{"foo":null}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":{"foo":null}}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":{"foo":false,"bar":123}}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"type"}]}' <<< '{"foo":{"foo":false,"bar":123}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":{"foo":false,"bar":123}}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":{"foo":{},"bar":[]}}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"type"}]}' <<< '{"foo":{"foo":{},"bar":[]}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":{"foo":{},"bar":[]}}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":{"foo":{"bar":{"baz":[]}}}}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"type"}]}' <<< '{"foo":{"foo":{"bar":{"baz":[]}}}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":{"foo":{"bar":{"baz":[]}}}}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"type"}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":[null]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"type"}]}' <<< '{"foo":[null]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":[null]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":[false]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"type"}]}' <<< '{"foo":[false]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":[false]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":[456]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"type"}]}' <<< '{"foo":[456]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":[456]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":[""]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"type"}]}' <<< '{"foo":[""]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":[""]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":[{}]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"type"}]}' <<< '{"foo":[{}]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":[{}]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":[{"foo":null}]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"type"}]}' <<< '{"foo":[{"foo":null}]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":[{"foo":null}]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":[{"foo":null,"bar":false}]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"type"}]}' <<< '{"foo":[{"foo":null,"bar":false}]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":[{"foo":null,"bar":false}]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":[{"foo":[],"bar":{}}]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"type"}]}' <<< '{"foo":[{"foo":[],"bar":{}}]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":[{"foo":[],"bar":{}}]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":[[]]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"type"}]}' <<< '{"foo":[[]]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":[[]]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":[[],[]]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"type"}]}' <<< '{"foo":[[],[]]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":[[],[]]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"null"}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"null"}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"null"}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"null"}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":"foo"}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"null"}]}' <<< '{"foo":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":"foo"}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"null"}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":{"foo":null}}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"null"}]}' <<< '{"foo":{"foo":null}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":{"foo":null}}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":{"foo":false,"bar":123}}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"null"}]}' <<< '{"foo":{"foo":false,"bar":123}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":{"foo":false,"bar":123}}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":{"foo":{},"bar":[]}}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"null"}]}' <<< '{"foo":{"foo":{},"bar":[]}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":{"foo":{},"bar":[]}}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":{"foo":{"bar":{"baz":[]}}}}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"null"}]}' <<< '{"foo":{"foo":{"bar":{"baz":[]}}}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":{"foo":{"bar":{"baz":[]}}}}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"null"}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":[null]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"null"}]}' <<< '{"foo":[null]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":[null]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":[false]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"null"}]}' <<< '{"foo":[false]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":[false]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":[456]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"null"}]}' <<< '{"foo":[456]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":[456]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":[""]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"null"}]}' <<< '{"foo":[""]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":[""]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":[{}]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"null"}]}' <<< '{"foo":[{}]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":[{}]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":[{"foo":null}]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"null"}]}' <<< '{"foo":[{"foo":null}]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":[{"foo":null}]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":[{"foo":null,"bar":false}]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"null"}]}' <<< '{"foo":[{"foo":null,"bar":false}]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":[{"foo":null,"bar":false}]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":[{"foo":[],"bar":{}}]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"null"}]}' <<< '{"foo":[{"foo":[],"bar":{}}]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":[{"foo":[],"bar":{}}]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":[[]]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"null"}]}' <<< '{"foo":[[]]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":[[]]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":[[],[]]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"null"}]}' <<< '{"foo":[[],[]]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":[[],[]]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"boolean"}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"boolean"}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"boolean"}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"boolean"}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":"foo"}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"boolean"}]}' <<< '{"foo":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":"foo"}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"boolean"}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":{"foo":null}}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"boolean"}]}' <<< '{"foo":{"foo":null}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":{"foo":null}}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":{"foo":false,"bar":123}}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"boolean"}]}' <<< '{"foo":{"foo":false,"bar":123}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":{"foo":false,"bar":123}}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":{"foo":{},"bar":[]}}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"boolean"}]}' <<< '{"foo":{"foo":{},"bar":[]}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":{"foo":{},"bar":[]}}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":{"foo":{"bar":{"baz":[]}}}}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"boolean"}]}' <<< '{"foo":{"foo":{"bar":{"baz":[]}}}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":{"foo":{"bar":{"baz":[]}}}}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"boolean"}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":[null]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"boolean"}]}' <<< '{"foo":[null]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":[null]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":[false]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"boolean"}]}' <<< '{"foo":[false]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":[false]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":[456]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"boolean"}]}' <<< '{"foo":[456]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":[456]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":[""]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"boolean"}]}' <<< '{"foo":[""]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":[""]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":[{}]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"boolean"}]}' <<< '{"foo":[{}]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":[{}]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":[{"foo":null}]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"boolean"}]}' <<< '{"foo":[{"foo":null}]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":[{"foo":null}]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":[{"foo":null,"bar":false}]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"boolean"}]}' <<< '{"foo":[{"foo":null,"bar":false}]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":[{"foo":null,"bar":false}]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":[{"foo":[],"bar":{}}]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"boolean"}]}' <<< '{"foo":[{"foo":[],"bar":{}}]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":[{"foo":[],"bar":{}}]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":[[]]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"boolean"}]}' <<< '{"foo":[[]]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":[[]]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":[[],[]]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"boolean"}]}' <<< '{"foo":[[],[]]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":[[],[]]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"number"}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"number"}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"number"}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"number"}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":"foo"}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"number"}]}' <<< '{"foo":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":"foo"}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"number"}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":{"foo":null}}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"number"}]}' <<< '{"foo":{"foo":null}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":{"foo":null}}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":{"foo":false,"bar":123}}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"number"}]}' <<< '{"foo":{"foo":false,"bar":123}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":{"foo":false,"bar":123}}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":{"foo":{},"bar":[]}}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"number"}]}' <<< '{"foo":{"foo":{},"bar":[]}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":{"foo":{},"bar":[]}}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":{"foo":{"bar":{"baz":[]}}}}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"number"}]}' <<< '{"foo":{"foo":{"bar":{"baz":[]}}}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":{"foo":{"bar":{"baz":[]}}}}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"number"}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":[null]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"number"}]}' <<< '{"foo":[null]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":[null]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":[false]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"number"}]}' <<< '{"foo":[false]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":[false]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":[456]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"number"}]}' <<< '{"foo":[456]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":[456]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":[""]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"number"}]}' <<< '{"foo":[""]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":[""]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":[{}]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"number"}]}' <<< '{"foo":[{}]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":[{}]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":[{"foo":null}]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"number"}]}' <<< '{"foo":[{"foo":null}]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":[{"foo":null}]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":[{"foo":null,"bar":false}]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"number"}]}' <<< '{"foo":[{"foo":null,"bar":false}]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":[{"foo":null,"bar":false}]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":[{"foo":[],"bar":{}}]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"number"}]}' <<< '{"foo":[{"foo":[],"bar":{}}]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":[{"foo":[],"bar":{}}]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":[[]]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"number"}]}' <<< '{"foo":[[]]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":[[]]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":[[],[]]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"number"}]}' <<< '{"foo":[[],[]]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":[[],[]]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"string"}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"string"}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"string"}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"string"}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":"foo"}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"string"}]}' <<< '{"foo":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":"foo"}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"string"}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":{"foo":null}}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"string"}]}' <<< '{"foo":{"foo":null}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":{"foo":null}}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":{"foo":false,"bar":123}}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"string"}]}' <<< '{"foo":{"foo":false,"bar":123}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":{"foo":false,"bar":123}}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":{"foo":{},"bar":[]}}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"string"}]}' <<< '{"foo":{"foo":{},"bar":[]}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":{"foo":{},"bar":[]}}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":{"foo":{"bar":{"baz":[]}}}}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"string"}]}' <<< '{"foo":{"foo":{"bar":{"baz":[]}}}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":{"foo":{"bar":{"baz":[]}}}}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"string"}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":[null]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"string"}]}' <<< '{"foo":[null]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":[null]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":[false]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"string"}]}' <<< '{"foo":[false]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":[false]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":[456]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"string"}]}' <<< '{"foo":[456]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":[456]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":[""]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"string"}]}' <<< '{"foo":[""]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":[""]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":[{}]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"string"}]}' <<< '{"foo":[{}]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":[{}]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":[{"foo":null}]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"string"}]}' <<< '{"foo":[{"foo":null}]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":[{"foo":null}]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":[{"foo":null,"bar":false}]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"string"}]}' <<< '{"foo":[{"foo":null,"bar":false}]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":[{"foo":null,"bar":false}]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":[{"foo":[],"bar":{}}]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"string"}]}' <<< '{"foo":[{"foo":[],"bar":{}}]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":[{"foo":[],"bar":{}}]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":[[]]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"string"}]}' <<< '{"foo":[[]]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":[[]]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":[[],[]]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"string"}]}' <<< '{"foo":[[],[]]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":[[],[]]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"object"}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"object"}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"object"}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"object"}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":"foo"}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"object"}]}' <<< '{"foo":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":"foo"}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"object"}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":{"foo":null}}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"object"}]}' <<< '{"foo":{"foo":null}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":{"foo":null}}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":{"foo":false,"bar":123}}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"object"}]}' <<< '{"foo":{"foo":false,"bar":123}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":{"foo":false,"bar":123}}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":{"foo":{},"bar":[]}}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"object"}]}' <<< '{"foo":{"foo":{},"bar":[]}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":{"foo":{},"bar":[]}}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":{"foo":{"bar":{"baz":[]}}}}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"object"}]}' <<< '{"foo":{"foo":{"bar":{"baz":[]}}}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":{"foo":{"bar":{"baz":[]}}}}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"object"}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":[null]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"object"}]}' <<< '{"foo":[null]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":[null]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":[false]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"object"}]}' <<< '{"foo":[false]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":[false]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":[456]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"object"}]}' <<< '{"foo":[456]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":[456]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":[""]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"object"}]}' <<< '{"foo":[""]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":[""]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":[{}]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"object"}]}' <<< '{"foo":[{}]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":[{}]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":[{"foo":null}]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"object"}]}' <<< '{"foo":[{"foo":null}]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":[{"foo":null}]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":[{"foo":null,"bar":false}]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"object"}]}' <<< '{"foo":[{"foo":null,"bar":false}]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":[{"foo":null,"bar":false}]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":[{"foo":[],"bar":{}}]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"object"}]}' <<< '{"foo":[{"foo":[],"bar":{}}]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":[{"foo":[],"bar":{}}]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":[[]]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"object"}]}' <<< '{"foo":[[]]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":[[]]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":[[],[]]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"object"}]}' <<< '{"foo":[[],[]]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":[[],[]]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"array"}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"array"}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"array"}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"array"}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":"foo"}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"array"}]}' <<< '{"foo":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":"foo"}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"array"}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":{"foo":null}}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"array"}]}' <<< '{"foo":{"foo":null}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":{"foo":null}}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":{"foo":false,"bar":123}}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"array"}]}' <<< '{"foo":{"foo":false,"bar":123}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":{"foo":false,"bar":123}}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":{"foo":{},"bar":[]}}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"array"}]}' <<< '{"foo":{"foo":{},"bar":[]}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":{"foo":{},"bar":[]}}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":{"foo":{"bar":{"baz":[]}}}}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"array"}]}' <<< '{"foo":{"foo":{"bar":{"baz":[]}}}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":{"foo":{"bar":{"baz":[]}}}}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"array"}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":[null]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"array"}]}' <<< '{"foo":[null]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":[null]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":[false]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"array"}]}' <<< '{"foo":[false]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":[false]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":[456]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"array"}]}' <<< '{"foo":[456]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":[456]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":[""]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"array"}]}' <<< '{"foo":[""]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":[""]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":[{}]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"array"}]}' <<< '{"foo":[{}]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":[{}]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":[{"foo":null}]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"array"}]}' <<< '{"foo":[{"foo":null}]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":[{"foo":null}]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":[{"foo":null,"bar":false}]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"array"}]}' <<< '{"foo":[{"foo":null,"bar":false}]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":[{"foo":null,"bar":false}]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":[{"foo":[],"bar":{}}]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"array"}]}' <<< '{"foo":[{"foo":[],"bar":{}}]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":[{"foo":[],"bar":{}}]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":[[]]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"array"}]}' <<< '{"foo":[[]]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":[[]]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":[[],[]]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"array"}]}' <<< '{"foo":[[],[]]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":[[],[]]}'\'''
)

