#!/bin/bash

# Copyright (C) 2016, 2017, 2018  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-checker-list:list-open-array-plain-val-array-basic-basic
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L list-open-array-plain-val-array-basic-basic.old <(echo \
'$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes
$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }
$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":null}}]}'\'' <<< '\''[null,null]'\''
[null,null]
$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":null}}]}'\'' <<< '\''[null,false]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:7: [null,false]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":null}}]}'\'' <<< '\''[null,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":null}}]}'\'' <<< '\''[null,true]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:7: [null,true]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":null}}]}'\'' <<< '\''[null,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":null}}]}'\'' <<< '\''[null,123]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:7: [null,123]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":null}}]}'\'' <<< '\''[null,123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":null}}]}'\'' <<< '\''[null,456]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:7: [null,456]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":null}}]}'\'' <<< '\''[null,456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":null}}]}'\'' <<< '\''[null,"foo"]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:7: [null,"foo"]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":null}}]}'\'' <<< '\''[null,"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":null}}]}'\'' <<< '\''[null,"bar"]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:7: [null,"bar"]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":null}}]}'\'' <<< '\''[null,"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":null}}]}'\'' <<< '\''[null,{}]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:7: [null,{}]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":null}}]}'\'' <<< '\''[null,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":null}}]}'\'' <<< '\''[null,[]]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:7: [null,[]]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":null}}]}'\'' <<< '\''[null,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":false}}]}'\'' <<< '\''[false,null]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: [false,null]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":false}}]}'\'' <<< '\''[false,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":false}}]}'\'' <<< '\''[false,false]'\''
[false,false]
$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":false}}]}'\'' <<< '\''[false,true]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: [false,true]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":false}}]}'\'' <<< '\''[false,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":false}}]}'\'' <<< '\''[false,123]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: [false,123]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":false}}]}'\'' <<< '\''[false,123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":false}}]}'\'' <<< '\''[false,456]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: [false,456]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":false}}]}'\'' <<< '\''[false,456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":false}}]}'\'' <<< '\''[false,"foo"]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: [false,"foo"]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":false}}]}'\'' <<< '\''[false,"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":false}}]}'\'' <<< '\''[false,"bar"]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: [false,"bar"]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":false}}]}'\'' <<< '\''[false,"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":false}}]}'\'' <<< '\''[false,{}]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: [false,{}]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":false}}]}'\'' <<< '\''[false,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":false}}]}'\'' <<< '\''[false,[]]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: [false,[]]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":false}}]}'\'' <<< '\''[false,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":true}}]}'\'' <<< '\''[true,null]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:7: [true,null]
json: error: <stdin>:1:7:       ^
[true,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":true}}]}'\'' <<< '\''[true,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":true}}]}'\'' <<< '\''[true,false]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:7: [true,false]
json: error: <stdin>:1:7:       ^
[true,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":true}}]}'\'' <<< '\''[true,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":true}}]}'\'' <<< '\''[true,true]'\''
[true,true]
$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":true}}]}'\'' <<< '\''[true,123]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:7: [true,123]
json: error: <stdin>:1:7:       ^
[true,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":true}}]}'\'' <<< '\''[true,123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":true}}]}'\'' <<< '\''[true,456]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:7: [true,456]
json: error: <stdin>:1:7:       ^
[true,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":true}}]}'\'' <<< '\''[true,456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":true}}]}'\'' <<< '\''[true,"foo"]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:7: [true,"foo"]
json: error: <stdin>:1:7:       ^
[true,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":true}}]}'\'' <<< '\''[true,"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":true}}]}'\'' <<< '\''[true,"bar"]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:7: [true,"bar"]
json: error: <stdin>:1:7:       ^
[true,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":true}}]}'\'' <<< '\''[true,"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":true}}]}'\'' <<< '\''[true,{}]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:7: [true,{}]
json: error: <stdin>:1:7:       ^
[true,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":true}}]}'\'' <<< '\''[true,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":true}}]}'\'' <<< '\''[true,[]]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:7: [true,[]]
json: error: <stdin>:1:7:       ^
[true,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":true}}]}'\'' <<< '\''[true,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":123}}]}'\'' <<< '\''[123,null]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:6: [123,null]
json: error: <stdin>:1:6:      ^
[123,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":123}}]}'\'' <<< '\''[123,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":123}}]}'\'' <<< '\''[123,false]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:6: [123,false]
json: error: <stdin>:1:6:      ^
[123,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":123}}]}'\'' <<< '\''[123,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":123}}]}'\'' <<< '\''[123,true]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:6: [123,true]
json: error: <stdin>:1:6:      ^
[123,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":123}}]}'\'' <<< '\''[123,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":123}}]}'\'' <<< '\''[123,123]'\''
[123,123]
$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":123}}]}'\'' <<< '\''[123,456]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:6: [123,456]
json: error: <stdin>:1:6:      ^
[123,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":123}}]}'\'' <<< '\''[123,456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":123}}]}'\'' <<< '\''[123,"foo"]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:6: [123,"foo"]
json: error: <stdin>:1:6:      ^
[123,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":123}}]}'\'' <<< '\''[123,"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":123}}]}'\'' <<< '\''[123,"bar"]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:6: [123,"bar"]
json: error: <stdin>:1:6:      ^
[123,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":123}}]}'\'' <<< '\''[123,"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":123}}]}'\'' <<< '\''[123,{}]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:6: [123,{}]
json: error: <stdin>:1:6:      ^
[123,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":123}}]}'\'' <<< '\''[123,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":123}}]}'\'' <<< '\''[123,[]]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:6: [123,[]]
json: error: <stdin>:1:6:      ^
[123,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":123}}]}'\'' <<< '\''[123,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":"foo"}}]}'\'' <<< '\''["foo",null]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:8: ["foo",null]
json: error: <stdin>:1:8:        ^
["foo",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":"foo"}}]}'\'' <<< '\''["foo",null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":"foo"}}]}'\'' <<< '\''["foo",false]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:8: ["foo",false]
json: error: <stdin>:1:8:        ^
["foo",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":"foo"}}]}'\'' <<< '\''["foo",false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":"foo"}}]}'\'' <<< '\''["foo",true]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:8: ["foo",true]
json: error: <stdin>:1:8:        ^
["foo",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":"foo"}}]}'\'' <<< '\''["foo",true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":"foo"}}]}'\'' <<< '\''["foo",123]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:8: ["foo",123]
json: error: <stdin>:1:8:        ^
["foo",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":"foo"}}]}'\'' <<< '\''["foo",123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":"foo"}}]}'\'' <<< '\''["foo",456]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:8: ["foo",456]
json: error: <stdin>:1:8:        ^
["foo",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":"foo"}}]}'\'' <<< '\''["foo",456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":"foo"}}]}'\'' <<< '\''["foo","foo"]'\''
["foo","foo"]
$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":"foo"}}]}'\'' <<< '\''["foo","bar"]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:8: ["foo","bar"]
json: error: <stdin>:1:8:        ^
["foo",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":"foo"}}]}'\'' <<< '\''["foo","bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":"foo"}}]}'\'' <<< '\''["foo",{}]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:8: ["foo",{}]
json: error: <stdin>:1:8:        ^
["foo",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":"foo"}}]}'\'' <<< '\''["foo",{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":"foo"}}]}'\'' <<< '\''["foo",[]]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:8: ["foo",[]]
json: error: <stdin>:1:8:        ^
["foo",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":"foo"}}]}'\'' <<< '\''["foo",[]]'\'''
) -L list-open-array-plain-val-array-basic-basic.new <(
echo '$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'
export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes 2>&1 ||
echo 'command failed: export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":null}}]}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":{"plain":null}}]}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":null}}]}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":null}}]}'\'' <<< '\''[null,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":{"plain":null}}]}' <<< '[null,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":null}}]}'\'' <<< '\''[null,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":null}}]}'\'' <<< '\''[null,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":{"plain":null}}]}' <<< '[null,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":null}}]}'\'' <<< '\''[null,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":null}}]}'\'' <<< '\''[null,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":{"plain":null}}]}' <<< '[null,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":null}}]}'\'' <<< '\''[null,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":null}}]}'\'' <<< '\''[null,456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":{"plain":null}}]}' <<< '[null,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":null}}]}'\'' <<< '\''[null,456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":null}}]}'\'' <<< '\''[null,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":{"plain":null}}]}' <<< '[null,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":null}}]}'\'' <<< '\''[null,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":null}}]}'\'' <<< '\''[null,"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":{"plain":null}}]}' <<< '[null,"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":null}}]}'\'' <<< '\''[null,"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":null}}]}'\'' <<< '\''[null,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":{"plain":null}}]}' <<< '[null,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":null}}]}'\'' <<< '\''[null,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":null}}]}'\'' <<< '\''[null,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":{"plain":null}}]}' <<< '[null,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":null}}]}'\'' <<< '\''[null,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":false}}]}'\'' <<< '\''[false,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":{"plain":false}}]}' <<< '[false,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":false}}]}'\'' <<< '\''[false,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":false}}]}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":{"plain":false}}]}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":false}}]}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":false}}]}'\'' <<< '\''[false,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":{"plain":false}}]}' <<< '[false,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":false}}]}'\'' <<< '\''[false,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":false}}]}'\'' <<< '\''[false,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":{"plain":false}}]}' <<< '[false,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":false}}]}'\'' <<< '\''[false,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":false}}]}'\'' <<< '\''[false,456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":{"plain":false}}]}' <<< '[false,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":false}}]}'\'' <<< '\''[false,456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":false}}]}'\'' <<< '\''[false,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":{"plain":false}}]}' <<< '[false,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":false}}]}'\'' <<< '\''[false,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":false}}]}'\'' <<< '\''[false,"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":{"plain":false}}]}' <<< '[false,"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":false}}]}'\'' <<< '\''[false,"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":false}}]}'\'' <<< '\''[false,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":{"plain":false}}]}' <<< '[false,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":false}}]}'\'' <<< '\''[false,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":false}}]}'\'' <<< '\''[false,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":{"plain":false}}]}' <<< '[false,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":false}}]}'\'' <<< '\''[false,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":true}}]}'\'' <<< '\''[true,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":{"plain":true}}]}' <<< '[true,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":true}}]}'\'' <<< '\''[true,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":true}}]}'\'' <<< '\''[true,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":{"plain":true}}]}' <<< '[true,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":true}}]}'\'' <<< '\''[true,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":true}}]}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":{"plain":true}}]}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":true}}]}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":true}}]}'\'' <<< '\''[true,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":{"plain":true}}]}' <<< '[true,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":true}}]}'\'' <<< '\''[true,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":true}}]}'\'' <<< '\''[true,456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":{"plain":true}}]}' <<< '[true,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":true}}]}'\'' <<< '\''[true,456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":true}}]}'\'' <<< '\''[true,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":{"plain":true}}]}' <<< '[true,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":true}}]}'\'' <<< '\''[true,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":true}}]}'\'' <<< '\''[true,"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":{"plain":true}}]}' <<< '[true,"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":true}}]}'\'' <<< '\''[true,"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":true}}]}'\'' <<< '\''[true,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":{"plain":true}}]}' <<< '[true,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":true}}]}'\'' <<< '\''[true,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":true}}]}'\'' <<< '\''[true,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":{"plain":true}}]}' <<< '[true,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":true}}]}'\'' <<< '\''[true,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":123}}]}'\'' <<< '\''[123,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":{"plain":123}}]}' <<< '[123,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":123}}]}'\'' <<< '\''[123,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":123}}]}'\'' <<< '\''[123,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":{"plain":123}}]}' <<< '[123,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":123}}]}'\'' <<< '\''[123,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":123}}]}'\'' <<< '\''[123,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":{"plain":123}}]}' <<< '[123,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":123}}]}'\'' <<< '\''[123,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":123}}]}'\'' <<< '\''[123,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":{"plain":123}}]}' <<< '[123,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":123}}]}'\'' <<< '\''[123,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":123}}]}'\'' <<< '\''[123,456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":{"plain":123}}]}' <<< '[123,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":123}}]}'\'' <<< '\''[123,456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":123}}]}'\'' <<< '\''[123,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":{"plain":123}}]}' <<< '[123,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":123}}]}'\'' <<< '\''[123,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":123}}]}'\'' <<< '\''[123,"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":{"plain":123}}]}' <<< '[123,"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":123}}]}'\'' <<< '\''[123,"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":123}}]}'\'' <<< '\''[123,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":{"plain":123}}]}' <<< '[123,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":123}}]}'\'' <<< '\''[123,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":123}}]}'\'' <<< '\''[123,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":{"plain":123}}]}' <<< '[123,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":123}}]}'\'' <<< '\''[123,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":"foo"}}]}'\'' <<< '\''["foo",null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":{"plain":"foo"}}]}' <<< '["foo",null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":"foo"}}]}'\'' <<< '\''["foo",null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":"foo"}}]}'\'' <<< '\''["foo",false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":{"plain":"foo"}}]}' <<< '["foo",false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":"foo"}}]}'\'' <<< '\''["foo",false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":"foo"}}]}'\'' <<< '\''["foo",true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":{"plain":"foo"}}]}' <<< '["foo",true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":"foo"}}]}'\'' <<< '\''["foo",true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":"foo"}}]}'\'' <<< '\''["foo",123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":{"plain":"foo"}}]}' <<< '["foo",123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":"foo"}}]}'\'' <<< '\''["foo",123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":"foo"}}]}'\'' <<< '\''["foo",456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":{"plain":"foo"}}]}' <<< '["foo",456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":"foo"}}]}'\'' <<< '\''["foo",456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":"foo"}}]}'\'' <<< '\''["foo","foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":{"plain":"foo"}}]}' <<< '["foo","foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":"foo"}}]}'\'' <<< '\''["foo","foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":"foo"}}]}'\'' <<< '\''["foo","bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":{"plain":"foo"}}]}' <<< '["foo","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":"foo"}}]}'\'' <<< '\''["foo","bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":"foo"}}]}'\'' <<< '\''["foo",{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":{"plain":"foo"}}]}' <<< '["foo",{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":"foo"}}]}'\'' <<< '\''["foo",{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":"foo"}}]}'\'' <<< '\''["foo",[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":{"plain":"foo"}}]}' <<< '["foo",[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"plain":"foo"}}]}'\'' <<< '\''["foo",[]]'\'''
)

