#!/bin/bash

# Copyright (C) 2016, 2017, 2018  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-cases:80
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L 80.old <(echo \
'$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@" 2>&1|sed -r '\''/error:/s|(/dev/fd/)[0-9]+|\1??|'\''; }
$ json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"array",...}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"number"'\'' or `{"plain":1}'\'' or, otherwise, no value at all
json: error: <stdin>:1:2: [null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[0]'\''
[0]
$ json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[1]'\''
[1]
$ json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[2]'\''
[2]
$ json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"number"'\'' or `{"plain":1}'\'' or, otherwise, no value at all
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[0,null]'\''
json: error: <stdin>:1:4: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:4: [0,null]
json: error: <stdin>:1:4:    ^
[0,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[0,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[0,1]'\''
[0,1]
$ json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[0,2]'\''
[0,2]
$ json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[0,{}]'\''
json: error: <stdin>:1:4: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:4: [0,{}]
json: error: <stdin>:1:4:    ^
[0,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[0,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[1,null]'\''
json: error: <stdin>:1:4: type check error: type mismatch: expected a value of type `"number"'\'' or `{"plain":2}'\''
json: error: <stdin>:1:4: [1,null]
json: error: <stdin>:1:4:    ^
[1,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[1,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[1,0]'\''
[1,0]
$ json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[1,1]'\''
[1,1]
$ json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[1,2]'\''
[1,2]
$ json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[1,{}]'\''
json: error: <stdin>:1:4: type check error: type mismatch: expected a value of type `"number"'\'' or `{"plain":2}'\''
json: error: <stdin>:1:4: [1,{}]
json: error: <stdin>:1:4:    ^
[1,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[1,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[2,null]'\''
json: error: <stdin>:1:4: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:4: [2,null]
json: error: <stdin>:1:4:    ^
[2,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[2,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[2,0]'\''
[2,0]
$ json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[2,1]'\''
[2,1]
$ json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[2,2]'\''
[2,2]
$ json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[2,{}]'\''
json: error: <stdin>:1:4: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:4: [2,{}]
json: error: <stdin>:1:4:    ^
[2,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[2,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[1,2,null]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `"number"'\'' or `"object"'\''
json: error: <stdin>:1:6: [1,2,null]
json: error: <stdin>:1:6:      ^
[1,2,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[1,2,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[1,2,0]'\''
[1,2,0]
$ json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[1,2,1]'\''
[1,2,1]
$ json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[1,2,2]'\''
[1,2,2]
$ json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[1,2,{}]'\''
[1,2,{}]
$ json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[1,2,3,4]'\''
[1,2,3,4]
$ json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[1,2,{},null]'\''
json: error: <stdin>:1:8: type check error: too many arguments
json: error: <stdin>:1:8: [1,2,{},null]
json: error: <stdin>:1:8:        ^
[1,2,{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[1,2,{},null]'\'''
) -L 80.new <(
echo '$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@" 2>&1|sed -r '\''/error:/s|(/dev/fd/)[0-9]+|\1??|'\''; }'
json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@" 2>&1|sed -r '/error:/s|(/dev/fd/)[0-9]+|\1??|'; } 2>&1 ||
echo 'command failed: json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@" 2>&1|sed -r '\''/error:/s|(/dev/fd/)[0-9]+|\1??|'\''; }'

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[0]'\'''
json -d '{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}' <<< '[0]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[0]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[1]'\'''
json -d '{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}' <<< '[1]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[1]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[2]'\'''
json -d '{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}' <<< '[2]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[2]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[0,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}' <<< '[0,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[0,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[0,1]'\'''
json -d '{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}' <<< '[0,1]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[0,1]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[0,2]'\'''
json -d '{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}' <<< '[0,2]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[0,2]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[0,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}' <<< '[0,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[0,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[1,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}' <<< '[1,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[1,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[1,0]'\'''
json -d '{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}' <<< '[1,0]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[1,0]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[1,1]'\'''
json -d '{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}' <<< '[1,1]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[1,1]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[1,2]'\'''
json -d '{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}' <<< '[1,2]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[1,2]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[1,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}' <<< '[1,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[1,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[2,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}' <<< '[2,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[2,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[2,0]'\'''
json -d '{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}' <<< '[2,0]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[2,0]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[2,1]'\'''
json -d '{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}' <<< '[2,1]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[2,1]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[2,2]'\'''
json -d '{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}' <<< '[2,2]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[2,2]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[2,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}' <<< '[2,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[2,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[1,2,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}' <<< '[1,2,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[1,2,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[1,2,0]'\'''
json -d '{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}' <<< '[1,2,0]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[1,2,0]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[1,2,1]'\'''
json -d '{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}' <<< '[1,2,1]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[1,2,1]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[1,2,2]'\'''
json -d '{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}' <<< '[1,2,2]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[1,2,2]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[1,2,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}' <<< '[1,2,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[1,2,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[1,2,3,4]'\'''
json -d '{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}' <<< '[1,2,3,4]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[1,2,3,4]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[1,2,{},null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}' <<< '[1,2,{},null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[{"plain":1},{"plain":2},"object"]}]}'\'' <<< '\''[1,2,{},null]'\'''
)

