#!/bin/bash

# Copyright (C) 2016, 2017, 2018  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-cases:26
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L 26.old <(echo \
'$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@" 2>&1|sed -r '\''/error:/s|(/dev/fd/)[0-9]+|\1??|'\''; }
$ json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["boolean","boolean","string"]},{"type":"array","args":["number","number","string"]}]}'\'' <<< '\''[null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"boolean"'\'' or `"number"'\'' or, otherwise, no value at all
json: error: <stdin>:1:2: [null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["boolean","boolean","string"]},{"type":"array","args":["number","number","string"]}]}'\'' <<< '\''[null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["boolean","boolean","string"]},{"type":"array","args":["number","number","string"]}]}'\'' <<< '\''[false]'\''
[false]
$ json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["boolean","boolean","string"]},{"type":"array","args":["number","number","string"]}]}'\'' <<< '\''[0]'\''
[0]
$ json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["boolean","boolean","string"]},{"type":"array","args":["number","number","string"]}]}'\'' <<< '\''[false,true]'\''
[false,true]
$ json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["boolean","boolean","string"]},{"type":"array","args":["number","number","string"]}]}'\'' <<< '\''[0,1]'\''
[0,1]
$ json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["boolean","boolean","string"]},{"type":"array","args":["number","number","string"]}]}'\'' <<< '\''[false,true,false]'\''
[false,true,false]
$ json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["boolean","boolean","string"]},{"type":"array","args":["number","number","string"]}]}'\'' <<< '\''[0,1,2]'\''
[0,1,2]
$ json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["boolean","boolean","string"]},{"type":"array","args":["number","number","string"]}]}'\'' <<< '\''[false,true,""]'\''
[false,true,""]
$ json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["boolean","boolean","string"]},{"type":"array","args":["number","number","string"]}]}'\'' <<< '\''[0,1,""]'\''
[0,1,""]
$ json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["boolean","boolean","string"]},{"type":"array","args":["number","number","string"]}]}'\'' <<< '\''[false,true,null]'\''
json: error: <stdin>:1:13: type check error: type mismatch: expected a value of type `"boolean"'\'' or `"string"'\''
json: error: <stdin>:1:13: [false,true,null]
json: error: <stdin>:1:13:             ^
[false,true,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["boolean","boolean","string"]},{"type":"array","args":["number","number","string"]}]}'\'' <<< '\''[false,true,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["boolean","boolean","string"]},{"type":"array","args":["number","number","string"]}]}'\'' <<< '\''[0,1,null]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `"number"'\'' or `"string"'\''
json: error: <stdin>:1:6: [0,1,null]
json: error: <stdin>:1:6:      ^
[0,1,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["boolean","boolean","string"]},{"type":"array","args":["number","number","string"]}]}'\'' <<< '\''[0,1,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["boolean","boolean","string"]},{"type":"array","args":["number","number","string"]}]}'\'' <<< '\''[false,true,false,true]'\''
[false,true,false,true]
$ json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["boolean","boolean","string"]},{"type":"array","args":["number","number","string"]}]}'\'' <<< '\''[0,1,2,3]'\''
[0,1,2,3]
$ json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["boolean","boolean","string"]},{"type":"array","args":["number","number","string"]}]}'\'' <<< '\''[false,true,false,null]'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:19: [false,true,false,null]
json: error: <stdin>:1:19:                   ^
[false,true,false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["boolean","boolean","string"]},{"type":"array","args":["number","number","string"]}]}'\'' <<< '\''[false,true,false,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["boolean","boolean","string"]},{"type":"array","args":["number","number","string"]}]}'\'' <<< '\''[0,1,2,null]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: [0,1,2,null]
json: error: <stdin>:1:8:        ^
[0,1,2,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["boolean","boolean","string"]},{"type":"array","args":["number","number","string"]}]}'\'' <<< '\''[0,1,2,null]'\'''
) -L 26.new <(
echo '$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@" 2>&1|sed -r '\''/error:/s|(/dev/fd/)[0-9]+|\1??|'\''; }'
json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@" 2>&1|sed -r '/error:/s|(/dev/fd/)[0-9]+|\1??|'; } 2>&1 ||
echo 'command failed: json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@" 2>&1|sed -r '\''/error:/s|(/dev/fd/)[0-9]+|\1??|'\''; }'

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["boolean","boolean","string"]},{"type":"array","args":["number","number","string"]}]}'\'' <<< '\''[null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["boolean","boolean","string"]},{"type":"array","args":["number","number","string"]}]}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["boolean","boolean","string"]},{"type":"array","args":["number","number","string"]}]}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["boolean","boolean","string"]},{"type":"array","args":["number","number","string"]}]}'\'' <<< '\''[false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["boolean","boolean","string"]},{"type":"array","args":["number","number","string"]}]}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["boolean","boolean","string"]},{"type":"array","args":["number","number","string"]}]}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["boolean","boolean","string"]},{"type":"array","args":["number","number","string"]}]}'\'' <<< '\''[0]'\'''
json -d '{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["boolean","boolean","string"]},{"type":"array","args":["number","number","string"]}]}' <<< '[0]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["boolean","boolean","string"]},{"type":"array","args":["number","number","string"]}]}'\'' <<< '\''[0]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["boolean","boolean","string"]},{"type":"array","args":["number","number","string"]}]}'\'' <<< '\''[false,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["boolean","boolean","string"]},{"type":"array","args":["number","number","string"]}]}' <<< '[false,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["boolean","boolean","string"]},{"type":"array","args":["number","number","string"]}]}'\'' <<< '\''[false,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["boolean","boolean","string"]},{"type":"array","args":["number","number","string"]}]}'\'' <<< '\''[0,1]'\'''
json -d '{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["boolean","boolean","string"]},{"type":"array","args":["number","number","string"]}]}' <<< '[0,1]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["boolean","boolean","string"]},{"type":"array","args":["number","number","string"]}]}'\'' <<< '\''[0,1]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["boolean","boolean","string"]},{"type":"array","args":["number","number","string"]}]}'\'' <<< '\''[false,true,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["boolean","boolean","string"]},{"type":"array","args":["number","number","string"]}]}' <<< '[false,true,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["boolean","boolean","string"]},{"type":"array","args":["number","number","string"]}]}'\'' <<< '\''[false,true,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["boolean","boolean","string"]},{"type":"array","args":["number","number","string"]}]}'\'' <<< '\''[0,1,2]'\'''
json -d '{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["boolean","boolean","string"]},{"type":"array","args":["number","number","string"]}]}' <<< '[0,1,2]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["boolean","boolean","string"]},{"type":"array","args":["number","number","string"]}]}'\'' <<< '\''[0,1,2]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["boolean","boolean","string"]},{"type":"array","args":["number","number","string"]}]}'\'' <<< '\''[false,true,""]'\'''
json -d '{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["boolean","boolean","string"]},{"type":"array","args":["number","number","string"]}]}' <<< '[false,true,""]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["boolean","boolean","string"]},{"type":"array","args":["number","number","string"]}]}'\'' <<< '\''[false,true,""]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["boolean","boolean","string"]},{"type":"array","args":["number","number","string"]}]}'\'' <<< '\''[0,1,""]'\'''
json -d '{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["boolean","boolean","string"]},{"type":"array","args":["number","number","string"]}]}' <<< '[0,1,""]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["boolean","boolean","string"]},{"type":"array","args":["number","number","string"]}]}'\'' <<< '\''[0,1,""]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["boolean","boolean","string"]},{"type":"array","args":["number","number","string"]}]}'\'' <<< '\''[false,true,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["boolean","boolean","string"]},{"type":"array","args":["number","number","string"]}]}' <<< '[false,true,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["boolean","boolean","string"]},{"type":"array","args":["number","number","string"]}]}'\'' <<< '\''[false,true,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["boolean","boolean","string"]},{"type":"array","args":["number","number","string"]}]}'\'' <<< '\''[0,1,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["boolean","boolean","string"]},{"type":"array","args":["number","number","string"]}]}' <<< '[0,1,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["boolean","boolean","string"]},{"type":"array","args":["number","number","string"]}]}'\'' <<< '\''[0,1,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["boolean","boolean","string"]},{"type":"array","args":["number","number","string"]}]}'\'' <<< '\''[false,true,false,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["boolean","boolean","string"]},{"type":"array","args":["number","number","string"]}]}' <<< '[false,true,false,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["boolean","boolean","string"]},{"type":"array","args":["number","number","string"]}]}'\'' <<< '\''[false,true,false,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["boolean","boolean","string"]},{"type":"array","args":["number","number","string"]}]}'\'' <<< '\''[0,1,2,3]'\'''
json -d '{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["boolean","boolean","string"]},{"type":"array","args":["number","number","string"]}]}' <<< '[0,1,2,3]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["boolean","boolean","string"]},{"type":"array","args":["number","number","string"]}]}'\'' <<< '\''[0,1,2,3]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["boolean","boolean","string"]},{"type":"array","args":["number","number","string"]}]}'\'' <<< '\''[false,true,false,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["boolean","boolean","string"]},{"type":"array","args":["number","number","string"]}]}' <<< '[false,true,false,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["boolean","boolean","string"]},{"type":"array","args":["number","number","string"]}]}'\'' <<< '\''[false,true,false,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["boolean","boolean","string"]},{"type":"array","args":["number","number","string"]}]}'\'' <<< '\''[0,1,2,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["boolean","boolean","string"]},{"type":"array","args":["number","number","string"]}]}' <<< '[0,1,2,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["boolean","boolean","string"]},{"type":"array","args":["number","number","string"]}]}'\'' <<< '\''[0,1,2,null]'\'''
)

