#!/bin/bash

# Copyright (C) 2016, 2017  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-checker:dict7
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L dict7.old <(echo \
'$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes
$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":null}'\''
{"bar":null,"foo":null}
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":false}'\''
{"bar":null,"foo":false}
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":true}'\''
{"bar":null,"foo":true}
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":123}'\''
{"bar":null,"foo":123}
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":"foo"}'\''
{"bar":null,"foo":"foo"}
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":{}}'\''
{"bar":null,"foo":{}}
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":[]}'\''
{"bar":null,"foo":[]}
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":null}'\''
{"bar":null,"foo":null}
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":false}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:19: {"bar":null,"foo":false}
json: error: <stdin>:1:19:                   ^
{"bar":null,"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":false}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":true}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:19: {"bar":null,"foo":true}
json: error: <stdin>:1:19:                   ^
{"bar":null,"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":true}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":123}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:19: {"bar":null,"foo":123}
json: error: <stdin>:1:19:                   ^
{"bar":null,"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":123}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":"foo"}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:19: {"bar":null,"foo":"foo"}
json: error: <stdin>:1:19:                   ^
{"bar":null,"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":"foo"}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":{}}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:19: {"bar":null,"foo":{}}
json: error: <stdin>:1:19:                   ^
{"bar":null,"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":{}}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":[]}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:19: {"bar":null,"foo":[]}
json: error: <stdin>:1:19:                   ^
{"bar":null,"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":[]}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":null}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:19: {"bar":null,"foo":null}
json: error: <stdin>:1:19:                   ^
{"bar":null,"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":false}'\''
{"bar":null,"foo":false}
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":true}'\''
{"bar":null,"foo":true}
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":123}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:19: {"bar":null,"foo":123}
json: error: <stdin>:1:19:                   ^
{"bar":null,"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":123}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":"foo"}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:19: {"bar":null,"foo":"foo"}
json: error: <stdin>:1:19:                   ^
{"bar":null,"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":"foo"}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":{}}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:19: {"bar":null,"foo":{}}
json: error: <stdin>:1:19:                   ^
{"bar":null,"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":{}}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":[]}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:19: {"bar":null,"foo":[]}
json: error: <stdin>:1:19:                   ^
{"bar":null,"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":[]}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":null}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:19: {"bar":null,"foo":null}
json: error: <stdin>:1:19:                   ^
{"bar":null,"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":false}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:19: {"bar":null,"foo":false}
json: error: <stdin>:1:19:                   ^
{"bar":null,"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":false}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":true}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:19: {"bar":null,"foo":true}
json: error: <stdin>:1:19:                   ^
{"bar":null,"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":true}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":123}'\''
{"bar":null,"foo":123}
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":"foo"}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:19: {"bar":null,"foo":"foo"}
json: error: <stdin>:1:19:                   ^
{"bar":null,"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":"foo"}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":{}}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:19: {"bar":null,"foo":{}}
json: error: <stdin>:1:19:                   ^
{"bar":null,"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":{}}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":[]}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:19: {"bar":null,"foo":[]}
json: error: <stdin>:1:19:                   ^
{"bar":null,"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":[]}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":null}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:19: {"bar":null,"foo":null}
json: error: <stdin>:1:19:                   ^
{"bar":null,"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":false}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:19: {"bar":null,"foo":false}
json: error: <stdin>:1:19:                   ^
{"bar":null,"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":false}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":true}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:19: {"bar":null,"foo":true}
json: error: <stdin>:1:19:                   ^
{"bar":null,"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":true}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":123}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:19: {"bar":null,"foo":123}
json: error: <stdin>:1:19:                   ^
{"bar":null,"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":123}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":"foo"}'\''
{"bar":null,"foo":"foo"}
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":{}}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:19: {"bar":null,"foo":{}}
json: error: <stdin>:1:19:                   ^
{"bar":null,"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":{}}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":[]}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:19: {"bar":null,"foo":[]}
json: error: <stdin>:1:19:                   ^
{"bar":null,"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":[]}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":null}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:19: {"bar":null,"foo":null}
json: error: <stdin>:1:19:                   ^
{"bar":null,"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":false}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:19: {"bar":null,"foo":false}
json: error: <stdin>:1:19:                   ^
{"bar":null,"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":false}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":true}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:19: {"bar":null,"foo":true}
json: error: <stdin>:1:19:                   ^
{"bar":null,"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":true}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":123}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:19: {"bar":null,"foo":123}
json: error: <stdin>:1:19:                   ^
{"bar":null,"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":123}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":"foo"}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:19: {"bar":null,"foo":"foo"}
json: error: <stdin>:1:19:                   ^
{"bar":null,"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":"foo"}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":{}}'\''
{"bar":null,"foo":{}}
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":[]}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:19: {"bar":null,"foo":[]}
json: error: <stdin>:1:19:                   ^
{"bar":null,"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":[]}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":null}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:19: {"bar":null,"foo":null}
json: error: <stdin>:1:19:                   ^
{"bar":null,"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":false}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:19: {"bar":null,"foo":false}
json: error: <stdin>:1:19:                   ^
{"bar":null,"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":false}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":true}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:19: {"bar":null,"foo":true}
json: error: <stdin>:1:19:                   ^
{"bar":null,"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":true}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":123}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:19: {"bar":null,"foo":123}
json: error: <stdin>:1:19:                   ^
{"bar":null,"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":123}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":"foo"}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:19: {"bar":null,"foo":"foo"}
json: error: <stdin>:1:19:                   ^
{"bar":null,"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":"foo"}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":{}}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:19: {"bar":null,"foo":{}}
json: error: <stdin>:1:19:                   ^
{"bar":null,"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":{}}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":[]}'\''
{"bar":null,"foo":[]}'
) -L dict7.new <(
echo '$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'
export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes 2>&1 ||
echo 'command failed: export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"bar","type":"null"}]}' <<< '{"bar":null,"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":false}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"bar","type":"null"}]}' <<< '{"bar":null,"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":false}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":true}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"bar","type":"null"}]}' <<< '{"bar":null,"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":true}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":123}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"bar","type":"null"}]}' <<< '{"bar":null,"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":123}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":"foo"}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"bar","type":"null"}]}' <<< '{"bar":null,"foo":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":"foo"}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":{}}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"bar","type":"null"}]}' <<< '{"bar":null,"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":{}}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":[]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"bar","type":"null"}]}' <<< '{"bar":null,"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":[]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"null"},{"name":"bar","type":"null"}]}' <<< '{"bar":null,"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":false}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"null"},{"name":"bar","type":"null"}]}' <<< '{"bar":null,"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":false}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":true}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"null"},{"name":"bar","type":"null"}]}' <<< '{"bar":null,"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":true}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":123}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"null"},{"name":"bar","type":"null"}]}' <<< '{"bar":null,"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":123}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":"foo"}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"null"},{"name":"bar","type":"null"}]}' <<< '{"bar":null,"foo":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":"foo"}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":{}}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"null"},{"name":"bar","type":"null"}]}' <<< '{"bar":null,"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":{}}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":[]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"null"},{"name":"bar","type":"null"}]}' <<< '{"bar":null,"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":[]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"null"}]}' <<< '{"bar":null,"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":false}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"null"}]}' <<< '{"bar":null,"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":false}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":true}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"null"}]}' <<< '{"bar":null,"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":true}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":123}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"null"}]}' <<< '{"bar":null,"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":123}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":"foo"}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"null"}]}' <<< '{"bar":null,"foo":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":"foo"}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":{}}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"null"}]}' <<< '{"bar":null,"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":{}}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":[]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"null"}]}' <<< '{"bar":null,"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":[]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"number"},{"name":"bar","type":"null"}]}' <<< '{"bar":null,"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":false}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"number"},{"name":"bar","type":"null"}]}' <<< '{"bar":null,"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":false}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":true}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"number"},{"name":"bar","type":"null"}]}' <<< '{"bar":null,"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":true}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":123}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"number"},{"name":"bar","type":"null"}]}' <<< '{"bar":null,"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":123}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":"foo"}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"number"},{"name":"bar","type":"null"}]}' <<< '{"bar":null,"foo":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":"foo"}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":{}}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"number"},{"name":"bar","type":"null"}]}' <<< '{"bar":null,"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":{}}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":[]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"number"},{"name":"bar","type":"null"}]}' <<< '{"bar":null,"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":[]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"string"},{"name":"bar","type":"null"}]}' <<< '{"bar":null,"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":false}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"string"},{"name":"bar","type":"null"}]}' <<< '{"bar":null,"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":false}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":true}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"string"},{"name":"bar","type":"null"}]}' <<< '{"bar":null,"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":true}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":123}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"string"},{"name":"bar","type":"null"}]}' <<< '{"bar":null,"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":123}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":"foo"}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"string"},{"name":"bar","type":"null"}]}' <<< '{"bar":null,"foo":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":"foo"}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":{}}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"string"},{"name":"bar","type":"null"}]}' <<< '{"bar":null,"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":{}}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":[]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"string"},{"name":"bar","type":"null"}]}' <<< '{"bar":null,"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":[]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"object"},{"name":"bar","type":"null"}]}' <<< '{"bar":null,"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":false}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"object"},{"name":"bar","type":"null"}]}' <<< '{"bar":null,"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":false}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":true}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"object"},{"name":"bar","type":"null"}]}' <<< '{"bar":null,"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":true}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":123}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"object"},{"name":"bar","type":"null"}]}' <<< '{"bar":null,"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":123}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":"foo"}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"object"},{"name":"bar","type":"null"}]}' <<< '{"bar":null,"foo":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":"foo"}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":{}}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"object"},{"name":"bar","type":"null"}]}' <<< '{"bar":null,"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":{}}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":[]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"object"},{"name":"bar","type":"null"}]}' <<< '{"bar":null,"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":[]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"array"},{"name":"bar","type":"null"}]}' <<< '{"bar":null,"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":false}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"array"},{"name":"bar","type":"null"}]}' <<< '{"bar":null,"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":false}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":true}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"array"},{"name":"bar","type":"null"}]}' <<< '{"bar":null,"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":true}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":123}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"array"},{"name":"bar","type":"null"}]}' <<< '{"bar":null,"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":123}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":"foo"}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"array"},{"name":"bar","type":"null"}]}' <<< '{"bar":null,"foo":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":"foo"}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":{}}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"array"},{"name":"bar","type":"null"}]}' <<< '{"bar":null,"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":{}}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":[]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"array"},{"name":"bar","type":"null"}]}' <<< '{"bar":null,"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"},{"name":"bar","type":"null"}]}'\'' <<< '\''{"bar":null,"foo":[]}'\'''
)

