#!/bin/bash

# Copyright (C) 2016, 2017  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-checker-list:list-object-basic-basic-val-object-basic-basic2
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L list-object-basic-basic-val-object-basic-basic2.old <(echo \
'$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes
$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"buu":null}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":null}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"buu":false}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":false}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"buu":true}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":true}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"buu":123}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":123}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"buu":"foo"}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":"foo"}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"buu":{}}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":{}}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"buu":[]}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":[]}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[{}],"buu":null}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":null}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[{}],"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[{}],"buu":false}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":false}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[{}],"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[{}],"buu":true}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":true}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[{}],"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[{}],"buu":123}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":123}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[{}],"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[{}],"buu":"foo"}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":"foo"}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[{}],"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[{}],"buu":{}}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":{}}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[{}],"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[{}],"buu":[]}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":[]}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[{}],"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[{}],"buu":null}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":null}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[{}],"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[{}],"buu":false}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":false}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[{}],"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[{}],"buu":true}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":true}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[{}],"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[{}],"buu":123}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":123}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[{}],"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[{}],"buu":"foo"}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":"foo"}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[{}],"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[{}],"buu":{}}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":{}}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[{}],"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[{}],"buu":[]}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":[]}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[{}],"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[{}],"buu":null}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":null}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[{}],"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[{}],"buu":false}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":false}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[{}],"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[{}],"buu":true}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":true}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[{}],"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[{}],"buu":123}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":123}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[{}],"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[{}],"buu":"foo"}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":"foo"}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[{}],"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[{}],"buu":{}}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":{}}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[{}],"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[{}],"buu":[]}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":[]}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[{}],"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[{}],"buu":null}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":null}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[{}],"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[{}],"buu":false}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":false}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[{}],"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[{}],"buu":true}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":true}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[{}],"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[{}],"buu":123}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":123}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[{}],"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[{}],"buu":"foo"}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":"foo"}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[{}],"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[{}],"buu":{}}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":{}}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[{}],"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[{}],"buu":[]}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":[]}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[{}],"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[{}],"buu":null}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":null}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[{}],"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[{}],"buu":false}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":false}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[{}],"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[{}],"buu":true}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":true}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[{}],"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[{}],"buu":123}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":123}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[{}],"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[{}],"buu":"foo"}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":"foo"}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[{}],"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[{}],"buu":{}}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":{}}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[{}],"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[{}],"buu":[]}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":[]}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[{}],"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[{}],"buu":null}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":null}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[{}],"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[{}],"buu":false}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":false}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[{}],"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[{}],"buu":true}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":true}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[{}],"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[{}],"buu":123}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":123}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[{}],"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[{}],"buu":"foo"}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":"foo"}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[{}],"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[{}],"buu":{}}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":{}}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[{}],"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[{}],"buu":[]}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":[]}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[{}],"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"buu":null}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":null}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"buu":false}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":false}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"buu":true}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":true}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"buu":123}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":123}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"buu":"foo"}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":"foo"}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"buu":{}}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":{}}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"buu":[]}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":[]}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"buu":null}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":null}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"buu":false}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":false}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"buu":true}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":true}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"buu":123}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":123}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"buu":"foo"}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":"foo"}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"buu":{}}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":{}}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"buu":[]}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":[]}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"buu":null}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":null}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"buu":false}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":false}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"buu":true}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":true}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"buu":123}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":123}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"buu":"foo"}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":"foo"}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"buu":{}}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":{}}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"buu":[]}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":[]}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"buu":null}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":null}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"buu":false}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":false}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"buu":true}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":true}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"buu":123}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":123}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"buu":"foo"}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":"foo"}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"buu":{}}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":{}}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"buu":[]}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":[]}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"buu":null}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":null}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"buu":false}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":false}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"buu":true}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":true}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"buu":123}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":123}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"buu":"foo"}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":"foo"}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"buu":{}}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":{}}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"buu":[]}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":[]}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"buu":null}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":null}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"buu":false}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":false}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"buu":true}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":true}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"buu":123}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":123}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"buu":"foo"}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":"foo"}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"buu":{}}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":{}}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"buu":[]}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":[]}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"buu":null}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":null}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"buu":false}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":false}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"buu":true}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":true}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"buu":123}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":123}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"buu":"foo"}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":"foo"}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"buu":{}}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":{}}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"buu":[]}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":[]}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"buu":null}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":null}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"buu":false}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":false}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"buu":true}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":true}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"buu":123}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":123}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"buu":"foo"}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":"foo"}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"buu":{}}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":{}}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"buu":[]}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":[]}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"buu":null}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":null}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"buu":false}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":false}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"buu":true}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":true}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"buu":123}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":123}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"buu":"foo"}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":"foo"}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"buu":{}}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":{}}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"buu":[]}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":[]}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"buu":null}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":null}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"buu":false}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":false}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"buu":true}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":true}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"buu":123}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":123}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"buu":"foo"}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":"foo"}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"buu":{}}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":{}}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"buu":[]}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":[]}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"buu":null}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":null}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"buu":false}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":false}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"buu":true}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":true}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"buu":123}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":123}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"buu":"foo"}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":"foo"}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"buu":{}}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":{}}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"buu":[]}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":[]}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"buu":null}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":null}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"buu":false}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":false}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"buu":true}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":true}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"buu":123}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":123}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"buu":"foo"}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":"foo"}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"buu":{}}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":{}}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"buu":[]}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":[]}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"buu":null}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":null}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"buu":false}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":false}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"buu":true}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":true}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"buu":123}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":123}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"buu":"foo"}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":"foo"}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"buu":{}}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":{}}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"buu":[]}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":[]}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"buu":null}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":null}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"buu":false}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":false}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"buu":true}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":true}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"buu":123}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":123}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"buu":"foo"}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":"foo"}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"buu":{}}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":{}}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"buu":[]}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":[]}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":456,"buu":null}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":null}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":456,"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":456,"buu":false}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":false}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":456,"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":456,"buu":true}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":true}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":456,"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":456,"buu":123}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":123}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":456,"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":456,"buu":"foo"}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":"foo"}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":456,"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":456,"buu":{}}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":{}}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":456,"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":456,"buu":[]}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":[]}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":456,"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":456,"buu":null}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":null}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":456,"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":456,"buu":false}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":false}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":456,"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":456,"buu":true}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":true}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":456,"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":456,"buu":123}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":123}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":456,"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":456,"buu":"foo"}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":"foo"}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":456,"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":456,"buu":{}}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":{}}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":456,"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":456,"buu":[]}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":[]}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":456,"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":456,"buu":null}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":null}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":456,"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":456,"buu":false}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":false}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":456,"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":456,"buu":true}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":true}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":456,"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":456,"buu":123}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":123}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":456,"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":456,"buu":"foo"}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":"foo"}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":456,"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":456,"buu":{}}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":{}}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":456,"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":456,"buu":[]}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":[]}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":456,"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"buu":null}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":null}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"buu":false}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":false}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"buu":true}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":true}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"buu":123}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":123}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"buu":"foo"}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":"foo"}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"buu":{}}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":{}}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"buu":[]}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":[]}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":456,"buu":null}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":null}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":456,"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":456,"buu":false}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":false}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":456,"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":456,"buu":true}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":true}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":456,"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":456,"buu":123}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":123}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":456,"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":456,"buu":"foo"}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":"foo"}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":456,"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":456,"buu":{}}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":{}}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":456,"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":456,"buu":[]}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":[]}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":456,"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":456,"buu":null}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":null}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":456,"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":456,"buu":false}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":false}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":456,"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":456,"buu":true}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":true}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":456,"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":456,"buu":123}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":123}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":456,"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":456,"buu":"foo"}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":"foo"}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":456,"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":456,"buu":{}}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":{}}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":456,"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":456,"buu":[]}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":[]}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":456,"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":456,"buu":null}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":null}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":456,"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":456,"buu":false}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":false}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":456,"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":456,"buu":true}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":true}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":456,"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":456,"buu":123}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":123}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":456,"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":456,"buu":"foo"}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":"foo"}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":456,"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":456,"buu":{}}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":{}}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":456,"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":456,"buu":[]}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":[]}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":456,"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"bar","buu":null}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":null}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"bar","buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"bar","buu":false}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":false}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"bar","buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"bar","buu":true}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":true}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"bar","buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"bar","buu":123}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":123}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"bar","buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"bar","buu":"foo"}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":"foo"}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"bar","buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"bar","buu":{}}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":{}}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"bar","buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"bar","buu":[]}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":[]}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"bar","buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"bar","buu":null}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":null}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"bar","buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"bar","buu":false}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":false}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"bar","buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"bar","buu":true}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":true}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"bar","buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"bar","buu":123}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":123}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"bar","buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"bar","buu":"foo"}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":"foo"}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"bar","buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"bar","buu":{}}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":{}}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"bar","buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"bar","buu":[]}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":[]}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"bar","buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"bar","buu":null}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":null}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"bar","buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"bar","buu":false}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":false}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"bar","buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"bar","buu":true}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":true}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"bar","buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"bar","buu":123}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":123}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"bar","buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"bar","buu":"foo"}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":"foo"}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"bar","buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"bar","buu":{}}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":{}}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"bar","buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"bar","buu":[]}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":[]}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"bar","buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"bar","buu":null}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":null}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"bar","buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"bar","buu":false}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":false}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"bar","buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"bar","buu":true}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":true}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"bar","buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"bar","buu":123}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":123}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"bar","buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"bar","buu":"foo"}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":"foo"}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"bar","buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"bar","buu":{}}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":{}}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"bar","buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"bar","buu":[]}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":[]}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"bar","buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","buu":null}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":null}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","buu":false}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":false}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","buu":true}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":true}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","buu":123}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":123}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","buu":"foo"}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":"foo"}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","buu":{}}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":{}}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","buu":[]}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":[]}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"bar","buu":null}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":null}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"bar","buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"bar","buu":false}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":false}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"bar","buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"bar","buu":true}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":true}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"bar","buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"bar","buu":123}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":123}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"bar","buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"bar","buu":"foo"}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":"foo"}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"bar","buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"bar","buu":{}}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":{}}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"bar","buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"bar","buu":[]}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":[]}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"bar","buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"bar","buu":null}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":null}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"bar","buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"bar","buu":false}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":false}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"bar","buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"bar","buu":true}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":true}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"bar","buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"bar","buu":123}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":123}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"bar","buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"bar","buu":"foo"}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":"foo"}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"bar","buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"bar","buu":{}}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":{}}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"bar","buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"bar","buu":[]}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":[]}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"bar","buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":{},"buu":null}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":null}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":{},"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":{},"buu":false}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":false}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":{},"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":{},"buu":true}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":true}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":{},"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":{},"buu":123}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":123}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":{},"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":{},"buu":"foo"}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":"foo"}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":{},"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":{},"buu":{}}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":{}}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":{},"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":{},"buu":[]}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":[]}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":{},"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":{},"buu":null}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":null}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":{},"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":{},"buu":false}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":false}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":{},"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":{},"buu":true}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":true}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":{},"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":{},"buu":123}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":123}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":{},"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":{},"buu":"foo"}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":"foo"}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":{},"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":{},"buu":{}}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":{}}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":{},"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":{},"buu":[]}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":[]}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":{},"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":{},"buu":null}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":null}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":{},"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":{},"buu":false}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":false}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":{},"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":{},"buu":true}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":true}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":{},"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":{},"buu":123}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":123}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":{},"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":{},"buu":"foo"}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":"foo"}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":{},"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":{},"buu":{}}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":{}}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":{},"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":{},"buu":[]}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":[]}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":{},"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":{},"buu":null}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":null}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":{},"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":{},"buu":false}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":false}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":{},"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":{},"buu":true}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":true}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":{},"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":{},"buu":123}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":123}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":{},"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":{},"buu":"foo"}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":"foo"}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":{},"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":{},"buu":{}}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":{}}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":{},"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":{},"buu":[]}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":[]}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":{},"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":{},"buu":null}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":null}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":{},"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":{},"buu":false}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":false}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":{},"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":{},"buu":true}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":true}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":{},"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":{},"buu":123}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":123}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":{},"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":{},"buu":"foo"}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":"foo"}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":{},"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":{},"buu":{}}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":{}}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":{},"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":{},"buu":[]}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":[]}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":{},"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"buu":null}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":null}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"buu":false}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":false}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"buu":true}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":true}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"buu":123}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":123}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"buu":"foo"}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":"foo"}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"buu":{}}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":{}}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"buu":[]}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":[]}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":{},"buu":null}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":null}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":{},"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":{},"buu":false}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":false}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":{},"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":{},"buu":true}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":true}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":{},"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":{},"buu":123}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":123}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":{},"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":{},"buu":"foo"}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":"foo"}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":{},"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":{},"buu":{}}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":{}}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":{},"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":{},"buu":[]}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":[]}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":{},"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[],"buu":null}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":null}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[],"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[],"buu":false}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":false}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[],"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[],"buu":true}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":true}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[],"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[],"buu":123}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":123}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[],"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[],"buu":"foo"}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":"foo"}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[],"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[],"buu":{}}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":{}}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[],"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[],"buu":[]}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":[]}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[],"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[],"buu":null}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":null}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[],"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[],"buu":false}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":false}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[],"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[],"buu":true}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":true}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[],"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[],"buu":123}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":123}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[],"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[],"buu":"foo"}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":"foo"}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[],"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[],"buu":{}}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":{}}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[],"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[],"buu":[]}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":[]}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[],"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[],"buu":null}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":null}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[],"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[],"buu":false}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":false}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[],"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[],"buu":true}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":true}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[],"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[],"buu":123}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":123}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[],"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[],"buu":"foo"}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":"foo"}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[],"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[],"buu":{}}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":{}}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[],"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[],"buu":[]}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":[]}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[],"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[],"buu":null}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":null}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[],"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[],"buu":false}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":false}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[],"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[],"buu":true}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":true}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[],"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[],"buu":123}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":123}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[],"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[],"buu":"foo"}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":"foo"}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[],"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[],"buu":{}}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":{}}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[],"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[],"buu":[]}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":[]}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[],"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[],"buu":null}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":null}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[],"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[],"buu":false}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":false}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[],"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[],"buu":true}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":true}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[],"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[],"buu":123}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":123}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[],"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[],"buu":"foo"}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":"foo"}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[],"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[],"buu":{}}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":{}}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[],"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[],"buu":[]}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":[]}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[],"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[],"buu":null}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":null}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[],"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[],"buu":false}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":false}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[],"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[],"buu":true}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":true}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[],"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[],"buu":123}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":123}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[],"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[],"buu":"foo"}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":"foo"}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[],"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[],"buu":{}}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":{}}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[],"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[],"buu":[]}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":[]}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[],"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"buu":null}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":null}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"buu":false}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":false}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"buu":true}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":true}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"buu":123}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":123}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"buu":"foo"}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":"foo"}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"buu":{}}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":{}}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"buu":[]}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":[]}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"buu":[]}'\'''
) -L list-object-basic-basic-val-object-basic-basic2.new <(
echo '$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'
export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes 2>&1 ||
echo 'command failed: export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":[{}],"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":[{}],"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":[{}],"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":[{}],"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":[{}],"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":[{}],"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":[{}],"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[{}],"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":[{}],"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[{}],"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[{}],"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":[{}],"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[{}],"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[{}],"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":[{}],"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[{}],"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[{}],"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":[{}],"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[{}],"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[{}],"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":[{}],"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[{}],"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[{}],"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":[{}],"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[{}],"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[{}],"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":[{}],"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[{}],"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[{}],"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":[{}],"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[{}],"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[{}],"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":[{}],"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[{}],"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[{}],"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":[{}],"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[{}],"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[{}],"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":[{}],"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[{}],"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[{}],"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":[{}],"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[{}],"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[{}],"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":[{}],"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[{}],"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[{}],"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":[{}],"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[{}],"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[{}],"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":[{}],"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[{}],"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[{}],"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":[{}],"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[{}],"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[{}],"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":[{}],"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[{}],"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[{}],"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":[{}],"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[{}],"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[{}],"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":[{}],"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[{}],"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[{}],"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":[{}],"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[{}],"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[{}],"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":[{}],"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[{}],"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[{}],"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":[{}],"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[{}],"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[{}],"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":[{}],"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[{}],"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[{}],"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":[{}],"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[{}],"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[{}],"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":[{}],"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[{}],"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[{}],"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":[{}],"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[{}],"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[{}],"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":[{}],"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[{}],"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[{}],"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":[{}],"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[{}],"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[{}],"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":[{}],"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[{}],"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[{}],"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":[{}],"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[{}],"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[{}],"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":[{}],"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[{}],"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[{}],"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":[{}],"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[{}],"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[{}],"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":[{}],"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[{}],"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[{}],"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":[{}],"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[{}],"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[{}],"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":[{}],"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[{}],"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[{}],"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":[{}],"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[{}],"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[{}],"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":[{}],"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[{}],"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[{}],"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":[{}],"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[{}],"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[{}],"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":[{}],"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[{}],"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[{}],"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":[{}],"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[{}],"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[{}],"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":[{}],"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[{}],"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[{}],"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":[{}],"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[{}],"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":null,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":null,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":null,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":null,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":null,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":null,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":null,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":null,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":null,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":null,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":null,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":null,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":null,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":null,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":null,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":null,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":null,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":null,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":null,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":null,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":null,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":null,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":null,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":null,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":null,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":null,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":null,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":null,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":null,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":null,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":null,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":null,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":null,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":null,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":null,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":null,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":null,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":null,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":null,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":null,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":null,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":null,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":null,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":null,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":null,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":null,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":null,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":null,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":null,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":false,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":false,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":false,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":false,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":false,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":false,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":false,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":false,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":false,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":false,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":false,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":false,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":false,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":false,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":false,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":false,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":false,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":false,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":false,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":false,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":false,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":false,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":false,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":false,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":false,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":false,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":false,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":false,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":false,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":false,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":false,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":false,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":false,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":false,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":false,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":false,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":false,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":false,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":false,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":false,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":false,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":false,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":false,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":false,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":false,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":false,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":false,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":false,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":false,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":456,"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":456,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":456,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":456,"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":456,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":456,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":456,"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":456,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":456,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":456,"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":456,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":456,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":456,"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":456,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":456,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":456,"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":456,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":456,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":456,"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":456,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":456,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":456,"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":456,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":456,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":456,"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":456,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":456,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":456,"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":456,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":456,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":456,"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":456,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":456,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":456,"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":456,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":456,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":456,"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":456,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":456,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":456,"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":456,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":456,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":456,"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":456,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":456,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":456,"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":456,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":456,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":456,"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":456,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":456,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":456,"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":456,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":456,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":456,"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":456,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":456,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":456,"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":456,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":456,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":456,"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":456,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":456,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":456,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":456,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":456,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":456,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":456,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":456,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":456,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":456,"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":456,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":456,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":456,"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":456,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":456,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":456,"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":456,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":456,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":456,"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":456,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":456,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":456,"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":456,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":456,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":456,"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":456,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":456,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":456,"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":456,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":456,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":456,"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":456,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":456,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":456,"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":456,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":456,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":456,"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":456,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":456,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":456,"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":456,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":456,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":456,"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":456,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":456,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":456,"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":456,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":456,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":456,"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":456,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":456,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":456,"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":456,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":456,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":456,"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":456,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":456,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":456,"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":456,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":456,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":456,"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":456,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":456,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":456,"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":456,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":456,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":456,"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":456,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":456,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":456,"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":456,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":456,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"bar","buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":"bar","buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"bar","buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"bar","buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":"bar","buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"bar","buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"bar","buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":"bar","buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"bar","buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"bar","buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":"bar","buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"bar","buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"bar","buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":"bar","buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"bar","buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"bar","buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":"bar","buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"bar","buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"bar","buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":"bar","buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"bar","buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"bar","buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":"bar","buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"bar","buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"bar","buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":"bar","buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"bar","buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"bar","buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":"bar","buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"bar","buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"bar","buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":"bar","buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"bar","buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"bar","buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":"bar","buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"bar","buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"bar","buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":"bar","buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"bar","buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"bar","buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":"bar","buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"bar","buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"bar","buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":"bar","buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"bar","buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"bar","buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":"bar","buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"bar","buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"bar","buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":"bar","buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"bar","buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"bar","buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":"bar","buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"bar","buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"bar","buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":"bar","buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"bar","buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"bar","buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":"bar","buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"bar","buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"bar","buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":"bar","buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"bar","buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"bar","buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":"bar","buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"bar","buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"bar","buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":"bar","buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"bar","buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"bar","buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":"bar","buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"bar","buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"bar","buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":"bar","buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"bar","buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"bar","buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":"bar","buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"bar","buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"bar","buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":"bar","buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"bar","buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"bar","buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":"bar","buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"bar","buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":"bar","buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":"bar","buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":"bar","buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":"bar","buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":"bar","buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":"bar","buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":"bar","buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"bar","buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":"bar","buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"bar","buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"bar","buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":"bar","buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"bar","buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"bar","buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":"bar","buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"bar","buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"bar","buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":"bar","buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"bar","buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"bar","buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":"bar","buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"bar","buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"bar","buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":"bar","buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"bar","buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"bar","buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":"bar","buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"bar","buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"bar","buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":"bar","buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"bar","buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"bar","buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":"bar","buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"bar","buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"bar","buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":"bar","buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"bar","buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"bar","buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":"bar","buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"bar","buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"bar","buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":"bar","buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"bar","buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"bar","buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":"bar","buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"bar","buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"bar","buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":"bar","buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"bar","buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":{},"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":{},"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":{},"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":{},"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":{},"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":{},"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":{},"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":{},"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":{},"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":{},"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":{},"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":{},"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":{},"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":{},"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":{},"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":{},"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":{},"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":{},"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":{},"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":{},"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":{},"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":{},"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":{},"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":{},"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":{},"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":{},"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":{},"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":{},"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":{},"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":{},"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":{},"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":{},"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":{},"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":{},"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":{},"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":{},"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":{},"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":{},"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":{},"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":{},"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":{},"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":{},"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":{},"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":{},"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":{},"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":{},"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":{},"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":{},"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":{},"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":{},"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":{},"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":{},"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":{},"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":{},"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":{},"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":{},"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":{},"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":{},"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":{},"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":{},"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":{},"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":{},"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":{},"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":{},"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":{},"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":{},"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":{},"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":{},"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":{},"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":{},"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":{},"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":{},"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":{},"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":{},"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":{},"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":{},"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":{},"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":{},"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":{},"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":{},"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":{},"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":{},"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":{},"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":{},"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":{},"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":{},"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":{},"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":{},"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":{},"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":{},"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":{},"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":{},"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":{},"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":{},"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":{},"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":{},"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":{},"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":{},"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":{},"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":{},"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":{},"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":{},"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":{},"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":{},"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":{},"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":{},"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":{},"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":{},"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":{},"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":{},"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":{},"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":{},"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":{},"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":{},"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":{},"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":{},"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":{},"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":{},"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":{},"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":{},"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":{},"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":{},"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":{},"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":{},"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":{},"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":{},"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":{},"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":{},"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":{},"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":{},"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":{},"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":{},"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":{},"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[],"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":[],"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[],"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[],"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":[],"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[],"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[],"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":[],"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[],"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[],"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":[],"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[],"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[],"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":[],"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[],"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[],"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":[],"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[],"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[],"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":[],"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[],"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[],"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":[],"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[],"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[],"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":[],"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[],"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[],"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":[],"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[],"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[],"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":[],"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[],"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[],"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":[],"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[],"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[],"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":[],"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[],"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[],"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":[],"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[],"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[],"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":[],"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[],"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[],"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":[],"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[],"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[],"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":[],"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[],"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[],"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":[],"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[],"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[],"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":[],"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[],"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[],"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":[],"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[],"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[],"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":[],"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[],"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[],"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":[],"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[],"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[],"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":[],"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[],"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[],"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":[],"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[],"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[],"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":[],"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[],"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[],"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":[],"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[],"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[],"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":[],"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[],"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[],"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":[],"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[],"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[],"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":[],"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[],"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[],"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":[],"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[],"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[],"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":[],"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[],"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[],"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":[],"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[],"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[],"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":[],"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[],"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[],"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":[],"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[],"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[],"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":[],"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[],"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[],"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":[],"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[],"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[],"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":[],"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[],"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[],"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":[],"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[],"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[],"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":[],"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[],"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[],"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":[],"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[],"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[],"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":[],"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[],"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[],"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":[],"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[],"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":[],"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":[],"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":[],"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":[],"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":[],"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":[],"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":[],"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"buu":[]}'\'''
)

