#!/bin/bash

# Copyright (C) 2016, 2017  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-checker-list:list-closed-array-empty-closed-array-basic-val-array-basic-basic
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L list-closed-array-empty-closed-array-basic-val-array-basic-basic.old <(echo \
'$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes
$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["type"]}]}'\'' <<< '\''[[{}],null]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [[{}],null]
json: error: <stdin>:1:6:      ^
[[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["type"]}]}'\'' <<< '\''[[{}],null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["type"]}]}'\'' <<< '\''[[{}],false]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [[{}],false]
json: error: <stdin>:1:6:      ^
[[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["type"]}]}'\'' <<< '\''[[{}],false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["type"]}]}'\'' <<< '\''[[{}],true]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [[{}],true]
json: error: <stdin>:1:6:      ^
[[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["type"]}]}'\'' <<< '\''[[{}],true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["type"]}]}'\'' <<< '\''[[{}],456]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [[{}],456]
json: error: <stdin>:1:6:      ^
[[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["type"]}]}'\'' <<< '\''[[{}],456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["type"]}]}'\'' <<< '\''[[{}],"bar"]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [[{}],"bar"]
json: error: <stdin>:1:6:      ^
[[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["type"]}]}'\'' <<< '\''[[{}],"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["type"]}]}'\'' <<< '\''[[{}],{}]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [[{}],{}]
json: error: <stdin>:1:6:      ^
[[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["type"]}]}'\'' <<< '\''[[{}],{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["type"]}]}'\'' <<< '\''[[{}],[]]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [[{}],[]]
json: error: <stdin>:1:6:      ^
[[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["type"]}]}'\'' <<< '\''[[{}],[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["null"]}]}'\'' <<< '\''[null,null]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [null,null]
json: error: <stdin>:1:6:      ^
[null
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["null"]}]}'\'' <<< '\''[null,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["null"]}]}'\'' <<< '\''[null,false]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [null,false]
json: error: <stdin>:1:6:      ^
[null
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["null"]}]}'\'' <<< '\''[null,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["null"]}]}'\'' <<< '\''[null,true]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [null,true]
json: error: <stdin>:1:6:      ^
[null
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["null"]}]}'\'' <<< '\''[null,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["null"]}]}'\'' <<< '\''[null,456]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [null,456]
json: error: <stdin>:1:6:      ^
[null
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["null"]}]}'\'' <<< '\''[null,456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["null"]}]}'\'' <<< '\''[null,"bar"]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [null,"bar"]
json: error: <stdin>:1:6:      ^
[null
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["null"]}]}'\'' <<< '\''[null,"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["null"]}]}'\'' <<< '\''[null,{}]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [null,{}]
json: error: <stdin>:1:6:      ^
[null
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["null"]}]}'\'' <<< '\''[null,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["null"]}]}'\'' <<< '\''[null,[]]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [null,[]]
json: error: <stdin>:1:6:      ^
[null
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["null"]}]}'\'' <<< '\''[null,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["boolean"]}]}'\'' <<< '\''[false,null]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: [false,null]
json: error: <stdin>:1:7:       ^
[false
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["boolean"]}]}'\'' <<< '\''[false,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["boolean"]}]}'\'' <<< '\''[false,false]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: [false,false]
json: error: <stdin>:1:7:       ^
[false
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["boolean"]}]}'\'' <<< '\''[false,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["boolean"]}]}'\'' <<< '\''[false,true]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: [false,true]
json: error: <stdin>:1:7:       ^
[false
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["boolean"]}]}'\'' <<< '\''[false,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["boolean"]}]}'\'' <<< '\''[false,456]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: [false,456]
json: error: <stdin>:1:7:       ^
[false
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["boolean"]}]}'\'' <<< '\''[false,456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["boolean"]}]}'\'' <<< '\''[false,"bar"]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: [false,"bar"]
json: error: <stdin>:1:7:       ^
[false
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["boolean"]}]}'\'' <<< '\''[false,"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["boolean"]}]}'\'' <<< '\''[false,{}]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: [false,{}]
json: error: <stdin>:1:7:       ^
[false
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["boolean"]}]}'\'' <<< '\''[false,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["boolean"]}]}'\'' <<< '\''[false,[]]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: [false,[]]
json: error: <stdin>:1:7:       ^
[false
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["boolean"]}]}'\'' <<< '\''[false,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["number"]}]}'\'' <<< '\''[456,null]'\''
json: error: <stdin>:1:5: type check error: too many arguments
json: error: <stdin>:1:5: [456,null]
json: error: <stdin>:1:5:     ^
[456
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["number"]}]}'\'' <<< '\''[456,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["number"]}]}'\'' <<< '\''[456,false]'\''
json: error: <stdin>:1:5: type check error: too many arguments
json: error: <stdin>:1:5: [456,false]
json: error: <stdin>:1:5:     ^
[456
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["number"]}]}'\'' <<< '\''[456,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["number"]}]}'\'' <<< '\''[456,true]'\''
json: error: <stdin>:1:5: type check error: too many arguments
json: error: <stdin>:1:5: [456,true]
json: error: <stdin>:1:5:     ^
[456
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["number"]}]}'\'' <<< '\''[456,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["number"]}]}'\'' <<< '\''[456,456]'\''
json: error: <stdin>:1:5: type check error: too many arguments
json: error: <stdin>:1:5: [456,456]
json: error: <stdin>:1:5:     ^
[456
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["number"]}]}'\'' <<< '\''[456,456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["number"]}]}'\'' <<< '\''[456,"bar"]'\''
json: error: <stdin>:1:5: type check error: too many arguments
json: error: <stdin>:1:5: [456,"bar"]
json: error: <stdin>:1:5:     ^
[456
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["number"]}]}'\'' <<< '\''[456,"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["number"]}]}'\'' <<< '\''[456,{}]'\''
json: error: <stdin>:1:5: type check error: too many arguments
json: error: <stdin>:1:5: [456,{}]
json: error: <stdin>:1:5:     ^
[456
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["number"]}]}'\'' <<< '\''[456,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["number"]}]}'\'' <<< '\''[456,[]]'\''
json: error: <stdin>:1:5: type check error: too many arguments
json: error: <stdin>:1:5: [456,[]]
json: error: <stdin>:1:5:     ^
[456
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["number"]}]}'\'' <<< '\''[456,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["string"]}]}'\'' <<< '\''["bar",null]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: ["bar",null]
json: error: <stdin>:1:7:       ^
["bar"
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["string"]}]}'\'' <<< '\''["bar",null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["string"]}]}'\'' <<< '\''["bar",false]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: ["bar",false]
json: error: <stdin>:1:7:       ^
["bar"
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["string"]}]}'\'' <<< '\''["bar",false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["string"]}]}'\'' <<< '\''["bar",true]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: ["bar",true]
json: error: <stdin>:1:7:       ^
["bar"
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["string"]}]}'\'' <<< '\''["bar",true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["string"]}]}'\'' <<< '\''["bar",456]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: ["bar",456]
json: error: <stdin>:1:7:       ^
["bar"
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["string"]}]}'\'' <<< '\''["bar",456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["string"]}]}'\'' <<< '\''["bar","bar"]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: ["bar","bar"]
json: error: <stdin>:1:7:       ^
["bar"
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["string"]}]}'\'' <<< '\''["bar","bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["string"]}]}'\'' <<< '\''["bar",{}]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: ["bar",{}]
json: error: <stdin>:1:7:       ^
["bar"
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["string"]}]}'\'' <<< '\''["bar",{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["string"]}]}'\'' <<< '\''["bar",[]]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: ["bar",[]]
json: error: <stdin>:1:7:       ^
["bar"
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["string"]}]}'\'' <<< '\''["bar",[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["object"]}]}'\'' <<< '\''[{},null]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},null]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["object"]}]}'\'' <<< '\''[{},null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["object"]}]}'\'' <<< '\''[{},false]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},false]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["object"]}]}'\'' <<< '\''[{},false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["object"]}]}'\'' <<< '\''[{},true]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},true]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["object"]}]}'\'' <<< '\''[{},true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["object"]}]}'\'' <<< '\''[{},456]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},456]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["object"]}]}'\'' <<< '\''[{},456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["object"]}]}'\'' <<< '\''[{},"bar"]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},"bar"]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["object"]}]}'\'' <<< '\''[{},"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["object"]}]}'\'' <<< '\''[{},{}]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},{}]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["object"]}]}'\'' <<< '\''[{},{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["object"]}]}'\'' <<< '\''[{},[]]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},[]]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["object"]}]}'\'' <<< '\''[{},[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["array"]}]}'\'' <<< '\''[[],null]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],null]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["array"]}]}'\'' <<< '\''[[],null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["array"]}]}'\'' <<< '\''[[],false]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],false]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["array"]}]}'\'' <<< '\''[[],false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["array"]}]}'\'' <<< '\''[[],true]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],true]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["array"]}]}'\'' <<< '\''[[],true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["array"]}]}'\'' <<< '\''[[],456]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],456]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["array"]}]}'\'' <<< '\''[[],456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["array"]}]}'\'' <<< '\''[[],"bar"]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],"bar"]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["array"]}]}'\'' <<< '\''[[],"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["array"]}]}'\'' <<< '\''[[],{}]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],{}]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["array"]}]}'\'' <<< '\''[[],{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["array"]}]}'\'' <<< '\''[[],[]]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],[]]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["array"]}]}'\'' <<< '\''[[],[]]'\'''
) -L list-closed-array-empty-closed-array-basic-val-array-basic-basic.new <(
echo '$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'
export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes 2>&1 ||
echo 'command failed: export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["type"]}]}'\'' <<< '\''[[{}],null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["type"]}]}' <<< '[[{}],null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["type"]}]}'\'' <<< '\''[[{}],null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["type"]}]}'\'' <<< '\''[[{}],false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["type"]}]}' <<< '[[{}],false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["type"]}]}'\'' <<< '\''[[{}],false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["type"]}]}'\'' <<< '\''[[{}],true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["type"]}]}' <<< '[[{}],true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["type"]}]}'\'' <<< '\''[[{}],true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["type"]}]}'\'' <<< '\''[[{}],456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["type"]}]}' <<< '[[{}],456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["type"]}]}'\'' <<< '\''[[{}],456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["type"]}]}'\'' <<< '\''[[{}],"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["type"]}]}' <<< '[[{}],"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["type"]}]}'\'' <<< '\''[[{}],"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["type"]}]}'\'' <<< '\''[[{}],{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["type"]}]}' <<< '[[{}],{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["type"]}]}'\'' <<< '\''[[{}],{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["type"]}]}'\'' <<< '\''[[{}],[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["type"]}]}' <<< '[[{}],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["type"]}]}'\'' <<< '\''[[{}],[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["null"]}]}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["null"]}]}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["null"]}]}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["null"]}]}'\'' <<< '\''[null,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["null"]}]}' <<< '[null,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["null"]}]}'\'' <<< '\''[null,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["null"]}]}'\'' <<< '\''[null,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["null"]}]}' <<< '[null,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["null"]}]}'\'' <<< '\''[null,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["null"]}]}'\'' <<< '\''[null,456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["null"]}]}' <<< '[null,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["null"]}]}'\'' <<< '\''[null,456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["null"]}]}'\'' <<< '\''[null,"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["null"]}]}' <<< '[null,"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["null"]}]}'\'' <<< '\''[null,"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["null"]}]}'\'' <<< '\''[null,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["null"]}]}' <<< '[null,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["null"]}]}'\'' <<< '\''[null,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["null"]}]}'\'' <<< '\''[null,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["null"]}]}' <<< '[null,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["null"]}]}'\'' <<< '\''[null,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["boolean"]}]}'\'' <<< '\''[false,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["boolean"]}]}' <<< '[false,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["boolean"]}]}'\'' <<< '\''[false,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["boolean"]}]}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["boolean"]}]}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["boolean"]}]}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["boolean"]}]}'\'' <<< '\''[false,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["boolean"]}]}' <<< '[false,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["boolean"]}]}'\'' <<< '\''[false,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["boolean"]}]}'\'' <<< '\''[false,456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["boolean"]}]}' <<< '[false,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["boolean"]}]}'\'' <<< '\''[false,456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["boolean"]}]}'\'' <<< '\''[false,"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["boolean"]}]}' <<< '[false,"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["boolean"]}]}'\'' <<< '\''[false,"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["boolean"]}]}'\'' <<< '\''[false,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["boolean"]}]}' <<< '[false,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["boolean"]}]}'\'' <<< '\''[false,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["boolean"]}]}'\'' <<< '\''[false,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["boolean"]}]}' <<< '[false,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["boolean"]}]}'\'' <<< '\''[false,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["number"]}]}'\'' <<< '\''[456,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["number"]}]}' <<< '[456,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["number"]}]}'\'' <<< '\''[456,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["number"]}]}'\'' <<< '\''[456,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["number"]}]}' <<< '[456,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["number"]}]}'\'' <<< '\''[456,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["number"]}]}'\'' <<< '\''[456,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["number"]}]}' <<< '[456,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["number"]}]}'\'' <<< '\''[456,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["number"]}]}'\'' <<< '\''[456,456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["number"]}]}' <<< '[456,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["number"]}]}'\'' <<< '\''[456,456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["number"]}]}'\'' <<< '\''[456,"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["number"]}]}' <<< '[456,"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["number"]}]}'\'' <<< '\''[456,"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["number"]}]}'\'' <<< '\''[456,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["number"]}]}' <<< '[456,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["number"]}]}'\'' <<< '\''[456,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["number"]}]}'\'' <<< '\''[456,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["number"]}]}' <<< '[456,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["number"]}]}'\'' <<< '\''[456,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["string"]}]}'\'' <<< '\''["bar",null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["string"]}]}' <<< '["bar",null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["string"]}]}'\'' <<< '\''["bar",null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["string"]}]}'\'' <<< '\''["bar",false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["string"]}]}' <<< '["bar",false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["string"]}]}'\'' <<< '\''["bar",false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["string"]}]}'\'' <<< '\''["bar",true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["string"]}]}' <<< '["bar",true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["string"]}]}'\'' <<< '\''["bar",true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["string"]}]}'\'' <<< '\''["bar",456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["string"]}]}' <<< '["bar",456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["string"]}]}'\'' <<< '\''["bar",456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["string"]}]}'\'' <<< '\''["bar","bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["string"]}]}' <<< '["bar","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["string"]}]}'\'' <<< '\''["bar","bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["string"]}]}'\'' <<< '\''["bar",{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["string"]}]}' <<< '["bar",{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["string"]}]}'\'' <<< '\''["bar",{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["string"]}]}'\'' <<< '\''["bar",[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["string"]}]}' <<< '["bar",[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["string"]}]}'\'' <<< '\''["bar",[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["object"]}]}'\'' <<< '\''[{},null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["object"]}]}' <<< '[{},null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["object"]}]}'\'' <<< '\''[{},null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["object"]}]}'\'' <<< '\''[{},false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["object"]}]}' <<< '[{},false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["object"]}]}'\'' <<< '\''[{},false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["object"]}]}'\'' <<< '\''[{},true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["object"]}]}' <<< '[{},true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["object"]}]}'\'' <<< '\''[{},true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["object"]}]}'\'' <<< '\''[{},456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["object"]}]}' <<< '[{},456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["object"]}]}'\'' <<< '\''[{},456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["object"]}]}'\'' <<< '\''[{},"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["object"]}]}' <<< '[{},"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["object"]}]}'\'' <<< '\''[{},"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["object"]}]}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["object"]}]}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["object"]}]}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["object"]}]}'\'' <<< '\''[{},[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["object"]}]}' <<< '[{},[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["object"]}]}'\'' <<< '\''[{},[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["array"]}]}'\'' <<< '\''[[],null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["array"]}]}' <<< '[[],null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["array"]}]}'\'' <<< '\''[[],null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["array"]}]}'\'' <<< '\''[[],false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["array"]}]}' <<< '[[],false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["array"]}]}'\'' <<< '\''[[],false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["array"]}]}'\'' <<< '\''[[],true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["array"]}]}' <<< '[[],true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["array"]}]}'\'' <<< '\''[[],true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["array"]}]}'\'' <<< '\''[[],456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["array"]}]}' <<< '[[],456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["array"]}]}'\'' <<< '\''[[],456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["array"]}]}'\'' <<< '\''[[],"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["array"]}]}' <<< '[[],"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["array"]}]}'\'' <<< '\''[[],"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["array"]}]}'\'' <<< '\''[[],{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["array"]}]}' <<< '[[],{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["array"]}]}'\'' <<< '\''[[],{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["array"]}]}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["array"]}]}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":["array"]}]}'\'' <<< '\''[[],[]]'\'''
)

