#!/bin/bash

# Copyright (C) 2016, 2017  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -w30 -G parser
#

w=30
c=""
q=""

if [[ "$1" =~ ^-w[1-9][0-9]*$ ]]; then
    w="${1:2}"
    shift
fi
if [ "$1" == "-c" ]; then
    c="c"
    shift
fi
if [ "$1" == "-q" ]; then
    q="q"
fi

p=0
f=0

for t in \
    empty \
    char \
    literal \
    literal2 \
    literal3 \
    literal4 \
    literal5 \
    literal6 \
    string \
    string2 \
    string-plain \
    string-esc \
    string-esc2 \
    string-esc3 \
    string-esc4 \
    string-unicode \
    string-unicode2 \
    string-unicode3 \
    string-unicode4 \
    string-non-ascii \
    string-utf8 \
    string-utf8-2 \
    string-non-bmp-utf8 \
    string-non-bmp-utf8-2 \
    string-non-bmp-utf8-3 \
    string-surrogate-pairs \
    string-surrogate-pairs2 \
    string-surrogate-pairs3 \
    string3 \
    number \
    number2 \
    number3 \
    number4 \
    number5 \
    number6 \
    number7 \
    number8 \
    number9 \
    number10 \
    number11 \
    array \
    array2 \
    object \
    object2 \
    error-context \
    error-context2 \
    error-context3 \
    error-context4 \
    error-context5 \
    error-context6
do
    test -z "$q" &&
    printf >&2 "%-$((w + 6))s " "test: parser:$t"
    if ! parser/test-$t.sh &>/dev/null; then
        (( f ++ ))

        test -n "$q" &&
        echo >&2 -n "test: parser:$t "
        echo >&2 failed
    else
        (( p ++ ))

        test -z "$q" &&
        echo >&2 OK
    fi
done

if [ -z "$c" ]; then
    [ -z "$q" -o "$f" -gt 0 ] &&
    echo >&2
    echo "tests passed: $p"
    echo "tests failed: $f"
else
    echo "$p"
    echo "$f"
fi

exit $(( r != 0 ))

