#!/bin/bash

# Copyright (C) 2016, 2017  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C escape:utf8-12
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L utf8-12.old <(echo \
'$ json() { LD_LIBRARY_PATH=../lib ../src/json --validate-utf8 --escape-json --verbose "$@"; }
$ echo -ne '\''\xed\x9f\xbf'\''|json
\ud7ff
$ echo -ne '\''\xed\xa0\x80'\''|json
json: error: <stdin>:1:1: invalid utf-8 encoding
json: error: <stdin>:1:1: \xed\xa0\x80
json: error: <stdin>:1:1: ^
command failed: echo -ne '\''\xed\xa0\x80'\''|json
$ echo -ne '\''\xed\xbf\xbf'\''|json
json: error: <stdin>:1:1: invalid utf-8 encoding
json: error: <stdin>:1:1: \xed\xbf\xbf
json: error: <stdin>:1:1: ^
command failed: echo -ne '\''\xed\xbf\xbf'\''|json
$ echo -ne '\''\xee\x80\x80'\''|json
\ue000
$ echo -ne '\''\xf4\x8f\xbf\xbf'\''|json
json: error: <stdin>:1:1: non-BMP utf-8 encoding
json: error: <stdin>:1:1: \xf4\x8f\xbf\xbf
json: error: <stdin>:1:1: ^
command failed: echo -ne '\''\xf4\x8f\xbf\xbf'\''|json
$ echo -ne '\''\xf4\x90\x80\x80'\''|json
json: error: <stdin>:1:1: invalid utf-8 encoding
json: error: <stdin>:1:1: \xf4\x90\x80\x80
json: error: <stdin>:1:1: ^
command failed: echo -ne '\''\xf4\x90\x80\x80'\''|json
$ echo -ne '\''\xf7\xbf\xbf\xbf'\''|json
json: error: <stdin>:1:1: invalid utf-8 encoding
json: error: <stdin>:1:1: \xf7\xbf\xbf\xbf
json: error: <stdin>:1:1: ^
command failed: echo -ne '\''\xf7\xbf\xbf\xbf'\''|json'
) -L utf8-12.new <(
echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --validate-utf8 --escape-json --verbose "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --validate-utf8 --escape-json --verbose "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --validate-utf8 --escape-json --verbose "$@"; }'

echo '$ echo -ne '\''\xed\x9f\xbf'\''|json'
echo -ne '\xed\x9f\xbf'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xed\x9f\xbf'\''|json'

echo '$ echo -ne '\''\xed\xa0\x80'\''|json'
echo -ne '\xed\xa0\x80'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xed\xa0\x80'\''|json'

echo '$ echo -ne '\''\xed\xbf\xbf'\''|json'
echo -ne '\xed\xbf\xbf'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xed\xbf\xbf'\''|json'

echo '$ echo -ne '\''\xee\x80\x80'\''|json'
echo -ne '\xee\x80\x80'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xee\x80\x80'\''|json'

echo '$ echo -ne '\''\xf4\x8f\xbf\xbf'\''|json'
echo -ne '\xf4\x8f\xbf\xbf'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xf4\x8f\xbf\xbf'\''|json'

echo '$ echo -ne '\''\xf4\x90\x80\x80'\''|json'
echo -ne '\xf4\x90\x80\x80'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xf4\x90\x80\x80'\''|json'

echo '$ echo -ne '\''\xf7\xbf\xbf\xbf'\''|json'
echo -ne '\xf7\xbf\xbf\xbf'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xf7\xbf\xbf\xbf'\''|json'
)

