/*
 * Decompiled with CFR 0.152.
 */
package ch.fhnw.jbackpack;

import ch.fhnw.jbackpack.IconManager;
import ch.fhnw.util.ProcessExecutor;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JProgressBar;

public class ProgressDialog
extends JDialog {
    private final Window parent;
    private final ProcessExecutor processExecutor;
    private JButton cancelButton;
    private JLabel label;
    private JProgressBar progressBar;
    private JLabel specialIconLabel;

    public ProgressDialog(Window parent, ProcessExecutor processExecutor) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        this.parent = parent;
        this.processExecutor = processExecutor;
        this.initComponents();
        this.label.setIcon(IconManager.INFORMATION_ICON);
    }

    public void setIcon(Icon icon) {
        this.label.setIcon(icon);
    }

    public void setSpecialIcon(Icon icon) {
        this.specialIconLabel.setIcon(icon);
    }

    public void setCancelButtonVisible(boolean visible) {
        this.cancelButton.setVisible(visible);
        this.pack();
        this.setLocationRelativeTo(this.parent);
    }

    public void setMessage(String message) {
        this.label.setText(message);
        this.pack();
        this.setLocationRelativeTo(this.parent);
    }

    public void setIndeterminate(boolean indeterminate) {
        this.progressBar.setIndeterminate(indeterminate);
        this.progressBar.setStringPainted(!indeterminate);
        this.pack();
        this.setLocationRelativeTo(this.parent);
    }

    public void setProgress(int progress) {
        this.progressBar.setValue(progress);
        this.progressBar.setString(progress + "%");
    }

    private void initComponents() {
        this.label = new JLabel();
        this.specialIconLabel = new JLabel();
        this.progressBar = new JProgressBar();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(0);
        ResourceBundle bundle = ResourceBundle.getBundle("ch/fhnw/jbackpack/Strings");
        this.setTitle(bundle.getString("ProgressDialog.title"));
        this.getContentPane().setLayout(new GridBagLayout());
        this.label.setText(bundle.getString("Removing_Selected_Backups"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.getContentPane().add((Component)this.label, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.getContentPane().add((Component)this.specialIconLabel, gridBagConstraints);
        this.progressBar.setIndeterminate(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.getContentPane().add((Component)this.progressBar, gridBagConstraints);
        this.cancelButton.setText(bundle.getString("ProgressDialog.cancelButton.text"));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProgressDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.getContentPane().add((Component)this.cancelButton, gridBagConstraints);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.processExecutor.destroy();
        this.cancelButton.setEnabled(false);
    }
}

