/*
 * Decompiled with CFR 0.152.
 */
package ch.fhnw.jbackpack;

import ch.fhnw.jbackpack.BackupMainPanel;
import ch.fhnw.jbackpack.DirectoryCheckDialog;
import ch.fhnw.jbackpack.EncryptionSwingWorker;
import ch.fhnw.jbackpack.TooLongFilenamesDialog;
import ch.fhnw.util.FileTools;
import ch.fhnw.util.ModalDialogHandler;
import ch.fhnw.util.PlainDirChecker;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EncryptionCheckSwingWorker
extends SwingWorker<Object, Void> {
    private static final Logger LOGGER = Logger.getLogger(EncryptionCheckSwingWorker.class.getName());
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("ch/fhnw/jbackpack/Strings");
    private final Frame parentFrame;
    private final BackupMainPanel backupMainPanel;
    private final DirectoryCheckDialog dirCheckDialog;
    private final ModalDialogHandler dialogHandler;
    private final PlainDirChecker plainDirChecker;
    private final File destinationDirectory;
    private final File encfsCipherDirectory;
    private final File encfsPlainDirectory;
    private final String password;
    private boolean spaceKnown;
    private long usableSpace;
    private long size;
    private boolean enoughSpaceAvailable;

    public EncryptionCheckSwingWorker(Frame parentFrame, BackupMainPanel backupMainPanel, DirectoryCheckDialog dirCheckDialog, ModalDialogHandler dialogHandler, File destinationDirectory, File encfsCipherDirectory, File encfsPlainDirectory, String password, int maxFilenameLength) {
        this.parentFrame = parentFrame;
        this.backupMainPanel = backupMainPanel;
        this.dirCheckDialog = dirCheckDialog;
        this.dialogHandler = dialogHandler;
        this.destinationDirectory = destinationDirectory;
        this.encfsCipherDirectory = encfsCipherDirectory;
        this.encfsPlainDirectory = encfsPlainDirectory;
        this.password = password;
        this.plainDirChecker = new PlainDirChecker(maxFilenameLength);
    }

    public void setUsableSpace(long usableSpace) {
        this.spaceKnown = true;
        this.usableSpace = usableSpace * 95L / 100L;
    }

    @Override
    protected Object doInBackground() {
        Thread checkThread = new Thread(){

            public void run() {
                try {
                    EncryptionCheckSwingWorker.this.plainDirChecker.check(EncryptionCheckSwingWorker.this.destinationDirectory);
                }
                catch (IOException ex) {
                    LOGGER.log(Level.SEVERE, null, ex);
                }
            }
        };
        checkThread.start();
        this.enoughSpaceAvailable = true;
        while (checkThread.isAlive()) {
            if (!this.update(this.plainDirChecker)) {
                this.enoughSpaceAvailable = false;
                break;
            }
            try {
                checkThread.join(300L);
            }
            catch (InterruptedException ex) {
                LOGGER.log(Level.SEVERE, null, ex);
            }
        }
        if (!this.update(this.plainDirChecker)) {
            this.enoughSpaceAvailable = false;
        }
        return this.enoughSpaceAvailable;
    }

    @Override
    protected void process(List<Void> chunks) {
        this.dirCheckDialog.setFileCount(this.plainDirChecker.getFileCounter());
        this.dirCheckDialog.setCurrentFile(this.plainDirChecker.getCurrentFile().getPath());
        this.dirCheckDialog.setCurrentSize(this.size);
        this.dirCheckDialog.setFilenameCheckstatus(this.plainDirChecker.getTooLongFiles().isEmpty());
    }

    @Override
    protected void done() {
        List<File> tooLongFiles;
        this.dialogHandler.hide();
        if (this.spaceKnown) {
            if (!this.enoughSpaceAvailable) {
                JOptionPane.showMessageDialog(this.parentFrame, BUNDLE.getString("Error_No_Space_For_Encryption"), BUNDLE.getString("Error"), 0);
                this.cleanup();
                return;
            }
        } else {
            String message = BUNDLE.getString("Warning_Unknown_Space");
            String sizeString = FileTools.getDataVolumeString(this.size, 1);
            int returnValue = JOptionPane.showOptionDialog(this.parentFrame, message = MessageFormat.format(message, sizeString), BUNDLE.getString("Warning"), 2, 2, null, null, null);
            if (returnValue != 0) {
                this.cleanup();
                return;
            }
        }
        if (!(tooLongFiles = this.plainDirChecker.getTooLongFiles()).isEmpty()) {
            TooLongFilenamesDialog tooLongFilenamesDialog = new TooLongFilenamesDialog(this.parentFrame, tooLongFiles);
            tooLongFilenamesDialog.setVisible(true);
            this.cleanup();
            return;
        }
        EncryptionSwingWorker encryptionSwingWorker = new EncryptionSwingWorker(this.parentFrame, this.backupMainPanel, this.destinationDirectory.getPath(), this.encfsPlainDirectory, this.encfsCipherDirectory.getPath(), this.password);
        encryptionSwingWorker.execute();
    }

    private boolean update(PlainDirChecker plainDirChecker) {
        this.size = plainDirChecker.getCurrentSize();
        if (!this.spaceKnown || this.size < this.usableSpace) {
            this.publish(new Void[0]);
            return true;
        }
        plainDirChecker.stop();
        return false;
    }

    private void cleanup() {
        FileTools.umountFUSE(this.encfsPlainDirectory, true);
        try {
            FileTools.recursiveDelete(this.encfsCipherDirectory, true);
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
    }
}

