/*
 * Decompiled with CFR 0.152.
 */
package ch.fhnw.jbackpack;

import ch.fhnw.jbackpack.IconManager;
import ch.fhnw.jbackpack.ProgressDialog;
import ch.fhnw.util.ModalDialogHandler;
import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingWorker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadSwingWorker
extends SwingWorker<Boolean, Integer> {
    private static final Logger LOGGER = Logger.getLogger(DownloadSwingWorker.class.getName());
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("ch/fhnw/jbackpack/Strings");
    private final URL url;
    private final File destination;
    private final ProgressDialog progressDialog;
    private final ModalDialogHandler dialogHandler;
    private IOException ioException;

    public DownloadSwingWorker(Frame parentFrame, URL url, String description, File destination) {
        this.url = url;
        this.destination = destination;
        this.progressDialog = new ProgressDialog((Window)parentFrame, null);
        this.progressDialog.setIcon(IconManager.INFORMATION_ICON);
        String message = BUNDLE.getString("Downloading");
        message = MessageFormat.format(message, description);
        this.progressDialog.setMessage(message);
        this.progressDialog.setSpecialIcon(null);
        this.progressDialog.setIndeterminate(false);
        this.progressDialog.setCancelButtonVisible(false);
        this.dialogHandler = new ModalDialogHandler(this.progressDialog);
        this.dialogHandler.show();
    }

    public IOException getIoException() {
        return this.ioException;
    }

    @Override
    protected Boolean doInBackground() {
        try {
            URLConnection connection = this.url.openConnection();
            int contentLength = connection.getContentLength();
            LOGGER.log(Level.INFO, "contentLength: {0}", contentLength);
            InputStream inputStream = this.url.openStream();
            FileOutputStream fileOutputStream = new FileOutputStream(this.destination);
            byte[] buffer = new byte[1024];
            long downloadCounter = 0L;
            int count = inputStream.read(buffer);
            while (count != -1) {
                fileOutputStream.write(buffer, 0, count);
                int progress = (int)((downloadCounter += (long)count) * 100L / (long)contentLength);
                this.publish(progress);
                count = inputStream.read(buffer);
            }
            inputStream.close();
            fileOutputStream.close();
            LOGGER.log(Level.INFO, "downloading finished");
            return true;
        }
        catch (IOException ex) {
            this.ioException = ex;
            LOGGER.log(Level.SEVERE, null, ex);
            return false;
        }
    }

    @Override
    protected void process(List<Integer> chunks) {
        this.progressDialog.setProgress(chunks.get(0));
    }

    @Override
    protected void done() {
        this.dialogHandler.hide();
    }
}

