/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler 
*/
/*
Copyright (c) 2015, iwrite authors
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#ifndef __ruler_wrap_h__

#include "global_common.h"
#include "paper.h"
#include "ruler.h"

struct ruler_top
{
  GtkBox*                               m_box;
  GtkFrame*                             m_frame_left;
  Ruler*                                m_ruler;
  GtkFrame*                             m_frame_right;
};

struct ruler_left
{
  GtkBox*                               m_box;
  GtkFrame*                             m_frame_top;
  Ruler*                                m_ruler;
  GtkFrame*                             m_frame_bottom;
};

struct ruler
{
  struct ruler_top                      m_top;
  struct ruler_left                     m_left;
};

extern void
ruler_wrap_add_track_widget(
  GtkWidget*                            io_widget);

extern void
ruler_wrap_adjust_allocate(
  double const                          i_pos_x,
  double const                          i_pos_y);

extern void
ruler_wrap_adjust_paper(
  GtkPageSetup const*const              i_page_setup);

extern void
ruler_wrap_assign(
  struct ruler*const                    o_ruler);

extern void
ruler_wrap_discharge(
  struct ruler*const                    io_ruler);

extern void
ruler_wrap_create(
  struct ruler*const                    io_ruler,
  GtkBuilder*const                      i_builder);

extern void
ruler_wrap_remove_track_widget(
  GtkWidget*                            i_widget);

extern void
ruler_wrap_reset();

extern void
ruler_wrap_set_hscroll(
  gdouble                               i_pos_x);

extern void
ruler_wrap_set_scale(
  gdouble const                         i_scale);

extern void
ruler_wrap_set_visible(
  gboolean                              i_visible);

extern void
ruler_wrap_set_vscroll(
  gdouble                               i_pos_y);

#define  __ruler_wrap_h__
#endif
