/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
/*
Copyright (c) 2015-2016, iwrite authors
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#ifndef __paper_h__

#include "global_common.h"
#include "item_common.h"

#define PAPER_DEFAULT_WIDTH             8.50
#define PAPER_DEFAULT_HEIGHT            11.0
#define PAPER_DEFAULT_MARGIN            0.25

struct paper
{
  gdouble                               m_width;
  gdouble                               m_height;
  gdouble                               m_margin_top;
  gdouble                               m_margin_bottom;
  gdouble                               m_margin_left;
  gdouble                               m_margin_right;
};

extern void
paper_assign(
  struct paper*const                    o_paper);

extern void
paper_convert_to_inches(
  struct paper*const                    io_paper);

extern void
paper_convert_to_points(
  struct paper*const                    io_paper);

extern void
paper_discharge(
  struct paper*const                    io_paper);

extern int
paper_read(
  GError**                              o_error,
  struct paper*const                    io_paper,
  struct xml *const                     i_xml);

extern void
paper_set_from_page_setup(
  struct paper*const                    o_paper,
  GtkPageSetup const*const              i_page_setup);

extern void
paper_set_from_page_setup_pt(
  struct paper*const                    o_paper,
  GtkPageSetup const*const              i_page_setup);

extern int
paper_write(
  GError**                              o_error,
  FILE*const                            io_fp,
  struct paper const*const              i_paper);

#define __paper_h__
#endif
